/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassFieldExistsGetQuery;
import org.anarres.jdiagnostics.ClassMethodExistsCallQuery;
import org.anarres.jdiagnostics.JarQuery;
import org.anarres.jdiagnostics.Result;

public class XalanQuery
extends AbstractQuery {
    private static final String XALAN_JARNAME = "xalan.jar";
    private static final String XMLAPIS_JARNAME = "xml-apis.jar";
    private static final String XALAN1_VERSION_CLASS = "org.apache.xalan.xslt.XSLProcessorVersion";
    private static final String XALAN2_VERSION_CLASS = "org.apache.xalan.processor.XSLProcessorVersion";
    private static final String XALAN2_2_VERSION_CLASS = "org.apache.xalan.Version";
    private static final String XALAN2_2_VERSION_METHOD = "getVersion";

    public String getName() {
        return "xalan";
    }

    public void call(Result result, String prefix) {
        new JarQuery(XALAN_JARNAME).call(result, prefix + "xalanJar/");
        new JarQuery(XMLAPIS_JARNAME).call(result, prefix + "xmlApisJar/");
        for (String packagePrefix : new String[]{"org.apache.xalan.", "com.sun.org.apache.xalan.internal."}) {
            new ClassFieldExistsGetQuery(null, packagePrefix + "xslt.XSLProcessorVersion", "PRODUCT", "VERSION", "S_VERSION").call(result, prefix + packagePrefix + "xalan1/");
            new ClassFieldExistsGetQuery(null, packagePrefix + "processor.XSLProcessorVersion", "S_VERSION", new String[0]).call(result, prefix + packagePrefix + "xalan2/");
            new ClassMethodExistsCallQuery(null, packagePrefix + "Version", XALAN2_2_VERSION_METHOD).call(result, prefix + packagePrefix + "xalan2.2/");
        }
    }
}

