/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.util.Map;
import java.util.Properties;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

public class SystemPropertiesQuery
extends AbstractQuery {
    private final String prefix;

    public SystemPropertiesQuery(String prefix) {
        this.prefix = prefix;
    }

    public SystemPropertiesQuery() {
        this("");
    }

    public String getName() {
        return "systemProperties";
    }

    public void call(Result result, String prefix) {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = String.valueOf(e.getKey());
            if (!key.startsWith(this.prefix)) continue;
            result.put(prefix + key, e.getValue());
        }
    }
}

