/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ResourceQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassQuery
extends AbstractQuery {
    private final Class<?> type;

    public ClassQuery(Class<?> type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return "class/" + this.type.getName();
    }

    public static String toResource(Class<?> type) {
        String name = type.getName();
        name = name.replace('.', '/');
        return name + ".class";
    }

    @Override
    public void call(Result result, String prefix) {
        result.put(prefix + "className", this.type.getName());
        result.put(prefix + "class.classLoader", this.type.getClassLoader());
        ProtectionDomain pd = this.type.getProtectionDomain();
        if (pd == null) {
            result.put(prefix + "codesource", "(no ProtectionDomain)");
        } else {
            CodeSource cs = pd.getCodeSource();
            if (cs == null) {
                result.put(prefix + "codesource", "(no CodeSource)");
            } else {
                result.put(prefix + "codesource", cs.getLocation());
            }
        }
        String resourceName = ClassQuery.toResource(this.type);
        new ResourceQuery(resourceName).call(result, prefix);
    }
}

