/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.MethodExistsQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodExistsQuery
extends ClassExistsQuery {
    public final String methodName;
    private final Class<?>[] parameterTypes;

    public ClassMethodExistsQuery(String className, String methodName, Class<?> ... parameterTypes) {
        super(className);
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public String getName() {
        return "classMethodExists/" + this.className + "/" + this.methodName + " " + Arrays.toString(this.parameterTypes);
    }

    public Method findMethod(Result result, String prefix) {
        Class<?> type = this.findClass(result, prefix + "class/");
        if (type == null) {
            return null;
        }
        return new MethodExistsQuery(type, this.methodName, this.parameterTypes).findMethod(result, prefix + "method/" + this.methodName + "/");
    }

    @Override
    public void call(Result result, String prefix) {
        Method method = this.findMethod(result, prefix);
        result.put(prefix + "exists", method != null);
    }
}

