/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.goodies.packageurl.MoreStrings;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.PackageUrlParser;
import org.sonatype.goodies.packageurl.PackageUrlValidator;

public class PackageUrlBuilder {
    private String type;
    private List<String> namespace;
    private String name;
    private String version;
    private Map<String, String> qualifiers;
    private List<String> subpath;

    public PackageUrlBuilder from(PackageUrl purl) {
        Preconditions.checkNotNull((Object)purl);
        this.type = purl.getType();
        if (purl.getNamespace() != null) {
            this.namespace = new ArrayList<String>(purl.getNamespace());
        }
        this.name = purl.getName();
        this.version = purl.getVersion();
        if (purl.getQualifiers() != null) {
            this.qualifiers = new LinkedHashMap<String, String>(purl.getQualifiers());
        }
        if (purl.getSubpath() != null) {
            this.subpath = new ArrayList<String>(purl.getSubpath());
        }
        return this;
    }

    public PackageUrlBuilder type(String type) {
        this.type = type;
        return this;
    }

    public PackageUrlBuilder namespace(List<String> namespace) {
        this.namespace = namespace;
        return this;
    }

    public PackageUrlBuilder namespace(String namespace) {
        return this.namespace(PackageUrlParser.parseNamespace(namespace));
    }

    public PackageUrlBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PackageUrlBuilder version(String version) {
        this.version = version;
        return this;
    }

    private Map<String, String> getQualifiers() {
        if (this.qualifiers == null) {
            this.qualifiers = new LinkedHashMap<String, String>();
        }
        return this.qualifiers;
    }

    public PackageUrlBuilder qualifiers(Map<String, String> qualifiers) {
        if (qualifiers != null) {
            this.getQualifiers().putAll(qualifiers);
        } else {
            this.qualifiers = null;
        }
        return this;
    }

    public PackageUrlBuilder qualifiers(String qualifiers) {
        return this.qualifiers(PackageUrlParser.parseQualifiers(qualifiers));
    }

    public PackageUrlBuilder qualifier(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        this.getQualifiers().put(key, value);
        return this;
    }

    public PackageUrlBuilder subpath(List<String> subpath) {
        this.subpath = subpath;
        return this;
    }

    public PackageUrlBuilder subpath(String subpath) {
        return this.subpath(PackageUrlParser.parseSubpath(subpath));
    }

    public PackageUrl build() {
        return this.buildAndValidate(true);
    }

    PackageUrl buildAndValidate(boolean validate) {
        if (validate) {
            PackageUrlValidator.validateType(this.type);
            PackageUrlValidator.validateNamespace(this.namespace);
            PackageUrlValidator.validateName(this.name);
            PackageUrlValidator.validateVersion(this.version);
            PackageUrlValidator.validateQualifiers(this.qualifiers);
            PackageUrlValidator.validateSubpath(this.subpath);
        }
        switch (this.type) {
            case "github": 
            case "bitbucket": {
                this.name = MoreStrings.lowerCase(this.name);
                this.namespace = MoreStrings.lowerCase(this.namespace);
                break;
            }
            case "pypi": {
                this.name = this.name.replace('_', '-');
                this.name = MoreStrings.lowerCase(this.name);
            }
        }
        return new PackageUrl(this.type, this.namespace, this.name, this.version, this.qualifiers, this.subpath);
    }
}

