/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.foreign.ForeignExecutableBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.foreign.ForeignExecutableBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ForeignExecutable})
public final class ForeignExecutableBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ForeignExecutableBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignExecutableBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doInteropCall(VirtualFrame frame, Object callee, Object[] arguments, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(limit="4") InteropLibrary lib, @Cached PForeignToPTypeNode toPTypeNode, @Cached GilNode gil, @Cached PRaiseNode raiseNode) {
            Object object;
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = context.getLanguage(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            gil.release(true);
            try {
                object = toPTypeNode.executeConvert(lib.execute(callee, arguments));
                gil.acquire();
            }
            catch (Throwable throwable) {
                try {
                    gil.acquire();
                    ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
                    throw throwable;
                }
                catch (ArityException | UnsupportedTypeException e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_INSTANTIATION_OF_FOREIGN_OBJ);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            return object;
        }
    }

    @Builtin(name="__doc__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class DocNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getName(Object self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached PForeignToPTypeNode toPythonNode, @CachedLibrary(limit="2") InteropLibrary lib) {
            if (lib.isMemberReadable(self, "__doc__")) {
                try {
                    return toPythonNode.executeConvert(lib.readMember(self, "__doc__"));
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class NameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getName(Object self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached PForeignToPTypeNode toPythonNode, @CachedLibrary(limit="2") InteropLibrary lib) {
            try {
                if (lib.isMemberReadable(self, "__name__")) {
                    return toPythonNode.executeConvert(lib.readMember(self, "__name__"));
                }
                if (lib.hasExecutableName(self)) {
                    return toPythonNode.executeConvert(lib.getExecutableName(self));
                }
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, self, SpecialAttributeNames.T___NAME__);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }
}

