/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoCollection;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.azure.core.models.GeoPosition;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class GeoJsonDeserializer
extends JsonDeserializer<GeoObject> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoJsonDeserializer.class);
    static final String TYPE_PROPERTY = "type";
    static final String GEOMETRIES_PROPERTY = "geometries";
    static final String COORDINATES_PROPERTY = "coordinates";
    static final String BOUNDING_BOX_PROPERTY = "bbox";
    static final SimpleModule MODULE = new SimpleModule().addDeserializer(GeoObject.class, (JsonDeserializer)new GeoJsonDeserializer()).addDeserializer(GeoPoint.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPoint.class)).addDeserializer(GeoLineString.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoLineString.class)).addDeserializer(GeoPolygon.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPolygon.class)).addDeserializer(GeoPointCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPointCollection.class)).addDeserializer(GeoLineStringCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoLineStringCollection.class)).addDeserializer(GeoPolygonCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPolygonCollection.class)).addDeserializer(GeoCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoCollection.class));

    GeoJsonDeserializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    public GeoObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return GeoJsonDeserializer.read(ctxt.readTree(p));
    }

    private static GeoObject read(JsonNode node) {
        String type = GeoJsonDeserializer.getRequiredProperty(node, TYPE_PROPERTY).asText();
        if (GeoJsonDeserializer.isGeoObjectType(type, GeoObjectType.GEOMETRY_COLLECTION)) {
            ArrayList<GeoObject> geometries = new ArrayList<GeoObject>();
            for (JsonNode geoNode : GeoJsonDeserializer.getRequiredProperty(node, GEOMETRIES_PROPERTY)) {
                geometries.add(GeoJsonDeserializer.read(geoNode));
            }
            return new GeoCollection(geometries, GeoJsonDeserializer.readBoundingBox(node), GeoJsonDeserializer.readProperties(node, GEOMETRIES_PROPERTY));
        }
        JsonNode coordinates = GeoJsonDeserializer.getRequiredProperty(node, COORDINATES_PROPERTY);
        GeoBoundingBox boundingBox = GeoJsonDeserializer.readBoundingBox(node);
        Map<String, Object> properties = GeoJsonDeserializer.readProperties(node);
        if (GeoJsonDeserializer.isGeoObjectType(type, GeoObjectType.POINT)) {
            return new GeoPoint(GeoJsonDeserializer.readCoordinate(coordinates), boundingBox, properties);
        }
        if (GeoJsonDeserializer.isGeoObjectType(type, GeoObjectType.LINE_STRING)) {
            return new GeoLineString(GeoJsonDeserializer.readCoordinates(coordinates), boundingBox, properties);
        }
        if (GeoJsonDeserializer.isGeoObjectType(type, GeoObjectType.POLYGON)) {
            ArrayList<GeoLinearRing> rings = new ArrayList<GeoLinearRing>();
            coordinates.forEach(ring -> rings.add(new GeoLinearRing(GeoJsonDeserializer.readCoordinates(ring))));
            return new GeoPolygon(rings, boundingBox, properties);
        }
        if (GeoJsonDeserializer.isGeoObjectType(type, GeoObjectType.MULTI_POINT)) {
            ArrayList<GeoPoint> points = new ArrayList<GeoPoint>();
            GeoJsonDeserializer.readCoordinates(coordinates).forEach(position -> points.add(new GeoPoint((GeoPosition)position)));
            return new GeoPointCollection(points, boundingBox, properties);
        }
        if (GeoJsonDeserializer.isGeoObjectType(type, GeoObjectType.MULTI_LINE_STRING)) {
            ArrayList<GeoLineString> lines = new ArrayList<GeoLineString>();
            coordinates.forEach(line -> lines.add(new GeoLineString(GeoJsonDeserializer.readCoordinates(line))));
            return new GeoLineStringCollection(lines, boundingBox, properties);
        }
        if (GeoJsonDeserializer.isGeoObjectType(type, GeoObjectType.MULTI_POLYGON)) {
            return GeoJsonDeserializer.readMultiPolygon(coordinates, boundingBox, properties);
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("Unsupported geo type %s.", type)));
    }

    private static boolean isGeoObjectType(String jsonType, GeoObjectType type) {
        return type.toString().equalsIgnoreCase(jsonType);
    }

    private static GeoPolygonCollection readMultiPolygon(JsonNode node, GeoBoundingBox boundingBox, Map<String, Object> properties) {
        ArrayList<GeoPolygon> polygons = new ArrayList<GeoPolygon>();
        for (JsonNode polygon : node) {
            ArrayList<GeoLinearRing> rings = new ArrayList<GeoLinearRing>();
            polygon.forEach(ring -> rings.add(new GeoLinearRing(GeoJsonDeserializer.readCoordinates(ring))));
            polygons.add(new GeoPolygon(rings));
        }
        return new GeoPolygonCollection(polygons, boundingBox, properties);
    }

    private static JsonNode getRequiredProperty(JsonNode node, String name) {
        JsonNode requiredNode = node.get(name);
        if (requiredNode == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("GeoJSON object expected to have '%s' property.", name)));
        }
        return requiredNode;
    }

    private static GeoBoundingBox readBoundingBox(JsonNode node) {
        JsonNode boundingBoxNode = node.get(BOUNDING_BOX_PROPERTY);
        if (boundingBoxNode != null) {
            switch (boundingBoxNode.size()) {
                case 4: {
                    return new GeoBoundingBox(boundingBoxNode.get(0).asDouble(), boundingBoxNode.get(1).asDouble(), boundingBoxNode.get(2).asDouble(), boundingBoxNode.get(3).asDouble());
                }
                case 6: {
                    return new GeoBoundingBox(boundingBoxNode.get(0).asDouble(), boundingBoxNode.get(1).asDouble(), boundingBoxNode.get(3).asDouble(), boundingBoxNode.get(4).asDouble(), boundingBoxNode.get(2).asDouble(), boundingBoxNode.get(5).asDouble());
                }
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 dimension bounding boxes are supported."));
        }
        return null;
    }

    private static Map<String, Object> readProperties(JsonNode node) {
        return GeoJsonDeserializer.readProperties(node, COORDINATES_PROPERTY);
    }

    private static Map<String, Object> readProperties(JsonNode node, String knownProperty) {
        HashMap<String, Object> additionalProperties = null;
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            String propertyName = (String)field.getKey();
            if (propertyName.equalsIgnoreCase(TYPE_PROPERTY) || propertyName.equalsIgnoreCase(BOUNDING_BOX_PROPERTY) || propertyName.equalsIgnoreCase(knownProperty)) continue;
            if (additionalProperties == null) {
                additionalProperties = new HashMap<String, Object>();
            }
            additionalProperties.put(propertyName, GeoJsonDeserializer.readAdditionalPropertyValue((JsonNode)field.getValue()));
        }
        return additionalProperties;
    }

    private static Object readAdditionalPropertyValue(JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return node.asText();
            }
            case NUMBER: {
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                if (node.isFloat()) {
                    return Float.valueOf(node.floatValue());
                }
                return node.asDouble();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NULL: 
            case MISSING: {
                return null;
            }
            case OBJECT: {
                HashMap object = new HashMap();
                node.fields().forEachRemaining(field -> object.put((String)field.getKey(), GeoJsonDeserializer.readAdditionalPropertyValue((JsonNode)field.getValue())));
                return object;
            }
            case ARRAY: {
                ArrayList array = new ArrayList();
                node.forEach(element -> array.add(GeoJsonDeserializer.readAdditionalPropertyValue(element)));
                return array;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("Unsupported additional property type %s.", node.getNodeType())));
    }

    private static List<GeoPosition> readCoordinates(JsonNode coordinates) {
        ArrayList<GeoPosition> positions = new ArrayList<GeoPosition>();
        coordinates.forEach(coordinate -> positions.add(GeoJsonDeserializer.readCoordinate(coordinate)));
        return positions;
    }

    private static GeoPosition readCoordinate(JsonNode coordinate) {
        int coordinateCount = coordinate.size();
        if (coordinateCount < 2 || coordinateCount > 3) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 element coordinates supported."));
        }
        double longitude = coordinate.get(0).asDouble();
        double latitude = coordinate.get(1).asDouble();
        Double altitude = null;
        if (coordinateCount > 2) {
            altitude = coordinate.get(2).asDouble();
        }
        return new GeoPosition(longitude, latitude, altitude);
    }

    private static <T extends GeoObject> JsonDeserializer<T> geoSubclassDeserializer(final Class<T> subclass) {
        return new JsonDeserializer<T>(){

            public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return (GeoObject)subclass.cast(GeoJsonDeserializer.read(ctxt.readTree(p)));
            }
        };
    }
}

