/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SourcePosition;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/SMAPParser;", "", "<init>", "()V", "parseOrNull", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "mappingInfo", "", "parseStratum", "stratum", "callSites", "SMAPTokenizer", "backend.common.jvm"})
@SourceDebugExtension(value={"SMAP\nSMAPParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMAPParser.kt\norg/jetbrains/kotlin/codegen/inline/SMAPParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class SMAPParser {
    @NotNull
    public static final SMAPParser INSTANCE = new SMAPParser();

    private SMAPParser() {
    }

    @Nullable
    public final SMAP parseOrNull(@NotNull String mappingInfo) {
        Intrinsics.checkNotNullParameter(mappingInfo, "mappingInfo");
        return ((CharSequence)mappingInfo).length() > 0 ? this.parseStratum(mappingInfo, "Kotlin", this.parseStratum(mappingInfo, "KotlinDebug", null)) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final SMAP parseStratum(String mappingInfo, String stratum, SMAP callSites) {
        String line;
        LinkedHashMap fileMappings = new LinkedHashMap();
        SMAPTokenizer iterator2 = new SMAPTokenizer(mappingInfo, "*S " + stratum);
        if (!iterator2.hasNext() || !Intrinsics.areEqual(iterator2.next(), "*F")) {
            return null;
        }
        SMAPTokenizer sMAPTokenizer = iterator2;
        while (((Iterator)sMAPTokenizer).hasNext()) {
            String string;
            line = sMAPTokenizer.next();
            if (Intrinsics.areEqual(line, "*L")) break;
            if (Intrinsics.areEqual(line, "*F") || Intrinsics.areEqual(line, "*E") || StringsKt.startsWith$default(line, "*S", false, 2, null)) {
                return null;
            }
            if (StringsKt.startsWith$default(line, "+ ", false, 2, null)) {
                String string2 = line.substring(2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            } else {
                string = line;
            }
            String indexAndFileInternalName = string;
            int fileIndex = Integer.parseInt(StringsKt.substringBefore$default(indexAndFileInternalName, ' ', null, 2, null));
            String fileName = StringsKt.substringAfter$default(indexAndFileInternalName, ' ', null, 2, null);
            String path = StringsKt.startsWith$default(line, "+ ", false, 2, null) ? iterator2.next() : fileName;
            ((Map)fileMappings).put(fileIndex, new FileMapping(fileName, path));
        }
        sMAPTokenizer = iterator2;
        while (((Iterator)sMAPTokenizer).hasNext()) {
            SourcePosition sourcePosition;
            FileMapping file;
            int n2;
            line = sMAPTokenizer.next();
            if (Intrinsics.areEqual(line, "*L") || Intrinsics.areEqual(line, "*F")) {
                return null;
            }
            if (Intrinsics.areEqual(line, "*E") || StringsKt.startsWith$default(line, "*S", false, 2, null)) break;
            int fileSeparator = StringsKt.indexOf$default((CharSequence)line, '#', 0, false, 6, null);
            if (fileSeparator < 0) {
                return null;
            }
            int destSeparator = StringsKt.indexOf$default((CharSequence)line, ':', fileSeparator, false, 4, null);
            if (destSeparator < 0) {
                return null;
            }
            int it = StringsKt.indexOf$default((CharSequence)line, ',', 0, false, 6, null);
            boolean bl = false;
            boolean bl2 = fileSeparator <= it ? it <= destSeparator : false;
            int sourceRangeSeparator = !bl2 ? destSeparator : it;
            int it2 = StringsKt.indexOf$default((CharSequence)line, ',', destSeparator, false, 4, null);
            boolean bl3 = false;
            int destMultiplierSeparator = it2 < 0 ? line.length() : it2;
            String string = line.substring(fileSeparator + 1, sourceRangeSeparator);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            if ((FileMapping)fileMappings.get(Integer.parseInt(string)) == null) {
                return null;
            }
            String string3 = line.substring(0, fileSeparator);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            int source = Integer.parseInt(string3);
            String string4 = line.substring(destSeparator + 1, destMultiplierSeparator);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            int dest = Integer.parseInt(string4);
            if (destMultiplierSeparator != line.length()) {
                String string5 = line.substring(destMultiplierSeparator + 1);
                Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                n2 = Integer.parseInt(string5);
            } else if (sourceRangeSeparator != destSeparator) {
                String string6 = line.substring(sourceRangeSeparator + 1, destSeparator);
                Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                n2 = Integer.parseInt(string6);
            } else {
                n2 = 1;
            }
            int range = n2;
            FileMapping fileMapping = file;
            int n3 = source;
            int n4 = dest;
            int n5 = range;
            Object object = callSites;
            if (object != null && (object = ((SMAP)object).findRange(dest)) != null) {
                void it3;
                Object object2 = object;
                int n6 = n5;
                int n7 = n4;
                int n8 = n3;
                FileMapping fileMapping2 = fileMapping;
                boolean bl4 = false;
                SourcePosition sourcePosition2 = it3.mapDestToSource(it3.getDest());
                fileMapping = fileMapping2;
                n3 = n8;
                n4 = n7;
                n5 = n6;
                sourcePosition = sourcePosition2;
            } else {
                sourcePosition = null;
            }
            fileMapping.mapNewInterval(n3, n4, n5, sourcePosition);
        }
        Collection collection = fileMappings.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return new SMAP(CollectionsKt.toList(collection));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u00020\rH\u0096\u0082\u0004J\n\u0010\u000e\u001a\u00020\u0002H\u0096\u0082\u0004R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/SMAPParser$SMAPTokenizer;", "", "", "text", "headerString", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "pos", "", "currentLine", "advance", "", "hasNext", "", "next", "backend.common.jvm"})
    private static final class SMAPTokenizer
    implements Iterator<String>,
    KMappedMarker {
        @NotNull
        private final String text;
        @NotNull
        private final String headerString;
        private int pos;
        @Nullable
        private String currentLine;

        public SMAPTokenizer(@NotNull String text, @NotNull String headerString) {
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(headerString, "headerString");
            this.text = text;
            this.headerString = headerString;
            this.advance();
            while (this.currentLine != null && !Intrinsics.areEqual(this.currentLine, this.headerString)) {
                this.advance();
            }
            if (Intrinsics.areEqual(this.currentLine, this.headerString)) {
                this.advance();
            }
        }

        private final void advance() {
            int n2;
            if (this.pos >= this.text.length()) {
                this.currentLine = null;
                return;
            }
            int fromPos = this.pos;
            while (this.pos < this.text.length() && this.text.charAt(this.pos) != '\n' && this.text.charAt(this.pos) != '\r') {
                n2 = this.pos;
                this.pos = n2 + 1;
            }
            String string = this.text.substring(fromPos, this.pos);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            this.currentLine = string;
            n2 = this.pos;
            this.pos = n2 + 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentLine != null;
        }

        @Override
        @NotNull
        public String next() {
            String string = this.currentLine;
            if (string == null) {
                throw new NoSuchElementException();
            }
            String res2 = string;
            this.advance();
            return res2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

