/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.CollectionUDF;

import java.math.BigDecimal;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class MVIndexFunctionImp
implements PPLFuncImpTable.FunctionImp {
    @Override
    public RexNode resolve(RexBuilder builder, RexNode ... args) {
        RexNode array = args[0];
        RexNode startIdx = args[1];
        RexNode arrayLen = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ARRAY_LENGTH, array);
        if (args.length == 2) {
            return this.resolveSingleElement(builder, array, startIdx, arrayLen);
        }
        RexNode endIdx = args[2];
        return this.resolveRange(builder, array, startIdx, endIdx, arrayLen);
    }

    private RexNode resolveSingleElement(RexBuilder builder, RexNode array, RexNode startIdx, RexNode arrayLen) {
        RexLiteral zero = builder.makeExactLiteral(BigDecimal.ZERO);
        RexLiteral one = builder.makeExactLiteral(BigDecimal.ONE);
        RexNode isNegative = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.LESS, new RexNode[]{startIdx, zero});
        RexNode sumArrayLenStart = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ADDFUNCTION, arrayLen, startIdx);
        RexNode negativeCase = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ADDFUNCTION, new RexNode[]{sumArrayLenStart, one});
        RexNode positiveCase = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ADDFUNCTION, new RexNode[]{startIdx, one});
        RexNode normalizedStart = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.IF, isNegative, negativeCase, positiveCase);
        return PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.INTERNAL_ITEM, array, normalizedStart);
    }

    private RexNode resolveRange(RexBuilder builder, RexNode array, RexNode startIdx, RexNode endIdx, RexNode arrayLen) {
        RexLiteral zero = builder.makeExactLiteral(BigDecimal.ZERO);
        RexLiteral one = builder.makeExactLiteral(BigDecimal.ONE);
        RexNode isStartNegative = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.LESS, new RexNode[]{startIdx, zero});
        RexNode startNegativeCase = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ADDFUNCTION, arrayLen, startIdx);
        RexNode normalizedStart = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.IF, isStartNegative, startNegativeCase, startIdx);
        RexNode isEndNegative = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.LESS, new RexNode[]{endIdx, zero});
        RexNode endNegativeCase = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ADDFUNCTION, arrayLen, endIdx);
        RexNode normalizedEnd = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.IF, isEndNegative, endNegativeCase, endIdx);
        RexNode diff = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.SUBTRACT, normalizedEnd, normalizedStart);
        RexNode length = PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ADDFUNCTION, new RexNode[]{diff, one});
        return PPLFuncImpTable.INSTANCE.resolve(builder, BuiltinFunctionName.ARRAY_SLICE, array, normalizedStart, length);
    }
}

