/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.Aws4UnsignedPayloadSigner;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.core.signer.NoOpSigner;
import software.amazon.awssdk.core.signer.Signer;

public enum AwsRequestSigner {
    VERSION_FOUR_SIGNER("AWS4SignerType", (Signer)Aws4Signer.create()),
    VERSION_FOUR_UNSIGNED_PAYLOAD_SIGNER("AWS4UnsignedPayloadSignerType", (Signer)Aws4UnsignedPayloadSigner.create()),
    NO_OP_SIGNER("NoOpSignerType", (Signer)new NoOpSigner()),
    S3_V4_SIGNER("AWSS3V4SignerType", (Signer)AwsS3V4Signer.create());

    private final String name;
    private final Signer signer;

    private AwsRequestSigner(String name, Signer signer) {
        this.name = name;
        this.signer = signer;
    }

    public String getName() {
        return this.name;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public static AwsRequestSigner fromSignerName(String signerName) {
        List matchingSigners = Arrays.stream(AwsRequestSigner.values()).filter(awsRequestSigner -> awsRequestSigner.getName().equals(signerName)).collect(Collectors.toList());
        if (matchingSigners.size() < 1) {
            throw new IllegalArgumentException("No matching signers found for signerName: " + signerName);
        }
        if (matchingSigners.size() > 1) {
            throw new IllegalArgumentException("More than 1 matching signers found for signerName: " + signerName);
        }
        return (AwsRequestSigner)((Object)matchingSigners.get(0));
    }
}

