/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReplicaStatus {
    CREATING("CREATING"),
    CREATION_FAILED("CREATION_FAILED"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    ACTIVE("ACTIVE"),
    REGION_DISABLED("REGION_DISABLED"),
    INACCESSIBLE_ENCRYPTION_CREDENTIALS("INACCESSIBLE_ENCRYPTION_CREDENTIALS"),
    ARCHIVING("ARCHIVING"),
    ARCHIVED("ARCHIVED"),
    REPLICATION_NOT_AUTHORIZED("REPLICATION_NOT_AUTHORIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReplicaStatus> VALUE_MAP;
    private final String value;

    private ReplicaStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReplicaStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReplicaStatus> knownValues() {
        EnumSet<ReplicaStatus> knownValues = EnumSet.allOf(ReplicaStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReplicaStatus.class, ReplicaStatus::toString);
    }
}

