import { jsxs, jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { InlineField, TagsInput, Input } from '@grafana/ui';
import 'react';
import { ConfigSubSection } from '../ConfigSection/ConfigSubSection.js';
import '@grafana/data';

const AdvancedHttpSettings = ({
  config,
  onChange,
  className
}) => {
  const onCookiesChange = (cookies) => {
    onChange({
      ...config,
      jsonData: {
        ...config.jsonData,
        keepCookies: cookies
      }
    });
  };
  const onTimeoutChange = (event) => {
    onChange({
      ...config,
      jsonData: {
        ...config.jsonData,
        timeout: parseInt(event.currentTarget.value, 10)
      }
    });
  };
  const styles = {
    container: css({
      maxWidth: 578
    })
  };
  return /* @__PURE__ */ jsxs(ConfigSubSection, { title: "Advanced HTTP settings", className: cx(styles.container, className), children: [
    /* @__PURE__ */ jsx(
      InlineField,
      {
        htmlFor: "advanced-http-cookies",
        label: "Allowed cookies",
        labelWidth: 24,
        tooltip: "Grafana proxy deletes forwarded cookies by default. Specify cookies by name that should be forwarded to the data source.",
        disabled: config.readOnly,
        grow: true,
        children: /* @__PURE__ */ jsx(
          TagsInput,
          {
            id: "advanced-http-cookies",
            placeholder: "New cookie (hit enter to add)",
            tags: config.jsonData.keepCookies,
            onChange: onCookiesChange
          }
        )
      }
    ),
    /* @__PURE__ */ jsx(
      InlineField,
      {
        htmlFor: "advanced-http-timeout",
        label: "Timeout",
        labelWidth: 24,
        tooltip: "HTTP request timeout in seconds",
        disabled: config.readOnly,
        grow: true,
        children: /* @__PURE__ */ jsx(
          Input,
          {
            id: "advanced-http-timeout",
            type: "number",
            min: 0,
            placeholder: "Timeout in seconds",
            "aria-label": "Timeout in seconds",
            value: config.jsonData.timeout,
            onChange: onTimeoutChange
          }
        )
      }
    )
  ] });
};

export { AdvancedHttpSettings };
//# sourceMappingURL=AdvancedHttpSettings.js.map
