/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

public enum TaskType implements MpxjEnum
{
    FIXED_UNITS(0),
    FIXED_DURATION(1),
    FIXED_WORK(2);

    private static final TaskType[] TYPE_VALUES;
    private final int m_value;

    private TaskType(int type) {
        this.m_value = type;
    }

    public static TaskType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = FIXED_WORK.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static TaskType getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return TaskType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (TaskType[])EnumHelper.createTypeArray(TaskType.class);
    }
}

