﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>Metadata information about scaling operations for an instance
 * group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/InstanceGroupScalingMetadata">AWS
 * API Reference</a></p>
 */
class InstanceGroupScalingMetadata {
 public:
  AWS_SAGEMAKER_API InstanceGroupScalingMetadata() = default;
  AWS_SAGEMAKER_API InstanceGroupScalingMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API InstanceGroupScalingMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The current number of instances in the group.</p>
   */
  inline int GetInstanceCount() const { return m_instanceCount; }
  inline bool InstanceCountHasBeenSet() const { return m_instanceCountHasBeenSet; }
  inline void SetInstanceCount(int value) {
    m_instanceCountHasBeenSet = true;
    m_instanceCount = value;
  }
  inline InstanceGroupScalingMetadata& WithInstanceCount(int value) {
    SetInstanceCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The desired number of instances for the group after scaling.</p>
   */
  inline int GetTargetCount() const { return m_targetCount; }
  inline bool TargetCountHasBeenSet() const { return m_targetCountHasBeenSet; }
  inline void SetTargetCount(int value) {
    m_targetCountHasBeenSet = true;
    m_targetCount = value;
  }
  inline InstanceGroupScalingMetadata& WithTargetCount(int value) {
    SetTargetCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Minimum instance count of the instance group.</p>
   */
  inline int GetMinCount() const { return m_minCount; }
  inline bool MinCountHasBeenSet() const { return m_minCountHasBeenSet; }
  inline void SetMinCount(int value) {
    m_minCountHasBeenSet = true;
    m_minCount = value;
  }
  inline InstanceGroupScalingMetadata& WithMinCount(int value) {
    SetMinCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An error message describing why the scaling operation failed, if
   * applicable.</p>
   */
  inline const Aws::String& GetFailureMessage() const { return m_failureMessage; }
  inline bool FailureMessageHasBeenSet() const { return m_failureMessageHasBeenSet; }
  template <typename FailureMessageT = Aws::String>
  void SetFailureMessage(FailureMessageT&& value) {
    m_failureMessageHasBeenSet = true;
    m_failureMessage = std::forward<FailureMessageT>(value);
  }
  template <typename FailureMessageT = Aws::String>
  InstanceGroupScalingMetadata& WithFailureMessage(FailureMessageT&& value) {
    SetFailureMessage(std::forward<FailureMessageT>(value));
    return *this;
  }
  ///@}
 private:
  int m_instanceCount{0};

  int m_targetCount{0};

  int m_minCount{0};

  Aws::String m_failureMessage;
  bool m_instanceCountHasBeenSet = false;
  bool m_targetCountHasBeenSet = false;
  bool m_minCountHasBeenSet = false;
  bool m_failureMessageHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
