﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/frauddetector/model/Language.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FraudDetector {
namespace Model {

/**
 * <p>The details of the rule.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/RuleDetail">AWS
 * API Reference</a></p>
 */
class RuleDetail {
 public:
  AWS_FRAUDDETECTOR_API RuleDetail() = default;
  AWS_FRAUDDETECTOR_API RuleDetail(Aws::Utils::Json::JsonView jsonValue);
  AWS_FRAUDDETECTOR_API RuleDetail& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FRAUDDETECTOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The rule ID.</p>
   */
  inline const Aws::String& GetRuleId() const { return m_ruleId; }
  inline bool RuleIdHasBeenSet() const { return m_ruleIdHasBeenSet; }
  template <typename RuleIdT = Aws::String>
  void SetRuleId(RuleIdT&& value) {
    m_ruleIdHasBeenSet = true;
    m_ruleId = std::forward<RuleIdT>(value);
  }
  template <typename RuleIdT = Aws::String>
  RuleDetail& WithRuleId(RuleIdT&& value) {
    SetRuleId(std::forward<RuleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The rule description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  RuleDetail& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The detector for which the rule is associated.</p>
   */
  inline const Aws::String& GetDetectorId() const { return m_detectorId; }
  inline bool DetectorIdHasBeenSet() const { return m_detectorIdHasBeenSet; }
  template <typename DetectorIdT = Aws::String>
  void SetDetectorId(DetectorIdT&& value) {
    m_detectorIdHasBeenSet = true;
    m_detectorId = std::forward<DetectorIdT>(value);
  }
  template <typename DetectorIdT = Aws::String>
  RuleDetail& WithDetectorId(DetectorIdT&& value) {
    SetDetectorId(std::forward<DetectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The rule version.</p>
   */
  inline const Aws::String& GetRuleVersion() const { return m_ruleVersion; }
  inline bool RuleVersionHasBeenSet() const { return m_ruleVersionHasBeenSet; }
  template <typename RuleVersionT = Aws::String>
  void SetRuleVersion(RuleVersionT&& value) {
    m_ruleVersionHasBeenSet = true;
    m_ruleVersion = std::forward<RuleVersionT>(value);
  }
  template <typename RuleVersionT = Aws::String>
  RuleDetail& WithRuleVersion(RuleVersionT&& value) {
    SetRuleVersion(std::forward<RuleVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The rule expression.</p>
   */
  inline const Aws::String& GetExpression() const { return m_expression; }
  inline bool ExpressionHasBeenSet() const { return m_expressionHasBeenSet; }
  template <typename ExpressionT = Aws::String>
  void SetExpression(ExpressionT&& value) {
    m_expressionHasBeenSet = true;
    m_expression = std::forward<ExpressionT>(value);
  }
  template <typename ExpressionT = Aws::String>
  RuleDetail& WithExpression(ExpressionT&& value) {
    SetExpression(std::forward<ExpressionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The rule language.</p>
   */
  inline Language GetLanguage() const { return m_language; }
  inline bool LanguageHasBeenSet() const { return m_languageHasBeenSet; }
  inline void SetLanguage(Language value) {
    m_languageHasBeenSet = true;
    m_language = value;
  }
  inline RuleDetail& WithLanguage(Language value) {
    SetLanguage(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The rule outcomes.</p>
   */
  inline const Aws::Vector<Aws::String>& GetOutcomes() const { return m_outcomes; }
  inline bool OutcomesHasBeenSet() const { return m_outcomesHasBeenSet; }
  template <typename OutcomesT = Aws::Vector<Aws::String>>
  void SetOutcomes(OutcomesT&& value) {
    m_outcomesHasBeenSet = true;
    m_outcomes = std::forward<OutcomesT>(value);
  }
  template <typename OutcomesT = Aws::Vector<Aws::String>>
  RuleDetail& WithOutcomes(OutcomesT&& value) {
    SetOutcomes(std::forward<OutcomesT>(value));
    return *this;
  }
  template <typename OutcomesT = Aws::String>
  RuleDetail& AddOutcomes(OutcomesT&& value) {
    m_outcomesHasBeenSet = true;
    m_outcomes.emplace_back(std::forward<OutcomesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Timestamp of the last time the rule was updated.</p>
   */
  inline const Aws::String& GetLastUpdatedTime() const { return m_lastUpdatedTime; }
  inline bool LastUpdatedTimeHasBeenSet() const { return m_lastUpdatedTimeHasBeenSet; }
  template <typename LastUpdatedTimeT = Aws::String>
  void SetLastUpdatedTime(LastUpdatedTimeT&& value) {
    m_lastUpdatedTimeHasBeenSet = true;
    m_lastUpdatedTime = std::forward<LastUpdatedTimeT>(value);
  }
  template <typename LastUpdatedTimeT = Aws::String>
  RuleDetail& WithLastUpdatedTime(LastUpdatedTimeT&& value) {
    SetLastUpdatedTime(std::forward<LastUpdatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp of when the rule was created.</p>
   */
  inline const Aws::String& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::String>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::String>
  RuleDetail& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The rule ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  RuleDetail& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_ruleId;

  Aws::String m_description;

  Aws::String m_detectorId;

  Aws::String m_ruleVersion;

  Aws::String m_expression;

  Language m_language{Language::NOT_SET};

  Aws::Vector<Aws::String> m_outcomes;

  Aws::String m_lastUpdatedTime;

  Aws::String m_createdTime;

  Aws::String m_arn;
  bool m_ruleIdHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_detectorIdHasBeenSet = false;
  bool m_ruleVersionHasBeenSet = false;
  bool m_expressionHasBeenSet = false;
  bool m_languageHasBeenSet = false;
  bool m_outcomesHasBeenSet = false;
  bool m_lastUpdatedTimeHasBeenSet = false;
  bool m_createdTimeHasBeenSet = false;
  bool m_arnHasBeenSet = false;
};

}  // namespace Model
}  // namespace FraudDetector
}  // namespace Aws
