﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/comprehendmedical/ComprehendMedical_EXPORTS.h>
#include <aws/comprehendmedical/model/Attribute.h>
#include <aws/comprehendmedical/model/EntitySubType.h>
#include <aws/comprehendmedical/model/EntityType.h>
#include <aws/comprehendmedical/model/Trait.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ComprehendMedical {
namespace Model {

/**
 * <p> Provides information about an extracted medical entity.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/Entity">AWS
 * API Reference</a></p>
 */
class Entity {
 public:
  AWS_COMPREHENDMEDICAL_API Entity() = default;
  AWS_COMPREHENDMEDICAL_API Entity(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPREHENDMEDICAL_API Entity& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPREHENDMEDICAL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The numeric identifier for the entity. This is a monotonically increasing id
   * unique within this response rather than a global unique identifier. </p>
   */
  inline int GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  inline void SetId(int value) {
    m_idHasBeenSet = true;
    m_id = value;
  }
  inline Entity& WithId(int value) {
    SetId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The 0-based character offset in the input text that shows where the entity
   * begins. The offset returns the UTF-8 code point in the string. </p>
   */
  inline int GetBeginOffset() const { return m_beginOffset; }
  inline bool BeginOffsetHasBeenSet() const { return m_beginOffsetHasBeenSet; }
  inline void SetBeginOffset(int value) {
    m_beginOffsetHasBeenSet = true;
    m_beginOffset = value;
  }
  inline Entity& WithBeginOffset(int value) {
    SetBeginOffset(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The 0-based character offset in the input text that shows where the entity
   * ends. The offset returns the UTF-8 code point in the string. </p>
   */
  inline int GetEndOffset() const { return m_endOffset; }
  inline bool EndOffsetHasBeenSet() const { return m_endOffsetHasBeenSet; }
  inline void SetEndOffset(int value) {
    m_endOffsetHasBeenSet = true;
    m_endOffset = value;
  }
  inline Entity& WithEndOffset(int value) {
    SetEndOffset(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The level of confidence that Amazon Comprehend Medical has in the accuracy of
   * the detection.</p>
   */
  inline double GetScore() const { return m_score; }
  inline bool ScoreHasBeenSet() const { return m_scoreHasBeenSet; }
  inline void SetScore(double value) {
    m_scoreHasBeenSet = true;
    m_score = value;
  }
  inline Entity& WithScore(double value) {
    SetScore(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The segment of input text extracted as this entity.</p>
   */
  inline const Aws::String& GetText() const { return m_text; }
  inline bool TextHasBeenSet() const { return m_textHasBeenSet; }
  template <typename TextT = Aws::String>
  void SetText(TextT&& value) {
    m_textHasBeenSet = true;
    m_text = std::forward<TextT>(value);
  }
  template <typename TextT = Aws::String>
  Entity& WithText(TextT&& value) {
    SetText(std::forward<TextT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The category of the entity.</p>
   */
  inline EntityType GetCategory() const { return m_category; }
  inline bool CategoryHasBeenSet() const { return m_categoryHasBeenSet; }
  inline void SetCategory(EntityType value) {
    m_categoryHasBeenSet = true;
    m_category = value;
  }
  inline Entity& WithCategory(EntityType value) {
    SetCategory(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Describes the specific type of entity with category of entities.</p>
   */
  inline EntitySubType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(EntitySubType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline Entity& WithType(EntitySubType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contextual information for the entity.</p>
   */
  inline const Aws::Vector<Trait>& GetTraits() const { return m_traits; }
  inline bool TraitsHasBeenSet() const { return m_traitsHasBeenSet; }
  template <typename TraitsT = Aws::Vector<Trait>>
  void SetTraits(TraitsT&& value) {
    m_traitsHasBeenSet = true;
    m_traits = std::forward<TraitsT>(value);
  }
  template <typename TraitsT = Aws::Vector<Trait>>
  Entity& WithTraits(TraitsT&& value) {
    SetTraits(std::forward<TraitsT>(value));
    return *this;
  }
  template <typename TraitsT = Trait>
  Entity& AddTraits(TraitsT&& value) {
    m_traitsHasBeenSet = true;
    m_traits.emplace_back(std::forward<TraitsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The extracted attributes that relate to this entity.</p>
   */
  inline const Aws::Vector<Attribute>& GetAttributes() const { return m_attributes; }
  inline bool AttributesHasBeenSet() const { return m_attributesHasBeenSet; }
  template <typename AttributesT = Aws::Vector<Attribute>>
  void SetAttributes(AttributesT&& value) {
    m_attributesHasBeenSet = true;
    m_attributes = std::forward<AttributesT>(value);
  }
  template <typename AttributesT = Aws::Vector<Attribute>>
  Entity& WithAttributes(AttributesT&& value) {
    SetAttributes(std::forward<AttributesT>(value));
    return *this;
  }
  template <typename AttributesT = Attribute>
  Entity& AddAttributes(AttributesT&& value) {
    m_attributesHasBeenSet = true;
    m_attributes.emplace_back(std::forward<AttributesT>(value));
    return *this;
  }
  ///@}
 private:
  int m_id{0};

  int m_beginOffset{0};

  int m_endOffset{0};

  double m_score{0.0};

  Aws::String m_text;

  EntityType m_category{EntityType::NOT_SET};

  EntitySubType m_type{EntitySubType::NOT_SET};

  Aws::Vector<Trait> m_traits;

  Aws::Vector<Attribute> m_attributes;
  bool m_idHasBeenSet = false;
  bool m_beginOffsetHasBeenSet = false;
  bool m_endOffsetHasBeenSet = false;
  bool m_scoreHasBeenSet = false;
  bool m_textHasBeenSet = false;
  bool m_categoryHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_traitsHasBeenSet = false;
  bool m_attributesHasBeenSet = false;
};

}  // namespace Model
}  // namespace ComprehendMedical
}  // namespace Aws
