﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgent {
namespace Model {

/**
 * <p>Details about a malformed input expression in a node.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/MalformedNodeInputExpressionFlowValidationDetails">AWS
 * API Reference</a></p>
 */
class MalformedNodeInputExpressionFlowValidationDetails {
 public:
  AWS_BEDROCKAGENT_API MalformedNodeInputExpressionFlowValidationDetails() = default;
  AWS_BEDROCKAGENT_API MalformedNodeInputExpressionFlowValidationDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API MalformedNodeInputExpressionFlowValidationDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the node containing the malformed input expression.</p>
   */
  inline const Aws::String& GetNode() const { return m_node; }
  inline bool NodeHasBeenSet() const { return m_nodeHasBeenSet; }
  template <typename NodeT = Aws::String>
  void SetNode(NodeT&& value) {
    m_nodeHasBeenSet = true;
    m_node = std::forward<NodeT>(value);
  }
  template <typename NodeT = Aws::String>
  MalformedNodeInputExpressionFlowValidationDetails& WithNode(NodeT&& value) {
    SetNode(std::forward<NodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the input with the malformed expression.</p>
   */
  inline const Aws::String& GetInput() const { return m_input; }
  inline bool InputHasBeenSet() const { return m_inputHasBeenSet; }
  template <typename InputT = Aws::String>
  void SetInput(InputT&& value) {
    m_inputHasBeenSet = true;
    m_input = std::forward<InputT>(value);
  }
  template <typename InputT = Aws::String>
  MalformedNodeInputExpressionFlowValidationDetails& WithInput(InputT&& value) {
    SetInput(std::forward<InputT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error message describing why the input expression is malformed.</p>
   */
  inline const Aws::String& GetCause() const { return m_cause; }
  inline bool CauseHasBeenSet() const { return m_causeHasBeenSet; }
  template <typename CauseT = Aws::String>
  void SetCause(CauseT&& value) {
    m_causeHasBeenSet = true;
    m_cause = std::forward<CauseT>(value);
  }
  template <typename CauseT = Aws::String>
  MalformedNodeInputExpressionFlowValidationDetails& WithCause(CauseT&& value) {
    SetCause(std::forward<CauseT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_node;

  Aws::String m_input;

  Aws::String m_cause;
  bool m_nodeHasBeenSet = false;
  bool m_inputHasBeenSet = false;
  bool m_causeHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
