/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Map;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.ShareGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.SimpleHeterogeneousAssignmentBuilder;
import org.apache.kafka.coordinator.group.assignor.SimpleHomogeneousAssignmentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAssignor
implements ShareGroupPartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(SimpleAssignor.class);
    private static final String SIMPLE_ASSIGNOR_NAME = "simple";

    public String name() {
        return SIMPLE_ASSIGNOR_NAME;
    }

    public GroupAssignment assign(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        if (groupSpec.memberIds().isEmpty()) {
            return new GroupAssignment(Map.of());
        }
        if (groupSpec.subscriptionType().equals((Object)SubscriptionType.HOMOGENEOUS)) {
            log.debug("Detected that all members are subscribed to the same set of topics, invoking the homogeneous assignment algorithm");
            return new SimpleHomogeneousAssignmentBuilder(groupSpec, subscribedTopicDescriber).build();
        }
        log.debug("Detected that the members are subscribed to different sets of topics, invoking the heterogeneous assignment algorithm");
        return new SimpleHeterogeneousAssignmentBuilder(groupSpec, subscribedTopicDescriber).build();
    }
}

