// generated by ../../../../tools/tube_transfer.py
// tube: SVEL34
// plate current function: pentode
// mu: 11.5
// kx: 1.35
// kg1: 608.9
// kg2: 4500
// kp: 41.2
// kvb: 30.1
// Uin_min: -25
// Uin_max: 25
// Vp: 250
// Rp: 2000

table1d_imp<2001> tubetable_SVEL34[2] __rt_data = {
	{ // Ri = 68k
	-25,25,40,2001, {
	228.35363740496678,228.28468348365752,228.21558796265822,228.14635082183173,228.07697204160016,
	228.00745160294287,227.9377894873946,227.86798567704355,227.79804015452928,227.72795290304072,
	227.6577239063145,227.58735314863253,227.51684061482038,227.446186290245,227.375390160813,
	227.30445221296853,227.23337243369122,227.16215081049424,227.0907873314223,227.0192819850497,
	226.9476347604782,226.87584564733504,226.803914635771,226.7318417164583,226.65962688058858,
	226.58727011987088,226.5147714265298,226.44213079330305,226.36934821343988,226.2964236806986,
	226.22335718934514,226.1501487341503,226.07679831038823,226.00330591383425,225.9296715407627,
	225.8558951879451,225.78197685264783,225.70791653263035,225.63371422614298,225.55936993192503,
	225.48488364920252,225.4102553776863,225.3354851175699,225.2605728695276,225.1855186347123,
	225.11032241475343,225.03498421175496,224.9595040282934,224.8838818674155,224.80811773263667,
	224.7322116279384,224.65616355776652,224.5799735270291,224.5036415410944,224.42716760578867,
	224.3505517273944,224.273793912648,224.19689416873788,224.11985250330235,224.0426689244276,
	223.96534344064574,223.88787606093254,223.8102667947056,223.7325156518222,223.65462264257735,
	223.57658777770155,223.498411068359,223.42009252614548,223.34163216308622,223.26302999163397,
	223.184286024667,223.10540027548691,223.02637275781672,222.94720348579895,222.8678924739934,
	222.78843973737528,222.70884529133306,222.6291091516665,222.54923133458482,222.46921185670433,
	222.38905073504685,222.30874798703735,222.2283036305021,222.14771768366668,222.06699016515398,
	221.98612109398212,221.90511048956276,221.82395837169858,221.74266476058185,221.66122967679206,
	221.57965314129422,221.49793517543668,221.41607580094927,221.33407503994135,221.25193291489973,
	221.1696494486869,221.08722466453884,221.00465858606339,220.92195123723795,220.83910264240777,
	220.75611282628395,220.67298181394148,220.5897096308174,220.50629630270876,220.4227418557708,
	220.3390463165149,220.25520971180683,220.17123206886473,220.08711341525728,220.00285377890174,
	219.91845318806207,219.83391167134718,219.74922925770875,219.66440597643958,219.57944185717167,
	219.4943369298744,219.40909122485252,219.32370477274435,219.23817760452008,219.15250975147967,
	219.06670124525124,218.98075211778902,218.89466240137162,218.80843212860032,218.72206133239698,
	218.6355500460024,218.54889830297464,218.46210613718677,218.37517358282557,218.2881006743895,
	218.20088744668678,218.11353393483387,218.02604017425355,217.93840620067323,217.85063205012304,
	217.76271775893412,217.674663363737,217.58646890145974,217.49813440932618,217.40965992485414,
	217.321045485854,217.23229113042646,217.14339689696124,217.05436282413535,216.965188950911,
	216.87587531653452,216.78642196053397,216.69682892271808,216.60709624317414,216.51722396226643,
	216.42721212063472,216.33706075919244,216.24676991912506,216.15633964188848,216.06576996920728,
	215.97506094307326,215.88421260574373,215.79322499973972,215.7020981678446,215.6108321531025,
	215.51942699881653,215.42788274854706,215.33619944611067,215.2443771355779,215.15241586127223,
	215.06031566776815,214.96807659988977,214.8756987027092,214.78318202154506,214.69052660196087,
	214.59773248976367,214.50479973100218,214.41172837196564,214.318518459182,214.22517003941672,
	214.13168315967098,214.03805786718038,213.94429420941333,213.8503922340697,213.7563519890792,
	213.6621735226001,213.56785688301767,213.4734021189426,213.37880927920995,213.28407841287725,
	213.18920956922335,213.09420279774707,212.99905814816552,212.9037756704129,212.80835541463904,
	212.71279743120812,212.617101770697,212.52126848389412,212.42529762179817,212.32918923561644,
	212.23294337676373,212.13656009686096,212.04003944773365,211.9433814814109,211.84658625012386,
	211.7496538063044,211.65258420258388,211.55537749179192,211.45803372695494,211.36055296129504,
	211.26293524822867,211.16518064136523,211.06728919450603,210.96926096164293,210.87109599695717,
	210.77279435481785,210.67435608978116,210.57578125658873,210.47706991016682,210.3782221056247,
	210.27923789825377,210.18011734352626,210.08086049709397,209.9814674147873,209.88193815261377,
	209.78227276675727,209.6824713135765,209.5825338496042,209.48246043154566,209.38225111627784,
	209.28190596084826,209.18142502247366,209.0808083585392,208.9800560265971,208.87916808436572,
	208.7781445897284,208.6769856007325,208.5756911755881,208.47426137266729,208.37269625050277,
	208.27099586778715,208.16916028337147,208.06718955626485,207.96508374563265,207.86284291079627,
	207.76046711123152,207.65795640656793,207.55531085658788,207.45253052122527,207.34961546056482,
	207.2465657348411,207.14338140443746,207.04006252988515,206.93660917186244,206.8330213911936,
	206.72929924884795,206.6254428059392,206.52145212372426,206.41732726360243,206.31306828711465,
	206.2086752559424,206.10414823190703,205.99948727696875,205.89469245322593,205.7897638229141,
	205.6847014484052,205.57950539220673,205.47417571696096,205.3687124854441,205.26311576056537,
	205.1573856053665,205.05152208302064,204.94552525683173,204.83939519023374,204.7331319467899,
	204.6267355901918,204.52020618425888,204.41354379293742,204.30674848030014,204.19982031054525,
	204.0927593479957,203.98556565709856,203.87823930242453,203.77078034866682,203.6631888606407,
	203.555464903283,203.4476085416511,203.33961984092252,203.2314988663941,203.12324568348163,
	203.01486035771882,202.9063429547571,202.7976935403646,202.68891218042594,202.5799989409414,
	202.47095388802623,202.36177708791033,202.2524686069375,202.143028511565,202.03345686836283,
	201.9237537440134,201.81391920531067,201.70395331915992,201.59385615257716,201.48362777268846,
	201.37326824672962,201.26277764204573,201.15215602609024,201.04140346642498,200.9305200307196,
	200.81950578675077,200.70836080240215,200.5970851456636,200.48567888463106,200.3741420875057,
	200.26247482259396,200.15067715830682,200.0387491631594,199.92669090577084,199.81450245486357,
	199.70218387926312,199.58973524789775,199.4771566297979,199.36444809409608,199.25160971002634,
	199.1386415469242,199.02554367422582,198.91231616146808,198.7989590782883,198.68547249442366,
	198.57185647971102,198.45811110408678,198.3442364375863,198.23023255034383,198.1160995125923,
	198.00183739466294,197.887446266985,197.77292620008558,197.65827726458943,197.5434995312188,
	197.42859307079289,197.313557954228,197.19839425253727,197.0831020368303,196.96768137831316,
	196.8521323482882,196.73645501815378,196.62064945940418,196.50471574362953,196.38865394251553,
	196.27246412784342,196.15614637148985,196.0397007454267,195.92312732172107,195.80642617253514,
	195.68959737012608,195.57264098684598,195.45555709514178,195.33834576755524,195.22100707672288,
	195.1035410953759,194.98594789634,194.86822755253587,194.75038013697858,194.63240572277786,
	194.5143043831381,194.39607619135822,194.277721220832,194.15923954504768,194.0406312375883,
	193.92189637213164,193.8030350224504,193.68404726241187,193.56493316597863,193.44569280720808,
	193.32632626025273,193.20683359936038,193.0872148988741,192.96747023323235,192.84759967696925,
	192.72760330471453,192.60748119119378,192.48723341122854,192.36686003973645,192.2463611517316,
	192.12573682232443,192.00498712672209,191.8841121402286,191.7631119382451,191.64198659626987,
	191.52073618989888,191.39936079482564,191.27786048684186,191.15623534183723,191.03448543580018,
	190.91261084481766,190.79061164507576,190.6684879128599,190.54623972455505,190.4238671566461,
	190.3013702857183,190.17874918845715,190.0560039416493,189.93313462218248,189.8101413070461,
	189.68702407333134,189.56378299823183,189.44041815904373,189.31692963316644,189.19331749810263,
	189.0695818314589,188.94572271094617,188.82174021437996,188.69763441968104,188.57340540487573,
	188.4490532480963,188.32457802758157,188.19997982167732,188.0752587088367,187.950414767621,
	187.8254480766997,187.7003587148513,187.57514676096383,187.44981229403524,187.32435539317405,
	187.19877613759988,187.07307460664384,186.94725087974942,186.82130503647275,186.69523715648344,
	186.56904731956502,186.44273560561544,186.31630209464814,186.18974686679206,186.06307000229282,
	185.93627158151295,185.80935168493284,185.68231039315128,185.55514778688615,185.427863946975,
	185.30045895437598,185.17293289016837,185.0452858355533,184.91751787185459,184.78962908051935,
	184.6616195431188,184.53348934134908,184.4052385570318,184.27686727211514,184.14837556867434,
	184.01976352891273,183.8910312351623,183.76217876988477,183.6332062156722,183.50411365524798,
	183.37490117146763,183.2455688473196,183.11611676592622,182.98654501054457,182.8568536645674,
	182.72704281152392,182.59711253508078,182.46706291904297,182.33689404735495,182.20660600410113,
	182.07619887350745,181.9456727399417,181.8150276879151,181.6842638020828,181.55338116724516,
	181.42237986834868,181.291259990487,181.16002161890194,181.02866483898464,180.89718973627646,
	180.76559639647013,180.63388490541078,180.50205534909713,180.3701078136825,180.23804238547595,
	180.10585915094333,179.97355819670855,179.84113960955466,179.70860347642488,179.5759498844241,
	179.44317892081952,179.3102906730425,179.1772852286893,179.0441626755223,178.91092310147155,
	178.77756659463563,178.64409324328324,178.51050313585415,178.3767963609607,178.2429730073889,
	178.1090331641,177.9749769202315,177.84080436509865,177.70651558819569,177.57211067919724,
	177.43758972795976,177.30295282452263,177.16820005910992,177.0333315221314,176.89834730418417,
	176.76324749605422,176.62803218871738,176.49270147334124,176.35725544128638,176.22169418410797,
	176.08601779355706,175.9502263615822,175.814319980331,175.67829874215144,175.54216273959375,
	175.4059120654115,175.26954681256362,175.13306707421566,174.9964729437415,174.85976451472493,
	174.7229418809612,174.5860051364587,174.4489543754407,174.31178969234685,174.17451118183482,
	174.03711893878204,173.89961305828754,173.7619936356734,173.62426076648657,173.48641454650075,
	173.34845507171784,173.21038243836995,173.07219674292108,172.93389808206882,172.79548655274638,
	172.65696225212426,172.51832527761195,172.37957572686003,172.24071369776183,172.10173928845543,
	171.9626525973256,171.82345372300531,171.6841427643783,171.5447198205803,171.4051849910015,
	171.26553837528834,171.1257800733454,170.9859101853374,170.8459288116914,170.7058360530986,
	170.56563201051648,170.4253167851707,170.28489047855743,170.1443531924452,170.00370502887705,
	169.86294609017273,169.72207647893066,169.58109629803016,169.44000565063374,169.298804640189,
	169.15749337043093,169.0160719453842,168.8745404693653,168.73289904698467,168.59114778314924,
	168.4492867830643,168.30731615223618,168.16523599647417,168.02304642189316,167.88074753491574,
	167.73833944227462,167.59582225101508,167.4531960684972,167.31046100239823,167.1676171607153,
	167.02466465176747,166.88160358419833,166.7384340669786,166.59515620940832,166.45177012111958,
	166.3082759120789,166.16467369258987,166.0209635732956,165.8771456651812,165.73322007957665,
	165.58918692815914,165.44504632295562,165.30079837634585,165.1564432010645,165.0119809102042,
	164.86741161721812,164.72273543592263,164.57795248050004,164.4330628655013,164.28806670584896,
	164.14296411683964,163.99775521414688,163.8524401138243,163.7070189323079,163.56149178641934,
	163.41585879336847,163.27012007075658,163.1242757365789,162.97832590922778,162.83227070749564,
	162.68611025057777,162.53984465807537,162.39347404999862,162.24699854676953,162.10041826922532,
	161.95373333862096,161.8069438766327,161.66005000536086,161.51305184733314,161.36594952550763,
	161.21874316327597,161.07143288446667,160.924018813348,160.77650107463148,160.628879793475,
	160.48115509548614,160.33332710672522,160.1853959537088,160.037361763413,159.88922466327674,
	159.74098478120504,159.5926422455725,159.44419718522673,159.29564972949152,159.1470000081706,
	158.99824815155085,158.84939429040585,158.70043855599948,158.55138108008916,158.40222199492968,
	158.25296143327665,158.10359952839005,157.95413641403775,157.8045722244994,157.6549070945698,
	157.50514115956273,157.3552745553145,157.2053074181878,157.05523988507537,156.90507209340373,
	156.75480418113693,156.6044362867805,156.45396854938505,156.3034011085503,156.1527341044288,
	156.00196767772982,155.85110196972357,155.70013712224457,155.54907327769604,155.3979105790538,
	155.24664916987007,155.0952891942777,154.94383079699426,154.79227412332577,154.6406193191711,
	154.48886653102613,154.33701590598756,154.18506759175736,154.0330217366467,153.8808784895806,
	153.72863800010154,153.5763004183742,153.42386589518966,153.27133458196943,153.11870663077005,
	152.96598219428736,152.81316142586073,152.6602444794778,152.50723150977856,152.3541226720598,
	152.20091812227994,152.04761801706306,151.8942225137037,151.7407317701714,151.58714594511508,
	151.4334651978679,151.27968968845147,151.125819577581,150.9718550266696,150.81779619783296,
	150.66364325389438,150.50939635838904,150.35505567556928,150.20062137040904,150.0460936086086,
	149.89147255659978,149.73675838155054,149.58195125136993,149.42705133471298,149.27205880098558,
	149.11697382034973,148.9617965637281,148.8065272028095,148.6511659100534,148.49571285869553,
	148.34016822275262,148.1845321770275,148.0288048971147,147.87298655940484,147.71707734109066,
	147.56107742017153,147.40498697545922,147.24880618658287,147.0925352339943,146.93617429897355,
	146.77972356363404,146.62318321092795,146.46655342465172,146.3098343894513,146.15302629082788,
	145.99612931514307,145.83914364962462,145.68206948237193,145.5249070023614,145.36765639945224,
	145.21031786439212,145.0528915888225,144.89537776528456,144.73777658722486,144.58008824900097,
	144.42231294588723,144.2644508740805,144.10650223070613,143.9484672138235,143.79034602243198,
	143.632138856477,143.47384591685557,143.31546740542254,143.1570035249963,142.99845447936502,
	142.83982047329235,142.68110171252374,142.52229840379232,142.36341075482497,142.20443897434845,
	142.0453832720957,141.88624385881175,141.72702094626015,141.56771474722885,141.40832547553669,
	141.24885334603974,141.08929857463735,140.92966137827867,140.76994197496867,140.61014058377503,
	140.45025742483404,140.2902927193572,140.1302466896378,139.9701195590572,139.80991155209136,
	139.64962289431742,139.48925381242017,139.32880453419872,139.16827528857306,139.00766630559056,
	138.84697781643274,138.68621005342197,138.5253632500281,138.36443764087514,138.20343346174803,
	138.04235094959952,137.88119034255683,137.7199518799285,137.55863580221126,137.3972423510968,
	137.23577176947887,137.0742243014599,136.91260019235835,136.75089968871515,136.58912303830104,
	136.42727049012353,136.26534229443382,136.10333870273405,135.94125996778405,135.77910634360885,
	135.6168780855053,135.45457545004982,135.29219869510504,135.12974807982727,134.9672238646735,
	134.80462631140898,134.64195568311408,134.4792122441918,134.31639626037497,134.15350799873363,
	133.99054772768224,133.82751571698725,133.66441223777426,133.50123756253552,133.33799196513738,
	133.17467572082757,133.01128910624288,132.84783239941643,132.68430587978528,132.52070982819797,
	132.35704452692175,132.19331025965056,132.02950731151242,131.86563596907683,131.70169652036262,
	131.53768925484542,131.37361446346537,131.20947243863466,131.04526347424542,130.88098786567704,
	130.71664590980424,130.55223790500452,130.38776415116592,130.22322494969495,130.05862060352408,
	129.89395141711967,129.72921769648968,129.56441974919147,129.39955788433963,129.2346324126138,
	129.06964364626634,128.90459189913057,128.73947748662806,128.57430072577685,128.40906193519942,
	128.24376143513015,128.07839954742357,127.91297659556214,127.74749290466406,127.58194880149136,
	127.41634461445771,127.25068067363627,127.08495731076782,126.91917485926852,126.75333365423798,
	126.58743403246709,126.421476332446,126.25546089437223,126.08938806015836,125.92325817344022,
	125.75707157958477,125.59082862569798,125.424529660633,125.25817503499788,125.09176510116373,
	124.9253002132726,124.75878072724544,124.59220700079014,124.42557939340934,124.25889826640856,
	124.09216398290408,123.9253769078308,123.75853740795031,123.59164585185874,123.42470260999488,
	123.2577080546478,123.09066255996491,122.92356650196008,122.7564202585211,122.58922420941806,
	122.42197873631082,122.25468422275704,122.0873410542202,121.91994961807707,121.752510303626,
	121.58502350209432,121.41748960664637,121.24990901239134,121.0822821163908,120.91460931766677,
	120.74689101720921,120.57912761798381,120.4113195249399,120.24346714501772,120.07557088715662,
	119.90763116230225,119.73964838341445,119.57162296547493,119.4035553254946,119.23544588252147,
	119.06729505764805,118.89910327401897,118.73087095683859,118.56259853337843,118.3942864329849,
	118.22593508708674,118.05754492920258,117.88911639494873,117.7206499220465,117.55214595033017,
	117.3836049217546,117.21502728040285,117.04641347249456,116.87776394639351,116.70907915261631,
	116.54035954384034,116.3716055749129,116.20281770286006,116.03399638689608,115.86514208843349,
	115.69625527109362,115.52733640071799,115.3583859453807,115.18940437540179,115.0203921633623,
	114.85134978412077,114.68227771483201,114.51317643496856,114.34404642634496,114.1748881731462,
	114.00570216196058,113.83648888181823,113.66724882423675,113.49798248327475,113.32869035559617,
	113.15937294054622,112.99003074024289,112.82066425968641,112.65127400689089,112.48186049304273,
	112.31242423269168,112.1429657439816,111.97348554892926,111.80398417376134,111.63446214932253,
	111.46492001156966,111.29535830216999,111.12577756922684,110.95617836815843,110.78656126276424,
	110.61692682651771,110.44727564413432,110.27760831347383,110.10792544784799,109.93822767882041,
	109.76851565960366,109.59879006918143,109.42905161731022,109.25930105058842,109.08953915982087,
	108.91976678895463,108.74998484592145,108.58019431579314,108.41039627674168,108.2405919194017,
	108.07078257035742,107.90096972062963,107.73115506022265,107.56134052001178,107.39152832252151,
	107.22172104346403,107.05192168629488,106.88213377250443,106.71236145091417,106.54260962990169,
	106.37288413725365,106.2031919132541,106.03354124367814,105.86394204058313,105.69440618018534,
	105.52494790866695,105.35558432845868,105.18633597933172,105.01722753041122,104.84828860082747,
	104.67955472789393,104.51106850204458,104.34288088671822,104.17505273814292,104.00765653348891,
	103.84077830475853,103.67451975843711,103.509000535548,103.34436053170108,103.18076215102047,
	103.01839231205001,102.85746396115914,102.69821678702945,102.54091678123453,102.38585427302272,
	102.23334010313994,102.08369971259059,101.93726511872254,101.79436502439866,101.6553136204724,
	101.52039893469045,101.38987177502499,101.26393634618485,101.14274345587197,101.02638689696131,
	100.91490316689337,100.80827426392244,100.7064329696127,100.60926984022714,100.51664109354464,
	100.4283766628852,100.34428784910405,100.26417418605224,100.18782930879956,100.11504575541866,
	100.04561873472332,99.9793489559245,99.9160446486296,99.85552291143384,99.79761052244439,
	99.74214433180322,99.68897133923375,99.63794854184296,99.5889426206652,99.54182951958283,
	99.49649395776987,99.45282890644678,99.41073505254481,99.37012026540717,99.3308990776875,
	99.29299218784048,99.25632598879062,99.22083212530487,99.18644708111012,99.15311179575103,
	99.12077131046655,99.0893744418937,99.05887348211495,99.02922392340547,99.00038420596837,
	98.9723154869411,98.94498142901689,98.91834800703009,98.89238333106029,98.86705748457791,
	98.84234237634148,98.81821160482507,98.79464033405962,98.77160517986562,98.74908410554403,
	98.72705632617534,98.70550222075401,98.68440325145625,98.66374188940428,98.64350154634961,
	98.62366651175188,98.6042218947787,98.58515357079685,98.56644813196507,98.5480928415752,
	98.53007559182137,98.51238486470666,98.49500969582402,98.47793964077071,98.46116474397762,
	98.4446755097705,98.42846287544091,98.41251818622422,98.39683317198546,98.38139992549844,
	98.36621088219057,98.35125880123928,98.3365367479167,98.32203807708801,98.30775641777629,
	98.29368565871464,98.27981993481308,98.26615361447251,98.25268128768573,98.23939775486761,
	98.22629801636421,98.21337726259172,98.20063086476233,98.18805436615625,98.1756434739023,
	98.1633940512331,98.15130211018273,98.13936380469768,98.12757542413344,98.11593338711084,
	98.10443423571843,98.09307463001107,98.08185134282672,98.07076125486769,98.05980135004502,
	98.04896871106676,98.0382605152553,98.02767403057983,98.01720661189103,98.00685569734605,
	97.9966188050123,97.98649352963969,97.97647753959173,97.96656857392614,97.95676443961625,
	97.94706300890337,97.93746221678859,97.92796005861018,97.91855458777324,97.90924391355937,
	97.90002619904399,97.89089965910821,97.88186255854157,97.87291321022553,97.86404997340391,
	97.85527125202394,97.84657549315247,97.83796118546024,97.8294268577709,97.82097107767687,
	97.81259245019722,97.80428961651744,97.79606125276091,97.78790606881975,97.77982280723238,
	97.77181024210655,97.76386717808603,97.75599244935863,97.74818491870383,97.74044347657785,
	97.73276704023495,97.72515455288233,97.71760498286842,97.71011732290187,97.7026905893003,
	97.6953238212677,97.68801608019884,97.68076644900955,97.67357403149194,97.66643795169017,
	97.65935735331297,97.65233139914226,97.64535927048597,97.6384401666402,97.631573304372,
	97.62475791742088,97.61799325601734,97.61127858641869,97.60461319046036,97.59799636512331,
	97.59142742211549,97.5849056874682,97.57843050114555,97.57200121666737,97.56561720074431,
	97.55927783292549,97.55298250525725,97.5467306219535,97.5405215990764,97.53435486422754,
	97.52822985624908,97.52214602493439,97.51610283074756,97.51009974455232,97.50413624734901,
	97.49821183001981,97.492325993082,97.48647824644875,97.48066810919714,97.4748951093433,
	97.46915878362445,97.46345867728724,97.45779434388274,97.45216534506727,97.44657125040915,
	97.44101163720133,97.43548609027917,97.42999420184387,97.42453557129065,97.4191098050384,
	97.41371651638168,97.40835532531388,97.40302585838633,97.39772774855705,97.39246063504632,
	97.38722416319611,97.38201798433366,97.37684175563867,97.37169514001421,97.36657780596093,
	97.3614894274551,97.35642968382948,97.35139825965764,97.3463948446414,97.34141913350099,
	97.33647082586853,97.33154962618383,97.32665524359331,97.32178739185136,97.31694578922422,
	97.31213015839651,97.30734022637994,97.30257572442446,97.29783638793182,97.29312195637088,
	97.2884321731956,97.28376678576454,97.27912554526279,97.27450820662561,97.26991452846404,
	97.26534427299225,97.26079720595672,97.25627309656724,97.25177171742929,97.24729284447835,
	97.24283625691571,97.23840173714572,97.23398907071446,97.22959804625019,97.22522845540482,
	97.22088009279706,97.21655275595661,97.21224624526988,97.20796036392687,97.2036949178692,
	97.19944971573953,97.19522456883192,97.19101929104339,97.18683369882667,97.18266761114394,
	97.17852084942139,97.17439323750534,97.17028460161872,97.16619477031888,97.16212357445632,
	97.15807084713747,97.15403642367255,97.15002014155485,97.14602184041144,97.1420413619688,
	97.1380785500167,97.13413325037261,97.13020531084699,97.12629458120935,97.12240091315496,
	97.11852416027219,97.11466417801087,97.11082082365073,97.10699395627115,97.10318343672104,
	97.09938912758946,97.09561089317714,97.09184859946807,97.08810211410213,97.084371306348,
	97.08065604707674,97.07695620873584,97.07327166532384,97.06960229236539,97.0659479668869,
	97.06230856739258,97.05868397384104,97.05507406762221,97.051478731535,97.04789784976487,
	97.04433130786258,97.04077899272251,97.03724079256224,97.03371659690178,97.03020629654372,
	97.02670978355351,97.02322695124009,97.0197576941371,97.01630190798429,97.01285948970916,
	97.00943033740927,97.0060143503346,97.0026114288703,96.99922147451984,96.99584438988853,
	96.99248007866703,96.98912844561545,96.98578939654767,96.98246283831605,96.97914867879608,
	96.97584682687166,96.9725571924205,96.9692796862998,96.96601422033213,96.96276070729172,
	96.95951906089076,96.95628919576605,96.9530710274662,96.94986447243832,96.94666944801571,
	96.9434858724053,96.94031366467547,96.93715274474411,96.93400303336665,96.93086445212478,
	96.92773692341478,96.9246203704326,96.92151471717752,96.91841988842033,96.91533580970612,
	96.9122624073406,96.90919960837985,96.90614734062012,96.90310553258801,96.90007411353066,
	96.89705301340615,96.89404216287397,96.89104149328594,96.88805093667679,96.88507042575546,
	96.882099893896,96.87913927512898,96.87618850413304,96.8732475162263,96.87031624735818,
	96.86739463410113,96.86448261364285,96.86158012377808,96.85868710290114,96.85580348999808,
	96.85292922463923,96.8500642469718,96.84720849771259,96.84436191814086,96.84152445009117,
	96.8386960359465,96.83587661863143,96.83306614160531,96.83026454885577,96.82747178489207,
	96.82468779473867,96.82191252392899,96.81914591849912,96.81638792498167,96.81363849039975,
	96.810897562261,96.80816508855173,96.80544101773111,96.80272529872558,96.80001788092314,
	96.79731871416779,96.79462774875432,96.79194493542266,96.78927022535278,96.78660357015941,
	96.78394492188708,96.78129423300477,96.77865145640114,96.77601654537963,96.77338945365358,
	96.77077013534141,96.76815854496202,96.7655546374301,96.76295836805163,96.76036969251936,
	96.75778856690826,96.75521494767142,96.75264879163547,96.75009005599642,96.74753869831568,
	96.74499467651553,96.74245794887541,96.73992847402417,96.73740621094971,96.7348911189758,
	96.73238315777027,96.72988228733863,96.72738846802011,96.7249016604841,96.7224218257263,
	96.7199489250654,96.71748292013936,96.71502377290199,96.71257144561949,96.71012590086701,
	96.70768710152537,96.7052550107777,96.70282959210627,96.70041080928911,96.69799862639695,
	96.6955930077901,96.69319391811533,96.69080132230275,96.6884151855629,96.68603547338377,
	96.6836621515278,96.68129518602909,96.67893454319035,96.6765801895804,96.6742320920311,
	96.67189021763473,96.66955453374125,96.6672250079557,96.66490160813544,96.66258430238764,
	96.6602730590667,96.65796784677161,96.6556686343436,96.65337539086352,96.65108808564946,
	96.64880668825447,96.6465311684639,96.64426149629321,96.64199764198574,96.63973957601019,
	96.63748726905854,96.63524069204375,96.63299981609755,96.63076461256826,96.6285350530186,
	96.62631110922365,96.62409275316872,96.62187995704717,96.61967269325854,96.61747093440636,
	96.61527465329627,96.61308382293396,96.61089841652324,96.60871840746422,96.6065437693512,
	96.60437447597101,96.60221050130089,96.60005181950696,96.59789840494214,96.59575023214806,
	96.59360727583993,96.59146951092364,96.58933691248208,96.5872094557764,96.5850871162441,
	96.58296986949752,96.5808576913222,96.57875055767514,96.57664844468327,96.5745513286419,
	96.57245918601299,96.5703719934238,96.56828972766513,96.56621236569,96.56413988461203,
	96.56207226170399,96.56000947439634,96.55795150027575,96.55589831708375,96.55384990271519,
	96.55180623521689,96.54976729278629,96.54773305377009,96.54570349666277,96.54367860010544,
	96.54165834288432,96.53964270392957,96.53763166231401,96.53562519725166,96.5336232880967,
	96.5316259143421,96.52963305561833,96.52764469169227,96.52566080246595,96.52368136797524,
	96.52170636838885,96.51973578400704,96.51776959526052,96.51580778270926,96.51385032704137,
	96.51189720907198,96.50994840974215,96.50800391011781,96.5060636913885,96.50412773486661,
	96.50219602198594,96.50026853430099,96.49834525348571,96.49642616133252,96.49451123975139,
	96.49260047076869,96.49069383652636,96.48879131928066,96.48689290140155,96.48499856537146,
	96.48310829378089,96.48122206934067,96.47933987486238,96.4774616932692,96.47558750759232,
	96.47371730096967,96.47185105664542,96.46998875796893,96.46813038839392,96.46627593147741,
	96.46442537087921,96.46257869036073,96.46073587378439,96.45889690511262,96.45706176840716,
	96.45523044782817,96.45340292763342,96.4515791921775,96.44975922591114,96.4479430133802,
	96.4461305392251,96.44432178818,96.44251674507197,96.44071539482029,96.43891772243579,
	96.43712371301993,96.4353333517642,96.43354662394941,96.4317635149449,96.42998401020789,
	96.42820809528271,96.42643575580026,96.42466697747712,96.422901746115,96.4211400476,
	96.41938186790212,96.41762719307431,96.41587600925202,96.41412830265251,96.41238405957422,
	96.41064326639608,96.40890590957696,96.40717197565492,96.40544145124684,96.4037143230475,
	96.40199057782918,96.40027020244106,96.39855318380857,96.39683950893274,96.39512916488978,
	96.39342213882625,96.39171841797382,96.39001798962722,96.38832084115737,96.38662696000722,
	96.3849363336916,96.38324894979642,96.38156479597828,96.37988385996381,96.37820612954928,
	96.3765315926,96.37486023704976,96.37319205090041,96.3715270222213,96.36986513914877,
	96.36820638988567,96.36655076270084,96.36489824592869,96.36324882796862,96.36160249728454,
	96.35995924240457,96.35831905192026,96.35668191448644,96.35504781882052,96.35341675370219,
	96.3517887079728,96.35016367053508,96.34854163035263,96.34692257644934,96.34530649790925,
	96.34369338387584,96.34208322355168,96.34047600619807,96.33887172113455,96.33727035773852,
	96.33567190544473,96.33407635374502,96.33248369218776,96.33089391037761,96.32930699797488,
	96.32772294469545,96.32614174030998,96.32456337464393,96.32298783758054,96.32141511904724,
	96.31984520903362,96.31827809757974,96.31671377477836,96.31515223077463,96.31359345576558,
	96.31203743999988,96.3104841737775,96.30893364744924,96.30738585141648,96.30584077613078,
	96.3042984120935,96.30275874985557,96.301221780017,96.29968749322661,96.29815588018178,
	96.29662693162788,96.29510063835825,96.29357699121363,96.29205598108186,96.29053759889776,
	96.28902183564253,96.28750868234367,96.28599813007449,96.28449016995387,96.28298479314606,
	96.28148199086012,96.27998175434985,96.27848407491337,96.27698894389292,96.27549635267441,
	96.27400629268725,96.27251875540404,96.2710337323403,96.26955121505407,96.26807119514578,
	96.2665936642579,96.26511861407117,96.26364603631684,96.26217592275931,96.26070826520633,
	96.25924305550629,96.25778028554801,96.25631994726038,96.25486203261225,96.25340653361194,
	96.25195344230724,96.25050275078489,96.24905445117055,96.24760853562846,96.24616499636105,
	96.24472382560904,96.24328501565076,96.2418485588023,96.240414447417,96.23898267388526,
	96.23755323063446,96.23612611012848,96.23470130486767,96.23327880738847,96.23185861026332,
	96.23044070610028,96.22902508754292,96.22761174727003,96.22620067799544,96.22479187246772,
	96.22338532347013,96.22198102382018,96.22057896636956,96.21917914400392,96.21778154964264,
	96.21638617623466,96.21499301677223,96.21360206427185,96.21221331178552,96.21082675239789,
	96.20944237922609,96.20806018541948,96.20668016415951,96.2053023086595,96.20392661216434,
	96.20255306795042,96.20118166932549,96.1998124096283,96.19844528222836,96.19708028052612,
	96.1957173979524,96.19435662796823,96.192997964065,96.19164139976388,96.19028692861583,
	96.18893454420147,96.1875842401307,96.18623601004275,96.18488984760577,96.18354574651691,
	96.18220370050192,96.18086370331507,96.17952574873893,96.1781898305843,96.17685594268985,
	96.1755240789264,96.17419423318182,96.1728663993807,96.17154057147226,96.17021674343286,
	96.16889490926586,96.16757506300158,96.16625719869688,96.16494131043528,96.16362739232665,
	96.16231543850704,96.16100544313862,96.15969740040943,96.15839130453331,96.15708714974964,
	96.1557849303234,96.15448464054471,96.15318627472897,96.15188982721652,96.15059529237264,
	96.14930266458728,96.14801193827499,96.14672310787478,96.14543616784994,96.14415111268796,
	96.1428679369004,96.14158663502273,96.14030720160929,96.13902963124993,96.13775391854773,
	96.13648005813214,96.13520804465576,96.13393787279423,96.13266953724623,96.1314030327331,
	96.13013835399889,96.1288754958102,96.12761445295608,96.1263552202478,96.12509779251879,
	96.12384216462452,96.12258833144237,96.12133628787153,96.12008602883276,96.11883754926845,
	96.11759084414237,96.11634590843958,96.11510273716634,96.11386132535007,96.11262166803907,
	96.11138376030267,96.11014759722562,96.10891317392569,96.10768048553058,96.10644952719149,
	96.10522029407981,96.10399278138709,96.10276698432489,96.10154289812465,96.10032051803765,
	96.09909983933487,96.09788085730682,96.09666356726358,96.09544796453443,96.09423404446812,
	96.09302180243243,96.09181123381418,96.09060233401921,96.08939509847208,96.08818952261613,
	96.08698560191334,96.08578333184403,96.08458270791047,96.08338372562524,96.0821863805259,
	96.08099066816614,96.07979658411767,96.0786041239703,96.07741328333154,96.07622405782664,
	96.07503644309864,96.07385043480802,96.07266602863281,96.07148322026833,96.07030200542731,
	96.0691223798395,96.0679443392519,96.06676787942841,96.06559299615,96.06441968521436,
	96.06324794243608,96.06207776364651,96.06090914468945,96.05974208143442,96.05857656975975,
	96.05741260556226,96.05625018475492,96.05508930326688,96.05392995704327,96.05277214204531,
	96.05161585424995,96.05046108965001,96.04930784425403,96.04815611408615,96.04700589518608,
	96.04585718360899,96.04470997542546,96.04356426672145,96.04242005359814,96.04127733217211,
	96.04013609857098,96.0389963489462,96.03785807945692,96.03672128627923,96.03558596560396,
	96.03445211363656,96.03331972659721,96.03218880072055,96.03105933225568,96.02993131746615,
	96.02880475262978,96.02767963403858,96.02655595799882,96.02543372083075,96.02431291886867,
	96.0231935484607,96.02207560596854,96.0209590877734,96.01984399025798,96.01873030982847,
	96.01761804290192,96.01650718590892,96.01539773529353,96.01428968751323,96.01318303903881,
	96.0120777863543,96.01097392595703,96.0098714543574,96.0087703680789,96.00767066365813,
	96.00657233764466,96.00547538660128,96.00437980709896,96.00328559573103,96.00219274909595,
	96.00110126380696,96.0000111364897,95.99892236378253,95.997834942336,95.99674886881327,
	95.99566413988967,95.99458075225286,95.99349870260265,95.9924179876511,95.99133860412242,
	95.9902605487531,95.98918381828759,95.98810840949041,95.98703431913155,95.98596154399462,
	95.98489008087488,95.9838199265792,95.98275107792624,95.98168353174607,95.98061728488035,
	95.97955233418206,95.9784886765157,95.97742630875688,95.97636522779233,95.97530543052319,
	95.97424691385535,95.97318967471078,95.97213371002114,95.97107901672913,95.97002559178844,
	95.96897343216362,95.96792253483007,95.96687289677403,95.96582451499256,95.96477738649347,
	95.96373150829531,95.96268687742788,95.96164349092491,95.96060134584368,95.95956043924194,
	95.95852076819052,95.95748232977068,95.95644512107398,95.9554091392021,95.95437438126716,
	95.95334084439135,95.95230852570704,95.95127742235712,95.9502475314908,95.94921885027425,
	95.9481913758784,95.9471651054853,95.94614003628699,95.9451161654852,95.94409349029151,
	95.94307200792709,95.94205171562274,95.9410326106188,95.94001469016469,95.93899795152372,
	95.93798239196038,95.93696800875485,95.93595479919499,95.93494276057802,95.93393189021045,
	95.93292218540815,95.93191364349606,95.93090626180856,95.92990003768948,95.92889496848841,
	95.92789105157016,95.926888284304,95.9258866640694,95.9248861882547,95.92388685425725,
	95.92288865948309,95.92189160134727,95.92089567727368,95.91990088469558,95.91890722104962,
	95.91791468379087,95.91692327037579,95.91593297827131,95.914943804953,95.91395574790478,
	95.91296880461908,95.91198297259665,95.91099824934597,95.91001463238835,95.9090321192454,
	95.9080507074529,95.9070703945532,95.90609117809699,95.90511305564303,95.90413602475829,
	95.90316008301802,95.9021852280065,95.90121145730889,95.90023876853107,95.8992671592776,
	95.89829662716339,95.89732716981128,95.89635878485191,95.89539146992392,95.89442522267439,
	95.8934600407533,95.89249592182689,95.89153286356286,95.89057086363823,95.88960991973757,
	95.88865002955306,95.88769119078417,95.88673340113702,95.88577665833135,95.88482096008359,
	95.88386630412536,95.88291268819353,95.88196011003244,95.88100856739374,95.8800580580368,
	95.87910857972568,95.87816013023603,95.87721270734758,95.87626630884805,95.87532093253225,
	95.87437657620217,95.87343323766721,95.87249091474187,95.87154960525082,95.87060930702353,
	95.86967001789696,95.86873173571499,95.86779445832832,95.86685818359412,95.86592290937868,
	95.86498863355132,95.8640553539907,95.86312306858164,95.86219177521563,95.86126147179101,
	95.86033215621362,95.85940382639096,95.85847648024539,95.8575501157001,95.8566247306863,
	95.85570032314175,95.85477689101113,95.85385443224327,95.85293294479729,95.85201242663604,
	95.85109287572935,95.85017429005359,95.84925666759081,95.84834000633153,95.84742430426927,
	95.84650955940603,95.84559576974948,95.84468293331354,95.84377104811881,95.84286011218947,
	95.84195012356,95.84104108026801,95.84013298035806,95.8392258218808,95.83831960289412,
	95.83741432145585,95.83650997563947,95.83560656351786,95.83470408317132,95.83380253268577,
	95.83290191015489,95.83200221367522,95.83110344135109,95.83020559129223,95.82930866161432,
	95.82841265043791,95.82751755589061,95.82662337610492,95.8257301092192,95.82483775337765,
	95.82394630673215,95.8230557674302,95.82216613364089,95.82127740352786,95.82038957526298,
	95.81950264702434,95.81861661699442,95.81773148336194,95.81684724432098,95.81596389807127,
	95.81508144281656,95.81419987676828,95.81331919814168,95.81243940515782,95.81156049604394,
	95.81068246902856
	}},
	{ // Ri = 250k
	-25,25,40,2001, {
	228.35363740496678,228.28468348365752,228.21558796265822,228.14635082183173,228.07697204160016,
	228.00745160294287,227.9377894873946,227.86798567704355,227.79804015452928,227.72795290304072,
	227.6577239063145,227.58735314863253,227.51684061482038,227.446186290245,227.375390160813,
	227.30445221296853,227.23337243369122,227.16215081049424,227.0907873314223,227.0192819850497,
	226.9476347604782,226.875845647335,226.803914635771,226.7318417164583,226.65962688058858,
	226.58727011987088,226.5147714265298,226.44213079330305,226.36934821343988,226.2964236806986,
	226.22335718934514,226.1501487341503,226.07679831038823,226.00330591383423,225.9296715407627,
	225.8558951879451,225.78197685264783,225.70791653263035,225.633714226143,225.55936993192503,
	225.48488364920252,225.4102553776863,225.3354851175699,225.2605728695276,225.1855186347123,
	225.11032241475343,225.03498421175496,224.9595040282934,224.8838818674155,224.80811773263667,
	224.7322116279384,224.65616355776652,224.5799735270291,224.5036415410944,224.42716760578867,
	224.3505517273944,224.273793912648,224.19689416873788,224.11985250330235,224.0426689244276,
	223.96534344064574,223.88787606093254,223.8102667947056,223.7325156518222,223.65462264257735,
	223.57658777770155,223.498411068359,223.42009252614548,223.34163216308622,223.26302999163397,
	223.184286024667,223.10540027548691,223.02637275781672,222.94720348579895,222.8678924739934,
	222.78843973737528,222.70884529133306,222.6291091516665,222.54923133458482,222.46921185670433,
	222.38905073504685,222.30874798703735,222.2283036305021,222.14771768366668,222.06699016515398,
	221.98612109398212,221.90511048956276,221.82395837169858,221.74266476058185,221.66122967679206,
	221.57965314129422,221.49793517543668,221.4160758009493,221.33407503994135,221.25193291489973,
	221.1696494486869,221.08722466453884,221.00465858606339,220.92195123723795,220.83910264240777,
	220.75611282628395,220.67298181394148,220.5897096308174,220.50629630270876,220.4227418557708,
	220.3390463165149,220.25520971180683,220.17123206886473,220.08711341525728,220.00285377890174,
	219.9184531880621,219.83391167134718,219.74922925770875,219.66440597643958,219.57944185717167,
	219.4943369298744,219.4090912248525,219.32370477274435,219.23817760452008,219.15250975147967,
	219.06670124525124,218.98075211778902,218.89466240137162,218.80843212860032,218.72206133239698,
	218.6355500460024,218.54889830297464,218.46210613718677,218.37517358282557,218.2881006743895,
	218.20088744668678,218.11353393483387,218.02604017425355,217.93840620067323,217.85063205012304,
	217.76271775893412,217.674663363737,217.58646890145977,217.49813440932618,217.40965992485414,
	217.321045485854,217.23229113042646,217.14339689696124,217.05436282413535,216.965188950911,
	216.87587531653452,216.78642196053397,216.69682892271808,216.60709624317414,216.51722396226643,
	216.42721212063472,216.33706075919244,216.24676991912506,216.15633964188848,216.06576996920728,
	215.97506094307326,215.88421260574373,215.79322499973972,215.7020981678446,215.6108321531025,
	215.51942699881647,215.42788274854706,215.33619944611067,215.2443771355779,215.15241586127223,
	215.06031566776815,214.96807659988977,214.8756987027092,214.78318202154506,214.69052660196087,
	214.59773248976367,214.50479973100218,214.4117283719656,214.318518459182,214.22517003941672,
	214.13168315967098,214.03805786718038,213.94429420941333,213.8503922340697,213.7563519890792,
	213.6621735226001,213.56785688301767,213.4734021189426,213.37880927920995,213.28407841287725,
	213.18920956922338,213.09420279774707,212.99905814816552,212.9037756704129,212.80835541463904,
	212.71279743120812,212.617101770697,212.52126848389412,212.42529762179817,212.32918923561644,
	212.23294337676373,212.13656009686096,212.04003944773365,211.9433814814109,211.84658625012386,
	211.7496538063044,211.65258420258388,211.55537749179192,211.45803372695494,211.36055296129504,
	211.26293524822867,211.16518064136523,211.06728919450603,210.96926096164293,210.87109599695717,
	210.77279435481785,210.67435608978116,210.57578125658873,210.47706991016682,210.3782221056247,
	210.27923789825377,210.18011734352626,210.08086049709397,209.9814674147873,209.88193815261377,
	209.78227276675727,209.6824713135765,209.5825338496042,209.48246043154566,209.3822511162779,
	209.28190596084826,209.18142502247366,209.0808083585392,208.9800560265971,208.87916808436572,
	208.7781445897284,208.6769856007325,208.5756911755881,208.47426137266729,208.37269625050277,
	208.27099586778715,208.16916028337147,208.06718955626485,207.96508374563265,207.86284291079627,
	207.76046711123152,207.65795640656793,207.55531085658788,207.45253052122527,207.34961546056482,
	207.2465657348411,207.14338140443746,207.04006252988515,206.93660917186244,206.8330213911936,
	206.72929924884795,206.6254428059392,206.52145212372426,206.41732726360243,206.31306828711465,
	206.2086752559424,206.10414823190703,205.99948727696875,205.89469245322593,205.7897638229141,
	205.6847014484052,205.57950539220673,205.47417571696096,205.3687124854441,205.26311576056537,
	205.1573856053665,205.05152208302064,204.94552525683173,204.83939519023374,204.7331319467899,
	204.6267355901918,204.52020618425888,204.41354379293742,204.30674848030014,204.19982031054525,
	204.0927593479957,203.98556565709856,203.87823930242453,203.77078034866682,203.6631888606407,
	203.555464903283,203.4476085416511,203.33961984092252,203.2314988663941,203.12324568348163,
	203.01486035771882,202.9063429547571,202.7976935403646,202.68891218042594,202.5799989409414,
	202.47095388802623,202.36177708791033,202.2524686069375,202.143028511565,202.03345686836283,
	201.9237537440134,201.81391920531067,201.70395331915992,201.59385615257716,201.48362777268846,
	201.37326824672962,201.26277764204573,201.15215602609024,201.04140346642498,200.9305200307196,
	200.81950578675077,200.70836080240215,200.5970851456636,200.48567888463106,200.3741420875057,
	200.26247482259396,200.15067715830682,200.0387491631594,199.92669090577084,199.81450245486357,
	199.70218387926312,199.58973524789775,199.4771566297979,199.36444809409608,199.25160971002634,
	199.1386415469242,199.02554367422582,198.91231616146808,198.7989590782883,198.68547249442366,
	198.57185647971104,198.45811110408678,198.3442364375863,198.23023255034383,198.1160995125923,
	198.00183739466294,197.887446266985,197.77292620008558,197.65827726458943,197.5434995312188,
	197.42859307079289,197.313557954228,197.19839425253727,197.0831020368303,196.96768137831316,
	196.8521323482882,196.73645501815378,196.62064945940418,196.50471574362953,196.38865394251553,
	196.27246412784342,196.15614637148985,196.0397007454267,195.92312732172107,195.80642617253514,
	195.68959737012608,195.57264098684598,195.45555709514178,195.33834576755524,195.22100707672288,
	195.1035410953759,194.98594789634,194.86822755253587,194.75038013697858,194.63240572277786,
	194.5143043831381,194.39607619135822,194.277721220832,194.15923954504768,194.0406312375883,
	193.92189637213164,193.8030350224504,193.68404726241187,193.56493316597863,193.44569280720808,
	193.32632626025273,193.20683359936038,193.0872148988741,192.96747023323235,192.84759967696925,
	192.72760330471453,192.60748119119378,192.48723341122854,192.36686003973645,192.2463611517316,
	192.12573682232443,192.00498712672209,191.88411214022864,191.7631119382451,191.64198659626987,
	191.52073618989883,191.39936079482564,191.27786048684186,191.15623534183723,191.03448543580018,
	190.91261084481766,190.79061164507576,190.6684879128599,190.54623972455505,190.4238671566461,
	190.3013702857183,190.17874918845715,190.05600394164927,189.93313462218248,189.81014130704608,
	189.68702407333134,189.56378299823183,189.44041815904373,189.31692963316644,189.19331749810263,
	189.0695818314589,188.94572271094617,188.82174021437996,188.69763441968104,188.57340540487573,
	188.4490532480963,188.32457802758157,188.19997982167732,188.0752587088367,187.950414767621,
	187.82544807669967,187.7003587148513,187.57514676096383,187.44981229403524,187.32435539317405,
	187.19877613759988,187.07307460664384,186.94725087974942,186.82130503647275,186.69523715648344,
	186.56904731956502,186.44273560561544,186.31630209464814,186.18974686679206,186.06307000229282,
	185.93627158151295,185.80935168493284,185.68231039315128,185.55514778688615,185.427863946975,
	185.300458954376,185.17293289016837,185.0452858355533,184.91751787185459,184.78962908051932,
	184.6616195431188,184.53348934134905,184.4052385570318,184.27686727211514,184.14837556867434,
	184.01976352891273,183.8910312351623,183.76217876988477,183.6332062156722,183.50411365524798,
	183.37490117146763,183.2455688473196,183.11611676592622,182.98654501054457,182.8568536645674,
	182.72704281152392,182.59711253508078,182.46706291904297,182.33689404735495,182.20660600410113,
	182.07619887350745,181.9456727399417,181.8150276879151,181.6842638020828,181.55338116724516,
	181.42237986834868,181.291259990487,181.16002161890194,181.02866483898464,180.89718973627646,
	180.76559639647013,180.63388490541075,180.50205534909713,180.3701078136825,180.23804238547595,
	180.10585915094333,179.97355819670858,179.84113960955466,179.7086034764249,179.5759498844241,
	179.44317892081952,179.31029067304252,179.1772852286893,179.0441626755223,178.91092310147158,
	178.77756659463563,178.64409324328324,178.51050313585415,178.3767963609607,178.2429730073889,
	178.1090331641,177.9749769202315,177.84080436509865,177.70651558819569,177.57211067919724,
	177.43758972795973,177.30295282452263,177.16820005910992,177.0333315221314,176.89834730418417,
	176.76324749605422,176.62803218871738,176.49270147334119,176.35725544128638,176.22169418410797,
	176.08601779355706,175.9502263615822,175.814319980331,175.67829874215144,175.54216273959375,
	175.4059120654115,175.26954681256362,175.13306707421566,174.9964729437415,174.85976451472493,
	174.7229418809612,174.5860051364587,174.4489543754407,174.31178969234685,174.17451118183482,
	174.03711893878204,173.89961305828754,173.7619936356734,173.62426076648657,173.48641454650075,
	173.34845507171784,173.21038243836995,173.07219674292108,172.93389808206882,172.79548655274638,
	172.65696225212426,172.51832527761195,172.37957572686003,172.2407136977618,172.10173928845543,
	171.9626525973256,171.82345372300531,171.6841427643783,171.5447198205803,171.4051849910015,
	171.26553837528837,171.1257800733454,170.9859101853374,170.8459288116914,170.7058360530986,
	170.56563201051648,170.4253167851707,170.28489047855743,170.1443531924452,170.00370502887705,
	169.86294609017273,169.72207647893063,169.5810962980302,169.44000565063376,169.298804640189,
	169.15749337043093,169.0160719453842,168.87454046936526,168.73289904698467,168.59114778314924,
	168.44928678306428,168.30731615223618,168.16523599647417,168.02304642189316,167.88074753491574,
	167.73833944227462,167.59582225101508,167.4531960684972,167.31046100239826,167.1676171607153,
	167.02466465176747,166.88160358419833,166.73843406697858,166.59515620940834,166.45177012111958,
	166.3082759120789,166.16467369258987,166.0209635732956,165.87714566518122,165.73322007957665,
	165.58918692815914,165.44504632295562,165.30079837634585,165.1564432010645,165.0119809102042,
	164.86741161721812,164.72273543592263,164.57795248050004,164.4330628655013,164.28806670584896,
	164.14296411683964,163.99775521414688,163.8524401138243,163.7070189323079,163.56149178641934,
	163.41585879336847,163.27012007075658,163.1242757365789,162.97832590922778,162.83227070749567,
	162.68611025057777,162.53984465807537,162.39347404999862,162.24699854676953,162.10041826922532,
	161.95373333862096,161.8069438766327,161.66005000536086,161.51305184733314,161.36594952550763,
	161.218743163276,161.07143288446667,160.924018813348,160.77650107463148,160.628879793475,
	160.48115509548614,160.33332710672522,160.1853959537088,160.037361763413,159.88922466327674,
	159.74098478120504,159.5926422455725,159.4441971852267,159.29564972949152,159.14700000817058,
	158.99824815155085,158.84939429040585,158.70043855599948,158.55138108008916,158.40222199492968,
	158.25296143327665,158.10359952839005,157.95413641403775,157.8045722244994,157.6549070945698,
	157.50514115956273,157.3552745553145,157.2053074181878,157.05523988507537,156.90507209340373,
	156.75480418113693,156.6044362867805,156.45396854938505,156.3034011085503,156.1527341044288,
	156.00196767772982,155.85110196972357,155.70013712224457,155.54907327769607,155.3979105790538,
	155.24664916987007,155.0952891942777,154.94383079699426,154.79227412332577,154.6406193191711,
	154.48886653102613,154.33701590598756,154.18506759175733,154.0330217366467,153.8808784895806,
	153.72863800010154,153.5763004183742,153.42386589518966,153.27133458196943,153.11870663077005,
	152.9659821942873,152.81316142586073,152.6602444794778,152.50723150977856,152.35412267205982,
	152.20091812227994,152.04761801706306,151.8942225137037,151.7407317701714,151.58714594511508,
	151.4334651978679,151.27968968845147,151.125819577581,150.9718550266696,150.81779619783296,
	150.66364325389438,150.50939635838904,150.35505567556928,150.20062137040904,150.0460936086086,
	149.89147255659978,149.73675838155054,149.58195125136993,149.42705133471298,149.27205880098558,
	149.11697382034967,148.9617965637281,148.8065272028095,148.65116591005344,148.49571285869553,
	148.34016822275262,148.1845321770275,148.0288048971147,147.87298655940484,147.71707734109066,
	147.56107742017153,147.40498697545922,147.24880618658287,147.0925352339943,146.93617429897355,
	146.77972356363404,146.62318321092795,146.4665534246517,146.3098343894513,146.15302629082788,
	145.99612931514307,145.83914364962465,145.68206948237193,145.5249070023614,145.36765639945224,
	145.21031786439212,145.0528915888225,144.89537776528456,144.73777658722486,144.58008824900097,
	144.42231294588723,144.2644508740805,144.10650223070613,143.9484672138235,143.79034602243198,
	143.632138856477,143.47384591685557,143.31546740542254,143.1570035249963,142.998454479365,
	142.83982047329235,142.68110171252374,142.52229840379232,142.36341075482497,142.20443897434845,
	142.0453832720957,141.88624385881178,141.72702094626015,141.56771474722885,141.40832547553669,
	141.24885334603974,141.08929857463735,140.92966137827867,140.76994197496867,140.61014058377503,
	140.45025742483404,140.29029271935718,140.13024668963783,139.9701195590572,139.8099115520913,
	139.64962289431742,139.48925381242017,139.32880453419872,139.16827528857306,139.00766630559056,
	138.84697781643277,138.68621005342197,138.5253632500281,138.36443764087514,138.20343346174803,
	138.04235094959952,137.8811903425568,137.71995187992852,137.55863580221126,137.39724235109676,
	137.23577176947887,137.0742243014599,136.91260019235835,136.75089968871515,136.58912303830104,
	136.42727049012353,136.26534229443382,136.10333870273408,135.94125996778405,135.77910634360885,
	135.6168780855053,135.45457545004982,135.29219869510504,135.12974807982727,134.9672238646735,
	134.804626311409,134.64195568311408,134.47921224419184,134.31639626037497,134.15350799873363,
	133.99054772768224,133.82751571698725,133.66441223777426,133.50123756253552,133.33799196513738,
	133.17467572082757,133.01128910624288,132.84783239941643,132.68430587978528,132.52070982819797,
	132.35704452692175,132.19331025965056,132.02950731151242,131.86563596907683,131.70169652036262,
	131.53768925484542,131.37361446346537,131.2094724386347,131.04526347424542,130.88098786567704,
	130.71664590980424,130.5522379050045,130.38776415116592,130.22322494969495,130.05862060352408,
	129.8939514171197,129.72921769648968,129.56441974919147,129.39955788433963,129.2346324126138,
	129.0696436462664,128.90459189913057,128.73947748662806,128.5743007257769,128.40906193519945,
	128.24376143513018,128.0783995474236,127.91297659556216,127.74749290466411,127.58194880149144,
	127.4163446144578,127.25068067363637,127.08495731076795,126.91917485926868,126.75333365423815,
	126.58743403246729,126.42147633244625,126.25546089437252,126.08938806015871,125.92325817344067,
	125.75707157958533,125.59082862569863,125.4245296606338,125.25817503499883,125.09176510116488,
	124.925300213274,124.75878072724714,124.59220700079219,124.42557939341184,124.25889826641162,
	124.09216398290779,123.92537690783529,123.75853740795576,123.59164585186538,123.42470261000292,
	123.25770805465757,123.09066255997675,122.92356650197448,122.7564202585386,122.5892242094393,
	122.4219787363366,122.25468422278836,122.08734105425819,121.91994961812321,121.75251030368203,
	121.58502350216234,121.41748960672895,121.2499090124916,121.08228211651256,120.91460931781462,
	120.74689101738868,120.57912761820175,120.41131952520446,120.24346714533894,120.07557088754662,
	119.90763116277574,119.73964838398932,119.57162296617288,119.40355532634197,119.23544588355027,
	119.0672950588971,118.89910327553545,118.73087095867969,118.56259853561367,118.39428643569867,
	118.22593509038144,118.0575449332026,117.88911639980502,117.72064992794236,117.55214595748812,
	117.38360493044475,117.21502729095317,117.04641348530319,116.87776396194383,116.70907917149509,
	116.54035956675996,116.37160560273819,116.20281773664092,116.0339964279071,115.865142138222,
	115.69625533153813,115.52733647409892,115.3583860344665,115.18940448355325,115.02039229465937,
	114.85134994351641,114.68227790833899,114.51317666988614,114.34404671153426,114.1748885193642,
	114.0057025822658,113.8364893920631,113.66724944366526,113.49798323524814,113.32869126847349,
	113.15937404875363,112.99003208557146,112.82066589286752,112.65127598950849,112.48186289985489,
	112.31242715444832,112.14296929084506,111.97348985462624,111.80398940062264,111.63446849440086,
	111.46492771406506,111.2953676524434,111.12578891974047,110.95619214675517,110.78657798878578,
	110.61694713036778,110.44730029102308,110.27763823223644,110.10796176592012,109.93827176468567,
	109.7685691743061,109.59885502883665,109.42913046895916,109.25939676423471,109.08965534009614,
	108.91990781058348,108.75015601803882,108.58040208123046,108.41064845368057,108.2408979943401,
	108.07115405319135,107.90142057488661,107.7317022241532,107.56200453743678,107.39233410612509,
	107.22269879771252,107.05310802244388,106.88357305432413,106.71410741689489,106.54472734584593,
	106.37545234230205,106.20630583242401,106.03731595063962,105.86851646514975,105.6999478649849,
	105.53165862730259,105.36370668109447,105.19616107802406,105.02910387146245,104.86263218937094,
	104.69686046371582,104.53192274688449,104.36797500285104,104.20519720764666,104.0437950324185,
	103.88400081912697,103.72607350492193,103.57029712326175,103.41697752920729,103.26643708482212,
	103.11900721303631,102.97501898265499,102.8347921956415,102.69862375452942,102.56677631810429,
	102.4394683354381,102.31686644029145,102.19908089897062,102.08616439669662,101.97811401478398,
	101.87487588759122,101.7763517983271,101.6824068959459,101.5928777708765,101.5075802707488,
	101.42631661917922,101.3488815804613,101.27506756495897,101.2046686830078,101.13748382888122,
	101.07331891677944,101.01198840615915,100.95331625224792,100.89713640612942,100.84329297244761,
	100.79164011493253,100.74204178284192,100.69437131592042,100.64851097232518,100.60435141303148,
	100.56179116744497,100.52073609801862,100.48109887631217,100.44279847885134,100.40575970808716,
	100.36991274150236,100.33519271027889,100.30153930778208,100.26889642731764,100.23721182808298,
	100.20643682789901,100.1765260211136,100.14743701997816,100.11913021777856,100.09156857203051,
	100.06471740613144,100.03854422788123,100.01301856349254,99.9881118056908,99.96379707468398,
	99.94004909085255,99.91684405811274,99.89415955699373,99.87197444655696,99.85026877436299,
	99.8290236937646,99.80822138787144,99.78784499959254,99.7678785672184,99.74830696505452,
	99.72911584866473,99.7102916043235,99.69182130231378,99.67369265374158,99.65589397056797,
	99.63841412858805,99.62124253311013,99.60436908711188,99.58778416167021,99.57147856847966,
	99.55544353429123,99.53967067711838,99.52415198407009,99.50887979068392,99.49384676164253,
	99.47904587276695,99.46447039419016,99.4501138746212,99.43597012661613,99.42203321279835,
	99.40829743291428,99.39475731172527,99.38140758762799,99.36824320197074,99.35525928901409,
	99.34245116649026,99.32981432671976,99.31734442824758,99.30503728796339,99.29288887367309,
	99.28089529709202,99.2690528072316,99.25735778415421,99.24580673307176,99.23439627876655,
	99.22312316031373,99.21198422608595,99.20097642902333,99.19009682215163,99.17934255433394,
	99.16871086624116,99.1581990865288,99.1478046282069,99.1375249851925,99.12735772903328,
	99.11730050579294,99.10735103308836,99.09750709727066,99.08776655074128,99.0781273093959,
	99.06858735018892,99.05914470881187,99.04979747747944,99.04054380281754,99.03138188384735,
	99.02230997006082,99.01332635958241,99.00442939741254,98.99561747374865,98.98688902237977,
	98.97824251915064,98.96967648049214,98.96118946201456,98.95278005716028,98.94444689591344,
	98.9361886435632,98.92800399951841,98.91989169617099,98.91185049780549,98.9038791995531,
	98.89597662638745,98.88814163216053,98.88037309867417,98.87266993480165,98.8650310756154,
	98.8574554815776,98.84994213774668,98.8424900530176,98.83509825939058,98.82776581126747,
	98.82049178477452,98.81327527711002,98.80611540591633,98.79901130867464,98.7919621421218,
	98.78496708168822,98.77802532095593,98.77113607113587,98.76429856056382,98.75751203421389,
	98.75077575322898,98.74408899446789,98.7374510500674,98.73086122701994,98.72431884676527,
	98.71782324479607,98.71137377027682,98.70496978567526,98.69861066640627,98.69229580048724,
	98.686024588205,98.67979644179336,98.67361078512101,98.66746705339004,98.6613646928431,
	98.65530316048091,98.64928192378784,98.64330046046662,98.63735825818114,98.63145481430718,
	98.62558963569094,98.61976223841489,98.61397214757082,98.60821889703959,98.60250202927772,
	98.59682109511034,98.5911756535302,98.5855652715026,98.57998952377632,98.57444799269976,
	98.56894026804261,98.56346594682272,98.55802463313779,98.55261593800196,98.54723947918724,
	98.54189488106906,98.53658177447633,98.53129979654602,98.52604859058117,98.52082780591334,
	98.51563709776872,98.51047612713768,98.50534456064831,98.50024207044298,98.49516833405843,
	98.49012303430915,98.48510585917369,98.48011650168404,98.47515465981802,98.47022003639461,
	98.46531233897157,98.46043127974625,98.4555765754587,98.45074794729719,98.44594512080644,
	98.44116782579808,98.43641579625984,98.43168877028415,98.42698648996412,98.42230870132734,
	98.41765515425296,98.41302560239507,98.40841980310744,98.4038375173706,98.3992785097202,
	98.39474254817759,98.39022940418174,98.38573885252295,98.38127067127814,98.37682464174763,
	98.37240054839356,98.36799817877956,98.36361732351196,98.35925777618246,98.35491933331191,
	98.35060179429573,98.34630496135014,98.34202863946014,98.3377726363282,98.33353676232454,
	98.32932083043818,98.32512465622949,98.32094805778328,98.31679085566353,98.3126528728686,
	98.30853393478796,98.30443386915935,98.30035250602724,98.29628967770216,98.29224521872072,
	98.28821896580673,98.2842107578331,98.28022043578437,98.27624784272037,98.27229282374046,
	98.26835522594847,98.26443489841864,98.26053169216199,98.2566454600936,98.25277605700042,
	98.24892333950997,98.24508716605942,98.24126739686555,98.2374638938952,98.23367652083628,
	98.2299051430696,98.22614962764094,98.22240984323405,98.21868566014388,98.21497695025053,
	98.21128358699373,98.20760544534767,98.2039424017966,98.20029433431051,98.19666112232176,
	98.19304264670187,98.18943878973876,98.18584943511466,98.1822744678842,98.17871377445294,
	98.17516724255665,98.17163476124058,98.16811622083921,98.16461151295668,98.16112053044716,
	98.15764316739599,98.15417931910086,98.15072888205353,98.14729175392188,98.14386783353213,
	98.14045702085174,98.13705921697218,98.13367432409231,98.13030224550212,98.12694288556644,
	98.12359614970933,98.12026194439848,98.11694017713008,98.11363075641125,98.11033359175588,
	98.10704859365387,98.10377567356842,98.10051474391902,98.0972657180679,98.09402851030664,
	98.09080303584284,98.08758921078737,98.0843869521415,98.0811961777845,98.0780168064613,
	98.07484875777051,98.07169195215248,98.06854631087766,98.06541175603519,98.06228821052163,
	98.05917559802992,98.05607384303838,98.05298287080025,98.04990260733291,98.0468329794078,
	98.04377391454004,98.04072534097864,98.03768718769649,98.03465938438083,98.03164186142372,
	98.02863454991268,98.02563738162146,98.0226502890011,98.01967320517096,98.01670606390998,
	98.01374879964814,98.0108013474579,98.00786364304588,98.0049356227449,98.00201722350543,
	97.9991083828882,97.996209039056,97.99331913076617,97.99043859736302,97.98756737877034,
	97.98470541548414,97.98185264856541,97.97900901963291,97.97617447085648,97.97334894494979,
	97.97053238516386,97.96772473528024,97.96492593960454,97.96213594295985,97.95935469068046,
	97.95658212860555,97.95381820307313,97.9510628609138,97.94831604944106,97.94557771646168,
	97.94284781024352,97.94012627952895,97.93741307352391,97.93470814189247,97.93201143475129,
	97.92932290266418,97.92664249663689,97.9239701681118,97.92130586896285,97.91864955149049,
	97.91600116841644,97.91336067287911,97.91072801842844,97.90810315902137,97.90548604901683,
	97.90287664317142,97.90027489663456,97.89768076494407,97.89509420402176,97.8925151701677,
	97.88994362006214,97.88737951074918,97.88482279964404,97.88227344452385,97.87973140352476,
	97.87719663513388,97.87466909819469,97.8721487518931,97.86963555575896,97.86712946966088,
	97.86463045380275,97.86213846871985,97.85965347527527,97.85717543465626,97.85470430837074,
	97.85224005824378,97.84978264641404,97.84733203533054,97.844888187749,97.84245106672891,
	97.8400206356299,97.83759685810868,97.83517969811582,97.83276911989266,97.83036508796803,
	97.82796756715531,97.82557652254954,97.82319191952888,97.82081372373447,97.81844190109157,
	97.81607641779185,97.81371724029385,97.81136433532038,97.80901766985566,97.80667721114263,
	97.80434292668026,97.80201478422092,97.79969275176764,97.79737679757176,97.79506689013017,
	97.7927629981829,97.79046509071058,97.78817313693199,97.78588710630173,97.78360696850763,
	97.78133269346861,97.77906425133222,97.77680161247235,97.77454474748698,97.77229362719594,
	97.77004822263861,97.76780850507187,97.76557444596777,97.76334601701164,97.76112319009964,
	97.75890593733698,97.75669423103572,97.7544880437127,97.75228734808765,97.75009211708114,
	97.74790232381261,97.74571794159844,97.74353894395004,97.74136530457201,97.7391969973602,
	97.73703399639984,97.73487627596393,97.7327238105111,97.73057657468412,97.72843454330801,
	97.72629769138831,97.72416599410943,97.72203942683286,97.71991796509555,97.71780158460825,
	97.71569026125387,97.71358397108582,97.71148269032656,97.70938639536577,97.70729506275903,
	97.70520866922608,97.7031271916495,97.70105060707303,97.6989788927001,97.6969120258925,
	97.69484998416873,97.69279274520268,97.69074028682215,97.68869258700758,97.68664962389036,
	97.6846113757518,97.68257782102154,97.68054893827629,97.6785247062385,97.67650510377504,
	97.67449010989286,97.67247970374932,97.67047386463412,97.66847257197895,97.6664758053535,
	97.66448354446429,97.66249576915348,97.66051245939762,97.65853359530647,97.65655915712192,
	97.6545891252166,97.652623480093,97.65066220238215,97.64870527284256,97.64675267235916,
	97.64480438194201,97.64286038272543,97.64092065596687,97.63898518304568,97.6370539454623,
	97.63512692483704,97.63320410290918,97.63128546153578,97.62937098269084,97.62746064846424,
	97.62555444106067,97.6236523427988,97.62175433611024,97.61986040353851,97.61797052773825,
	97.61608469147416,97.61420287762003,97.61232506915812,97.61045124917783,97.60858140087511,
	97.6067155075514,97.6048535526129,97.60299551956955,97.6011413920343,97.5992911537221,
	97.5974447884493,97.5956022801325,97.59376361278802,97.59192877053087,97.59009773757408,
	97.58827049822776,97.58644703689846,97.58462733808831,97.58281138639418,97.580999166507,
	97.57919066321105,97.57738586138304,97.57558474599139,97.57378730209578,97.57199351484596,
	97.57020336948135,97.56841685133024,97.5666339458091,97.56485463842174,97.56307891475883,
	97.56130676049703,97.55953816139845,97.55777310330983,97.55601157216198,97.55425355396912,
	97.55249903482813,97.550748000918,97.54900043849912,97.54725633391269,97.54551567358007,
	97.54377844400213,97.54204463175871,97.54031422350786,97.53858720598541,97.53686356600431,
	97.53514329045393,97.53342636629961,97.53171278058198,97.53000252041646,97.52829557299263,
	97.52659192557373,97.52489156549595,97.52319448016806,97.52150065707077,97.5198100837562,
	97.51812274784727,97.51643863703725,97.51475773908925,97.51308004183555,97.5114055331773,
	97.5097342010838,97.50806603359209,97.5064010188064,97.50473914489774,97.50308040010329,
	97.50142477272597,97.4997722511339,97.49812282376003,97.49647647910156,97.4948332057194,
	97.49319299223791,97.4915558273443,97.48992169978816,97.48829059838097,97.48666251199582,
	97.48503742956682,97.48341534008858,97.48179623261603,97.48018009626368,97.47856692020545,
	97.47695669367408,97.47534940596066,97.47374504641446,97.47214360444224,97.470545069508,
	97.46894943113251,97.46735667889281,97.4657668024221,97.464179791409,97.46259563559734,
	97.46101432478578,97.4594358488273,97.45786019762895,97.45628736115137,97.45471732940844,
	97.45315009246698,97.45158564044623,97.45002396351762,97.44846505190435,97.44690889588097,
	97.44535548577313,97.44380481195712,97.44225686485967,97.44071163495737,97.43916911277657,
	97.43762928889282,97.4360921539307,97.43455769856338,97.43302591350877,97.4314967895431,
	97.42997031748011,97.42844648818418,97.42692529256661,97.42540672158535,97.42389076624468,
	97.42237741759499,97.42086666673231,97.41935850479797,97.4178529229786,97.41634991250547,
	97.4148494646544,97.41335157074533,97.41185622214215,97.41036341025232,97.40887312652661,
	97.40738536245878,97.4059001095853,97.40441735948514,97.40293710377937,97.40145933413092,
	97.39998404224441,97.39851121986568,97.39704085878168,97.39557295082008,97.3941074878492,
	97.3926444617774,97.39118386455313,97.38972568816456,97.38826992463932,97.38681656604417,
	97.38536560448486,97.38391703210586,97.38247084108998,97.38102702365833,97.37958557206986,
	97.37814647862128,97.37670973564667,97.3752753355174,97.3738432706418,97.37241353346487,
	97.37098611646815,97.3695610121694,97.36813821312245,97.36671771191688,97.36529950117792,
	97.36388357356601,97.36246992177685,97.3610585385409,97.3596494166234,97.35824254882397,
	97.35683792797647,97.35543554694883,97.35403539864275,97.35263747599349,97.35124177196975,
	97.34984827957331,97.34845699183903,97.34706790183445,97.34568100265965,97.34429628744711,
	97.34291374936144,97.34153338159912,97.3401551773885,97.33877912998942,97.33740523269302,
	97.33603347882176,97.33466386172891,97.3332963747986,97.3319310114455,97.3305677651148,
	97.3292066292817,97.32784759745162,97.32649066315977,97.32513581997098,97.32378306147956,
	97.32243238130924,97.32108377311272,97.31973723057177,97.31839274739689,97.31705031732714,
	97.31570993413007,97.31437159160147,97.31303528356518,97.31170100387301,97.31036874640448,
	97.30903850506671,97.30771027379424,97.30638404654884,97.30505981731937,97.30373758012166,
	97.3024173289983,97.30109905801847,97.29978276127778,97.29846843289818,97.29715606702773,
	97.29584565784049,97.29453719953639,97.29323068634096,97.29192611250528,97.29062347230588,
	97.28932276004444,97.2880239700477,97.2867270966675,97.28543213428026,97.28413907728715,
	97.28284792011387,97.28155865721043,97.28027128305104,97.27898579213402,97.27770217898168,
	97.27642043813998,97.27514056417876,97.27386255169115,97.27258639529383,97.27131208962668,
	97.27003962935271,97.26876900915795,97.26750022375123,97.26623326786412,97.26496813625084,
	97.26370482368802,97.26244332497468,97.26118363493201,97.25992574840332,97.25866966025389,
	97.25741536537076,97.2561628586628,97.2549121350604,97.25366318951546,97.25241601700118,
	97.25117061251201,97.24992697106357,97.24868508769238,97.24744495745591,97.24620657543232,
	97.24496993672051,97.24373503643977,97.24250186972992,97.24127043175108,97.24004071768348,
	97.23881272272745,97.23758644210334,97.23636187105126,97.23513900483117,97.23391783872259,
	97.23269836802459,97.23148058805566,97.23026449415359,97.22905008167542,97.22783734599726,
	97.22662628251418,97.22541688664023,97.2242091538082,97.2230030794696,97.22179865909443,
	97.22059588817132,97.21939476220716,97.21819527672723,97.21699742727492,97.21580120941175,
	97.21460661871721,97.21341365078874,97.21222230124147,97.21103256570831,97.2098444398398,
	97.20865791930396,97.20747299978618,97.20628967698921,97.20510794663316,97.20392780445505,
	97.20274924620914,97.20157226766655,97.20039686461533,97.19922303286027,97.19805076822286,
	97.19688006654123,97.19571092366995,97.1945433354801,97.19337729785906,97.19221280671046,
	97.19104985795414,97.18988844752599,97.18872857137787,97.18757022547767,97.18641340580903,
	97.18525810837133,97.18410432917966,97.18295206426471,97.18180130967265,97.18065206146505,
	97.17950431571889,97.17835806852638,97.17721331599493,97.17607005424705,97.17492827942361,
	97.17378798767068,97.17264917515874,97.17151183807002,97.17037597260138,97.16924157496442,
	97.16810864138523,97.16697716810448,97.16584715137718,97.1647185874728,97.16359147267502,
	97.1624658032817,97.16134157560491,97.16021878597071,97.15909743071921,97.15797750620442,
	97.1568590087942,97.15574193487016,97.15462628082767,97.15351204307571,97.15239921803685,
	97.15128780214717,97.15017779185618,97.14906918362674,97.14796197393501,97.14685615927047,
	97.14575173613564,97.14464870104625,97.14354705053101,97.14244678113164,97.14134788940277,
	97.1402503719118,97.13915422523907,97.13805944597745,97.1369660307326,97.13587397612272,
	97.1347832787786,97.13369393534342,97.13260594247278,97.13151929683468,97.13043399510937,
	97.12935003398935,97.12826741017926,97.12718612039583,97.1261061613679,97.12502752983627,
	97.12395022255365,97.12287423628463,97.12179956780565,97.12072621390489,97.11965417138215,
	97.11858343704905,97.11751400772864,97.11644588025555,97.11537905147593,97.11431351824729,
	97.11324927743853,97.11218632592987,97.1111246606128,97.11006427838994,97.10900517617516,
	97.10794735089335,97.10689079948047,97.10583551888348,97.10478150606025,97.10372875797958,
	97.10267727162105,97.10162704397509,97.10057807204278,97.09953035283596,97.098483883377,
	97.09743866069894,97.09639468184533,97.0953519438702,97.09431044383797,97.0932701788235,
	97.09223114591194,97.09119334219874,97.09015676478955,97.08912141080029,97.08808727735695,
	97.08705436159563,97.08602266066251,97.0849921717137,97.08396289191528,97.08293481844332,
	97.08190794848363,97.08088227923194,97.07985780789366,97.07883453168397,97.07781244782774,
	97.07679155355945,97.07577184612313,97.07475332277244,97.07373598077048,97.07271981738984,
	97.0717048299125,97.07069101562983,97.06967837184247,97.06866689586046,97.06765658500302,
	97.06664743659847,97.06563944798447,97.0646326165077,97.06362693952389,97.06262241439786,
	97.06161903850342,97.06061680922325,97.05961572394911,97.0586157800814,97.05761697502956,
	97.05661930621172,97.05562277105477,97.05462736699434,97.05363309147467,97.0526399419487,
	97.05164791587796,97.05065701073251,97.04966722399092,97.04867855314026,97.04769099567606,
	97.04670454910219,97.04571921093094,97.04473497868294,97.04375184988707,97.04276982208049,
	97.04178889280858,97.04080905962488,97.03983032009108,97.03885267177705,97.03787611226063,
	97.03690063912775,97.03592624997233,97.03495294239629,97.03398071400943,97.03300956242947,
	97.03203948528204,97.03107048020053,97.03010254482612,97.02913567680784,97.02816987380236,
	97.02720513347401,97.02624145349493,97.02527883154474,97.02431726531073,97.02335675248767,
	97.02239729077802,97.0214388778915,97.02048151154547,97.01952518946466,97.0185699093812,
	97.0176156690346,97.01666246617162,97.01571029854648,97.01475916392049,97.01380906006237,
	97.01285998474789,97.01191193576011,97.01096491088919,97.01001890793235,97.00907392469406,
	97.00812995898565,97.0071870086256,97.00624507143937,97.0053041452593,97.00436422792477,
	97.00342531728197,97.00248741118405,97.00155050749102,97.00061460406954,96.99967969879323,
	96.99874578954248,96.99781287420429,96.99688095067242,96.99595001684732,96.99502007063604,
	96.99409110995232,96.99316313271642,96.99223613685521,96.99131012030212,96.99038508099694,
	96.98946101688612,96.9885379259225,96.9876158060653,96.98669465528022,96.98577447153923,
	96.98485525282075,96.98393699710948,96.98301970239639,96.98210336667877,96.98118798796006,
	96.98027356425001,96.97936009356457,96.9784475739257,96.9775360033617,96.97662537990689,
	96.97571570160164,96.97480696649244,96.9738991726318,96.97299231807827,96.97208640089633,
	96.97118141915648,96.97027737093515,96.96937425431464,96.9684720673832,96.96757080823494,
	96.96667047496973,96.9657710656934,96.96487257851747,96.96397501155924,96.96307836294187,
	96.96218263079408,96.96128781325032,96.96039390845092,96.95950091454161,96.95860882967386,
	96.95771765200477,96.956827379697,96.95593801091881,96.95504954384397,96.95416197665173,
	96.95327530752691,96.95238953465979,96.95150465624606,96.95062067048696,96.94973757558891,
	96.94885536976402,96.94797405122952,96.94709361820811,96.9462140689278,96.94533540161842,
	96.94445761452523,96.94358070588882,96.94270467395829,96.94182951698792,96.94095523323722,
	96.94008182097085
	}}
};
table1d_imp<2001> tubetable2_SVEL34[2] __rt_data = {
	{ // Ri = 68k
	-25,25,40,2001, {
	3196.116471263702,3187.7926694823304,3179.501529796419,3171.2429006971893,3163.0166314504404,
	3154.8225720946275,3146.6605734359036,3138.530487045725,3130.4321652549615,3122.3654611497373,
	3114.330228570764,3106.326322103318,3098.35359707919,3090.411909569725,3082.5011163820845,
	3074.621075057046,3066.771643862369,3058.9526817913315,3051.1640485580315,3043.405604592295,
	3035.677211038612,3027.978729750823,3020.31002328738,3012.670954909351,3005.0613885758667,
	2997.481188940551,2989.9302213474684,2982.4083518285024,2974.9154470986964,2967.4513745524673,
	2960.0160022615396,2952.6091989701326,2945.2308340905506,2937.8807777022553,2930.558900545409,
	2923.265074019613,2915.999170178907,2908.7610617295363,2901.5506220256316,2894.367725065881,
	2887.21224549047,2880.0840585778174,2872.9830402397174,2865.909067020619,2858.862016091575,
	2851.8417652486314,2844.84819290912,2837.881178108112,2830.9406004954308,2824.026340331683,
	2817.138278486343,2810.2762964328917,2803.4402762473846,2796.6301006043445,2789.8456527728645,
	2783.086816614295,2776.3534765798036,2769.645517706132,2762.9628256121305,2756.3052864970223,
	2749.672787136504,2743.0652148801155,2736.4824576473375,2729.924403925818,2723.3909427672493,
	2716.8819637852375,2710.397357150997,2703.9370135926497,2697.500824390084,2691.08868137324,
	2684.700476918503,2678.336103946291,2671.995455918227,2665.6784268340707,2659.3849112283274,
	2653.114804168752,2646.8680012524324,2640.644398602936,2634.443892868024,2628.266381216688,
	2622.1117613369183,2615.9799314317593,2609.8707902180336,2603.784236921769,2597.7201712774695,
	2591.678493524661,2585.6591044040833,2579.6619051565435,2573.686797520855,2567.7336837283874,
	2561.802466502822,2555.8930490576504,2550.0053350914754,2544.1392287884078,2538.294634812739,
	2532.471458307026,2526.6696048920057,2520.8889806606203,2515.1294921772237,2509.391046475108,
	2503.6735510538942,2497.97691387733,2492.301043369598,2486.64584841412,2481.011238350953,
	2475.3971229744475,2469.8034125301897,2464.230017712296,2458.676849663174,2453.143819969179,
	2447.6308406581475,2442.1378241990337,2436.664683496823,2431.2113318929237,2425.7776831605397,
	2420.3636515042576,2414.9691515567247,2409.5940983764003,2404.2384074456872,2398.9019946691424,
	2393.5847763693932,2388.2866692869306,2383.007590577434,2377.7474578084875,2372.5061889590415,
	2367.283702415542,2362.079916970889,2356.8947518228692,2351.7281265699626,2346.5799612111628,
	2341.450176142973,2336.338692157628,2331.245430440472,2326.170312568447,2321.113260508292,
	2316.0741966133846,2311.053043622534,2306.049724657879,2301.0641632230995,2296.0962832000837,
	2291.1460088487565,2286.213264804238,2281.297976074253,2276.400068038194,2271.519466444787,
	2266.6560974102713,2261.8098874154566,2256.9807633056143,2252.168652286903,2247.3734819252327,
	2242.595180145216,2237.8336752258674,2233.0888958013243,2228.360770857117,2223.6492297295486,
	2218.9542021034,2214.27561801002,2209.6134078247383,2204.9675022671477,2200.3378323971847,
	2195.7243296143183,2191.1269256559276,2186.545552594383,2181.980142837235,2177.430629123436,
	2172.8969445229213,2168.379022434047,2163.8767965822813,2159.3902010195134,2154.919170119344,
	2150.4636385793196,2146.0235414156655,2141.5988139641927,2137.1893918774463,2132.795211122568,
	2128.4162079806893,2124.0523190451813,2119.703481219649,2115.3696317156014,2111.050708052984,
	2106.7466480557173,2102.4573898521894,2098.1828718737797,2093.9230328513236,2089.677811815264,
	2085.4471480938537,2081.2309813106954,2077.0292513843465,2072.84189852601,2068.6688632381715,
	2064.510086313155,2060.365508831721,2056.235072161293,2052.1187179546923,2048.016388148467,
	2043.928024961294,2039.8535708929649,2035.7929687225005,2031.746161506992,2027.7130925798203,
	2023.693705549417,2019.6879442975153,2015.6957529787383,2011.7170760175459,2007.7518581082372,
	2003.8000442130979,1999.8615795603828,1995.9364096441827,1992.0244802217087,1988.125737312694,
	1984.240127197881,1980.3675964182885,1976.5080917718858,1972.6615603147036,1968.8279493577122,
	1965.007206466623,1961.1992794598355,1957.404116407117,1953.6216656290974,1949.8518756951241,
	1946.0946954221902,1942.350073873639,1938.6179603583132,1934.8983044287186,1931.191055879713,
	1927.4961647481614,1923.8135813099136,1920.1432560809503,1916.4851398139872,1912.8391834984504,
	1909.2053383585228,1905.5835558527071,1901.9737876722077,1898.3759857395512,1894.7901022073459,
	1891.2160894576996,1887.6539001005112,1884.1034869724265,1880.564803135595,1877.037801876504,
	1873.5224367049123,1870.0186613525416,1866.5264297724414,1863.0456961366986,1859.5764148370515,
	1856.1185404816283,1852.6720278958096,1849.2368321200797,1845.812908408384,1842.4002122286045,
	1838.9986992600275,1835.6083253932736,1832.2290467281423,1828.860819573407,1825.5036004453275,
	1822.1573460671589,1818.8220133668146,1815.4975594773198,1812.1839417346132,1808.8811176771212,
	1805.5890450445088,1802.3076817766387,1799.0369860126102,1795.7769160895846,1792.5274305419953,
	1789.2884881002412,1786.0600476899338,1782.8420684308028,1779.6345096357868,1776.4373308098545,
	1773.2504916491166,1770.0739520398654,1766.9076720573482,1763.7516119652653,1760.605732214574,
	1757.4699934423552,1754.3443564710642,1751.2287823075867,1748.1232321422597,1745.0276673478538,
	1741.9420494783126,1738.8663402689033,1735.8005016341156,1732.7444956672598,1729.6982846395438,
	1726.6618309993507,1723.6350973705437,1720.6180465525965,1717.6106415192933,1714.612845417074,
	1711.624621565808,1708.6459334560343,1705.676744749708,1702.717019278199,1699.766721041955,
	1696.8258142093957,1693.8942631166158,1690.9720322653873,1688.0590863238672,1685.155390124056,
	1682.260908662309,1679.375607098098,1676.4994507525746,1673.6324051087067,1670.7744358097084,
	1667.9255086586109,1665.0855896175826,1662.2546448064802,1659.4326405026854,1656.619543140117,
	1653.8153193082335,1651.0199357512495,1648.2333593679566,1645.455557210015,1642.686496481892,
	1639.926144539877,1637.1744688909248,1634.4314371927453,1631.697017251787,1628.9711770239853,
	1626.253884612702,1623.5451082686673,1620.8448163892517,1618.1529775172733,1615.469560340594,
	1612.794533691475,1610.1278665453087,1607.4695280207186,1604.819487378256,1602.1777140195393,
	1599.5441774872404,1596.918847463522,1594.301693770167,1591.6926863668737,1589.0917953517649,
	1586.4989909597105,1583.9142435622562,1581.3375236663146,1578.7688019138952,1576.2080490815254,
	1573.6552360794792,1571.110333950718,1568.5733138706535,1566.0441471464574,1563.5228052162072,
	1561.0092596482825,1558.503482140702,1556.005444520621,1553.5151187434642,1551.0324768924072,
	1548.5574911775147,1546.0901339356878,1543.6303776293576,1541.1781948459027,1538.733558297688,
	1536.2964408206328,1533.8668153740841,1531.4446550400014,1529.0299330226098,1526.6226226469873,
	1524.2226973595646,1521.830130726747,1519.4448964346598,1517.0669682881278,1514.6963202107943,
	1512.332926243731,1509.976760545472,1507.6277973909591,1505.2860111714951,1502.9513763934517,
	1500.623867678315,1498.3034597617304,1495.9901274931453,1493.6838458350983,1491.3845898626398,
	1489.0923347631103,1486.8070558348657,1484.5287284875797,1482.2573282410551,1479.9928307247449,
	1477.7352116775282,1475.4844469469017,1473.2405124884472,1471.0033843655447,1468.773038748183,
	1466.5494519132174,1464.332600243462,1462.1224602269192,1459.9190084571123,1457.7222216311038,
	1455.5320765503075,1453.3485501195878,1451.171619346139,1449.0012613402519,1446.8374533131564,
	1444.6801725778014,1442.529396548012,1440.3851027377248,1438.2472687605189,1436.1158723293715,
	1433.9908912561234,1431.8723034508064,1429.7600869210642,1427.6542197720635,1425.5546802057581,
	1423.4614465202728,1421.374497109583,1419.293810463143,1417.2193651652242,1415.1511398942064,
	1413.0891134228889,1411.0332646172685,1408.9835724364177,1406.9400159315549,1404.9025742464105,
	1402.8712266160617,1400.845952366834,1398.8267309155387,1396.8135417694157,1394.806364525255,
	1392.8051788693485,1390.809964576675,1388.8207015108514,1386.8373696231347,1384.8599489526512,
	1382.8884196253455,1380.9227618538412,1378.9629559372027,1377.008982259949,1375.0608212922136,
	1373.1184535888356,1371.1818597893,1369.2510206170627,1367.325916879209,1365.4065294661423,
	1363.4928393509665,1361.584827589027,1359.6824753179312,1357.7857637567122,1355.8946742054234,
	1354.009188044915,1352.1292867365055,1350.2549518211567,1348.3861649195564,1346.522907731394,
	1344.6651620349764,1342.8129096871673,1340.9661326224532,1339.1248128531483,1337.288932468438,
	1335.4584736343058,1333.633418592933,1331.8137496628096,1329.9994492377486,1328.1904997866764,
	1326.3868838536043,1324.588584056549,1322.7955830879655,1321.00786371389,1319.2254087732722,
	1317.4482011785194,1315.6762239140946,1313.9094600371056,1312.1478926760974,1310.391505031197,
	1308.6402803735339,1306.8942020450133,1305.1532534577734,1303.4174180942068,1301.6866795058738,
	1299.9610213140302,1298.2404272085996,1296.5248809481793,1294.814366359387,1293.108867336878,
	1291.408367842695,1289.7128519062423,1288.0223036234013,1286.3367071567166,1284.6560467348163,
	1282.9803066520806,1281.3094712681043,1279.6435250081813,1277.9824523616326,1276.3262378826776,
	1274.6748661893691,1273.028321963669,1271.3865899508053,1269.7496549592297,1268.1175018599108,
	1266.4901155866048,1264.867481134693,1263.2495835618047,1261.6364079865825,1260.0279395891275,
	1258.424163610166,1256.825065350838,1255.2306301726678,1253.6408434967316,1252.0556908038416,
	1250.475157633987,1248.8992295858266,1247.3278923170112,1245.761131542974,1244.1989330374831,
	1242.6412826316828,1241.0881662142706,1239.5395697307633,1237.9954791835005,1236.4558806313194,
	1234.9207601889739,1233.3901040271396,1231.8638983719397,1230.3421295048377,1228.8247837620406,
	1227.3118475343867,1225.8033072670216,1224.299149459116,1222.7993606636583,1221.3039274869486,
	1219.8128365883185,1218.326074680021,1216.8436285269197,1215.365484946065,1213.8916308064547,
	1212.4220530288499,1210.9567385851515,1209.4956744986698,1208.0388478432333,1206.5862457436253,
	1205.1378553742518,1203.6936639600635,1202.253658775372,1200.81782714387,1199.386156438518,
	1197.958634080974,1196.535247541645,1195.1159843390583,1193.70083203976,1192.2897782581058,
	1190.8828106557887,1189.4799169417122,1188.0810848717801,1186.6863022484029,1185.2955569204844,
	1183.9088367828465,1182.5261297762438,1181.1474238869653,1179.7727071465597,1178.401967631665,
	1177.0351934633977,1175.6723728078011,1174.3134938746878,1172.9585449181457,1171.607514235664,
	1170.2603901684226,1168.9171611005288,1167.5778154589993,1166.2423417137745,1164.9107283767487,
	1163.5829640021384,1162.2590371861452,1160.9389365661325,1159.6226508212496,1158.3101686715745,
	1157.0014788777814,1155.6965702413718,1154.3954316040033,1153.0980518474016,1151.8044198931495,
	1150.5145247023393,1149.2283552752187,1147.945900651249,1146.667149908567,1145.3920921637682,
	1144.1207165718642,1142.8530123257765,1141.5889686561832,1140.3285748313292,1139.0718201567202,
	1137.8186939749648,1136.5691856651238,1135.3232846431451,1134.0809803610985,1132.8422623069025,
	1131.607120004479,1130.3755430132785,1129.1475209279101,1127.9230433779624,1126.7021000280201,
	1125.484680577017,1124.2707747581271,1123.060372338934,1121.8534631205155,1120.65003693749,
	1119.4500836579125,1118.253593182918,1117.0605554463707,1115.8709604147339,1114.6847980869454,
	1113.5020584939716,1112.3227316984526,1111.1468077949564,1109.9742769091906,1108.8051291981126,
	1107.639354849546,1106.4769440818586,1105.317887143977,1104.162174314831,1103.0097959035245,
	1101.8607422485943,1100.7150037181098,1099.57257070941,1098.4334336486884,1097.2975829910124,
	1096.1650092197526,1095.0357028466274,1093.9096544113213,1092.7868544814419,1091.667293651841,
	1090.5509625448703,1089.437851809888,1088.3279521230836,1087.2212541871083,1086.117748731084,
	1085.0174265101334,1083.9202783052165,1082.8262949231407,1081.7354671956634,1080.647785980094,
	1079.5632421584462,1078.4818266374398,1077.4035303481908,1076.3283442460265,1075.256259310212,
	1074.1872665437322,1073.1213569729355,1072.058521647682,1070.9987516404603,1069.942038046845,
	1068.8883719846187,1067.8377445941212,1066.7901470374923,1065.7455704988377,1064.7040061837572,
	1063.6654453190974,1062.6298791529782,1061.5972989541137,1060.5676960119793,1059.5410616363786,
	1058.5173871572306,1057.4966639242678,1056.4788833069492,1055.4640366941073,1054.452115493742,
	1053.4431111326714,1052.4370150565321,1051.4338187293433,1050.433513633133,1049.4360912682253,
	1048.4415431524162,1047.4498608209192,1046.4610358264013,1045.475059738308,1044.4919241429345,
	1043.5116206429293,1042.5341408572688,1041.5594764210582,1040.587618985007,1039.6185602153166,
	1038.6522917935229,1037.6888054162312,1036.7280927948143,1035.7701456550465,1034.8149557371833,
	1033.86251479537,1032.912814597586,1031.9658469254225,1031.0216035736132,1030.080076350158,
	1029.1412570756795,1028.2051375834753,1027.2717097189986,1026.3409653399433,1025.4128963156056,
	1024.4874945270396,1023.5647518664729,1022.644660237229,1021.7272115533837,1020.8123977395397,
	1019.9002107307433,1018.9906424719115,1018.0836849178968,1017.179330032937,1016.277569790658,
	1015.3783961736458,1014.4818011733167,1013.5877767895068,1012.6963150304033,1011.8074079121353,
	1010.9210474586138,1010.0372257011496,1009.1559346783787,1008.2771664358784,1007.4009130258484,
	1006.527166507084,1005.6559189443688,1004.7871624086099,1003.9208889762639,1003.0570907291458,
	1002.1957597543342,1001.3368881436816,1000.480467993665,999.6264914051773,998.7749504831164,
	997.9258373361631,997.079144076653,996.2348628201066,995.3929856850391,994.5535047928407,
	993.7164122672152,992.8817002342904,992.0493608218796,991.2193861595193,990.3917683783441,
	989.5664996102818,988.7435719884141,987.9229776463071,987.1047087176094,986.288757336368,
	985.4751156360867,984.6637757499198,983.8547298101411,983.0479699479478,982.2434882932173,
	981.4412769741639,980.6413281171241,979.8436338463194,979.0481862832876,978.2549775470328,
	977.4639997533789,976.6752450149712,975.8887054407813,975.1043731358548,974.3222402011875,
	973.5422987332445,972.7645408238081,971.9889585595859,971.215544022092,970.4442892871439,
	969.675186424668,968.9082274985705,968.1434045661197,967.3807096779773,966.6201348776677,
	965.8616722015425,965.1053136781491,964.3510513282043,963.5988771643506,962.8487831904847,
	962.1007614019078,961.3548037848947,960.6109023160357,959.8690489626093,959.1292356816059,
	958.3914544201148,957.6556971143302,956.9219556897673,956.1902220606927,955.4604881300492,
	954.7327457888318,954.0069869161849,953.283203378723,952.5613870305475,951.8415297127063,
	951.1236232529876,950.4076594657703,949.6936301513779,948.9815270960471,948.2713420715081,
	947.5630668348043,946.8566931278247,946.1522126770644,945.4496171935018,944.7488983718188,
	944.0500478906296,943.3530574118513,942.6579185805341,941.9646230244377,941.2731623538956,
	940.5835281613814,939.8957120210845,939.209705488923,938.5255001019476,937.8430873782082,
	937.1624588162933,936.4836058951944,935.8065200738454,935.1311927909259,934.4576154643911,
	933.7857794914439,933.1156762478754,932.4472970880585,931.780633344425,931.1156763272853,
	930.4524173244531,929.7908476009562,929.1309583987445,928.4727409364046,927.816186408698,
	927.1612859863534,926.5080308159687,925.8564120192135,925.206420692927,924.5580479087135,
	923.9112847126485,923.2661221247575,922.6225511390127,921.980562722846,921.340147816852,
	920.7012973344765,920.0640021618407,919.428253157279,918.7940411511116,918.1613569452538,
	917.5301913130058,916.9005349987199,916.2723787175846,915.6457131549638,915.0205289665632,
	914.3968167779996,913.7745671841857,913.1537707493873,912.5344180067788,911.916499458231,
	911.3000055737642,910.6849267917208,910.0712535179214,909.458976125703,908.848084955637,
	908.2385703150198,907.6304224777689,907.0236316841749,906.4181881402939,905.8140820180766,
	905.2113034547001,904.6098425526643,904.009689379122,903.4108339658512,902.8132663089389,
	902.2169763683829,901.6219540680254,901.0281892949201,900.4356718994783,899.8443916949681,
	899.254338457152,898.6655019243169,898.0778717966544,897.491437736332,896.9061893669539,
	896.3221162734366,895.739208001766,895.1574540585644,894.576843911173,893.9973669870839,
	893.4190126737479,892.8417703184792,892.2656292281196,891.6905786687322,891.1166078654483,
	890.5437060021297,889.9718622212717,889.401065623742,888.8313052684402,888.2625701721257,
	887.6948493093039,887.1281316118692,886.5624059689247,885.9976612265748,885.4338861877875,
	884.8710696120289,884.3092002152304,883.7482666694743,883.1882576028393,882.629161599215,
	882.0709671981032,881.513662894345,880.9572371382537,880.401678334965,879.8469748446718,
	879.2931149822392,878.7400870170997,878.1878791731654,877.6364796284664,877.0858765153059,
	876.5360579197688,875.9870118819631,875.4387263955449,874.8911894077926,874.3443888194504,
	873.7983124844316,873.2529482101107,872.7082837567816,872.1643068378437,871.6210051195962,
	871.0783662211547,870.5363777145677,869.9950271244186,869.4543019281105,868.914189555537,
	868.3746773894476,867.8357527648836,867.2974029698912,866.7596152448821,866.2223767831182,
	865.6856747307172,865.1494961866947,864.6138282031557,864.0786577856244,863.5439718931409,
	863.009757438752,862.4760012897747,861.942690268634,861.4098111531812,860.8773506775284,
	860.345295533295,859.8136323706074,859.282347799391,858.7514283916204,858.2208606829179,
	857.6906311757261,857.1607263421714,856.6311326281303,856.1018364580973,855.5728242410402,
	855.0440823775164,854.5155972684903,853.9873553259948,853.4593429862833,852.9315467259757,
	852.403953081546,851.8765486736203,851.3493202362775,850.8222546537222,850.2953390045486,
	849.7685606169736,849.2419071362424,848.7153666084413,848.1889275837417,847.6625792443302,
	847.1363115634831,846.6101155035356,846.083983263111,845.5579085864454,845.0318871529506,
	844.5059170679419,843.9799994840346,843.4541393914287,842.9283466253935,842.4026371554652,
	841.8770347397638,841.3515730498225,840.8262984018096,840.3012732602048,839.7765807149609,
	839.2523301615416,838.728664432391,838.2057686106858,837.68388069756,837.1633041537525,
	836.6444220793012,836.1277124027386,835.6137629148527,835.1032843696197,834.5971192703767,
	834.0962435702022,833.6017585431734,833.1148707392947,832.6368592848046,832.1690316997583,
	831.7126715090658,831.268982686959,830.8390368951099,830.4237292410849,830.0237469400157,
	829.6395531735614,829.2713861513367,828.9192714291015,828.5830442669466,828.2623783172477,
	827.956817111068,827.665805428987,827.3887184523965,827.1248874106544,826.8736211240604,
	826.6342233646759,826.4060062961921,826.1883004456206,825.9804617455128,825.781876183389,
	825.591962563035,825.4101738154764,825.2359972270956,825.0689538878341,824.9085975949439,
	824.754513397521,824.606315923552,824.4636475906445,824.3261767787603,824.1935960174101,
	824.0656202247206,823.9419850234124,823.8224451450809,823.7067729362499,823.5947569645132,
	823.4862007264685,823.3809214544286,823.2787490181306,823.1795249149526,823.0831013441382,
	822.9893403599,822.8981130938566,822.8092990458965,822.7227854350726,822.6384666052742,
	822.55624348387,822.4760230832618,822.3977180481986,822.321246238847,822.246530349577,
	822.1734975612137,822.102079219264,822.0322105410897,821.9638303447047,821.89688080215,
	821.8313072096323,821.7670577786796,821.7040834423973,821.642337675406,821.5817763305023,
	821.5223574857391,821.4640413042406,821.4067899025982,821.3505672307585,821.2953389606394,
	821.2410723832695,821.1877363110207,821.1353009846159,821.083737999055,821.0330202165859,
	820.9831217006848,820.9340176446258,820.8856843116798,820.8380989765811,820.7912398662515,
	820.7450861160786,820.6996177146999,820.654815463235,820.610660932102,820.5671364223762,
	820.5242249270053,820.4819100984463,820.4401762139315,820.3990081446058,820.3583913301228,
	820.3183117462679,820.2787558843613,820.2397107224352,820.2011637076139,820.1631027297874,
	820.125516103055,820.0883925482799,820.0517211718419,820.0154914526003,819.9796932211311,
	819.9443166483758,819.9093522261546,819.8747907603475,819.8406233514321,819.8068413843229,
	819.7734365180941,819.7404006733702,819.7077260209367,819.6754049738929,819.6434301761277,
	819.6117944924063,819.580491003554,819.5495129935101,819.5188539446273,819.4885075297173,
	819.4584676018767,819.4287281913794,819.3992834993207,819.3701278873855,819.3412558758444,
	819.3126621354512,819.2843414838794,819.2562888778482,819.2284994116795,819.2009683109648,
	819.1736909253493,819.1466627287664,819.1198793132378,819.0933363810537,819.0670297514209,
	819.0409553434763,819.0151091823103,818.9894873920822,818.964086191901,818.9389018968144,
	818.9139309105287,818.8891697221634,818.864614908476,818.8402631272727,818.8161111129974,
	818.7921556802189,818.7683937174276,818.7448221832303,818.7214381084179,818.6982385923233,
	818.6752207961835,818.6523819494124,818.6297193418555,818.6072303216695,818.5849123005339,
	818.5627627421553,818.5407791656223,818.518959146781,818.4973003106343,818.4758003353643,
	818.454456945704,818.4332679156626,818.4122310656686,818.3913442606647,818.3706054116516,
	818.3500124669846,818.3295634269948,818.3092563212175,818.2890892264383,818.2690602535033,
	818.2491675528163,818.2294093115702,818.2097837505277,818.1902891271678,818.1709237315222,
	818.151685886841,818.1325739475043,818.1135863016453,818.0947213648674,818.0759775826913,
	818.0573534328638,818.0388474186125,818.020458071555,818.0021839500897,817.9840236384879,
	817.9659757459734,817.9480389097988,817.9302117862185,817.9124930636616,817.8948814466496,
	817.8773756641506,817.8599744683531,817.8426766329574,817.8254809527028,817.808386244473,
	817.7913913410015,817.7744951006196,817.7576963973344,817.7409941257733,817.7243871964994,
	817.7078745424315,817.6914551115065,817.6751278678917,817.6588917946772,817.6427458907461,
	817.6266891735601,817.6107206727902,817.5948394332396,817.579044521684,817.5633350094896,
	817.5477099937852,817.5321685761284,817.5167098790744,817.5013330354085,817.4860371914058,
	817.4708215080517,817.455685156771,817.4406273253799,817.4256472087499,817.4107440203705,
	817.3959169810652,817.3811653226757,817.3664882913116,817.3518851447625,817.3373551500349,
	817.3228975829195,817.308511732477,817.2941968991236,817.2799523887696,817.2657775243955,
	817.2516716313127,817.2376340495077,817.2236641277283,817.2097612196559,817.1959246935362,
	817.1821539241099,817.1684482944297,817.1548071974936,817.1412300323774,817.1277162084695,
	817.1142651444171,817.1008762621155,817.0875489950209,817.0742827846079,817.0610770796295,
	817.0479313310557,817.0348450068103,817.0218175732873,817.0088485088108,816.9959372953653,
	816.9830834212808,816.9702863888267,816.9575456997612,816.9448608625725,816.9322313943577,
	816.919656816027,816.9071366598052,816.8946704579159,816.8822577510024,816.8698980843143,
	816.8575910128028,816.8453360922452,816.8331328860851,816.8209809645264,816.8088798965185,
	816.796829266531,816.7848286571547,816.7728776591678,816.7609758625601,816.749122872433,
	816.7373182914309,816.725561723261,816.7138527873758,816.7021911022524,816.6905762867103,
	816.6790079717706,816.6674857860511,816.656009367871,816.6445783567304,816.633192396866,
	816.6218511405051,816.6105542321875,816.5993013337047,816.5880921090081,816.576926217214,
	816.5658033267681,816.5547231119825,816.5436852506571,816.5326894173451,816.5217353013592,
	816.5108225811068,816.4999509550878,816.489120110398,816.4783297480029,816.4675795670088,
	816.4568692685556,816.4461985658614,816.4355671608014,816.4249747731405,816.4144211182304,
	816.4039059131478,816.3934288814659,816.3829897498116,816.3725882423648,816.3622240938836,
	816.3518970399085,816.3416068120478,816.3313531575867,816.3211358132061,816.310954524513,
	816.3008090404354,816.2906991099163,816.2806244868381,816.2705849294728,816.2605801911785,
	816.2506100369752,816.2406742246594,816.2307725241162,816.2209047040108,816.2110705293006,
	816.2012697758631,816.1915022196557,816.1817676317785,816.1720657971649,816.1623964972359,
	816.1527595126224,816.1431546294166,816.133581636396,816.1240403251977,816.1145304836808,
	816.1050519121372,816.0956044032324,816.0861877497377,816.0768017585937,816.0674462297817,
	816.0581209684802,816.0488257769206,816.0395604668389,816.030324843414,816.0211187182961,
	816.0119419086398,816.0027942260905,815.993675485896,815.9845855076808,815.9755241105908,
	815.9664911219029,815.9574863552645,815.9485096443877,815.9395608092668,815.9306396786683,
	815.9217460890756,815.9128798599924,815.9040408372382,815.8952288466201,815.8864437247487,
	815.8776853111134,815.8689534434691,815.8602479612606,815.851568707322,815.8429155281244,
	815.8342882597574,815.8256867538487,815.8171108574354,815.8085604151835,815.800035281745,
	815.7915353062135,815.7830603423955,815.7746102409996,815.7661848614084,815.7577840531696,
	815.7494076814809,815.7410556012446,815.7327276735326,815.7244237561144,815.716143716407,
	815.7078874203378,815.6996547198288,815.6914454950208,815.6832596064952,815.6750969173884,
	815.6669573098102,815.6588406439387,815.6507467912973,815.6426756317006,815.6346270299034,
	815.6266008710317,815.6185970205007,815.6106153576044,815.6026557643955,815.5947181150029,
	815.5868022892043,815.5789081734516,815.571035641834,815.5631845795067,815.5553548741606,
	815.5475464018642,815.5397590608926,815.5319927242989,815.524247283649,815.5165226317737,
	815.5088186534002,815.5011352404695,815.4934722804195,815.4858296698354,815.4782072964158,
	815.4706050602692,815.4630228459944,815.4554605544337,815.447918080628,815.4403953240485,
	815.4328921786835,815.4254085419212,815.4179443173218,815.410499403186,815.4030736940699,
	815.3956670958603,815.3882795171166,815.3809108523324,815.3735610053856,815.3662298824092,
	815.358917393206,815.3516234331688,815.3443479201646,815.3370907544083,815.329851842825,
	815.3226310975002,815.3154284296488,815.3082437446392,815.3010769569946,815.293927969581,
	815.2867967063761,815.2796830713038,815.2725869837022,815.2655083488877,815.2584470946133,
	815.2514031210397,815.2443763528224,815.2373667029685,815.2303740950498,815.223398438294,
	815.2164396543714,815.2094976599215,815.2025723796969,815.1956637274023,815.1887716294685,
	815.1818960006453,815.175036767506,815.1681938443674,815.16136716123,815.1545566435931,
	815.1477622132443,815.1409837928809,815.1342213020243,815.1274746717692,815.1207438322858,
	815.1140287014068,815.1073292114477,815.1006452907576,815.0939768648452,815.0873238606247,
	815.0806862083373,815.0740638385678,815.0674566791341,815.0608646614821,815.0542877195312,
	815.0477257825955,815.0411787792608,815.0346466424983,815.0281293114114,815.0216267102645,
	815.0151387816762,815.0086654536137,815.0022066585407,814.9957623390143,814.9893324281414,
	814.9829168554343,814.9765155649563,814.9701284883821,814.9637555696658,814.9573967329773,
	814.951051929238,814.9447210914244,814.9384041550519,814.9321010681253,814.925811765657,
	814.9195361869856,814.9132742679707,814.9070259576266,814.9007911942814,814.8945699147299,
	814.8883620691056,814.8821675921505,814.8759864269953,814.8698185263692,814.8636638210077,
	814.857522261362,814.8513937877411,814.8452783485053,814.8391758845914,814.8330863454014,
	814.8270096742773,814.8209458150197,814.8148947203041,814.8088563277712,814.8028305913313,
	814.7968174548967,814.790816859945,814.7848287661135,814.7788531184734,814.7728898582125,
	814.7669389399925,814.7610003101496,814.7550739237843,814.7491597255733,814.7432576650996,
	814.7373676950612,814.731489765655,814.7256238275863,814.719769830881,814.7139277262241,
	814.7080974670956,814.702279007305,814.6964722977959,814.6906772897215,814.684893939814,
	814.6791221979909,814.6733620167104,814.6676133563237,814.6618761592182,814.6561503958972,
	814.6504360032285,814.6447329469078,814.6390411838202,814.6333606597386,814.6276913435012,
	814.6220331806176,814.6163861281825,814.610750148298,814.6051251935847,814.5995112189747,
	814.5939081922189,814.588316058465,814.5827347735697,814.5771643070833,814.571604613704,
	814.5660556461881,814.5605173770606,814.5549897482937,814.5494727238611,814.5439662732409,
	814.5384703398224,814.5329848957748,814.527509899059,814.5220453063598,814.5165910813993,
	814.5111471846017,814.5057135747775,814.5002902126483,814.4948770649272,814.4894740877718,
	814.4840812472527,814.4786985035771,814.4733258169284,814.4679631513617,814.462610471846,
	814.4572677337549,814.4519349073169,814.4466119609431,814.4412988444443,814.4359955340743,
	814.4307019820639,814.4254181621869,814.4201440396337,814.4148795682465,814.4096247207215,
	814.4043794617231,814.3991437511069,814.3939175636538,814.3887008521266,814.3834935968183,
	814.3782957512354,814.373107289674,814.3679281759075,814.36275837203,814.3575978477506,
	814.3524465695727,814.347304508414,814.3421716221735,814.3370478889879,814.3319332636527,
	814.32682772518,814.3217312413469,814.3166437738355,814.3115652912606,814.3064957665258,
	814.3014351568902,814.2963834506799,814.2913406057042,814.2863065867036,814.2812813676417,
	814.276264912617,814.2712571947494,814.2662581948339,814.2612678669658,814.2562861862913,
	814.2513131189565,814.2463486414879,814.2413927256589,814.2364453321773,814.2315064392064,
	814.2265760250901,814.2216540419961,814.216740473879,814.2118352944057,814.2069384645506,
	814.202049962748,814.197169760207,814.1922978256463,814.187434133945,814.1825786525325,
	814.1777313634816,814.172892234893,814.1680612338507,814.1632383328753,814.1584235191422,
	814.1536167531672,814.148818003765,814.1440272594396,814.1392444815597,814.1344696439327,
	814.1297027290783,814.1249437033108,814.1201925431349,814.1154492214915,814.1107137072283,
	814.1059859871588,814.1012660271596,814.0965538020737,814.0918492917356,814.0871524587283,
	814.0824632925808,814.0777817665313,814.0731078424141,814.0684415082885,814.0637827394846,
	814.0591315072118,814.0544877829676,814.049851550878,814.0452227787578,814.0406014522734,
	814.0359875404345,814.0313810271847,814.0267818737,814.0221900708759,814.0176055915841,
	814.0130284025485,814.0084584969765,814.003895840019,813.9993404164247,813.9947921995077,
	813.9902511618409,813.9857172946541,813.9811905595915,813.9766709404976,813.9721584162376,
	813.9676529586745,813.9631545533557,813.958663177834,813.9541788101997,813.949701425142,
	813.9452310022195,813.9407675153197,813.9363109482769,813.9318612848816,813.927418486313,
	813.9229825516422,813.9185534515108,813.9141311597452,813.9097156567319,813.9053069323319,
	813.9009049547001,813.896509705122,813.8921211696758,813.8877393121836,813.8833641311318,
	813.8789955955613,813.8746336878287,813.8702783921211,813.8659296797305,813.8615875325999,
	813.8572519323342,813.852922869852,813.8486003079087,813.8442842396812,813.8399746386219,
	813.8356714869157,813.8313747638251,813.8270844549834,813.8228005387698,813.8185229943527,
	813.8142518075446,813.8099869570506,813.8057284198851,813.80147618452,813.7972302261571,
	813.792990524064,813.788757068866,813.7845298381217,813.7803088158435,813.7760939795146,
	813.771885310512,813.7676828004809,813.7634864106659,813.7592961445285,813.7551119783332,
	813.7509338888306,813.7467618635833,813.7425958845636,813.7384359315862,813.7342819843221,
	813.7301340402361,813.7259920606252,813.7218560406255,813.7177259623796,813.7136018111469,
	813.7094835676896,813.7053712150749,813.7012647254256,813.697164101892,813.6930693212182,
	813.6889803582499,813.6848971928667,813.6808198312259,813.6767482371313,813.6726824010062,
	813.6686223106285,813.6645679373601,813.6605192769064,813.6564763077505,813.6524390199313,
	813.6484073924414,813.6443814020733,813.6403610456395,813.636346299317,813.632337150755,
	813.6283335932158,813.6243355923052,813.6203431493539,813.6163562421342,813.6123748519065,
	813.6083989682335,813.6044285689933,813.6004636491891,813.5965041937133,813.5925501678855,
	813.5886015819241,813.5846584105178,813.5807206371843,813.5767882517575,813.5728612362882,
	813.5689395731155,813.565023252454,813.5611122576779,813.5572065798913,813.5533061903915,
	813.5494110918572,813.5455212583884,813.541636684724,813.5377573498857,813.5338832363506,
	813.5300143373356,813.5261506334945,813.5222921166134,813.5184387702784,813.514590585863,
	813.5107475400886,813.5069096247703,813.5030768232152,813.499249122424,813.4954265142841,
	813.4916089726374,813.4877964967992,813.4839890689215,813.4801866725189,813.476389301722,
	813.4725969368891,813.468809566445,813.4650271708538,813.4612497518566,813.4574772871383,
	813.4537097650908,813.4499471697968,813.4461894892285,813.442436717933,813.4386888303873,
	813.4349458233507,813.4312076881904,813.4274743967543,813.4237459515574,813.4200223312599,
	813.416303521493,813.4125895222224,813.4088803095966,813.4051758746039,813.4014762102895,
	813.3977812862753,813.3940911160104,813.3904056703338,813.3867249352011,813.3830489182717,
	813.3793775909234,813.3757109333409,813.3720489558916,813.3683916256455,813.3647389440654,
	813.3610908966259,813.3574474700139,813.3538086546965,813.3501744324394,813.3465448092032,
	813.3429197507201,813.3392992538237,813.3356833157584,813.3320719085463,813.328465040481,
	813.3248626854582,813.3212648445517,813.3176714880417,813.3140826143783,813.3104982166994,
	813.3069182836473,813.3033428020544,813.2997717521802,813.2962051322039,813.2926429347176,
	813.289085137049,813.2855317471342,813.2819827329964,813.2784380888363,813.2748978217651,
	813.2713618877614,813.2678303030169,813.2643030562988,813.2607801232326,813.2572615058813,
	813.2537471828674,813.2502371487717,813.2467313838953,813.243229898089,813.2397326723783,
	813.2362396827742,813.2327509418998,813.2292664200234,813.22578610852,813.2223100120855,
	813.2188381044332,813.2153703884269,813.2119068478426,813.2084474746583,813.2049922550225,
	813.2015411736382,813.1980942407592,813.1946514234626,813.1912127214235,813.1877781267402,
	813.184347633043,813.1809212196094,813.1774988818904,813.1740806254314,813.1706664026964,
	813.1672562530661,813.1638501207028,813.1604480265429,813.1570499575251,813.1536558863767,
	813.1502658181245,813.1468797392381,813.1434976466873,813.1401195160851,813.1367453587568,
	813.1333751491334,813.1300088781343,813.1266465500742,813.1232881424896,813.1199336567298,
	813.1165830763981,813.1132363865087,813.1098935886114,813.1065546792497,813.1032196351141,
	813.0998884532055,813.0965611248823,813.0932376377373,813.0899179845841,813.0866021631451,
	813.0832901570997,813.0799819451328,813.0766775580889,813.073376955639,813.0700801297813,
	813.0667870738299,813.0634977880741,813.0602122584673,813.0569304793403,813.0536524348942,
	813.0503781277688,813.0471075372916,813.0438406593131,813.040577492983,813.0373180113469,
	813.034062235134,813.0308101306713,813.027561696812,813.0243169253498,813.0210758223286,
	813.0178383524163,813.014604525819,813.0113743344708,813.0081477534369,813.0049247924862,
	813.0017054379734,812.9984896872674,812.9952775269677,812.9920689531956,812.988863941153,
	812.9856625011122,812.9824646187361,812.9792702843006,812.9760794910321,812.9728922391786,
	812.9697085069814,812.9665283021557,812.9633516027898,812.9601784096587,812.9570087144681,
	812.9538425004979,812.9506797641797,812.9475205114034,812.944364719788,812.9412123848973,
	812.9380634994608,812.9349180585849,812.9317760478326,812.9286374729922,812.9255023089424,
	812.922370556474,812.9192422128763,812.9161172704848,812.9129957097695,812.9098775411621,
	812.9067627402767,812.9036513152885,812.90054323742,812.8974385184763,812.8943371583348,
	812.8912391260607,812.8881444262341,812.8850530523732,812.8819649940914,812.8788802485074,
	812.8757988073626,812.872720659696,812.8696458010826,812.8665742288389,812.8635059306788,
	812.8604408987024,812.8573791270717,812.8543206135786,812.8512653452542,812.8482133236337,
	812.8451645239121,812.842118946384,812.8390766048523,812.8360374710089,812.8330015429974,
	812.829968811277,812.8269392837412,812.823912924685,812.8208897564485,812.8178697576058,
	812.814852929439,812.8118392531043,812.8088287371811,812.8058213581965,812.8028171236045,
	812.7998160151578,812.7968180404348,812.7938231856831,812.7908314451865,812.7878428047961,
	812.7848572725678,812.7818748339016,812.7788954788247,812.7759191993268,812.7729460105073,
	812.7699758829484,812.7670088077639,812.7640447985527,812.7610838496221,812.7581259256336,
	812.7551710463615,812.7522191870016,812.7492703558594,812.7463245503682,812.7433817528471,
	812.7404419748458,812.7375051700054,812.7345713785708,812.7316405733272,812.728712746868,
	812.7257878930375,812.7228660122182,812.7199470904397,812.7170311251936,812.7141181135682,
	812.711208043781,812.7083009156922,812.7053967298705,812.7024954649512,812.6995971207385,
	812.6967016850131,812.6938091713802,812.6909195524369,812.6880328462897,812.6851490160889,
	812.682268069549,812.6793900209053,812.6765148340734,812.6736425247535,812.670773081219,
	812.6679064755963
	}},
	{ // Ri = 250k
	-25,25,40,2001, {
	3196.116471263702,3187.7926694823304,3179.501529796419,3171.2429006971893,3163.0166314504404,
	3154.8225720946275,3146.6605734359036,3138.530487045772,3130.4321652549615,3122.3654611497373,
	3114.330228570764,3106.326322103318,3098.353597078955,3090.411909569725,3082.5011163820845,
	3074.621075057046,3066.771643862369,3058.9526817914616,3051.1640485580315,3043.405604592295,
	3035.677211038612,3027.978729751131,3020.31002328738,3012.670954909351,3005.0613885758667,
	2997.481188940551,2989.9302213474684,2982.4083518285024,2974.9154470986964,2967.4513745524673,
	2960.0160022615396,2952.6091989701326,2945.2308340908567,2937.880777702378,2930.558900545409,
	2923.265074019613,2915.999170178907,2908.7610617295363,2901.5506220257125,2894.367725065881,
	2887.21224549047,2880.0840585775777,2872.9830402397174,2865.909067020619,2858.862016091575,
	2851.8417652486314,2844.84819290912,2837.881178108112,2830.9406004954308,2824.026340331683,
	2817.138278486343,2810.2762964328917,2803.4402762473846,2796.6301006043445,2789.8456527728645,
	2783.086816614295,2776.3534765798036,2769.645517706132,2762.9628256121305,2756.3052864970223,
	2749.672787136504,2743.0652148801155,2736.4824576473375,2729.924403925818,2723.3909427672493,
	2716.8819637852375,2710.397357150997,2703.9370135926497,2697.500824390084,2691.08868137324,
	2684.700476918503,2678.336103946291,2671.995455918227,2665.6784268340707,2659.3849112283274,
	2653.114804168752,2646.8680012524324,2640.644398602936,2634.443892868024,2628.266381216688,
	2622.1117613369183,2615.9799314320167,2609.8707902180336,2603.784236921769,2597.7201712774695,
	2591.678493524661,2585.6591044040833,2579.6619051565435,2573.686797520948,2567.7336837283874,
	2561.802466502822,2555.8930490576504,2550.0053350917647,2544.1392287884078,2538.294634812739,
	2532.471458307026,2526.6696048920057,2520.8889806606203,2515.1294921772237,2509.391046475108,
	2503.6735510538942,2497.97691387733,2492.301043369598,2486.645848414184,2481.011238350953,
	2475.3971229744475,2469.8034125300123,2464.230017712296,2458.676849663174,2453.143819969179,
	2447.630840658506,2442.1378241990337,2436.664683496823,2431.2113318929237,2425.7776831604724,
	2420.3636515042576,2414.9691515568197,2409.5940983764003,2404.2384074456872,2398.9019946691424,
	2393.5847763693932,2388.2866692869306,2383.007590577434,2377.7474578084875,2372.5061889590415,
	2367.283702415542,2362.079916970889,2356.8947518228692,2351.7281265699626,2346.5799612111628,
	2341.450176142973,2336.338692157628,2331.245430440472,2326.170312568526,2321.113260508292,
	2316.0741966133846,2311.053043622534,2306.0497246578557,2301.0641632230995,2296.0962832000837,
	2291.1460088487565,2286.213264804238,2281.297976074253,2276.400068038194,2271.519466444787,
	2266.6560974102713,2261.8098874154566,2256.9807633056143,2252.168652286903,2247.3734819252327,
	2242.595180145216,2237.8336752258674,2233.0888958013243,2228.360770857117,2223.6492297295486,
	2218.9542021034,2214.2756180099454,2209.6134078247383,2204.9675022671477,2200.3378323971847,
	2195.7243296145707,2191.1269256559276,2186.545552594383,2181.980142837235,2177.430629123436,
	2172.8969445229213,2168.379022434047,2163.8767965822813,2159.3902010194606,2154.919170119344,
	2150.4636385793196,2146.0235414156655,2141.5988139642855,2137.1893918774463,2132.795211122568,
	2128.4162079806893,2124.0523190451813,2119.703481219649,2115.3696317156014,2111.050708052984,
	2106.7466480557173,2102.457389852315,2098.1828718737797,2093.9230328513236,2089.677811815264,
	2085.4471480936527,2081.2309813106954,2077.0292513843465,2072.84189852601,2068.6688632381715,
	2064.510086313155,2060.365508831721,2056.235072161293,2052.1187179546923,2048.016388148467,
	2043.928024961294,2039.8535708929649,2035.7929687225005,2031.746161506992,2027.7130925798203,
	2023.693705549417,2019.6879442975153,2015.6957529787383,2011.7170760175459,2007.7518581082372,
	2003.8000442130979,1999.8615795603828,1995.9364096441827,1992.0244802217087,1988.125737312694,
	1984.240127197881,1980.3675964182885,1976.5080917718858,1972.6615603147036,1968.8279493577122,
	1965.007206466623,1961.1992794598355,1957.404116407117,1953.6216656290974,1949.8518756951241,
	1946.0946954221108,1942.350073873639,1938.6179603583132,1934.8983044287186,1931.1910558797608,
	1927.4961647481614,1923.8135813099136,1920.1432560809503,1916.4851398139872,1912.8391834984504,
	1909.2053383585228,1905.5835558527071,1901.9737876722077,1898.3759857395512,1894.7901022073459,
	1891.2160894576996,1887.6539001005112,1884.1034869724265,1880.564803135595,1877.037801876504,
	1873.5224367049123,1870.0186613525416,1866.5264297724414,1863.0456961366986,1859.5764148370515,
	1856.1185404816283,1852.6720278958096,1849.2368321200797,1845.812908408384,1842.4002122286045,
	1838.9986992600275,1835.6083253932736,1832.2290467282112,1828.860819573407,1825.5036004453275,
	1822.1573460671589,1818.8220133668146,1815.4975594773198,1812.1839417346673,1808.8811176771212,
	1805.5890450445088,1802.3076817766387,1799.0369860125984,1795.7769160895846,1792.5274305419953,
	1789.2884881002412,1786.0600476899338,1782.8420684308028,1779.6345096357868,1776.4373308098545,
	1773.2504916491166,1770.0739520398654,1766.9076720571964,1763.7516119652653,1760.605732214574,
	1757.4699934423552,1754.3443564710642,1751.2287823075867,1748.1232321422597,1745.0276673478538,
	1741.9420494783126,1738.8663402689033,1735.8005016341156,1732.7444956672598,1729.6982846395438,
	1726.6618309993507,1723.6350973705437,1720.6180465527143,1717.6106415192933,1714.612845417074,
	1711.6246215656918,1708.6459334560343,1705.676744749708,1702.717019278199,1699.766721041955,
	1696.8258142093957,1693.8942631166158,1690.9720322653873,1688.0590863238672,1685.155390124056,
	1682.260908662309,1679.375607098098,1676.4994507525746,1673.6324051087067,1670.7744358097084,
	1667.9255086586109,1665.0855896175826,1662.2546448064802,1659.4326405026854,1656.619543140117,
	1653.8153193082335,1651.0199357512495,1648.2333593679566,1645.455557210015,1642.686496481892,
	1639.926144539877,1637.1744688909248,1634.4314371927453,1631.697017251787,1628.9711770239853,
	1626.253884612702,1623.5451082688073,1620.8448163892517,1618.152977517333,1615.469560340594,
	1612.7945336914368,1610.1278665453087,1607.4695280207186,1604.819487378256,1602.1777140195393,
	1599.5441774872404,1596.918847463522,1594.301693770167,1591.6926863668955,1589.0917953517649,
	1586.4989909597105,1583.9142435622562,1581.337523666202,1578.7688019138952,1576.2080490815254,
	1573.6552360794792,1571.110333950718,1568.5733138706535,1566.0441471464574,1563.5228052162072,
	1561.0092596482825,1558.503482140702,1556.005444520621,1553.5151187434642,1551.0324768924072,
	1548.5574911775147,1546.0901339356878,1543.6303776293576,1541.1781948459027,1538.733558297688,
	1536.2964408206328,1533.8668153740841,1531.4446550400014,1529.0299330226098,1526.6226226469873,
	1524.2226973595646,1521.830130726747,1519.4448964346598,1517.0669682881278,1514.6963202107943,
	1512.332926243731,1509.976760545472,1507.6277973909591,1505.2860111714951,1502.9513763935083,
	1500.623867678315,1498.3034597617304,1495.9901274931453,1493.6838458350983,1491.3845898626398,
	1489.0923347631103,1486.8070558348657,1484.5287284875478,1482.257328241047,1479.9928307247449,
	1477.7352116774584,1475.4844469469188,1473.2405124885024,1471.0033843655447,1468.773038748183,
	1466.549451913184,1464.332600243462,1462.1224602269192,1459.9190084571428,1457.7222216311188,
	1455.5320765503789,1453.3485501195878,1451.171619346139,1449.0012613402168,1446.8374533131564,
	1444.6801725778014,1442.529396548012,1440.3851027375977,1438.2472687605189,1436.1158723292888,
	1433.9908912561234,1431.8723034508064,1429.7600869210642,1427.6542197720635,1425.5546802057581,
	1423.4614465202728,1421.374497109583,1419.293810463143,1417.2193651652242,1415.1511398942064,
	1413.0891134228889,1411.0332646172935,1408.9835724364177,1406.9400159315549,1404.9025742464105,
	1402.87122661605,1400.8459523667798,1398.8267309155387,1396.8135417694157,1394.806364525255,
	1392.8051788693485,1390.809964576675,1388.8207015108514,1386.8373696232006,1384.8599489526512,
	1382.8884196253455,1380.9227618538412,1378.9629559372027,1377.008982259949,1375.0608212921102,
	1373.1184535888356,1371.1818597893516,1369.2510206170627,1367.325916879209,1365.4065294661423,
	1363.4928393508908,1361.584827589027,1359.6824753179567,1357.7857637567122,1355.894674205423,
	1354.009188044915,1352.1292867365294,1350.2549518211567,1348.3861649195564,1346.522907731394,
	1344.6651620349764,1342.8129096871673,1340.9661326224532,1339.1248128531483,1337.288932468438,
	1335.4584736343058,1333.633418592933,1331.8137496628096,1329.9994492377486,1328.1904997866764,
	1326.3868838536043,1324.588584056549,1322.7955830879655,1321.00786371389,1319.2254087732722,
	1317.4482011785194,1315.6762239141633,1313.9094600371056,1312.1478926760974,1310.391505031197,
	1308.6402803735339,1306.8942020450133,1305.153253457754,1303.4174180942068,1301.686679505896,
	1299.9610213140302,1298.2404272086183,1296.5248809481316,1294.814366359387,1293.1088673368743,
	1291.408367842695,1289.7128519062896,1288.022303623354,1286.336707156742,1284.6560467348163,
	1282.9803066520592,1281.3094712681727,1279.6435250081813,1277.9824523616326,1276.326237882682,
	1274.6748661893691,1273.028321963669,1271.3865899508053,1269.7496549592088,1268.1175018599108,
	1266.4901155866048,1264.8674811346152,1263.2495835618047,1261.6364079865825,1260.0279395891275,
	1258.424163610161,1256.825065350838,1255.2306301726678,1253.640843496702,1252.0556908038416,
	1250.4751576339615,1248.8992295858266,1247.32789231698,1245.761131542974,1244.1989330374831,
	1242.6412826316828,1241.0881662142706,1239.5395697307633,1237.9954791835005,1236.4558806313194,
	1234.9207601889739,1233.3901040271396,1231.8638983719975,1230.3421295048377,1228.8247837620406,
	1227.3118475344056,1225.8033072670216,1224.299149459116,1222.7993606636583,1221.3039274869486,
	1219.812836588269,1218.326074680021,1216.8436285269197,1215.365484946065,1213.8916308064547,
	1212.4220530288499,1210.9567385851515,1209.495674498688,1208.0388478432333,1206.586245743578,
	1205.1378553742518,1203.6936639600456,1202.253658775372,1200.8178271438267,1199.386156438518,
	1197.958634080974,1196.5352475416553,1195.1159843390406,1193.70083203976,1192.2897782581058,
	1190.8828106557787,1189.4799169417122,1188.0810848717801,1186.6863022484029,1185.2955569204844,
	1183.9088367828465,1182.5261297762438,1181.1474238869905,1179.7727071465858,1178.4019676316054,
	1177.0351934633977,1175.6723728077761,1174.3134938747128,1172.9585449181623,1171.607514235664,
	1170.2603901683892,1168.9171611005204,1167.5778154590241,1166.2423417137745,1164.9107283767487,
	1163.582964002196,1162.2590371861452,1160.9389365661325,1159.6226508212496,1158.3101686715656,
	1157.001478877749,1155.6965702413718,1154.3954316040033,1153.0980518474032,1151.8044198931889,
	1150.5145247023393,1149.2283552752187,1147.945900651256,1146.6671499085282,1145.3920921637907,
	1144.1207165718642,1142.8530123257765,1141.5889686561832,1140.3285748312915,1139.0718201567202,
	1137.8186939749648,1136.5691856651238,1135.3232846431451,1134.0809803610985,1132.8422623069025,
	1131.607120004479,1130.3755430133092,1129.1475209279101,1127.9230433779624,1126.7021000279747,
	1125.484680577017,1124.2707747581271,1123.060372338934,1121.8534631205305,1120.65003693749,
	1119.4500836579125,1118.253593182918,1117.0605554463707,1115.8709604147339,1114.68479808697,
	1113.5020584939716,1112.3227316984526,1111.1468077949564,1109.9742769092197,1108.805129198156,
	1107.639354849546,1106.476944081863,1105.317887143977,1104.162174314831,1103.0097959035245,
	1101.8607422485475,1100.7150037181098,1099.57257070941,1098.4334336486884,1097.2975829910124,
	1096.1650092197526,1095.0357028466135,1093.9096544113213,1092.7868544814523,1091.667293651841,
	1090.5509625448842,1089.437851809888,1088.3279521231145,1087.2212541871083,1086.1177487310597,
	1085.0174265101334,1083.9202783052165,1082.8262949231134,1081.7354671956634,1080.647785980094,
	1079.5632421584462,1078.4818266374398,1077.4035303481908,1076.32834424604,1075.256259310212,
	1074.1872665437322,1073.1213569729355,1072.058521647682,1070.9987516404603,1069.9420380468428,
	1068.8883719846187,1067.8377445941212,1066.7901470374923,1065.7455704988508,1064.7040061837592,
	1063.6654453190974,1062.6298791529782,1061.5972989541137,1060.5676960120034,1059.5410616363529,
	1058.5173871572306,1057.4966639242405,1056.4788833069492,1055.46403669412,1054.452115493742,
	1053.4431111326714,1052.4370150565321,1051.4338187292565,1050.433513633133,1049.4360912682253,
	1048.4415431524162,1047.4498608209192,1046.4610358264013,1045.475059738308,1044.4919241429345,
	1043.5116206429311,1042.5341408572688,1041.5594764210582,1040.587618985007,1039.61856021528,
	1038.6522917935229,1037.6888054162678,1036.7280927948143,1035.770145655095,1034.8149557371833,
	1033.86251479537,1032.912814597586,1031.9658469254225,1031.0216035736132,1030.080076350158,
	1029.1412570756795,1028.2051375834635,1027.2717097189986,1026.3409653399433,1025.412896315629,
	1024.4874945270396,1023.5647518664729,1022.644660237229,1021.7272115533837,1020.8123977395398,
	1019.9002107307545,1018.9906424719115,1018.0836849178968,1017.1793300329373,1016.277569790658,
	1015.3783961736458,1014.4818011733167,1013.5877767895068,1012.6963150304033,1011.8074079121353,
	1010.9210474586138,1010.0372257011496,1009.1559346783787,1008.277166435879,1007.4009130258484,
	1006.5271665070511,1005.6559189443688,1004.787162408597,1003.9208889762639,1003.0570907291458,
	1002.1957597543342,1001.3368881436716,1000.480467993665,999.6264914051773,998.7749504831164,
	997.9258373361631,997.0791440766519,996.2348628201066,995.3929856850391,994.5535047928407,
	993.7164122672152,992.8817002342904,992.0493608218796,991.2193861595193,990.3917683783441,
	989.5664996102818,988.7435719884141,987.9229776463071,987.1047087176094,986.2887573363771,
	985.4751156360867,984.6637757499198,983.8547298101411,983.0479699479478,982.2434882932173,
	981.4412769741743,980.6413281171468,979.8436338463176,979.0481862832876,978.2549775470328,
	977.4639997533789,976.6752450149919,975.8887054407813,975.1043731358548,974.3222402011875,
	973.5422987332445,972.7645408238162,971.9889585596085,971.215544022092,970.4442892871191,
	969.675186424668,968.9082274985705,968.1434045661197,967.3807096779773,966.6201348776677,
	965.8616722015048,965.1053136781491,964.3510513282043,963.5988771643531,962.8487831904847,
	962.1007614019451,961.3548037848498,960.6109023160159,959.8690489626093,959.1292356816427,
	958.3914544201049,957.6556971143203,956.9219556897673,956.1902220606927,955.4604881300463,
	954.7327457888318,954.0069869161654,953.2832033787453,952.5613870305281,951.8415297127063,
	951.1236232529876,950.4076594657673,949.6936301513779,948.9815270960279,948.2713420714824,
	947.5630668348009,946.8566931278247,946.1522126771184,945.449617193505,944.7488983718188,
	944.0500478906296,943.3530574118513,942.6579185804962,941.9646230244377,941.2731623538956,
	940.5835281613814,939.8957120210845,939.209705488923,938.5255001019476,937.8430873782082,
	937.1624588162933,936.4836058951944,935.8065200738731,935.1311927909408,934.4576154643911,
	933.7857794914439,933.1156762478754,932.4472970880656,931.780633344425,931.1156763272853,
	930.4524173244622,929.7908476009707,929.1309583987755,928.4727409363956,927.8161864086942,
	927.1612859863662,926.5080308159273,925.8564120192135,925.206420692936,924.5580479087328,
	923.9112847126216,923.2661221247625,922.6225511390267,921.9805627228836,921.340147816848,
	920.7012973344765,920.0640021618682,919.4282531573132,918.7940411510947,918.1613569452613,
	917.5301913129978,916.900534998763,916.2723787175748,915.6457131549255,915.0205289665887,
	914.3968167780163,913.7745671841415,913.1537707493671,912.5344180067585,911.9164994582192,
	911.3000055737782,910.6849267916975,910.0712535178953,909.4589761256974,908.8480849556643,
	908.238570315,907.6304224778168,907.0236316841931,906.4181881403262,905.8140820180616,
	905.2113034547571,904.6098425526519,904.0096893791007,903.4108339658278,902.8132663089322,
	902.2169763684078,901.621954068006,901.0281892949323,900.4356718994924,899.8443916949703,
	899.2543384571654,898.6655019243319,898.0778717967214,897.4914377363646,896.9061893669976,
	896.322116273475,895.73920800179,895.1574540586204,894.5768439112632,893.9973669871155,
	893.4190126738579,892.8417703186253,892.2656292282721,891.6905786689389,891.1166078656872,
	890.543706002426,889.971862221653,889.4010656241578,888.8313052689297,888.2625701727204,
	887.6948493100618,887.1281316127637,886.5624059700359,885.9976612279459,885.4338861894608,
	884.8710696140555,884.309200217684,883.7482666724549,883.188257606459,882.6291616035954,
	882.0709672033863,881.5136629008069,880.9572371460753,880.4016783444721,879.8469748562161,
	879.2931149961927,878.7400870341008,878.1878791937381,877.6364796535164,877.0858765457068,
	876.5360579567061,875.9870119268375,875.4387264500417,874.8911894740415,874.3443888998803,
	873.7983125822533,873.2529483289707,872.7082839012728,872.1643070135115,871.6210053331482,
	871.0783664808833,870.5363780304065,869.9950275085602,869.4543023954137,868.9141901240455,
	868.3746780811067,867.8357536065722,867.2974039941827,866.7596164915097,866.2223783005694,
	865.6856765780693,865.1494984358628,864.6138309419028,864.0786611208257,863.5439759552507,
	863.0097623866316,862.4760073174351,861.9426976124673,861.4098201015602,860.8773615823758,
	860.3453088238801,859.8136485707367,859.2823675485417,858.7514524700248,858.2208900432962,
	857.6906669813064,857.160770013446,856.6311859001738,856.1019014506328,855.5729035443378,
	855.0441791575338,854.5157153960498,853.9874995352517,853.4595190693188,852.9317617722521,
	852.4042157726952,851.8768696467006,851.3497125329519,850.8227342753075,850.2959256009127,
	849.7692783421891,849.2427857153609,848.7164426708041,848.1902463352916,847.6641965722208,
	847.1382966954736,846.6125543804714,846.0869828329345,845.5616022912147,845.0364419621155,
	844.5115425166083,843.9869593033847,843.4627664738742,842.9390622435611,842.41597553777,
	841.8936742698639,841.3723754506519,840.8523572128363,840.3339726065333,839.8176646695503,
	839.3039817754603,838.7935916564734,838.2872918706867,837.7860140029038,837.2908187711614,
	836.8028796705851,836.3234539470318,835.853841480507,835.3953342671177,834.9491611171721,
	834.516433397182,834.0980977512858,833.6949006803562,833.3073679222001,832.9357992770971,
	832.5802774245652,832.2406877915398,831.9167458174597,831.6080279744202,831.3140034167182,
	831.0340639206748,830.7675506020071,830.5137766369005,830.2720457774623,830.0416668459486,
	829.8219646204891,829.6122876343568,829.412013435716,829.2205518218184,829.0373465081797,
	828.8618756197527,828.6936513230652,828.5322188567767,828.3771551549181,828.228067218656,
	828.0845903458497,827.9463863065654,827.8131415184613,827.6845652659484,827.5603879915022,
	827.4403596719491,827.3242482966033,827.211838442908,827.1029299545008,826.9973367243623,
	826.8948855659089,826.7954151820275,826.6987752151553,826.6048253786771,826.5134346624112,
	826.4244806034967,826.3378486224449,826.2534314145203,826.1711283924078,826.0908451799692,
	826.012493143325,825.9359889691242,825.861254271806,825.7882152354894,825.716802288874,
	825.6469498034746,825.578595815367,825.5116817763806,825.4461523153127,825.3819550271303,
	825.3190402734263,825.2573609997792,825.196872569313,825.1375326046303,825.0793008459923,
	825.0221390181517,824.9660107073703,824.910881245912,824.856717608809,824.8034883126661,
	824.7511633285435,824.6997139931207,824.6491129313118,824.5993339838499,824.5503521373706,
	824.5021434613078,824.4546850485128,824.4079549577333,824.3619321638769,824.3165965087445,
	824.2719286538451,824.2279100394674,824.1845228455526,824.1417499502622,824.0995748982532,
	824.0579818665178,824.0169556339283,823.976481548153,823.9365455046802,823.8971339146378,
	823.8582336850009,823.8198321913568,823.7819172606186,823.7444771453928,823.707500509151,
	823.670976405588,823.6348942616978,823.599243861183,823.5640153288305,823.5291991168165,
	823.4947859883765,823.4607670090548,823.4271335272147,823.3938771701559,823.3609898263721,
	823.3284636384955,823.296290992334,823.2644645028143,823.2329770144017,823.2018215827092,
	823.1709914703189,823.140480139662,823.1102812448319,823.0803886200142,823.0507962816215,
	823.0214984111259,822.9924893576735,822.9637636270234,822.9353158767386,822.9071409127192,
	822.8792336811719,822.8515892635005,822.8242028763173,822.7970698613614,822.7701856814344,
	822.7435459205337,822.7171462766784,822.6909825572673,822.6650506769265,822.6393466575072,
	822.6138666126393,822.5886067595858,822.5635634069936,822.5387329534743,822.5141118858068,
	822.489696776037,822.4654842773618,822.4414711247922,822.4176541264093,822.3940301698173,
	822.3705962106103,822.3473492781407,822.324286468257,822.3014049417482,822.2787019275503,
	822.2561747114272,822.2338206447978,822.2116371353004,822.1896216455266,822.1677716957014,
	822.1460848629397,822.1245587665001,822.1031910888539,822.0819795550732,822.0609219376418,
	822.0400160573411,822.0192597801882,821.9986510162265,821.9781877160088,821.9578678806284,
	821.9376895389681,821.9176507684099,821.8977496824782,821.8779844327429,821.8583532043641,
	821.838854222226,821.8194857443632,821.8002460609241,821.7811334969913,821.7621464094897,
	821.7432831861939,821.7245422463451,821.7059220345819,821.6874210323984,821.6690377410414,
	821.6507706967767,821.6326184587243,821.6145796123292,821.5966527716536,821.5788365694826,
	821.5611296711307,821.5435307619894,821.5260385469002,821.5086517603745,821.4913691558684,
	821.4741895072618,821.4571116125139,821.4401342896151,821.4232563745162,821.4064767261287,
	821.3897942195099,821.3732077524513,821.3567162380606,821.3403186094913,821.3240138176536,
	821.3078008285381,821.291678625707,821.2756462157299,821.2597026076683,821.2438468415876,
	821.2280779639141,821.2123950370338,821.1967971419867,821.1812833714022,821.16585283281,
	821.1505046496786,821.1352379553546,821.1200519001734,821.1049456444966,821.0899183648031,
	821.0749692474143,821.060097492522,821.0453023132413,821.0305829321723,821.0159385853622,
	821.0013685198303,820.9868719925707,820.9724482729565,820.9580966420974,820.9438163894595,
	820.929606816217,820.9154672329091,820.9013969590636,820.8873953288763,820.873461677614,
	820.8595953561925,820.8457957265691,820.8320621526588,820.8183940116046,820.8047906913865,
	820.7912515850605,820.7777760939366,820.7643636278383,820.751013605853,820.7377254543892,
	820.7244986106563,820.7113325125624,820.6982266124596,820.6851803686167,820.6721932388356,
	820.6592647003642,820.6463942312423,820.6335813143879,820.6208254406679,820.6081261135257,
	820.595482833006,820.5828951154461,820.5703624758581,820.5578844394294,820.5454605340608,
	820.5330902975401,820.5207732742732,820.5085090084582,820.4962970549565,820.484136975871,
	820.4720283304509,820.4599706925502,820.4479636380017,820.4360067450085,820.4240996014637,
	820.4122417972968,820.400432928464,820.3886725942194,820.3769604024413,820.3652959663934,
	820.3536788949067,820.3421088109437,820.3305853386884,820.3191081056596,820.3076767481903,
	820.2962908991735,820.2849502025917,820.2736543030505,820.2624028515099,820.2511955047629,
	820.2400319173723,820.2289117503013,820.2178346723385,820.206800350419,820.1958084617444,
	820.184858680213,820.173950686685,820.1630841681035,820.1522588108425,820.141474305286,
	820.1307303489261,820.1200266354667,820.1093628695395,820.0987387552893,820.0881540032861,
	820.0776083207943,820.0671014255998,820.0566330328202,820.046202864,820.0358106449568,
	820.0254560984597,820.0151389533988,820.0048589482667,819.9946158129293,819.9844092890687,
	819.9742391077556,819.9641050269403,819.9540067861168,819.9439441326628,819.9339168191309,
	819.9239246003248,819.913967232934,819.9040444728687,819.8941560880164,819.884301835595,
	819.8744814867309,819.8646948100401,819.854941574043,819.8452215540817,819.8355345267025,
	819.8258802672483,819.8162585585744,819.8066691802443,819.7971119194297,819.787586562615,
	819.77809289902,819.7686307159623,819.759199812283,819.7497999765158,819.7404310091513,
	819.7310927097272,819.7217848801247,819.7125073167076,819.7032598335293,819.6940422321629,
	819.6848543165077,819.6756959074795,819.6665668110762,819.6574668390728,819.6483958070585,
	819.6393535401255,819.6303398493849,819.6213545586046,819.6123974892446,819.6034684680837,
	819.5945673179333,819.5856938644351,819.576847945543,819.5680293829652,819.5592380085685,
	819.5504736619554,819.5417361721975,819.5330253798887,819.5243411194766,819.5156832358849,
	819.5070515634452,819.498445952169,819.4898662391688,819.4813122752597,819.4727839023572,
	819.4642809687829,819.4558033277324,819.4473508265753,819.4389233185383,819.4305206562141,
	819.4221426936837,819.4137892902004,819.4054602961171,819.397155576729,819.3888749881992,
	819.3806183913811,819.3723856457618,819.3641766173237,819.3559911738469,819.3478291752135,
	819.3396904894139,819.3315749822075,819.323482528754,819.315412994419,819.3073662481042,
	819.2993421689771,819.2913406201399,819.2833614881496,819.275404638265,819.2674699519749,
	819.259557301162,819.2516665707319,819.2437976347355,819.2359503779059,819.2281246805089,
	819.220320424409,819.212537489799,819.2047757656985,819.1970351336312,819.1893154819974,
	819.181616698439,819.1739386667267,819.1662812773791,819.1586444223616,819.1510279920524,
	819.1434318727846,819.1358559632739,819.1283001544459,819.1207643376523,819.1132484140137,
	819.1057522697831,819.0982758074254,819.0908189267318,819.0833815205623,819.0759634867431,
	819.0685647343056,819.0611851492947,819.0538246474342,819.0464831195025,819.0391604747375,
	819.0318566146233,819.024571443438,819.0173048624036,819.0100567850186,819.0028271097044,
	818.9956157473208,818.988422607004,818.9812475946324,818.974090618633,818.9669515919031,
	818.959830419528,818.9527270199075,818.94564130216,818.9385731775077,818.9315225580154,
	818.9244893553251,818.9174734924909,818.9104748751654,818.9034934240171,818.896529057693,
	818.8895816863466,818.8826512335638,818.87573761019,818.8688407417594,818.8619605452271,
	818.8550969360269,818.8482498442999,818.8414191829265,818.8346048771422,818.827806846776,
	818.8210250136976,818.8142593021752,818.8075096400535,818.800775948234,818.7940581487564,
	818.787356172126,818.7806699366807,818.7739993786104,818.7673444152285,818.7607049810103,
	818.754081000609,818.7474724018475,818.7408791152283,818.7343010762963,818.7277382033839,
	818.7211904330466,818.7146576925878,818.7081399145692,818.7016370358948,818.6951489830461,
	818.6886756899709,818.6822170872974,818.6757731172936,818.6693437028861,818.6629287912165,
	818.6565283037659,818.6501421819951,818.6437703642929,818.6374127785986,818.631069372225,
	818.6247400761788,818.6184248315055,818.6121235745081,818.6058362364271,818.5995627628865,
	818.5933031014539,818.5870571728536,818.5808249303437,818.5746063063553,818.5684012528407,
	818.5622096969364,818.5560315872212,818.549866871119,818.5437154811899,818.537577363445,
	818.5314524609419,818.5253407193369,818.519242076459,818.513156486905,818.5070838802471,
	818.5010242137281,818.4949774272565,818.4889434669237,818.482922276628,818.4769138056004,
	818.4709179993971,818.4649348105494,818.4589641722558,818.453006043556,818.4470603663833,
	818.4411270891278,818.435206169264,818.4292975423324,818.4234011653367,818.4175169866976,
	818.41164495736,818.405785021547,818.3999371363092,818.3941012501048,818.3882773127148,
	818.3824652717733,818.3766650885517,818.3708767034658,818.3651000777903,818.3593351639212,
	818.3535819085778,818.3478402655101,818.3421101913248,818.3363916389661,818.3306845577126,
	818.3249889092689,818.3193046464887,818.3136317142616,818.3079700812862,818.3023196934943,
	818.2966805111042,818.291052483113,818.2854355755801,818.2798297387087,818.2742349274631,
	818.2686511036452,818.2630782195224,818.2575162345576,818.2519651067538,818.2464247936556,
	818.2408952502997,818.2353764421578,818.2298683196858,818.2243708454979,818.2188839726153,
	818.2134076697383,818.2079418956637,818.2024866067808,818.1970417570492,818.1916073176724,
	818.186183239563,818.1807694847116,818.1753660217776,818.1699728077521,818.1645897993359,
	818.1592169554018,818.1538542576594,818.1485016411593,818.1431590928556,818.1378265536262,
	818.1325039932817,818.1271913839704,818.1218886786771,818.1165958450691,818.1113128453761,
	818.1060396342624,818.1007761893734,818.0955224687542,818.0902784370965,818.0850440576347,
	818.0798192978301,818.074604119365,818.0693984875115,818.0642023656691,818.0590157241337,
	818.0538385238061,818.0486707349924,818.0435123211957,818.0383632484366,818.0332234795434,
	818.0280929890585,818.0229717344282,818.0178596922265,818.0127568145505,818.0076630858739,
	818.0025784603291,817.997502919381,817.9924364162604,817.9873789227594,817.9823304138188,
	817.9772908497355,817.9722602043059,817.9672384381485,817.9622255254416,817.9572214428778,
	817.9522261441367,817.9472396089527,817.942261800435,817.9372926954408,817.9323322582859,
	817.9273804642154,817.9224372711657,817.917502661258,817.9125765976029,817.9076590514603,
	817.9027499995178,817.8978494172147,817.8929572527684,817.8880734963825,817.8831981126029,
	817.8783310778341,817.8734723565182,817.8686219276905,817.8637797534352,817.8589458123977,
	817.8541200821156,817.849302521891,817.8444931112141,817.8396918273,817.8348986321872,
	817.8301135074594,817.825336416328,817.8205673464211,817.8158062622539,817.8110531279674,
	817.8063079329761,817.8015706400055,817.7968412300074,817.7921196753357,817.7874059468709,
	817.7827000195283,817.7780018723544,817.7733114673526,817.7686287974047,817.763953821951,
	817.7592865225715,817.7546268661578,817.7499748386273,817.7453304099975,817.740693554835,
	817.7360642539919,817.7314424726808,817.7268281920883,817.7222213891572,817.7176220414316,
	817.7130301205419,817.7084456015873,817.7038684619025,817.6992986811117,817.6947362366267,
	817.6901811007299,817.6856332508869,817.6810926627164,817.6765593104446,817.6720331830219,
	817.6675142436168,817.6630024779951,817.6584978576942,817.6540003703069,817.6495099804442,
	817.645026663731,817.6405504195711,817.6360812054442,817.631619007538,817.6271637976995,
	817.6227155636441,817.6182742710585,817.6138399096067,817.6094124566204,817.6049918842483,
	817.6005781751418,817.5961713080682,817.5917712587292,817.5873780065629,817.582991539107,
	817.5786118258773,817.5742388499842,817.5698725872568,817.5655130151139,817.5611601242792,
	817.5568138826955,817.5524742827452,817.5481412905231,817.5438148971093,817.53949507151,
	817.5351818000145,817.5308750619832,817.5265748358697,817.522281108417,817.5179938572188,
	817.5137130598456,817.5094386938491,817.5051707494954,817.5009091960271,817.4966540281642,
	817.4924052151607,817.4881627376919,817.4839265883728,817.4796967373702,817.4754731712147,
	817.4712558724766,817.4670448202647,817.4628399896803,817.4586413718448,817.4544489478109,
	817.4502626914473,817.4460825945494,817.4419086293536,817.4377407851089,817.4335790449086,
	817.429423382443,817.425273792217,817.421130239897,817.4169927215137,817.4128612219184,
	817.4087357114951,817.404616175723,817.4005026014676,817.396394972586,817.3922932734813,
	817.3881974749455,817.3841075734606,817.3800235431909,817.3759453744674,817.3718730467289,
	817.3678065376553,817.3637458435046,817.359690933426,817.3556418062542,817.3515984290613,
	817.347560802821,817.3435288948582,817.3395027027218,817.3354822005001,817.3314673744156,
	817.3274582123087,817.3234546946888,817.319456797055,817.3154645268974,817.3114778487604,
	817.3074967526871,817.3035212255886,817.2995512432262,817.2955867971204,817.2916278760988,
	817.2876744583139,817.2837265358482,817.2797840738854,817.2758470814797,817.2719155274822,
	817.2679894013759,817.2640686976396,817.2601533822672,817.2562434592189,817.2523389015479,
	817.248439699766,817.2445458378552,817.2406572995342,817.236774074972,817.2328961410424,
	817.229023491746,817.2251561135622,817.2212939878765,817.2174370982211,817.213585432705,
	817.2097389845159,817.2058977198615,817.2020616416461,817.1982307423531,817.1944049878047,
	817.1905843758602,817.1867688928077,817.1829585232794,817.1791532457639,817.1753530585756,
	817.171557942186,817.167767886586,817.1639828756785,817.1602029014799,817.1564279434186,
	817.1526579905968,817.14889302389,817.1451330383962,817.1413780195379,817.1376279454763,
	817.133882824128,817.1301426182555,817.1264073312857,817.1226769455328,817.118951441491,
	817.1152308160072,817.1115150536797,817.1078041398779,817.1040980607497,817.1003968113178,
	817.0967003671925,817.0930087233999,817.0893218668496,817.085639787668,817.0819624631359,
	817.0782898957481,817.074622063266,817.070958950422,817.0673005519496,817.0636468598411,
	817.0599978505331,817.0563535192276,817.0527138567942,817.0490788472985,817.0454484745331,
	817.0418227287867,817.0382015991439,817.0345850791645,817.0309731529069,817.0273658125178,
	817.0237630354364,817.0201648258719,817.0165711535843,817.0129820261183,817.0093974164753,
	817.0058173177476,817.0022417244945,816.9986706226659,816.9951040033152,816.9915418442021,
	816.9879841427758,816.984430885386,816.9808820665277,816.9773376737797,816.9737976876211,
	816.9702621131642,816.966730917868,816.9632040996242,816.9596816589087,816.9561635683948,
	816.95264983514,816.9491404319706,816.945635348566,816.9421345915658,816.9386381305713,
	816.9351459649465,816.9316580859,816.9281744699639,816.9246951278826,816.9212200358926,
	816.9177491791752,816.9142825561701,816.9108201555543,816.9073619636521,816.9039079779378,
	816.900458168218,816.8970125522856,816.8935710946693,816.8901338080703,816.8867006670315,
	816.883271661091,816.8798467933359,816.8764260317807,816.8730093912006,816.8695968398479,
	816.8661883879051,816.8627840186189,816.8593837150704,816.8559874722458,816.8525952844976,
	816.8492071333493,816.8458230090006,816.8424429153044,816.8390668322405,816.8356947495861,
	816.8323266619692,816.828962557812,816.8256024393021,816.8222462678436,816.8188940626167,
	816.815545802005,816.8122014798828,816.8088610843826,816.8055246029805,816.8021920403884,
	816.7988633652524,816.7955385944388,816.7922177036132,816.7889006818355,816.7855875236856,
	816.782278219042,816.7789727668015,816.7756711492663,816.7723733684786,816.7690793917639,
	816.765789237354,816.762502877957,816.7592203134548,816.75594153282,816.7526665276912,
	816.7493952919115,816.746127818707,816.7428640810123,816.7396040958481,816.736347833128,
	816.7330953084496,816.7298464903298,816.7266013781743,816.7233599648392,816.7201222438414,
	816.7168882026604,816.7136578379508,816.7104311324475,816.7072080889012,816.7039886921547,
	816.7007729279596,816.6975607930303,816.6943522962548,816.691147405604,816.6879461291977,
	816.6847484511133,816.6815543524006,816.6783638560612,816.6751769113032,816.6719935486615,
	816.6688137416659,816.6656374760494,816.662464764562,816.6592955898045,816.6561299419039,
	816.6529678020719,816.649809189205,816.6466540683156,816.6435024463326,816.6403543105251,
	816.6372096575775,816.6340684733466,816.6309307626942,816.62779650357,816.6246656982096,
	816.6215383411135,816.6184144033116,816.6152939005267,816.6121768210164,816.6090631450222,
	816.6059528779349,816.6028460064508,816.5997425285764,816.5966424302544,816.5935457038537,
	816.5904523472082,816.5873623567302,816.5842757125598,816.5811924115498,816.5781124603051,
	816.5750358300498,816.5719625259693,816.5688925416476,816.5658258741793,816.5627624957094,
	816.5597024134256,816.5566456249383,816.5535921184562,816.5505418716898,816.5474949114076,
	816.5444512046822,816.5414107505268,816.5383735416408,816.5353395724777,816.5323088387892,
	816.5292813219024,816.5262570376744,816.5232359513327,816.5202180717221,816.5172034059473,
	816.5141919126901,816.511183614923,816.508178499054,816.5051765332754,816.5021777522999,
	816.4991821173992,816.49618964136,816.4932003082727,816.4902141109034,816.4872310424591,
	816.484251104369,816.4812742853832,816.4783005735259,816.4753299718793,816.4723624632554,
	816.4693980449783,816.4664367173649,816.4634784705853,816.4605232910435,816.4575711838601,
	816.4546221314478,816.4516761408523,816.4487331923282,816.4457932813631,816.4428564084449,
	816.4399225676386,816.4369917453004,816.4340639429819,816.4311391463089,816.428217357347,
	816.4252985563879,816.4223827602158,816.4194699437542,816.416560099309,816.4136532383575,
	816.4107493407121,816.4078484036877,816.4049504244329,816.4020553947639,816.3991633060501,
	816.3962741448204,816.3933879208898,816.3905046299413,816.3876242433734,816.3847467812974,
	816.3818722235465,816.3790005647708,816.3761318047955,816.3732659323285,816.3704029496043,
	816.3675428328887,816.364685597366,816.3618312223501,816.3589797099922,816.356131062257,
	816.353285255848,816.3504422918757,816.3476021689856,816.3447648738994,816.3419304122338,
	816.3390987648135,816.3362699300466,816.3334439109368,816.3306206912339,816.3278002811733,
	816.3249826517547
	}}
};
