﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Composition;
using Microsoft.CodeAnalysis.CSharp.LanguageService;
using Microsoft.CodeAnalysis.Host.Mef;
using Microsoft.CodeAnalysis.LanguageService;

namespace Microsoft.CodeAnalysis.CSharp
{
    [ExportLanguageService(typeof(IFileBannerFactsService), LanguageNames.CSharp), Shared]
    internal class CSharpFileBannerFactsService : CSharpFileBannerFacts, IFileBannerFactsService
    {
        [ImportingConstructor]
        [Obsolete(MefConstruction.ImportingConstructorMessage, error: true)]
        public CSharpFileBannerFactsService()
        {
        }
    }
}
