/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.feature.LanguageFeature;
import adql.parser.grammar.ParseException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.UnknownType;
import adql.query.operand.function.ADQLFunction;

public abstract class GeometryFunction
extends ADQLFunction {
    @Deprecated
    protected ADQLOperand coordSys = null;

    protected GeometryFunction() {
        this.coordSys = null;
    }

    @Deprecated
    protected GeometryFunction(ADQLOperand coordSys) throws UnsupportedOperationException, NullPointerException, Exception {
        this.setCoordinateSystem(coordSys);
    }

    protected GeometryFunction(GeometryFunction toCopy) throws Exception {
        this.coordSys = (ADQLOperand)toCopy.coordSys.getCopy();
        this.setPosition(toCopy.getPosition() == null ? null : new TextPosition(toCopy.getPosition()));
    }

    @Deprecated
    public ADQLOperand getCoordinateSystem() {
        return this.coordSys;
    }

    @Deprecated
    public void setCoordinateSystem(ADQLOperand coordSys) throws UnsupportedOperationException, NullPointerException, ParseException {
        if (coordSys == null) {
            this.coordSys = new StringConstant("");
        } else {
            if (!coordSys.isString()) {
                throw new ParseException("A coordinate system must be a string literal: \"" + coordSys.toADQL() + "\" is not a string operand!");
            }
            this.coordSys = coordSys;
            this.setPosition(null);
        }
    }

    public static final class GeometryValue<F extends GeometryFunction>
    implements ADQLOperand {
        private F geomFunct;
        private UnknownType unknownValue;
        private TextPosition position = null;

        public GeometryValue(F geometry) throws NullPointerException {
            if (geometry == null) {
                throw new NullPointerException("Impossible to build a GeometryValue without a geometry function or an operand whose type can not be determined at parsing time (e.g. a column, a User Defined Function, a casting function)!");
            }
            this.setGeometry(geometry);
        }

        public GeometryValue(UnknownType val) throws NullPointerException {
            if (val == null) {
                throw new NullPointerException("Impossible to build a GeometryValue without a geometry function or an operand whose type can not be determined at parsing time (e.g. a column, a User Defined Function, a casting function)!");
            }
            this.setUnknownTypeValue(val);
        }

        public GeometryValue(GeometryValue<F> toCopy) throws Exception {
            this.unknownValue = toCopy.unknownValue == null ? null : (UnknownType)toCopy.unknownValue.getCopy();
            this.geomFunct = toCopy.geomFunct == null ? null : (GeometryFunction)toCopy.geomFunct.getCopy();
            this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
        }

        @Override
        public final LanguageFeature getFeatureDescription() {
            return this.unknownValue != null ? this.unknownValue.getFeatureDescription() : this.geomFunct.getFeatureDescription();
        }

        @Deprecated
        public final void setColumn(ADQLColumn col) {
            this.setUnknownTypeValue(col);
        }

        public void setGeometry(F geometry) {
            if (geometry != null) {
                this.unknownValue = null;
                this.geomFunct = geometry;
                this.position = ((ADQLFunction)this.geomFunct).getPosition() != null ? ((ADQLFunction)this.geomFunct).getPosition() : null;
            }
        }

        public void setUnknownTypeValue(UnknownType val) {
            if (val != null) {
                this.unknownValue = val;
                this.geomFunct = null;
                this.position = val.getPosition() != null ? val.getPosition() : null;
            }
        }

        public ADQLOperand getValue() {
            if (this.geomFunct != null) {
                return this.geomFunct;
            }
            return this.unknownValue;
        }

        public boolean isColumn() {
            return this.unknownValue != null && this.unknownValue instanceof ADQLColumn;
        }

        @Override
        public boolean isNumeric() {
            return this.getValue().isNumeric();
        }

        @Override
        public boolean isString() {
            return this.getValue().isString();
        }

        @Override
        public TextPosition getPosition() {
            return this.position;
        }

        @Override
        public boolean isGeometry() {
            return this.getValue().isGeometry();
        }

        @Override
        public ADQLObject getCopy() throws Exception {
            return new GeometryValue<F>(this);
        }

        @Override
        public String getName() {
            return this.getValue().getName();
        }

        @Override
        public ADQLIterator adqlIterator() {
            return this.getValue().adqlIterator();
        }

        @Override
        public String toADQL() {
            return this.getValue().toADQL();
        }
    }
}

