// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "NuGetConsole.Host.PowerShell.Resources.resources")]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "NuGetConsole.Host")]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "NuGetConsole.Host.PowerShell.Implementation")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", MessageId = "isSync", Scope = "member", Target = "NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.#GetPathExpansionsAsyncCore(System.String,System.Boolean,System.Threading.CancellationToken)")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.HandleSolutionOpened")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<SimpleExpansion> CommandExpansion.GetExpansionsAsync(string line, int caretIndex, CancellationToken token)', validate parameter 'line' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.CommandExpansion.GetExpansionsAsync(System.String,System.Int32,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGetConsole.SimpleExpansion}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object MethodBinder.ChangeType(ParameterInfo parameterInfo, object arg)', validate parameter 'parameterInfo' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.ChangeType(System.Reflection.ParameterInfo,System.Object)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object MethodBinder.Invoke(MethodInfo method, object target, object[] args)', validate parameter 'method' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.Invoke(System.Reflection.MethodInfo,System.Object,System.Object[])~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool MethodBinder.TryGetOptionalArg(ParameterInfo paramInfo, out object argValue)', validate parameter 'paramInfo' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.TryGetOptionalArg(System.Reflection.ParameterInfo,System.Object@)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool MethodBinder.TryInvoke(Type type, string name, object target, object[] args, out object result)', validate parameter 'type' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.TryInvoke(System.Type,System.String,System.Object,System.Object[],System.Object@)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ExecuteInitPs1Async' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.ExecuteInitPs1Async(System.String,NuGet.Packaging.Core.PackageIdentity)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1822:Member IsWebSiteAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.IsWebSiteAsync(NuGet.VisualStudio.IVsProjectAdapter)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PSObject PSTypeWrapper.CreateInterfaceWrapper(TypeWrapper<PSObject> wrapper, Type interfaceType)', validate parameter 'wrapper' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PSTypeWrapper.CreateInterfaceWrapper(NuGetConsole.Host.TypeWrapper{System.Management.Automation.PSObject},System.Type)~System.Management.Automation.PSObject")]
[assembly: SuppressMessage("Build", "CA1822:Member CollectPackagesForPackagesConfigAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.InstalledPackageEnumerator.CollectPackagesForPackagesConfigAsync(NuGet.ProjectManagement.NuGetProject,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{NuGet.Frameworks.NuGetFramework,System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity}}}")]
[assembly: SuppressMessage("Build", "CA1822:Member OrderPackagesForPackagesConfigAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.InstalledPackageEnumerator.OrderPackagesForPackagesConfigAsync(NuGet.PackageManagement.NuGetPackageManager,System.Collections.Generic.IDictionary{NuGet.Frameworks.NuGetFramework,System.Collections.Generic.ISet{NuGet.Packaging.Core.PackageIdentity}},System.Collections.Generic.ISet{NuGet.Packaging.Core.PackageIdentity},System.Collections.Generic.IList{NuGetConsole.Host.PowerShell.InstalledPackageEnumerator.PackageItem},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T TypeWrapper<T>.GetInterface(object scriptValue, Type interfaceType, Func<object, TypeWrapper<T>> getTypeWrapper)', validate parameter 'getTypeWrapper' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.TypeWrapper`1.GetInterface(System.Object,System.Type,System.Func{System.Object,NuGetConsole.Host.TypeWrapper`1})~`0")]
[assembly: SuppressMessage("Build", "CA1303:Method 'T TypeWrapper<T>.GetInterface(object scriptValue, Type interfaceType, Func<object, TypeWrapper<T>> getTypeWrapper)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Invalid argument\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.TypeWrapper`1.GetInterface(System.Object,System.Type,System.Func{System.Object,NuGetConsole.Host.TypeWrapper`1})~`0")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T TypeWrapper<T>.GetInterface(Type interfaceType)', validate parameter 'interfaceType' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.TypeWrapper`1.GetInterface(System.Type)~`0")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/NuGet.Client/pull/4435", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.WriteErrorLine(System.String)")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/NuGet.Client/pull/4435", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.WriteLine(System.String)")]
[assembly: SuppressMessage("Usage", "VSTHRD011:Use AsyncLazy<T>", Justification = "In PMC, this is the only option. It was already working the same way before but it was hidden.", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.#ctor(System.String,NuGet.VisualStudio.IRestoreEvents,NuGetConsole.Host.PowerShell.Implementation.IRunspaceManager,NuGet.Common.IEnvironmentVariableReader)")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.FindPackageCommand.FindPackagesByPSSearchService")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.FindPackageCommand.FindPackageStartWithId(System.Boolean)")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.InstallPackageCommand.ProcessRecordCore")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.SyncPackageCommand.ProcessRecordCore")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.UpdatePackageCommand.ProcessRecordCore")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.UninstallPackageCommand.ProcessRecordCore")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand._packageCount")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand._status")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.PowerShellCmdlets.PackageActionBaseCommand._lockService")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'InstallPackageByIdAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.InstallPackageCommand.InstallPackageByIdAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'InstallPackagesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.InstallPackageCommand.InstallPackagesAsync(System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1822:Member EnsureValidSource does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.EnsureValidSource(NuGet.PackageManagement.PowerShellCmdlets.SourceValidationResult)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NuGetPowerShellBaseCommand.EnsureValidSource(SourceValidationResult result)', validate parameter 'result' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.EnsureValidSource(NuGet.PackageManagement.PowerShellCmdlets.SourceValidationResult)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Dictionary<NuGetProject, IEnumerable<PackageReference>>> NuGetPowerShellBaseCommand.GetInstalledPackagesAsync(IEnumerable<NuGetProject> projects, string filter, int skip, int take, CancellationToken token)', validate parameter 'projects' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.GetInstalledPackagesAsync(System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject},System.String,System.Int32,System.Int32,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.Dictionary{NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<IVsProjectAdapter>> NuGetPowerShellBaseCommand.GetProjectsByNameAsync(string[] projectNames)', validate parameter 'projectNames' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.GetProjectsByNameAsync(System.String[])~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.VisualStudio.IVsProjectAdapter}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NuGetPowerShellBaseCommand.Log(ILogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.Log(NuGet.Common.ILogMessage)")]
[assembly: SuppressMessage("Build", "CA1822:Member SubscribeToProgressEvents does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.SubscribeToProgressEvents")]
[assembly: SuppressMessage("Build", "CA1822:Member UnsubscribeEvents does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.UnsubscribeEvents")]
[assembly: SuppressMessage("Build", "CA1822:Member UnsubscribeFromProgressEvents does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.NuGetPowerShellBaseCommand.UnsubscribeFromProgressEvents")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task PackageActionBaseCommand.InstallPackageByIdAsync(NuGetProject project, string packageId, ResolutionContext resolutionContext, INuGetProjectContext projectContext, bool isPreview)', validate parameter 'resolutionContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.PackageActionBaseCommand.InstallPackageByIdAsync(NuGet.ProjectManagement.NuGetProject,System.String,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,System.Boolean)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task PackageActionBaseCommand.InstallPackageByIdentityAsync(NuGetProject project, PackageIdentity identity, ResolutionContext resolutionContext, INuGetProjectContext projectContext, bool isPreview)', validate parameter 'resolutionContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.PackageActionBaseCommand.InstallPackageByIdentityAsync(NuGet.ProjectManagement.NuGetProject,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,System.Boolean)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> PowerShellCmdletsUtility.GetProjectTargetFrameworks(NuGetProject project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.PowerShellCmdletsUtility.GetProjectTargetFrameworks(NuGet.ProjectManagement.NuGetProject)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'int ProgressRecordCollection.GetKeyForItem(ProgressRecord item)', validate parameter 'item' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.ProgressRecordCollection.GetKeyForItem(System.Management.Automation.ProgressRecord)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SyncPackages' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.SyncPackageCommand.SyncPackages(System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject},NuGet.Packaging.Core.PackageIdentity)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UninstallPackageAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.UninstallPackageCommand.UninstallPackageAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UpdateOrReinstallAllPackagesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.UpdatePackageCommand.UpdateOrReinstallAllPackagesAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UpdateOrReinstallSinglePackageAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PowerShellCmdlets.UpdatePackageCommand.UpdateOrReinstallSinglePackageAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property PowerShellPackage.LicenseUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.PowerShellCmdlets.PowerShellPackage.LicenseUrl")]
[assembly: SuppressMessage("Build", "CA1501:'InstallPackageCommand' has an object hierarchy '6' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'PackageActionBaseCommand, NuGetPowerShellBaseCommand, PSCmdlet, Cmdlet, InternalCommand, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.PowerShellCmdlets.InstallPackageCommand")]
[assembly: SuppressMessage("Build", "CA1501:'SyncPackageCommand' has an object hierarchy '6' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'PackageActionBaseCommand, NuGetPowerShellBaseCommand, PSCmdlet, Cmdlet, InternalCommand, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.PowerShellCmdlets.SyncPackageCommand")]
[assembly: SuppressMessage("Build", "CA1501:'TabExpansionCommand' has an object hierarchy '6' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'FindPackageCommand, NuGetPowerShellBaseCommand, PSCmdlet, Cmdlet, InternalCommand, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.PowerShellCmdlets.TabExpansionCommand")]
[assembly: SuppressMessage("Build", "CA1501:'UpdatePackageCommand' has an object hierarchy '6' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'PackageActionBaseCommand, NuGetPowerShellBaseCommand, PSCmdlet, Cmdlet, InternalCommand, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.PowerShellCmdlets.UpdatePackageCommand")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.CompleteTaskAsync(System.Collections.Generic.List{System.Threading.Tasks.Task{System.Tuple{System.String,System.String}}})~System.Threading.Tasks.Task{System.Tuple{System.String,System.String}}")]
