// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Firmware.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.firmware {

  public class UpdateHistoryEntry : ICloneable {
    public object Clone() {
      UpdateHistoryEntry copy = new UpdateHistoryEntry();
      copy.timestamp = this.timestamp;
      copy.oldVersion = this.oldVersion;
      copy.imageVersion = this.imageVersion;
      copy.imageMD5 = this.imageMD5;
      copy.status = this.status;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
      json["oldVersion"] = this.oldVersion;
      json["imageVersion"] = this.imageVersion;
      json["imageMD5"] = this.imageMD5;
      json["status"] = (int)this.status;
      return json;
    }

    public static UpdateHistoryEntry Decode(LightJson.JsonObject json, Agent agent) {
      UpdateHistoryEntry inst = new UpdateHistoryEntry();
      inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
      inst.oldVersion = (string)json["oldVersion"];
      inst.imageVersion = (string)json["imageVersion"];
      inst.imageMD5 = (string)json["imageMD5"];
      inst.status = (Com.Raritan.Idl.firmware.UpdateHistoryStatus)(int)json["status"];
      return inst;
    }

    public System.DateTime timestamp = new System.DateTime(0);
    public string oldVersion = "";
    public string imageVersion = "";
    public string imageMD5 = "";
    public Com.Raritan.Idl.firmware.UpdateHistoryStatus status = Com.Raritan.Idl.firmware.UpdateHistoryStatus.SUCCESSFUL;
  }
}
