% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{preserveDelayedOperations}
\alias{preserveDelayedOperations}
\title{Preserve delayed operations during staging}
\usage{
preserveDelayedOperations(preserve)
}
\arguments{
\item{preserve}{Whether to preserve delayed operations using the \pkg{chihaya} specification.}
}
\value{
Logical scalar indicating whether delayed operations are to be preserved by the DelayedArray method.
If \code{preserve} is supplied, it is used to set this scalar, and the \emph{previous} value of the scalar is invisibly returned.
}
\description{
Preserve delayed operations via \pkg{chihaya} when staging a \linkS4class{DelayedArray} with \code{\link{stageObject}}.
}
\details{
By default, any DelayedArray in \code{\link{stageObject}} will be saved as a new dense array or sparse matrix.
However, if this option is enabled, DelayedArrays will instead be saved in the \pkg{chihaya} specification,
where the delayed operations are themselves stored in the HDF5 file (see \url{https://ltla.github.io/chihaya} for details).

The \pkg{chihaya} specification is more complicated to parse but can be helpful in reducing disk usage.
One simple example is to avoid sparsity-breaking or integer-to-float operations by storing their delayed representations in the file.
If the seed matrix is derived from some immutable reference location, advanced users can even store links to that location instead of duplicating the seed data.
}
\examples{
preserveDelayedOperations()
old <- preserveDelayedOperations(TRUE)
preserveDelayedOperations()
preserveDelayedOperations(old)

}
\author{
Aaron Lun
}
