% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReloadedArray.R
\name{ReloadedArraySeed}
\alias{ReloadedArraySeed}
\alias{ReloadedArraySeed-class}
\alias{ReloadedArray-class}
\alias{ReloadedMatrix-class}
\alias{DelayedArray,ReloadedArraySeed-method}
\alias{matrixClass,ReloadedArray-method}
\alias{coerce,ReloadedArray,ReloadedMatrix-method}
\alias{coerce,ReloadedMatrix,ReloadedArray-method}
\alias{path,ReloadedArraySeed-method}
\alias{saveObject,ReloadedArray-method}
\alias{ReloadedArray}
\title{Reloaded \pkg{alabaster} array}
\usage{
ReloadedArraySeed(path, seed = NULL, ...)

ReloadedArray(path, seed = NULL, ...)
}
\arguments{
\item{path}{String containing a path to the directory with the on-disk array representation.
Alternatively an existing ReloadedArraySeed, which is returned without modification.}

\item{seed}{Contents of the loaded array, e.g., as an ordinary R array, a \linkS4class{DelayedArray} or a sparse matrix.
If \code{NULL}, this is obtained by calling \code{\link{readObject}}.}

\item{...}{Further arguments to pass to \code{\link{readObject}} when \code{seed=NULL}.}
}
\value{
For the constructors, an instance of the \linkS4class{ReloadedArraySeed} or \linkS4class{ReloadedArray}.
}
\description{
An array that was reloaded from disk by the \code{\link{readObject}} function.
This allows methods to refer to the existing on-disk representation by inspecting the \code{path}.
For example, \code{\link{saveObject}} can just copy/link to the files instead of repeating the saving process.
}
\details{
The ReloadedArraySeed is a subclass of the \linkS4class{WrapperArraySeed} and will just forward all operations to the underlying \code{seed}.
Its main purpose is to track the \code{path} that was originally used to generate \code{seed}, which enables optimizations for methods that need to operate on the files.

One obvious optimization is the specialization of \code{\link{saveObject}} on ReloadedArray instances.
Instead of loading the array data back into the R session and saving it again, the \code{saveObject} method can just link or copy the existing files.
This behavior is controlled by the optional \code{ReloadedArray.reuse.files} option in the \code{saveObject} method, which can be one of:
\itemize{
\item \code{"copy"}: copy the files from the original directory (as stored in the ReloadedArray object) to the new \code{path} specified in \code{saveObject}.
\item \code{"link"}: create a hard link from the files in the original directory to the new \code{path}.
If this fails, we silently fall back to a copy.
This mode is the default approach.
\item \code{"symlink"}: create a symbolic link from the files in the original directory to the new \code{path}.
\item \code{"none"}: ignore existing files and just save the contents by calling \code{"\link{saveObject,DelayedArray-method}"}.
}
}
\examples{
arr <- array(rpois(10000, 10), c(50, 20, 10))
dir <- tempfile()
saveObject(arr, dir)
obj <- readArray(dir)
obj
DelayedArray::showtree(obj)

}
