# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._managed_database_vulnerability_assessment_rule_baselines_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ManagedDatabaseVulnerabilityAssessmentRuleBaselinesOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.sql.aio.SqlManagementClient`'s
        :attr:`managed_database_vulnerability_assessment_rule_baselines` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        database_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        rule_id: str,
        baseline_name: Union[str, _models.VulnerabilityAssessmentPolicyBaselineName],
        **kwargs: Any
    ) -> _models.DatabaseVulnerabilityAssessmentRuleBaseline:
        """Gets a database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance. Required.
        :type managed_instance_name: str
        :param database_name: The name of the database for which the vulnerability assessment rule
         baseline is defined. Required.
        :type database_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID. Required.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a database level rule and master for server level rule). Known values are: "master"
         and "default". Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :return: DatabaseVulnerabilityAssessmentRuleBaseline or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2020-11-01-preview"))
        cls: ClsType[_models.DatabaseVulnerabilityAssessmentRuleBaseline] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            managed_instance_name=managed_instance_name,
            database_name=database_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            rule_id=rule_id,
            baseline_name=baseline_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseVulnerabilityAssessmentRuleBaseline", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        database_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        rule_id: str,
        baseline_name: Union[str, _models.VulnerabilityAssessmentPolicyBaselineName],
        parameters: _models.DatabaseVulnerabilityAssessmentRuleBaseline,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseVulnerabilityAssessmentRuleBaseline:
        """Creates or updates a database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance. Required.
        :type managed_instance_name: str
        :param database_name: The name of the database for which the vulnerability assessment rule
         baseline is defined. Required.
        :type database_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID. Required.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a database level rule and master for server level rule). Known values are: "master"
         and "default". Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :param parameters: The requested rule baseline resource. Required.
        :type parameters: ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseVulnerabilityAssessmentRuleBaseline or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        database_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        rule_id: str,
        baseline_name: Union[str, _models.VulnerabilityAssessmentPolicyBaselineName],
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseVulnerabilityAssessmentRuleBaseline:
        """Creates or updates a database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance. Required.
        :type managed_instance_name: str
        :param database_name: The name of the database for which the vulnerability assessment rule
         baseline is defined. Required.
        :type database_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID. Required.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a database level rule and master for server level rule). Known values are: "master"
         and "default". Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :param parameters: The requested rule baseline resource. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseVulnerabilityAssessmentRuleBaseline or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        database_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        rule_id: str,
        baseline_name: Union[str, _models.VulnerabilityAssessmentPolicyBaselineName],
        parameters: Union[_models.DatabaseVulnerabilityAssessmentRuleBaseline, IO[bytes]],
        **kwargs: Any
    ) -> _models.DatabaseVulnerabilityAssessmentRuleBaseline:
        """Creates or updates a database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance. Required.
        :type managed_instance_name: str
        :param database_name: The name of the database for which the vulnerability assessment rule
         baseline is defined. Required.
        :type database_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID. Required.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a database level rule and master for server level rule). Known values are: "master"
         and "default". Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :param parameters: The requested rule baseline resource. Is either a
         DatabaseVulnerabilityAssessmentRuleBaseline type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline or
         IO[bytes]
        :return: DatabaseVulnerabilityAssessmentRuleBaseline or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2020-11-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DatabaseVulnerabilityAssessmentRuleBaseline] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "DatabaseVulnerabilityAssessmentRuleBaseline")

        _request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            managed_instance_name=managed_instance_name,
            database_name=database_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            rule_id=rule_id,
            baseline_name=baseline_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseVulnerabilityAssessmentRuleBaseline", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        managed_instance_name: str,
        database_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        rule_id: str,
        baseline_name: Union[str, _models.VulnerabilityAssessmentPolicyBaselineName],
        **kwargs: Any
    ) -> None:
        """Removes the database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance. Required.
        :type managed_instance_name: str
        :param database_name: The name of the database for which the vulnerability assessment rule
         baseline is defined. Required.
        :type database_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID. Required.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a database level rule and master for server level rule). Known values are: "master"
         and "default". Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2020-11-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            managed_instance_name=managed_instance_name,
            database_name=database_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            rule_id=rule_id,
            baseline_name=baseline_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
