# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.hdinsightcontainers import HDInsightContainersMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hdinsightcontainers
# USAGE
    python create_autoscale_cluster.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HDInsightContainersMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="10e32bab-26da-4cc4-a441-52b318f824e6",
    )

    response = client.clusters.begin_create(
        resource_group_name="hiloResourcegroup",
        cluster_pool_name="clusterpool1",
        cluster_name="cluster1",
        hd_insight_cluster={
            "location": "West US 2",
            "properties": {
                "clusterProfile": {
                    "authorizationProfile": {"userIds": ["testuser1", "testuser2"]},
                    "autoscaleProfile": {
                        "autoscaleType": "ScheduleBased",
                        "enabled": True,
                        "gracefulDecommissionTimeout": 3600,
                        "loadBasedConfig": {
                            "cooldownPeriod": 300,
                            "maxNodes": 20,
                            "minNodes": 10,
                            "pollInterval": 60,
                            "scalingRules": [
                                {
                                    "actionType": "scaleup",
                                    "comparisonRule": {"operator": "greaterThan", "threshold": 90},
                                    "evaluationCount": 3,
                                    "scalingMetric": "cpu",
                                },
                                {
                                    "actionType": "scaledown",
                                    "comparisonRule": {"operator": "lessThan", "threshold": 20},
                                    "evaluationCount": 3,
                                    "scalingMetric": "cpu",
                                },
                            ],
                        },
                        "scheduleBasedConfig": {
                            "defaultCount": 10,
                            "schedules": [
                                {"count": 20, "days": ["Monday"], "endTime": "12:00", "startTime": "00:00"},
                                {"count": 25, "days": ["Sunday"], "endTime": "12:00", "startTime": "00:00"},
                            ],
                            "timeZone": "Cen. Australia Standard Time",
                        },
                    },
                    "clusterVersion": "1.0.6",
                    "identityProfile": {
                        "msiClientId": "de91f1d8-767f-460a-ac11-3cf103f74b34",
                        "msiObjectId": "40491351-c240-4042-91e0-f644a1d2b441",
                        "msiResourceId": "/subscriptions/subid/resourceGroups/hiloResourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-msi",
                    },
                    "ossVersion": "0.410.0",
                    "sshProfile": {"count": 2},
                    "trinoProfile": {},
                },
                "clusterType": "Trino",
                "computeProfile": {
                    "nodes": [
                        {"count": 2, "type": "Head", "vmSize": "Standard_E8as_v5"},
                        {"count": 3, "type": "Worker", "vmSize": "Standard_E8as_v5"},
                    ]
                },
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2023-11-01-preview/examples/CreateAutoscaleCluster.json
if __name__ == "__main__":
    main()
