# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ElasticDeploymentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag specifying if the Elastic deployment status is healthy or not."""

    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"


class LiftrResourceCategories(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LiftrResourceCategories."""

    UNKNOWN = "Unknown"
    MONITOR_LOGS = "MonitorLogs"


class ManagedIdentityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Managed Identity types."""

    SYSTEM_ASSIGNED = "SystemAssigned"


class MonitoringStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag specifying if the resource monitoring is enabled or disabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class OperationName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation to be performed on the given vm resource id."""

    ADD = "Add"
    DELETE = "Delete"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of Elastic resource."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    NOT_SPECIFIED = "NotSpecified"


class SendingLogs(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag indicating the status of the resource for sending logs operation to Elastic."""

    TRUE = "True"
    FALSE = "False"


class TagAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Valid actions for a filtering tag. Exclusion takes priority over inclusion."""

    INCLUDE = "Include"
    EXCLUDE = "Exclude"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the elastic filter."""

    IP = "ip"
    AZURE_PRIVATE_ENDPOINT = "azure_private_endpoint"
