# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.containerservicefleet.v2023_10_15.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.containerservicefleet.v2023_10_15.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.containerservicefleet.v2023_10_15.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.v2023_10_15.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.v2023_10_15.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Fleet(TrackedResource):
    """The Fleet resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.v2023_10_15.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    :ivar identity: Managed identity.
    :vartype identity: ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedServiceIdentity
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "e_tag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed identity.
        :paramtype identity:
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedServiceIdentity
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.e_tag = None
        self.identity = identity
        self.provisioning_state = None


class FleetCredentialResult(_serialization.Model):
    """One credential result item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytes
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "bytearray"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class FleetCredentialResults(_serialization.Model):
    """The Credential results response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Array of base64-encoded Kubernetes configuration files.
    :vartype kubeconfigs:
     list[~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetCredentialResult]
    """

    _validation = {
        "kubeconfigs": {"readonly": True},
    }

    _attribute_map = {
        "kubeconfigs": {"key": "kubeconfigs", "type": "[FleetCredentialResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kubeconfigs = None


class FleetListResult(_serialization.Model):
    """The response of a Fleet list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Fleet items on this page. Required.
    :vartype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.Fleet]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Fleet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Fleet"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Fleet items on this page. Required.
        :paramtype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.Fleet]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.v2023_10_15.models.SystemData
    """


class FleetMember(ProxyResource):
    """A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.v2023_10_15.models.SystemData
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    :ivar cluster_resource_id: The ARM resource id of the cluster that joins the Fleet. Must be a
     valid Azure resource id. e.g.:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.  # pylint: disable=line-too-long
    :vartype cluster_resource_id: str
    :ivar group: The group this member belongs to for multi-cluster update management.
    :vartype group: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Joining", "Leaving", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetMemberProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "e_tag": {"readonly": True},
        "group": {"max_length": 50, "min_length": 1, "pattern": r"^[a-z0-9]([-a-z0-9]*[a-z0-9])?$"},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "e_tag": {"key": "eTag", "type": "str"},
        "cluster_resource_id": {"key": "properties.clusterResourceId", "type": "str"},
        "group": {"key": "properties.group", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, cluster_resource_id: Optional[str] = None, group: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword cluster_resource_id: The ARM resource id of the cluster that joins the Fleet. Must be
         a valid Azure resource id. e.g.:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.  # pylint: disable=line-too-long
        :paramtype cluster_resource_id: str
        :keyword group: The group this member belongs to for multi-cluster update management.
        :paramtype group: str
        """
        super().__init__(**kwargs)
        self.e_tag = None
        self.cluster_resource_id = cluster_resource_id
        self.group = group
        self.provisioning_state = None


class FleetMemberListResult(_serialization.Model):
    """The response of a FleetMember list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The FleetMember items on this page. Required.
    :vartype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetMember]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FleetMember]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.FleetMember"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The FleetMember items on this page. Required.
        :paramtype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetMember]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FleetMemberUpdate(_serialization.Model):
    """The type used for update operations of the FleetMember.

    :ivar group: The group this member belongs to for multi-cluster update management.
    :vartype group: str
    """

    _validation = {
        "group": {"max_length": 50, "min_length": 1, "pattern": r"^[a-z0-9]([-a-z0-9]*[a-z0-9])?$"},
    }

    _attribute_map = {
        "group": {"key": "properties.group", "type": "str"},
    }

    def __init__(self, *, group: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword group: The group this member belongs to for multi-cluster update management.
        :paramtype group: str
        """
        super().__init__(**kwargs)
        self.group = group


class FleetPatch(_serialization.Model):
    """Properties of a Fleet that can be patched.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed identity.
    :vartype identity: ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedServiceIdentity
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed identity.
        :paramtype identity:
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedServiceIdentity
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class FleetUpdateStrategy(ProxyResource):
    """Defines a multi-stage process to perform update operations across members of a Fleet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.v2023_10_15.models.SystemData
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    :ivar provisioning_state: The provisioning state of the UpdateStrategy resource. Known values
     are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetUpdateStrategyProvisioningState
    :ivar strategy: Defines the update sequence of the clusters.
    :vartype strategy: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRunStrategy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "e_tag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "e_tag": {"key": "eTag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "strategy": {"key": "properties.strategy", "type": "UpdateRunStrategy"},
    }

    def __init__(self, *, strategy: Optional["_models.UpdateRunStrategy"] = None, **kwargs: Any) -> None:
        """
        :keyword strategy: Defines the update sequence of the clusters.
        :paramtype strategy: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRunStrategy
        """
        super().__init__(**kwargs)
        self.e_tag = None
        self.provisioning_state = None
        self.strategy = strategy


class FleetUpdateStrategyListResult(_serialization.Model):
    """The response of a FleetUpdateStrategy list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The FleetUpdateStrategy items on this page. Required.
    :vartype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetUpdateStrategy]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FleetUpdateStrategy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.FleetUpdateStrategy"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The FleetUpdateStrategy items on this page. Required.
        :paramtype value:
         list[~azure.mgmt.containerservicefleet.v2023_10_15.models.FleetUpdateStrategy]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedClusterUpdate(_serialization.Model):
    """The update to be applied to the ManagedClusters.

    All required parameters must be populated in order to send to server.

    :ivar upgrade: The upgrade to apply to the ManagedClusters. Required.
    :vartype upgrade:
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedClusterUpgradeSpec
    :ivar node_image_selection: The node image upgrade to be applied to the target nodes in update
     run.
    :vartype node_image_selection:
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.NodeImageSelection
    """

    _validation = {
        "upgrade": {"required": True},
    }

    _attribute_map = {
        "upgrade": {"key": "upgrade", "type": "ManagedClusterUpgradeSpec"},
        "node_image_selection": {"key": "nodeImageSelection", "type": "NodeImageSelection"},
    }

    def __init__(
        self,
        *,
        upgrade: "_models.ManagedClusterUpgradeSpec",
        node_image_selection: Optional["_models.NodeImageSelection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword upgrade: The upgrade to apply to the ManagedClusters. Required.
        :paramtype upgrade:
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedClusterUpgradeSpec
        :keyword node_image_selection: The node image upgrade to be applied to the target nodes in
         update run.
        :paramtype node_image_selection:
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.NodeImageSelection
        """
        super().__init__(**kwargs)
        self.upgrade = upgrade
        self.node_image_selection = node_image_selection


class ManagedClusterUpgradeSpec(_serialization.Model):
    """The upgrade to apply to a ManagedCluster.

    All required parameters must be populated in order to send to server.

    :ivar type: ManagedClusterUpgradeType is the type of upgrade to be applied. Required. Known
     values are: "Full" and "NodeImageOnly".
    :vartype type: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedClusterUpgradeType
    :ivar kubernetes_version: The Kubernetes version to upgrade the member clusters to.
    :vartype kubernetes_version: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedClusterUpgradeType"],
        kubernetes_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: ManagedClusterUpgradeType is the type of upgrade to be applied. Required. Known
         values are: "Full" and "NodeImageOnly".
        :paramtype type: str or
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedClusterUpgradeType
        :keyword kubernetes_version: The Kubernetes version to upgrade the member clusters to.
        :paramtype kubernetes_version: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.kubernetes_version = kubernetes_version


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned, UserAssigned".
        :paramtype type: str or
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MemberUpdateStatus(_serialization.Model):
    """The status of a member update operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the MemberUpdate operation.
    :vartype status: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStatus
    :ivar name: The name of the FleetMember.
    :vartype name: str
    :ivar cluster_resource_id: The Azure resource id of the target Kubernetes cluster.
    :vartype cluster_resource_id: str
    :ivar operation_id: The operation resource id of the latest attempt to perform the operation.
    :vartype operation_id: str
    :ivar message: The status message after processing the member update operation.
    :vartype message: str
    """

    _validation = {
        "status": {"readonly": True},
        "name": {"readonly": True},
        "cluster_resource_id": {"readonly": True},
        "operation_id": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "UpdateStatus"},
        "name": {"key": "name", "type": "str"},
        "cluster_resource_id": {"key": "clusterResourceId", "type": "str"},
        "operation_id": {"key": "operationId", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.name = None
        self.cluster_resource_id = None
        self.operation_id = None
        self.message = None


class NodeImageSelection(_serialization.Model):
    """The node image upgrade to be applied to the target nodes in update run.

    All required parameters must be populated in order to send to server.

    :ivar type: The node image upgrade type. Required. Known values are: "Latest" and "Consistent".
    :vartype type: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.NodeImageSelectionType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.NodeImageSelectionType"], **kwargs: Any) -> None:
        """
        :keyword type: The node image upgrade type. Required. Known values are: "Latest" and
         "Consistent".
        :paramtype type: str or
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.NodeImageSelectionType
        """
        super().__init__(**kwargs)
        self.type = type


class NodeImageSelectionStatus(_serialization.Model):
    """The node image upgrade specs for the update run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar selected_node_image_versions: The image versions to upgrade the nodes to.
    :vartype selected_node_image_versions:
     list[~azure.mgmt.containerservicefleet.v2023_10_15.models.NodeImageVersion]
    """

    _validation = {
        "selected_node_image_versions": {"readonly": True},
    }

    _attribute_map = {
        "selected_node_image_versions": {"key": "selectedNodeImageVersions", "type": "[NodeImageVersion]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.selected_node_image_versions = None


class NodeImageVersion(_serialization.Model):
    """The node upgrade image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The image version to upgrade the nodes to (e.g.,
     'AKSUbuntu-1804gen2containerd-2022.12.13').
    :vartype version: str
    """

    _validation = {
        "version": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version = None


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.containerservicefleet.v2023_10_15.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.containerservicefleet.v2023_10_15.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.containerservicefleet.v2023_10_15.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.containerservicefleet.v2023_10_15.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UpdateGroup(_serialization.Model):
    """A group to be updated.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the group.
     It must match a group name of an existing fleet member. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True, "max_length": 50, "min_length": 1, "pattern": r"^[a-z0-9]([-a-z0-9]*[a-z0-9])?$"},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the group.
         It must match a group name of an existing fleet member. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class UpdateGroupStatus(_serialization.Model):
    """The status of a UpdateGroup.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the UpdateGroup.
    :vartype status: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStatus
    :ivar name: The name of the UpdateGroup.
    :vartype name: str
    :ivar members: The list of member this UpdateGroup updates.
    :vartype members: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.MemberUpdateStatus]
    """

    _validation = {
        "status": {"readonly": True},
        "name": {"readonly": True},
        "members": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "UpdateStatus"},
        "name": {"key": "name", "type": "str"},
        "members": {"key": "members", "type": "[MemberUpdateStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.name = None
        self.members = None


class UpdateRun(ProxyResource):
    """A multi-stage process to perform update operations across members of a Fleet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.v2023_10_15.models.SystemData
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    :ivar provisioning_state: The provisioning state of the UpdateRun resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRunProvisioningState
    :ivar update_strategy_id: The resource id of the FleetUpdateStrategy resource to reference.

     When creating a new run, there are three ways to define a strategy for the run:


     #. Define a new strategy in place: Set the "strategy" field.
     #. Use an existing strategy: Set the "updateStrategyId" field. (since 2023-08-15-preview)
     #. Use the default strategy to update all the members one by one: Leave both
     "updateStrategyId" and "strategy" unset. (since 2023-08-15-preview)

     Setting both "updateStrategyId" and "strategy" is invalid.

     UpdateRuns created by "updateStrategyId" snapshot the referenced UpdateStrategy at the time of
     creation and store it in the "strategy" field.
     Subsequent changes to the referenced FleetUpdateStrategy resource do not propagate.
     UpdateRunStrategy changes can be made directly on the "strategy" field before launching the
     UpdateRun.
    :vartype update_strategy_id: str
    :ivar strategy: The strategy defines the order in which the clusters will be updated.
     If not set, all members will be updated sequentially. The UpdateRun status will show a single
     UpdateStage and a single UpdateGroup targeting all members.
     The strategy of the UpdateRun can be modified until the run is started.
    :vartype strategy: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRunStrategy
    :ivar managed_cluster_update: The update to be applied to all clusters in the UpdateRun. The
     managedClusterUpdate can be modified until the run is started.
    :vartype managed_cluster_update:
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedClusterUpdate
    :ivar status: The status of the UpdateRun.
    :vartype status: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRunStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "e_tag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "e_tag": {"key": "eTag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "update_strategy_id": {"key": "properties.updateStrategyId", "type": "str"},
        "strategy": {"key": "properties.strategy", "type": "UpdateRunStrategy"},
        "managed_cluster_update": {"key": "properties.managedClusterUpdate", "type": "ManagedClusterUpdate"},
        "status": {"key": "properties.status", "type": "UpdateRunStatus"},
    }

    def __init__(
        self,
        *,
        update_strategy_id: Optional[str] = None,
        strategy: Optional["_models.UpdateRunStrategy"] = None,
        managed_cluster_update: Optional["_models.ManagedClusterUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword update_strategy_id: The resource id of the FleetUpdateStrategy resource to reference.

         When creating a new run, there are three ways to define a strategy for the run:


         #. Define a new strategy in place: Set the "strategy" field.
         #. Use an existing strategy: Set the "updateStrategyId" field. (since 2023-08-15-preview)
         #. Use the default strategy to update all the members one by one: Leave both
         "updateStrategyId" and "strategy" unset. (since 2023-08-15-preview)

         Setting both "updateStrategyId" and "strategy" is invalid.

         UpdateRuns created by "updateStrategyId" snapshot the referenced UpdateStrategy at the time of
         creation and store it in the "strategy" field.
         Subsequent changes to the referenced FleetUpdateStrategy resource do not propagate.
         UpdateRunStrategy changes can be made directly on the "strategy" field before launching the
         UpdateRun.
        :paramtype update_strategy_id: str
        :keyword strategy: The strategy defines the order in which the clusters will be updated.
         If not set, all members will be updated sequentially. The UpdateRun status will show a single
         UpdateStage and a single UpdateGroup targeting all members.
         The strategy of the UpdateRun can be modified until the run is started.
        :paramtype strategy: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRunStrategy
        :keyword managed_cluster_update: The update to be applied to all clusters in the UpdateRun. The
         managedClusterUpdate can be modified until the run is started.
        :paramtype managed_cluster_update:
         ~azure.mgmt.containerservicefleet.v2023_10_15.models.ManagedClusterUpdate
        """
        super().__init__(**kwargs)
        self.e_tag = None
        self.provisioning_state = None
        self.update_strategy_id = update_strategy_id
        self.strategy = strategy
        self.managed_cluster_update = managed_cluster_update
        self.status = None


class UpdateRunListResult(_serialization.Model):
    """The response of a UpdateRun list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The UpdateRun items on this page. Required.
    :vartype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRun]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpdateRun]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.UpdateRun"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The UpdateRun items on this page. Required.
        :paramtype value: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateRun]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateRunStatus(_serialization.Model):
    """The status of a UpdateRun.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the UpdateRun.
    :vartype status: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStatus
    :ivar stages: The stages composing an update run. Stages are run sequentially withing an
     UpdateRun.
    :vartype stages: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStageStatus]
    :ivar node_image_selection: The node image upgrade specs for the update run. It is only set in
     update run when ``NodeImageSelection.type`` is ``Consistent``.
    :vartype node_image_selection:
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.NodeImageSelectionStatus
    """

    _validation = {
        "status": {"readonly": True},
        "stages": {"readonly": True},
        "node_image_selection": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "UpdateStatus"},
        "stages": {"key": "stages", "type": "[UpdateStageStatus]"},
        "node_image_selection": {"key": "nodeImageSelection", "type": "NodeImageSelectionStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.stages = None
        self.node_image_selection = None


class UpdateRunStrategy(_serialization.Model):
    """Defines the update sequence of the clusters via stages and groups.

    Stages within a run are executed sequentially one after another.
    Groups within a stage are executed in parallel.
    Member clusters within a group are updated sequentially one after another.

    A valid strategy contains no duplicate groups within or across stages.

    All required parameters must be populated in order to send to server.

    :ivar stages: The list of stages that compose this update run. Min size: 1. Required.
    :vartype stages: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStage]
    """

    _validation = {
        "stages": {"required": True},
    }

    _attribute_map = {
        "stages": {"key": "stages", "type": "[UpdateStage]"},
    }

    def __init__(self, *, stages: List["_models.UpdateStage"], **kwargs: Any) -> None:
        """
        :keyword stages: The list of stages that compose this update run. Min size: 1. Required.
        :paramtype stages: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStage]
        """
        super().__init__(**kwargs)
        self.stages = stages


class UpdateStage(_serialization.Model):
    """Defines a stage which contains the groups to update and the steps to take (e.g., wait for a
    time period) before starting the next stage.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the stage. Must be unique within the UpdateRun. Required.
    :vartype name: str
    :ivar groups: Defines the groups to be executed in parallel in this stage. Duplicate groups are
     not allowed. Min size: 1.
    :vartype groups: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateGroup]
    :ivar after_stage_wait_in_seconds: The time in seconds to wait at the end of this stage before
     starting the next one. Defaults to 0 seconds if unspecified.
    :vartype after_stage_wait_in_seconds: int
    """

    _validation = {
        "name": {"required": True, "max_length": 50, "min_length": 1, "pattern": r"^[a-z0-9]([-a-z0-9]*[a-z0-9])?$"},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "groups": {"key": "groups", "type": "[UpdateGroup]"},
        "after_stage_wait_in_seconds": {"key": "afterStageWaitInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        groups: Optional[List["_models.UpdateGroup"]] = None,
        after_stage_wait_in_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the stage. Must be unique within the UpdateRun. Required.
        :paramtype name: str
        :keyword groups: Defines the groups to be executed in parallel in this stage. Duplicate groups
         are not allowed. Min size: 1.
        :paramtype groups: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateGroup]
        :keyword after_stage_wait_in_seconds: The time in seconds to wait at the end of this stage
         before starting the next one. Defaults to 0 seconds if unspecified.
        :paramtype after_stage_wait_in_seconds: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.groups = groups
        self.after_stage_wait_in_seconds = after_stage_wait_in_seconds


class UpdateStageStatus(_serialization.Model):
    """The status of a UpdateStage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the UpdateStage.
    :vartype status: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStatus
    :ivar name: The name of the UpdateStage.
    :vartype name: str
    :ivar groups: The list of groups to be updated as part of this UpdateStage.
    :vartype groups: list[~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateGroupStatus]
    :ivar after_stage_wait_status: The status of the wait period configured on the UpdateStage.
    :vartype after_stage_wait_status:
     ~azure.mgmt.containerservicefleet.v2023_10_15.models.WaitStatus
    """

    _validation = {
        "status": {"readonly": True},
        "name": {"readonly": True},
        "groups": {"readonly": True},
        "after_stage_wait_status": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "UpdateStatus"},
        "name": {"key": "name", "type": "str"},
        "groups": {"key": "groups", "type": "[UpdateGroupStatus]"},
        "after_stage_wait_status": {"key": "afterStageWaitStatus", "type": "WaitStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.name = None
        self.groups = None
        self.after_stage_wait_status = None


class UpdateStatus(_serialization.Model):
    """The status for an operation or group of operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The time the operation or group was started.
    :vartype start_time: ~datetime.datetime
    :ivar completed_time: The time the operation or group was completed.
    :vartype completed_time: ~datetime.datetime
    :ivar state: The State of the operation or group. Known values are: "NotStarted", "Running",
     "Stopping", "Stopped", "Skipped", "Failed", and "Completed".
    :vartype state: str or ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateState
    :ivar error: The error details when a failure is encountered.
    :vartype error: ~azure.mgmt.containerservicefleet.v2023_10_15.models.ErrorDetail
    """

    _validation = {
        "start_time": {"readonly": True},
        "completed_time": {"readonly": True},
        "state": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "completed_time": {"key": "completedTime", "type": "iso-8601"},
        "state": {"key": "state", "type": "str"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.start_time = None
        self.completed_time = None
        self.state = None
        self.error = None


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class WaitStatus(_serialization.Model):
    """The status of the wait duration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the wait duration.
    :vartype status: ~azure.mgmt.containerservicefleet.v2023_10_15.models.UpdateStatus
    :ivar wait_duration_in_seconds: The wait duration configured in seconds.
    :vartype wait_duration_in_seconds: int
    """

    _validation = {
        "status": {"readonly": True},
        "wait_duration_in_seconds": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "UpdateStatus"},
        "wait_duration_in_seconds": {"key": "waitDurationInSeconds", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.wait_duration_in_seconds = None
