# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice.aio import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceAgentPoolsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.agent_pools.list(
            resource_group_name=resource_group.name,
            managed_cluster_name="str",
            api_version="2019-02-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.agent_pools.get(
            resource_group_name=resource_group.name,
            managed_cluster_name="str",
            agent_pool_name="str",
            api_version="2019-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.agent_pools.begin_create_or_update(
                resource_group_name=resource_group.name,
                managed_cluster_name="str",
                agent_pool_name="str",
                parameters={
                    "availabilityZones": ["str"],
                    "count": 1,
                    "enableAutoScaling": bool,
                    "id": "str",
                    "maxCount": 0,
                    "maxPods": 0,
                    "minCount": 0,
                    "name": "str",
                    "orchestratorVersion": "str",
                    "osDiskSizeGB": 0,
                    "osType": "Linux",
                    "provisioningState": "str",
                    "type": "str",
                    "vmSize": "str",
                    "vnetSubnetID": "str",
                },
                api_version="2019-02-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.agent_pools.begin_delete(
                resource_group_name=resource_group.name,
                managed_cluster_name="str",
                agent_pool_name="str",
                api_version="2019-02-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
