# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementVirtualMachinesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_capture(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_capture(
                resource_group_name=resource_group.name,
                vm_name="str",
                parameters={"destinationContainerName": "str", "overwriteVhds": bool, "vhdPrefix": "str"},
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_create_or_update(
                resource_group_name=resource_group.name,
                vm_name="str",
                parameters={
                    "location": "str",
                    "availabilitySet": {"id": "str"},
                    "diagnosticsProfile": {"bootDiagnostics": {"enabled": bool, "storageUri": "str"}},
                    "hardwareProfile": {"vmSize": "str"},
                    "id": "str",
                    "instanceView": {
                        "bootDiagnostics": {"consoleScreenshotBlobUri": "str", "serialConsoleLogBlobUri": "str"},
                        "disks": [
                            {
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                            }
                        ],
                        "extensions": [
                            {
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "substatuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "type": "str",
                                "typeHandlerVersion": "str",
                            }
                        ],
                        "platformFaultDomain": 0,
                        "platformUpdateDomain": 0,
                        "rdpThumbPrint": "str",
                        "statuses": [
                            {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            }
                        ],
                        "vmAgent": {
                            "extensionHandlers": [
                                {
                                    "status": {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    },
                                    "type": "str",
                                    "typeHandlerVersion": "str",
                                }
                            ],
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "vmAgentVersion": "str",
                        },
                    },
                    "licenseType": "str",
                    "name": "str",
                    "networkProfile": {"networkInterfaces": [{"id": "str", "primary": bool}]},
                    "osProfile": {
                        "adminPassword": "str",
                        "adminUsername": "str",
                        "computerName": "str",
                        "customData": "str",
                        "linuxConfiguration": {
                            "disablePasswordAuthentication": bool,
                            "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                        },
                        "secrets": [
                            {
                                "sourceVault": {"id": "str"},
                                "vaultCertificates": [{"certificateStore": "str", "certificateUrl": "str"}],
                            }
                        ],
                        "windowsConfiguration": {
                            "additionalUnattendContent": [
                                {
                                    "componentName": "Microsoft-Windows-Shell-Setup",
                                    "content": "str",
                                    "passName": "OobeSystem",
                                    "settingName": "str",
                                }
                            ],
                            "enableAutomaticUpdates": bool,
                            "provisionVMAgent": bool,
                            "timeZone": "str",
                            "winRM": {"listeners": [{"certificateUrl": "str", "protocol": "str"}]},
                        },
                    },
                    "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str"},
                    "provisioningState": "str",
                    "resources": [
                        {
                            "location": "str",
                            "autoUpgradeMinorVersion": bool,
                            "forceUpdateTag": "str",
                            "id": "str",
                            "instanceView": {
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "substatuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "type": "str",
                                "typeHandlerVersion": "str",
                            },
                            "name": "str",
                            "protectedSettings": {},
                            "provisioningState": "str",
                            "publisher": "str",
                            "settings": {},
                            "tags": {"str": "str"},
                            "type": "str",
                            "typeHandlerVersion": "str",
                        }
                    ],
                    "storageProfile": {
                        "dataDisks": [
                            {
                                "createOption": "str",
                                "lun": 0,
                                "name": "str",
                                "vhd": {"uri": "str"},
                                "caching": "str",
                                "diskSizeGB": 0,
                                "image": {"uri": "str"},
                            }
                        ],
                        "imageReference": {"offer": "str", "publisher": "str", "sku": "str", "version": "str"},
                        "osDisk": {
                            "createOption": "str",
                            "name": "str",
                            "vhd": {"uri": "str"},
                            "caching": "str",
                            "diskSizeGB": 0,
                            "encryptionSettings": {
                                "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                "enabled": bool,
                                "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                            },
                            "image": {"uri": "str"},
                            "osType": "str",
                        },
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_delete(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.virtual_machines.get(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2015-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_deallocate(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_deallocate(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_generalize(self, resource_group):
        response = await self.client.virtual_machines.generalize(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2015-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.virtual_machines.list(
            resource_group_name=resource_group.name,
            api_version="2015-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_all(self, resource_group):
        response = self.client.virtual_machines.list_all(
            api_version="2015-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_available_sizes(self, resource_group):
        response = self.client.virtual_machines.list_available_sizes(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2015-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_power_off(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_power_off(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_restart(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_restart(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_start(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_start(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_redeploy(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_redeploy(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
