# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementCloudServicesUpdateDomainOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_walk_update_domain(self, resource_group):
        response = await (
            await self.client.cloud_services_update_domain.begin_walk_update_domain(
                resource_group_name=resource_group.name,
                cloud_service_name="str",
                update_domain=0,
                api_version="2020-10-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_update_domain(self, resource_group):
        response = await self.client.cloud_services_update_domain.get_update_domain(
            resource_group_name=resource_group.name,
            cloud_service_name="str",
            update_domain=0,
            api_version="2020-10-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_update_domains(self, resource_group):
        response = self.client.cloud_services_update_domain.list_update_domains(
            resource_group_name=resource_group.name,
            cloud_service_name="str",
            api_version="2020-10-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
