/*
 * Copyright 2022-2024 Soren Stoutner <soren@stoutner.com>.
 *
 * This file is part of Privacy Browser PC <https://www.stoutner.com/privacy-browser-pc/>.
 *
 * Privacy Browser PC is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Privacy Browser PC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Privacy Browser PC.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef URL_REQUEST_INTERCEPTOR_H
#define URL_REQUEST_INTERCEPTOR_H

// Application headers.
#include "structs/RequestStruct.h"
#include "widgets/PrivacyWebEngineView.h"

// Qt framework headers.
#include <QtWebEngineCore>

class UrlRequestInterceptor : public QWebEngineUrlRequestInterceptor
{
    // Include the Q_OBJECT macro.
    Q_OBJECT

public:
    // The default constructor.
    UrlRequestInterceptor(PrivacyWebEngineView *privacyWebEngineViewPointer);

    // The public functions.
    void interceptRequest(QWebEngineUrlRequestInfo &urlRequestInfo) override;

signals:
    // The signals.
    void applyDomainSettings(const QString &hostname) const;
    void displayHttpPingDialog(const QString &httpPingUrl) const;
    void newMainFrameResource() const;
    void requestProcessed(RequestStruct *requestStruct) const;

private:
    // The private variables.
    PrivacyWebEngineView *privacyWebEngineViewPointer;
};
#endif
