/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    storage: Storage,
    align: [Align; 0],
}

impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }

    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        byte & mask == mask
    }

    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }

    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        let mut val = 0;

        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                val |= 1 << i;
            }
        }

        val
    }

    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            self.set_bit(i + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ptr(&self) -> *const T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut_ptr(&mut self) -> *mut T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
impl<T> ::std::clone::Clone for __IncompleteArrayField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __IncompleteArrayField<T> {}
pub const __BITS_PER_LONG: u32 = 64;
pub const __FD_SETSIZE: u32 = 1024;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201505;
pub const __STDC_NO_THREADS__: u32 = 1;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 23;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __ENUM_IDTYPE_T: u32 = 1;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const _ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const _SIGSET_H_types: u32 = 1;
pub const __timespec_defined: u32 = 1;
pub const _STRUCT_TIMEVAL: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _SYS_SYSMACROS_H: u32 = 1;
pub const _BITS_PTHREADTYPES_H: u32 = 1;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const __have_pthread_attr_t: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __PTHREAD_RWLOCK_INT_FLAGS_SHARED: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const SNDRV_PCM_INFO_MMAP: u32 = 1;
pub const SNDRV_PCM_INFO_MMAP_VALID: u32 = 2;
pub const SNDRV_PCM_INFO_DOUBLE: u32 = 4;
pub const SNDRV_PCM_INFO_BATCH: u32 = 16;
pub const SNDRV_PCM_INFO_SYNC_APPLPTR: u32 = 32;
pub const SNDRV_PCM_INFO_INTERLEAVED: u32 = 256;
pub const SNDRV_PCM_INFO_NONINTERLEAVED: u32 = 512;
pub const SNDRV_PCM_INFO_COMPLEX: u32 = 1024;
pub const SNDRV_PCM_INFO_BLOCK_TRANSFER: u32 = 65536;
pub const SNDRV_PCM_INFO_OVERRANGE: u32 = 131072;
pub const SNDRV_PCM_INFO_RESUME: u32 = 262144;
pub const SNDRV_PCM_INFO_PAUSE: u32 = 524288;
pub const SNDRV_PCM_INFO_HALF_DUPLEX: u32 = 1048576;
pub const SNDRV_PCM_INFO_JOINT_DUPLEX: u32 = 2097152;
pub const SNDRV_PCM_INFO_SYNC_START: u32 = 4194304;
pub const SNDRV_PCM_INFO_NO_PERIOD_WAKEUP: u32 = 8388608;
pub const SNDRV_PCM_INFO_HAS_WALL_CLOCK: u32 = 16777216;
pub const SNDRV_PCM_INFO_HAS_LINK_ATIME: u32 = 16777216;
pub const SNDRV_PCM_INFO_HAS_LINK_ABSOLUTE_ATIME: u32 = 33554432;
pub const SNDRV_PCM_INFO_HAS_LINK_ESTIMATED_ATIME: u32 = 67108864;
pub const SNDRV_PCM_INFO_HAS_LINK_SYNCHRONIZED_ATIME: u32 = 134217728;
pub const SNDRV_PCM_INFO_DRAIN_TRIGGER: u32 = 1073741824;
pub const SNDRV_PCM_INFO_FIFO_IN_FRAMES: u32 = 2147483648;
pub const SNDRV_PCM_HW_PARAM_ACCESS: u32 = 0;
pub const SNDRV_PCM_HW_PARAM_FORMAT: u32 = 1;
pub const SNDRV_PCM_HW_PARAM_SUBFORMAT: u32 = 2;
pub const SNDRV_PCM_HW_PARAM_FIRST_MASK: u32 = 0;
pub const SNDRV_PCM_HW_PARAM_LAST_MASK: u32 = 2;
pub const SNDRV_PCM_HW_PARAM_SAMPLE_BITS: u32 = 8;
pub const SNDRV_PCM_HW_PARAM_FRAME_BITS: u32 = 9;
pub const SNDRV_PCM_HW_PARAM_CHANNELS: u32 = 10;
pub const SNDRV_PCM_HW_PARAM_RATE: u32 = 11;
pub const SNDRV_PCM_HW_PARAM_PERIOD_TIME: u32 = 12;
pub const SNDRV_PCM_HW_PARAM_PERIOD_SIZE: u32 = 13;
pub const SNDRV_PCM_HW_PARAM_PERIOD_BYTES: u32 = 14;
pub const SNDRV_PCM_HW_PARAM_PERIODS: u32 = 15;
pub const SNDRV_PCM_HW_PARAM_BUFFER_TIME: u32 = 16;
pub const SNDRV_PCM_HW_PARAM_BUFFER_SIZE: u32 = 17;
pub const SNDRV_PCM_HW_PARAM_BUFFER_BYTES: u32 = 18;
pub const SNDRV_PCM_HW_PARAM_TICK_TIME: u32 = 19;
pub const SNDRV_PCM_HW_PARAM_FIRST_INTERVAL: u32 = 8;
pub const SNDRV_PCM_HW_PARAM_LAST_INTERVAL: u32 = 19;
pub const SNDRV_PCM_HW_PARAMS_NORESAMPLE: u32 = 1;
pub const SNDRV_PCM_HW_PARAMS_EXPORT_BUFFER: u32 = 2;
pub const SNDRV_PCM_HW_PARAMS_NO_PERIOD_WAKEUP: u32 = 4;
pub const SNDRV_MASK_MAX: u32 = 256;
pub const SNDRV_PCM_SYNC_PTR_HWSYNC: u32 = 1;
pub const SNDRV_PCM_SYNC_PTR_APPL: u32 = 2;
pub const SNDRV_PCM_SYNC_PTR_AVAIL_MIN: u32 = 4;
pub const SNDRV_CHMAP_POSITION_MASK: u32 = 65535;
pub const SNDRV_CHMAP_PHASE_INVERSE: u32 = 65536;
pub const SNDRV_CHMAP_DRIVER_SPEC: u32 = 131072;
pub const SNDRV_RAWMIDI_INFO_OUTPUT: u32 = 1;
pub const SNDRV_RAWMIDI_INFO_INPUT: u32 = 2;
pub const SNDRV_RAWMIDI_INFO_DUPLEX: u32 = 4;
pub const SNDRV_TIMER_GLOBAL_SYSTEM: u32 = 0;
pub const SNDRV_TIMER_GLOBAL_RTC: u32 = 1;
pub const SNDRV_TIMER_GLOBAL_HPET: u32 = 2;
pub const SNDRV_TIMER_GLOBAL_HRTIMER: u32 = 3;
pub const SNDRV_TIMER_FLG_SLAVE: u32 = 1;
pub const SNDRV_TIMER_PSFLG_AUTO: u32 = 1;
pub const SNDRV_TIMER_PSFLG_EXCLUSIVE: u32 = 2;
pub const SNDRV_TIMER_PSFLG_EARLY_EVENT: u32 = 4;
pub const SNDRV_CTL_ELEM_ACCESS_READ: u32 = 1;
pub const SNDRV_CTL_ELEM_ACCESS_WRITE: u32 = 2;
pub const SNDRV_CTL_ELEM_ACCESS_READWRITE: u32 = 3;
pub const SNDRV_CTL_ELEM_ACCESS_VOLATILE: u32 = 4;
pub const SNDRV_CTL_ELEM_ACCESS_TIMESTAMP: u32 = 8;
pub const SNDRV_CTL_ELEM_ACCESS_TLV_READ: u32 = 16;
pub const SNDRV_CTL_ELEM_ACCESS_TLV_WRITE: u32 = 32;
pub const SNDRV_CTL_ELEM_ACCESS_TLV_READWRITE: u32 = 48;
pub const SNDRV_CTL_ELEM_ACCESS_TLV_COMMAND: u32 = 64;
pub const SNDRV_CTL_ELEM_ACCESS_INACTIVE: u32 = 256;
pub const SNDRV_CTL_ELEM_ACCESS_LOCK: u32 = 512;
pub const SNDRV_CTL_ELEM_ACCESS_OWNER: u32 = 1024;
pub const SNDRV_CTL_ELEM_ACCESS_TLV_CALLBACK: u32 = 268435456;
pub const SNDRV_CTL_ELEM_ACCESS_USER: u32 = 536870912;
pub const SNDRV_CTL_POWER_D0: u32 = 0;
pub const SNDRV_CTL_POWER_D1: u32 = 256;
pub const SNDRV_CTL_POWER_D2: u32 = 512;
pub const SNDRV_CTL_POWER_D3: u32 = 768;
pub const SNDRV_CTL_POWER_D3hot: u32 = 768;
pub const SNDRV_CTL_POWER_D3cold: u32 = 769;
pub const SNDRV_CTL_ELEM_ID_NAME_MAXLEN: u32 = 44;
pub const SNDRV_CTL_EVENT_MASK_VALUE: u32 = 1;
pub const SNDRV_CTL_EVENT_MASK_INFO: u32 = 2;
pub const SNDRV_CTL_EVENT_MASK_ADD: u32 = 4;
pub const SNDRV_CTL_EVENT_MASK_TLV: u32 = 8;
pub const SNDRV_CTL_EVENT_MASK_REMOVE: i32 = -1;
pub const SNDRV_CTL_NAME_NONE: &'static [u8; 1usize] = b"\0";
pub const SNDRV_CTL_NAME_PLAYBACK: &'static [u8; 10usize] = b"Playback \0";
pub const SNDRV_CTL_NAME_CAPTURE: &'static [u8; 9usize] = b"Capture \0";
pub const SNDRV_CTL_NAME_IEC958_NONE: &'static [u8; 1usize] = b"\0";
pub const SNDRV_CTL_NAME_IEC958_SWITCH: &'static [u8; 7usize] = b"Switch\0";
pub const SNDRV_CTL_NAME_IEC958_VOLUME: &'static [u8; 7usize] = b"Volume\0";
pub const SNDRV_CTL_NAME_IEC958_DEFAULT: &'static [u8; 8usize] = b"Default\0";
pub const SNDRV_CTL_NAME_IEC958_MASK: &'static [u8; 5usize] = b"Mask\0";
pub const SNDRV_CTL_NAME_IEC958_CON_MASK: &'static [u8; 9usize] = b"Con Mask\0";
pub const SNDRV_CTL_NAME_IEC958_PRO_MASK: &'static [u8; 9usize] = b"Pro Mask\0";
pub const SNDRV_CTL_NAME_IEC958_PCM_STREAM: &'static [u8; 11usize] = b"PCM Stream\0";
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__kernel_fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__kernel_fsid_t>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fsid_t),
            "::",
            stringify!(val)
        )
    );
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type wchar_t = ::std::os::raw::c_int;
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = u32;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __qaddr_t = *mut __quad_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub __wait_terminated: wait__bindgen_ty_1,
    pub __wait_stopped: wait__bindgen_ty_2,
    _bindgen_union_align: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub __bindgen_align: [u32; 0usize],
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn __w_termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set___w_termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___w_coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_termsig: ::std::os::raw::c_uint,
        __w_coredump: ::std::os::raw::c_uint,
        __w_retcode: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let __w_termsig: u32 = unsafe { ::std::mem::transmute(__w_termsig) };
            __w_termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __w_coredump: u32 = unsafe { ::std::mem::transmute(__w_coredump) };
            __w_coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_retcode: u32 = unsafe { ::std::mem::transmute(__w_retcode) };
            __w_retcode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub __bindgen_align: [u32; 0usize],
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn __w_stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_stopval: ::std::os::raw::c_uint,
        __w_stopsig: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let __w_stopval: u32 = unsafe { ::std::mem::transmute(__w_stopval) };
            __w_stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_stopsig: u32 = unsafe { ::std::mem::transmute(__w_stopsig) };
            __w_stopsig as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_terminated as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_terminated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_stopped as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_stopped)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __WAIT_STATUS {
    pub __uptr: *mut wait,
    pub __iptr: *mut ::std::os::raw::c_int,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout___WAIT_STATUS() {
    assert_eq!(
        ::std::mem::size_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Size of: ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        ::std::mem::align_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Alignment of ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__uptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__uptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__iptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__iptr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> usize;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type time_t = __time_t;
pub type clockid_t = __clockid_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulong;
pub type register_t = ::std::os::raw::c_long;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gnu_dev_major(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_minor(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_makedev(
        __major: ::std::os::raw::c_uint,
        __minor: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: pthread_mutex_t___pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_mutex_t___pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t___pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t___pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t___pthread_mutex_s>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pthread_mutex_t___pthread_mutex_s)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__lock as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__owner as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__nusers as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__kind as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__spins as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__elision as *const _
                as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__list as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: pthread_cond_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_cond_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __futex: ::std::os::raw::c_uint,
    pub __total_seq: ::std::os::raw::c_ulonglong,
    pub __wakeup_seq: ::std::os::raw::c_ulonglong,
    pub __woken_seq: ::std::os::raw::c_ulonglong,
    pub __mutex: *mut ::std::os::raw::c_void,
    pub __nwaiters: ::std::os::raw::c_uint,
    pub __broadcast_seq: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_cond_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__futex as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__total_seq as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__total_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__wakeup_seq as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__wakeup_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__woken_seq as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__woken_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__mutex as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__nwaiters as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__nwaiters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__broadcast_seq as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__broadcast_seq)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: pthread_rwlock_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_rwlock_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __nr_readers: ::std::os::raw::c_uint,
    pub __readers_wakeup: ::std::os::raw::c_uint,
    pub __writer_wakeup: ::std::os::raw::c_uint,
    pub __nr_readers_queued: ::std::os::raw::c_uint,
    pub __nr_writers_queued: ::std::os::raw::c_uint,
    pub __writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__readers_wakeup as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__readers_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer_wakeup as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers_queued
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_writers_queued
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_writers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__rwelision as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad1 as *const _ as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad2 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__flags)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
#[test]
fn bindgen_test_layout_random_data() {
    assert_eq!(
        ::std::mem::size_of::<random_data>(),
        48usize,
        concat!("Size of: ", stringify!(random_data))
    );
    assert_eq!(
        ::std::mem::align_of::<random_data>(),
        8usize,
        concat!("Alignment of ", stringify!(random_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).state as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_deg as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_deg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).end_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(end_ptr)
        )
    );
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: usize,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_drand48_data() {
    assert_eq!(
        ::std::mem::size_of::<drand48_data>(),
        24usize,
        concat!("Size of: ", stringify!(drand48_data))
    );
    assert_eq!(
        ::std::mem::align_of::<drand48_data>(),
        8usize,
        concat!("Alignment of ", stringify!(drand48_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__old_x as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__old_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__c as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__init as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__a as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__a)
        )
    );
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(__nmemb: usize, __size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn cfree(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(__size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: usize,
        __size: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(__alignment: usize, __size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void, arg2: *const ::std::os::raw::c_void)
        -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: usize,
        __size: usize,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: usize,
        __size: usize,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(__pwcs: *mut wchar_t, __s: *const ::std::os::raw::c_char, __n: usize) -> usize;
}
extern "C" {
    pub fn wcstombs(__s: *mut ::std::os::raw::c_char, __pwcs: *const wchar_t, __n: usize) -> usize;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *const ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
/// *
/// Digital audio interface					    *
/// *
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_aes_iec958 {
    pub status: [::std::os::raw::c_uchar; 24usize],
    pub subcode: [::std::os::raw::c_uchar; 147usize],
    pub pad: ::std::os::raw::c_uchar,
    pub dig_subframe: [::std::os::raw::c_uchar; 4usize],
}
#[test]
fn bindgen_test_layout_snd_aes_iec958() {
    assert_eq!(
        ::std::mem::size_of::<snd_aes_iec958>(),
        176usize,
        concat!("Size of: ", stringify!(snd_aes_iec958))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_aes_iec958>(),
        1usize,
        concat!("Alignment of ", stringify!(snd_aes_iec958))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_aes_iec958>())).status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_aes_iec958),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_aes_iec958>())).subcode as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_aes_iec958),
            "::",
            stringify!(subcode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_aes_iec958>())).pad as *const _ as usize },
        171usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_aes_iec958),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_aes_iec958>())).dig_subframe as *const _ as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_aes_iec958),
            "::",
            stringify!(dig_subframe)
        )
    );
}
/// *
/// CEA-861 Audio InfoFrame. Used in HDMI and DisplayPort		    *
/// *
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_cea_861_aud_if {
    pub db1_ct_cc: ::std::os::raw::c_uchar,
    pub db2_sf_ss: ::std::os::raw::c_uchar,
    pub db3: ::std::os::raw::c_uchar,
    pub db4_ca: ::std::os::raw::c_uchar,
    pub db5_dminh_lsv: ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout_snd_cea_861_aud_if() {
    assert_eq!(
        ::std::mem::size_of::<snd_cea_861_aud_if>(),
        5usize,
        concat!("Size of: ", stringify!(snd_cea_861_aud_if))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_cea_861_aud_if>(),
        1usize,
        concat!("Alignment of ", stringify!(snd_cea_861_aud_if))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_cea_861_aud_if>())).db1_ct_cc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_cea_861_aud_if),
            "::",
            stringify!(db1_ct_cc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_cea_861_aud_if>())).db2_sf_ss as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_cea_861_aud_if),
            "::",
            stringify!(db2_sf_ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_cea_861_aud_if>())).db3 as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_cea_861_aud_if),
            "::",
            stringify!(db3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_cea_861_aud_if>())).db4_ca as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_cea_861_aud_if),
            "::",
            stringify!(db4_ca)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_cea_861_aud_if>())).db5_dminh_lsv as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_cea_861_aud_if),
            "::",
            stringify!(db5_dminh_lsv)
        )
    );
}
pub const SNDRV_HWDEP_IFACE_OPL2: _bindgen_ty_1 = 0;
pub const SNDRV_HWDEP_IFACE_OPL3: _bindgen_ty_1 = 1;
pub const SNDRV_HWDEP_IFACE_OPL4: _bindgen_ty_1 = 2;
pub const SNDRV_HWDEP_IFACE_SB16CSP: _bindgen_ty_1 = 3;
pub const SNDRV_HWDEP_IFACE_EMU10K1: _bindgen_ty_1 = 4;
pub const SNDRV_HWDEP_IFACE_YSS225: _bindgen_ty_1 = 5;
pub const SNDRV_HWDEP_IFACE_ICS2115: _bindgen_ty_1 = 6;
pub const SNDRV_HWDEP_IFACE_SSCAPE: _bindgen_ty_1 = 7;
pub const SNDRV_HWDEP_IFACE_VX: _bindgen_ty_1 = 8;
pub const SNDRV_HWDEP_IFACE_MIXART: _bindgen_ty_1 = 9;
pub const SNDRV_HWDEP_IFACE_USX2Y: _bindgen_ty_1 = 10;
pub const SNDRV_HWDEP_IFACE_EMUX_WAVETABLE: _bindgen_ty_1 = 11;
pub const SNDRV_HWDEP_IFACE_BLUETOOTH: _bindgen_ty_1 = 12;
pub const SNDRV_HWDEP_IFACE_USX2Y_PCM: _bindgen_ty_1 = 13;
pub const SNDRV_HWDEP_IFACE_PCXHR: _bindgen_ty_1 = 14;
pub const SNDRV_HWDEP_IFACE_SB_RC: _bindgen_ty_1 = 15;
pub const SNDRV_HWDEP_IFACE_HDA: _bindgen_ty_1 = 16;
pub const SNDRV_HWDEP_IFACE_USB_STREAM: _bindgen_ty_1 = 17;
pub const SNDRV_HWDEP_IFACE_FW_DICE: _bindgen_ty_1 = 18;
pub const SNDRV_HWDEP_IFACE_FW_FIREWORKS: _bindgen_ty_1 = 19;
pub const SNDRV_HWDEP_IFACE_FW_BEBOB: _bindgen_ty_1 = 20;
pub const SNDRV_HWDEP_IFACE_FW_OXFW: _bindgen_ty_1 = 21;
pub const SNDRV_HWDEP_IFACE_FW_DIGI00X: _bindgen_ty_1 = 22;
pub const SNDRV_HWDEP_IFACE_FW_TASCAM: _bindgen_ty_1 = 23;
pub const SNDRV_HWDEP_IFACE_LINE6: _bindgen_ty_1 = 24;
pub const SNDRV_HWDEP_IFACE_FW_MOTU: _bindgen_ty_1 = 25;
pub const SNDRV_HWDEP_IFACE_FW_FIREFACE: _bindgen_ty_1 = 26;
pub const SNDRV_HWDEP_IFACE_LAST: _bindgen_ty_1 = 26;
pub type _bindgen_ty_1 = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_hwdep_info {
    pub device: ::std::os::raw::c_uint,
    pub card: ::std::os::raw::c_int,
    pub id: [::std::os::raw::c_uchar; 64usize],
    pub name: [::std::os::raw::c_uchar; 80usize],
    pub iface: ::std::os::raw::c_int,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_snd_hwdep_info() {
    assert_eq!(
        ::std::mem::size_of::<snd_hwdep_info>(),
        220usize,
        concat!("Size of: ", stringify!(snd_hwdep_info))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_hwdep_info>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_hwdep_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_info>())).device as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_info),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_info>())).card as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_info),
            "::",
            stringify!(card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_info>())).id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_info>())).name as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_info>())).iface as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_info),
            "::",
            stringify!(iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_info>())).reserved as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_info),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_hwdep_dsp_status {
    pub version: ::std::os::raw::c_uint,
    pub id: [::std::os::raw::c_uchar; 32usize],
    pub num_dsps: ::std::os::raw::c_uint,
    pub dsp_loaded: ::std::os::raw::c_uint,
    pub chip_ready: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uchar; 16usize],
}
#[test]
fn bindgen_test_layout_snd_hwdep_dsp_status() {
    assert_eq!(
        ::std::mem::size_of::<snd_hwdep_dsp_status>(),
        64usize,
        concat!("Size of: ", stringify!(snd_hwdep_dsp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_hwdep_dsp_status>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_hwdep_dsp_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_status>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_status),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_status>())).id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_status),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_status>())).num_dsps as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_status),
            "::",
            stringify!(num_dsps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_status>())).dsp_loaded as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_status),
            "::",
            stringify!(dsp_loaded)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_status>())).chip_ready as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_status),
            "::",
            stringify!(chip_ready)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_status>())).reserved as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_status),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_hwdep_dsp_image {
    pub index: ::std::os::raw::c_uint,
    pub name: [::std::os::raw::c_uchar; 64usize],
    pub image: *mut ::std::os::raw::c_uchar,
    pub length: usize,
    pub driver_data: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_snd_hwdep_dsp_image() {
    assert_eq!(
        ::std::mem::size_of::<snd_hwdep_dsp_image>(),
        96usize,
        concat!("Size of: ", stringify!(snd_hwdep_dsp_image))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_hwdep_dsp_image>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_hwdep_dsp_image))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_image>())).index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_image),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_image>())).name as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_image),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_image>())).image as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_image),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_image>())).length as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_image),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_hwdep_dsp_image>())).driver_data as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_hwdep_dsp_image),
            "::",
            stringify!(driver_data)
        )
    );
}
pub type snd_pcm_uframes_t = ::std::os::raw::c_ulong;
pub type snd_pcm_sframes_t = ::std::os::raw::c_long;
pub const SNDRV_PCM_CLASS_GENERIC: _bindgen_ty_2 = 0;
pub const SNDRV_PCM_CLASS_MULTI: _bindgen_ty_2 = 1;
pub const SNDRV_PCM_CLASS_MODEM: _bindgen_ty_2 = 2;
pub const SNDRV_PCM_CLASS_DIGITIZER: _bindgen_ty_2 = 3;
pub const SNDRV_PCM_CLASS_LAST: _bindgen_ty_2 = 3;
pub type _bindgen_ty_2 = u32;
pub const SNDRV_PCM_SUBCLASS_GENERIC_MIX: _bindgen_ty_3 = 0;
pub const SNDRV_PCM_SUBCLASS_MULTI_MIX: _bindgen_ty_3 = 1;
pub const SNDRV_PCM_SUBCLASS_LAST: _bindgen_ty_3 = 1;
pub type _bindgen_ty_3 = u32;
pub const SNDRV_PCM_STREAM_PLAYBACK: _bindgen_ty_4 = 0;
pub const SNDRV_PCM_STREAM_CAPTURE: _bindgen_ty_4 = 1;
pub const SNDRV_PCM_STREAM_LAST: _bindgen_ty_4 = 1;
pub type _bindgen_ty_4 = u32;
pub type snd_pcm_access_t = ::std::os::raw::c_int;
pub type snd_pcm_format_t = ::std::os::raw::c_int;
pub type snd_pcm_subformat_t = ::std::os::raw::c_int;
pub type snd_pcm_state_t = ::std::os::raw::c_int;
pub const SNDRV_PCM_MMAP_OFFSET_DATA: _bindgen_ty_5 = 0;
pub const SNDRV_PCM_MMAP_OFFSET_STATUS: _bindgen_ty_5 = 2147483648;
pub const SNDRV_PCM_MMAP_OFFSET_CONTROL: _bindgen_ty_5 = 2164260864;
pub type _bindgen_ty_5 = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_pcm_sync_id {
    pub id: [::std::os::raw::c_uchar; 16usize],
    pub id16: [::std::os::raw::c_ushort; 8usize],
    pub id32: [::std::os::raw::c_uint; 4usize],
    _bindgen_union_align: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_snd_pcm_sync_id() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_sync_id>(),
        16usize,
        concat!("Size of: ", stringify!(snd_pcm_sync_id))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_sync_id>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_pcm_sync_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sync_id>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_id),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sync_id>())).id16 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_id),
            "::",
            stringify!(id16)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sync_id>())).id32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_id),
            "::",
            stringify!(id32)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_pcm_info {
    pub device: ::std::os::raw::c_uint,
    pub subdevice: ::std::os::raw::c_uint,
    pub stream: ::std::os::raw::c_int,
    pub card: ::std::os::raw::c_int,
    pub id: [::std::os::raw::c_uchar; 64usize],
    pub name: [::std::os::raw::c_uchar; 80usize],
    pub subname: [::std::os::raw::c_uchar; 32usize],
    pub dev_class: ::std::os::raw::c_int,
    pub dev_subclass: ::std::os::raw::c_int,
    pub subdevices_count: ::std::os::raw::c_uint,
    pub subdevices_avail: ::std::os::raw::c_uint,
    pub sync: snd_pcm_sync_id,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_snd_pcm_info() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_info>(),
        288usize,
        concat!("Size of: ", stringify!(snd_pcm_info))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_info>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_pcm_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).device as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).subdevice as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(subdevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).stream as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).card as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).id as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).name as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).subname as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(subname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).dev_class as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(dev_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).dev_subclass as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(dev_subclass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).subdevices_count as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(subdevices_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).subdevices_avail as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(subdevices_avail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).sync as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(sync)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_info>())).reserved as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_info),
            "::",
            stringify!(reserved)
        )
    );
}
pub type snd_pcm_hw_param_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_interval {
    pub min: ::std::os::raw::c_uint,
    pub max: ::std::os::raw::c_uint,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_snd_interval() {
    assert_eq!(
        ::std::mem::size_of::<snd_interval>(),
        12usize,
        concat!("Size of: ", stringify!(snd_interval))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_interval>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_interval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_interval>())).min as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_interval),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_interval>())).max as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_interval),
            "::",
            stringify!(max)
        )
    );
}
impl snd_interval {
    #[inline]
    pub fn openmin(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_openmin(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn openmax(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_openmax(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn integer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_integer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn empty(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_empty(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        openmin: ::std::os::raw::c_uint,
        openmax: ::std::os::raw::c_uint,
        integer: ::std::os::raw::c_uint,
        empty: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let openmin: u32 = unsafe { ::std::mem::transmute(openmin) };
            openmin as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let openmax: u32 = unsafe { ::std::mem::transmute(openmax) };
            openmax as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let integer: u32 = unsafe { ::std::mem::transmute(integer) };
            integer as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let empty: u32 = unsafe { ::std::mem::transmute(empty) };
            empty as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_mask {
    pub bits: [__u32; 8usize],
}
#[test]
fn bindgen_test_layout_snd_mask() {
    assert_eq!(
        ::std::mem::size_of::<snd_mask>(),
        32usize,
        concat!("Size of: ", stringify!(snd_mask))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_mask>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_mask))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_mask>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_mask),
            "::",
            stringify!(bits)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_pcm_hw_params {
    pub flags: ::std::os::raw::c_uint,
    pub masks: [snd_mask; 3usize],
    pub mres: [snd_mask; 5usize],
    pub intervals: [snd_interval; 12usize],
    pub ires: [snd_interval; 9usize],
    pub rmask: ::std::os::raw::c_uint,
    pub cmask: ::std::os::raw::c_uint,
    pub info: ::std::os::raw::c_uint,
    pub msbits: ::std::os::raw::c_uint,
    pub rate_num: ::std::os::raw::c_uint,
    pub rate_den: ::std::os::raw::c_uint,
    pub fifo_size: snd_pcm_uframes_t,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_snd_pcm_hw_params() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_hw_params>(),
        608usize,
        concat!("Size of: ", stringify!(snd_pcm_hw_params))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_hw_params>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_hw_params))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).masks as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(masks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).mres as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(mres)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).intervals as *const _ as usize },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(intervals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).ires as *const _ as usize },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(ires)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).rmask as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(rmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).cmask as *const _ as usize },
        516usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(cmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).info as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).msbits as *const _ as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(msbits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).rate_num as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(rate_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).rate_den as *const _ as usize },
        532usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(rate_den)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).fifo_size as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(fifo_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_hw_params>())).reserved as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_hw_params),
            "::",
            stringify!(reserved)
        )
    );
}
pub const SNDRV_PCM_TSTAMP_NONE: _bindgen_ty_6 = 0;
pub const SNDRV_PCM_TSTAMP_ENABLE: _bindgen_ty_6 = 1;
pub const SNDRV_PCM_TSTAMP_LAST: _bindgen_ty_6 = 1;
pub type _bindgen_ty_6 = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_pcm_sw_params {
    pub tstamp_mode: ::std::os::raw::c_int,
    pub period_step: ::std::os::raw::c_uint,
    pub sleep_min: ::std::os::raw::c_uint,
    pub avail_min: snd_pcm_uframes_t,
    pub xfer_align: snd_pcm_uframes_t,
    pub start_threshold: snd_pcm_uframes_t,
    pub stop_threshold: snd_pcm_uframes_t,
    pub silence_threshold: snd_pcm_uframes_t,
    pub silence_size: snd_pcm_uframes_t,
    pub boundary: snd_pcm_uframes_t,
    pub proto: ::std::os::raw::c_uint,
    pub tstamp_type: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uchar; 56usize],
}
#[test]
fn bindgen_test_layout_snd_pcm_sw_params() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_sw_params>(),
        136usize,
        concat!("Size of: ", stringify!(snd_pcm_sw_params))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_sw_params>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_sw_params))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).tstamp_mode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(tstamp_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).period_step as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(period_step)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).sleep_min as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(sleep_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).avail_min as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(avail_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).xfer_align as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(xfer_align)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_sw_params>())).start_threshold as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(start_threshold)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_sw_params>())).stop_threshold as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(stop_threshold)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_sw_params>())).silence_threshold as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(silence_threshold)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).silence_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(silence_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).boundary as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(boundary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).proto as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).tstamp_type as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(tstamp_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sw_params>())).reserved as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sw_params),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_pcm_channel_info {
    pub channel: ::std::os::raw::c_uint,
    pub offset: __kernel_off_t,
    pub first: ::std::os::raw::c_uint,
    pub step: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_snd_pcm_channel_info() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_channel_info>(),
        24usize,
        concat!("Size of: ", stringify!(snd_pcm_channel_info))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_channel_info>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_channel_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_channel_info>())).channel as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_channel_info),
            "::",
            stringify!(channel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_channel_info>())).offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_channel_info),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_channel_info>())).first as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_channel_info),
            "::",
            stringify!(first)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_channel_info>())).step as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_channel_info),
            "::",
            stringify!(step)
        )
    );
}
pub const SNDRV_PCM_AUDIO_TSTAMP_TYPE_COMPAT: _bindgen_ty_7 = 0;
pub const SNDRV_PCM_AUDIO_TSTAMP_TYPE_DEFAULT: _bindgen_ty_7 = 1;
pub const SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK: _bindgen_ty_7 = 2;
pub const SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE: _bindgen_ty_7 = 3;
pub const SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED: _bindgen_ty_7 = 4;
pub const SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED: _bindgen_ty_7 = 5;
pub const SNDRV_PCM_AUDIO_TSTAMP_TYPE_LAST: _bindgen_ty_7 = 5;
pub type _bindgen_ty_7 = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_pcm_status {
    pub state: snd_pcm_state_t,
    pub trigger_tstamp: timespec,
    pub tstamp: timespec,
    pub appl_ptr: snd_pcm_uframes_t,
    pub hw_ptr: snd_pcm_uframes_t,
    pub delay: snd_pcm_sframes_t,
    pub avail: snd_pcm_uframes_t,
    pub avail_max: snd_pcm_uframes_t,
    pub overrange: snd_pcm_uframes_t,
    pub suspended_state: snd_pcm_state_t,
    pub audio_tstamp_data: __u32,
    pub audio_tstamp: timespec,
    pub driver_tstamp: timespec,
    pub audio_tstamp_accuracy: __u32,
    pub reserved: [::std::os::raw::c_uchar; 20usize],
}
#[test]
fn bindgen_test_layout_snd_pcm_status() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_status>(),
        152usize,
        concat!("Size of: ", stringify!(snd_pcm_status))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_status>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).trigger_tstamp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(trigger_tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).tstamp as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).appl_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(appl_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).hw_ptr as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(hw_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).delay as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(delay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).avail as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(avail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).avail_max as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(avail_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).overrange as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(overrange)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).suspended_state as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(suspended_state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_status>())).audio_tstamp_data as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(audio_tstamp_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).audio_tstamp as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(audio_tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).driver_tstamp as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(driver_tstamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_status>())).audio_tstamp_accuracy as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(audio_tstamp_accuracy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_status>())).reserved as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_status),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_pcm_mmap_status {
    pub state: snd_pcm_state_t,
    pub pad1: ::std::os::raw::c_int,
    pub hw_ptr: snd_pcm_uframes_t,
    pub tstamp: timespec,
    pub suspended_state: snd_pcm_state_t,
    pub audio_tstamp: timespec,
}
#[test]
fn bindgen_test_layout_snd_pcm_mmap_status() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_mmap_status>(),
        56usize,
        concat!("Size of: ", stringify!(snd_pcm_mmap_status))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_mmap_status>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_mmap_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_mmap_status>())).state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_status),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_mmap_status>())).pad1 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_status),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_mmap_status>())).hw_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_status),
            "::",
            stringify!(hw_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_mmap_status>())).tstamp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_status),
            "::",
            stringify!(tstamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_mmap_status>())).suspended_state as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_status),
            "::",
            stringify!(suspended_state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_mmap_status>())).audio_tstamp as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_status),
            "::",
            stringify!(audio_tstamp)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_pcm_mmap_control {
    pub appl_ptr: snd_pcm_uframes_t,
    pub avail_min: snd_pcm_uframes_t,
}
#[test]
fn bindgen_test_layout_snd_pcm_mmap_control() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_mmap_control>(),
        16usize,
        concat!("Size of: ", stringify!(snd_pcm_mmap_control))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_mmap_control>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_mmap_control))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_mmap_control>())).appl_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_control),
            "::",
            stringify!(appl_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_mmap_control>())).avail_min as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_mmap_control),
            "::",
            stringify!(avail_min)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_pcm_sync_ptr {
    pub flags: ::std::os::raw::c_uint,
    pub s: snd_pcm_sync_ptr__bindgen_ty_1,
    pub c: snd_pcm_sync_ptr__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_pcm_sync_ptr__bindgen_ty_1 {
    pub status: snd_pcm_mmap_status,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
    _bindgen_union_align: [u64; 8usize],
}
#[test]
fn bindgen_test_layout_snd_pcm_sync_ptr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_sync_ptr__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(snd_pcm_sync_ptr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_sync_ptr__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_sync_ptr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_sync_ptr__bindgen_ty_1>())).status as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_ptr__bindgen_ty_1),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_sync_ptr__bindgen_ty_1>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_ptr__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_pcm_sync_ptr__bindgen_ty_2 {
    pub control: snd_pcm_mmap_control,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
    _bindgen_union_align: [u64; 8usize],
}
#[test]
fn bindgen_test_layout_snd_pcm_sync_ptr__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_sync_ptr__bindgen_ty_2>(),
        64usize,
        concat!("Size of: ", stringify!(snd_pcm_sync_ptr__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_sync_ptr__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_sync_ptr__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_sync_ptr__bindgen_ty_2>())).control as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_ptr__bindgen_ty_2),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_pcm_sync_ptr__bindgen_ty_2>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_ptr__bindgen_ty_2),
            "::",
            stringify!(reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_snd_pcm_sync_ptr() {
    assert_eq!(
        ::std::mem::size_of::<snd_pcm_sync_ptr>(),
        136usize,
        concat!("Size of: ", stringify!(snd_pcm_sync_ptr))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_pcm_sync_ptr>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_pcm_sync_ptr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sync_ptr>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_ptr),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sync_ptr>())).s as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_ptr),
            "::",
            stringify!(s)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_pcm_sync_ptr>())).c as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_pcm_sync_ptr),
            "::",
            stringify!(c)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_xferi {
    pub result: snd_pcm_sframes_t,
    pub buf: *mut ::std::os::raw::c_void,
    pub frames: snd_pcm_uframes_t,
}
#[test]
fn bindgen_test_layout_snd_xferi() {
    assert_eq!(
        ::std::mem::size_of::<snd_xferi>(),
        24usize,
        concat!("Size of: ", stringify!(snd_xferi))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_xferi>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_xferi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_xferi>())).result as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_xferi),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_xferi>())).buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_xferi),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_xferi>())).frames as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_xferi),
            "::",
            stringify!(frames)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_xfern {
    pub result: snd_pcm_sframes_t,
    pub bufs: *mut *mut ::std::os::raw::c_void,
    pub frames: snd_pcm_uframes_t,
}
#[test]
fn bindgen_test_layout_snd_xfern() {
    assert_eq!(
        ::std::mem::size_of::<snd_xfern>(),
        24usize,
        concat!("Size of: ", stringify!(snd_xfern))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_xfern>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_xfern))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_xfern>())).result as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_xfern),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_xfern>())).bufs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_xfern),
            "::",
            stringify!(bufs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_xfern>())).frames as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_xfern),
            "::",
            stringify!(frames)
        )
    );
}
pub const SNDRV_PCM_TSTAMP_TYPE_GETTIMEOFDAY: _bindgen_ty_8 = 0;
pub const SNDRV_PCM_TSTAMP_TYPE_MONOTONIC: _bindgen_ty_8 = 1;
pub const SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW: _bindgen_ty_8 = 2;
pub const SNDRV_PCM_TSTAMP_TYPE_LAST: _bindgen_ty_8 = 2;
pub type _bindgen_ty_8 = u32;
pub const SNDRV_CHMAP_UNKNOWN: _bindgen_ty_9 = 0;
pub const SNDRV_CHMAP_NA: _bindgen_ty_9 = 1;
pub const SNDRV_CHMAP_MONO: _bindgen_ty_9 = 2;
pub const SNDRV_CHMAP_FL: _bindgen_ty_9 = 3;
pub const SNDRV_CHMAP_FR: _bindgen_ty_9 = 4;
pub const SNDRV_CHMAP_RL: _bindgen_ty_9 = 5;
pub const SNDRV_CHMAP_RR: _bindgen_ty_9 = 6;
pub const SNDRV_CHMAP_FC: _bindgen_ty_9 = 7;
pub const SNDRV_CHMAP_LFE: _bindgen_ty_9 = 8;
pub const SNDRV_CHMAP_SL: _bindgen_ty_9 = 9;
pub const SNDRV_CHMAP_SR: _bindgen_ty_9 = 10;
pub const SNDRV_CHMAP_RC: _bindgen_ty_9 = 11;
pub const SNDRV_CHMAP_FLC: _bindgen_ty_9 = 12;
pub const SNDRV_CHMAP_FRC: _bindgen_ty_9 = 13;
pub const SNDRV_CHMAP_RLC: _bindgen_ty_9 = 14;
pub const SNDRV_CHMAP_RRC: _bindgen_ty_9 = 15;
pub const SNDRV_CHMAP_FLW: _bindgen_ty_9 = 16;
pub const SNDRV_CHMAP_FRW: _bindgen_ty_9 = 17;
pub const SNDRV_CHMAP_FLH: _bindgen_ty_9 = 18;
pub const SNDRV_CHMAP_FCH: _bindgen_ty_9 = 19;
pub const SNDRV_CHMAP_FRH: _bindgen_ty_9 = 20;
pub const SNDRV_CHMAP_TC: _bindgen_ty_9 = 21;
pub const SNDRV_CHMAP_TFL: _bindgen_ty_9 = 22;
pub const SNDRV_CHMAP_TFR: _bindgen_ty_9 = 23;
pub const SNDRV_CHMAP_TFC: _bindgen_ty_9 = 24;
pub const SNDRV_CHMAP_TRL: _bindgen_ty_9 = 25;
pub const SNDRV_CHMAP_TRR: _bindgen_ty_9 = 26;
pub const SNDRV_CHMAP_TRC: _bindgen_ty_9 = 27;
pub const SNDRV_CHMAP_TFLC: _bindgen_ty_9 = 28;
pub const SNDRV_CHMAP_TFRC: _bindgen_ty_9 = 29;
pub const SNDRV_CHMAP_TSL: _bindgen_ty_9 = 30;
pub const SNDRV_CHMAP_TSR: _bindgen_ty_9 = 31;
pub const SNDRV_CHMAP_LLFE: _bindgen_ty_9 = 32;
pub const SNDRV_CHMAP_RLFE: _bindgen_ty_9 = 33;
pub const SNDRV_CHMAP_BC: _bindgen_ty_9 = 34;
pub const SNDRV_CHMAP_BLC: _bindgen_ty_9 = 35;
pub const SNDRV_CHMAP_BRC: _bindgen_ty_9 = 36;
pub const SNDRV_CHMAP_LAST: _bindgen_ty_9 = 36;
pub type _bindgen_ty_9 = u32;
pub const SNDRV_RAWMIDI_STREAM_OUTPUT: _bindgen_ty_10 = 0;
pub const SNDRV_RAWMIDI_STREAM_INPUT: _bindgen_ty_10 = 1;
pub const SNDRV_RAWMIDI_STREAM_LAST: _bindgen_ty_10 = 1;
pub type _bindgen_ty_10 = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_rawmidi_info {
    pub device: ::std::os::raw::c_uint,
    pub subdevice: ::std::os::raw::c_uint,
    pub stream: ::std::os::raw::c_int,
    pub card: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_uint,
    pub id: [::std::os::raw::c_uchar; 64usize],
    pub name: [::std::os::raw::c_uchar; 80usize],
    pub subname: [::std::os::raw::c_uchar; 32usize],
    pub subdevices_count: ::std::os::raw::c_uint,
    pub subdevices_avail: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_snd_rawmidi_info() {
    assert_eq!(
        ::std::mem::size_of::<snd_rawmidi_info>(),
        268usize,
        concat!("Size of: ", stringify!(snd_rawmidi_info))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_rawmidi_info>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_rawmidi_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).device as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).subdevice as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(subdevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).stream as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).card as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).id as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).name as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).subname as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(subname)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_rawmidi_info>())).subdevices_count as *const _ as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(subdevices_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_rawmidi_info>())).subdevices_avail as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(subdevices_avail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_info>())).reserved as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_info),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_rawmidi_params {
    pub stream: ::std::os::raw::c_int,
    pub buffer_size: usize,
    pub avail_min: usize,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub reserved: [::std::os::raw::c_uchar; 16usize],
}
#[test]
fn bindgen_test_layout_snd_rawmidi_params() {
    assert_eq!(
        ::std::mem::size_of::<snd_rawmidi_params>(),
        48usize,
        concat!("Size of: ", stringify!(snd_rawmidi_params))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_rawmidi_params>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_rawmidi_params))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_params>())).stream as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_params),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_params>())).buffer_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_params),
            "::",
            stringify!(buffer_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_params>())).avail_min as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_params),
            "::",
            stringify!(avail_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_params>())).reserved as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_params),
            "::",
            stringify!(reserved)
        )
    );
}
impl snd_rawmidi_params {
    #[inline]
    pub fn no_active_sensing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_active_sensing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        no_active_sensing: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let no_active_sensing: u32 = unsafe { ::std::mem::transmute(no_active_sensing) };
            no_active_sensing as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_rawmidi_status {
    pub stream: ::std::os::raw::c_int,
    pub tstamp: timespec,
    pub avail: usize,
    pub xruns: usize,
    pub reserved: [::std::os::raw::c_uchar; 16usize],
}
#[test]
fn bindgen_test_layout_snd_rawmidi_status() {
    assert_eq!(
        ::std::mem::size_of::<snd_rawmidi_status>(),
        56usize,
        concat!("Size of: ", stringify!(snd_rawmidi_status))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_rawmidi_status>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_rawmidi_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_status>())).stream as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_status),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_status>())).tstamp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_status),
            "::",
            stringify!(tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_status>())).avail as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_status),
            "::",
            stringify!(avail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_status>())).xruns as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_status),
            "::",
            stringify!(xruns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_rawmidi_status>())).reserved as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_rawmidi_status),
            "::",
            stringify!(reserved)
        )
    );
}
pub const SNDRV_TIMER_CLASS_NONE: _bindgen_ty_11 = -1;
pub const SNDRV_TIMER_CLASS_SLAVE: _bindgen_ty_11 = 0;
pub const SNDRV_TIMER_CLASS_GLOBAL: _bindgen_ty_11 = 1;
pub const SNDRV_TIMER_CLASS_CARD: _bindgen_ty_11 = 2;
pub const SNDRV_TIMER_CLASS_PCM: _bindgen_ty_11 = 3;
pub const SNDRV_TIMER_CLASS_LAST: _bindgen_ty_11 = 3;
pub type _bindgen_ty_11 = i32;
pub const SNDRV_TIMER_SCLASS_NONE: _bindgen_ty_12 = 0;
pub const SNDRV_TIMER_SCLASS_APPLICATION: _bindgen_ty_12 = 1;
pub const SNDRV_TIMER_SCLASS_SEQUENCER: _bindgen_ty_12 = 2;
pub const SNDRV_TIMER_SCLASS_OSS_SEQUENCER: _bindgen_ty_12 = 3;
pub const SNDRV_TIMER_SCLASS_LAST: _bindgen_ty_12 = 3;
pub type _bindgen_ty_12 = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_timer_id {
    pub dev_class: ::std::os::raw::c_int,
    pub dev_sclass: ::std::os::raw::c_int,
    pub card: ::std::os::raw::c_int,
    pub device: ::std::os::raw::c_int,
    pub subdevice: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_snd_timer_id() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_id>(),
        20usize,
        concat!("Size of: ", stringify!(snd_timer_id))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_id>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_timer_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_id>())).dev_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_id),
            "::",
            stringify!(dev_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_id>())).dev_sclass as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_id),
            "::",
            stringify!(dev_sclass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_id>())).card as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_id),
            "::",
            stringify!(card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_id>())).device as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_id),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_id>())).subdevice as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_id),
            "::",
            stringify!(subdevice)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_timer_ginfo {
    pub tid: snd_timer_id,
    pub flags: ::std::os::raw::c_uint,
    pub card: ::std::os::raw::c_int,
    pub id: [::std::os::raw::c_uchar; 64usize],
    pub name: [::std::os::raw::c_uchar; 80usize],
    pub reserved0: ::std::os::raw::c_ulong,
    pub resolution: ::std::os::raw::c_ulong,
    pub resolution_min: ::std::os::raw::c_ulong,
    pub resolution_max: ::std::os::raw::c_ulong,
    pub clients: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uchar; 32usize],
}
#[test]
fn bindgen_test_layout_snd_timer_ginfo() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_ginfo>(),
        248usize,
        concat!("Size of: ", stringify!(snd_timer_ginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_ginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_timer_ginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).tid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).card as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).id as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).name as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).reserved0 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(reserved0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).resolution as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(resolution)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).resolution_min as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(resolution_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).resolution_max as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(resolution_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).clients as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(clients)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_ginfo>())).reserved as *const _ as usize },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_ginfo),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_timer_gparams {
    pub tid: snd_timer_id,
    pub period_num: ::std::os::raw::c_ulong,
    pub period_den: ::std::os::raw::c_ulong,
    pub reserved: [::std::os::raw::c_uchar; 32usize],
}
#[test]
fn bindgen_test_layout_snd_timer_gparams() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_gparams>(),
        72usize,
        concat!("Size of: ", stringify!(snd_timer_gparams))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_gparams>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_timer_gparams))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_gparams>())).tid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gparams),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_gparams>())).period_num as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gparams),
            "::",
            stringify!(period_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_gparams>())).period_den as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gparams),
            "::",
            stringify!(period_den)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_gparams>())).reserved as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gparams),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_timer_gstatus {
    pub tid: snd_timer_id,
    pub resolution: ::std::os::raw::c_ulong,
    pub resolution_num: ::std::os::raw::c_ulong,
    pub resolution_den: ::std::os::raw::c_ulong,
    pub reserved: [::std::os::raw::c_uchar; 32usize],
}
#[test]
fn bindgen_test_layout_snd_timer_gstatus() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_gstatus>(),
        80usize,
        concat!("Size of: ", stringify!(snd_timer_gstatus))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_gstatus>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_timer_gstatus))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_gstatus>())).tid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gstatus),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_gstatus>())).resolution as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gstatus),
            "::",
            stringify!(resolution)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_timer_gstatus>())).resolution_num as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gstatus),
            "::",
            stringify!(resolution_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_timer_gstatus>())).resolution_den as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gstatus),
            "::",
            stringify!(resolution_den)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_gstatus>())).reserved as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_gstatus),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_timer_select {
    pub id: snd_timer_id,
    pub reserved: [::std::os::raw::c_uchar; 32usize],
}
#[test]
fn bindgen_test_layout_snd_timer_select() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_select>(),
        52usize,
        concat!("Size of: ", stringify!(snd_timer_select))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_select>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_timer_select))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_select>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_select),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_select>())).reserved as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_select),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_timer_info {
    pub flags: ::std::os::raw::c_uint,
    pub card: ::std::os::raw::c_int,
    pub id: [::std::os::raw::c_uchar; 64usize],
    pub name: [::std::os::raw::c_uchar; 80usize],
    pub reserved0: ::std::os::raw::c_ulong,
    pub resolution: ::std::os::raw::c_ulong,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_snd_timer_info() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_info>(),
        232usize,
        concat!("Size of: ", stringify!(snd_timer_info))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_info>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_timer_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_info>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_info>())).card as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_info),
            "::",
            stringify!(card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_info>())).id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_info>())).name as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_info>())).reserved0 as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_info),
            "::",
            stringify!(reserved0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_info>())).resolution as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_info),
            "::",
            stringify!(resolution)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_info>())).reserved as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_info),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_timer_params {
    pub flags: ::std::os::raw::c_uint,
    pub ticks: ::std::os::raw::c_uint,
    pub queue_size: ::std::os::raw::c_uint,
    pub reserved0: ::std::os::raw::c_uint,
    pub filter: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uchar; 60usize],
}
#[test]
fn bindgen_test_layout_snd_timer_params() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_params>(),
        80usize,
        concat!("Size of: ", stringify!(snd_timer_params))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_params>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_timer_params))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_params>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_params),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_params>())).ticks as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_params),
            "::",
            stringify!(ticks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_params>())).queue_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_params),
            "::",
            stringify!(queue_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_params>())).reserved0 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_params),
            "::",
            stringify!(reserved0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_params>())).filter as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_params),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_params>())).reserved as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_params),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_timer_status {
    pub tstamp: timespec,
    pub resolution: ::std::os::raw::c_uint,
    pub lost: ::std::os::raw::c_uint,
    pub overrun: ::std::os::raw::c_uint,
    pub queue: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_snd_timer_status() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_status>(),
        96usize,
        concat!("Size of: ", stringify!(snd_timer_status))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_status>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_timer_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_status>())).tstamp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_status),
            "::",
            stringify!(tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_status>())).resolution as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_status),
            "::",
            stringify!(resolution)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_status>())).lost as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_status),
            "::",
            stringify!(lost)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_status>())).overrun as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_status),
            "::",
            stringify!(overrun)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_status>())).queue as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_status),
            "::",
            stringify!(queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_status>())).reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_status),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_timer_read {
    pub resolution: ::std::os::raw::c_uint,
    pub ticks: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_snd_timer_read() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_read>(),
        8usize,
        concat!("Size of: ", stringify!(snd_timer_read))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_read>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_timer_read))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_read>())).resolution as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_read),
            "::",
            stringify!(resolution)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_read>())).ticks as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_read),
            "::",
            stringify!(ticks)
        )
    );
}
pub const SNDRV_TIMER_EVENT_RESOLUTION: _bindgen_ty_13 = 0;
pub const SNDRV_TIMER_EVENT_TICK: _bindgen_ty_13 = 1;
pub const SNDRV_TIMER_EVENT_START: _bindgen_ty_13 = 2;
pub const SNDRV_TIMER_EVENT_STOP: _bindgen_ty_13 = 3;
pub const SNDRV_TIMER_EVENT_CONTINUE: _bindgen_ty_13 = 4;
pub const SNDRV_TIMER_EVENT_PAUSE: _bindgen_ty_13 = 5;
pub const SNDRV_TIMER_EVENT_EARLY: _bindgen_ty_13 = 6;
pub const SNDRV_TIMER_EVENT_SUSPEND: _bindgen_ty_13 = 7;
pub const SNDRV_TIMER_EVENT_RESUME: _bindgen_ty_13 = 8;
pub const SNDRV_TIMER_EVENT_MSTART: _bindgen_ty_13 = 12;
pub const SNDRV_TIMER_EVENT_MSTOP: _bindgen_ty_13 = 13;
pub const SNDRV_TIMER_EVENT_MCONTINUE: _bindgen_ty_13 = 14;
pub const SNDRV_TIMER_EVENT_MPAUSE: _bindgen_ty_13 = 15;
pub const SNDRV_TIMER_EVENT_MSUSPEND: _bindgen_ty_13 = 17;
pub const SNDRV_TIMER_EVENT_MRESUME: _bindgen_ty_13 = 18;
pub type _bindgen_ty_13 = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_timer_tread {
    pub event: ::std::os::raw::c_int,
    pub tstamp: timespec,
    pub val: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_snd_timer_tread() {
    assert_eq!(
        ::std::mem::size_of::<snd_timer_tread>(),
        32usize,
        concat!("Size of: ", stringify!(snd_timer_tread))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_timer_tread>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_timer_tread))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_tread>())).event as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_tread),
            "::",
            stringify!(event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_tread>())).tstamp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_tread),
            "::",
            stringify!(tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_timer_tread>())).val as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_timer_tread),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_card_info {
    pub card: ::std::os::raw::c_int,
    pub pad: ::std::os::raw::c_int,
    pub id: [::std::os::raw::c_uchar; 16usize],
    pub driver: [::std::os::raw::c_uchar; 16usize],
    pub name: [::std::os::raw::c_uchar; 32usize],
    pub longname: [::std::os::raw::c_uchar; 80usize],
    pub reserved_: [::std::os::raw::c_uchar; 16usize],
    pub mixername: [::std::os::raw::c_uchar; 80usize],
    pub components: [::std::os::raw::c_uchar; 128usize],
}
#[test]
fn bindgen_test_layout_snd_ctl_card_info() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_card_info>(),
        376usize,
        concat!("Size of: ", stringify!(snd_ctl_card_info))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_card_info>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_ctl_card_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).card as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).pad as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).driver as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(driver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).name as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).longname as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(longname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).reserved_ as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(reserved_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).mixername as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(mixername)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_card_info>())).components as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_card_info),
            "::",
            stringify!(components)
        )
    );
}
pub type snd_ctl_elem_type_t = ::std::os::raw::c_int;
pub type snd_ctl_elem_iface_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_elem_id {
    pub numid: ::std::os::raw::c_uint,
    pub iface: snd_ctl_elem_iface_t,
    pub device: ::std::os::raw::c_uint,
    pub subdevice: ::std::os::raw::c_uint,
    pub name: [::std::os::raw::c_uchar; 44usize],
    pub index: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_id() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_id>(),
        64usize,
        concat!("Size of: ", stringify!(snd_ctl_elem_id))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_id>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_ctl_elem_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_id>())).numid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_id),
            "::",
            stringify!(numid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_id>())).iface as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_id),
            "::",
            stringify!(iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_id>())).device as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_id),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_id>())).subdevice as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_id),
            "::",
            stringify!(subdevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_id>())).name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_id),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_id>())).index as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_id),
            "::",
            stringify!(index)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_elem_list {
    pub offset: ::std::os::raw::c_uint,
    pub space: ::std::os::raw::c_uint,
    pub used: ::std::os::raw::c_uint,
    pub count: ::std::os::raw::c_uint,
    pub pids: *mut snd_ctl_elem_id,
    pub reserved: [::std::os::raw::c_uchar; 50usize],
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_list() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_list>(),
        80usize,
        concat!("Size of: ", stringify!(snd_ctl_elem_list))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_list>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_ctl_elem_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_list>())).offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_list),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_list>())).space as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_list),
            "::",
            stringify!(space)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_list>())).used as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_list),
            "::",
            stringify!(used)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_list>())).count as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_list),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_list>())).pids as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_list),
            "::",
            stringify!(pids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_list>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_list),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_elem_info {
    pub id: snd_ctl_elem_id,
    pub type_: snd_ctl_elem_type_t,
    pub access: ::std::os::raw::c_uint,
    pub count: ::std::os::raw::c_uint,
    pub owner: __kernel_pid_t,
    pub value: snd_ctl_elem_info__bindgen_ty_1,
    pub dimen: snd_ctl_elem_info__bindgen_ty_2,
    pub reserved: [::std::os::raw::c_uchar; 56usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_elem_info__bindgen_ty_1 {
    pub integer: snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1,
    pub integer64: snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2,
    pub enumerated: snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3,
    pub reserved: [::std::os::raw::c_uchar; 128usize],
    _bindgen_union_align: [u64; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1 {
    pub min: ::std::os::raw::c_long,
    pub max: ::std::os::raw::c_long,
    pub step: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1>())).min
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1>())).max
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1>())).step
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(step)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2 {
    pub min: ::std::os::raw::c_longlong,
    pub max: ::std::os::raw::c_longlong,
    pub step: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2>())).min
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2>())).max
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2>())).step
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(step)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3 {
    pub items: ::std::os::raw::c_uint,
    pub item: ::std::os::raw::c_uint,
    pub name: [::std::os::raw::c_char; 64usize],
    pub names_ptr: __u64,
    pub names_length: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3>(),
        88usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3>())).items
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3>())).item
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(item)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3>())).name
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3>())).names_ptr
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(names_ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3>())).names_length
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(names_length)
        )
    );
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_info__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_info__bindgen_ty_1>(),
        128usize,
        concat!("Size of: ", stringify!(snd_ctl_elem_info__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_info__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_ctl_elem_info__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1>())).integer as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1),
            "::",
            stringify!(integer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1>())).integer64 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1),
            "::",
            stringify!(integer64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1>())).enumerated as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1),
            "::",
            stringify!(enumerated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_1>())).reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_elem_info__bindgen_ty_2 {
    pub d: [::std::os::raw::c_ushort; 4usize],
    pub d_ptr: *mut ::std::os::raw::c_ushort,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_info__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_info__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(snd_ctl_elem_info__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_info__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_ctl_elem_info__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_2>())).d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_2),
            "::",
            stringify!(d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_info__bindgen_ty_2>())).d_ptr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info__bindgen_ty_2),
            "::",
            stringify!(d_ptr)
        )
    );
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_info() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_info>(),
        272usize,
        concat!("Size of: ", stringify!(snd_ctl_elem_info))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_info>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_ctl_elem_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).type_ as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).access as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(access)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).count as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).owner as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).value as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).dimen as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(dimen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_info>())).reserved as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_info),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_elem_value {
    pub id: snd_ctl_elem_id,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub value: snd_ctl_elem_value__bindgen_ty_1,
    pub tstamp: timespec,
    pub reserved: [::std::os::raw::c_uchar; 112usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_elem_value__bindgen_ty_1 {
    pub integer: snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1,
    pub integer64: snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2,
    pub enumerated: snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3,
    pub bytes: snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4,
    pub iec958: snd_aes_iec958,
    _bindgen_union_align: [u64; 128usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1 {
    pub value: [::std::os::raw::c_long; 128usize],
    pub value_ptr: *mut ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 128usize],
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1>(),
        1024usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1>())).value_ptr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(value_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2 {
    pub value: [::std::os::raw::c_longlong; 64usize],
    pub value_ptr: *mut ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 64usize],
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2>(),
        512usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2>())).value_ptr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(value_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3 {
    pub item: [::std::os::raw::c_uint; 128usize],
    pub item_ptr: *mut ::std::os::raw::c_uint,
    _bindgen_union_align: [u64; 64usize],
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3>(),
        512usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3>())).item
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(item)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3>())).item_ptr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(item_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4 {
    pub data: [::std::os::raw::c_uchar; 512usize],
    pub data_ptr: *mut ::std::os::raw::c_uchar,
    _bindgen_union_align: [u64; 64usize],
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4>(),
        512usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4>())).data
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4>())).data_ptr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(data_ptr)
        )
    );
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_value__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_value__bindgen_ty_1>(),
        1024usize,
        concat!("Size of: ", stringify!(snd_ctl_elem_value__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_value__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1>())).integer as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1),
            "::",
            stringify!(integer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1>())).integer64 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1),
            "::",
            stringify!(integer64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1>())).enumerated as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1),
            "::",
            stringify!(enumerated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1>())).bytes as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1),
            "::",
            stringify!(bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_elem_value__bindgen_ty_1>())).iec958 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value__bindgen_ty_1),
            "::",
            stringify!(iec958)
        )
    );
}
#[test]
fn bindgen_test_layout_snd_ctl_elem_value() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_elem_value>(),
        1224usize,
        concat!("Size of: ", stringify!(snd_ctl_elem_value))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_elem_value>(),
        8usize,
        concat!("Alignment of ", stringify!(snd_ctl_elem_value))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_value>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_value>())).value as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_value>())).tstamp as *const _ as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value),
            "::",
            stringify!(tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_elem_value>())).reserved as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_elem_value),
            "::",
            stringify!(reserved)
        )
    );
}
impl snd_ctl_elem_value {
    #[inline]
    pub fn indirect(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_indirect(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        indirect: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let indirect: u32 = unsafe { ::std::mem::transmute(indirect) };
            indirect as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct snd_ctl_tlv {
    pub numid: ::std::os::raw::c_uint,
    pub length: ::std::os::raw::c_uint,
    pub tlv: __IncompleteArrayField<::std::os::raw::c_uint>,
}
#[test]
fn bindgen_test_layout_snd_ctl_tlv() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_tlv>(),
        8usize,
        concat!("Size of: ", stringify!(snd_ctl_tlv))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_tlv>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_ctl_tlv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_tlv>())).numid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_tlv),
            "::",
            stringify!(numid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_tlv>())).length as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_tlv),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_tlv>())).tlv as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_tlv),
            "::",
            stringify!(tlv)
        )
    );
}
pub const sndrv_ctl_event_type_SNDRV_CTL_EVENT_ELEM: sndrv_ctl_event_type = 0;
pub const sndrv_ctl_event_type_SNDRV_CTL_EVENT_LAST: sndrv_ctl_event_type = 0;
pub type sndrv_ctl_event_type = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_event {
    pub type_: ::std::os::raw::c_int,
    pub data: snd_ctl_event__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_ctl_event__bindgen_ty_1 {
    pub elem: snd_ctl_event__bindgen_ty_1__bindgen_ty_1,
    pub data8: [::std::os::raw::c_uchar; 60usize],
    _bindgen_union_align: [u32; 17usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_ctl_event__bindgen_ty_1__bindgen_ty_1 {
    pub mask: ::std::os::raw::c_uint,
    pub id: snd_ctl_elem_id,
}
#[test]
fn bindgen_test_layout_snd_ctl_event__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_event__bindgen_ty_1__bindgen_ty_1>(),
        68usize,
        concat!(
            "Size of: ",
            stringify!(snd_ctl_event__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_event__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(snd_ctl_event__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_event__bindgen_ty_1__bindgen_ty_1>())).mask as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_event__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_event__bindgen_ty_1__bindgen_ty_1>())).id as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_event__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(id)
        )
    );
}
#[test]
fn bindgen_test_layout_snd_ctl_event__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_event__bindgen_ty_1>(),
        68usize,
        concat!("Size of: ", stringify!(snd_ctl_event__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_event__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_ctl_event__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_event__bindgen_ty_1>())).elem as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_event__bindgen_ty_1),
            "::",
            stringify!(elem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<snd_ctl_event__bindgen_ty_1>())).data8 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_event__bindgen_ty_1),
            "::",
            stringify!(data8)
        )
    );
}
#[test]
fn bindgen_test_layout_snd_ctl_event() {
    assert_eq!(
        ::std::mem::size_of::<snd_ctl_event>(),
        72usize,
        concat!("Size of: ", stringify!(snd_ctl_event))
    );
    assert_eq!(
        ::std::mem::align_of::<snd_ctl_event>(),
        4usize,
        concat!("Alignment of ", stringify!(snd_ctl_event))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_event>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_event),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<snd_ctl_event>())).data as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(snd_ctl_event),
            "::",
            stringify!(data)
        )
    );
}
