// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the configuration policies that the Security Hub delegated administrator
// has created for your organization. Only the delegated administrator can invoke
// this operation from the home Region.
func (c *Client) ListConfigurationPolicies(ctx context.Context, params *ListConfigurationPoliciesInput, optFns ...func(*Options)) (*ListConfigurationPoliciesOutput, error) {
	if params == nil {
		params = &ListConfigurationPoliciesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConfigurationPolicies", params, optFns, c.addOperationListConfigurationPoliciesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConfigurationPoliciesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConfigurationPoliciesInput struct {

	// The maximum number of results that's returned by ListConfigurationPolicies in
	// each page of the response. When this parameter is used,
	// ListConfigurationPolicies returns the specified number of results in a single
	// page and a NextToken response element. You can see the remaining results of the
	// initial request by sending another ListConfigurationPolicies request with the
	// returned NextToken value. A valid range for MaxResults is between 1 and 100.
	MaxResults *int32

	// The NextToken value that's returned from a previous paginated
	// ListConfigurationPolicies request where MaxResults was used but the results
	// exceeded the value of that parameter. Pagination continues from the MaxResults
	// was used but the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous response that returned the NextToken
	// value. This value is null when there are no more results to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListConfigurationPoliciesOutput struct {

	// Provides metadata for each of your configuration policies.
	ConfigurationPolicySummaries []types.ConfigurationPolicySummary

	// The NextToken value to include in the next ListConfigurationPolicies request.
	// When the results of a ListConfigurationPolicies request exceed MaxResults , this
	// value can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConfigurationPoliciesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListConfigurationPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListConfigurationPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConfigurationPolicies"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConfigurationPolicies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListConfigurationPoliciesAPIClient is a client that implements the
// ListConfigurationPolicies operation.
type ListConfigurationPoliciesAPIClient interface {
	ListConfigurationPolicies(context.Context, *ListConfigurationPoliciesInput, ...func(*Options)) (*ListConfigurationPoliciesOutput, error)
}

var _ ListConfigurationPoliciesAPIClient = (*Client)(nil)

// ListConfigurationPoliciesPaginatorOptions is the paginator options for
// ListConfigurationPolicies
type ListConfigurationPoliciesPaginatorOptions struct {
	// The maximum number of results that's returned by ListConfigurationPolicies in
	// each page of the response. When this parameter is used,
	// ListConfigurationPolicies returns the specified number of results in a single
	// page and a NextToken response element. You can see the remaining results of the
	// initial request by sending another ListConfigurationPolicies request with the
	// returned NextToken value. A valid range for MaxResults is between 1 and 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConfigurationPoliciesPaginator is a paginator for ListConfigurationPolicies
type ListConfigurationPoliciesPaginator struct {
	options   ListConfigurationPoliciesPaginatorOptions
	client    ListConfigurationPoliciesAPIClient
	params    *ListConfigurationPoliciesInput
	nextToken *string
	firstPage bool
}

// NewListConfigurationPoliciesPaginator returns a new
// ListConfigurationPoliciesPaginator
func NewListConfigurationPoliciesPaginator(client ListConfigurationPoliciesAPIClient, params *ListConfigurationPoliciesInput, optFns ...func(*ListConfigurationPoliciesPaginatorOptions)) *ListConfigurationPoliciesPaginator {
	if params == nil {
		params = &ListConfigurationPoliciesInput{}
	}

	options := ListConfigurationPoliciesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConfigurationPoliciesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConfigurationPoliciesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConfigurationPolicies page.
func (p *ListConfigurationPoliciesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConfigurationPoliciesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListConfigurationPolicies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListConfigurationPolicies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConfigurationPolicies",
	}
}
