// ************************************************************************** //
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Wrap/Swig/libBornAgainSample.i
//! @brief     SWIG interface file for libBornAgainSample
//!
//!            Configuration is done in Sample/CMakeLists.txt
//!
//! @homepage  http://apps.jcns.fz-juelich.de/BornAgain
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2013
//! @authors   Scientific Computing Group at MLZ Garching
//
// ************************************************************************** //

%module(directors="1", moduleimport="import $module") "libBornAgainSample"

%include "commons.i"

%include "ignoreSample.i"

%feature("director") ISampleNode;    // needed by IReParticle
%feature("director") IReParticle;    // needed by ReParticle etc ?
%feature("director") IFormfactor;    // used in CustomFormfactor.py

%{
#include "Base/Axis/Frame.h"
#include "Base/Type/Span.h"
#include "Base/Vector/RotMatrix.h"
#include "Param/Distrib/ParameterDistribution.h"
#include "Sample/Aggregate/Interference1DLattice.h"
#include "Sample/Aggregate/Interference2DLattice.h"
#include "Sample/Aggregate/Interference2DParacrystal.h"
#include "Sample/Aggregate/Interference2DSuperLattice.h"
#include "Sample/Aggregate/InterferenceFinite2DLattice.h"
#include "Sample/Aggregate/InterferenceHardDisk.h"
#include "Sample/Aggregate/InterferenceNone.h"
#include "Sample/Aggregate/InterferenceRadialParacrystal.h"
#include "Sample/Aggregate/ParticleLayout.h"
#include "Sample/Correlation/IPeakShape.h"
#include "Sample/HardParticle/HardParticles.h"
#include "Sample/Lattice/Lattice3D.h"
#include "Sample/Lattice/BakeLattice.h"
#include "Sample/Lattice/ISelectionRule.h"
#include "Sample/Material/MaterialFactoryFuncs.h"
#include "Sample/Material/RefractiveMaterialImpl.h"
#include "Sample/Material/MaterialBySLDImpl.h"
#include "Sample/Multilayer/Layer.h"
#include "Sample/Multilayer/MultiLayer.h"
#include "Sample/Particle/Crystal.h"
#include "Sample/Particle/Mesocrystal.h"
#include "Sample/Particle/Particle.h"
#include "Sample/Particle/Compound.h"
#include "Sample/Particle/CoreAndShell.h"
#include "Sample/Interface/LayerInterface.h"
#include "Sample/Interface/LayerRoughness.h"
#include "Sample/Interface/RoughnessMap.h"
#include "Sample/Scattering/Rotations.h"
#include "Sample/SoftParticle/SoftParticles.h"
%}

%include "fromBase.i"
%include "fromParam.i"

%template(swig_dummy_type_const_inode_vector) std::vector<const INode*>;

%include "Sample/Material/Material.h"
%include "Sample/Material/MaterialFactoryFuncs.h"
%include "Sample/Material/IMaterialImpl.h"
%include "Sample/Material/RefractiveMaterialImpl.h"
%include "Sample/Material/MaterialBySLDImpl.h"

%include "Sample/Scattering/ISampleNode.h"
%include "Sample/Particle/IFormfactor.h"
%include "Sample/Scattering/Rotations.h"

%include "Sample/Particle/Crystal.h"
%include "Sample/Particle/IParticle.h"
%include "Sample/Particle/Mesocrystal.h"
%include "Sample/Particle/Particle.h"
%include "Sample/Particle/Compound.h"
%include "Sample/Particle/CoreAndShell.h"

%include "Sample/Correlation/Profiles1D.h"
%include "Sample/Correlation/Profiles2D.h"
%include "Sample/Correlation/IPeakShape.h"

%include "Sample/Aggregate/IInterference.h"
%include "Sample/Aggregate/Interference1DLattice.h"
%include "Sample/Aggregate/Interference2DLattice.h"
%include "Sample/Aggregate/Interference2DParacrystal.h"
%include "Sample/Aggregate/Interference2DSuperLattice.h"
%include "Sample/Aggregate/InterferenceFinite2DLattice.h"
%include "Sample/Aggregate/InterferenceHardDisk.h"
%include "Sample/Aggregate/InterferenceNone.h"
%include "Sample/Aggregate/InterferenceRadialParacrystal.h"
%include "Sample/Aggregate/ParticleLayout.h"

%include "Sample/Interface/LayerRoughness.h"
%include "Sample/Interface/RoughnessMap.h"

%include "Sample/Multilayer/Layer.h"
%include "Sample/Multilayer/MultiLayer.h"

%include "Sample/Interface/RoughnessModels.h"

%include "Sample/HardParticle/IFormfactorPolyhedron.h"
%include "Sample/HardParticle/IFormfactorPrism.h"
%include "Sample/HardParticle/IProfileRipple.h"

%include "Sample/HardParticle/Polyhedra.h"

%include "Sample/HardParticle/Cone.h"
%include "Sample/HardParticle/Cylinder.h"
%include "Sample/HardParticle/EllipsoidalCylinder.h"
%include "Sample/HardParticle/HemiEllipsoid.h"
%include "Sample/HardParticle/HorizontalCylinder.h"
%include "Sample/HardParticle/Sphere.h"
%include "Sample/HardParticle/Spheroid.h"
%include "Sample/HardParticle/TruncatedSphere.h"
%include "Sample/HardParticle/TruncatedSpheroid.h"

%include "Sample/HardParticle/Bar.h"
%include "Sample/HardParticle/CosineRipple.h"
%include "Sample/HardParticle/SawtoothRipple.h"

%include "Sample/HardParticle/LongBoxGauss.h"
%include "Sample/HardParticle/LongBoxLorentz.h"

%include "Sample/SoftParticle/Gauss.h"
%include "Sample/SoftParticle/FuzzySphere.h"

%include "Sample/Lattice/ISelectionRule.h"
%include "Sample/Lattice/Lattice3D.h"
%include "Sample/Lattice/Lattice2D.h"
%include "Sample/Lattice/BakeLattice.h"
