//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Sample/SampleForm.h
//! @brief     Defines class SampleForm.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLE_SAMPLEFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLE_SAMPLEFORM_H

#include <QPushButton>
#include <QWidget>

class HeinzFormLayout;
class LayerForm;
class LayerItem;
class QVBoxLayout;
class SampleEditorController;
class SampleItem;

//! Form to present/edit a sample
class SampleForm : public QWidget {
    Q_OBJECT
public:
    SampleForm(SampleItem* sampleItem, SampleEditorController* ec);

    //! Create widgets for the new layer.
    void onLayerAdded(LayerItem* layerItem);

    //! Call this when a layerItem has been moved to a different position.
    //!
    //! This updates the item's position in the layout.
    void onLayerMoved(LayerItem* layerItem);

    //! Call this before removing (deleting) a LayerItem.
    //!
    //! Any widgets related to the item will be deleted or scheduled for later deletion.
    void onAboutToRemoveLayer(LayerItem* layerItem);

    void updateRowVisibilities();

    //! Search for the next LayerForm, starting from the given widget.
    //!
    //! The search starts with the given widget itself If it is a LayerForm, it is returned.
    //! If no following LayerForm is found, nullptr is returned.
    LayerForm* findNextLayerForm(QWidget* w);

private:
    QVBoxLayout* m_layout;
    SampleItem* m_sample_item;    //!< Ptr is borrowed, don't delete
    SampleEditorController* m_ec; //!< Ptr is borrowed, don't delete
    QVector<QPushButton*> m_add_layer_buttons;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLE_SAMPLEFORM_H
