//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Axis/BasicAxisItem.h
//! @brief     Defines various axis items.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_AXIS_BASICAXISITEM_H
#define BORNAGAIN_GUI_MODEL_AXIS_BASICAXISITEM_H

#include <QObject>
#include <QXmlStreamReader>

class Scale;

class BasicAxisItem : public QObject {
    Q_OBJECT
public:
    explicit BasicAxisItem(QObject* parent = nullptr);
    ~BasicAxisItem() override;

    virtual void writeTo(QXmlStreamWriter* w) const;
    virtual void readFrom(QXmlStreamReader* r);

public:
    Scale makeScale(std::string name) const;

    size_t size() const { return m_nbins; }
    void resize(size_t value);

    double min() const { return m_min; }
    void setMin(double value);

    double max() const { return m_max; }
    void setMax(double value);

signals:
    void axisRangeChanged();
    void axisTitleChanged();

private:
    int m_nbins;
    double m_min; // in display units (if angle, then deg)
    double m_max;
};

#endif // BORNAGAIN_GUI_MODEL_AXIS_BASICAXISITEM_H
