systemd_unit_directives = [
    "Description",
    "Documentation",
    "Wants",
    "Requires",
    "Requisite",
    "BindsTo",
    "PartOf",
    "Upholds",
    "Conflicts",
    "Before",
    "After",
    "OnFailure",
    "OnSuccess",
    "PropagatesReloadTo",
    "ReloadPropagatedFrom",
    "PropagatesStopTo",
    "StopPropagatedFrom",
    "JoinsNamespaceOf",
    "RequiresMountsFor",
    "WantsMountsFor",
    "OnSuccessJobMode",
    "OnFailureJobMode",
    "IgnoreOnIsolate",
    "StopWhenUnneeded",
    "RefuseManualStart",
    "RefuseManualStop",
    "AllowIsolate",
    "DefaultDependencies",
    "SurviveFinalKillSignal",
    "CollectMode",
    "FailureAction",
    "SuccessAction",
    "FailureActionExitStatus",
    "SuccessActionExitStatus",
    "JobTimeoutSec",
    "JobRunningTimeoutSec",
    "JobTimeoutAction",
    "JobTimeoutRebootArgument",
    "StartLimitIntervalSec",
    "StartLimitBurst",
    "StartLimitAction",
    "RebootArgument",
    "SourcePath",
    "ConditionArchitecture",
    "ConditionFirmware",
    "ConditionVirtualization",
    "ConditionHost",
    "ConditionKernelCommandLine",
    "ConditionKernelVersion",
    "ConditionCredential",
    "ConditionEnvironment",
    "ConditionSecurity",
    "ConditionCapability",
    "ConditionACPower",
    "ConditionNeedsUpdate",
    "ConditionFirstBoot",
    "ConditionPathExists",
    "ConditionPathExistsGlob",
    "ConditionPathIsDirectory",
    "ConditionPathIsSymbolicLink",
    "ConditionPathIsMountPoint",
    "ConditionPathIsReadWrite",
    "ConditionPathIsEncrypted",
    "ConditionDirectoryNotEmpty",
    "ConditionFileNotEmpty",
    "ConditionFileIsExecutable",
    "ConditionUser",
    "ConditionGroup",
    "ConditionControlGroupController",
    "ConditionMemory",
    "ConditionCPUs",
    "ConditionCPUFeature",
    "ConditionOSRelease",
    "ConditionMemoryPressure",
    "ConditionCPUPressure",
    "ConditionIOPressure",
    "AssertArchitecture",
    "AssertVirtualization",
    "AssertHost",
    "AssertKernelCommandLine",
    "AssertKernelVersion",
    "AssertCredential",
    "AssertEnvironment",
    "AssertSecurity",
    "AssertCapability",
    "AssertACPower",
    "AssertNeedsUpdate",
    "AssertFirstBoot",
    "AssertPathExists",
    "AssertPathExistsGlob",
    "AssertPathIsDirectory",
    "AssertPathIsSymbolicLink",
    "AssertPathIsMountPoint",
    "AssertPathIsReadWrite",
    "AssertPathIsEncrypted",
    "AssertDirectoryNotEmpty",
    "AssertFileNotEmpty",
    "AssertFileIsExecutable",
    "AssertUser",
    "AssertGroup",
    "AssertControlGroupController",
    "AssertMemory",
    "AssertCPUs",
    "AssertCPUFeature",
    "AssertOSRelease",
    "AssertMemoryPressure",
    "AssertCPUPressure",
    "AssertIOPressure",
]

systemd_install_directives = [
    "Alias",
    "WantedBy",
    "RequiredBy",
    "UpheldBy",
    "Also",
    "DefaultInstance",
]

systemd_service_directives = [
    "Type",
    "ExitType",
    "RemainAfterExit",
    "GuessMainPID",
    "PIDFile",
    "BusName",
    "ExecStart",
    "ExecStartPre",
    "ExecStartPost",
    "ExecCondition",
    "ExecReload",
    "ExecStop",
    "ExecStopPost",
    "RestartSec",
    "RestartSteps",
    "RestartMaxDelaySec",
    "TimeoutStartSec",
    "TimeoutStopSec",
    "TimeoutAbortSec",
    "TimeoutSec",
    "TimeoutStartFailureMode",
    "TimeoutStopFailureMode",
    "RuntimeMaxSec",
    "RuntimeRandomizedExtraSec",
    "WatchdogSec",
    "Restart",
    "RestartMode",
    "SuccessExitStatus",
    "RestartPreventExitStatus",
    "RestartForceExitStatus",
    "RootDirectoryStartOnly",
    "NonBlocking",
    "NotifyAccess",
    "Sockets",
    "FileDescriptorStoreMax",
    "FileDescriptorStorePreserve",
    "USBFunctionDescriptors",
    "USBFunctionStrings",
    "OOMPolicy",
    "OpenFile",
    "ReloadSignal",
]

systemd_socket_directives = [
    "ListenStream",
    "ListenDatagram",
    "ListenSequentialPacket",
    "ListenFIFO",
    "ListenSpecial",
    "ListenNetlink",
    "ListenMessageQueue",
    "ListenUSBFunction",
    "SocketProtocol",
    "BindIPv6Only",
    "Backlog",
    "BindToDevice",
    "SocketUser",
    "SocketGroup",
    "SocketMode",
    "DirectoryMode",
    "Accept",
    "Writable",
    "FlushPending",
    "MaxConnections",
    "MaxConnectionsPerSource",
    "KeepAlive",
    "KeepAliveTimeSec",
    "KeepAliveIntervalSec",
    "KeepAliveProbes",
    "NoDelay",
    "Priority",
    "DeferAcceptSec",
    "ReceiveBuffer",
    "SendBuffer",
    "IPTOS",
    "IPTTL",
    "Mark",
    "ReusePort",
    "SmackLabel",
    "SmackLabelIPIn",
    "SmackLabelIPOut",
    "SELinuxContextFromNet",
    "PipeSize",
    "MessageQueueMaxMessages",
    "MessageQueueMessageSize",
    "FreeBind",
    "Transparent",
    "Broadcast",
    "PassCredentials",
    "PassSecurity",
    "PassPacketInfo",
    "Timestamping",
    "TCPCongestion",
    "ExecStartPre",
    "ExecStartPost",
    "ExecStopPre",
    "ExecStopPost",
    "TimeoutSec",
    "Service",
    "RemoveOnStop",
    "Symlinks",
    "FileDescriptorName",
    "TriggerLimitIntervalSec",
    "TriggerLimitBurst",
    "PollLimitIntervalSec",
    "PollLimitBurst",
]

systemd_mount_directives = [
    "What",
    "Where",
    "Type",
    "Options",
    "SloppyOptions",
    "LazyUnmount",
    "ReadWriteOnly",
    "ForceUnmount",
    "DirectoryMode",
    "TimeoutSec",
]

systemd_automount_directives = [
    "Where",
    "ExtraOptions",
    "DirectoryMode",
    "TimeoutIdleSec",
]


systemd_timer_directives = [
    "OnActiveSec",
    "OnBootSec",
    "OnStartupSec",
    "OnUnitActiveSec",
    "OnUnitInactiveSec",
    "OnCalendar",
    "AccuracySec",
    "RandomizedDelaySec",
    "FixedRandomDelay",
    "OnClockChange",
    "OnTimezoneChange",
    "Unit",
    "Persistent",
    "WakeSystem",
    "RemainAfterElapse",
]

systemd_scope_directives = [
    "RuntimeMaxSec",
    "RuntimeRandomizedExtraSec",
]

systemd_swap_directives = [
    "What",
    "Priority",
    "Options",
    "TimeoutSec",
]

systemd_path_directives = [
    "PathExists",
    "PathExistsGlob",
    "PathChanged",
    "PathModified",
    "DirectoryNotEmpty",
    "Unit",
    "MakeDirectory",
    "DirectoryMode",
    "TriggerLimitIntervalSec",
    "TriggerLimitBurst",
]

# from systemd.exec(5)
systemd_exec_directives = [
    "ExecSearchPath",
    "WorkingDirectory",
    "RootDirectory",
    "RootImage",
    "RootImageOptions",
    "RootEphemeral",
    "RootHash",
    "RootHashSignature",
    "RootVerity",
    "RootImagePolicy",
    "MountImagePolicy",
    "ExtensionImagePolicy",
    "MountAPIVFS",
    "ProtectProc",
    "ProcSubset",
    "BindPaths",
    "BindReadOnlyPaths",
    "MountImages",
    "ExtensionImages",
    "ExtensionDirectories",
    "User",
    "Group",
    "DynamicUser",
    "SupplementaryGroups",
    "SetLoginEnvironment",
    "PAMName",
    "CapabilityBoundingSet",
    "AmbientCapabilities",
    "NoNewPrivileges",
    "SecureBits",
    "SELinuxContext",
    "AppArmorProfile",
    "SmackProcessLabel",
    "LimitCPU",
    "LimitFSIZE",
    "LimitDATA",
    "LimitSTACK",
    "LimitCORE",
    "LimitRSS",
    "LimitNOFILE",
    "LimitAS",
    "LimitNPROC",
    "LimitMEMLOCK",
    "LimitLOCKS",
    "LimitSIGPENDING",
    "LimitMSGQUEUE",
    "LimitNICE",
    "LimitRTPRIO",
    "LimitRTTIME",
    "UMask",
    "CoredumpFilter",
    "KeyringMode",
    "OOMScoreAdjust",
    "TimerSlackNSec",
    "Personality",
    "IgnoreSIGPIPE",
    "Nice",
    "CPUSchedulingPolicy",
    "CPUSchedulingPriority",
    "CPUSchedulingResetOnFork",
    "CPUAffinity",
    "NUMAPolicy",
    "NUMAMask",
    "IOSchedulingClass",
    "IOSchedulingPriority",
    "ProtectSystem",
    "ProtectHome",
    "RuntimeDirectory",
    "StateDirectory",
    "CacheDirectory",
    "LogsDirectory",
    "ConfigurationDirectory",
    "RuntimeDirectoryMode",
    "StateDirectoryMode",
    "CacheDirectoryMode",
    "LogsDirectoryMode",
    "ConfigurationDirectoryMode",
    "RuntimeDirectoryPreserve",
    "TimeoutCleanSec",
    "ReadWritePaths",
    "ReadOnlyPaths",
    "InaccessiblePaths",
    "ExecPaths",
    "NoExecPaths",
    "TemporaryFileSystem",
    "PrivateTmp",
    "PrivateDevices",
    "PrivateNetwork",
    "NetworkNamespacePath",
    "PrivateIPC",
    "IPCNamespacePath",
    "MemoryKSM",
    "PrivateUsers",
    "ProtectHostname",
    "ProtectClock",
    "ProtectKernelTunables",
    "ProtectKernelModules",
    "ProtectKernelLogs",
    "ProtectControlGroups",
    "RestrictAddressFamilies",
    "RestrictFileSystems",
    "RestrictNamespaces",
    "LockPersonality",
    "MemoryDenyWriteExecute",
    "RestrictRealtime",
    "RestrictSUIDSGID",
    "RemoveIPC",
    "PrivateMounts",
    "MountFlags",
    "SystemCallFilter",
    "SystemCallErrorNumber",
    "SystemCallArchitectures",
    "SystemCallLog",
    "Environment",
    "EnvironmentFile",
    "PassEnvironment",
    "UnsetEnvironment",
    "StandardInput",
    "StandardOutput",
    "StandardError",
    "StandardInputText",
    "StandardInputData",
    "LogLevelMax",
    "LogExtraFields",
    "LogRateLimitIntervalSec",
    "LogRateLimitBurst",
    "LogFilterPatterns",
    "LogNamespace",
    "SyslogIdentifier",
    "SyslogFacility",
    "SyslogLevel",
    "SyslogLevelPrefix",
    "TTYPath",
    "TTYReset",
    "TTYVHangup",
    "TTYRows",
    "TTYColumns",
    "TTYVTDisallocate",
    "LoadCredential",
    "LoadCredentialEncrypted",
    "ImportCredential",
    "SetCredential",
    "SetCredentialEncrypted",
    "UtmpIdentifier",
    "UtmpMode",
]

systemd_kill_directives = [
    "KillMode",
    "KillSignal",
    "RestartKillSignal",
    "SendSIGHUP",
    "SendSIGKILL",
    "FinalKillSignal",
    "WatchdogSignal",
]
