"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderRect = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var canvas_1 = require("../../../../../renderers/canvas");
var common_1 = require("../../../../../utils/common");
function renderRect(ctx, rect, fill, stroke, disableBoardOffset) {
    if (disableBoardOffset === void 0) { disableBoardOffset = false; }
    if (!fill && !stroke) {
        return;
    }
    if (fill) {
        var borderOffset = !disableBoardOffset && stroke && stroke.width > 0.001 ? stroke.width : 0;
        var x_1 = rect.x + borderOffset;
        var y_1 = rect.y + borderOffset;
        var width_1 = rect.width - borderOffset * 2;
        var height_1 = rect.height - borderOffset * 2;
        drawRect(ctx, { x: x_1, y: y_1, width: width_1, height: height_1 });
        ctx.fillStyle = color_library_wrappers_1.RGBtoString(fill.color);
        ctx.fill();
        if (fill.texture) {
            var texture_1 = fill.texture;
            canvas_1.withContext(ctx, function (ctx) {
                var _a, _b, _c, _d, _e;
                drawRect(ctx, { x: x_1, y: y_1, width: width_1, height: height_1 });
                ctx.clip();
                var rotation = common_1.getRadians((_a = texture_1.rotation) !== null && _a !== void 0 ? _a : 0);
                var offset = texture_1.offset;
                if (offset && offset.global)
                    ctx.translate((_b = offset === null || offset === void 0 ? void 0 : offset.x) !== null && _b !== void 0 ? _b : 0, (_c = offset === null || offset === void 0 ? void 0 : offset.y) !== null && _c !== void 0 ? _c : 0);
                if (rotation)
                    ctx.rotate(rotation);
                if (offset && !offset.global)
                    ctx.translate((_d = offset === null || offset === void 0 ? void 0 : offset.x) !== null && _d !== void 0 ? _d : 0, (_e = offset === null || offset === void 0 ? void 0 : offset.y) !== null && _e !== void 0 ? _e : 0);
                ctx.fillStyle = texture_1.pattern;
                var rotationRectFillSize = ctx.canvas.clientWidth * ctx.canvas.clientHeight;
                ctx.translate(-rotationRectFillSize / 2, -rotationRectFillSize / 2);
                ctx.fillRect(0, 0, rotationRectFillSize, rotationRectFillSize);
            });
        }
    }
    if (stroke && stroke.width > 0.001) {
        var borderOffset = !disableBoardOffset && stroke && stroke.width > 0.001 ? stroke.width / 2 : 0;
        var x = rect.x + borderOffset;
        var y = rect.y + borderOffset;
        var width = rect.width - borderOffset * 2;
        var height = rect.height - borderOffset * 2;
        ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
        ctx.lineWidth = stroke.width;
        drawRect(ctx, { x: x, y: y, width: width, height: height });
        if (stroke.dash) {
            ctx.setLineDash(stroke.dash);
        }
        else {
            ctx.lineCap = 'square';
        }
        ctx.stroke();
    }
}
exports.renderRect = renderRect;
function drawRect(ctx, rect) {
    var x = rect.x, y = rect.y, width = rect.width, height = rect.height;
    ctx.beginPath();
    ctx.moveTo(x, y);
    ctx.lineTo(x + width, y);
    ctx.lineTo(x + width, y + height);
    ctx.lineTo(x, y + height);
    ctx.lineTo(x, y);
}
//# sourceMappingURL=rect.js.map