// !!! This is a file automatically generated by hipify!!!
#pragma once
#include <hip/hip_runtime.h>
#define NVML_NO_UNVERSIONED_FUNC_DEFS
#include <rocm_smi/rocm_smi.h>

#include <c10/util/Exception.h>

#define C10_HIP_DRIVER_CHECK(EXPR)                                        \
  do {                                                                     \
    hipError_t __err = EXPR;                                                 \
    if (__err != hipSuccess) {                                           \
      const char* err_str;                                                 \
      hipError_t get_error_str_err [[maybe_unused]] =                        \
          c10::hip::DriverAPI::get()->hipDrvGetErrorString_(__err, &err_str); \
      if (get_error_str_err != hipSuccess) {                             \
        TORCH_CHECK(false, "HIP driver error: unknown error");            \
      } else {                                                             \
        TORCH_CHECK(false, "HIP driver error: ", err_str);                \
      }                                                                    \
    }                                                                      \
  } while (0)

// The integer in the second column specifies the requested HIP Driver API
// version. The dynamic loader will accept a driver with a newer version, but it
// ensures that the requested symbol exists in *at least* the specified version
// or earlier.

// Keep these requested versions as low as possible to maximize compatibility
// across different driver versions.

// Why do we pin to an older version instead of using the latest?
// If a user installs a newer driver, blindly resolving the symbol may bind to a
// newer version of the function with different behavior, potentially breaking
// PyTorch.

#define C10_LIBHIP_DRIVER_API_REQUIRED(_) \
  _(hipDeviceGetAttribute, 12000)           \
  _(cuMemAddressReserve, 12000)            \
  _(cuMemRelease, 12000)                   \
  _(cuMemMap, 12000)                       \
  _(cuMemAddressFree, 12000)               \
  _(cuMemSetAccess, 12000)                 \
  _(cuMemUnmap, 12000)                     \
  _(cuMemCreate, 12000)                    \
  _(cuMemGetAllocationGranularity, 12000)  \
  _(cuMemExportToShareableHandle, 12000)   \
  _(cuMemImportFromShareableHandle, 12000) \
  _(hipMemsetAsync, 12000)               \
  _(hipStreamWriteValue32, 12000)           \
  _(hipDrvGetErrorString, 12000)

#if defined(TORCH_HIP_VERSION) && (TORCH_HIP_VERSION >= 12030)
#define C10_LIBHIP_DRIVER_API_OPTIONAL(_) \
  _(cuMulticastAddDevice, 12030)           \
  _(cuMulticastBindMem, 12030)             \
  _(cuMulticastCreate, 12030)
#else
#define C10_LIBHIP_DRIVER_API_OPTIONAL(_)
#endif

#define C10_NVML_DRIVER_API(_)            \
  _(nvmlInit_v2)                          \
  _(nvmlDeviceGetHandleByPciBusId_v2)     \
  _(nvmlDeviceGetNvLinkRemoteDeviceType)  \
  _(nvmlDeviceGetNvLinkRemotePciInfo_v2)  \
  _(nvmlDeviceGetComputeRunningProcesses) \
  _(nvmlSystemGetHipDriverVersion_v2)

namespace c10::hip {

struct DriverAPI {
#define CREATE_MEMBER_VERSIONED(name, version) decltype(&name) name##_;
#define CREATE_MEMBER(name) decltype(&name) name##_;
  C10_LIBHIP_DRIVER_API_REQUIRED(CREATE_MEMBER_VERSIONED)
  C10_LIBHIP_DRIVER_API_OPTIONAL(CREATE_MEMBER_VERSIONED)
  C10_NVML_DRIVER_API(CREATE_MEMBER)
#undef CREATE_MEMBER_VERSIONED
#undef CREATE_MEMBER

  static DriverAPI* get();
  static void* get_nvml_handle();
};

} // namespace c10::hip
