/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0086\u0002J%\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011H\u0082\bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\rH\u0086\u0002J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Landroidx/compose/runtime/BitVector;", "", "()V", "first", "", "others", "", "second", "size", "", "getSize", "()I", "get", "", "index", "nextBit", "valueSelector", "Lkotlin/Function1;", "nextClear", "nextSet", "set", "", "value", "setRange", "start", "end", "toString", "", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/BitVector\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n*L\n1#1,3963:1\n3500#1,5:3967\n3505#1,27:3973\n3500#1,5:4000\n3505#1,27:4006\n3810#2:3964\n3810#2:3965\n3810#2:3966\n3580#2:3972\n3580#2:4005\n3580#2:4033\n3580#2:4034\n3580#2:4035\n3810#2:4036\n3810#2:4037\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/BitVector\n*L\n3490#1:3967,5\n3490#1:3973,27\n3492#1:4000,5\n3492#1:4006,27\n3467#1:3964\n3473#1:3965\n3487#1:3966\n3490#1:3972\n3492#1:4005\n3504#1:4033\n3510#1:4034\n3527#1:4035\n3544#1:4036\n3555#1:4037\n*E\n"})
public final class BitVector {
    private long first;
    private long second;
    @NotNull
    private long[] others = SlotTableKt.access$getEmptyLongArray$p();
    public static final int $stable = 8;

    public final int getSize() {
        return (this.others.length + 2) * 64;
    }

    public final boolean get(int index2) {
        if (index2 < 64) {
            return (this.first & 1L << index2) != 0L;
        }
        if (index2 < 128) {
            return (this.second & 1L << index2 - 64) != 0L;
        }
        long[] others = this.others;
        int size2 = others.length;
        if (size2 == 0) {
            return false;
        }
        int address = index2 / 64 - 2;
        if (address >= size2) {
            return false;
        }
        int bit = index2 % 64;
        return (others[address] & 1L << bit) != 0L;
    }

    public final void set(int index2, boolean value) {
        if (index2 < 64) {
            long mask = 1L << index2;
            boolean $this$toBit$iv = value;
            boolean $i$f$toBit = false;
            this.first = this.first & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)($this$toBit$iv ? 1 : 0) << index2;
            return;
        }
        if (index2 < 128) {
            long mask = 1L << index2 - 64;
            boolean $this$toBit$iv = value;
            boolean $i$f$toBit = false;
            this.second = this.second & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)($this$toBit$iv ? 1 : 0) << index2;
            return;
        }
        int address = index2 / 64 - 2;
        int newIndex = index2 % 64;
        long mask = 1L << newIndex;
        long[] others = this.others;
        if (address >= others.length) {
            long[] lArray = Arrays.copyOf(others, address + 1);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            this.others = others = lArray;
        }
        long bits = others[address];
        boolean $this$toBit$iv = value;
        boolean $i$f$toBit = false;
        others[address] = bits & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)($this$toBit$iv ? 1 : 0) << newIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int nextSet(int index2) {
        int index$iv;
        int n;
        boolean bl;
        long it;
        BitVector this_$iv = this;
        boolean $i$f$nextBit = false;
        if (index2 < 64) {
            it = this_$iv.first;
            bl = false;
            long $this$firstBitSet$iv$iv = it >>> index2 << index2;
            boolean $i$f$getFirstBitSet = false;
            int bit$iv = Long.numberOfTrailingZeros($this$firstBitSet$iv$iv);
            if (bit$iv < 64) {
                n = bit$iv;
                return n;
            }
        }
        if (index2 < 128) {
            index$iv = index2 - 64;
            it = this_$iv.second;
            bl = false;
            long $this$firstBitSet$iv$iv = it >>> index$iv << index$iv;
            boolean $i$f$getFirstBitSet = false;
            int bit$iv = Long.numberOfTrailingZeros($this$firstBitSet$iv$iv);
            if (bit$iv < 64) {
                n = 64 + bit$iv;
                return n;
            }
        }
        index$iv = Math.max(index2, 128);
        int start$iv = index$iv / 64 - 2;
        long[] others$iv = this_$iv.others;
        int i$iv = start$iv;
        int n2 = others$iv.length;
        while (i$iv < n2) {
            it = others$iv[i$iv];
            bl = false;
            long value$iv = it;
            if (i$iv == start$iv) {
                int shift$iv = index$iv % 64;
                value$iv = value$iv >>> shift$iv << shift$iv;
            }
            long $this$firstBitSet$iv$iv = value$iv;
            boolean $i$f$getFirstBitSet = false;
            int bit$iv = Long.numberOfTrailingZeros($this$firstBitSet$iv$iv);
            if (bit$iv < 64) {
                n = 128 + i$iv * 64 + bit$iv;
                return n;
            }
            ++i$iv;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int nextClear(int index2) {
        int index$iv;
        int n;
        boolean bl;
        long it;
        BitVector this_$iv = this;
        boolean $i$f$nextBit = false;
        if (index2 < 64) {
            it = this_$iv.first;
            bl = false;
            long $this$firstBitSet$iv$iv = (it ^ 0xFFFFFFFFFFFFFFFFL) >>> index2 << index2;
            boolean $i$f$getFirstBitSet = false;
            int bit$iv = Long.numberOfTrailingZeros($this$firstBitSet$iv$iv);
            if (bit$iv < 64) {
                n = bit$iv;
                return n;
            }
        }
        if (index2 < 128) {
            index$iv = index2 - 64;
            it = this_$iv.second;
            bl = false;
            long $this$firstBitSet$iv$iv = (it ^ 0xFFFFFFFFFFFFFFFFL) >>> index$iv << index$iv;
            boolean $i$f$getFirstBitSet = false;
            int bit$iv = Long.numberOfTrailingZeros($this$firstBitSet$iv$iv);
            if (bit$iv < 64) {
                n = 64 + bit$iv;
                return n;
            }
        }
        index$iv = Math.max(index2, 128);
        int start$iv = index$iv / 64 - 2;
        long[] others$iv = this_$iv.others;
        int i$iv = start$iv;
        int n2 = others$iv.length;
        while (i$iv < n2) {
            it = others$iv[i$iv];
            bl = false;
            long value$iv = it ^ 0xFFFFFFFFFFFFFFFFL;
            if (i$iv == start$iv) {
                int shift$iv = index$iv % 64;
                value$iv = value$iv >>> shift$iv << shift$iv;
            }
            long $this$firstBitSet$iv$iv = value$iv;
            boolean $i$f$getFirstBitSet = false;
            int bit$iv = Long.numberOfTrailingZeros($this$firstBitSet$iv$iv);
            if (bit$iv < 64) {
                n = 128 + i$iv * 64 + bit$iv;
                return n;
            }
            ++i$iv;
        }
        return Integer.MAX_VALUE;
    }

    private final int nextBit(int index2, Function1<? super Long, Long> valueSelector) {
        int index3;
        boolean $i$f$nextBit = false;
        if (index2 < 64) {
            long $this$firstBitSet$iv = ((Number)valueSelector.invoke((Object)this.first)).longValue() >>> index2 << index2;
            boolean $i$f$getFirstBitSet = false;
            int bit = Long.numberOfTrailingZeros($this$firstBitSet$iv);
            if (bit < 64) {
                return bit;
            }
        }
        if (index2 < 128) {
            index3 = index2 - 64;
            long $this$firstBitSet$iv = ((Number)valueSelector.invoke((Object)this.second)).longValue() >>> index3 << index3;
            boolean $i$f$getFirstBitSet = false;
            int bit = Long.numberOfTrailingZeros($this$firstBitSet$iv);
            if (bit < 64) {
                return 64 + bit;
            }
        }
        index3 = Math.max(index2, 128);
        int start = index3 / 64 - 2;
        long[] others = this.others;
        int n = others.length;
        for (int i = start; i < n; ++i) {
            long value = ((Number)valueSelector.invoke((Object)others[i])).longValue();
            if (i == start) {
                int shift = index3 % 64;
                value = value >>> shift << shift;
            }
            long $this$firstBitSet$iv = value;
            boolean $i$f$getFirstBitSet = false;
            int bit = Long.numberOfTrailingZeros($this$firstBitSet$iv);
            if (bit >= 64) continue;
            return 128 + i * 64 + bit;
        }
        return Integer.MAX_VALUE;
    }

    public final void setRange(int start, int end2) {
        int start2 = start;
        long bits = start2 < end2 ? -1L : 0L;
        boolean $this$toBit$iv = start2 < 64;
        boolean $i$f$toBit = false;
        long selector = bits * (long)($this$toBit$iv ? 1 : 0);
        long firstValue = selector >>> 64 - (Math.min(64, end2) - start2) << start2;
        this.first |= firstValue;
        if (end2 <= 64) {
            return;
        }
        start2 = Math.max(start2, 64);
        boolean $this$toBit$iv2 = start2 < 128;
        boolean $i$f$toBit2 = false;
        selector = bits * (long)($this$toBit$iv2 ? 1 : 0);
        long secondValue = selector >>> 128 - (Math.min(128, end2) - start2) << start2;
        this.second |= secondValue;
        if (end2 <= 128) {
            return;
        }
        start2 = Math.max(start2, 128);
        for (int bit = start2; bit < end2; ++bit) {
            this.set(bit, true);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean first = true;
        $this$toString_u24lambda_u242.append("BitVector [");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!first) {
                $this$toString_u24lambda_u242.append(", ");
            }
            first = false;
            $this$toString_u24lambda_u242.append(i);
        }
        $this$toString_u24lambda_u242.append(']');
        return stringBuilder.toString();
    }
}

