/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.search.profile.ProfileMetric;
import org.opensearch.search.profile.Timer;

@PublicApi(since="3.2.0")
public abstract class AbstractProfileBreakdown {
    protected final Map<String, ProfileMetric> metrics;

    public AbstractProfileBreakdown(Collection<Supplier<ProfileMetric>> metricSuppliers) {
        this.metrics = metricSuppliers.stream().map(Supplier::get).collect(Collectors.toMap(ProfileMetric::getName, metric -> metric));
    }

    public Timer getTimer(Enum<?> type) {
        ProfileMetric metric = this.metrics.get(type.toString());
        assert (metric instanceof Timer) : "Metric " + String.valueOf(type) + " is not a timer";
        return (Timer)metric;
    }

    public ProfileMetric getMetric(String name) {
        return this.metrics.get(name);
    }

    public Map<String, Long> toBreakdownMap() {
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        for (Map.Entry<String, ProfileMetric> entry : this.metrics.entrySet()) {
            map.putAll(entry.getValue().toBreakdownMap());
        }
        return Collections.unmodifiableMap(map);
    }

    public long toNodeTime() {
        long total = 0L;
        for (Map.Entry<String, ProfileMetric> entry : this.metrics.entrySet()) {
            ProfileMetric profileMetric = entry.getValue();
            if (!(profileMetric instanceof Timer)) continue;
            Timer t = (Timer)profileMetric;
            total += t.getApproximateTiming();
        }
        return total;
    }

    public Map<String, Object> toDebugMap() {
        return Collections.emptyMap();
    }
}

