/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Relabel the components in an image such that consecutive labels are
used.


RelabelComponentImageFilter remaps the labels associated with the objects in an image (as from
the output of ConnectedComponentImageFilter ) such that the label numbers are consecutive with no gaps between
the label numbers used. By default, the relabeling will also sort the
labels based on the size of the object: the largest object will have
label #1, the second largest will have label #2, etc. If two labels
have the same size their initial order is kept. The sorting by size
can be disabled using SetSortByObjectSize.

Label #0 is assumed to be the background and is left unaltered by the
relabeling.

RelabelComponentImageFilter is typically used on the output of the ConnectedComponentImageFilter for those applications that want to extract the largest object or the
"k" largest objects. Any particular object can be extracted from the
relabeled output using a BinaryThresholdImageFilter . A group of objects can be extracted from the relabeled output using
a ThresholdImageFilter .

Once all the objects are relabeled, the application can query the
number of objects and the size of each object. Object sizes are returned in a vector. The size of the background is not
calculated. So the size of object #1 is GetSizeOfObjectsInPixels() [0], the size of object #2 is GetSizeOfObjectsInPixels() [1], etc.

If user sets a minimum object size, all objects with fewer pixels than
the minimum will be discarded, so that the number of objects reported
will be only those remaining. The GetOriginalNumberOfObjects method
can be called to find out how many objects were present before the
small ones were discarded.

RelabelComponentImageFilter can be run as an "in place" filter, where it will overwrite its
output. The default is run out of place (or generate a separate
output). "In place" operation can be controlled via methods in the
superclass, InPlaceImageFilter::InPlaceOn() and InPlaceImageFilter::InPlaceOff().


See:
 ConnectedComponentImageFilter , BinaryThresholdImageFilter , ThresholdImageFilter

 itk::simple::RelabelComponent for the procedural interface

 itk::RelabelComponentImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRelabelComponentImageFilter.h
*/
public class RelabelComponentImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RelabelComponentImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RelabelComponentImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RelabelComponentImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RelabelComponentImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RelabelComponentImageFilter::~RelabelComponentImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RelabelComponentImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RelabelComponentImageFilter::RelabelComponentImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RelabelComponentImageFilter() {
    this(SimpleITKJNI.new_RelabelComponentImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RelabelComponentImageFilter::SetMinimumObjectSize(uint64_t MinimumObjectSize)

Set the minimum size in pixels for an object. All objects smaller than
this size will be discarded and will not appear in the output label
map. NumberOfObjects will count only the objects whose pixel counts
are greater than or equal to the minimum size. Call
GetOriginalNumberOfObjects to find out how many objects were present
in the original label map.

*/
public  void setMinimumObjectSize(java.math.BigInteger MinimumObjectSize) {
    SimpleITKJNI.RelabelComponentImageFilter_setMinimumObjectSize(swigCPtr, this, MinimumObjectSize);
  }

  /**
uint64_t itk::simple::RelabelComponentImageFilter::GetMinimumObjectSize() const

Get the caller-defined minimum size of an object in pixels. If the
caller has not set the minimum, 0 will be returned, which is to be
interpreted as meaning that no minimum exists, and all objects in the
original label map will be passed through to the output.

*/
public  java.math.BigInteger getMinimumObjectSize() {
    return SimpleITKJNI.RelabelComponentImageFilter_getMinimumObjectSize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RelabelComponentImageFilter::SetSortByObjectSize(bool SortByObjectSize)

Controls whether the object labels are sorted by size. If false,
initial order of labels is kept.

*/
public  void setSortByObjectSize(boolean SortByObjectSize) {
    SimpleITKJNI.RelabelComponentImageFilter_setSortByObjectSize(swigCPtr, this, SortByObjectSize);
  }

  /**
Self&amp; itk::simple::RelabelComponentImageFilter::SortByObjectSizeOn()

Set the value of SortByObjectSize to true or false respectfully.

*/
public  void sortByObjectSizeOn() {
    SimpleITKJNI.RelabelComponentImageFilter_sortByObjectSizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RelabelComponentImageFilter::SortByObjectSizeOff()
*/
public  void sortByObjectSizeOff() {
    SimpleITKJNI.RelabelComponentImageFilter_sortByObjectSizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::RelabelComponentImageFilter::GetSortByObjectSize() const

Controls whether the object labels are sorted by size. If false,
initial order of labels is kept.

*/
public  boolean getSortByObjectSize() {
    return SimpleITKJNI.RelabelComponentImageFilter_getSortByObjectSize(swigCPtr, this);
  }

  /**
uint32_t itk::simple::RelabelComponentImageFilter::GetNumberOfObjects() const

Get the number of objects in the image. This information is only valid
after the filter has executed.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getNumberOfObjects() {
    return SimpleITKJNI.RelabelComponentImageFilter_getNumberOfObjects(swigCPtr, this);
  }

  /**
uint32_t itk::simple::RelabelComponentImageFilter::GetOriginalNumberOfObjects() const

Get the original number of objects in the image before small objects
were discarded. This information is only valid after the filter has
executed. If the caller has not specified a minimum object size,
OriginalNumberOfObjects is the same as NumberOfObjects.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getOriginalNumberOfObjects() {
    return SimpleITKJNI.RelabelComponentImageFilter_getOriginalNumberOfObjects(swigCPtr, this);
  }

  /**
std::vector&lt;float&gt; itk::simple::RelabelComponentImageFilter::GetSizeOfObjectsInPhysicalUnits() const

Get the size of each object in physical space (in units of pixel
size). This information is only valid after the filter has executed. Size of the background is not calculated. Size of object #1 is GetSizeOfObjectsInPhysicalUnits() [0]. Size of object #2 is GetSizeOfObjectsInPhysicalUnits() [1]. Etc.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorFloat getSizeOfObjectsInPhysicalUnits() {
    return new VectorFloat(SimpleITKJNI.RelabelComponentImageFilter_getSizeOfObjectsInPhysicalUnits(swigCPtr, this), true);
  }

  /**
std::vector&lt;uint64_t&gt; itk::simple::RelabelComponentImageFilter::GetSizeOfObjectsInPixels() const

Get the size of each object in pixels. This information is only valid
after the filter has executed. Size of the background is not calculated. Size of object #1 is GetSizeOfObjectsInPixels() [0]. Size of object #2 is GetSizeOfObjectsInPixels() [1]. Etc.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorUInt64 getSizeOfObjectsInPixels() {
    return new VectorUInt64(SimpleITKJNI.RelabelComponentImageFilter_getSizeOfObjectsInPixels(swigCPtr, this), true);
  }

  /**
std::string itk::simple::RelabelComponentImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RelabelComponentImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RelabelComponentImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RelabelComponentImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RelabelComponentImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RelabelComponentImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
