/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Permutes the image axes according to a user specified order.


PermuateAxesImageFilter permutes the image axes according to a user
specified order. The permutation order is set via method SetOrder(
order ) where the input is an array of ImageDimension number of
unsigned int. The elements of the array must be a rearrangement of the
numbers from 0 to ImageDimension - 1.

The i-th axis of the output image corresponds with the order[i]-th
axis of the input image.

The output meta image information (LargestPossibleRegion, spacing,
origin) is computed by permuting the corresponding input meta
information.
See:
 itk::simple::PermuteAxes for the procedural interface

 itk::PermuteAxesImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkPermuteAxesImageFilter.h
*/
public class PermuteAxesImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected PermuteAxesImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.PermuteAxesImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(PermuteAxesImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(PermuteAxesImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::PermuteAxesImageFilter::~PermuteAxesImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_PermuteAxesImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::PermuteAxesImageFilter::PermuteAxesImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  PermuteAxesImageFilter() {
    this(SimpleITKJNI.new_PermuteAxesImageFilter(), true);
  }

  public static VectorUInt32 getDefaultOrder() {
    long cPtr = SimpleITKJNI.PermuteAxesImageFilter_DefaultOrder_get();
    return (cPtr == 0) ? null : new VectorUInt32(cPtr, false);
  }

  /**
Self&amp; itk::simple::PermuteAxesImageFilter::SetOrder(std::vector&lt; unsigned int &gt; Order)

Set the permutation order. The elements of order must be a
rearrangement of the numbers from 0 to ImageDimension - 1.

*/
public  void setOrder(VectorUInt32 Order) {
    SimpleITKJNI.PermuteAxesImageFilter_setOrder(swigCPtr, this, VectorUInt32.getCPtr(Order), Order);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::PermuteAxesImageFilter::GetOrder() const

Get the permutation order.

*/
public  VectorUInt32 getOrder() {
    return new VectorUInt32(SimpleITKJNI.PermuteAxesImageFilter_getOrder(swigCPtr, this), true);
  }

  /**
std::string itk::simple::PermuteAxesImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.PermuteAxesImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::PermuteAxesImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.PermuteAxesImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::PermuteAxesImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.PermuteAxesImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
