/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.autotagging;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.rule.autotagging.FeatureType;

public interface Attribute
extends Writeable {
    public String getName();

    default public void validateAttribute() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getName());
    }

    public static Attribute from(StreamInput in, FeatureType featureType) throws IOException {
        String attributeName = in.readString();
        Attribute attribute = featureType.getAttributeFromName(attributeName);
        if (attribute == null) {
            throw new IllegalStateException(attributeName + " is not a valid attribute under feature type " + featureType.getName());
        }
        return attribute;
    }
}

