// SPDX-FileCopyrightText: 2021-2023 deroad <wargio@libero.it>
// SPDX-License-Identifier: LGPL-3.0-only

#include "minunit.h"

mu_demangle_tests(gpl,
	mu_demangle_test("_ZNSt2147483648ios_base4InitD1Ev", NULL),
	mu_demangle_test("_Z10initThemesv_ptr", "initThemes()"),
	mu_demangle_test("_Z11InitUIViewsv_ptr", "InitUIViews()"),
	mu_demangle_test("_Z13getThemeColor12BNThemeColor_ptr", "getThemeColor(BNThemeColor)"),
	mu_demangle_test("_Z13InitUIActionsv_ptr", "InitUIActions()"),
	mu_demangle_test("_Z13InitUIPluginsv_ptr", "InitUIPlugins()"),
	mu_demangle_test("_Z14getActiveThemev_ptr", "getActiveTheme()"),
	mu_demangle_test("_Z14setActiveThemeRK7QStringb_ptr", "setActiveTheme(QString const&, bool)"),
	mu_demangle_test("_Z15resetUserThemesv_ptr", "resetUserThemes()"),
	mu_demangle_test("_Z16getMonospaceFontP7QWidget_ptr", "getMonospaceFont(QWidget*)"),
	mu_demangle_test("_Z16setMonospaceFontRK5QFont_ptr", "setMonospaceFont(QFont const&)"),
	mu_demangle_test("_Z17setAllowBoldFontsb_ptr", "setAllowBoldFonts(bool)"),
	mu_demangle_test("_Z17setColorBlindModeb_ptr", "setColorBlindMode(bool)"),
	mu_demangle_test("_Z19getExtraFontSpacingv_ptr", "getExtraFontSpacing()"),
	mu_demangle_test("_Z19setExtraFontSpacingi_ptr", "setExtraFontSpacing(int)"),
	mu_demangle_test("_Z20setAntialiasingStyle17AntialiasingStyle_ptr", "setAntialiasingStyle(AntialiasingStyle)"),
	mu_demangle_test("_Z21qRegisterResourceDataiPKhS0_S0__ptr", "qRegisterResourceData(int, unsigned char const*, unsigned char const*, unsigned char const*)"),
	mu_demangle_test("_Z23getDefaultMonospaceFontv_ptr", "getDefaultMonospaceFont()"),
	mu_demangle_test("_Z23qUnregisterResourceDataiPKhS0_S0__ptr", "qUnregisterResourceData(int, unsigned char const*, unsigned char const*, unsigned char const*)"),
	mu_demangle_test("_Z26getDefaultExtraFontSpacingv_ptr", "getDefaultExtraFontSpacing()"),
	mu_demangle_test("_Z33adjustFontForAntialiasingSettingsR5QFontP7QWidget_ptr", "adjustFontForAntialiasingSettings(QFont&, QWidget*)"),
	mu_demangle_test("_ZdaPv_ptr", "operator delete[](void*)"),
	mu_demangle_test("_ZdaPvm_ptr", "operator delete[](void*, unsigned long)"),
	mu_demangle_test("_ZdlPv_ptr", "operator delete(void*)"),
	mu_demangle_test("_ZdlPvm_ptr", "operator delete(void*, unsigned long)"),
	mu_demangle_test("_ZeqRK7QStringS1__ptr", "operator==(QString const&, QString const&)"),
	mu_demangle_test("_ZltRK7QStringS1__ptr", "operator<(QString const&, QString const&)"),
	mu_demangle_test("_ZN10FeatureMapC1EP9ViewFrameN11BinaryNinja3RefINS2_10BinaryViewEEE_ptr", "FeatureMap::FeatureMap(ViewFrame*, BinaryNinja::Ref<BinaryNinja::BinaryView>)"),
	mu_demangle_test("_ZN10MenuHelper11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "MenuHelper::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN10MenuHelper11qt_metacastEPKc_ptr", "MenuHelper::qt_metacast(char const*)"),
	mu_demangle_test("_ZN10MenuHelper22setBackgroundColorRoleEN8QPalette9ColorRoleE_ptr", "MenuHelper::setBackgroundColorRole(QPalette::ColorRole)"),
	mu_demangle_test("_ZN10MenuHelperC2EP7QWidgetb_ptr", "MenuHelper::MenuHelper(QWidget*, bool)"),
	mu_demangle_test("_ZN10QArrayData10deallocateEPS_mm_ptr", "QArrayData::deallocate(QArrayData*, unsigned long, unsigned long)"),
	mu_demangle_test("_ZN10QArrayData11shared_nullE_ptr", "QArrayData::shared_null"),
	mu_demangle_test("_ZN10QBoxLayout10addSpacingEi_ptr", "QBoxLayout::addSpacing(int)"),
	mu_demangle_test("_ZN10QBoxLayout10addStretchEi_ptr", "QBoxLayout::addStretch(int)"),
	mu_demangle_test("_ZN10QBoxLayout10setSpacingEi_ptr", "QBoxLayout::setSpacing(int)"),
	mu_demangle_test("_ZN10QBoxLayout9addLayoutEP7QLayouti_ptr", "QBoxLayout::addLayout(QLayout*, int)"),
	mu_demangle_test("_ZN10QBoxLayout9addWidgetEP7QWidgeti6QFlagsIN2Qt13AlignmentFlagEE_ptr", "QBoxLayout::addWidget(QWidget*, int, QFlags<Qt::AlignmentFlag>)"),
	mu_demangle_test("_ZN10QByteArray11reallocDataEj6QFlagsIN10QArrayData16AllocationOptionEE_ptr", "QByteArray::reallocData(unsigned int, QFlags<QArrayData::AllocationOption>)"),
	mu_demangle_test("_ZN10QByteArray6appendEc_ptr", "QByteArray::append(char)"),
	mu_demangle_test("_ZN10QByteArray6appendEPKc_ptr", "QByteArray::append(char const*)"),
	mu_demangle_test("_ZN10QByteArray6appendEPKci_ptr", "QByteArray::append(char const*, int)"),
	mu_demangle_test("_ZN10QByteArrayC1EPKci_ptr", "QByteArray::QByteArray(char const*, int)"),
	mu_demangle_test("_ZN10QClipboard11setMimeDataEP9QMimeDataNS_4ModeE_ptr", "QClipboard::setMimeData(QMimeData*, QClipboard::Mode)"),
	mu_demangle_test("_ZN10QClipboard5clearENS_4ModeE_ptr", "QClipboard::clear(QClipboard::Mode)"),
	mu_demangle_test("_ZN10QCompleter18setCaseSensitivityEN2Qt15CaseSensitivityE_ptr", "QCompleter::setCaseSensitivity(Qt::CaseSensitivity)"),
	mu_demangle_test("_ZN10QCompleterC1ERK11QStringListP7QObject_ptr", "QCompleter::QCompleter(QStringList const&, QObject*)"),
	mu_demangle_test("_ZN10QEventLoop4execE6QFlagsINS_17ProcessEventsFlagEE_ptr", "QEventLoop::exec(QFlags<QEventLoop::ProcessEventsFlag>)"),
	mu_demangle_test("_ZN10QEventLoopC1EP7QObject_ptr", "QEventLoop::QEventLoop(QObject*)"),
	mu_demangle_test("_ZN10QEventLoopD1Ev_ptr", "QEventLoop::~QEventLoop()"),
	mu_demangle_test("_ZN10QJsonValueD1Ev_ptr", "QJsonValue::~QJsonValue()"),
	mu_demangle_test("_ZN10QStatusBar11showMessageERK7QStringi_ptr", "QStatusBar::showMessage(QString const&, int)"),
	mu_demangle_test("_ZN10QStatusBar12clearMessageEv_ptr", "QStatusBar::clearMessage()"),
	mu_demangle_test("_ZN10QStatusBar12removeWidgetEP7QWidget_ptr", "QStatusBar::removeWidget(QWidget*)"),
	mu_demangle_test("_ZN10QStatusBar18addPermanentWidgetEP7QWidgeti_ptr", "QStatusBar::addPermanentWidget(QWidget*, int)"),
	mu_demangle_test("_ZN10QStatusBar9addWidgetEP7QWidgeti_ptr", "QStatusBar::addWidget(QWidget*, int)"),
	mu_demangle_test("_ZN10QTableView11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QTableView::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN10QTableView11qt_metacastEPKc_ptr", "QTableView::qt_metacast(char const*)"),
	mu_demangle_test("_ZN10QTableView11setShowGridEb_ptr", "QTableView::setShowGrid(bool)"),
	mu_demangle_test("_ZN10QTableView12sortByColumnEiN2Qt9SortOrderE_ptr", "QTableView::sortByColumn(int, Qt::SortOrder)"),
	mu_demangle_test("_ZN10QTableView16staticMetaObjectE_ptr", "QTableView::staticMetaObject"),
	mu_demangle_test("_ZN10QTableView17setSortingEnabledEb_ptr", "QTableView::setSortingEnabled(bool)"),
	mu_demangle_test("_ZN10QTableView23resizeColumnsToContentsEv_ptr", "QTableView::resizeColumnsToContents()"),
	mu_demangle_test("_ZN10QTableView8setModelEP18QAbstractItemModel_ptr", "QTableView::setModel(QAbstractItemModel*)"),
	mu_demangle_test("_ZN10QTableView9selectRowEi_ptr", "QTableView::selectRow(int)"),
	mu_demangle_test("_ZN10QTableViewC2EP7QWidget_ptr", "QTableView::QTableView(QWidget*)"),
	mu_demangle_test("_ZN10QTableViewD2Ev_ptr", "QTableView::~QTableView()"),
	mu_demangle_test("_ZN10QTabWidget10setMovableEb_ptr", "QTabWidget::setMovable(bool)"),
	mu_demangle_test("_ZN10QTabWidget10setTabTextEiRK7QString_ptr", "QTabWidget::setTabText(int, QString const&)"),
	mu_demangle_test("_ZN10QTabWidget11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QTabWidget::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN10QTabWidget11qt_metacastEPKc_ptr", "QTabWidget::qt_metacast(char const*)"),
	mu_demangle_test("_ZN10QTabWidget15setCornerWidgetEP7QWidgetN2Qt6CornerE_ptr", "QTabWidget::setCornerWidget(QWidget*, Qt::Corner)"),
	mu_demangle_test("_ZN10QTabWidget15setCurrentIndexEi_ptr", "QTabWidget::setCurrentIndex(int)"),
	mu_demangle_test("_ZN10QTabWidget15setDocumentModeEb_ptr", "QTabWidget::setDocumentMode(bool)"),
	mu_demangle_test("_ZN10QTabWidget15setTabsClosableEb_ptr", "QTabWidget::setTabsClosable(bool)"),
	mu_demangle_test("_ZN10QTabWidget17setTabBarAutoHideEb_ptr", "QTabWidget::setTabBarAutoHide(bool)"),
	mu_demangle_test("_ZN10QTabWidget6addTabEP7QWidgetRK7QString_ptr", "QTabWidget::addTab(QWidget*, QString const&)"),
	mu_demangle_test("_ZN10QTabWidget9insertTabEiP7QWidgetRK7QString_ptr", "QTabWidget::insertTab(int, QWidget*, QString const&)"),
	mu_demangle_test("_ZN10QTabWidget9removeTabEi_ptr", "QTabWidget::removeTab(int)"),
	mu_demangle_test("_ZN10QTabWidget9setTabBarEP7QTabBar_ptr", "QTabWidget::setTabBar(QTabBar*)"),
	mu_demangle_test("_ZN10QTabWidgetC1EP7QWidget_ptr", "QTabWidget::QTabWidget(QWidget*)"),
	mu_demangle_test("_ZN10QTabWidgetC2EP7QWidget_ptr", "QTabWidget::QTabWidget(QWidget*)"),
	mu_demangle_test("_ZN10QTabWidgetD2Ev_ptr", "QTabWidget::~QTabWidget()"),
	mu_demangle_test("_ZN11DockHandler10setVisibleERK7QStringb_ptr", "DockHandler::setVisible(QString const&, bool)"),
	mu_demangle_test("_ZN11DockHandler11updateFontsEv_ptr", "DockHandler::updateFonts()"),
	mu_demangle_test("_ZN11DockHandler11updateThemeEv_ptr", "DockHandler::updateTheme()"),
	mu_demangle_test("_ZN11DockHandler11viewChangedEP9ViewFrame_ptr", "DockHandler::viewChanged(ViewFrame*)"),
	mu_demangle_test("_ZN11DockHandler12restoreStateER9QSettingsRK7QString_ptr", "DockHandler::restoreState(QSettings&, QString const&)"),
	mu_demangle_test("_ZN11DockHandler13addDockWidgetEP7QWidgetN2Qt14DockWidgetAreaENS2_11OrientationEb_ptr", "DockHandler::addDockWidget(QWidget*, Qt::DockWidgetArea, Qt::Orientation, bool)"),
	mu_demangle_test("_ZN11DockHandler13addDockWidgetERK7QStringRKSt8functionIFP7QWidgetS2_P9ViewFrameN11BinaryNinja3RefINS8_10BinaryViewEEEEEN2Qt14DockWidgetAreaENSG_11OrientationEb_ptr", "DockHandler::addDockWidget(QString const&, std::function<QWidget* (QString const&, ViewFrame*, BinaryNinja::Ref<BinaryNinja::BinaryView>)> const&, Qt::DockWidgetArea, Qt::Orientation, bool)"),
	mu_demangle_test("_ZN11DockHandler13getDockWidgetERK7QString_ptr", "DockHandler::getDockWidget(QString const&)"),
	mu_demangle_test("_ZN11DockHandler15addActionOnShowERK7QStringRKSt8functionIFvvEE_ptr", "DockHandler::addActionOnShow(QString const&, std::function<void ()> const&)"),
	mu_demangle_test("_ZN11DockHandler17shouldResizeDocksEv_ptr", "DockHandler::shouldResizeDocks()"),
	mu_demangle_test("_ZN11DockHandler18updateViewLocationEP4ViewRK12ViewLocation_ptr", "DockHandler::updateViewLocation(View*, ViewLocation const&)"),
	mu_demangle_test("_ZN11DockHandler23notifyRestoredFromStateEv_ptr", "DockHandler::notifyRestoredFromState()"),
	mu_demangle_test("_ZN11DockHandler5closeEv_ptr", "DockHandler::close()"),
	mu_demangle_test("_ZN11DockHandler5resetEb_ptr", "DockHandler::reset(bool)"),
	mu_demangle_test("_ZN11DockHandler5resetERK7QString_ptr", "DockHandler::reset(QString const&)"),
	mu_demangle_test("_ZN11DockHandler9isVisibleERK7QString_ptr", "DockHandler::isVisible(QString const&)"),
	mu_demangle_test("_ZN11DockHandler9saveStateER9QSettingsRK7QString_ptr", "DockHandler::saveState(QSettings&, QString const&)"),
	mu_demangle_test("_ZN11DockHandlerC1EP7QObjecti_ptr", "DockHandler::DockHandler(QObject*, int)"),
	mu_demangle_test("_ZN11FileContext10isModifiedEv_ptr", "FileContext::isModified()"),
	mu_demangle_test("_ZN11FileContext11getBestTypeEv_ptr", "FileContext::getBestType()"),
	mu_demangle_test("_ZN11FileContext11getDataViewERK7QStringb_ptr", "FileContext::getDataView(QString const&, bool)"),
	mu_demangle_test("_ZN11FileContext11markAsSavedERK7QString_ptr", "FileContext::markAsSaved(QString const&)"),
	mu_demangle_test("_ZN11FileContext11resolveTypeERK7QStringRP8ViewTypeRN11BinaryNinja3RefINS6_14BinaryViewTypeEEE_ptr", "FileContext::resolveType(QString const&, ViewType*&, BinaryNinja::Ref<BinaryNinja::BinaryViewType>&)"),
	mu_demangle_test("_ZN11FileContext14createDataViewERK7QString_ptr", "FileContext::createDataView(QString const&)"),
	mu_demangle_test("_ZN11FileContext15isTypeAvailableERK7QString_ptr", "FileContext::isTypeAvailable(QString const&)"),
	mu_demangle_test("_ZN11FileContext17closeAllOpenFilesEv_ptr", "FileContext::closeAllOpenFiles()"),
	mu_demangle_test("_ZN11FileContext17getAvailableTypesEv_ptr", "FileContext::getAvailableTypes()"),
	mu_demangle_test("_ZN11FileContext17registerReferenceEP7QWidget_ptr", "FileContext::registerReference(QWidget*)"),
	mu_demangle_test("_ZN11FileContext19getOpenFileContextsEv_ptr", "FileContext::getOpenFileContexts()"),
	mu_demangle_test("_ZN11FileContext19setCurrentViewFrameEP9ViewFrame_ptr", "FileContext::setCurrentViewFrame(ViewFrame*)"),
	mu_demangle_test("_ZN11FileContext20refreshDataViewCacheEv_ptr", "FileContext::refreshDataViewCache()"),
	mu_demangle_test("_ZN11FileContext7newFileEv_ptr", "FileContext::newFile()"),
	mu_demangle_test("_ZN11FileContextC1EN11BinaryNinja3RefINS0_12FileMetadataEEENS1_INS0_10BinaryViewEEERK7QStringbb_ptr", "FileContext::FileContext(BinaryNinja::Ref<BinaryNinja::FileMetadata>, BinaryNinja::Ref<BinaryNinja::BinaryView>, QString const&, bool, bool)"),
	mu_demangle_test("_ZN11QFileDevice5closeEv_ptr", "QFileDevice::close()"),
	mu_demangle_test("_ZN11QFileDialog15getOpenFileNameEP7QWidgetRK7QStringS4_S4_PS2_6QFlagsINS_6OptionEE_ptr", "QFileDialog::getOpenFileName(QWidget*, QString const&, QString const&, QString const&, QString*, QFlags<QFileDialog::Option>)"),
	mu_demangle_test("_ZN11QFileDialog15getSaveFileNameEP7QWidgetRK7QStringS4_S4_PS2_6QFlagsINS_6OptionEE_ptr", "QFileDialog::getSaveFileName(QWidget*, QString const&, QString const&, QString const&, QString*, QFlags<QFileDialog::Option>)"),
	mu_demangle_test("_ZN11QFileDialog16getOpenFileNamesEP7QWidgetRK7QStringS4_S4_PS2_6QFlagsINS_6OptionEE_ptr", "QFileDialog::getOpenFileNames(QWidget*, QString const&, QString const&, QString const&, QString*, QFlags<QFileDialog::Option>)"),
	mu_demangle_test("_ZN11QFileDialog20getExistingDirectoryEP7QWidgetRK7QStringS4_6QFlagsINS_6OptionEE_ptr", "QFileDialog::getExistingDirectory(QWidget*, QString const&, QString const&, QFlags<QFileDialog::Option>)"),
	mu_demangle_test("_ZN11QFontDialog7getFontEPbRK5QFontP7QWidgetRK7QString6QFlagsINS_16FontDialogOptionEE_ptr", "QFontDialog::getFont(bool*, QFont const&, QWidget*, QString const&, QFlags<QFontDialog::FontDialogOption>)"),
	mu_demangle_test("_ZN11QGridLayout16setColumnStretchEii_ptr", "QGridLayout::setColumnStretch(int, int)"),
	mu_demangle_test("_ZN11QGridLayout19setRowMinimumHeightEii_ptr", "QGridLayout::setRowMinimumHeight(int, int)"),
	mu_demangle_test("_ZN11QGridLayout9addWidgetEP7QWidgetii6QFlagsIN2Qt13AlignmentFlagEE_ptr", "QGridLayout::addWidget(QWidget*, int, int, QFlags<Qt::AlignmentFlag>)"),
	mu_demangle_test("_ZN11QGridLayoutC1EP7QWidget_ptr", "QGridLayout::QGridLayout(QWidget*)"),
	mu_demangle_test("_ZN11QGridLayoutC1Ev_ptr", "QGridLayout::QGridLayout()"),
	mu_demangle_test("_ZN11QHBoxLayoutC1EP7QWidget_ptr", "QHBoxLayout::QHBoxLayout(QWidget*)"),
	mu_demangle_test("_ZN11QHBoxLayoutC1Ev_ptr", "QHBoxLayout::QHBoxLayout()"),
	mu_demangle_test("_ZN11QHeaderView20setSectionResizeModeEiNS_10ResizeModeE_ptr", "QHeaderView::setSectionResizeMode(int, QHeaderView::ResizeMode)"),
	mu_demangle_test("_ZN11QHeaderView20setSectionResizeModeENS_10ResizeModeE_ptr", "QHeaderView::setSectionResizeMode(QHeaderView::ResizeMode)"),
	mu_demangle_test("_ZN11QHeaderView21setDefaultSectionSizeEi_ptr", "QHeaderView::setDefaultSectionSize(int)"),
	mu_demangle_test("_ZN11QHeaderView21setStretchLastSectionEb_ptr", "QHeaderView::setStretchLastSection(bool)"),
	mu_demangle_test("_ZN11QJsonObjectD1Ev_ptr", "QJsonObject::~QJsonObject()"),
	mu_demangle_test("_ZN11QMainWindow10addToolBarEN2Qt11ToolBarAreaEP8QToolBar_ptr", "QMainWindow::addToolBar(Qt::ToolBarArea, QToolBar*)"),
	mu_demangle_test("_ZN11QMainWindow11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QMainWindow::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN11QMainWindow11qt_metacastEPKc_ptr", "QMainWindow::qt_metacast(char const*)"),
	mu_demangle_test("_ZN11QMainWindow11resizeDocksERK5QListIP11QDockWidgetERKS0_IiEN2Qt11OrientationE_ptr", "QMainWindow::resizeDocks(QList<QDockWidget*> const&, QList<int> const&, Qt::Orientation)"),
	mu_demangle_test("_ZN11QMainWindow12restoreStateERK10QByteArrayi_ptr", "QMainWindow::restoreState(QByteArray const&, int)"),
	mu_demangle_test("_ZN11QMainWindow15splitDockWidgetEP11QDockWidgetS1_N2Qt11OrientationE_ptr", "QMainWindow::splitDockWidget(QDockWidget*, QDockWidget*, Qt::Orientation)"),
	mu_demangle_test("_ZN11QMainWindow16setCentralWidgetEP7QWidget_ptr", "QMainWindow::setCentralWidget(QWidget*)"),
	mu_demangle_test("_ZN11QMainWindow16tabifyDockWidgetEP11QDockWidgetS1__ptr", "QMainWindow::tabifyDockWidget(QDockWidget*, QDockWidget*)"),
	mu_demangle_test("_ZN11QMainWindow21setDockNestingEnabledEb_ptr", "QMainWindow::setDockNestingEnabled(bool)"),
	mu_demangle_test("_ZN11QMainWindow9setCornerEN2Qt6CornerENS0_14DockWidgetAreaE_ptr", "QMainWindow::setCorner(Qt::Corner, Qt::DockWidgetArea)"),
	mu_demangle_test("_ZN11QMainWindowC2EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QMainWindow::QMainWindow(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN11QMainWindowD2Ev_ptr", "QMainWindow::~QMainWindow()"),
	mu_demangle_test("_ZN11QMessageBox11informationEP7QWidgetRK7QStringS4_6QFlagsINS_14StandardButtonEES6__ptr", "QMessageBox::information(QWidget*, QString const&, QString const&, QFlags<QMessageBox::StandardButton>, QMessageBox::StandardButton)"),
	mu_demangle_test("_ZN11QMessageBox14setWindowTitleERK7QString_ptr", "QMessageBox::setWindowTitle(QString const&)"),
	mu_demangle_test("_ZN11QMessageBox16setDefaultButtonENS_14StandardButtonE_ptr", "QMessageBox::setDefaultButton(QMessageBox::StandardButton)"),
	mu_demangle_test("_ZN11QMessageBox18setInformativeTextERK7QString_ptr", "QMessageBox::setInformativeText(QString const&)"),
	mu_demangle_test("_ZN11QMessageBox18setStandardButtonsE6QFlagsINS_14StandardButtonEE_ptr", "QMessageBox::setStandardButtons(QFlags<QMessageBox::StandardButton>)"),
	mu_demangle_test("_ZN11QMessageBox7setIconENS_4IconE_ptr", "QMessageBox::setIcon(QMessageBox::Icon)"),
	mu_demangle_test("_ZN11QMessageBox7setTextERK7QString_ptr", "QMessageBox::setText(QString const&)"),
	mu_demangle_test("_ZN11QMessageBox7warningEP7QWidgetRK7QStringS4_6QFlagsINS_14StandardButtonEES6__ptr", "QMessageBox::warning(QWidget*, QString const&, QString const&, QFlags<QMessageBox::StandardButton>, QMessageBox::StandardButton)"),
	mu_demangle_test("_ZN11QMessageBox8criticalEP7QWidgetRK7QStringS4_6QFlagsINS_14StandardButtonEES6__ptr", "QMessageBox::critical(QWidget*, QString const&, QString const&, QFlags<QMessageBox::StandardButton>, QMessageBox::StandardButton)"),
	mu_demangle_test("_ZN11QMessageBox8questionEP7QWidgetRK7QStringS4_6QFlagsINS_14StandardButtonEES6__ptr", "QMessageBox::question(QWidget*, QString const&, QString const&, QFlags<QMessageBox::StandardButton>, QMessageBox::StandardButton)"),
	mu_demangle_test("_ZN11QMessageBox9addButtonENS_14StandardButtonE_ptr", "QMessageBox::addButton(QMessageBox::StandardButton)"),
	mu_demangle_test("_ZN11QMessageBox9addButtonERK7QStringNS_10ButtonRoleE_ptr", "QMessageBox::addButton(QString const&, QMessageBox::ButtonRole)"),
	mu_demangle_test("_ZN11QMessageBoxC1ENS_4IconERK7QStringS3_6QFlagsINS_14StandardButtonEEP7QWidgetS4_IN2Qt10WindowTypeEE_ptr", "QMessageBox::QMessageBox(QMessageBox::Icon, QString const&, QString const&, QFlags<QMessageBox::StandardButton>, QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN11QMessageBoxC1EP7QWidget_ptr", "QMessageBox::QMessageBox(QWidget*)"),
	mu_demangle_test("_ZN11QMessageBoxD1Ev_ptr", "QMessageBox::~QMessageBox()"),
	mu_demangle_test("_ZN11QMetaObject10ConnectionD1Ev_ptr", "QMetaObject::Connection::~Connection()"),
	mu_demangle_test("_ZN11QMetaObject14normalizedTypeEPKc_ptr", "QMetaObject::normalizedType(char const*)"),
	mu_demangle_test("_ZN11QMetaObject8activateEP7QObjectPKS_iPPv_ptr", "QMetaObject::activate(QObject*, QMetaObject const*, int, void**)"),
	mu_demangle_test("_ZN11QPushButton10setDefaultEb_ptr", "QPushButton::setDefault(bool)"),
	mu_demangle_test("_ZN11QPushButtonC1EP7QWidget_ptr", "QPushButton::QPushButton(QWidget*)"),
	mu_demangle_test("_ZN11QPushButtonC1ERK7QStringP7QWidget_ptr", "QPushButton::QPushButton(QString const&, QWidget*)"),
	mu_demangle_test("_ZN11QScrollArea11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QScrollArea::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN11QScrollArea11qt_metacastEPKc_ptr", "QScrollArea::qt_metacast(char const*)"),
	mu_demangle_test("_ZN11QScrollArea18setWidgetResizableEb_ptr", "QScrollArea::setWidgetResizable(bool)"),
	mu_demangle_test("_ZN11QScrollArea9setWidgetEP7QWidget_ptr", "QScrollArea::setWidget(QWidget*)"),
	mu_demangle_test("_ZN11QScrollAreaC2EP7QWidget_ptr", "QScrollArea::QScrollArea(QWidget*)"),
	mu_demangle_test("_ZN11QScrollAreaD2Ev_ptr", "QScrollArea::~QScrollArea()"),
	mu_demangle_test("_ZN11QTextStream7readAllEv_ptr", "QTextStream::readAll()"),
	mu_demangle_test("_ZN11QTextStreamC1EP7QString6QFlagsIN9QIODevice12OpenModeFlagEE_ptr", "QTextStream::QTextStream(QString*, QFlags<QIODevice::OpenModeFlag>)"),
	mu_demangle_test("_ZN11QTextStreamC1EP9QIODevice_ptr", "QTextStream::QTextStream(QIODevice*)"),
	mu_demangle_test("_ZN11QTextStreamD1Ev_ptr", "QTextStream::~QTextStream()"),
	mu_demangle_test("_ZN11QTextStreamlsEl_ptr", "QTextStream::operator<<(long)"),
	mu_demangle_test("_ZN11QTextStreamlsEm_ptr", "QTextStream::operator<<(unsigned long)"),
	mu_demangle_test("_ZN11QTextStreamlsEPKc_ptr", "QTextStream::operator<<(char const*)"),
	mu_demangle_test("_ZN11QTextStreamlsERK7QString_ptr", "QTextStream::operator<<(QString const&)"),
	mu_demangle_test("_ZN11QThreadPool5startEP9QRunnablei_ptr", "QThreadPool::start(QRunnable*, int)"),
	mu_demangle_test("_ZN11QThreadPoolC1EP7QObject_ptr", "QThreadPool::QThreadPool(QObject*)"),
	mu_demangle_test("_ZN11QToolButton12setArrowTypeEN2Qt9ArrowTypeE_ptr", "QToolButton::setArrowType(Qt::ArrowType)"),
	mu_demangle_test("_ZN11QToolButtonC1EP7QWidget_ptr", "QToolButton::QToolButton(QWidget*)"),
	mu_demangle_test("_ZN11QVBoxLayoutC1EP7QWidget_ptr", "QVBoxLayout::QVBoxLayout(QWidget*)"),
	mu_demangle_test("_ZN11QVBoxLayoutC1Ev_ptr", "QVBoxLayout::QVBoxLayout()"),
	mu_demangle_test("_ZN11SymbolsViewC1EP9ViewFrameN11BinaryNinja3RefINS2_10BinaryViewEEE_ptr", "SymbolsView::SymbolsView(ViewFrame*, BinaryNinja::Ref<BinaryNinja::BinaryView>)"),
	mu_demangle_test("_ZN12FilteredView10showFilterERK7QString_ptr", "FilteredView::showFilter(QString const&)"),
	mu_demangle_test("_ZN12FilteredView5matchERKNSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEES7__ptr", "FilteredView::match(std::string const&, std::string const&)"),
	mu_demangle_test("_ZN12FilteredViewC1EP7QWidgetS1_P12FilterTarget_ptr", "FilteredView::FilteredView(QWidget*, QWidget*, FilterTarget*)"),
	mu_demangle_test("_ZN12LogListModel16staticMetaObjectE_ptr", "LogListModel::staticMetaObject"),
	mu_demangle_test("_ZN12QApplication11focusWidgetEv_ptr", "QApplication::focusWidget()"),
	mu_demangle_test("_ZN12QApplication11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QApplication::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN12QApplication11qt_metacastEPKc_ptr", "QApplication::qt_metacast(char const*)"),
	mu_demangle_test("_ZN12QApplication12activeWindowEv_ptr", "QApplication::activeWindow()"),
	mu_demangle_test("_ZN12QApplication17activeModalWidgetEv_ptr", "QApplication::activeModalWidget()"),
	mu_demangle_test("_ZN12QApplication4execEv_ptr", "QApplication::exec()"),
	mu_demangle_test("_ZN12QApplication4fontEv_ptr", "QApplication::font()"),
	mu_demangle_test("_ZN12QApplication7setFontERK5QFontPKc_ptr", "QApplication::setFont(QFont const&, char const*)"),
	mu_demangle_test("_ZN12QApplicationC2ERiPPci_ptr", "QApplication::QApplication(int&, char**, int)"),
	mu_demangle_test("_ZN12QApplicationD2Ev_ptr", "QApplication::~QApplication()"),
	mu_demangle_test("_ZN12QDirIterator4nextEv_ptr", "QDirIterator::next()"),
	mu_demangle_test("_ZN12QDirIteratorC1ERK7QString6QFlagsINS_12IteratorFlagEE_ptr", "QDirIterator::QDirIterator(QString const&, QFlags<QDirIterator::IteratorFlag>)"),
	mu_demangle_test("_ZN12QDirIteratorD1Ev_ptr", "QDirIterator::~QDirIterator()"),
	mu_demangle_test("_ZN12QEasingCurveC1ENS_4TypeE_ptr", "QEasingCurve::QEasingCurve(QEasingCurve::Type)"),
	mu_demangle_test("_ZN12QEasingCurveD1Ev_ptr", "QEasingCurve::~QEasingCurve()"),
	mu_demangle_test("_ZN12QFontMetricsC1ERK5QFont_ptr", "QFontMetrics::QFontMetrics(QFont const&)"),
	mu_demangle_test("_ZN12QFontMetricsD1Ev_ptr", "QFontMetrics::~QFontMetrics()"),
	mu_demangle_test("_ZN12QInputDialog12setLabelTextERK7QString_ptr", "QInputDialog::setLabelText(QString const&)"),
	mu_demangle_test("_ZN12QInputDialog15setTextEchoModeEN9QLineEdit8EchoModeE_ptr", "QInputDialog::setTextEchoMode(QLineEdit::EchoMode)"),
	mu_demangle_test("_ZN12QInputDialog7getItemEP7QWidgetRK7QStringS4_RK11QStringListibPb6QFlagsIN2Qt10WindowTypeEES9_INSA_15InputMethodHintEE_ptr", "QInputDialog::getItem(QWidget*, QString const&, QString const&, QStringList const&, int, bool, bool*, QFlags<Qt::WindowType>, QFlags<Qt::InputMethodHint>)"),
	mu_demangle_test("_ZN12QInputDialog7getTextEP7QWidgetRK7QStringS4_N9QLineEdit8EchoModeES4_Pb6QFlagsIN2Qt10WindowTypeEES8_INS9_15InputMethodHintEE_ptr", "QInputDialog::getText(QWidget*, QString const&, QString const&, QLineEdit::EchoMode, QString const&, bool*, QFlags<Qt::WindowType>, QFlags<Qt::InputMethodHint>)"),
	mu_demangle_test("_ZN12QInputDialogC1EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QInputDialog::QInputDialog(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN12QInputDialogD1Ev_ptr", "QInputDialog::~QInputDialog()"),
	mu_demangle_test("_ZN12QKeySequenceC1Eiiii_ptr", "QKeySequence::QKeySequence(int, int, int, int)"),
	mu_demangle_test("_ZN12QKeySequenceC1ENS_11StandardKeyE_ptr", "QKeySequence::QKeySequence(QKeySequence::StandardKey)"),
	mu_demangle_test("_ZN12QKeySequenceC1ERK7QStringNS_14SequenceFormatE_ptr", "QKeySequence::QKeySequence(QString const&, QKeySequence::SequenceFormat)"),
	mu_demangle_test("_ZN12QKeySequenceC1ERKS__ptr", "QKeySequence::QKeySequence(QKeySequence const&)"),
	mu_demangle_test("_ZN12QKeySequenceC1Ev_ptr", "QKeySequence::QKeySequence()"),
	mu_demangle_test("_ZN12QKeySequenceD1Ev_ptr", "QKeySequence::~QKeySequence()"),
	mu_demangle_test("_ZN12QRadioButtonC1ERK7QStringP7QWidget_ptr", "QRadioButton::QRadioButton(QString const&, QWidget*)"),
	mu_demangle_test("_ZN12QStyleOption4initEPK7QWidget_ptr", "QStyleOption::init(QWidget const*)"),
	mu_demangle_test("_ZN12QStyleOptionC1Eii_ptr", "QStyleOption::QStyleOption(int, int)"),
	mu_demangle_test("_ZN12QStyleOptionD1Ev_ptr", "QStyleOption::~QStyleOption()"),
	mu_demangle_test("_ZN12QTextBrowser20setOpenExternalLinksEb_ptr", "QTextBrowser::setOpenExternalLinks(bool)"),
	mu_demangle_test("_ZN12QTextBrowserC1EP7QWidget_ptr", "QTextBrowser::QTextBrowser(QWidget*)"),
	// INCORRECT : 	mu_demangle_test("_ZN12ReportWidgetC1EP7QWidgetN11BinaryNinja3RefINS2_10BinaryViewEEERKNSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE12BNReportTypeSD_SD__ptr", "ReportWidget::ReportWidget(QWidget*, BinaryNinja::Ref<BinaryNinja::BinaryView>, std::string const&, BNReportType, std::string const&, std::string const&)"),
	mu_demangle_test("_ZN13QFileAccessor5CloseEv_ptr", "QFileAccessor::Close()"),
	mu_demangle_test("_ZN13QFileAccessorC1ERK7QStringb_ptr", "QFileAccessor::QFileAccessor(QString const&, bool)"),
	mu_demangle_test("_ZN13QFileAccessorD1Ev_ptr", "QFileAccessor::~QFileAccessor()"),
	mu_demangle_test("_ZN13QFontDatabase18addApplicationFontERK7QString_ptr", "QFontDatabase::addApplicationFont(QString const&)"),
	mu_demangle_test("_ZN13QFontMetricsFC1ERK5QFont_ptr", "QFontMetricsF::QFontMetricsF(QFont const&)"),
	mu_demangle_test("_ZN13QFontMetricsFD1Ev_ptr", "QFontMetricsF::~QFontMetricsF()"),
	mu_demangle_test("_ZN13QItemDelegate11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QItemDelegate::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN13QItemDelegate11qt_metacastEPKc_ptr", "QItemDelegate::qt_metacast(char const*)"),
	mu_demangle_test("_ZN13QItemDelegateC2EP7QObject_ptr", "QItemDelegate::QItemDelegate(QObject*)"),
	mu_demangle_test("_ZN13QItemDelegateD2Ev_ptr", "QItemDelegate::~QItemDelegate()"),
	mu_demangle_test("_ZN13QJsonDocument8fromJsonERK10QByteArrayP15QJsonParseError_ptr", "QJsonDocument::fromJson(QByteArray const&, QJsonParseError*)"),
	mu_demangle_test("_ZN13QJsonDocumentD1Ev_ptr", "QJsonDocument::~QJsonDocument()"),
	// INCORRECT : 	mu_demangle_test("_ZN13RenderContext19drawDisassemblyLineER8QPainteriiRKSt6vectorIN11BinaryNinja20InstructionTextTokenESaIS4_EER19HighlightTokenStateb_ptr", "RenderContext::drawDisassemblyLine(QPainter&, int, int, std::vector<BinaryNinja::InstructionTextToken> const&, HighlightTokenState&, bool)"),
	mu_demangle_test("_ZN13RenderContext7setFontERK5QFont_ptr", "RenderContext::setFont(QFont const&)"),
	mu_demangle_test("_ZN13RenderContextC1EP7QWidgetf_ptr", "RenderContext::RenderContext(QWidget*, float)"),
	mu_demangle_test("_ZN13TagListWidgetC1EP7QWidgetP9ViewFrameN11BinaryNinja3RefINS4_10BinaryViewEEE_ptr", "TagListWidget::TagListWidget(QWidget*, ViewFrame*, BinaryNinja::Ref<BinaryNinja::BinaryView>)"),
	mu_demangle_test("_ZN14ClickableLabel16staticMetaObjectE_ptr", "ClickableLabel::staticMetaObject"),
	mu_demangle_test("_ZN14ClickableLabel7clickedEv_ptr", "ClickableLabel::clicked()"),
	mu_demangle_test("_ZN14CommandPalette10focusInputEv_ptr", "CommandPalette::focusInput()"),
	mu_demangle_test("_ZN14CommandPaletteC1EP7QWidgetP15UIActionHandler_ptr", "CommandPalette::CommandPalette(QWidget*, UIActionHandler*)"),
	mu_demangle_test("_ZN14QDoubleSpinBox10setMaximumEd_ptr", "QDoubleSpinBox::setMaximum(double)"),
	mu_demangle_test("_ZN14QDoubleSpinBox10setMinimumEd_ptr", "QDoubleSpinBox::setMinimum(double)"),
	mu_demangle_test("_ZN14QDoubleSpinBox11setDecimalsEi_ptr", "QDoubleSpinBox::setDecimals(int)"),
	mu_demangle_test("_ZN14QDoubleSpinBox8setValueEd_ptr", "QDoubleSpinBox::setValue(double)"),
	mu_demangle_test("_ZN14QDoubleSpinBoxC1EP7QWidget_ptr", "QDoubleSpinBox::QDoubleSpinBox(QWidget*)"),
	mu_demangle_test("_ZN14QWebEnginePage11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QWebEnginePage::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN14QWebEnginePage11qt_metacastEPKc_ptr", "QWebEnginePage::qt_metacast(char const*)"),
	mu_demangle_test("_ZN14QWebEnginePage13runJavaScriptERK7QStringj_ptr", "QWebEnginePage::runJavaScript(QString const&, unsigned int)"),
	mu_demangle_test("_ZN14QWebEnginePage13runJavaScriptERK7QStringRK18QWebEngineCallbackIRK8QVariantE_ptr", "QWebEnginePage::runJavaScript(QString const&, QWebEngineCallback<QVariant const&> const&)"),
	mu_demangle_test("_ZN14QWebEnginePage16staticMetaObjectE_ptr", "QWebEnginePage::staticMetaObject"),
	mu_demangle_test("_ZN14QWebEnginePage18setBackgroundColorERK6QColor_ptr", "QWebEnginePage::setBackgroundColor(QColor const&)"),
	mu_demangle_test("_ZN14QWebEnginePage19contentsSizeChangedERK6QSizeF_ptr", "QWebEnginePage::contentsSizeChanged(QSizeF const&)"),
	mu_demangle_test("_ZN14QWebEnginePage23acceptNavigationRequestERK4QUrlNS_14NavigationTypeEb_ptr", "QWebEnginePage::acceptNavigationRequest(QUrl const&, QWebEnginePage::NavigationType, bool)"),
	mu_demangle_test("_ZN14QWebEnginePage7scriptsEv_ptr", "QWebEnginePage::scripts()"),
	mu_demangle_test("_ZN14QWebEnginePageC2EP7QObject_ptr", "QWebEnginePage::QWebEnginePage(QObject*)"),
	mu_demangle_test("_ZN14QWebEnginePageD2Ev_ptr", "QWebEnginePage::~QWebEnginePage()"),
	mu_demangle_test("_ZN14QWebEngineView13setZoomFactorEd_ptr", "QWebEngineView::setZoomFactor(double)"),
	mu_demangle_test("_ZN14QWebEngineView6setUrlERK4QUrl_ptr", "QWebEngineView::setUrl(QUrl const&)"),
	mu_demangle_test("_ZN14QWebEngineView7setHtmlERK7QStringRK4QUrl_ptr", "QWebEngineView::setHtml(QString const&, QUrl const&)"),
	mu_demangle_test("_ZN14QWebEngineView7setPageEP14QWebEnginePage_ptr", "QWebEngineView::setPage(QWebEnginePage*)"),
	mu_demangle_test("_ZN14QWebEngineViewC1EP7QWidget_ptr", "QWebEngineView::QWebEngineView(QWidget*)"),
	mu_demangle_test("_ZN14ReflectionViewC1EP9ViewFrameN11BinaryNinja3RefINS2_10BinaryViewEEE_ptr", "ReflectionView::ReflectionView(ViewFrame*, BinaryNinja::Ref<BinaryNinja::BinaryView>)"),
	mu_demangle_test("_ZN15FlowGraphWidgetC1EP7QWidgetN11BinaryNinja3RefINS2_10BinaryViewEEENS3_INS2_9FlowGraphEEE_ptr", "FlowGraphWidget::FlowGraphWidget(QWidget*, BinaryNinja::Ref<BinaryNinja::BinaryView>, BinaryNinja::Ref<BinaryNinja::FlowGraph>)"),
	// INCORRECT : 	mu_demangle_test("_ZN15FormInputDialogC1EP7QWidgetPSt6vectorIN11BinaryNinja14FormInputFieldESaIS4_EERKNSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE_ptr", "FormInputDialog::FormInputDialog(QWidget*, std::vector<BinaryNinja::FormInputField>*, std::string const&)"),
	mu_demangle_test("_ZN15QAbstractButton10setCheckedEb_ptr", "QAbstractButton::setChecked(bool)"),
	mu_demangle_test("_ZN15QAbstractButton16staticMetaObjectE_ptr", "QAbstractButton::staticMetaObject"),
	mu_demangle_test("_ZN15QAbstractButton7clickedEb_ptr", "QAbstractButton::clicked(bool)"),
	mu_demangle_test("_ZN15QAbstractButton7setTextERK7QString_ptr", "QAbstractButton::setText(QString const&)"),
	mu_demangle_test("_ZN15QAbstractSlider13setSingleStepEi_ptr", "QAbstractSlider::setSingleStep(int)"),
	mu_demangle_test("_ZN15QGuiApplication22queryKeyboardModifiersEv_ptr", "QGuiApplication::queryKeyboardModifiers()"),
	mu_demangle_test("_ZN15QGuiApplication7screensEv_ptr", "QGuiApplication::screens()"),
	mu_demangle_test("_ZN15QGuiApplication9clipboardEv_ptr", "QGuiApplication::clipboard()"),
	mu_demangle_test("_ZN15QNetworkRequest12setAttributeENS_9AttributeERK8QVariant_ptr", "QNetworkRequest::setAttribute(QNetworkRequest::Attribute, QVariant const&)"),
	mu_demangle_test("_ZN15QNetworkRequest12setRawHeaderERK10QByteArrayS2__ptr", "QNetworkRequest::setRawHeader(QByteArray const&, QByteArray const&)"),
	mu_demangle_test("_ZN15QNetworkRequest18setTransferTimeoutEi_ptr", "QNetworkRequest::setTransferTimeout(int)"),
	mu_demangle_test("_ZN15QNetworkRequestC1ERK4QUrl_ptr", "QNetworkRequest::QNetworkRequest(QUrl const&)"),
	mu_demangle_test("_ZN15QNetworkRequestD1Ev_ptr", "QNetworkRequest::~QNetworkRequest()"),
	mu_demangle_test("_ZN15QProgressDialog10setMaximumEi_ptr", "QProgressDialog::setMaximum(int)"),
	mu_demangle_test("_ZN15QProgressDialog12setLabelTextERK7QString_ptr", "QProgressDialog::setLabelText(QString const&)"),
	mu_demangle_test("_ZN15QProgressDialog18setMinimumDurationEi_ptr", "QProgressDialog::setMinimumDuration(int)"),
	mu_demangle_test("_ZN15QProgressDialog19setCancelButtonTextERK7QString_ptr", "QProgressDialog::setCancelButtonText(QString const&)"),
	mu_demangle_test("_ZN15QProgressDialog6cancelEv_ptr", "QProgressDialog::cancel()"),
	mu_demangle_test("_ZN15QProgressDialog8setValueEi_ptr", "QProgressDialog::setValue(int)"),
	mu_demangle_test("_ZN15QProgressDialogC1EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QProgressDialog::QProgressDialog(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN15QProgressDialogD1Ev_ptr", "QProgressDialog::~QProgressDialog()"),
	mu_demangle_test("_ZN15QtSharedPointer20ExternalRefCountData9getAndRefEPK7QObject_ptr", "QtSharedPointer::ExternalRefCountData::getAndRef(QObject const*)"),
	mu_demangle_test("_ZN15UIActionContextC1Ev_ptr", "UIActionContext::UIActionContext()"),
	mu_demangle_test("_ZN15UIActionHandler10bindActionERK7QStringRK8UIAction14ActionPriority_ptr", "UIActionHandler::bindAction(QString const&, UIAction const&, ActionPriority)"),
	mu_demangle_test("_ZN15UIActionHandler10bindActionERK7QStringRK8UIAction_ptr", "UIActionHandler::bindAction(QString const&, UIAction const&)"),
	mu_demangle_test("_ZN15UIActionHandler10setCheckedERK7QStringRKSt8functionIFbvEE_ptr", "UIActionHandler::setChecked(QString const&, std::function<bool ()> const&)"),
	mu_demangle_test("_ZN15UIActionHandler12unbindActionERK7QString_ptr", "UIActionHandler::unbindAction(QString const&)"),
	mu_demangle_test("_ZN15UIActionHandler13executeActionERK7QString_ptr", "UIActionHandler::executeAction(QString const&)"),
	mu_demangle_test("_ZN15UIActionHandler14reparentWidgetEP7QWidget_ptr", "UIActionHandler::reparentWidget(QWidget*)"),
	mu_demangle_test("_ZN15UIActionHandler18setupActionHandlerEP7QWidgetb_ptr", "UIActionHandler::setupActionHandler(QWidget*, bool)"),
	mu_demangle_test("_ZN15UIActionHandler20setActionDisplayNameERK7QStringRKSt8functionIFS0_vEE_ptr", "UIActionHandler::setActionDisplayName(QString const&, std::function<QString ()> const&)"),
	mu_demangle_test("_ZN15UIActionHandler23actionHandlerFromWidgetEP7QWidget_ptr", "UIActionHandler::actionHandlerFromWidget(QWidget*)"),
	mu_demangle_test("_ZN15UIActionHandler24bindPluginCommandActionsEv_ptr", "UIActionHandler::bindPluginCommandActions()"),
	mu_demangle_test("_ZN15UIActionHandlerC1Eb_ptr", "UIActionHandler::UIActionHandler(bool)"),
	mu_demangle_test("_ZN15UIActionHandlerD1Ev_ptr", "UIActionHandler::~UIActionHandler()"),
	mu_demangle_test("_ZN16AddressIndicator10setOffsetsEmm_ptr", "AddressIndicator::setOffsets(unsigned long, unsigned long)"),
	mu_demangle_test("_ZN16AddressIndicatorC1EP7QWidget_ptr", "AddressIndicator::AddressIndicator(QWidget*)"),
	mu_demangle_test("_ZN16MainMenuInstance6updateEP15UIActionHandler_ptr", "MainMenuInstance::update(UIActionHandler*)"),
	mu_demangle_test("_ZN16MainMenuInstance6updateEP15UIActionHandlerRK15UIActionContext_ptr", "MainMenuInstance::update(UIActionHandler*, UIActionContext const&)"),
	mu_demangle_test("_ZN16MainMenuInstanceC1EP8QMenuBar_ptr", "MainMenuInstance::MainMenuInstance(QMenuBar*)"),
	mu_demangle_test("_ZN16MainMenuInstanceD1Ev_ptr", "MainMenuInstance::~MainMenuInstance()"),
	mu_demangle_test("_ZN16QAbstractSpinBox11setWrappingEb_ptr", "QAbstractSpinBox::setWrapping(bool)"),
	mu_demangle_test("_ZN16QCoreApplication12setAttributeEN2Qt20ApplicationAttributeEb_ptr", "QCoreApplication::setAttribute(Qt::ApplicationAttribute, bool)"),
	mu_demangle_test("_ZN16QCoreApplication13processEventsE6QFlagsIN10QEventLoop17ProcessEventsFlagEE_ptr", "QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag>)"),
	mu_demangle_test("_ZN16QCoreApplication18applicationDirPathEv_ptr", "QCoreApplication::applicationDirPath()"),
	mu_demangle_test("_ZN16QCoreApplication18setApplicationNameERK7QString_ptr", "QCoreApplication::setApplicationName(QString const&)"),
	mu_demangle_test("_ZN16QCoreApplication19setOrganizationNameERK7QString_ptr", "QCoreApplication::setOrganizationName(QString const&)"),
	mu_demangle_test("_ZN16QCoreApplication21setApplicationVersionERK7QString_ptr", "QCoreApplication::setApplicationVersion(QString const&)"),
	mu_demangle_test("_ZN16QCoreApplication21setOrganizationDomainERK7QString_ptr", "QCoreApplication::setOrganizationDomain(QString const&)"),
	mu_demangle_test("_ZN16QCoreApplication4selfE_ptr", "QCoreApplication::self"),
	mu_demangle_test("_ZN16QCoreApplication9argumentsEv_ptr", "QCoreApplication::arguments()"),
	mu_demangle_test("_ZN16QCoreApplication9postEventEP7QObjectP6QEventi_ptr", "QCoreApplication::postEvent(QObject*, QEvent*, int)"),
	mu_demangle_test("_ZN16QCoreApplication9translateEPKcS1_S1_i_ptr", "QCoreApplication::translate(char const*, char const*, char const*, int)"),
	mu_demangle_test("_ZN16QDesktopServices7openUrlERK4QUrl_ptr", "QDesktopServices::openUrl(QUrl const&)"),
	mu_demangle_test("_ZN16QKeySequenceEdit14setKeySequenceERK12QKeySequence_ptr", "QKeySequenceEdit::setKeySequence(QKeySequence const&)"),
	mu_demangle_test("_ZN16QKeySequenceEdit16staticMetaObjectE_ptr", "QKeySequenceEdit::staticMetaObject"),
	mu_demangle_test("_ZN16QKeySequenceEditC1EP7QWidget_ptr", "QKeySequenceEdit::QKeySequenceEdit(QWidget*)"),
	mu_demangle_test("_ZN16QWebEngineScript10setWorldIdEj_ptr", "QWebEngineScript::setWorldId(unsigned int)"),
	mu_demangle_test("_ZN16QWebEngineScript13setSourceCodeERK7QString_ptr", "QWebEngineScript::setSourceCode(QString const&)"),
	mu_demangle_test("_ZN16QWebEngineScript17setInjectionPointENS_14InjectionPointE_ptr", "QWebEngineScript::setInjectionPoint(QWebEngineScript::InjectionPoint)"),
	mu_demangle_test("_ZN16QWebEngineScript18setRunsOnSubFramesEb_ptr", "QWebEngineScript::setRunsOnSubFrames(bool)"),
	mu_demangle_test("_ZN16QWebEngineScript7setNameERK7QString_ptr", "QWebEngineScript::setName(QString const&)"),
	mu_demangle_test("_ZN16QWebEngineScriptC1Ev_ptr", "QWebEngineScript::QWebEngineScript()"),
	mu_demangle_test("_ZN16QWebEngineScriptD1Ev_ptr", "QWebEngineScript::~QWebEngineScript()"),
	mu_demangle_test("_ZN16ScriptingConsoleC1EP7QWidgetRK7QStringS4_N11BinaryNinja3RefINS5_17ScriptingInstanceEEE_ptr", "ScriptingConsole::ScriptingConsole(QWidget*, QString const&, QString const&, BinaryNinja::Ref<BinaryNinja::ScriptingInstance>)"),
	mu_demangle_test("_ZN16UIContextHandlerD2Ev_ptr", "UIContextHandler::~UIContextHandler()"),
	mu_demangle_test("_ZN17QAbstractItemView11resizeEventEP12QResizeEvent_ptr", "QAbstractItemView::resizeEvent(QResizeEvent*)"),
	mu_demangle_test("_ZN17QAbstractItemView11scrollToTopEv_ptr", "QAbstractItemView::scrollToTop()"),
	mu_demangle_test("_ZN17QAbstractItemView13keyPressEventEP9QKeyEvent_ptr", "QAbstractItemView::keyPressEvent(QKeyEvent*)"),
	mu_demangle_test("_ZN17QAbstractItemView14clearSelectionEv_ptr", "QAbstractItemView::clearSelection()"),
	mu_demangle_test("_ZN17QAbstractItemView15mousePressEventEP11QMouseEvent_ptr", "QAbstractItemView::mousePressEvent(QMouseEvent*)"),
	mu_demangle_test("_ZN17QAbstractItemView15setCurrentIndexERK11QModelIndex_ptr", "QAbstractItemView::setCurrentIndex(QModelIndex const&)"),
	mu_demangle_test("_ZN17QAbstractItemView15setEditTriggersE6QFlagsINS_11EditTriggerEE_ptr", "QAbstractItemView::setEditTriggers(QFlags<QAbstractItemView::EditTrigger>)"),
	mu_demangle_test("_ZN17QAbstractItemView15setItemDelegateEP21QAbstractItemDelegate_ptr", "QAbstractItemView::setItemDelegate(QAbstractItemDelegate*)"),
	mu_demangle_test("_ZN17QAbstractItemView16setSelectionModeENS_13SelectionModeE_ptr", "QAbstractItemView::setSelectionMode(QAbstractItemView::SelectionMode)"),
	mu_demangle_test("_ZN17QAbstractItemView20openPersistentEditorERK11QModelIndex_ptr", "QAbstractItemView::openPersistentEditor(QModelIndex const&)"),
	mu_demangle_test("_ZN17QAbstractItemView20setSelectionBehaviorENS_17SelectionBehaviorE_ptr", "QAbstractItemView::setSelectionBehavior(QAbstractItemView::SelectionBehavior)"),
	mu_demangle_test("_ZN17QAbstractItemView21closePersistentEditorERK11QModelIndex_ptr", "QAbstractItemView::closePersistentEditor(QModelIndex const&)"),
	mu_demangle_test("_ZN17QAbstractItemView21setVerticalScrollModeENS_10ScrollModeE_ptr", "QAbstractItemView::setVerticalScrollMode(QAbstractItemView::ScrollMode)"),
	mu_demangle_test("_ZN17QAbstractItemView23setHorizontalScrollModeENS_10ScrollModeE_ptr", "QAbstractItemView::setHorizontalScrollMode(QAbstractItemView::ScrollMode)"),
	mu_demangle_test("_ZN17QAbstractItemView4editERK11QModelIndex_ptr", "QAbstractItemView::edit(QModelIndex const&)"),
	mu_demangle_test("_ZN17QVariantAnimation11setDurationEi_ptr", "QVariantAnimation::setDuration(int)"),
	mu_demangle_test("_ZN17QVariantAnimation11setEndValueERK8QVariant_ptr", "QVariantAnimation::setEndValue(QVariant const&)"),
	mu_demangle_test("_ZN17QVariantAnimation13setStartValueERK8QVariant_ptr", "QVariantAnimation::setStartValue(QVariant const&)"),
	mu_demangle_test("_ZN17QVariantAnimation14setEasingCurveERK12QEasingCurve_ptr", "QVariantAnimation::setEasingCurve(QEasingCurve const&)"),
	mu_demangle_test("_ZN17QWebEngineProfile16setHttpCacheTypeENS_13HttpCacheTypeE_ptr", "QWebEngineProfile::setHttpCacheType(QWebEngineProfile::HttpCacheType)"),
	mu_demangle_test("_ZN18ContextMenuManager4showEP4MenuP15UIActionHandler_ptr", "ContextMenuManager::show(Menu*, UIActionHandler*)"),
	mu_demangle_test("_ZN18ContextMenuManager6createEv_ptr", "ContextMenuManager::create()"),
	mu_demangle_test("_ZN18ContextMenuManagerC1EP7QWidget_ptr", "ContextMenuManager::ContextMenuManager(QWidget*)"),
	mu_demangle_test("_ZN18ContextMenuManagerD1Ev_ptr", "ContextMenuManager::~ContextMenuManager()"),
	mu_demangle_test("_ZN18QAbstractAnimation12setDirectionENS_9DirectionE_ptr", "QAbstractAnimation::setDirection(QAbstractAnimation::Direction)"),
	mu_demangle_test("_ZN18QAbstractAnimation4stopEv_ptr", "QAbstractAnimation::stop()"),
	mu_demangle_test("_ZN18QAbstractAnimation5startENS_14DeletionPolicyE_ptr", "QAbstractAnimation::start(QAbstractAnimation::DeletionPolicy)"),
	mu_demangle_test("_ZN18QAbstractItemModel11dataChangedERK11QModelIndexS2_RK7QVectorIiE_ptr", "QAbstractItemModel::dataChanged(QModelIndex const&, QModelIndex const&, QVector<int> const&)"),
	mu_demangle_test("_ZN18QAbstractItemModel11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QAbstractItemModel::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN18QAbstractItemModel11qt_metacastEPKc_ptr", "QAbstractItemModel::qt_metacast(char const*)"),
	mu_demangle_test("_ZN18QAbstractItemModel13endResetModelEv_ptr", "QAbstractItemModel::endResetModel()"),
	mu_demangle_test("_ZN18QAbstractItemModel13layoutChangedERK5QListI21QPersistentModelIndexENS_16LayoutChangeHintE_ptr", "QAbstractItemModel::layoutChanged(QList<QPersistentModelIndex> const&, QAbstractItemModel::LayoutChangeHint)"),
	mu_demangle_test("_ZN18QAbstractItemModel15beginResetModelEv_ptr", "QAbstractItemModel::beginResetModel()"),
	mu_demangle_test("_ZN18QAbstractItemModel16staticMetaObjectE_ptr", "QAbstractItemModel::staticMetaObject"),
	mu_demangle_test("_ZN18QAbstractItemModel22layoutAboutToBeChangedERK5QListI21QPersistentModelIndexENS_16LayoutChangeHintE_ptr", "QAbstractItemModel::layoutAboutToBeChanged(QList<QPersistentModelIndex> const&, QAbstractItemModel::LayoutChangeHint)"),
	mu_demangle_test("_ZN18QAbstractItemModelC2EP7QObject_ptr", "QAbstractItemModel::QAbstractItemModel(QObject*)"),
	mu_demangle_test("_ZN18QAbstractItemModelD2Ev_ptr", "QAbstractItemModel::~QAbstractItemModel()"),
	mu_demangle_test("_ZN18QAbstractListModel11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QAbstractListModel::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN18QAbstractListModel11qt_metacastEPKc_ptr", "QAbstractListModel::qt_metacast(char const*)"),
	mu_demangle_test("_ZN18QAbstractListModelC2EP7QObject_ptr", "QAbstractListModel::QAbstractListModel(QObject*)"),
	mu_demangle_test("_ZN18QAbstractListModelD2Ev_ptr", "QAbstractListModel::~QAbstractListModel()"),
	mu_demangle_test("_ZN18QCommandLineOptionC1ERK11QStringListRK7QStringS5_S5__ptr", "QCommandLineOption::QCommandLineOption(QStringList const&, QString const&, QString const&, QString const&)"),
	mu_demangle_test("_ZN18QCommandLineOptionD1Ev_ptr", "QCommandLineOption::~QCommandLineOption()"),
	mu_demangle_test("_ZN18QCommandLineParser13addHelpOptionEv_ptr", "QCommandLineParser::addHelpOption()"),
	mu_demangle_test("_ZN18QCommandLineParser16addVersionOptionEv_ptr", "QCommandLineParser::addVersionOption()"),
	mu_demangle_test("_ZN18QCommandLineParser25setApplicationDescriptionERK7QString_ptr", "QCommandLineParser::setApplicationDescription(QString const&)"),
	mu_demangle_test("_ZN18QCommandLineParser7processERK16QCoreApplication_ptr", "QCommandLineParser::process(QCoreApplication const&)"),
	mu_demangle_test("_ZN18QCommandLineParser9addOptionERK18QCommandLineOption_ptr", "QCommandLineParser::addOption(QCommandLineOption const&)"),
	mu_demangle_test("_ZN18QCommandLineParserC1Ev_ptr", "QCommandLineParser::QCommandLineParser()"),
	mu_demangle_test("_ZN18QCommandLineParserD1Ev_ptr", "QCommandLineParser::~QCommandLineParser()"),
	mu_demangle_test("_ZN18QProgressIndicator14startAnimationEv_ptr", "QProgressIndicator::startAnimation()"),
	mu_demangle_test("_ZN18QProgressIndicator17setAnimationDelayEi_ptr", "QProgressIndicator::setAnimationDelay(int)"),
	mu_demangle_test("_ZN18QProgressIndicator8setColorERK6QColor_ptr", "QProgressIndicator::setColor(QColor const&)"),
	mu_demangle_test("_ZN18QProgressIndicatorC1EP7QWidget_ptr", "QProgressIndicator::QProgressIndicator(QWidget*)"),
	mu_demangle_test("_ZN18QPropertyAnimationC1EP7QObjectRK10QByteArrayS1__ptr", "QPropertyAnimation::QPropertyAnimation(QObject*, QByteArray const&, QObject*)"),
	mu_demangle_test("_ZN18QRegularExpression10setPatternERK7QString_ptr", "QRegularExpression::setPattern(QString const&)"),
	mu_demangle_test("_ZN18QRegularExpression17setPatternOptionsE6QFlagsINS_13PatternOptionEE_ptr", "QRegularExpression::setPatternOptions(QFlags<QRegularExpression::PatternOption>)"),
	mu_demangle_test("_ZN18QRegularExpressionC1ERK7QString6QFlagsINS_13PatternOptionEE_ptr", "QRegularExpression::QRegularExpression(QString const&, QFlags<QRegularExpression::PatternOption>)"),
	mu_demangle_test("_ZN18QRegularExpressionC1Ev_ptr", "QRegularExpression::QRegularExpression()"),
	mu_demangle_test("_ZN18QRegularExpressionD1Ev_ptr", "QRegularExpression::~QRegularExpression()"),
	mu_demangle_test("_ZN18QWebEngineSettings12setAttributeENS_12WebAttributeEb_ptr", "QWebEngineSettings::setAttribute(QWebEngineSettings::WebAttribute, bool)"),
	mu_demangle_test("_ZN19HighlightTokenStateC1Ev_ptr", "HighlightTokenState::HighlightTokenState()"),
	mu_demangle_test("_ZN19QAbstractScrollArea26setVerticalScrollBarPolicyEN2Qt15ScrollBarPolicyE_ptr", "QAbstractScrollArea::setVerticalScrollBarPolicy(Qt::ScrollBarPolicy)"),
	mu_demangle_test("_ZN19QAbstractScrollArea28setHorizontalScrollBarPolicyEN2Qt15ScrollBarPolicyE_ptr", "QAbstractScrollArea::setHorizontalScrollBarPolicy(Qt::ScrollBarPolicy)"),
	mu_demangle_test("_ZN19QAbstractTableModel11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QAbstractTableModel::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN19QAbstractTableModel11qt_metacastEPKc_ptr", "QAbstractTableModel::qt_metacast(char const*)"),
	mu_demangle_test("_ZN19QAbstractTableModelC2EP7QObject_ptr", "QAbstractTableModel::QAbstractTableModel(QObject*)"),
	mu_demangle_test("_ZN19QAbstractTableModelD2Ev_ptr", "QAbstractTableModel::~QAbstractTableModel()"),
	mu_demangle_test("_ZN19QStyledItemDelegate11eventFilterEP7QObjectP6QEvent_ptr", "QStyledItemDelegate::eventFilter(QObject*, QEvent*)"),
	mu_demangle_test("_ZN19QStyledItemDelegate11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QStyledItemDelegate::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN19QStyledItemDelegate11qt_metacastEPKc_ptr", "QStyledItemDelegate::qt_metacast(char const*)"),
	mu_demangle_test("_ZN19QStyledItemDelegateC2EP7QObject_ptr", "QStyledItemDelegate::QStyledItemDelegate(QObject*)"),
	mu_demangle_test("_ZN19QStyledItemDelegateD2Ev_ptr", "QStyledItemDelegate::~QStyledItemDelegate()"),
	mu_demangle_test("_ZN20CrossReferenceWidgetC1EP9ViewFrameN11BinaryNinja3RefINS2_10BinaryViewEEEb_ptr", "CrossReferenceWidget::CrossReferenceWidget(ViewFrame*, BinaryNinja::Ref<BinaryNinja::BinaryView>, bool)"),
	mu_demangle_test("_ZN21QAbstractItemDelegate10commitDataEP7QWidget_ptr", "QAbstractItemDelegate::commitData(QWidget*)"),
	mu_demangle_test("_ZN21QAbstractItemDelegate11closeEditorEP7QWidgetNS_11EndEditHintE_ptr", "QAbstractItemDelegate::closeEditor(QWidget*, QAbstractItemDelegate::EndEditHint)"),
	mu_demangle_test("_ZN21QNetworkAccessManager17sendCustomRequestERK15QNetworkRequestRK10QByteArrayP9QIODevice_ptr", "QNetworkAccessManager::sendCustomRequest(QNetworkRequest const&, QByteArray const&, QIODevice*)"),
	mu_demangle_test("_ZN21QNetworkAccessManager17setRedirectPolicyEN15QNetworkRequest14RedirectPolicyE_ptr", "QNetworkAccessManager::setRedirectPolicy(QNetworkRequest::RedirectPolicy)"),
	mu_demangle_test("_ZN21QNetworkAccessManager3getERK15QNetworkRequest_ptr", "QNetworkAccessManager::get(QNetworkRequest const&)"),
	mu_demangle_test("_ZN21QNetworkAccessManagerC1EP7QObject_ptr", "QNetworkAccessManager::QNetworkAccessManager(QObject*)"),
	mu_demangle_test("_ZN21QNetworkAccessManagerD1Ev_ptr", "QNetworkAccessManager::~QNetworkAccessManager()"),
	mu_demangle_test("_ZN21QPersistentModelIndexC1ERKS__ptr", "QPersistentModelIndex::QPersistentModelIndex(QPersistentModelIndex const&)"),
	mu_demangle_test("_ZN21QPersistentModelIndexD1Ev_ptr", "QPersistentModelIndex::~QPersistentModelIndex()"),
	mu_demangle_test("_ZN21QSortFilterProxyModel10invalidateEv_ptr", "QSortFilterProxyModel::invalidate()"),
	mu_demangle_test("_ZN21QSortFilterProxyModel11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QSortFilterProxyModel::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN21QSortFilterProxyModel11qt_metacastEPKc_ptr", "QSortFilterProxyModel::qt_metacast(char const*)"),
	mu_demangle_test("_ZN21QSortFilterProxyModel13setFilterRoleEi_ptr", "QSortFilterProxyModel::setFilterRole(int)"),
	mu_demangle_test("_ZN21QSortFilterProxyModel14setSourceModelEP18QAbstractItemModel_ptr", "QSortFilterProxyModel::setSourceModel(QAbstractItemModel*)"),
	mu_demangle_test("_ZN21QSortFilterProxyModel15setFilterRegExpERK7QRegExp_ptr", "QSortFilterProxyModel::setFilterRegExp(QRegExp const&)"),
	mu_demangle_test("_ZN21QSortFilterProxyModel16invalidateFilterEv_ptr", "QSortFilterProxyModel::invalidateFilter()"),
	mu_demangle_test("_ZN21QSortFilterProxyModel20setDynamicSortFilterEb_ptr", "QSortFilterProxyModel::setDynamicSortFilter(bool)"),
	mu_demangle_test("_ZN21QSortFilterProxyModel26setFilterRegularExpressionERK18QRegularExpression_ptr", "QSortFilterProxyModel::setFilterRegularExpression(QRegularExpression const&)"),
	mu_demangle_test("_ZN21QSortFilterProxyModel28setRecursiveFilteringEnabledEb_ptr", "QSortFilterProxyModel::setRecursiveFilteringEnabled(bool)"),
	mu_demangle_test("_ZN21QSortFilterProxyModelC2EP7QObject_ptr", "QSortFilterProxyModel::QSortFilterProxyModel(QObject*)"),
	mu_demangle_test("_ZN21QSortFilterProxyModelD2Ev_ptr", "QSortFilterProxyModel::~QSortFilterProxyModel()"),
	mu_demangle_test("_ZN22QGraphicsOpacityEffectC1EP7QObject_ptr", "QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject*)"),
	// INCORRECT : 	mu_demangle_test("_ZN22ReportCollectionWidgetC1EP7QWidgetN11BinaryNinja3RefINS2_16ReportCollectionEEERKNSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE_ptr", "ReportCollectionWidget::ReportCollectionWidget(QWidget*, BinaryNinja::Ref<BinaryNinja::ReportCollection>, std::string const&)"),
	mu_demangle_test("_ZN23QRegularExpressionMatchC1Ev_ptr", "QRegularExpressionMatch::QRegularExpressionMatch()"),
	mu_demangle_test("_ZN23QRegularExpressionMatchD1Ev_ptr", "QRegularExpressionMatch::~QRegularExpressionMatch()"),
	mu_demangle_test("_ZN26QWebEngineScriptCollection6insertERK16QWebEngineScript_ptr", "QWebEngineScriptCollection::insert(QWebEngineScript const&)"),
	mu_demangle_test("_ZN4Menu11setOrderingERK7QStringS2_h_ptr", "Menu::setOrdering(QString const&, QString const&, unsigned char)"),
	mu_demangle_test("_ZN4Menu12removeActionERK7QString_ptr", "Menu::removeAction(QString const&)"),
	mu_demangle_test("_ZN4Menu13setVisibilityERK7QString18MenuItemVisibility_ptr", "Menu::setVisibility(QString const&, MenuItemVisibility)"),
	mu_demangle_test("_ZN4Menu16addCopyAsActionsERK7QStringh_ptr", "Menu::addCopyAsActions(QString const&, unsigned char)"),
	mu_demangle_test("_ZN4Menu16setGroupOrderingERK7QStringh_ptr", "Menu::setGroupOrdering(QString const&, unsigned char)"),
	mu_demangle_test("_ZN4Menu16setMainMenuOrderERK7QStringh_ptr", "Menu::setMainMenuOrder(QString const&, unsigned char)"),
	mu_demangle_test("_ZN4Menu19addPasteFromActionsERK7QStringh_ptr", "Menu::addPasteFromActions(QString const&, unsigned char)"),
	mu_demangle_test("_ZN4Menu19addTransformActionsERK7QStringh_ptr", "Menu::addTransformActions(QString const&, unsigned char)"),
	mu_demangle_test("_ZN4Menu30addPluginCommandSubmenuActionsERK7QStringS2__ptr", "Menu::addPluginCommandSubmenuActions(QString const&, QString const&)"),
	mu_demangle_test("_ZN4Menu7setRoleERK7QStringN7QAction8MenuRoleE_ptr", "Menu::setRole(QString const&, QAction::MenuRole)"),
	mu_demangle_test("_ZN4Menu8mainMenuERK7QString_ptr", "Menu::mainMenu(QString const&)"),
	mu_demangle_test("_ZN4Menu9addActionERK7QStringS2_h_ptr", "Menu::addAction(QString const&, QString const&, unsigned char)"),
	mu_demangle_test("_ZN4Menu9addActionERK7QStringS2_S2_h_ptr", "Menu::addAction(QString const&, QString const&, QString const&, unsigned char)"),
	mu_demangle_test("_ZN4MenuC1Ev_ptr", "Menu::Menu()"),
	mu_demangle_test("_ZN4QDirC1ERK7QString_ptr", "QDir::QDir(QString const&)"),
	mu_demangle_test("_ZN4QDirD1Ev_ptr", "QDir::~QDir()"),
	mu_demangle_test("_ZN4QPenC1ERK6QBrushdN2Qt8PenStyleENS3_11PenCapStyleENS3_12PenJoinStyleE_ptr", "QPen::QPen(QBrush const&, double, Qt::PenStyle, Qt::PenCapStyle, Qt::PenJoinStyle)"),
	mu_demangle_test("_ZN4QPenC1ERK6QColor_ptr", "QPen::QPen(QColor const&)"),
	mu_demangle_test("_ZN4QPenD1Ev_ptr", "QPen::~QPen()"),
	mu_demangle_test("_ZN4QUrl13fromLocalFileERK7QString_ptr", "QUrl::fromLocalFile(QString const&)"),
	mu_demangle_test("_ZN4QUrl8setQueryERK7QStringNS_11ParsingModeE_ptr", "QUrl::setQuery(QString const&, QUrl::ParsingMode)"),
	mu_demangle_test("_ZN4QUrlC1ERK7QStringNS_11ParsingModeE_ptr", "QUrl::QUrl(QString const&, QUrl::ParsingMode)"),
	mu_demangle_test("_ZN4QUrlC1ERKS__ptr", "QUrl::QUrl(QUrl const&)"),
	mu_demangle_test("_ZN4QUrlD1Ev_ptr", "QUrl::~QUrl()"),
	mu_demangle_test("_ZN4View17getViewFromWidgetEP7QWidget_ptr", "View::getViewFromWidget(QWidget*)"),
	mu_demangle_test("_ZN4View22getDisassemblySettingsEv_ptr", "View::getDisassemblySettings()"),
	mu_demangle_test("_ZN5QFile4copyERK7QString_ptr", "QFile::copy(QString const&)"),
	mu_demangle_test("_ZN5QFile4openE6QFlagsIN9QIODevice12OpenModeFlagEE_ptr", "QFile::open(QFlags<QIODevice::OpenModeFlag>)"),
	mu_demangle_test("_ZN5QFile6existsERK7QString_ptr", "QFile::exists(QString const&)"),
	mu_demangle_test("_ZN5QFile6removeERK7QString_ptr", "QFile::remove(QString const&)"),
	mu_demangle_test("_ZN5QFileC1ERK7QString_ptr", "QFile::QFile(QString const&)"),
	mu_demangle_test("_ZN5QFileD1Ev_ptr", "QFile::~QFile()"),
	mu_demangle_test("_ZN5QFont12setPointSizeEi_ptr", "QFont::setPointSize(int)"),
	mu_demangle_test("_ZN5QFont12setStyleNameERK7QString_ptr", "QFont::setStyleName(QString const&)"),
	mu_demangle_test("_ZN5QFont9setWeightEi_ptr", "QFont::setWeight(int)"),
	mu_demangle_test("_ZN5QFontC1ERK7QStringiib_ptr", "QFont::QFont(QString const&, int, int, bool)"),
	mu_demangle_test("_ZN5QFontC1ERKS__ptr", "QFont::QFont(QFont const&)"),
	mu_demangle_test("_ZN5QFontC1Ev_ptr", "QFont::QFont()"),
	mu_demangle_test("_ZN5QFontD1Ev_ptr", "QFont::~QFont()"),
	mu_demangle_test("_ZN5QIconC1ERK7QString_ptr", "QIcon::QIcon(QString const&)"),
	mu_demangle_test("_ZN5QIconC1Ev_ptr", "QIcon::QIcon()"),
	mu_demangle_test("_ZN5QIconD1Ev_ptr", "QIcon::~QIcon()"),
	mu_demangle_test("_ZN5QListIP13QOpenGLShaderED2Ev_47_0", "QList<QOpenGLShader*>::~QList()"),
	mu_demangle_test("_ZN5QMenu12addSeparatorEv_ptr", "QMenu::addSeparator()"),
	mu_demangle_test("_ZN5QMenu4execERK6QPointP7QAction_ptr", "QMenu::exec(QPoint const&, QAction*)"),
	mu_demangle_test("_ZN5QMenu5popupERK6QPointP7QAction_ptr", "QMenu::popup(QPoint const&, QAction*)"),
	mu_demangle_test("_ZN5QMenuC1EP7QWidget_ptr", "QMenu::QMenu(QWidget*)"),
	mu_demangle_test("_ZN6QBrushC1ERK6QColorN2Qt10BrushStyleE_ptr", "QBrush::QBrush(QColor const&, Qt::BrushStyle)"),
	mu_demangle_test("_ZN6QBrushD1Ev_ptr", "QBrush::~QBrush()"),
	mu_demangle_test("_ZN6QColor13setNamedColorERK7QString_ptr", "QColor::setNamedColor(QString const&)"),
	mu_demangle_test("_ZN6QColor6setRgbEiiii_ptr", "QColor::setRgb(int, int, int, int)"),
	mu_demangle_test("_ZN6QColor8setAlphaEi_ptr", "QColor::setAlpha(int)"),
	mu_demangle_test("_ZN6QColoraSERKS__ptr", "QColor::operator=(QColor const&)"),
	mu_demangle_test("_ZN6QEvent17registerEventTypeEi_ptr", "QEvent::registerEventType(int)"),
	mu_demangle_test("_ZN6QEventC1ENS_4TypeE_ptr", "QEvent::QEvent(QEvent::Type)"),
	mu_demangle_test("_ZN6QEventC2ENS_4TypeE_ptr", "QEvent::QEvent(QEvent::Type)"),
	mu_demangle_test("_ZN6QEventD2Ev_ptr", "QEvent::~QEvent()"),
	mu_demangle_test("_ZN6QFrame11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QFrame::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN6QFrame11qt_metacastEPKc_ptr", "QFrame::qt_metacast(char const*)"),
	mu_demangle_test("_ZN6QFrame13setFrameShapeENS_5ShapeE_ptr", "QFrame::setFrameShape(QFrame::Shape)"),
	mu_demangle_test("_ZN6QFrame13setFrameStyleEi_ptr", "QFrame::setFrameStyle(int)"),
	mu_demangle_test("_ZN6QFrame14setFrameShadowENS_6ShadowE_ptr", "QFrame::setFrameShadow(QFrame::Shadow)"),
	mu_demangle_test("_ZN6QFrameC1EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QFrame::QFrame(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN6QFrameC2EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QFrame::QFrame(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN6QFrameD2Ev_ptr", "QFrame::~QFrame()"),
	mu_demangle_test("_ZN6QLabel10setPictureERK8QPicture_ptr", "QLabel::setPicture(QPicture const&)"),
	mu_demangle_test("_ZN6QLabel11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QLabel::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN6QLabel11qt_metacastEPKc_ptr", "QLabel::qt_metacast(char const*)"),
	mu_demangle_test("_ZN6QLabel11setWordWrapEb_ptr", "QLabel::setWordWrap(bool)"),
	mu_demangle_test("_ZN6QLabel12setAlignmentE6QFlagsIN2Qt13AlignmentFlagEE_ptr", "QLabel::setAlignment(QFlags<Qt::AlignmentFlag>)"),
	mu_demangle_test("_ZN6QLabel13linkActivatedERK7QString_ptr", "QLabel::linkActivated(QString const&)"),
	mu_demangle_test("_ZN6QLabel13setTextFormatEN2Qt10TextFormatE_ptr", "QLabel::setTextFormat(Qt::TextFormat)"),
	mu_demangle_test("_ZN6QLabel16staticMetaObjectE_ptr", "QLabel::staticMetaObject"),
	mu_demangle_test("_ZN6QLabel20setOpenExternalLinksEb_ptr", "QLabel::setOpenExternalLinks(bool)"),
	mu_demangle_test("_ZN6QLabel23setTextInteractionFlagsE6QFlagsIN2Qt19TextInteractionFlagEE_ptr", "QLabel::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag>)"),
	mu_demangle_test("_ZN6QLabel7setTextERK7QString_ptr", "QLabel::setText(QString const&)"),
	mu_demangle_test("_ZN6QLabel9setPixmapERK7QPixmap_ptr", "QLabel::setPixmap(QPixmap const&)"),
	mu_demangle_test("_ZN6QLabelC1EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QLabel::QLabel(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN6QLabelC1ERK7QStringP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QLabel::QLabel(QString const&, QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN6QLabelC2EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QLabel::QLabel(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN6QLabelC2ERK7QStringP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QLabel::QLabel(QString const&, QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN6QLabelD2Ev_ptr", "QLabel::~QLabel()"),
	mu_demangle_test("_ZN6QStyle11alignedRectEN2Qt15LayoutDirectionE6QFlagsINS0_13AlignmentFlagEERK5QSizeRK5QRect_ptr", "QStyle::alignedRect(Qt::LayoutDirection, QFlags<Qt::AlignmentFlag>, QSize const&, QRect const&)"),
	mu_demangle_test("_ZN6QTimer10singleShotEiPK7QObjectPKc_ptr", "QTimer::singleShot(int, QObject const*, char const*)"),
	mu_demangle_test("_ZN6QTimer11setIntervalEi_ptr", "QTimer::setInterval(int)"),
	mu_demangle_test("_ZN6QTimer14singleShotImplEiN2Qt9TimerTypeEPK7QObjectPN9QtPrivate15QSlotObjectBaseE_ptr", "QTimer::singleShotImpl(int, Qt::TimerType, QObject const*, QtPrivate::QSlotObjectBase*)"),
	mu_demangle_test("_ZN6QTimer16staticMetaObjectE_ptr", "QTimer::staticMetaObject"),
	mu_demangle_test("_ZN6QTimer4stopEv_ptr", "QTimer::stop()"),
	mu_demangle_test("_ZN6QTimer5startEi_ptr", "QTimer::start(int)"),
	mu_demangle_test("_ZN6QTimer5startEv_ptr", "QTimer::start()"),
	mu_demangle_test("_ZN6QTimer7timeoutENS_14QPrivateSignalE_ptr", "QTimer::timeout(QTimer::QPrivateSignal)"),
	mu_demangle_test("_ZN6QTimerC1EP7QObject_ptr", "QTimer::QTimer(QObject*)"),
	mu_demangle_test("_ZN7LogView10SetLogSizeEm_ptr", "LogView::SetLogSize(unsigned long)"),
	mu_demangle_test("_ZN7LogView11SetLogLevelE10BNLogLevel_ptr", "LogView::SetLogLevel(BNLogLevel)"),
	mu_demangle_test("_ZN7LogViewC1EP7QWidgetP9LogStatus_ptr", "LogView::LogView(QWidget*, LogStatus*)"),
	mu_demangle_test("_ZN7QAction10setCheckedEb_ptr", "QAction::setChecked(bool)"),
	mu_demangle_test("_ZN7QAction10setEnabledEb_ptr", "QAction::setEnabled(bool)"),
	mu_demangle_test("_ZN7QAction12setCheckableEb_ptr", "QAction::setCheckable(bool)"),
	mu_demangle_test("_ZN7QAction16staticMetaObjectE_ptr", "QAction::staticMetaObject"),
	mu_demangle_test("_ZN7QAction7setDataERK8QVariant_ptr", "QAction::setData(QVariant const&)"),
	mu_demangle_test("_ZN7QAction9triggeredEb_ptr", "QAction::triggered(bool)"),
	mu_demangle_test("_ZN7QActionC1ERK7QStringP7QObject_ptr", "QAction::QAction(QString const&, QObject*)"),
	mu_demangle_test("_ZN7QCursor3posEv_ptr", "QCursor::pos()"),
	mu_demangle_test("_ZN7QDialog11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QDialog::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN7QDialog11qt_metacastEPKc_ptr", "QDialog::qt_metacast(char const*)"),
	mu_demangle_test("_ZN7QDialog16staticMetaObjectE_ptr", "QDialog::staticMetaObject"),
	mu_demangle_test("_ZN7QDialog4doneEi_ptr", "QDialog::done(int)"),
	mu_demangle_test("_ZN7QDialog4execEv_ptr", "QDialog::exec()"),
	mu_demangle_test("_ZN7QDialog6acceptEv_ptr", "QDialog::accept()"),
	mu_demangle_test("_ZN7QDialog8setModalEb_ptr", "QDialog::setModal(bool)"),
	mu_demangle_test("_ZN7QDialogC2EP7QWidget6QFlagsIN2Qt10WindowTypeEE_ptr", "QDialog::QDialog(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN7QDialogD2Ev_ptr", "QDialog::~QDialog()"),
	mu_demangle_test("_ZN7QLayout17setSizeConstraintENS_14SizeConstraintE_ptr", "QLayout::setSizeConstraint(QLayout::SizeConstraint)"),
	mu_demangle_test("_ZN7QLayout18setContentsMarginsEiiii_ptr", "QLayout::setContentsMargins(int, int, int, int)"),
	mu_demangle_test("_ZN7QLayout18setContentsMarginsERK8QMargins_ptr", "QLayout::setContentsMargins(QMargins const&)"),
	mu_demangle_test("_ZN7QLayout9addWidgetEP7QWidget_ptr", "QLayout::addWidget(QWidget*)"),
	mu_demangle_test("_ZN7QLocale6systemEv_ptr", "QLocale::system()"),
	mu_demangle_test("_ZN7QLocaleC1Ev_ptr", "QLocale::QLocale()"),
	mu_demangle_test("_ZN7QLocaleD1Ev_ptr", "QLocale::~QLocale()"),
	mu_demangle_test("_ZN7QObject11connectImplEPKS_PPvS1_S3_PN9QtPrivate15QSlotObjectBaseEN2Qt14ConnectionTypeEPKiPK11QMetaObject_ptr", "QObject::connectImpl(QObject const*, void**, QObject const*, void**, QtPrivate::QSlotObjectBase*, Qt::ConnectionType, int const*, QMetaObject const*)"),
	mu_demangle_test("_ZN7QObject11deleteLaterEv_ptr", "QObject::deleteLater()"),
	mu_demangle_test("_ZN7QObject11eventFilterEPS_P6QEvent_ptr", "QObject::eventFilter(QObject*, QEvent*)"),
	mu_demangle_test("_ZN7QObject11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QObject::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN7QObject11qt_metacastEPKc_ptr", "QObject::qt_metacast(char const*)"),
	mu_demangle_test("_ZN7QObject12blockSignalsEb_ptr", "QObject::blockSignals(bool)"),
	mu_demangle_test("_ZN7QObject18installEventFilterEPS__ptr", "QObject::installEventFilter(QObject*)"),
	mu_demangle_test("_ZN7QObject7connectEPKS_PKcS1_S3_N2Qt14ConnectionTypeE_ptr", "QObject::connect(QObject const*, char const*, QObject const*, char const*, Qt::ConnectionType)"),
	mu_demangle_test("_ZN7QObjectC2EPS__ptr", "QObject::QObject(QObject*)"),
	mu_demangle_test("_ZN7QObjectD2Ev_ptr", "QObject::~QObject()"),
	mu_demangle_test("_ZN7QPixmap4fillERK6QColor_ptr", "QPixmap::fill(QColor const&)"),
	mu_demangle_test("_ZN7QPixmapC1Eii_ptr", "QPixmap::QPixmap(int, int)"),
	mu_demangle_test("_ZN7QPixmapC1ERK7QStringPKc6QFlagsIN2Qt19ImageConversionFlagEE_ptr", "QPixmap::QPixmap(QString const&, char const*, QFlags<Qt::ImageConversionFlag>)"),
	mu_demangle_test("_ZN7QPixmapD1Ev_ptr", "QPixmap::~QPixmap()"),
	mu_demangle_test("_ZN7QRegExpC1ERK7QStringN2Qt15CaseSensitivityENS_13PatternSyntaxE_ptr", "QRegExp::QRegExp(QString const&, Qt::CaseSensitivity, QRegExp::PatternSyntax)"),
	mu_demangle_test("_ZN7QRegExpD1Ev_ptr", "QRegExp::~QRegExp()"),
	mu_demangle_test("_ZN7QString11reallocDataEjb_ptr", "QString::reallocData(unsigned int, bool)"),
	mu_demangle_test("_ZN7QString13toUtf8_helperERKS__ptr", "QString::toUtf8_helper(QString const&)"),
	mu_demangle_test("_ZN7QString14compare_helperEPK5QChariPKciN2Qt15CaseSensitivityE_ptr", "QString::compare_helper(QChar const*, int, char const*, int, Qt::CaseSensitivity)"),
	mu_demangle_test("_ZN7QString14trimmed_helperERKS__ptr", "QString::trimmed_helper(QString const&)"),
	mu_demangle_test("_ZN7QString14trimmed_helperERS__ptr", "QString::trimmed_helper(QString&)"),
	mu_demangle_test("_ZN7QString15fromUtf8_helperEPKci_ptr", "QString::fromUtf8_helper(char const*, int)"),
	mu_demangle_test("_ZN7QString16fromAscii_helperEPKci_ptr", "QString::fromAscii_helper(char const*, int)"),
	mu_demangle_test("_ZN7QString17fromLatin1_helperEPKci_ptr", "QString::fromLatin1_helper(char const*, int)"),
	mu_demangle_test("_ZN7QString17simplified_helperERKS__ptr", "QString::simplified_helper(QString const&)"),
	mu_demangle_test("_ZN7QString20fromLocal8Bit_helperEPKci_ptr", "QString::fromLocal8Bit_helper(char const*, int)"),
	mu_demangle_test("_ZN7QString4chopEi_ptr", "QString::chop(int)"),
	mu_demangle_test("_ZN7QString6appendERKS__ptr", "QString::append(QString const&)"),
	mu_demangle_test("_ZN7QString6numberEii_ptr", "QString::number(int, int)"),
	mu_demangle_test("_ZN7QString6numberEmi_ptr", "QString::number(unsigned long, int)"),
	mu_demangle_test("_ZN7QString7replaceERK18QRegularExpressionRKS__ptr", "QString::replace(QRegularExpression const&, QString const&)"),
	mu_demangle_test("_ZN7QString7replaceERKS_S1_N2Qt15CaseSensitivityE_ptr", "QString::replace(QString const&, QString const&, Qt::CaseSensitivity)"),
	mu_demangle_test("_ZN7QStringaSERKS__ptr", "QString::operator=(QString const&)"),
	mu_demangle_test("_ZN7QTabBar11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QTabBar::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN7QTabBar11qt_metacastEPKc_ptr", "QTabBar::qt_metacast(char const*)"),
	mu_demangle_test("_ZN7QTabBar13setTabToolTipEiRK7QString_ptr", "QTabBar::setTabToolTip(int, QString const&)"),
	mu_demangle_test("_ZN7QTabBar17mouseReleaseEventEP11QMouseEvent_ptr", "QTabBar::mouseReleaseEvent(QMouseEvent*)"),
	mu_demangle_test("_ZN7QTabBar17tabCloseRequestedEi_ptr", "QTabBar::tabCloseRequested(int)"),
	mu_demangle_test("_ZN7QTabBarC2EP7QWidget_ptr", "QTabBar::QTabBar(QWidget*)"),
	mu_demangle_test("_ZN7QTabBarD2Ev_ptr", "QTabBar::~QTabBar()"),
	mu_demangle_test("_ZN7QThread11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QThread::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN7QThread11qt_metacastEPKc_ptr", "QThread::qt_metacast(char const*)"),
	mu_demangle_test("_ZN7QThread13currentThreadEv_ptr", "QThread::currentThread()"),
	mu_demangle_test("_ZN7QThread19requestInterruptionEv_ptr", "QThread::requestInterruption()"),
	mu_demangle_test("_ZN7QThread4waitE14QDeadlineTimer_ptr", "QThread::wait(QDeadlineTimer)"),
	mu_demangle_test("_ZN7QThread5startENS_8PriorityE_ptr", "QThread::start(QThread::Priority)"),
	mu_demangle_test("_ZN7QThread6msleepEm_ptr", "QThread::msleep(unsigned long)"),
	mu_demangle_test("_ZN7QThreadC2EP7QObject_ptr", "QThread::QThread(QObject*)"),
	mu_demangle_test("_ZN7QThreadD2Ev_ptr", "QThread::~QThread()"),
	mu_demangle_test("_ZN7QWidget10clearFocusEv_ptr", "QWidget::clearFocus()"),
	mu_demangle_test("_ZN7QWidget10enterEventEP6QEvent_ptr", "QWidget::enterEvent(QEvent*)"),
	mu_demangle_test("_ZN7QWidget10leaveEventEP6QEvent_ptr", "QWidget::leaveEvent(QEvent*)"),
	mu_demangle_test("_ZN7QWidget10setEnabledEb_ptr", "QWidget::setEnabled(bool)"),
	mu_demangle_test("_ZN7QWidget10setPaletteERK8QPalette_ptr", "QWidget::setPalette(QPalette const&)"),
	mu_demangle_test("_ZN7QWidget10setToolTipERK7QString_ptr", "QWidget::setToolTip(QString const&)"),
	mu_demangle_test("_ZN7QWidget11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QWidget::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN7QWidget11qt_metacastEPKc_ptr", "QWidget::qt_metacast(char const*)"),
	mu_demangle_test("_ZN7QWidget11resizeEventEP12QResizeEvent_ptr", "QWidget::resizeEvent(QResizeEvent*)"),
	mu_demangle_test("_ZN7QWidget11setDisabledEb_ptr", "QWidget::setDisabled(bool)"),
	mu_demangle_test("_ZN7QWidget11setGeometryERK5QRect_ptr", "QWidget::setGeometry(QRect const&)"),
	mu_demangle_test("_ZN7QWidget12setAttributeEN2Qt15WidgetAttributeEb_ptr", "QWidget::setAttribute(Qt::WidgetAttribute, bool)"),
	mu_demangle_test("_ZN7QWidget12setFixedSizeEii_ptr", "QWidget::setFixedSize(int, int)"),
	mu_demangle_test("_ZN7QWidget13keyPressEventEP9QKeyEvent_ptr", "QWidget::keyPressEvent(QKeyEvent*)"),
	mu_demangle_test("_ZN7QWidget13setFixedWidthEi_ptr", "QWidget::setFixedWidth(int)"),
	mu_demangle_test("_ZN7QWidget13setSizePolicyE11QSizePolicy_ptr", "QWidget::setSizePolicy(QSizePolicy)"),
	mu_demangle_test("_ZN7QWidget13setStyleSheetERK7QString_ptr", "QWidget::setStyleSheet(QString const&)"),
	mu_demangle_test("_ZN7QWidget13setWindowIconERK5QIcon_ptr", "QWidget::setWindowIcon(QIcon const&)"),
	mu_demangle_test("_ZN7QWidget14activateWindowEv_ptr", "QWidget::activateWindow()"),
	mu_demangle_test("_ZN7QWidget14setAcceptDropsEb_ptr", "QWidget::setAcceptDrops(bool)"),
	mu_demangle_test("_ZN7QWidget14setFocusPolicyEN2Qt11FocusPolicyE_ptr", "QWidget::setFocusPolicy(Qt::FocusPolicy)"),
	mu_demangle_test("_ZN7QWidget14setMaximumSizeEii_ptr", "QWidget::setMaximumSize(int, int)"),
	mu_demangle_test("_ZN7QWidget14setMinimumSizeEii_ptr", "QWidget::setMinimumSize(int, int)"),
	mu_demangle_test("_ZN7QWidget14setWindowFlagsE6QFlagsIN2Qt10WindowTypeEE_ptr", "QWidget::setWindowFlags(QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN7QWidget14setWindowTitleERK7QString_ptr", "QWidget::setWindowTitle(QString const&)"),
	mu_demangle_test("_ZN7QWidget14updateGeometryEv_ptr", "QWidget::updateGeometry()"),
	mu_demangle_test("_ZN7QWidget15restoreGeometryERK10QByteArray_ptr", "QWidget::restoreGeometry(QByteArray const&)"),
	mu_demangle_test("_ZN7QWidget15setMinimumWidthEi_ptr", "QWidget::setMinimumWidth(int)"),
	mu_demangle_test("_ZN7QWidget16setMaximumHeightEi_ptr", "QWidget::setMaximumHeight(int)"),
	mu_demangle_test("_ZN7QWidget16staticMetaObjectE_ptr", "QWidget::staticMetaObject"),
	mu_demangle_test("_ZN7QWidget17setForegroundRoleEN8QPalette9ColorRoleE_ptr", "QWidget::setForegroundRole(QPalette::ColorRole)"),
	mu_demangle_test("_ZN7QWidget17setGraphicsEffectEP15QGraphicsEffect_ptr", "QWidget::setGraphicsEffect(QGraphicsEffect*)"),
	mu_demangle_test("_ZN7QWidget17setWindowFilePathERK7QString_ptr", "QWidget::setWindowFilePath(QString const&)"),
	mu_demangle_test("_ZN7QWidget17setWindowModalityEN2Qt14WindowModalityE_ptr", "QWidget::setWindowModality(Qt::WindowModality)"),
	mu_demangle_test("_ZN7QWidget18setContentsMarginsEiiii_ptr", "QWidget::setContentsMargins(int, int, int, int)"),
	mu_demangle_test("_ZN7QWidget20setContextMenuPolicyEN2Qt17ContextMenuPolicyE_ptr", "QWidget::setContextMenuPolicy(Qt::ContextMenuPolicy)"),
	mu_demangle_test("_ZN7QWidget21setAutoFillBackgroundEb_ptr", "QWidget::setAutoFillBackground(bool)"),
	mu_demangle_test("_ZN7QWidget4hideEv_ptr", "QWidget::hide()"),
	mu_demangle_test("_ZN7QWidget4moveERK6QPoint_ptr", "QWidget::move(QPoint const&)"),
	mu_demangle_test("_ZN7QWidget4showEv_ptr", "QWidget::show()"),
	mu_demangle_test("_ZN7QWidget5closeEv_ptr", "QWidget::close()"),
	mu_demangle_test("_ZN7QWidget5eventEP6QEvent_ptr", "QWidget::event(QEvent*)"),
	mu_demangle_test("_ZN7QWidget5raiseEv_ptr", "QWidget::raise()"),
	mu_demangle_test("_ZN7QWidget6resizeERK5QSize_ptr", "QWidget::resize(QSize const&)"),
	mu_demangle_test("_ZN7QWidget6updateEv_ptr", "QWidget::update()"),
	mu_demangle_test("_ZN7QWidget7setFontERK5QFont_ptr", "QWidget::setFont(QFont const&)"),
	mu_demangle_test("_ZN7QWidget8setFocusEN2Qt11FocusReasonE_ptr", "QWidget::setFocus(Qt::FocusReason)"),
	mu_demangle_test("_ZN7QWidget9addActionEP7QAction_ptr", "QWidget::addAction(QAction*)"),
	mu_demangle_test("_ZN7QWidget9hideEventEP10QHideEvent_ptr", "QWidget::hideEvent(QHideEvent*)"),
	mu_demangle_test("_ZN7QWidget9setLayoutEP7QLayout_ptr", "QWidget::setLayout(QLayout*)"),
	mu_demangle_test("_ZN7QWidget9setParentEPS__ptr", "QWidget::setParent(QWidget*)"),
	mu_demangle_test("_ZN7QWidgetC1EPS_6QFlagsIN2Qt10WindowTypeEE_ptr", "QWidget::QWidget(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN7QWidgetC2EPS_6QFlagsIN2Qt10WindowTypeEE_ptr", "QWidget::QWidget(QWidget*, QFlags<Qt::WindowType>)"),
	mu_demangle_test("_ZN7QWidgetD2Ev_ptr", "QWidget::~QWidget()"),
	mu_demangle_test("_ZN8QPainter10drawPixmapERK6QRectFRK7QPixmapS2__ptr", "QPainter::drawPixmap(QRectF const&, QPixmap const&, QRectF const&)"),
	mu_demangle_test("_ZN8QPainter13setRenderHintENS_10RenderHintEb_ptr", "QPainter::setRenderHint(QPainter::RenderHint, bool)"),
	mu_demangle_test("_ZN8QPainter3endEv_ptr", "QPainter::end()"),
	mu_demangle_test("_ZN8QPainter4saveEv_ptr", "QPainter::save()"),
	mu_demangle_test("_ZN8QPainter5beginEP12QPaintDevice_ptr", "QPainter::begin(QPaintDevice*)"),
	mu_demangle_test("_ZN8QPainter6setPenEN2Qt8PenStyleE_ptr", "QPainter::setPen(Qt::PenStyle)"),
	mu_demangle_test("_ZN8QPainter6setPenERK4QPen_ptr", "QPainter::setPen(QPen const&)"),
	mu_demangle_test("_ZN8QPainter6setPenERK6QColor_ptr", "QPainter::setPen(QColor const&)"),
	mu_demangle_test("_ZN8QPainter7restoreEv_ptr", "QPainter::restore()"),
	mu_demangle_test("_ZN8QPainter7setFontERK5QFont_ptr", "QPainter::setFont(QFont const&)"),
	mu_demangle_test("_ZN8QPainter8drawTextERK5QRectiRK7QStringPS0__ptr", "QPainter::drawText(QRect const&, int, QString const&, QRect*)"),
	mu_demangle_test("_ZN8QPainter8drawTextERK7QPointFRK7QString_ptr", "QPainter::drawText(QPointF const&, QString const&)"),
	mu_demangle_test("_ZN8QPainter8fillRectERK5QRectRK6QColor_ptr", "QPainter::fillRect(QRect const&, QColor const&)"),
	mu_demangle_test("_ZN8QPainter8setBrushERK6QBrush_ptr", "QPainter::setBrush(QBrush const&)"),
	mu_demangle_test("_ZN8QPainter9drawLinesEPK5QLinei_ptr", "QPainter::drawLines(QLine const*, int)"),
	mu_demangle_test("_ZN8QPainter9drawRectsEPK5QRecti_ptr", "QPainter::drawRects(QRect const*, int)"),
	mu_demangle_test("_ZN8QPainterC1EP12QPaintDevice_ptr", "QPainter::QPainter(QPaintDevice*)"),
	mu_demangle_test("_ZN8QPainterC1Ev_ptr", "QPainter::QPainter()"),
	mu_demangle_test("_ZN8QPainterD1Ev_ptr", "QPainter::~QPainter()"),
	mu_demangle_test("_ZN8QPalette8setBrushENS_10ColorGroupENS_9ColorRoleERK6QBrush_ptr", "QPalette::setBrush(QPalette::ColorGroup, QPalette::ColorRole, QBrush const&)"),
	mu_demangle_test("_ZN8QPaletteC1ERKS__ptr", "QPalette::QPalette(QPalette const&)"),
	mu_demangle_test("_ZN8QPaletteD1Ev_ptr", "QPalette::~QPalette()"),
	mu_demangle_test("_ZN8QPictureC1Ei_ptr", "QPicture::QPicture(int)"),
	mu_demangle_test("_ZN8QPictureD1Ev_ptr", "QPicture::~QPicture()"),
	mu_demangle_test("_ZN8QProcess13startDetachedERK7QStringRK11QStringList_ptr", "QProcess::startDetached(QString const&, QStringList const&)"),
	mu_demangle_test("_ZN8QSpinBox10setMaximumEi_ptr", "QSpinBox::setMaximum(int)"),
	mu_demangle_test("_ZN8QSpinBox10setMinimumEi_ptr", "QSpinBox::setMinimum(int)"),
	mu_demangle_test("_ZN8QSpinBox8setValueEi_ptr", "QSpinBox::setValue(int)"),
	mu_demangle_test("_ZN8QSpinBoxC1EP7QWidget_ptr", "QSpinBox::QSpinBox(QWidget*)"),
	mu_demangle_test("_ZN8QSysInfo17prettyProductNameEv_ptr", "QSysInfo::prettyProductName()"),
	mu_demangle_test("_ZN8QToolBar10setMovableEb_ptr", "QToolBar::setMovable(bool)"),
	mu_demangle_test("_ZN8QToolBar11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QToolBar::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN8QToolBar11qt_metacastEPKc_ptr", "QToolBar::qt_metacast(char const*)"),
	mu_demangle_test("_ZN8QToolBarC2ERK7QStringP7QWidget_ptr", "QToolBar::QToolBar(QString const&, QWidget*)"),
	mu_demangle_test("_ZN8QToolBarD2Ev_ptr", "QToolBar::~QToolBar()"),
	mu_demangle_test("_ZN8QToolTip8showTextERK6QPointRK7QStringP7QWidget_ptr", "QToolTip::showText(QPoint const&, QString const&, QWidget*)"),
	mu_demangle_test("_ZN8QVariantC1Eb_ptr", "QVariant::QVariant(bool)"),
	mu_demangle_test("_ZN8QVariantC1Ei_ptr", "QVariant::QVariant(int)"),
	mu_demangle_test("_ZN8QVariantC1EiPKvj_ptr", "QVariant::QVariant(int, void const*, unsigned int)"),
	mu_demangle_test("_ZN8QVariantC1EPKc_ptr", "QVariant::QVariant(char const*)"),
	mu_demangle_test("_ZN8QVariantC1ERK10QByteArray_ptr", "QVariant::QVariant(QByteArray const&)"),
	mu_demangle_test("_ZN8QVariantC1ERK5QListIS_E_ptr", "QVariant::QVariant(QList<QVariant> const&)"),
	mu_demangle_test("_ZN8QVariantC1ERK7QString_ptr", "QVariant::QVariant(QString const&)"),
	mu_demangle_test("_ZN8QVariantC1ERKS__ptr", "QVariant::QVariant(QVariant const&)"),
	mu_demangle_test("_ZN8QVariantD1Ev_ptr", "QVariant::~QVariant()"),
	mu_demangle_test("_ZN8UIAction13getKeyBindingERK7QString_ptr", "UIAction::getKeyBinding(QString const&)"),
	mu_demangle_test("_ZN8UIAction14registerActionERK7QStringRK12QKeySequence_ptr", "UIAction::registerAction(QString const&, QKeySequence const&)"),
	mu_demangle_test("_ZN8UIAction14registerActionERK7QStringRK5QListI12QKeySequenceE_ptr", "UIAction::registerAction(QString const&, QList<QKeySequence> const&)"),
	mu_demangle_test("_ZN8UIAction16unregisterActionERK7QString_ptr", "UIAction::unregisterAction(QString const&)"),
	mu_demangle_test("_ZN8UIAction17setUserKeyBindingERK7QStringRK5QListI12QKeySequenceE_ptr", "UIAction::setUserKeyBinding(QString const&, QList<QKeySequence> const&)"),
	mu_demangle_test("_ZN8UIAction19readKeyBindingsFileEv_ptr", "UIAction::readKeyBindingsFile()"),
	mu_demangle_test("_ZN8UIAction20getActionDisplayNameERK7QStringRK15UIActionContext_ptr", "UIAction::getActionDisplayName(QString const&, UIActionContext const&)"),
	mu_demangle_test("_ZN8UIAction20getDefaultKeyBindingERK7QString_ptr", "UIAction::getDefaultKeyBinding(QString const&)"),
	mu_demangle_test("_ZN8UIAction20setActionDisplayNameERK7QStringRKSt8functionIFS0_vEE_ptr", "UIAction::setActionDisplayName(QString const&, std::function<QString ()> const&)"),
	mu_demangle_test("_ZN8UIAction20writeKeyBindingsFileEv_ptr", "UIAction::writeKeyBindingsFile()"),
	mu_demangle_test("_ZN8UIAction23getAllRegisteredActionsEv_ptr", "UIAction::getAllRegisteredActions()"),
	mu_demangle_test("_ZN8UIAction24registerTransformActionsEv_ptr", "UIAction::registerTransformActions()"),
	mu_demangle_test("_ZN8UIAction24resetKeyBindingToDefaultERK7QString_ptr", "UIAction::resetKeyBindingToDefault(QString const&)"),
	mu_demangle_test("_ZN8UIAction28registerPluginCommandActionsEv_ptr", "UIAction::registerPluginCommandActions()"),
	mu_demangle_test("_ZN8UIActionC1ERKSt8functionIFvvEE_ptr", "UIAction::UIAction(std::function<void ()> const&)"),
	mu_demangle_test("_ZN8UIActionC1ERKSt8functionIFvvEERKS0_IFbRK15UIActionContextEE_ptr", "UIAction::UIAction(std::function<void ()> const&, std::function<bool (UIActionContext const&)> const&)"),
	mu_demangle_test("_ZN8UIActionC1ERKSt8functionIFvvEERKS0_IFbvEE_ptr", "UIAction::UIAction(std::function<void ()> const&, std::function<bool ()> const&)"),
	mu_demangle_test("_ZN8ViewType8getTypesEv_ptr", "ViewType::getTypes()"),
	mu_demangle_test("_ZN8WebPage211linkClickedERK4QUrl_4_0", "WebPage2::linkClicked(QUrl const&)"),
	mu_demangle_test("_ZN9LogStatus15clearIndicatorsEv_ptr", "LogStatus::clearIndicators()"),
	mu_demangle_test("_ZN9LogStatus19incrementErrorCountEi_ptr", "LogStatus::incrementErrorCount(int)"),
	mu_demangle_test("_ZN9LogStatus21incrementWarningCountEi_ptr", "LogStatus::incrementWarningCount(int)"),
	mu_demangle_test("_ZN9LogStatusC1EP7QWidget_ptr", "LogStatus::LogStatus(QWidget*)"),
	mu_demangle_test("_ZN9MiniGraphC1EP9ViewFrame_ptr", "MiniGraph::MiniGraph(ViewFrame*)"),
	mu_demangle_test("_ZN9QCheckBox13setCheckStateEN2Qt10CheckStateE_ptr", "QCheckBox::setCheckState(Qt::CheckState)"),
	mu_demangle_test("_ZN9QCheckBoxC1EP7QWidget_ptr", "QCheckBox::QCheckBox(QWidget*)"),
	mu_demangle_test("_ZN9QCheckBoxC1ERK7QStringP7QWidget_ptr", "QCheckBox::QCheckBox(QString const&, QWidget*)"),
	mu_demangle_test("_ZN9QComboBox10insertItemEiRK5QIconRK7QStringRK8QVariant_ptr", "QComboBox::insertItem(int, QIcon const&, QString const&, QVariant const&)"),
	mu_demangle_test("_ZN9QComboBox14setCurrentTextERK7QString_ptr", "QComboBox::setCurrentText(QString const&)"),
	mu_demangle_test("_ZN9QComboBox15setCurrentIndexEi_ptr", "QComboBox::setCurrentIndex(int)"),
	mu_demangle_test("_ZN9QComboBox16staticMetaObjectE_ptr", "QComboBox::staticMetaObject"),
	mu_demangle_test("_ZN9QComboBox19setSizeAdjustPolicyENS_16SizeAdjustPolicyE_ptr", "QComboBox::setSizeAdjustPolicy(QComboBox::SizeAdjustPolicy)"),
	mu_demangle_test("_ZN9QComboBox5clearEv_ptr", "QComboBox::clear()"),
	mu_demangle_test("_ZN9QComboBox9activatedEi_ptr", "QComboBox::activated(int)"),
	mu_demangle_test("_ZN9QComboBoxC1EP7QWidget_ptr", "QComboBox::QComboBox(QWidget*)"),
	mu_demangle_test("_ZN9QDateTime11setTimeSpecEN2Qt8TimeSpecE_ptr", "QDateTime::setTimeSpec(Qt::TimeSpec)"),
	mu_demangle_test("_ZN9QDateTime18currentDateTimeUtcEv_ptr", "QDateTime::currentDateTimeUtc()"),
	mu_demangle_test("_ZN9QDateTime18fromSecsSinceEpochExN2Qt8TimeSpecEi_ptr", "QDateTime::fromSecsSinceEpoch(int64_t, Qt::TimeSpec, int)"),
	mu_demangle_test("_ZN9QDateTime9setTime_tEj_ptr", "QDateTime::setTime_t(unsigned int)"),
	mu_demangle_test("_ZN9QDateTimeC1Ev_ptr", "QDateTime::QDateTime()"),
	mu_demangle_test("_ZN9QDateTimeD1Ev_ptr", "QDateTime::~QDateTime()"),
	mu_demangle_test("_ZN9QFileInfoC1ERK7QString_ptr", "QFileInfo::QFileInfo(QString const&)"),
	mu_demangle_test("_ZN9QFileInfoD1Ev_ptr", "QFileInfo::~QFileInfo()"),
	mu_demangle_test("_ZN9QGroupBox12setAlignmentEi_ptr", "QGroupBox::setAlignment(int)"),
	mu_demangle_test("_ZN9QGroupBoxC1EP7QWidget_ptr", "QGroupBox::QGroupBox(QWidget*)"),
	mu_demangle_test("_ZN9QGroupBoxC1ERK7QStringP7QWidget_ptr", "QGroupBox::QGroupBox(QString const&, QWidget*)"),
	mu_demangle_test("_ZN9QIODevice4openE6QFlagsINS_12OpenModeFlagEE_ptr", "QIODevice::open(QFlags<QIODevice::OpenModeFlag>)"),
	mu_demangle_test("_ZN9QIODevice4readEPcx_ptr", "QIODevice::read(char*, int64_t)"),
	mu_demangle_test("_ZN9QIODevice5writeEPKcx_ptr", "QIODevice::write(char const*, int64_t)"),
	mu_demangle_test("_ZN9QIODevice7readAllEv_ptr", "QIODevice::readAll()"),
	mu_demangle_test("_ZN9QIODeviceC2Ev_ptr", "QIODevice::QIODevice()"),
	mu_demangle_test("_ZN9QIODeviceD2Ev_ptr", "QIODevice::~QIODevice()"),
	mu_demangle_test("_ZN9QLineEdit11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QLineEdit::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN9QLineEdit11qt_metacastEPKc_ptr", "QLineEdit::qt_metacast(char const*)"),
	mu_demangle_test("_ZN9QLineEdit11setReadOnlyEb_ptr", "QLineEdit::setReadOnly(bool)"),
	mu_demangle_test("_ZN9QLineEdit11textChangedERK7QString_ptr", "QLineEdit::textChanged(QString const&)"),
	mu_demangle_test("_ZN9QLineEdit12setCompleterEP10QCompleter_ptr", "QLineEdit::setCompleter(QCompleter*)"),
	mu_demangle_test("_ZN9QLineEdit13keyPressEventEP9QKeyEvent_ptr", "QLineEdit::keyPressEvent(QKeyEvent*)"),
	mu_demangle_test("_ZN9QLineEdit16staticMetaObjectE_ptr", "QLineEdit::staticMetaObject"),
	mu_demangle_test("_ZN9QLineEdit18setPlaceholderTextERK7QString_ptr", "QLineEdit::setPlaceholderText(QString const&)"),
	mu_demangle_test("_ZN9QLineEdit3cutEv_ptr", "QLineEdit::cut()"),
	mu_demangle_test("_ZN9QLineEdit4redoEv_ptr", "QLineEdit::redo()"),
	mu_demangle_test("_ZN9QLineEdit4undoEv_ptr", "QLineEdit::undo()"),
	mu_demangle_test("_ZN9QLineEdit5pasteEv_ptr", "QLineEdit::paste()"),
	mu_demangle_test("_ZN9QLineEdit7setTextERK7QString_ptr", "QLineEdit::setText(QString const&)"),
	mu_demangle_test("_ZN9QLineEdit9selectAllEv_ptr", "QLineEdit::selectAll()"),
	mu_demangle_test("_ZN9QLineEditC1EP7QWidget_ptr", "QLineEdit::QLineEdit(QWidget*)"),
	mu_demangle_test("_ZN9QLineEditC2EP7QWidget_ptr", "QLineEdit::QLineEdit(QWidget*)"),
	mu_demangle_test("_ZN9QLineEditD2Ev_ptr", "QLineEdit::~QLineEdit()"),
	mu_demangle_test("_ZN9QListData11detach_growEPii_ptr", "QListData::detach_grow(int*, int)"),
	mu_demangle_test("_ZN9QListData11shared_nullE_ptr", "QListData::shared_null"),
	mu_demangle_test("_ZN9QListData6appendEv_ptr", "QListData::append()"),
	mu_demangle_test("_ZN9QListData6detachEi_ptr", "QListData::detach(int)"),
	mu_demangle_test("_ZN9QListData6removeEii_ptr", "QListData::remove(int, int)"),
	mu_demangle_test("_ZN9QListData7disposeEPNS_4DataE_ptr", "QListData::dispose(QListData::Data*)"),
	mu_demangle_test("_ZN9QListData7reallocEi_ptr", "QListData::realloc(int)"),
	mu_demangle_test("_ZN9QListView11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QListView::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN9QListView11qt_metacastEPKc_ptr", "QListView::qt_metacast(char const*)"),
	mu_demangle_test("_ZN9QListView14currentChangedERK11QModelIndexS2__ptr", "QListView::currentChanged(QModelIndex const&, QModelIndex const&)"),
	mu_demangle_test("_ZN9QListViewC2EP7QWidget_ptr", "QListView::QListView(QWidget*)"),
	mu_demangle_test("_ZN9QListViewD2Ev_ptr", "QListView::~QListView()"),
	mu_demangle_test("_ZN9QMetaType22registerNormalizedTypeERK10QByteArrayPFvPvEPFS3_S3_PKvEi6QFlagsINS_8TypeFlagEEPK11QMetaObject_ptr", "QMetaType::registerNormalizedType(QByteArray const&, void (*)(void*), void* (*)(void*, void const*), int, QFlags<QMetaType::TypeFlag>, QMetaObject const*)"),
	mu_demangle_test("_ZN9QMetaType25registerConverterFunctionEPKN9QtPrivate25AbstractConverterFunctionEii_ptr", "QMetaType::registerConverterFunction(QtPrivate::AbstractConverterFunction const*, int, int)"),
	mu_demangle_test("_ZN9QMetaType25registerNormalizedTypedefERK10QByteArrayi_ptr", "QMetaType::registerNormalizedTypedef(QByteArray const&, int)"),
	mu_demangle_test("_ZN9QMetaType27unregisterConverterFunctionEii_ptr", "QMetaType::unregisterConverterFunction(int, int)"),
	mu_demangle_test("_ZN9QMetaType30hasRegisteredConverterFunctionEii_ptr", "QMetaType::hasRegisteredConverterFunction(int, int)"),
	mu_demangle_test("_ZN9QMetaType8typeNameEi_ptr", "QMetaType::typeName(int)"),
	mu_demangle_test("_ZN9QMimeData7setTextERK7QString_ptr", "QMimeData::setText(QString const&)"),
	mu_demangle_test("_ZN9QMimeDataC1Ev_ptr", "QMimeData::QMimeData()"),
	mu_demangle_test("_ZN9QResource11setFileNameERK7QString_ptr", "QResource::setFileName(QString const&)"),
	mu_demangle_test("_ZN9QResourceC1ERK7QStringRK7QLocale_ptr", "QResource::QResource(QString const&, QLocale const&)"),
	mu_demangle_test("_ZN9QResourceD1Ev_ptr", "QResource::~QResource()"),
	mu_demangle_test("_ZN9QRunnableD2Ev_ptr", "QRunnable::~QRunnable()"),
	mu_demangle_test("_ZN9QSettings10beginGroupERK7QString_ptr", "QSettings::beginGroup(QString const&)"),
	mu_demangle_test("_ZN9QSettings6removeERK7QString_ptr", "QSettings::remove(QString const&)"),
	mu_demangle_test("_ZN9QSettings8setValueERK7QStringRK8QVariant_ptr", "QSettings::setValue(QString const&, QVariant const&)"),
	mu_demangle_test("_ZN9QSettingsC1EP7QObject_ptr", "QSettings::QSettings(QObject*)"),
	mu_demangle_test("_ZN9QSettingsD1Ev_ptr", "QSettings::~QSettings()"),
	mu_demangle_test("_ZN9QSplitter14setCollapsibleEib_ptr", "QSplitter::setCollapsible(int, bool)"),
	mu_demangle_test("_ZN9QSplitter14setHandleWidthEi_ptr", "QSplitter::setHandleWidth(int)"),
	mu_demangle_test("_ZN9QSplitter16setStretchFactorEii_ptr", "QSplitter::setStretchFactor(int, int)"),
	mu_demangle_test("_ZN9QSplitter9addWidgetEP7QWidget_ptr", "QSplitter::addWidget(QWidget*)"),
	mu_demangle_test("_ZN9QSplitterC1EP7QWidget_ptr", "QSplitter::QSplitter(QWidget*)"),
	mu_demangle_test("_ZN9QTextEdit17setAcceptRichTextEb_ptr", "QTextEdit::setAcceptRichText(bool)"),
	mu_demangle_test("_ZN9QTextEdit18setPlaceholderTextERK7QString_ptr", "QTextEdit::setPlaceholderText(QString const&)"),
	mu_demangle_test("_ZN9QTextEdit23setTextInteractionFlagsE6QFlagsIN2Qt19TextInteractionFlagEE_ptr", "QTextEdit::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag>)"),
	mu_demangle_test("_ZN9QTextEdit3cutEv_ptr", "QTextEdit::cut()"),
	mu_demangle_test("_ZN9QTextEdit4copyEv_ptr", "QTextEdit::copy()"),
	mu_demangle_test("_ZN9QTextEdit4redoEv_ptr", "QTextEdit::redo()"),
	mu_demangle_test("_ZN9QTextEdit4undoEv_ptr", "QTextEdit::undo()"),
	mu_demangle_test("_ZN9QTextEdit5pasteEv_ptr", "QTextEdit::paste()"),
	mu_demangle_test("_ZN9QTextEdit6appendERK7QString_ptr", "QTextEdit::append(QString const&)"),
	mu_demangle_test("_ZN9QTextEdit7setTextERK7QString_ptr", "QTextEdit::setText(QString const&)"),
	mu_demangle_test("_ZN9QTextEdit9selectAllEv_ptr", "QTextEdit::selectAll()"),
	mu_demangle_test("_ZN9QTextEditC1EP7QWidget_ptr", "QTextEdit::QTextEdit(QWidget*)"),
	mu_demangle_test("_ZN9QtPrivate12argToQStringE11QStringViewmPPKNS_7ArgBaseE_ptr", "QtPrivate::argToQString(QStringView, unsigned long, QtPrivate::ArgBase const**)"),
	mu_demangle_test("_ZN9QtPrivate16QStringList_joinEPK11QStringListPK5QChari_ptr", "QtPrivate::QStringList_join(QStringList const*, QChar const*, int)"),
	mu_demangle_test("_ZN9QtPrivate20QContainerImplHelper3midEiPiS1__ptr", "QtPrivate::QContainerImplHelper::mid(int, int*, int*)"),
	mu_demangle_test("_ZN9QTreeView11qt_metacallEN11QMetaObject4CallEiPPv_ptr", "QTreeView::qt_metacall(QMetaObject::Call, int, void**)"),
	mu_demangle_test("_ZN9QTreeView11qt_metacastEPKc_ptr", "QTreeView::qt_metacast(char const*)"),
	mu_demangle_test("_ZN9QTreeView14setIndentationEi_ptr", "QTreeView::setIndentation(int)"),
	mu_demangle_test("_ZN9QTreeView17setSortingEnabledEb_ptr", "QTreeView::setSortingEnabled(bool)"),
	mu_demangle_test("_ZN9QTreeView20setUniformRowHeightsEb_ptr", "QTreeView::setUniformRowHeights(bool)"),
	mu_demangle_test("_ZN9QTreeView22resizeColumnToContentsEi_ptr", "QTreeView::resizeColumnToContents(int)"),
	mu_demangle_test("_ZN9QTreeView9expandAllEv_ptr", "QTreeView::expandAll()"),
	mu_demangle_test("_ZN9QTreeViewC1EP7QWidget_ptr", "QTreeView::QTreeView(QWidget*)"),
	mu_demangle_test("_ZN9QTreeViewC2EP7QWidget_ptr", "QTreeView::QTreeView(QWidget*)"),
	mu_demangle_test("_ZN9QTreeViewD2Ev_ptr", "QTreeView::~QTreeView()"),
	mu_demangle_test("_ZN9QUrlQueryC1ERK7QString_ptr", "QUrlQuery::QUrlQuery(QString const&)"),
	mu_demangle_test("_ZN9QUrlQueryD1Ev_ptr", "QUrlQuery::~QUrlQuery()"),
	mu_demangle_test("_ZN9UIContext10setHandlerEP16UIContextHandler_ptr", "UIContext::setHandler(UIContextHandler*)"),
	mu_demangle_test("_ZN9UIContext12updateStatusEb_ptr", "UIContext::updateStatus(bool)"),
	mu_demangle_test("_ZN9UIContext14setupUIContextEP7QWidget_ptr", "UIContext::setupUIContext(QWidget*)"),
	mu_demangle_test("_ZN9UIContext18NotifyOnViewChangeEP9ViewFrameRK7QString_ptr", "UIContext::NotifyOnViewChange(ViewFrame*, QString const&)"),
	mu_demangle_test("_ZN9UIContext19getScaledWindowSizeEii_ptr", "UIContext::getScaledWindowSize(int, int)"),
	mu_demangle_test("_ZN9UIContext19NotifyOnContextOpenEv_ptr", "UIContext::NotifyOnContextOpen()"),
	mu_demangle_test("_ZN9UIContext20NotifyOnContextCloseEv_ptr", "UIContext::NotifyOnContextClose()"),
	mu_demangle_test("_ZN9UIContext21NotifyOnAddressChangeEP9ViewFrameP4ViewRK12ViewLocation_ptr", "UIContext::NotifyOnAddressChange(ViewFrame*, View*, ViewLocation const&)"),
	mu_demangle_test("_ZN9UIContext21NotifyOnAfterOpenFileEP11FileContextP9ViewFrame_ptr", "UIContext::NotifyOnAfterOpenFile(FileContext*, ViewFrame*)"),
	mu_demangle_test("_ZN9UIContext21NotifyOnAfterSaveFileEP11FileContextP9ViewFrame_ptr", "UIContext::NotifyOnAfterSaveFile(FileContext*, ViewFrame*)"),
	mu_demangle_test("_ZN9UIContext22NotifyOnAfterCloseFileEP11FileContextP9ViewFrame_ptr", "UIContext::NotifyOnAfterCloseFile(FileContext*, ViewFrame*)"),
	mu_demangle_test("_ZN9UIContext22NotifyOnBeforeOpenFileEP11FileContext_ptr", "UIContext::NotifyOnBeforeOpenFile(FileContext*)"),
	mu_demangle_test("_ZN9UIContext22NotifyOnBeforeSaveFileEP11FileContextP9ViewFrame_ptr", "UIContext::NotifyOnBeforeSaveFile(FileContext*, ViewFrame*)"),
	mu_demangle_test("_ZN9UIContext23NotifyOnBeforeCloseFileEP11FileContextP9ViewFrame_ptr", "UIContext::NotifyOnBeforeCloseFile(FileContext*, ViewFrame*)"),
	mu_demangle_test("_ZN9UIContext25NotifyOnAfterOpenDatabaseEN11BinaryNinja3RefINS0_12FileMetadataEEENS1_INS0_10BinaryViewEEE_ptr", "UIContext::NotifyOnAfterOpenDatabase(BinaryNinja::Ref<BinaryNinja::FileMetadata>, BinaryNinja::Ref<BinaryNinja::BinaryView>)"),
	mu_demangle_test("_ZN9UIContext26NotifyOnBeforeOpenDatabaseEN11BinaryNinja3RefINS0_12FileMetadataEEE_ptr", "UIContext::NotifyOnBeforeOpenDatabase(BinaryNinja::Ref<BinaryNinja::FileMetadata>)"),
	mu_demangle_test("_ZN9UIContextC2Ev_ptr", "UIContext::UIContext()"),
	mu_demangle_test("_ZN9UIContextD2Ev_ptr", "UIContext::~UIContext()"),
	mu_demangle_test("_ZN9ViewFrame10getTabNameEv_ptr", "ViewFrame::getTabName()"),
	mu_demangle_test("_ZN9ViewFrame11setViewTypeERK7QString_ptr", "ViewFrame::setViewType(QString const&)"),
	mu_demangle_test("_ZN9ViewFrame11updateFontsEv_ptr", "ViewFrame::updateFonts()"),
	mu_demangle_test("_ZN9ViewFrame11updateThemeEv_ptr", "ViewFrame::updateTheme()"),
	mu_demangle_test("_ZN9ViewFrame12closeRequestEv_ptr", "ViewFrame::closeRequest()"),
	mu_demangle_test("_ZN9ViewFrame14getCurrentViewEv_ptr", "ViewFrame::getCurrentView()"),
	mu_demangle_test("_ZN9ViewFrame15getViewLocationEv_ptr", "ViewFrame::getViewLocation()"),
	mu_demangle_test("_ZN9ViewFrame15setViewLocationERK12ViewLocation_ptr", "ViewFrame::setViewLocation(ViewLocation const&)"),
	mu_demangle_test("_ZN9ViewFrame16getShortFileNameEv_ptr", "ViewFrame::getShortFileName()"),
	mu_demangle_test("_ZN9ViewFrame18getCurrentDataTypeEv_ptr", "ViewFrame::getCurrentDataType()"),
	mu_demangle_test("_ZN9ViewFrame19getAddressFromInputEP7QWidgetN11BinaryNinja3RefINS2_10BinaryViewEEERmmRK7QStringS9_b_ptr", "ViewFrame::getAddressFromInput(QWidget*, BinaryNinja::Ref<BinaryNinja::BinaryView>, unsigned long&, unsigned long, QString const&, QString const&, bool)"),
	mu_demangle_test("_ZN9ViewFrame21setFileContentsLockedEb_ptr", "ViewFrame::setFileContentsLocked(bool)"),
	mu_demangle_test("_ZN9ViewFrame21updateCrossReferencesEv_ptr", "ViewFrame::updateCrossReferences()"),
	mu_demangle_test("_ZN9ViewFrame25getFileContentsLockStatusEv_ptr", "ViewFrame::getFileContentsLockStatus()"),
	mu_demangle_test("_ZN9ViewFrame4backEv_ptr", "ViewFrame::back()"),
	mu_demangle_test("_ZN9ViewFrame5focusEv_ptr", "ViewFrame::focus()"),
	mu_demangle_test("_ZN9ViewFrame7closingEv_ptr", "ViewFrame::closing()"),
	mu_demangle_test("_ZN9ViewFrame7forwardEv_ptr", "ViewFrame::forward()"),
	mu_demangle_test("_ZN9ViewFrame8navigateERK7QStringmbb_ptr", "ViewFrame::navigate(QString const&, unsigned long, bool, bool)"),
	mu_demangle_test("_ZN9ViewFrameC1EP7QWidgetP11FileContextRK7QStringb_ptr", "ViewFrame::ViewFrame(QWidget*, FileContext*, QString const&, bool)"),
	mu_demangle_test("_Znam_ptr", "operator new[](unsigned long)"),
	mu_demangle_test("_ZNK10QByteArray8endsWithEc_ptr", "QByteArray::endsWith(char) const"),
	mu_demangle_test("_ZNK10QJsonValue5toIntEi_ptr", "QJsonValue::toInt(int) const"),
	mu_demangle_test("_ZNK10QTableView14verticalHeaderEv_ptr", "QTableView::verticalHeader() const"),
	mu_demangle_test("_ZNK10QTableView16horizontalHeaderEv_ptr", "QTableView::horizontalHeader() const"),
	mu_demangle_test("_ZNK10QTableView9gridStyleEv_ptr", "QTableView::gridStyle() const"),
	mu_demangle_test("_ZNK10QTabWidget12currentIndexEv_ptr", "QTabWidget::currentIndex() const"),
	mu_demangle_test("_ZNK10QTabWidget13currentWidgetEv_ptr", "QTabWidget::currentWidget() const"),
	mu_demangle_test("_ZNK10QTabWidget5countEv_ptr", "QTabWidget::count() const"),
	mu_demangle_test("_ZNK10QTabWidget6tabBarEv_ptr", "QTabWidget::tabBar() const"),
	mu_demangle_test("_ZNK10QTabWidget6widgetEi_ptr", "QTabWidget::widget(int) const"),
	mu_demangle_test("_ZNK10QTabWidget7indexOfEP7QWidget_ptr", "QTabWidget::indexOf(QWidget*) const"),
	mu_demangle_test("_ZNK10QTabWidget7tabTextEi_ptr", "QTabWidget::tabText(int) const"),
	mu_demangle_test("_ZNK11BinaryNinja13FlowGraphNode12GetHighlightEv_5_0", "BinaryNinja::FlowGraphNode::GetHighlight() const"),
	mu_demangle_test("_ZNK11BinaryNinja13FlowGraphNode12GetHighlightEv_5_1", "BinaryNinja::FlowGraphNode::GetHighlight() const"),
	mu_demangle_test("_ZNK11BinaryNinja13FlowGraphNode12GetHighlightEv_5_2", "BinaryNinja::FlowGraphNode::GetHighlight() const"),
	mu_demangle_test("_ZNK11BinaryNinja13FlowGraphNode12GetHighlightEv_5_3", "BinaryNinja::FlowGraphNode::GetHighlight() const"),
	mu_demangle_test("_ZNK11QJsonObject8containsERK7QString_ptr", "QJsonObject::contains(QString const&) const"),
	mu_demangle_test("_ZNK11QMainWindow20isDockNestingEnabledEv_ptr", "QMainWindow::isDockNestingEnabled() const"),
	mu_demangle_test("_ZNK11QMainWindow6cornerEN2Qt6CornerE_ptr", "QMainWindow::corner(Qt::Corner) const"),
	mu_demangle_test("_ZNK11QMainWindow7menuBarEv_ptr", "QMainWindow::menuBar() const"),
	mu_demangle_test("_ZNK11QMainWindow9saveStateEi_ptr", "QMainWindow::saveState(int) const"),
	mu_demangle_test("_ZNK11QMainWindow9statusBarEv_ptr", "QMainWindow::statusBar() const"),
	mu_demangle_test("_ZNK11QMetaObject2trEPKcS1_i_ptr", "QMetaObject::tr(char const*, char const*, int) const"),
	mu_demangle_test("_ZNK11QMetaObject4castEP7QObject_ptr", "QMetaObject::cast(QObject*) const"),
	mu_demangle_test("_ZNK11QMetaObject4castEPK7QObject_ptr", "QMetaObject::cast(QObject const*) const"),
	mu_demangle_test("_ZNK11QMetaObject9classNameEv_ptr", "QMetaObject::className() const"),
	mu_demangle_test("_ZNK11QObjectData17dynamicMetaObjectEv_ptr", "QObjectData::dynamicMetaObject() const"),
	mu_demangle_test("_ZNK12QDirIterator7hasNextEv_ptr", "QDirIterator::hasNext() const"),
	mu_demangle_test("_ZNK12QDirIterator8fileInfoEv_ptr", "QDirIterator::fileInfo() const"),
	mu_demangle_test("_ZNK12QDirIterator8fileNameEv_ptr", "QDirIterator::fileName() const"),
	mu_demangle_test("_ZNK12QFontMetrics17horizontalAdvanceERK7QStringi_ptr", "QFontMetrics::horizontalAdvance(QString const&, int) const"),
	mu_demangle_test("_ZNK12QFontMetrics6ascentEv_ptr", "QFontMetrics::ascent() const"),
	mu_demangle_test("_ZNK12QFontMetrics6heightEv_ptr", "QFontMetrics::height() const"),
	mu_demangle_test("_ZNK12QInputDialog9textValueEv_ptr", "QInputDialog::textValue() const"),
	mu_demangle_test("_ZNK12QKeySequence7isEmptyEv_ptr", "QKeySequence::isEmpty() const"),
	mu_demangle_test("_ZNK12QKeySequence8toStringENS_14SequenceFormatE_ptr", "QKeySequence::toString(QKeySequence::SequenceFormat) const"),
	mu_demangle_test("_ZNK12QKeySequenceeqERKS__ptr", "QKeySequence::operator==(QKeySequence const&) const"),
	mu_demangle_test("_ZNK12QKeySequenceltERKS__ptr", "QKeySequence::operator<(QKeySequence const&) const"),
	mu_demangle_test("_ZNK13QFileAccessor7IsValidEv_ptr", "QFileAccessor::IsValid() const"),
	mu_demangle_test("_ZNK13QFontMetricsF6heightEv_ptr", "QFontMetricsF::height() const"),
	mu_demangle_test("_ZNK13QItemDelegate5paintEP8QPainterRK20QStyleOptionViewItemRK11QModelIndex_ptr", "QItemDelegate::paint(QPainter*, QStyleOptionViewItem const&, QModelIndex const&) const"),
	mu_demangle_test("_ZNK13QJsonDocument6objectEv_ptr", "QJsonDocument::object() const"),
	mu_demangle_test("_ZNK13QJsonDocumentixERK7QString_ptr", "QJsonDocument::operator[](QString const&) const"),
	mu_demangle_test("_ZNK13QNetworkReply10isFinishedEv_ptr", "QNetworkReply::isFinished() const"),
	mu_demangle_test("_ZNK13QNetworkReply12hasRawHeaderERK10QByteArray_ptr", "QNetworkReply::hasRawHeader(QByteArray const&) const"),
	mu_demangle_test("_ZNK13QNetworkReply14rawHeaderPairsEv_ptr", "QNetworkReply::rawHeaderPairs() const"),
	mu_demangle_test("_ZNK13QNetworkReply5errorEv_ptr", "QNetworkReply::error() const"),
	mu_demangle_test("_ZNK13QNetworkReply6headerEN15QNetworkRequest12KnownHeadersE_ptr", "QNetworkReply::header(QNetworkRequest::KnownHeaders) const"),
	mu_demangle_test("_ZNK13QNetworkReply9attributeEN15QNetworkRequest9AttributeE_ptr", "QNetworkReply::attribute(QNetworkRequest::Attribute) const"),
	mu_demangle_test("_ZNK13QNetworkReply9rawHeaderERK10QByteArray_ptr", "QNetworkReply::rawHeader(QByteArray const&) const"),
	mu_demangle_test("_ZNK14QItemSelection7indexesEv_ptr", "QItemSelection::indexes() const"),
	mu_demangle_test("_ZNK14QWebEnginePage7profileEv_ptr", "QWebEnginePage::profile() const"),
	mu_demangle_test("_ZNK14QWebEngineView4pageEv_ptr", "QWebEngineView::page() const"),
	mu_demangle_test("_ZNK14QWebEngineView8settingsEv_ptr", "QWebEngineView::settings() const"),
	mu_demangle_test("_ZNK15QAbstractButton9isCheckedEv_ptr", "QAbstractButton::isChecked() const"),
	mu_demangle_test("_ZNK15QProgressDialog11wasCanceledEv_ptr", "QProgressDialog::wasCanceled() const"),
	mu_demangle_test("_ZNK15QProgressDialog7maximumEv_ptr", "QProgressDialog::maximum() const"),
	mu_demangle_test("_ZNK15QProgressDialog7minimumEv_ptr", "QProgressDialog::minimum() const"),
	mu_demangle_test("_ZNK16QKeySequenceEdit11keySequenceEv_ptr", "QKeySequenceEdit::keySequence() const"),
	mu_demangle_test("_ZNK17QAbstractItemView12itemDelegateEv_ptr", "QAbstractItemView::itemDelegate() const"),
	mu_demangle_test("_ZNK17QAbstractItemView14selectionModelEv_ptr", "QAbstractItemView::selectionModel() const"),
	mu_demangle_test("_ZNK17QAbstractItemView5modelEv_ptr", "QAbstractItemView::model() const"),
	mu_demangle_test("_ZNK18QAbstractAnimation9directionEv_ptr", "QAbstractAnimation::direction() const"),
	mu_demangle_test("_ZNK18QAbstractItemModel5flagsERK11QModelIndex_ptr", "QAbstractItemModel::flags(QModelIndex const&) const"),
	mu_demangle_test("_ZNK18QCommandLineParser19positionalArgumentsEv_ptr", "QCommandLineParser::positionalArguments() const"),
	mu_demangle_test("_ZNK18QCommandLineParser5isSetERK18QCommandLineOption_ptr", "QCommandLineParser::isSet(QCommandLineOption const&) const"),
	mu_demangle_test("_ZNK18QCommandLineParser5valueERK18QCommandLineOption_ptr", "QCommandLineParser::value(QCommandLineOption const&) const"),
	mu_demangle_test("_ZNK18QRegularExpression5matchERK7QStringiNS_9MatchTypeE6QFlagsINS_11MatchOptionEE_ptr", "QRegularExpression::match(QString const&, int, QRegularExpression::MatchType, QFlags<QRegularExpression::MatchOption>) const"),
	mu_demangle_test("_ZNK18QRegularExpression7isValidEv_ptr", "QRegularExpression::isValid() const"),
	mu_demangle_test("_ZNK18QRegularExpression7patternEv_ptr", "QRegularExpression::pattern() const"),
	mu_demangle_test("_ZNK19QAbstractProxyModel11sourceModelEv_ptr", "QAbstractProxyModel::sourceModel() const"),
	mu_demangle_test("_ZNK19QAbstractScrollArea17verticalScrollBarEv_ptr", "QAbstractScrollArea::verticalScrollBar() const"),
	mu_demangle_test("_ZNK19QAbstractScrollArea19horizontalScrollBarEv_ptr", "QAbstractScrollArea::horizontalScrollBar() const"),
	mu_demangle_test("_ZNK19QItemSelectionModel9selectionEv_ptr", "QItemSelectionModel::selection() const"),
	mu_demangle_test("_ZNK19QStyledItemDelegate12createEditorEP7QWidgetRK20QStyleOptionViewItemRK11QModelIndex_ptr", "QStyledItemDelegate::createEditor(QWidget*, QStyleOptionViewItem const&, QModelIndex const&) const"),
	mu_demangle_test("_ZNK19QStyledItemDelegate12setModelDataEP7QWidgetP18QAbstractItemModelRK11QModelIndex_ptr", "QStyledItemDelegate::setModelData(QWidget*, QAbstractItemModel*, QModelIndex const&) const"),
	mu_demangle_test("_ZNK19QStyledItemDelegate13setEditorDataEP7QWidgetRK11QModelIndex_ptr", "QStyledItemDelegate::setEditorData(QWidget*, QModelIndex const&) const"),
	mu_demangle_test("_ZNK21QSortFilterProxyModel12filterRegExpEv_ptr", "QSortFilterProxyModel::filterRegExp() const"),
	mu_demangle_test("_ZNK21QSortFilterProxyModel23filterRegularExpressionEv_ptr", "QSortFilterProxyModel::filterRegularExpression() const"),
	mu_demangle_test("_ZNK21QSortFilterProxyModel4dataERK11QModelIndexi_ptr", "QSortFilterProxyModel::data(QModelIndex const&, int) const"),
	mu_demangle_test("_ZNK21QSortFilterProxyModel8lessThanERK11QModelIndexS2__ptr", "QSortFilterProxyModel::lessThan(QModelIndex const&, QModelIndex const&) const"),
	mu_demangle_test("_ZNK23QRegularExpressionMatch13capturedTextsEv_ptr", "QRegularExpressionMatch::capturedTexts() const"),
	mu_demangle_test("_ZNK23QRegularExpressionMatch8hasMatchEv_ptr", "QRegularExpressionMatch::hasMatch() const"),
	mu_demangle_test("_ZNK4QDir16absoluteFilePathERK7QString_ptr", "QDir::absoluteFilePath(QString const&) const"),
	mu_demangle_test("_ZNK4QDir6existsEv_ptr", "QDir::exists() const"),
	mu_demangle_test("_ZNK4QDir6mkpathERK7QString_ptr", "QDir::mkpath(QString const&) const"),
	mu_demangle_test("_ZNK4QUrl11isLocalFileEv_ptr", "QUrl::isLocalFile() const"),
	mu_demangle_test("_ZNK4QUrl11toLocalFileEv_ptr", "QUrl::toLocalFile() const"),
	mu_demangle_test("_ZNK4QUrl4pathE6QFlagsINS_25ComponentFormattingOptionEE_ptr", "QUrl::path(QFlags<QUrl::ComponentFormattingOption>) const"),
	mu_demangle_test("_ZNK4QUrl5queryE6QFlagsINS_25ComponentFormattingOptionEE_ptr", "QUrl::query(QFlags<QUrl::ComponentFormattingOption>) const"),
	mu_demangle_test("_ZNK4QUrl6schemeEv_ptr", "QUrl::scheme() const"),
	mu_demangle_test("_ZNK4QUrl7isValidEv_ptr", "QUrl::isValid() const"),
	mu_demangle_test("_ZNK4QUrl8adjustedE12QUrlTwoFlagsINS_19UrlFormattingOptionENS_25ComponentFormattingOptionEE_ptr", "QUrl::adjusted(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption>) const"),
	mu_demangle_test("_ZNK4QUrl8toStringE12QUrlTwoFlagsINS_19UrlFormattingOptionENS_25ComponentFormattingOptionEE_ptr", "QUrl::toString(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption>) const"),
	mu_demangle_test("_ZNK5QFile4sizeEv_ptr", "QFile::size() const"),
	mu_demangle_test("_ZNK5QFile6existsEv_ptr", "QFile::exists() const"),
	mu_demangle_test("_ZNK5QFont6familyEv_ptr", "QFont::family() const"),
	mu_demangle_test("_ZNK5QFont9pointSizeEv_ptr", "QFont::pointSize() const"),
	mu_demangle_test("_ZNK5QFont9styleNameEv_ptr", "QFont::styleName() const"),
	mu_demangle_test("_ZNK5QIcon6pixmapERK5QSizeNS_4ModeENS_5StateE_ptr", "QIcon::pixmap(QSize const&, QIcon::Mode, QIcon::State) const"),
	mu_demangle_test("_ZNK5QRect8containsERKS_b_ptr", "QRect::contains(QRect const&, bool) const"),
	mu_demangle_test("_ZNK6QColor4nameENS_10NameFormatE_ptr", "QColor::name(QColor::NameFormat) const"),
	mu_demangle_test("_ZNK6QColor4nameEv_ptr", "QColor::name() const"),
	mu_demangle_test("_ZNK6QColor6darkerEi_ptr", "QColor::darker(int) const"),
	mu_demangle_test("_ZNK6QColor9lightnessEv_ptr", "QColor::lightness() const"),
	mu_demangle_test("_ZNK6QLabel20textInteractionFlagsEv_ptr", "QLabel::textInteractionFlags() const"),
	mu_demangle_test("_ZNK6QLabel4textEv_ptr", "QLabel::text() const"),
	mu_demangle_test("_ZNK7QAction4dataEv_ptr", "QAction::data() const"),
	mu_demangle_test("_ZNK7QLocale8toStringERK9QDateTimeNS_10FormatTypeE_ptr", "QLocale::toString(QDateTime const&, QLocale::FormatType) const"),
	mu_demangle_test("_ZNK7QObject6senderEv_ptr", "QObject::sender() const"),
	mu_demangle_test("_ZNK7QRegExp10exactMatchERK7QString_ptr", "QRegExp::exactMatch(QString const&) const"),
	mu_demangle_test("_ZNK7QRegExp7indexInERK7QStringiNS_9CaretModeE_ptr", "QRegExp::indexIn(QString const&, int, QRegExp::CaretMode) const"),
	mu_demangle_test("_ZNK7QRegExp7isEmptyEv_ptr", "QRegExp::isEmpty() const"),
	mu_demangle_test("_ZNK7QScreen4sizeEv_ptr", "QScreen::size() const"),
	mu_demangle_test("_ZNK7QScreen8geometryEv_ptr", "QScreen::geometry() const"),
	mu_demangle_test("_ZNK7QString10startsWithERKS_N2Qt15CaseSensitivityE_ptr", "QString::startsWith(QString const&, Qt::CaseSensitivity) const"),
	mu_demangle_test("_ZNK7QString10toLongLongEPbi_ptr", "QString::toLongLong(bool*, int) const"),
	mu_demangle_test("_ZNK7QString11toULongLongEPbi_ptr", "QString::toULongLong(bool*, int) const"),
	mu_demangle_test("_ZNK7QString13toHtmlEscapedEv_ptr", "QString::toHtmlEscaped() const"),
	mu_demangle_test("_ZNK7QString3argERKS_i5QChar_ptr", "QString::arg(QString const&, int, QChar) const"),
	mu_demangle_test("_ZNK7QString3argExii5QChar_ptr", "QString::arg(int64_t, int, int, QChar) const"),
	mu_demangle_test("_ZNK7QString3argEyii5QChar_ptr", "QString::arg(uint64_t, int, int, QChar) const"),
	mu_demangle_test("_ZNK7QString3midEii_ptr", "QString::mid(int, int) const"),
	mu_demangle_test("_ZNK7QString5splitE5QChar6QFlagsIN2Qt18SplitBehaviorFlagsEENS2_15CaseSensitivityE_ptr", "QString::split(QChar, QFlags<Qt::SplitBehaviorFlags>, Qt::CaseSensitivity) const"),
	mu_demangle_test("_ZNK7QString5splitERKS_6QFlagsIN2Qt18SplitBehaviorFlagsEENS3_15CaseSensitivityE_ptr", "QString::split(QString const&, QFlags<Qt::SplitBehaviorFlags>, Qt::CaseSensitivity) const"),
	mu_demangle_test("_ZNK7QString5toIntEPbi_ptr", "QString::toInt(bool*, int) const"),
	mu_demangle_test("_ZNK7QString7indexOfERKS_iN2Qt15CaseSensitivityE_ptr", "QString::indexOf(QString const&, int, Qt::CaseSensitivity) const"),
	mu_demangle_test("_ZNK7QString8containsERK18QRegularExpressionP23QRegularExpressionMatch_ptr", "QString::contains(QRegularExpression const&, QRegularExpressionMatch*) const"),
	mu_demangle_test("_ZNK7QString8endsWithERKS_N2Qt15CaseSensitivityE_ptr", "QString::endsWith(QString const&, Qt::CaseSensitivity) const"),
	mu_demangle_test("_ZNK7QTabBar5tabAtERK6QPoint_ptr", "QTabBar::tabAt(QPoint const&) const"),
	mu_demangle_test("_ZNK7QThread23isInterruptionRequestedEv_ptr", "QThread::isInterruptionRequested() const"),
	mu_demangle_test("_ZNK7QWidget10sizePolicyEv_ptr", "QWidget::sizePolicy() const"),
	mu_demangle_test("_ZNK7QWidget11focusWidgetEv_ptr", "QWidget::focusWidget() const"),
	mu_demangle_test("_ZNK7QWidget12contentsRectEv_ptr", "QWidget::contentsRect() const"),
	mu_demangle_test("_ZNK7QWidget12saveGeometryEv_ptr", "QWidget::saveGeometry() const"),
	mu_demangle_test("_ZNK7QWidget13frameGeometryEv_ptr", "QWidget::frameGeometry() const"),
	mu_demangle_test("_ZNK7QWidget14isActiveWindowEv_ptr", "QWidget::isActiveWindow() const"),
	mu_demangle_test("_ZNK7QWidget5styleEv_ptr", "QWidget::style() const"),
	mu_demangle_test("_ZNK7QWidget6layoutEv_ptr", "QWidget::layout() const"),
	mu_demangle_test("_ZNK7QWidget6screenEv_ptr", "QWidget::screen() const"),
	mu_demangle_test("_ZNK7QWidget7paletteEv_ptr", "QWidget::palette() const"),
	mu_demangle_test("_ZNK7QWidget8hasFocusEv_ptr", "QWidget::hasFocus() const"),
	mu_demangle_test("_ZNK8QPalette5brushENS_10ColorGroupENS_9ColorRoleE_ptr", "QPalette::brush(QPalette::ColorGroup, QPalette::ColorRole) const"),
	mu_demangle_test("_ZNK8QVariant10canConvertEi_ptr", "QVariant::canConvert(int) const"),
	mu_demangle_test("_ZNK8QVariant11toByteArrayEv_ptr", "QVariant::toByteArray() const"),
	mu_demangle_test("_ZNK8QVariant3cmpERKS__ptr", "QVariant::cmp(QVariant const&) const"),
	mu_demangle_test("_ZNK8QVariant5toIntEPb_ptr", "QVariant::toInt(bool*) const"),
	mu_demangle_test("_ZNK8QVariant6toBoolEv_ptr", "QVariant::toBool() const"),
	mu_demangle_test("_ZNK8QVariant6toListEv_ptr", "QVariant::toList() const"),
	mu_demangle_test("_ZNK8QVariant7convertEiPv_ptr", "QVariant::convert(int, void*) const"),
	mu_demangle_test("_ZNK8QVariant8toStringEv_ptr", "QVariant::toString() const"),
	mu_demangle_test("_ZNK8QVariant8userTypeEv_ptr", "QVariant::userType() const"),
	mu_demangle_test("_ZNK8QVariant9constDataEv_ptr", "QVariant::constData() const"),
	mu_demangle_test("_ZNK9QCheckBox10checkStateEv_ptr", "QCheckBox::checkState() const"),
	mu_demangle_test("_ZNK9QComboBox11currentTextEv_ptr", "QComboBox::currentText() const"),
	mu_demangle_test("_ZNK9QComboBox5countEv_ptr", "QComboBox::count() const"),
	mu_demangle_test("_ZNK9QComboBox8findDataERK8QVarianti6QFlagsIN2Qt9MatchFlagEE_ptr", "QComboBox::findData(QVariant const&, int, QFlags<Qt::MatchFlag>) const"),
	mu_demangle_test("_ZNK9QComboBox8itemDataEii_ptr", "QComboBox::itemData(int, int) const"),
	mu_demangle_test("_ZNK9QComboBox8itemTextEi_ptr", "QComboBox::itemText(int) const"),
	mu_demangle_test("_ZNK9QDateTime10toTimeSpecEN2Qt8TimeSpecE_ptr", "QDateTime::toTimeSpec(Qt::TimeSpec) const"),
	mu_demangle_test("_ZNK9QDateTime6daysToERKS__ptr", "QDateTime::daysTo(QDateTime const&) const"),
	mu_demangle_test("_ZNK9QDateTime8toStringEN2Qt10DateFormatE_ptr", "QDateTime::toString(Qt::DateFormat) const"),
	mu_demangle_test("_ZNK9QDateTimeltERKS__ptr", "QDateTime::operator<(QDateTime const&) const"),
	mu_demangle_test("_ZNK9QFileInfo12absolutePathEv_ptr", "QFileInfo::absolutePath() const"),
	mu_demangle_test("_ZNK9QFileInfo17canonicalFilePathEv_ptr", "QFileInfo::canonicalFilePath() const"),
	mu_demangle_test("_ZNK9QFileInfo4pathEv_ptr", "QFileInfo::path() const"),
	mu_demangle_test("_ZNK9QFileInfo5isDirEv_ptr", "QFileInfo::isDir() const"),
	mu_demangle_test("_ZNK9QFileInfo6existsEv_ptr", "QFileInfo::exists() const"),
	mu_demangle_test("_ZNK9QFileInfo6suffixEv_ptr", "QFileInfo::suffix() const"),
	mu_demangle_test("_ZNK9QFileInfo8fileNameEv_ptr", "QFileInfo::fileName() const"),
	mu_demangle_test("_ZNK9QIODevice11errorStringEv_ptr", "QIODevice::errorString() const"),
	mu_demangle_test("_ZNK9QKeyEvent9modifiersEv_ptr", "QKeyEvent::modifiers() const"),
	mu_demangle_test("_ZNK9QLineEdit10isReadOnlyEv_ptr", "QLineEdit::isReadOnly() const"),
	mu_demangle_test("_ZNK9QLineEdit4copyEv_ptr", "QLineEdit::copy() const"),
	mu_demangle_test("_ZNK9QLineEdit4textEv_ptr", "QLineEdit::text() const"),
	mu_demangle_test("_ZNK9QMimeData4urlsEv_ptr", "QMimeData::urls() const"),
	mu_demangle_test("_ZNK9QResource16uncompressedDataEv_ptr", "QResource::uncompressedData() const"),
	mu_demangle_test("_ZNK9QResource16uncompressedSizeEv_ptr", "QResource::uncompressedSize() const"),
	mu_demangle_test("_ZNK9QSettings5valueERK7QStringRK8QVariant_ptr", "QSettings::value(QString const&, QVariant const&) const"),
	mu_demangle_test("_ZNK9QSettings7allKeysEv_ptr", "QSettings::allKeys() const"),
	mu_demangle_test("_ZNK9QSettings8containsERK7QString_ptr", "QSettings::contains(QString const&) const"),
	mu_demangle_test("_ZNK9QTextEdit10isReadOnlyEv_ptr", "QTextEdit::isReadOnly() const"),
	mu_demangle_test("_ZNK9QTextEdit11toPlainTextEv_ptr", "QTextEdit::toPlainText() const"),
	mu_demangle_test("_ZNK9QTreeView6headerEv_ptr", "QTreeView::header() const"),
	mu_demangle_test("_ZNK9QUrlQuery12hasQueryItemERK7QString_ptr", "QUrlQuery::hasQueryItem(QString const&) const"),
	mu_demangle_test("_ZNK9QUrlQuery14queryItemValueERK7QString6QFlagsIN4QUrl25ComponentFormattingOptionEE_ptr", "QUrlQuery::queryItemValue(QString const&, QFlags<QUrl::ComponentFormattingOption>) const"),
	mu_demangle_test("_ZNK9ViewFrame17getAvailableTypesEv_ptr", "ViewFrame::getAvailableTypes() const"),
	// INCORRECT : 	mu_demangle_test("_ZNKSt7__cxx1115basic_stringbufIcSt11char_traitsIcESaIcEE3strEv_ptr", "std::stringbuf::str() const"),
	mu_demangle_test("_ZNKSt8__detail20_Prime_rehash_policy11_M_next_bktEm_ptr", "std::__detail::_Prime_rehash_policy::_M_next_bkt(unsigned long) const"),
	mu_demangle_test("_ZNKSt8__detail20_Prime_rehash_policy14_M_need_rehashEmmm_ptr", "std::__detail::_Prime_rehash_policy::_M_need_rehash(unsigned long, unsigned long, unsigned long) const"),
	mu_demangle_test("_ZNSi10_M_extractIdEERSiRT__ptr", "std::istream& std::istream::_M_extract<double>(double&)"),
	mu_demangle_test("_ZNSo9_M_insertImEERSoT__ptr", "std::ostream& std::ostream::_M_insert<unsigned long>(unsigned long)"),
	mu_demangle_test("_ZNSolsEPSt15basic_streambufIcSt11char_traitsIcEE_ptr", "std::ostream::operator<<(std::streambuf*)"),
	mu_demangle_test("_ZNSt11logic_errorC1EPKc_ptr", "std::logic_error::logic_error(char const*)"),
	mu_demangle_test("_ZNSt11logic_errorD1Ev_ptr", "std::logic_error::~logic_error()"),
	mu_demangle_test("_ZNSt14_Function_base13_Base_managerIZN8appdebug20clPrintCmdQOccupancyEP17_cl_command_queueEUlvE_E10_M_managerERSt9_Any_dataRKS6_St18_Manager_operation_100", "std::_Function_base::_Base_manager<appdebug::clPrintCmdQOccupancy(_cl_command_queue*)::{lambda()#1}>::_M_manager(std::_Any_data&, std::_Any_data const&, std::_Manager_operation)"),
	mu_demangle_test("_ZNSt14_Function_base13_Base_managerIZN8appdebug20clPrintCmdQOccupancyEP17_cl_command_queueEUlvE_E10_M_managerERSt9_Any_dataRKS6_St18_Manager_operation_101", "std::_Function_base::_Base_manager<appdebug::clPrintCmdQOccupancy(_cl_command_queue*)::{lambda()#1}>::_M_manager(std::_Any_data&, std::_Any_data const&, std::_Manager_operation)"),
	mu_demangle_test("_ZNSt14_Function_base13_Base_managerIZN8appdebug20clPrintCmdQOccupancyEP17_cl_command_queueEUlvE_E10_M_managerERSt9_Any_dataRKS6_St18_Manager_operation_102", "std::_Function_base::_Base_manager<appdebug::clPrintCmdQOccupancy(_cl_command_queue*)::{lambda()#1}>::_M_manager(std::_Any_data&, std::_Any_data const&, std::_Manager_operation)"),
	mu_demangle_test("_ZNSt14_Function_base13_Base_managerIZN8appdebug20clPrintCmdQOccupancyEP17_cl_command_queueEUlvE_E10_M_managerERSt9_Any_dataRKS6_St18_Manager_operation_103", "std::_Function_base::_Base_manager<appdebug::clPrintCmdQOccupancy(_cl_command_queue*)::{lambda()#1}>::_M_manager(std::_Any_data&, std::_Any_data const&, std::_Manager_operation)"),
	mu_demangle_test("_ZNSt14_Function_base13_Base_managerIZN8appdebug20clPrintCmdQOccupancyEP17_cl_command_queueEUlvE_E10_M_managerERSt9_Any_dataRKS6_St18_Manager_operation_104", "std::_Function_base::_Base_manager<appdebug::clPrintCmdQOccupancy(_cl_command_queue*)::{lambda()#1}>::_M_manager(std::_Any_data&, std::_Any_data const&, std::_Manager_operation)"),
	mu_demangle_test("_ZNSt14_Function_base13_Base_managerIZN8appdebug20clPrintCmdQOccupancyEP17_cl_command_queueEUlvE_E10_M_managerERSt9_Any_dataRKS6_St18_Manager_operation_105", "std::_Function_base::_Base_manager<appdebug::clPrintCmdQOccupancy(_cl_command_queue*)::{lambda()#1}>::_M_manager(std::_Any_data&, std::_Any_data const&, std::_Manager_operation)"),
	mu_demangle_test("_ZNSt6chrono3_V212steady_clock3nowEv_ptr", "std::chrono::_V2::steady_clock::now()"),
	mu_demangle_test("_ZNSt6chrono3_V212system_clock3nowEv_ptr", "std::chrono::_V2::system_clock::now()"),
	mu_demangle_test("_ZNSt6localeC1Ev_ptr", "std::locale::locale()"),
	mu_demangle_test("_ZNSt6localeD1Ev_ptr", "std::locale::~locale()"),
	// INCORRECT : 	mu_demangle_test("_ZNSt7__cxx1115basic_stringbufIcSt11char_traitsIcESaIcEE7_M_syncEPcmm_ptr", "std::stringbuf::_M_sync(char*, unsigned long, unsigned long)"),
	// INCORRECT : 	mu_demangle_test("_ZNSt7__cxx1118basic_stringstreamIcSt11char_traitsIcESaIcEED1Ev_ptr", "std::stringstream::~stringstream()"),
	// INCORRECT : 	mu_demangle_test("_ZNSt7__cxx1119basic_istringstreamIcSt11char_traitsIcESaIcEED1Ev_ptr", "std::istringstream::~istringstream()"),
	// INCORRECT : 	mu_demangle_test("_ZNSt7__cxx1119basic_ostringstreamIcSt11char_traitsIcESaIcEEC1ESt13_Ios_Openmode_ptr", "std::ostringstream::ostringstream(std::ios_base::openmode)"),
	// INCORRECT : 	mu_demangle_test("_ZNSt7__cxx1119basic_ostringstreamIcSt11char_traitsIcESaIcEED1Ev_ptr", "std::ostringstream::~ostringstream()"),
	mu_demangle_test("_ZNSt8ios_baseC2Ev_ptr", "std::ios_base::ios_base()"),
	mu_demangle_test("_ZNSt8ios_baseD2Ev_ptr", "std::ios_base::~ios_base()"),
	mu_demangle_test("_ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E_ptr", "std::ios::init(std::streambuf*)"),
	mu_demangle_test("_ZNSt9exceptionD2Ev_ptr", "std::exception::~exception()"),
	mu_demangle_test("_Znwm_ptr", "operator new(unsigned long)"),
	mu_demangle_test("_ZSt11_Hash_bytesPKvmm_ptr", "std::_Hash_bytes(void const*, unsigned long, unsigned long)"),
	mu_demangle_test("_ZSt16__ostream_insertIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_PKS3_l_ptr", "std::ostream& std::__ostream_insert<char, std::char_traits<char> >(std::ostream&, char const*, long)"),
	mu_demangle_test("_ZSt17__throw_bad_allocv_ptr", "std::__throw_bad_alloc()"),
	mu_demangle_test("_ZSt18_Rb_tree_decrementPKSt18_Rb_tree_node_base_ptr", "std::_Rb_tree_decrement(std::_Rb_tree_node_base const*)"),
	mu_demangle_test("_ZSt18_Rb_tree_decrementPSt18_Rb_tree_node_base_ptr", "std::_Rb_tree_decrement(std::_Rb_tree_node_base*)"),
	mu_demangle_test("_ZSt18_Rb_tree_incrementPKSt18_Rb_tree_node_base_ptr", "std::_Rb_tree_increment(std::_Rb_tree_node_base const*)"),
	mu_demangle_test("_ZSt18_Rb_tree_incrementPSt18_Rb_tree_node_base_ptr", "std::_Rb_tree_increment(std::_Rb_tree_node_base*)"),
	mu_demangle_test("_ZSt19__throw_logic_errorPKc_ptr", "std::__throw_logic_error(char const*)"),
	mu_demangle_test("_ZSt20__throw_length_errorPKc_ptr", "std::__throw_length_error(char const*)"),
	mu_demangle_test("_ZSt20__throw_out_of_rangePKc_ptr", "std::__throw_out_of_range(char const*)"),
	mu_demangle_test("_ZSt20__throw_system_errori_ptr", "std::__throw_system_error(int)"),
	mu_demangle_test("_ZSt24__throw_out_of_range_fmtPKcz_ptr", "std::__throw_out_of_range_fmt(char const*, ...)"),
	mu_demangle_test("_ZSt25__throw_bad_function_callv_ptr", "std::__throw_bad_function_call()"),
	mu_demangle_test("_ZSt28_Rb_tree_rebalance_for_erasePSt18_Rb_tree_node_baseRS__ptr", "std::_Rb_tree_rebalance_for_erase(std::_Rb_tree_node_base*, std::_Rb_tree_node_base&)"),
	mu_demangle_test("_ZSt29_Rb_tree_insert_and_rebalancebPSt18_Rb_tree_node_baseS0_RS__ptr", "std::_Rb_tree_insert_and_rebalance(bool, std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::_Rb_tree_node_base&)"),
	// INCORRECT : 	mu_demangle_test("_ZSt7getlineIcSt11char_traitsIcESaIcEERSt13basic_istreamIT_T0_ES7_RNSt7__cxx1112basic_stringIS4_S5_T1_EES4__ptr", "std::istream& std::getline<char, std::char_traits<char>, std::allocator<char> >(std::istream&, std::string&, char)"),
	mu_demangle_test("_ZSt9terminatev_ptr", "std::terminate()"),
	mu_demangle_test("_ZStlsISt11char_traitsIcEERSt13basic_ostreamIcT_ES5_PKc_ptr", "std::ostream& std::operator<< <std::char_traits<char> >(std::ostream&, char const*)"),
	mu_demangle_test("_ZTI12QApplication_ptr", "typeinfo for QApplication"),
	mu_demangle_test("_ZTI12QTextBrowser_ptr", "typeinfo for QTextBrowser"),
	mu_demangle_test("_ZTI12ReportWidget_ptr", "typeinfo for ReportWidget"),
	mu_demangle_test("_ZTI15FlowGraphWidget_ptr", "typeinfo for FlowGraphWidget"),
	mu_demangle_test("_ZTI22ReportCollectionWidget_ptr", "typeinfo for ReportCollectionWidget"),
	mu_demangle_test("_ZTI4View_ptr", "typeinfo for View"),
	mu_demangle_test("_ZTI6QEvent_ptr", "typeinfo for QEvent"),
	mu_demangle_test("_ZTI9QLineEdit_ptr", "typeinfo for QLineEdit"),
	mu_demangle_test("_ZTI9ViewFrame_ptr", "typeinfo for ViewFrame"),
	// INCORRECT : 	mu_demangle_test("_ZTTNSt7__cxx1118basic_stringstreamIcSt11char_traitsIcESaIcEEE_ptr", "VTT for std::stringstream"),
	// INCORRECT : 	mu_demangle_test("_ZTTNSt7__cxx1119basic_istringstreamIcSt11char_traitsIcESaIcEEE_ptr", "VTT for std::istringstream"),
	// INCORRECT : 	mu_demangle_test("_ZTTNSt7__cxx1119basic_ostringstreamIcSt11char_traitsIcESaIcEEE_ptr", "VTT for std::ostringstream"),
	mu_demangle_test("_ZTV10MenuHelper_ptr", "vtable for MenuHelper"),
	mu_demangle_test("_ZTV14ClickableLabel_ptr", "vtable for ClickableLabel"),
	mu_demangle_test("_ZTV15FormInputDialog_ptr", "vtable for FormInputDialog"),
	// INCORRECT : 	mu_demangle_test("_ZTVNSt7__cxx1115basic_stringbufIcSt11char_traitsIcESaIcEEE_ptr", "vtable for std::stringbuf"),
	// INCORRECT : 	mu_demangle_test("_ZTVNSt7__cxx1118basic_stringstreamIcSt11char_traitsIcESaIcEEE_ptr", "vtable for std::stringstream"),
	// INCORRECT : 	mu_demangle_test("_ZTVNSt7__cxx1119basic_istringstreamIcSt11char_traitsIcESaIcEEE_ptr", "vtable for std::istringstream"),
	// INCORRECT : 	mu_demangle_test("_ZTVNSt7__cxx1119basic_ostringstreamIcSt11char_traitsIcESaIcEEE_ptr", "vtable for std::ostringstream"),
	mu_demangle_test("_ZTVSt15basic_streambufIcSt11char_traitsIcEE_ptr", "vtable for std::streambuf"),
	mu_demangle_test("_ZTVSt9basic_iosIcSt11char_traitsIcEE_ptr", "vtable for std::ios"),
	mu_demangle_test("_Z14getPackageNameP7_JNIEnvP8_jobject", "getPackageName(_JNIEnv*, _jobject*)"),
	mu_demangle_test("_Z15JstringToStringP7_JNIEnvP8_jstring", "JstringToString(_JNIEnv*, _jstring*)"),
	mu_demangle_test("_Z13CharTojstringP7_JNIEnvPKc", "CharTojstring(_JNIEnv*, char const*)"),
	mu_demangle_test("_Z20invokeStaticMethodssP7_JNIEnvP8_jstringS2_", "invokeStaticMethodss(_JNIEnv*, _jstring*, _jstring*)"),
	mu_demangle_test("_Z16getFieldOjbectExP7_JNIEnvP7_jclassP8_jobjectP8_jstring", "getFieldOjbectEx(_JNIEnv*, _jclass*, _jobject*, _jstring*)"),
	mu_demangle_test("_Z14getFieldOjbectP7_JNIEnvP8_jstringP8_jobjectS2_", "getFieldOjbect(_JNIEnv*, _jstring*, _jobject*, _jstring*)"),
	mu_demangle_test("_Z16setFieldOjbectExP7_JNIEnvP7_jclassP8_jstringP8_jobjectS6_", "setFieldOjbectEx(_JNIEnv*, _jclass*, _jstring*, _jobject*, _jobject*)"),
	mu_demangle_test("_Z14setFieldOjbectP7_JNIEnvP8_jstringS2_P8_jobjectS4_", "setFieldOjbect(_JNIEnv*, _jstring*, _jstring*, _jobject*, _jobject*)"),
	mu_demangle_test("_Z14checkExceptionP7_JNIEnv", "checkException(_JNIEnv*)"),
	mu_demangle_test("_Z7forNameP7_JNIEnvP8_jstring", "forName(_JNIEnv*, _jstring*)"),
	mu_demangle_test("_Z11GetFileNamePc", "GetFileName(char*)"),
	mu_demangle_test("_Z10replaceAllPKcS0_S0_", "replaceAll(char const*, char const*, char const*)"),
	mu_demangle_test("_Z6decodeP7_JNIEnvP8_jstringS2_", "decode(_JNIEnv*, _jstring*, _jstring*)"),
	mu_demangle_test("_Z7sub_444P7_JNIEnvP8_jobjectS2_P8_jstringS4_", "sub_444(_JNIEnv*, _jobject*, _jobject*, _jstring*, _jstring*)"),
	mu_demangle_test("_Z7sub_333P7_JNIEnvP8_jobjectS2_P8_jstringS4_", "sub_333(_JNIEnv*, _jobject*, _jobject*, _jstring*, _jstring*)"),
	mu_demangle_test("_ZN25SystemClassLoaderInjector6injectEP7_JNIEnvP8_jobjectP8_jstringS5_", "SystemClassLoaderInjector::inject(_JNIEnv*, _jobject*, _jstring*, _jstring*)"),
	mu_demangle_test("_Z21registerNativeMethodsP7_JNIEnvPKcP15JNINativeMethodi", "registerNativeMethods(_JNIEnv*, char const*, JNINativeMethod*, int)"),
	mu_demangle_test("_Z17register_ndk_loadP7_JNIEnv", "register_ndk_load(_JNIEnv*)"),
	mu_demangle_test("_____Z17register_ndk_loadP7_JNIEnv", "register_ndk_load(_JNIEnv*)"),
	mu_demangle_test("___ZZN12foonamespace3Foo13inside_lambdaEvENKUlvE_clEv_block_invoke_7636", "foonamespace::Foo::inside_lambda()::{lambda()#1}::operator()() const block_invoke_7636"),
	mu_demangle_test("___ZN12foonamespace3FooC2Ev_block_invoke_7636", "foonamespace::Foo::Foo() block_invoke_7636"),
	mu_demangle_test("____Z20InstallSignalHandlerv_block_invoke", "InstallSignalHandler() block_invoke"),
	mu_demangle_test("____Z20InstallSignalHandlerv_block_invoke_2", "InstallSignalHandler() block_invoke_2"),
	mu_demangle_test("____ZN12_GLOBAL__N_117ScreenshotManagerC2Ev_block_invoke", "(anonymous namespace)::ScreenshotManager::ScreenshotManager() block_invoke"),
	mu_demangle_test("____ZN10screenshot29TryPromptUserForScreenCaptureEv_block_invoke", "screenshot::TryPromptUserForScreenCapture() block_invoke"),
	mu_demangle_test("_ZNKSt7__cxx1111basic_regexIcNS_12regex_traitsIcEEE5flagsEv", "std::regex::flags() const"),
	mu_demangle_test("_ZNSt7__cxx1111basic_regexIcNS_12regex_traitsIcEEE10_M_compileEPKcS5_NSt15regex_constants18syntax_option_typeE", "std::regex::_M_compile(char const*, char const*, std::regex_constants::syntax_option_type)"),
	mu_demangle_test("_ZNSt7__cxx1111basic_regexIcNS_12regex_traitsIcEEEC1EPKcNSt15regex_constants18syntax_option_typeE", "std::regex::regex(char const*, std::regex_constants::syntax_option_type)"),
	mu_demangle_test("_ZNSt7__cxx1111basic_regexIcNS_12regex_traitsIcEEEC2EPKcNSt15regex_constants18syntax_option_typeE", "std::regex::regex(char const*, std::regex_constants::syntax_option_type)"),
	mu_demangle_test("_ZNSt7__cxx1111basic_regexIcNS_12regex_traitsIcEEED1Ev", "std::regex::~regex()"),
	mu_demangle_test("_ZNSt7__cxx1111basic_regexIcNS_12regex_traitsIcEEED2Ev", "std::regex::~regex()"),
	mu_demangle_test("_ZNSt8__detail17__regex_algo_implIPKcSaINSt7__cxx119sub_matchIS2_EEEcNS3_12regex_traitsIcEEEEbT_S9_RNS3_13match_resultsIS9_T0_EERKNS3_11basic_regexIT1_T2_EENSt15regex_constants15match_flag_typeENS_20_RegexExecutorPolicyEb", "bool std::__detail::__regex_algo_impl<char const*, std::allocator<std::csub_match >, char, std::regex_traits<char> >(char const*, char const*, std::cmatch&, std::regex const&, std::regex_constants::match_flag_type, std::__detail::_RegexExecutorPolicy, bool)"),
	mu_demangle_test("_ZNSt8__detail9_ExecutorIPKcSaINSt7__cxx119sub_matchIS2_EEENS3_12regex_traitsIcEELb0EEC1ES2_S2_RSt6vectorIS5_S6_ERKNS3_11basic_regexIcS8_EENSt15regex_constants15match_flag_typeE", "std::__detail::_Executor<char, false>::_Executor(char const*, char const*, std::vector<std::csub_match>&, std::regex const&, std::regex_constants::match_flag_type)"),
	mu_demangle_test("_ZNSt8__detail9_ExecutorIPKcSaINSt7__cxx119sub_matchIS2_EEENS3_12regex_traitsIcEELb0EEC2ES2_S2_RSt6vectorIS5_S6_ERKNS3_11basic_regexIcS8_EENSt15regex_constants15match_flag_typeE", "std::__detail::_Executor<char, false>::_Executor(char const*, char const*, std::vector<std::csub_match>&, std::regex const&, std::regex_constants::match_flag_type)"),
	mu_demangle_test("_ZNSt8__detail9_ExecutorIPKcSaINSt7__cxx119sub_matchIS2_EEENS3_12regex_traitsIcEELb1EEC1ES2_S2_RSt6vectorIS5_S6_ERKNS3_11basic_regexIcS8_EENSt15regex_constants15match_flag_typeE", "std::__detail::_Executor<char, true>::_Executor(char const*, char const*, std::vector<std::csub_match>&, std::regex const&, std::regex_constants::match_flag_type)"),
	mu_demangle_test("_ZNSt8__detail9_ExecutorIPKcSaINSt7__cxx119sub_matchIS2_EEENS3_12regex_traitsIcEELb1EEC2ES2_S2_RSt6vectorIS5_S6_ERKNS3_11basic_regexIcS8_EENSt15regex_constants15match_flag_typeE", "std::__detail::_Executor<char, true>::_Executor(char const*, char const*, std::vector<std::csub_match>&, std::regex const&, std::regex_constants::match_flag_type)"),
	mu_demangle_test("_ZSt11regex_matchIcSaINSt7__cxx119sub_matchIPKcEEENS0_12regex_traitsIcEEEbPKT_RNS0_13match_resultsISA_T0_EERKNS0_11basic_regexIS8_T1_EENSt15regex_constants15match_flag_typeE", "bool std::regex_match<char>(char const*, std::cmatch&, std::regex const&, std::regex_constants::match_flag_type)"),
	mu_demangle_test("_ZSt11regex_matchIPKcSaINSt7__cxx119sub_matchIS1_EEEcNS2_12regex_traitsIcEEEbT_S8_RNS2_13match_resultsIS8_T0_EERKNS2_11basic_regexIT1_T2_EENSt15regex_constants15match_flag_typeE", "bool std::regex_match<char>(char const*, char const*, std::cmatch&, std::regex const&, std::regex_constants::match_flag_type)"),
	mu_demangle_test("_ZSt12regex_searchIcSaINSt7__cxx119sub_matchIPKcEEENS0_12regex_traitsIcEEEbPKT_RNS0_13match_resultsISA_T0_EERKNS0_11basic_regexIS8_T1_EENSt15regex_constants15match_flag_typeE", "bool std::regex_search<char>(char const*, std::cmatch&, std::regex const&, std::regex_constants::match_flag_type)"),
	mu_demangle_test("_ZSt12regex_searchIPKcSaINSt7__cxx119sub_matchIS1_EEEcNS2_12regex_traitsIcEEEbT_S8_RNS2_13match_resultsIS8_T0_EERKNS2_11basic_regexIT1_T2_EENSt15regex_constants15match_flag_typeE", "bool std::regex_search<char>(char const*, char const*, std::cmatch&, std::regex const&, std::regex_constants::match_flag_type)"),
	// end
	// The following test cases are a copied and modified version of https://raw.githubusercontent.com/ianlancetaylor/demangle/refs/heads/master/cases_test.go
	// This modified version is licensed under as LGPL-3.0-only
  mu_demangle_test("_Z1A", "A"),
	mu_demangle_test("_Z1Av", "A()"),
	mu_demangle_test("_Z1A1B1C", "A(B, C)"),
	mu_demangle_test("_Z4testI1A1BE1Cv", "C test<A, B>()"),
	mu_demangle_test("_Z4testI1A1BET0_T_S3_", "B test<A, B>(A, A)"),
	mu_demangle_test("_ZN1SgtEi", "S::operator>(int)"),
	mu_demangle_test("_ZrsI1QEiT_i", "int operator>><Q>(Q, int)"),
	mu_demangle_test("_ZN13dyldbootstrap5startEPK12macho_headeriPPKcl", "dyldbootstrap::start(macho_header const*, int, char const**, long)"),
	mu_demangle_test("_ZN4dyld17getExecutablePathEv", "dyld::getExecutablePath()"),
	mu_demangle_test("_ZN4dyld22mainExecutablePreboundEv", "dyld::mainExecutablePrebound()"),
	mu_demangle_test("_ZN4dyld14mainExecutableEv", "dyld::mainExecutable()"),
	mu_demangle_test("_ZN4dyld21findImageByMachHeaderEPK11mach_header", "dyld::findImageByMachHeader(mach_header const*)"),
	mu_demangle_test("_ZN4dyld26findImageContainingAddressEPKv", "dyld::findImageContainingAddress(void const*)"),
	mu_demangle_test("_ZN4dyld17clearErrorMessageEv", "dyld::clearErrorMessage()"),
	mu_demangle_test("_ZN4dyld15getErrorMessageEv", "dyld::getErrorMessage()"),
	mu_demangle_test("_ZN4dyld24registerUndefinedHandlerEPFvPKcE", "dyld::registerUndefinedHandler(void (*)(char const*))"),
	mu_demangle_test("_ZN4dyld19openSharedCacheFileEv", "dyld::openSharedCacheFile()"),
	mu_demangle_test("_ZN4dyld15setErrorMessageEPKc", "dyld::setErrorMessage(char const*)"),
	mu_demangle_test("_ZN4dyld22registerRemoveCallbackEPFvPK11mach_headerlE", "dyld::registerRemoveCallback(void (*)(mach_header const*, long))"),
	mu_demangle_test("_ZN4dyld13inSharedCacheEPKc", "dyld::inSharedCache(char const*)"),
	mu_demangle_test("_ZN4dyld15runInitializersEP11ImageLoader", "dyld::runInitializers(ImageLoader*)"),
	mu_demangle_test("_ZN4dyld27findCoalescedExportedSymbolEPKcPPKN11ImageLoader6SymbolEPPKS2_", "dyld::findCoalescedExportedSymbol(char const*, ImageLoader::Symbol const**, ImageLoader const**)"),
	mu_demangle_test("_ZN4dyld22flatFindExportedSymbolEPKcPPKN11ImageLoader6SymbolEPPKS2_", "dyld::flatFindExportedSymbol(char const*, ImageLoader::Symbol const**, ImageLoader const**)"),
	mu_demangle_test("_ZN4dyld15findLoadedImageERK4stat", "dyld::findLoadedImage(stat const&)"),
	mu_demangle_test("_ZN4dyld24initializeMainExecutableEv", "dyld::initializeMainExecutable()"),
	mu_demangle_test("_ZN4dyld4warnEPKcz", "dyld::warn(char const*, ...)"),
	mu_demangle_test("_ZN4dyld29processDyldEnvironmentVaribleEPKcS1_", "dyld::processDyldEnvironmentVarible(char const*, char const*)"),
	mu_demangle_test("_ZN4dyld3logEPKcz", "dyld::log(char const*, ...)"),
	mu_demangle_test("_ZN4dyld6throwfEPKcz", "dyld::throwf(char const*, ...)"),
	mu_demangle_test("_ZN4dyld9mkstringfEPKcz", "dyld::mkstringf(char const*, ...)"),
	mu_demangle_test("_ZN4dyld14addMappedRangeEP11ImageLoadermm", "dyld::addMappedRange(ImageLoader*, unsigned long, unsigned long)"),
	mu_demangle_test("_Z28coresymbolication_load_imageP25CSCppDyldSharedMemoryPagePK11ImageLoadery", "coresymbolication_load_image(CSCppDyldSharedMemoryPage*, ImageLoader const*, uint64_t)"),
	mu_demangle_test("_Z30coresymbolication_unload_imageP25CSCppDyldSharedMemoryPagePK11ImageLoader", "coresymbolication_unload_image(CSCppDyldSharedMemoryPage*, ImageLoader const*)"),
	mu_demangle_test("_ZN4dyld18getCoalescedImagesEPP11ImageLoader", "dyld::getCoalescedImages(ImageLoader**)"),
	mu_demangle_test("_ZN4dyld25findImageContainingSymbolEPKv", "dyld::findImageContainingSymbol(void const*)"),
	mu_demangle_test("_ZN4dyld19registerAddCallbackEPFvPK11mach_headerlE", "dyld::registerAddCallback(void (*)(mach_header const*, long))"),
	mu_demangle_test("_ZN4dyld14forEachImageDoEPFvP11ImageLoaderPvES2_", "dyld::forEachImageDo(void (*)(ImageLoader*, void*), void*)"),
	mu_demangle_test("_ZN4dyld15getIndexedImageEj", "dyld::getIndexedImage(unsigned int)"),
	mu_demangle_test("_ZN4dyld13getImageCountEv", "dyld::getImageCount()"),
	mu_demangle_test("_ZN4dyld10validImageEPK11ImageLoader", "dyld::validImage(ImageLoader const*)"),
	mu_demangle_test("_ZN4dyld30flatFindExportedSymbolWithHintEPKcS1_PPKN11ImageLoader6SymbolEPPKS2_", "dyld::flatFindExportedSymbolWithHint(char const*, char const*, ImageLoader::Symbol const**, ImageLoader const**)"),
	mu_demangle_test("_ZN4dyld14loadFromMemoryEPKhyPKc", "dyld::loadFromMemory(unsigned char const*, uint64_t, char const*)"),
	mu_demangle_test("_ZN4dyld36registerImageStateBatchChangeHandlerE17dyld_image_statesPFPKcS0_jPK15dyld_image_infoE", "dyld::registerImageStateBatchChangeHandler(dyld_image_states, char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*))"),
	mu_demangle_test("_ZN4dyld37registerImageStateSingleChangeHandlerE17dyld_image_statesPFPKcS0_jPK15dyld_image_infoE", "dyld::registerImageStateSingleChangeHandler(dyld_image_states, char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*))"),
	mu_demangle_test("_ZN4dyld4haltEPKc", "dyld::halt(char const*)"),
	mu_demangle_test("_ZN4dyld18fastBindLazySymbolEPP11ImageLoaderm", "dyld::fastBindLazySymbol(ImageLoader**, unsigned long)"),
	mu_demangle_test("_ZN4dyld14bindLazySymbolEPK11mach_headerPm", "dyld::bindLazySymbol(mach_header const*, unsigned long*)"),
	mu_demangle_test("_ZN4dyld14runTerminatorsEPv", "dyld::runTerminators(void*)"),
	mu_demangle_test("_ZN4dyld11removeImageEP11ImageLoader", "dyld::removeImage(ImageLoader*)"),
	mu_demangle_test("_ZN4dyld20garbageCollectImagesEv", "dyld::garbageCollectImages()"),
	mu_demangle_test("_ZN4dyld9preflightEP11ImageLoaderRKNS0_10RPathChainE", "dyld::preflight(ImageLoader*, ImageLoader::RPathChain const&)"),
	mu_demangle_test("_ZN4dyld4linkEP11ImageLoaderbRKNS0_10RPathChainE", "dyld::link(ImageLoader*, bool, ImageLoader::RPathChain const&)"),
	mu_demangle_test("_ZN4dyld10cloneImageEP11ImageLoader", "dyld::cloneImage(ImageLoader*)"),
	mu_demangle_test("_ZN4dyld4loadEPKcRKNS_11LoadContextE", "dyld::load(char const*, dyld::LoadContext const&)"),
	mu_demangle_test("_ZN4dyld5_mainEPK12macho_headermiPPKcS5_S5_", "dyld::_main(macho_header const*, unsigned long, int, char const**, char const**, char const**)"),
	mu_demangle_test("_ZNSt12_Vector_baseIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EED2Ev", "std::_Vector_base<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::~_Vector_base()"),
	mu_demangle_test("_ZNSt6vectorIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EED2Ev", "std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::~vector()"),
	mu_demangle_test("_ZNSt12_Vector_baseIPFvPK11mach_headerlESaIS4_EED2Ev", "std::_Vector_base<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::~_Vector_base()"),
	mu_demangle_test("_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EED2Ev", "std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::~vector()"),
	mu_demangle_test("_ZSt18uninitialized_copyIPPFPKc17dyld_image_statesjPK15dyld_image_infoES8_ET0_T_SA_S9_", "char const* (**std::uninitialized_copy<char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*)>(char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*)))(dyld_image_states, unsigned int, dyld_image_info const*)"),
	mu_demangle_test("_ZSt18uninitialized_copyIPPFvPK11mach_headerlES5_ET0_T_S7_S6_", "void (**std::uninitialized_copy<void (**)(mach_header const*, long), void (**)(mach_header const*, long)>(void (**)(mach_header const*, long), void (**)(mach_header const*, long), void (**)(mach_header const*, long)))(mach_header const*, long)"),
	mu_demangle_test("_ZSt18uninitialized_copyIPPKcS2_ET0_T_S4_S3_", "char const** std::uninitialized_copy<char const**, char const**>(char const**, char const**, char const**)"),
	mu_demangle_test("_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIPFPKc17dyld_image_statesjPK15dyld_image_infoEEEPT_PKSB_SE_SC_", "char const* (**std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)>(char const* (* const*)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (* const*)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*)))(dyld_image_states, unsigned int, dyld_image_info const*)"),
	mu_demangle_test("_ZNSt6vectorIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EE9push_backERKS7_", "std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::push_back(char const* (* const&)(dyld_image_states, unsigned int, dyld_image_info const*))"),
	mu_demangle_test("_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIPFvPK11mach_headerlEEEPT_PKS8_SB_S9_", "void (**std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<void (*)(mach_header const*, long)>(void (* const*)(mach_header const*, long), void (* const*)(mach_header const*, long), void (**)(mach_header const*, long)))(mach_header const*, long)"),
	mu_demangle_test("_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EE9push_backERKS4_", "std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::push_back(void (* const&)(mach_header const*, long))"),
	mu_demangle_test("_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIPKcEEPT_PKS5_S8_S6_", "char const** std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<char const*>(char const* const*, char const* const*, char const**)"),
	mu_demangle_test("_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIP11ImageLoaderEEPT_PKS5_S8_S6_", "ImageLoader** std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<ImageLoader*>(ImageLoader* const*, ImageLoader* const*, ImageLoader**)"),
	mu_demangle_test("_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EE20_M_allocate_and_copyIPS4_EES8_mT_S9_", "void (**std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::_M_allocate_and_copy<void (**)(mach_header const*, long)>(unsigned long, void (**)(mach_header const*, long), void (**)(mach_header const*, long)))(mach_header const*, long)"),
	mu_demangle_test("_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EE7reserveEm", "std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::reserve(unsigned long)"),
	mu_demangle_test("_ZSt18uninitialized_copyIPP11ImageLoaderS2_ET0_T_S4_S3_", "ImageLoader** std::uninitialized_copy<ImageLoader**, ImageLoader**>(ImageLoader**, ImageLoader**, ImageLoader**)"),
	mu_demangle_test("_Z18lookupDyldFunctionPKcPm", "lookupDyldFunction(char const*, unsigned long*)"),
	mu_demangle_test("_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIP19__NSObjectFileImageEEPT_PKS5_S8_S6_", "__NSObjectFileImage** std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<__NSObjectFileImage*>(__NSObjectFileImage* const*, __NSObjectFileImage* const*, __NSObjectFileImage**)"),
	mu_demangle_test("_Z19setAlImageInfosHaltPKcm", "setAlImageInfosHalt(char const*, unsigned long)"),
	mu_demangle_test("_Z24removeImageFromAllImagesPK11mach_header", "removeImageFromAllImages(mach_header const*)"),
	mu_demangle_test("_Z20addImagesToAllImagesjPK15dyld_image_info", "addImagesToAllImages(unsigned int, dyld_image_info const*)"),
	mu_demangle_test("_ZN10__cxxabiv112__unexpectedEPFvvE", "__cxxabiv1::__unexpected(void (*)())"),
	mu_demangle_test("_ZN10__cxxabiv111__terminateEPFvvE", "__cxxabiv1::__terminate(void (*)())"),
	mu_demangle_test("_ZSt10unexpectedv", "std::unexpected()"),
	mu_demangle_test("_ZSt9terminatev", "std::terminate()"),
	mu_demangle_test("_ZN11ImageLoaderC2EPKcj", "ImageLoader::ImageLoader(char const*, unsigned int)"),
	mu_demangle_test("_ZN11ImageLoader11deleteImageEPS_", "ImageLoader::deleteImage(ImageLoader*)"),
	mu_demangle_test("_ZN11ImageLoader11setFileInfoEiyl", "ImageLoader::setFileInfo(int, uint64_t, long)"),
	mu_demangle_test("_ZN11ImageLoader9setMappedERKNS_11LinkContextE", "ImageLoader::setMapped(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK11ImageLoader7compareEPKS_", "ImageLoader::compare(ImageLoader const*) const"),
	mu_demangle_test("_ZN11ImageLoader4hashEPKc", "ImageLoader::hash(char const*)"),
	mu_demangle_test("_ZNK11ImageLoader16matchInstallPathEv", "ImageLoader::matchInstallPath() const"),
	mu_demangle_test("_ZN11ImageLoader19setMatchInstallPathEb", "ImageLoader::setMatchInstallPath(bool)"),
	mu_demangle_test("_ZNK11ImageLoader9statMatchERK4stat", "ImageLoader::statMatch(stat const&) const"),
	mu_demangle_test("_ZN11ImageLoader14setLeaveMappedEv", "ImageLoader::setLeaveMapped()"),
	mu_demangle_test("_ZN11ImageLoader14setHideExportsEb", "ImageLoader::setHideExports(bool)"),
	mu_demangle_test("_ZNK11ImageLoader16hasHiddenExportsEv", "ImageLoader::hasHiddenExports() const"),
	mu_demangle_test("_ZNK11ImageLoader8isLinkedEv", "ImageLoader::isLinked() const"),
	mu_demangle_test("_ZNK11ImageLoader12lastModifiedEv", "ImageLoader::lastModified() const"),
	mu_demangle_test("_ZNK11ImageLoader24overlapsWithAddressRangeEPKvS1_", "ImageLoader::overlapsWithAddressRange(void const*, void const*) const"),
	mu_demangle_test("_ZNK11ImageLoader16getMappedRegionsERPNS_12MappedRegionE", "ImageLoader::getMappedRegions(ImageLoader::MappedRegion*&) const"),
	mu_demangle_test("_ZNK11ImageLoader41findExportedSymbolInDependentImagesExceptEPKcPPKS_RS4_S4_S4_", "ImageLoader::findExportedSymbolInDependentImagesExcept(char const*, ImageLoader const**, ImageLoader const**&, ImageLoader const**, ImageLoader const**) const"),
	mu_demangle_test("_ZN11ImageLoader29decrementDlopenReferenceCountEv", "ImageLoader::decrementDlopenReferenceCount()"),
	mu_demangle_test("_ZN11ImageLoader19bindAllLazyPointersERKNS_11LinkContextEb", "ImageLoader::bindAllLazyPointers(ImageLoader::LinkContext const&, bool)"),
	mu_demangle_test("_ZNK11ImageLoader35allDependentLibrariesAsWhenPreBoundEv", "ImageLoader::allDependentLibrariesAsWhenPreBound() const"),
	mu_demangle_test("_ZN11ImageLoader20recursiveUpdateDepthEj", "ImageLoader::recursiveUpdateDepth(unsigned int)"),
	mu_demangle_test("_ZNK11ImageLoader12getShortNameEv", "ImageLoader::getShortName() const"),
	mu_demangle_test("_ZN11ImageLoader9addSuffixEPKcS1_Pc", "ImageLoader::addSuffix(char const*, char const*, char*)"),
	mu_demangle_test("_ZN11ImageLoader15printStatisticsEj", "ImageLoader::printStatistics(unsigned int)"),
	mu_demangle_test("_ZN11ImageLoader13recursiveBindERKNS_11LinkContextEb", "ImageLoader::recursiveBind(ImageLoader::LinkContext const&, bool)"),
	mu_demangle_test("_ZN11ImageLoader25recursiveApplyInterposingERKNS_11LinkContextE", "ImageLoader::recursiveApplyInterposing(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN11ImageLoader16applyInterposingERKNS_11LinkContextE", "ImageLoader::applyInterposing(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN11ImageLoader15recursiveRebaseERKNS_11LinkContextE", "ImageLoader::recursiveRebase(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK11ImageLoader42findExportedSymbolInImageOrDependentImagesEPKcRKNS_11LinkContextEPPKS_", "ImageLoader::findExportedSymbolInImageOrDependentImages(char const*, ImageLoader::LinkContext const&, ImageLoader const**) const"),
	mu_demangle_test("_ZNK11ImageLoader35findExportedSymbolInDependentImagesEPKcRKNS_11LinkContextEPPKS_", "ImageLoader::findExportedSymbolInDependentImages(char const*, ImageLoader::LinkContext const&, ImageLoader const**) const"),
	mu_demangle_test("_ZN11ImageLoader8reExportEPS_", "ImageLoader::reExport(ImageLoader*)"),
	mu_demangle_test("_ZN11ImageLoader19addDynamicReferenceEPKS_", "ImageLoader::addDynamicReference(ImageLoader const*)"),
	mu_demangle_test("_ZN11ImageLoader14setPathUnownedEPKc", "ImageLoader::setPathUnowned(char const*)"),
	mu_demangle_test("_ZN11ImageLoader7setPathEPKc", "ImageLoader::setPath(char const*)"),
	mu_demangle_test("_ZN11ImageLoaderD0Ev", "ImageLoader::~ImageLoader()"),
	mu_demangle_test("_ZNK11ImageLoader15containsAddressEPKv", "ImageLoader::containsAddress(void const*) const"),
	mu_demangle_test("_ZN11ImageLoaderD2Ev", "ImageLoader::~ImageLoader()"),
	mu_demangle_test("_ZN11ImageLoaderD1Ev", "ImageLoader::~ImageLoader()"),
	mu_demangle_test("_ZN11ImageLoader23recursiveInitializationERKNS_11LinkContextEj", "ImageLoader::recursiveInitialization(ImageLoader::LinkContext const&, unsigned int)"),
	mu_demangle_test("_ZN11ImageLoader15runInitializersERKNS_11LinkContextE", "ImageLoader::runInitializers(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN11ImageLoader8weakBindERKNS_11LinkContextE", "ImageLoader::weakBind(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN11ImageLoader22recursiveLoadLibrariesERKNS_11LinkContextEbRKNS_10RPathChainE", "ImageLoader::recursiveLoadLibraries(ImageLoader::LinkContext const&, bool, ImageLoader::RPathChain const&)"),
	mu_demangle_test("_ZN11ImageLoader4linkERKNS_11LinkContextEbbRKNS_10RPathChainE", "ImageLoader::link(ImageLoader::LinkContext const&, bool, bool, ImageLoader::RPathChain const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE8_M_eraseEPSt13_Rb_tree_nodeIS2_E", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_erase(std::_Rb_tree_node<ImageLoader const*>*)"),
	mu_demangle_test("_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE14_M_create_nodeERKS2_", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_create_node(ImageLoader const* const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE9_M_insertEPSt18_Rb_tree_node_baseSA_RKS2_", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, ImageLoader const* const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE16_M_insert_uniqueERKS2_", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_insert_unique(ImageLoader const* const&)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO12segmentCountEv", "ImageLoaderMachO::segmentCount() const"),
	mu_demangle_test("_ZN16ImageLoaderMachO22segHasTrailingZeroFillEj", "ImageLoaderMachO::segHasTrailingZeroFill(unsigned int)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO19segActualEndAddressEj", "ImageLoaderMachO::segActualEndAddress(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO25segmentsMustSlideTogetherEv", "ImageLoaderMachO::segmentsMustSlideTogether() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO16segmentsCanSlideEv", "ImageLoaderMachO::segmentsCanSlide() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO8isBundleEv", "ImageLoaderMachO::isBundle() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO7isDylibEv", "ImageLoaderMachO::isDylib() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO12isExecutableEv", "ImageLoaderMachO::isExecutable() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO31isPositionIndependentExecutableEv", "ImageLoaderMachO::isPositionIndependentExecutable() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO9forceFlatEv", "ImageLoaderMachO::forceFlat() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO21usesTwoLevelNameSpaceEv", "ImageLoaderMachO::usesTwoLevelNameSpace() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO13isPrebindableEv", "ImageLoaderMachO::isPrebindable() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO19hasCoalescedExportsEv", "ImageLoaderMachO::hasCoalescedExports() const"),
	mu_demangle_test("_ZN16ImageLoaderMachO8setSlideEl", "ImageLoaderMachO::setSlide(long)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO14getInstallPathEv", "ImageLoaderMachO::getInstallPath() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO7getMainEv", "ImageLoaderMachO::getMain() const"),
	mu_demangle_test("_ZN16ImageLoaderMachO16doGetLibraryInfoEv", "ImageLoaderMachO::doGetLibraryInfo()"),
	mu_demangle_test("_ZNK16ImageLoaderMachO21getExportedSymbolInfoEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getExportedSymbolInfo(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO21getExportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getExportedSymbolName(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO22getExportedSymbolCountEv", "ImageLoaderMachO::getExportedSymbolCount() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO24getIndexedExportedSymbolEj", "ImageLoaderMachO::getIndexedExportedSymbol(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO22getImportedSymbolCountEv", "ImageLoaderMachO::getImportedSymbolCount() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO24getIndexedImportedSymbolEj", "ImageLoaderMachO::getIndexedImportedSymbol(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO21getImportedSymbolInfoEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getImportedSymbolInfo(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO21getImportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getImportedSymbolName(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZN16ImageLoaderMachO13getUnwindInfoEP20dyld_unwind_sections", "ImageLoaderMachO::getUnwindInfo(dyld_unwind_sections*)"),
	mu_demangle_test("_ZN16ImageLoaderMachO11findSectionEPKvPPKcS4_Pm", "ImageLoaderMachO::findSection(void const*, char const**, char const**, unsigned long*)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO10machHeaderEv", "ImageLoaderMachO::machHeader() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO8getSlideEv", "ImageLoaderMachO::getSlide() const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO17lookupProgramVarsERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::lookupProgramVars(ImageLoader::LinkContext const&) const"),
	mu_demangle_test("_ZN16ImageLoaderMachO19needsInitializationEv", "ImageLoaderMachO::needsInitialization()"),
	mu_demangle_test("_ZN16ImageLoaderMachO16needsTerminationEv", "ImageLoaderMachO::needsTermination()"),
	mu_demangle_test("_ZN16ImageLoaderMachO10segProtectEjRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::segProtect(unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO18doModInitFunctionsERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doModInitFunctions(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO11doImageInitERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doImageInit(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO16doInitializationERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doInitialization(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO16getSymbolAddressEPKN11ImageLoader6SymbolEPKS0_RKNS0_11LinkContextE", "ImageLoaderMachO::getSymbolAddress(ImageLoader::Symbol const*, ImageLoader const*, ImageLoader::LinkContext const&) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO24getExportedSymbolAddressEPKN11ImageLoader6SymbolERKNS0_11LinkContextEPKS0_", "ImageLoaderMachO::getExportedSymbolAddress(ImageLoader::Symbol const*, ImageLoader::LinkContext const&, ImageLoader const*) const"),
	mu_demangle_test("_ZN16ImageLoaderMachO19throwSymbolNotFoundEPKcS1_S1_", "ImageLoaderMachO::throwSymbolNotFound(char const*, char const*, char const*)"),
	mu_demangle_test("_ZN16ImageLoaderMachO21reserveAnAddressRangeEmRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::reserveAnAddressRange(unsigned long, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO23setupLazyPointerHandlerERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::setupLazyPointerHandler(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO6getEndEv", "ImageLoaderMachO::getEnd() const"),
	mu_demangle_test("_ZN16ImageLoaderMachO17getSectionContentEPKcS1_PPvPm", "ImageLoaderMachO::getSectionContent(char const*, char const*, void**, unsigned long*)"),
	mu_demangle_test("_ZN16ImageLoaderMachO13parseLoadCmdsEv", "ImageLoaderMachO::parseLoadCmds()"),
	mu_demangle_test("_ZN16ImageLoaderMachO15printStatisticsEj", "ImageLoaderMachO::printStatistics(unsigned int)"),
	mu_demangle_test("_ZN16ImageLoaderMachO12bindLocationERKN11ImageLoader11LinkContextEmmPKS0_hPKclS7_", "ImageLoaderMachO::bindLocation(ImageLoader::LinkContext const&, unsigned long, unsigned long, ImageLoader const*, unsigned char, char const*, long, char const*)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO16usablePrebindingERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::usablePrebinding(ImageLoader::LinkContext const&) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO7getUUIDEPh", "ImageLoaderMachO::getUUID(unsigned char*) const"),
	mu_demangle_test("_ZN16ImageLoaderMachO26needsAddedLibSystemDepencyEjPK12macho_header", "ImageLoaderMachO::needsAddedLibSystemDepency(unsigned int, macho_header const*)"),
	mu_demangle_test("_ZN16ImageLoaderMachO23doGetDependentLibrariesEPN11ImageLoader20DependentLibraryInfoE", "ImageLoaderMachO::doGetDependentLibraries(ImageLoader::DependentLibraryInfo*)"),
	mu_demangle_test("_ZN16ImageLoaderMachO17sniffLoadCommandsEPK12macho_headerPKcPbPjS6_", "ImageLoaderMachO::sniffLoadCommands(macho_header const*, char const*, bool*, unsigned int*, unsigned int*)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO24participatesInCoalescingEv", "ImageLoaderMachO::participatesInCoalescing() const"),
	mu_demangle_test("_ZN16ImageLoaderMachO12preFetchDATAEiyRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::preFetchDATA(int, uint64_t, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO13UnmapSegmentsEv", "ImageLoaderMachO::UnmapSegments()"),
	mu_demangle_test("_ZN16ImageLoaderMachO7destroyEv", "ImageLoaderMachO::destroy()"),
	mu_demangle_test("_ZN16ImageLoaderMachO21instantiateFromMemoryEPKcPK12macho_headeryRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateFromMemory(char const*, macho_header const*, uint64_t, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO20instantiateFromCacheEPK12macho_headerPKcRK4statRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateFromCache(macho_header const*, char const*, stat const&, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO19instantiateFromFileEPKciPKhyyRK4statRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateFromFile(char const*, int, unsigned char const*, uint64_t, uint64_t, stat const&, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO25instantiateMainExecutableEPK12macho_headermPKcRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateMainExecutable(macho_header const*, unsigned long, char const*, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachOC2EPK12macho_headerPKcjPjj", "ImageLoaderMachO::ImageLoaderMachO(macho_header const*, char const*, unsigned int, unsigned int*, unsigned int)"),
	mu_demangle_test("_ZN16ImageLoaderMachO13doTerminationERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doTermination(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO8doRebaseERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doRebase(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO19registerInterposingEv", "ImageLoaderMachO::registerInterposing()"),
	mu_demangle_test("_ZNK16ImageLoaderMachO18findExportedSymbolEPKcbPPK11ImageLoader", "ImageLoaderMachO::findExportedSymbol(char const*, bool, ImageLoader const**) const"),
	mu_demangle_test("_ZN16ImageLoaderMachO22assignSegmentAddressesERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::assignSegmentAddresses(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO11mapSegmentsEPKvyRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::mapSegments(void const*, uint64_t, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN16ImageLoaderMachO11mapSegmentsEiyyyRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::mapSegments(int, uint64_t, uint64_t, uint64_t, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK16ImageLoaderMachO23segPreferredLoadAddressEj", "ImageLoaderMachO::segPreferredLoadAddress(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO26segHasPreferredLoadAddressEj", "ImageLoaderMachO::segHasPreferredLoadAddress(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO15segUnaccessibleEj", "ImageLoaderMachO::segUnaccessible(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO13segExecutableEj", "ImageLoaderMachO::segExecutable(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO20segActualLoadAddressEj", "ImageLoaderMachO::segActualLoadAddress(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO7segSizeEj", "ImageLoaderMachO::segSize(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO7segNameEj", "ImageLoaderMachO::segName(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO12segWriteableEj", "ImageLoaderMachO::segWriteable(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO11segReadableEj", "ImageLoaderMachO::segReadable(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO13segFileOffsetEj", "ImageLoaderMachO::segFileOffset(unsigned int) const"),
	mu_demangle_test("_ZNK16ImageLoaderMachO11segFileSizeEj", "ImageLoaderMachO::segFileSize(unsigned int) const"),
	mu_demangle_test("_ZN16ImageLoaderMachOD2Ev", "ImageLoaderMachO::~ImageLoaderMachO()"),
	mu_demangle_test("_ZN16ImageLoaderMachOD1Ev", "ImageLoaderMachO::~ImageLoaderMachO()"),
	mu_demangle_test("_ZN16ImageLoaderMachOD0Ev", "ImageLoaderMachO::~ImageLoaderMachO()"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic21segmentCommandOffsetsEv", "ImageLoaderMachOClassic::segmentCommandOffsets() const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic8libImageEj", "ImageLoaderMachOClassic::libImage(unsigned int) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic13libReExportedEj", "ImageLoaderMachOClassic::libReExported(unsigned int) const"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic11setLibImageEjP11ImageLoaderb", "ImageLoaderMachOClassic::setLibImage(unsigned int, ImageLoader*, bool)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic18setSymbolTableInfoEPK11macho_nlistPKcPK16dysymtab_command", "ImageLoaderMachOClassic::setSymbolTableInfo(macho_nlist const*, char const*, dysymtab_command const*)"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic14containsSymbolEPKv", "ImageLoaderMachOClassic::containsSymbol(void const*) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic21exportedSymbolAddressEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::exportedSymbolAddress(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic29exportedSymbolIsWeakDefintionEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::exportedSymbolIsWeakDefintion(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic18exportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::exportedSymbolName(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic19exportedSymbolCountEv", "ImageLoaderMachOClassic::exportedSymbolCount() const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic21exportedSymbolIndexedEj", "ImageLoaderMachOClassic::exportedSymbolIndexed(unsigned int) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic19importedSymbolCountEv", "ImageLoaderMachOClassic::importedSymbolCount() const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic21importedSymbolIndexedEj", "ImageLoaderMachOClassic::importedSymbolIndexed(unsigned int) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic18importedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::importedSymbolName(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic22initializeCoalIteratorERN11ImageLoader12CoalIteratorEj", "ImageLoaderMachOClassic::initializeCoalIterator(ImageLoader::CoalIterator&, unsigned int)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic21incrementCoalIteratorERN11ImageLoader12CoalIteratorE", "ImageLoaderMachOClassic::incrementCoalIterator(ImageLoader::CoalIterator&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic22getAddressCoalIteratorERN11ImageLoader12CoalIteratorERKNS0_11LinkContextE", "ImageLoaderMachOClassic::getAddressCoalIterator(ImageLoader::CoalIterator&, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic17findClosestSymbolEPKvPS1_", "ImageLoaderMachOClassic::findClosestSymbol(void const*, void const**) const"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic20doBindFastLazySymbolEjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindFastLazySymbol(unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic30getFirstWritableSegmentAddressEv", "ImageLoaderMachOClassic::getFirstWritableSegmentAddress()"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic18bindIndirectSymbolEPmPK13macho_sectionPKcmPK11ImageLoaderRKNS6_11LinkContextE", "ImageLoaderMachOClassic::bindIndirectSymbol(unsigned long*, macho_section const*, char const*, unsigned long, ImageLoader const*, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic12binarySearchEPKcS1_PK11macho_nlistj", "ImageLoaderMachOClassic::binarySearch(char const*, char const*, macho_nlist const*, unsigned int) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic19binarySearchWithTocEPKcS1_PK11macho_nlistPK23dylib_table_of_contentsjj", "ImageLoaderMachOClassic::binarySearchWithToc(char const*, char const*, macho_nlist const*, dylib_table_of_contents const*, unsigned int, unsigned int) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic18findExportedSymbolEPKcPPK11ImageLoader", "ImageLoaderMachOClassic::findExportedSymbol(char const*, ImageLoader const**) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic13hasSubLibraryERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOClassic::hasSubLibrary(ImageLoader::LinkContext const&, ImageLoader const*) const"),
	mu_demangle_test("_ZNK23ImageLoaderMachOClassic16isSubframeworkOfERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOClassic::isSubframeworkOf(ImageLoader::LinkContext const&, ImageLoader const*) const"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic18mapSegmentsClassicEiyyyRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::mapSegmentsClassic(int, uint64_t, uint64_t, uint64_t, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic16prefetchLINKEDITERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::prefetchLINKEDIT(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassicD2Ev", "ImageLoaderMachOClassic::~ImageLoaderMachOClassic()"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassicD1Ev", "ImageLoaderMachOClassic::~ImageLoaderMachOClassic()"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassicD0Ev", "ImageLoaderMachOClassic::~ImageLoaderMachOClassic()"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic17instantiateFinishERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFinish(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic6rebaseERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::rebase(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic11doInterposeERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doInterpose(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic16resolveUndefinedERKN11ImageLoader11LinkContextEPK11macho_nlistbbPPKS0_", "ImageLoaderMachOClassic::resolveUndefined(ImageLoader::LinkContext const&, macho_nlist const*, bool, bool, ImageLoader const**)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic26bindIndirectSymbolPointersERKN11ImageLoader11LinkContextEbb", "ImageLoaderMachOClassic::bindIndirectSymbolPointers(ImageLoader::LinkContext const&, bool, bool)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic16doBindJustLaziesERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindJustLazies(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic16doBindLazySymbolEPmRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindLazySymbol(unsigned long*, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic16instantiateStartEPK12macho_headerPKcjj", "ImageLoaderMachOClassic::instantiateStart(macho_header const*, char const*, unsigned int, unsigned int)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic21instantiateFromMemoryEPKcPK12macho_headeryjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFromMemory(char const*, macho_header const*, uint64_t, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic20instantiateFromCacheEPK12macho_headerPKcRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFromCache(macho_header const*, char const*, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic19instantiateFromFileEPKciPKhyyRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFromFile(char const*, int, unsigned char const*, uint64_t, uint64_t, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic25instantiateMainExecutableEPK12macho_headermPKcjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateMainExecutable(macho_header const*, unsigned long, char const*, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic22updateUsesCoalIteratorERN11ImageLoader12CoalIteratorEmPS0_RKNS0_11LinkContextE", "ImageLoaderMachOClassic::updateUsesCoalIterator(ImageLoader::CoalIterator&, unsigned long, ImageLoader*, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic25doBindExternalRelocationsERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindExternalRelocations(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic6doBindERKN11ImageLoader11LinkContextEb", "ImageLoaderMachOClassic::doBind(ImageLoader::LinkContext const&, bool)"),
	mu_demangle_test("_ZN23ImageLoaderMachOClassic11setDyldInfoEPK17dyld_info_command", "ImageLoaderMachOClassic::setDyldInfo(dyld_info_command const*)"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed21segmentCommandOffsetsEv", "ImageLoaderMachOCompressed::segmentCommandOffsets() const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed8libImageEj", "ImageLoaderMachOCompressed::libImage(unsigned int) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed13libReExportedEj", "ImageLoaderMachOCompressed::libReExported(unsigned int) const"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed11setLibImageEjP11ImageLoaderb", "ImageLoaderMachOCompressed::setLibImage(unsigned int, ImageLoader*, bool)"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed14containsSymbolEPKv", "ImageLoaderMachOCompressed::containsSymbol(void const*) const"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed22initializeCoalIteratorERN11ImageLoader12CoalIteratorEj", "ImageLoaderMachOCompressed::initializeCoalIterator(ImageLoader::CoalIterator&, unsigned int)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed22getAddressCoalIteratorERN11ImageLoader12CoalIteratorERKNS0_11LinkContextE", "ImageLoaderMachOCompressed::getAddressCoalIterator(ImageLoader::CoalIterator&, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed17findClosestSymbolEPKvPS1_", "ImageLoaderMachOCompressed::findClosestSymbol(void const*, void const**) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed18importedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::importedSymbolName(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed21importedSymbolIndexedEj", "ImageLoaderMachOCompressed::importedSymbolIndexed(unsigned int) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed19importedSymbolCountEv", "ImageLoaderMachOCompressed::importedSymbolCount() const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed21exportedSymbolIndexedEj", "ImageLoaderMachOCompressed::exportedSymbolIndexed(unsigned int) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed19exportedSymbolCountEv", "ImageLoaderMachOCompressed::exportedSymbolCount() const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed18exportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::exportedSymbolName(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed15resolveTwolevelERKN11ImageLoader11LinkContextEPKS0_bPKcPS5_", "ImageLoaderMachOCompressed::resolveTwolevel(ImageLoader::LinkContext const&, ImageLoader const*, bool, char const*, ImageLoader const**)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed11resolveFlatERKN11ImageLoader11LinkContextEPKcbPPKS0_", "ImageLoaderMachOCompressed::resolveFlat(ImageLoader::LinkContext const&, char const*, bool, ImageLoader const**)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed7resolveERKN11ImageLoader11LinkContextEPKchiPPKS0_PNS_10LastLookupE", "ImageLoaderMachOCompressed::resolve(ImageLoader::LinkContext const&, char const*, unsigned char, int, ImageLoader const**, ImageLoaderMachOCompressed::LastLookup*)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed6bindAtERKN11ImageLoader11LinkContextEmhPKchliS5_PNS_10LastLookupE", "ImageLoaderMachOCompressed::bindAt(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed11interposeAtERKN11ImageLoader11LinkContextEmhPKchliS5_PNS_10LastLookupE", "ImageLoaderMachOCompressed::interposeAt(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed16instantiateStartEPK12macho_headerPKcjj", "ImageLoaderMachOCompressed::instantiateStart(macho_header const*, char const*, unsigned int, unsigned int)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed16doBindLazySymbolEPmRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doBindLazySymbol(unsigned long*, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed20instantiateFromCacheEPK12macho_headerPKcRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateFromCache(macho_header const*, char const*, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed21instantiateFromMemoryEPKcPK12macho_headeryjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateFromMemory(char const*, macho_header const*, uint64_t, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed25instantiateMainExecutableEPK12macho_headermPKcjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateMainExecutable(macho_header const*, unsigned long, char const*, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressedD0Ev", "ImageLoaderMachOCompressed::~ImageLoaderMachOCompressed()"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressedD1Ev", "ImageLoaderMachOCompressed::~ImageLoaderMachOCompressed()"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed19instantiateFromFileEPKciPKhyyRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateFromFile(char const*, int, unsigned char const*, uint64_t, uint64_t, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed29exportedSymbolIsWeakDefintionEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::exportedSymbolIsWeakDefintion(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed21exportedSymbolAddressEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::exportedSymbolAddress(ImageLoader::Symbol const*) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed18findExportedSymbolEPKcPPK11ImageLoader", "ImageLoaderMachOCompressed::findExportedSymbol(char const*, ImageLoader const**) const"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed6rebaseERKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::rebase(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed22updateUsesCoalIteratorERN11ImageLoader12CoalIteratorEmPS0_RKNS0_11LinkContextE", "ImageLoaderMachOCompressed::updateUsesCoalIterator(ImageLoader::CoalIterator&, unsigned long, ImageLoader*, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed21incrementCoalIteratorERN11ImageLoader12CoalIteratorE", "ImageLoaderMachOCompressed::incrementCoalIterator(ImageLoader::CoalIterator&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed20doBindFastLazySymbolEjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doBindFastLazySymbol(unsigned int, ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed12eachLazyBindERKN11ImageLoader11LinkContextEMS_FmS3_mhPKchliS5_PNS_10LastLookupEE", "ImageLoaderMachOCompressed::eachLazyBind(ImageLoader::LinkContext const&, unsigned long (ImageLoaderMachOCompressed::*)(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*))"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed16doBindJustLaziesERKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doBindJustLazies(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed8eachBindERKN11ImageLoader11LinkContextEMS_FmS3_mhPKchliS5_PNS_10LastLookupEE", "ImageLoaderMachOCompressed::eachBind(ImageLoader::LinkContext const&, unsigned long (ImageLoaderMachOCompressed::*)(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*))"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed11doInterposeERKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doInterpose(ImageLoader::LinkContext const&)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed6doBindERKN11ImageLoader11LinkContextEb", "ImageLoaderMachOCompressed::doBind(ImageLoader::LinkContext const&, bool)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed11setDyldInfoEPK17dyld_info_command", "ImageLoaderMachOCompressed::setDyldInfo(dyld_info_command const*)"),
	mu_demangle_test("_ZN26ImageLoaderMachOCompressed18setSymbolTableInfoEPK11macho_nlistPKcPK16dysymtab_command", "ImageLoaderMachOCompressed::setSymbolTableInfo(macho_nlist const*, char const*, dysymtab_command const*)"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed16isSubframeworkOfERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOCompressed::isSubframeworkOf(ImageLoader::LinkContext const&, ImageLoader const*) const"),
	mu_demangle_test("_ZNK26ImageLoaderMachOCompressed13hasSubLibraryERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOCompressed::hasSubLibrary(ImageLoader::LinkContext const&, ImageLoader const*) const"),
	mu_demangle_test("_ZSt17__throw_bad_allocv", "std::__throw_bad_alloc()"),
	mu_demangle_test("_ZSt20__throw_length_errorPKc", "std::__throw_length_error(char const*)"),
	mu_demangle_test("_ZSt19__throw_logic_errorPKc", "std::__throw_logic_error(char const*)"),
	mu_demangle_test("_ZNSt12length_errorD0Ev", "std::length_error::~length_error()"),
	mu_demangle_test("_ZNSt12length_errorD2Ev", "std::length_error::~length_error()"),
	mu_demangle_test("_ZNSt12length_errorD1Ev", "std::length_error::~length_error()"),
	mu_demangle_test("_ZNKSt11logic_error4whatEv", "std::logic_error::what() const"),
	mu_demangle_test("_ZNSt11logic_errorC2ERKSs", "std::logic_error::logic_error(std::string const&)"),
	mu_demangle_test("_ZNSt11logic_errorC1ERKSs", "std::logic_error::logic_error(std::string const&)"),
	mu_demangle_test("_ZNSt12length_errorC1ERKSs", "std::length_error::length_error(std::string const&)"),
	mu_demangle_test("_ZNSt11logic_errorD0Ev", "std::logic_error::~logic_error()"),
	mu_demangle_test("_ZNSt11logic_errorD2Ev", "std::logic_error::~logic_error()"),
	mu_demangle_test("_ZNSt11logic_errorD1Ev", "std::logic_error::~logic_error()"),
	mu_demangle_test("_ZSt18_Rb_tree_decrementPSt18_Rb_tree_node_base", "std::_Rb_tree_decrement(std::_Rb_tree_node_base*)"),
	mu_demangle_test("_ZSt29_Rb_tree_insert_and_rebalancebPSt18_Rb_tree_node_baseS0_RS_", "std::_Rb_tree_insert_and_rebalance(bool, std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::_Rb_tree_node_base&)"),
	mu_demangle_test("_ZSt18_Rb_tree_incrementPKSt18_Rb_tree_node_base", "std::_Rb_tree_increment(std::_Rb_tree_node_base const*)"),
	mu_demangle_test("_ZNSs4_Rep10_M_disposeERKSaIcE", "std::string::_Rep::_M_dispose(std::allocator<char> const&)"),
	mu_demangle_test("_ZNSs4_Rep9_S_createEmmRKSaIcE", "std::string::_Rep::_S_create(unsigned long, unsigned long, std::allocator<char> const&)"),
	mu_demangle_test("_ZNSs4_Rep8_M_cloneERKSaIcEm", "std::string::_Rep::_M_clone(std::allocator<char> const&, unsigned long)"),
	mu_demangle_test("_ZNSs4_Rep7_M_grabERKSaIcES2_", "std::string::_Rep::_M_grab(std::allocator<char> const&, std::allocator<char> const&)"),
	mu_demangle_test("_ZNSs12_S_constructIPKcEEPcT_S3_RKSaIcESt20forward_iterator_tag", "char* std::string::_S_construct<char const*>(char const*, char const*, std::allocator<char> const&, std::forward_iterator_tag)"),
	mu_demangle_test("_ZdlPv", "operator delete(void*)"),
	mu_demangle_test("_ZdaPv", "operator delete[](void*)"),
	mu_demangle_test("_ZNKSt9exception4whatEv", "std::exception::what() const"),
	mu_demangle_test("_ZNKSt13bad_exception4whatEv", "std::bad_exception::what() const"),
	mu_demangle_test("_ZNSt13bad_exceptionD0Ev", "std::bad_exception::~bad_exception()"),
	mu_demangle_test("_ZNSt9exceptionD0Ev", "std::exception::~exception()"),
	mu_demangle_test("_ZNSt9exceptionD2Ev", "std::exception::~exception()"),
	mu_demangle_test("_ZNSt13bad_exceptionD1Ev", "std::bad_exception::~bad_exception()"),
	mu_demangle_test("_ZNSt9exceptionD1Ev", "std::exception::~exception()"),
	mu_demangle_test("_ZNKSt9bad_alloc4whatEv", "std::bad_alloc::what() const"),
	mu_demangle_test("_ZNSt9bad_allocD0Ev", "std::bad_alloc::~bad_alloc()"),
	mu_demangle_test("_ZNSt9bad_allocD2Ev", "std::bad_alloc::~bad_alloc()"),
	mu_demangle_test("_ZNSt9bad_allocD1Ev", "std::bad_alloc::~bad_alloc()"),
	mu_demangle_test("_Znwm", "operator new(unsigned long)"),
	mu_demangle_test("_Znam", "operator new[](unsigned long)"),
	mu_demangle_test("_ZNKSt9type_info14__is_pointer_pEv", "std::type_info::__is_pointer_p() const"),
	mu_demangle_test("_ZNKSt9type_info15__is_function_pEv", "std::type_info::__is_function_p() const"),
	mu_demangle_test("_ZNKSt9type_info11__do_upcastEPKN10__cxxabiv117__class_type_infoEPPv", "std::type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void**) const"),
	mu_demangle_test("_ZNK10__cxxabiv117__class_type_info10__do_catchEPKSt9type_infoPPvj", "__cxxabiv1::__class_type_info::__do_catch(std::type_info const*, void**, unsigned int) const"),
	mu_demangle_test("_ZNK10__cxxabiv117__class_type_info11__do_upcastEPKS0_PPv", "__cxxabiv1::__class_type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void**) const"),
	mu_demangle_test("_ZNK10__cxxabiv117__class_type_info20__do_find_public_srcElPKvPKS0_S2_", "__cxxabiv1::__class_type_info::__do_find_public_src(long, void const*, __cxxabiv1::__class_type_info const*, void const*) const"),
	mu_demangle_test("_ZNK10__cxxabiv117__class_type_info11__do_upcastEPKS0_PKvRNS0_15__upcast_resultE", "__cxxabiv1::__class_type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__upcast_result&) const"),
	mu_demangle_test("_ZN10__cxxabiv117__class_type_infoD0Ev", "__cxxabiv1::__class_type_info::~__class_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv117__class_type_infoD1Ev", "__cxxabiv1::__class_type_info::~__class_type_info()"),
	mu_demangle_test("_ZNSt9type_infoD0Ev", "std::type_info::~type_info()"),
	mu_demangle_test("_ZNSt9type_infoD1Ev", "std::type_info::~type_info()"),
	mu_demangle_test("_ZNSt9type_infoD2Ev", "std::type_info::~type_info()"),
	mu_demangle_test("_ZNKSt9type_info10__do_catchEPKS_PPvj", "std::type_info::__do_catch(std::type_info const*, void**, unsigned int) const"),
	mu_demangle_test("_ZNK10__cxxabiv117__class_type_info12__do_dyncastElNS0_10__sub_kindEPKS0_PKvS3_S5_RNS0_16__dyncast_resultE", "__cxxabiv1::__class_type_info::__do_dyncast(long, __cxxabiv1::__class_type_info::__sub_kind, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__dyncast_result&) const"),
	mu_demangle_test("_ZNK10__cxxabiv120__si_class_type_info20__do_find_public_srcElPKvPKNS_17__class_type_infoES2_", "__cxxabiv1::__si_class_type_info::__do_find_public_src(long, void const*, __cxxabiv1::__class_type_info const*, void const*) const"),
	mu_demangle_test("_ZNK10__cxxabiv120__si_class_type_info12__do_dyncastElNS_17__class_type_info10__sub_kindEPKS1_PKvS4_S6_RNS1_16__dyncast_resultE", "__cxxabiv1::__si_class_type_info::__do_dyncast(long, __cxxabiv1::__class_type_info::__sub_kind, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__dyncast_result&) const"),
	mu_demangle_test("_ZNK10__cxxabiv120__si_class_type_info11__do_upcastEPKNS_17__class_type_infoEPKvRNS1_15__upcast_resultE", "__cxxabiv1::__si_class_type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__upcast_result&) const"),
	mu_demangle_test("_ZN10__cxxabiv120__si_class_type_infoD0Ev", "__cxxabiv1::__si_class_type_info::~__si_class_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv120__si_class_type_infoD2Ev", "__cxxabiv1::__si_class_type_info::~__si_class_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv120__si_class_type_infoD1Ev", "__cxxabiv1::__si_class_type_info::~__si_class_type_info()"),
	mu_demangle_test("_ZNK10__cxxabiv119__pointer_type_info14__is_pointer_pEv", "__cxxabiv1::__pointer_type_info::__is_pointer_p() const"),
	mu_demangle_test("_ZN10__cxxabiv117__pbase_type_infoD0Ev", "__cxxabiv1::__pbase_type_info::~__pbase_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv117__pbase_type_infoD2Ev", "__cxxabiv1::__pbase_type_info::~__pbase_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv119__pointer_type_infoD0Ev", "__cxxabiv1::__pointer_type_info::~__pointer_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv119__pointer_type_infoD2Ev", "__cxxabiv1::__pointer_type_info::~__pointer_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv119__pointer_type_infoD1Ev", "__cxxabiv1::__pointer_type_info::~__pointer_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv117__pbase_type_infoD1Ev", "__cxxabiv1::__pbase_type_info::~__pbase_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv123__fundamental_type_infoD0Ev", "__cxxabiv1::__fundamental_type_info::~__fundamental_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv123__fundamental_type_infoD2Ev", "__cxxabiv1::__fundamental_type_info::~__fundamental_type_info()"),
	mu_demangle_test("_ZN10__cxxabiv123__fundamental_type_infoD1Ev", "__cxxabiv1::__fundamental_type_info::~__fundamental_type_info()"),
	mu_demangle_test("_ZNK10__cxxabiv117__pbase_type_info10__do_catchEPKSt9type_infoPPvj", "__cxxabiv1::__pbase_type_info::__do_catch(std::type_info const*, void**, unsigned int) const"),
	mu_demangle_test("_ZNK10__cxxabiv119__pointer_type_info15__pointer_catchEPKNS_17__pbase_type_infoEPPvj", "__cxxabiv1::__pointer_type_info::__pointer_catch(__cxxabiv1::__pbase_type_info const*, void**, unsigned int) const"),
	mu_demangle_test("_ZNK10__cxxabiv117__pbase_type_info15__pointer_catchEPKS0_PPvj", "__cxxabiv1::__pbase_type_info::__pointer_catch(__cxxabiv1::__pbase_type_info const*, void**, unsigned int) const"),
	mu_demangle_test("_ZN16CSCppTimeoutLockD1Ev", "CSCppTimeoutLock::~CSCppTimeoutLock()"),
	mu_demangle_test("_ZN16CSCppTimeoutLockC2EPjj", "CSCppTimeoutLock::CSCppTimeoutLock(unsigned int*, unsigned int)"),
	mu_demangle_test("_ZN16CSCppTimeoutLockC1EPjj", "CSCppTimeoutLock::CSCppTimeoutLock(unsigned int*, unsigned int)"),
	mu_demangle_test("_ZN25CSCppDyldSharedMemoryPage11send_noticeEjRjS0_", "CSCppDyldSharedMemoryPage::send_notice(unsigned int, unsigned int&, unsigned int&)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE8validRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::validReg(int)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE13validFloatRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::validFloatReg(int)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE7getInfoEP15unw_proc_info_t", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getInfo(unw_proc_info_t*)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE15getRegisterNameEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getRegisterName(int)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE13isSignalFrameEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::isSignalFrame()"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EED0Ev", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::~UnwindCursor()"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE33getInfoFromCompactEncodingSectionEyyy", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getInfoFromCompactEncodingSection(uint64_t, uint64_t, uint64_t)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE24setInfoBasedOnIPRegisterEb", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::setInfoBasedOnIPRegister(bool)"),
	mu_demangle_test("_ZN9libunwind17LocalAddressSpace16findFunctionNameEyPcmPy", "libunwind::LocalAddressSpace::findFunctionName(uint64_t, char*, unsigned long, uint64_t*)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE15getFunctionNameEPcmPy", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getFunctionName(char*, unsigned long, uint64_t*)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE6jumptoEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::jumpto()"),
	mu_demangle_test("_ZN9libunwind22CompactUnwinder_x86_64INS_17LocalAddressSpaceEE32stepWithCompactEncodingFramelessEjyRS1_RNS_16Registers_x86_64Eb", "libunwind::CompactUnwinder_x86_64<libunwind::LocalAddressSpace>::stepWithCompactEncodingFrameless(unsigned int, uint64_t, libunwind::LocalAddressSpace&, libunwind::Registers_x86_64&, bool)"),
	mu_demangle_test("_ZN9libunwind22CompactUnwinder_x86_64INS_17LocalAddressSpaceEE31stepWithCompactEncodingRBPFrameEjyRS1_RNS_16Registers_x86_64E", "libunwind::CompactUnwinder_x86_64<libunwind::LocalAddressSpace>::stepWithCompactEncodingRBPFrame(unsigned int, uint64_t, libunwind::LocalAddressSpace&, libunwind::Registers_x86_64&)"),
	mu_demangle_test("_ZN9libunwind22CompactUnwinder_x86_64INS_17LocalAddressSpaceEE23stepWithCompactEncodingEjyRS1_RNS_16Registers_x86_64E", "libunwind::CompactUnwinder_x86_64<libunwind::LocalAddressSpace>::stepWithCompactEncoding(unsigned int, uint64_t, libunwind::LocalAddressSpace&, libunwind::Registers_x86_64&)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE23stepWithCompactEncodingEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::stepWithCompactEncoding()"),
	mu_demangle_test("_ZN9libunwind16Registers_x86_6411setRegisterEiy", "libunwind::Registers_x86_64::setRegister(int, uint64_t)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE6setRegEiy", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::setReg(int, uint64_t)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE6getRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getReg(int)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EED1Ev", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::~UnwindCursor()"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE4stepEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::step()"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE11setFloatRegEid", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::setFloatReg(int, double)"),
	mu_demangle_test("_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE11getFloatRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getFloatReg(int)"),
	mu_demangle_test("_ZN9libunwind16Registers_x86_646jumptoEv", "libunwind::Registers_x86_64::jumpto()"),
	mu_demangle_test("_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"),
	mu_demangle_test("_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"),
	mu_demangle_test("_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"),
	mu_demangle_test("_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"),
	mu_demangle_test("_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"),
	mu_demangle_test("_ZZ34dyld_image_path_containing_addressE8__func__", "dyld_image_path_containing_address::__func__"),
	mu_demangle_test("_ZZ40dyld_register_image_state_change_handlerE8__func__", "dyld_register_image_state_change_handler::__func__"),
	mu_demangle_test("_ZZ5dlsymE8__func__", "dlsym::__func__"),
	mu_demangle_test("_ZZ7dlerrorE8__func__", "dlerror::__func__"),
	mu_demangle_test("_ZZ6dladdrE8__func__", "dladdr::__func__"),
	mu_demangle_test("_ZZ7dlcloseE8__func__", "dlclose::__func__"),
	mu_demangle_test("_ZZ6dlopenE8__func__", "dlopen::__func__"),
	mu_demangle_test("_ZZ16dlopen_preflightE8__func__", "dlopen_preflight::__func__"),
	mu_demangle_test("_ZZ23_dyld_launched_preboundE8__func__", "_dyld_launched_prebound::__func__"),
	mu_demangle_test("_ZZ14NSUnLinkModuleE8__func__", "NSUnLinkModule::__func__"),
	mu_demangle_test("_ZZ22NSLibraryNameForModuleE8__func__", "NSLibraryNameForModule::__func__"),
	mu_demangle_test("_ZZ14NSNameOfModuleE8__func__", "NSNameOfModule::__func__"),
	mu_demangle_test("_ZZ22NSLookupSymbolInModuleE8__func__", "NSLookupSymbolInModule::__func__"),
	mu_demangle_test("_ZZ12NSLinkModuleE8__func__", "NSLinkModule::__func__"),
	mu_demangle_test("_ZZ34NSIsSymbolDefinedInObjectFileImageE8__func__", "NSIsSymbolDefinedInObjectFileImage::__func__"),
	mu_demangle_test("_ZZ33NSGetSectionDataInObjectFileImageE8__func__", "NSGetSectionDataInObjectFileImage::__func__"),
	mu_demangle_test("_ZZ38NSSymbolReferenceNameInObjectFileImageE8__func__", "NSSymbolReferenceNameInObjectFileImage::__func__"),
	mu_demangle_test("_ZZ39NSSymbolReferenceCountInObjectFileImageE8__func__", "NSSymbolReferenceCountInObjectFileImage::__func__"),
	mu_demangle_test("_ZZ39NSSymbolDefinitionNameInObjectFileImageE8__func__", "NSSymbolDefinitionNameInObjectFileImage::__func__"),
	mu_demangle_test("_ZZ40NSSymbolDefinitionCountInObjectFileImageE8__func__", "NSSymbolDefinitionCountInObjectFileImage::__func__"),
	mu_demangle_test("_ZZ27NSHasModInitObjectFileImageE8__func__", "NSHasModInitObjectFileImage::__func__"),
	mu_demangle_test("_ZZ24NSDestroyObjectFileImageE8__func__", "NSDestroyObjectFileImage::__func__"),
	mu_demangle_test("_ZZ33NSCreateObjectFileImageFromMemoryE8__func__", "NSCreateObjectFileImageFromMemory::__func__"),
	mu_demangle_test("_ZZ31NSCreateObjectFileImageFromFileE8__func__", "NSCreateObjectFileImageFromFile::__func__"),
	mu_demangle_test("_ZZ30_dyld_image_containing_addressE8__func__", "_dyld_image_containing_address::__func__"),
	mu_demangle_test("_ZZ41_dyld_bind_fully_image_containing_addressE8__func__", "_dyld_bind_fully_image_containing_address::__func__"),
	mu_demangle_test("_ZZ22_dyld_bind_objc_moduleE8__func__", "_dyld_bind_objc_module::__func__"),
	mu_demangle_test("_ZZ35_dyld_all_twolevel_modules_preboundE8__func__", "_dyld_all_twolevel_modules_prebound::__func__"),
	mu_demangle_test("_ZZ17NSModuleForSymbolE8__func__", "NSModuleForSymbol::__func__"),
	mu_demangle_test("_ZZ17NSAddressOfSymbolE8__func__", "NSAddressOfSymbol::__func__"),
	mu_demangle_test("_ZZ14NSNameOfSymbolE8__func__", "NSNameOfSymbol::__func__"),
	mu_demangle_test("_ZZ29NSIsSymbolNameDefinedWithHintE8__func__", "NSIsSymbolNameDefinedWithHint::__func__"),
	mu_demangle_test("_ZZ21NSLookupSymbolInImageE8__func__", "NSLookupSymbolInImage::__func__"),
	mu_demangle_test("_ZZ28NSIsSymbolNameDefinedInImageE8__func__", "NSIsSymbolNameDefinedInImage::__func__"),
	mu_demangle_test("_ZZ25NSAddLibraryWithSearchingE8__func__", "NSAddLibraryWithSearching::__func__"),
	mu_demangle_test("_ZZ12NSAddLibraryE8__func__", "NSAddLibrary::__func__"),
	mu_demangle_test("_ZZ10NSAddImageE8__func__", "NSAddImage::__func__"),
	mu_demangle_test("_ZZ29NSLookupAndBindSymbolWithHintE8__func__", "NSLookupAndBindSymbolWithHint::__func__"),
	mu_demangle_test("_ZZ21NSLookupAndBindSymbolE8__func__", "NSLookupAndBindSymbol::__func__"),
	mu_demangle_test("_ZZ31_dyld_lookup_and_bind_with_hintE8__func__", "_dyld_lookup_and_bind_with_hint::__func__"),
	mu_demangle_test("_ZZ27_dyld_lookup_and_bind_fullyE8__func__", "_dyld_lookup_and_bind_fully::__func__"),
	mu_demangle_test("_ZZ36_dyld_register_func_for_remove_imageE8__func__", "_dyld_register_func_for_remove_image::__func__"),
	mu_demangle_test("_ZZ33_dyld_register_func_for_add_imageE8__func__", "_dyld_register_func_for_add_image::__func__"),
	mu_demangle_test("_ZZ41_dyld_get_image_header_containing_addressE8__func__", "_dyld_get_image_header_containing_address::__func__"),
	mu_demangle_test("_ZZ20_dyld_get_image_nameE8__func__", "_dyld_get_image_name::__func__"),
	mu_demangle_test("_ZZ21_dyld_get_image_slideE8__func__", "_dyld_get_image_slide::__func__"),
	mu_demangle_test("_ZZ28_dyld_get_image_vmaddr_slideE8__func__", "_dyld_get_image_vmaddr_slide::__func__"),
	mu_demangle_test("_ZZ22_dyld_get_image_headerE8__func__", "_dyld_get_image_header::__func__"),
	mu_demangle_test("_ZZ17_dyld_image_countE8__func__", "_dyld_image_count::__func__"),
	mu_demangle_test("_ZZ20_NSGetExecutablePathE8__func__", "_NSGetExecutablePath::__func__"),
	mu_demangle_test("_ZTSSt11logic_error", "typeinfo name for std::logic_error"),
	mu_demangle_test("_ZTSSt13bad_exception", "typeinfo name for std::bad_exception"),
	mu_demangle_test("_ZTSSt9exception", "typeinfo name for std::exception"),
	mu_demangle_test("_ZTSSt9bad_alloc", "typeinfo name for std::bad_alloc"),
	mu_demangle_test("_ZTSN10__cxxabiv120__si_class_type_infoE", "typeinfo name for __cxxabiv1::__si_class_type_info"),
	mu_demangle_test("_ZTSN10__cxxabiv117__class_type_infoE", "typeinfo name for __cxxabiv1::__class_type_info"),
	mu_demangle_test("_ZTSSt9type_info", "typeinfo name for std::type_info"),
	mu_demangle_test("_ZTSPKc", "typeinfo name for char const*"),
	mu_demangle_test("_ZTSPc", "typeinfo name for char*"),
	mu_demangle_test("_ZTSc", "typeinfo name for char"),
	mu_demangle_test("_ZTSv", "typeinfo name for void"),
	mu_demangle_test("_ZTSN10__cxxabiv119__pointer_type_infoE", "typeinfo name for __cxxabiv1::__pointer_type_info"),
	mu_demangle_test("_ZTSN10__cxxabiv117__pbase_type_infoE", "typeinfo name for __cxxabiv1::__pbase_type_info"),
	mu_demangle_test("_ZTSN10__cxxabiv123__fundamental_type_infoE", "typeinfo name for __cxxabiv1::__fundamental_type_info"),
	mu_demangle_test("_ZTSSt12length_error", "typeinfo name for std::length_error"),
	mu_demangle_test("_ZTV11ImageLoader", "vtable for ImageLoader"),
	mu_demangle_test("_ZTV16ImageLoaderMachO", "vtable for ImageLoaderMachO"),
	mu_demangle_test("_ZTV23ImageLoaderMachOClassic", "vtable for ImageLoaderMachOClassic"),
	mu_demangle_test("_ZTV26ImageLoaderMachOCompressed", "vtable for ImageLoaderMachOCompressed"),
	mu_demangle_test("_ZTISt12length_error", "typeinfo for std::length_error"),
	mu_demangle_test("_ZTVSt12length_error", "vtable for std::length_error"),
	mu_demangle_test("_ZTVSt11logic_error", "vtable for std::logic_error"),
	mu_demangle_test("_ZTISt11logic_error", "typeinfo for std::logic_error"),
	mu_demangle_test("_ZTVSt13bad_exception", "vtable for std::bad_exception"),
	mu_demangle_test("_ZTVSt9exception", "vtable for std::exception"),
	mu_demangle_test("_ZTISt13bad_exception", "typeinfo for std::bad_exception"),
	mu_demangle_test("_ZTISt9exception", "typeinfo for std::exception"),
	mu_demangle_test("_ZTVSt9bad_alloc", "vtable for std::bad_alloc"),
	mu_demangle_test("_ZTISt9bad_alloc", "typeinfo for std::bad_alloc"),
	mu_demangle_test("_ZTVN10__cxxabiv120__si_class_type_infoE", "vtable for __cxxabiv1::__si_class_type_info"),
	mu_demangle_test("_ZTVN10__cxxabiv117__class_type_infoE", "vtable for __cxxabiv1::__class_type_info"),
	mu_demangle_test("_ZTVSt9type_info", "vtable for std::type_info"),
	mu_demangle_test("_ZTIN10__cxxabiv120__si_class_type_infoE", "typeinfo for __cxxabiv1::__si_class_type_info"),
	mu_demangle_test("_ZTIN10__cxxabiv117__class_type_infoE", "typeinfo for __cxxabiv1::__class_type_info"),
	mu_demangle_test("_ZTISt9type_info", "typeinfo for std::type_info"),
	mu_demangle_test("_ZTVN10__cxxabiv119__pointer_type_infoE", "vtable for __cxxabiv1::__pointer_type_info"),
	mu_demangle_test("_ZTVN10__cxxabiv117__pbase_type_infoE", "vtable for __cxxabiv1::__pbase_type_info"),
	mu_demangle_test("_ZTVN10__cxxabiv123__fundamental_type_infoE", "vtable for __cxxabiv1::__fundamental_type_info"),
	mu_demangle_test("_ZTIPKc", "typeinfo for char const*"),
	mu_demangle_test("_ZTIPc", "typeinfo for char*"),
	mu_demangle_test("_ZTIc", "typeinfo for char"),
	mu_demangle_test("_ZTIv", "typeinfo for void"),
	mu_demangle_test("_ZTIN10__cxxabiv119__pointer_type_infoE", "typeinfo for __cxxabiv1::__pointer_type_info"),
	mu_demangle_test("_ZTIN10__cxxabiv117__pbase_type_infoE", "typeinfo for __cxxabiv1::__pbase_type_info"),
	mu_demangle_test("_ZTIN10__cxxabiv123__fundamental_type_infoE", "typeinfo for __cxxabiv1::__fundamental_type_info"),
	mu_demangle_test("_ZTVN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EEE", "vtable for libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>"),
	mu_demangle_test("_ZN4dyld8gLogAPIsE", "dyld::gLogAPIs"),
	mu_demangle_test("_ZN4dyld17gLibSystemHelpersE", "dyld::gLibSystemHelpers"),
	mu_demangle_test("_ZN10__cxxabiv119__terminate_handlerE", "__cxxabiv1::__terminate_handler"),
	mu_demangle_test("_ZN10__cxxabiv120__unexpected_handlerE", "__cxxabiv1::__unexpected_handler"),
	mu_demangle_test("_ZN11ImageLoader27fgImagesUsedFromSharedCacheE", "ImageLoader::fgImagesUsedFromSharedCache"),
	mu_demangle_test("_ZN11ImageLoader26fgImagesWithUsedPrebindingE", "ImageLoader::fgImagesWithUsedPrebinding"),
	mu_demangle_test("_ZN11ImageLoader25fgImagesRequiringNoFixupsE", "ImageLoader::fgImagesRequiringNoFixups"),
	mu_demangle_test("_ZN11ImageLoader27fgImagesRequiringCoalescingE", "ImageLoader::fgImagesRequiringCoalescing"),
	mu_demangle_test("_ZN11ImageLoader26fgImagesHasWeakDefinitionsE", "ImageLoader::fgImagesHasWeakDefinitions"),
	mu_demangle_test("_ZN11ImageLoader19fgTotalRebaseFixupsE", "ImageLoader::fgTotalRebaseFixups"),
	mu_demangle_test("_ZN11ImageLoader17fgTotalBindFixupsE", "ImageLoader::fgTotalBindFixups"),
	mu_demangle_test("_ZN11ImageLoader26fgTotalBindSymbolsResolvedE", "ImageLoader::fgTotalBindSymbolsResolved"),
	mu_demangle_test("_ZN11ImageLoader24fgTotalBindImageSearchesE", "ImageLoader::fgTotalBindImageSearches"),
	mu_demangle_test("_ZN11ImageLoader21fgTotalLazyBindFixupsE", "ImageLoader::fgTotalLazyBindFixups"),
	mu_demangle_test("_ZN11ImageLoader29fgTotalPossibleLazyBindFixupsE", "ImageLoader::fgTotalPossibleLazyBindFixups"),
	mu_demangle_test("_ZN11ImageLoader21fgTotalSegmentsMappedE", "ImageLoader::fgTotalSegmentsMapped"),
	mu_demangle_test("_ZN11ImageLoader18fgTotalBytesMappedE", "ImageLoader::fgTotalBytesMapped"),
	mu_demangle_test("_ZN11ImageLoader22fgTotalBytesPreFetchedE", "ImageLoader::fgTotalBytesPreFetched"),
	mu_demangle_test("_ZN11ImageLoader21fgNextPIEDylibAddressE", "ImageLoader::fgNextPIEDylibAddress"),
	mu_demangle_test("_ZN16ImageLoaderMachO26fgSymbolTableBinarySearchsE", "ImageLoaderMachO::fgSymbolTableBinarySearchs"),
	mu_demangle_test("_ZN16ImageLoaderMachO19fgSymbolTrieSearchsE", "ImageLoaderMachO::fgSymbolTrieSearchs"),
	mu_demangle_test("_ZN4dyld12gLinkContextE", "dyld::gLinkContext"),
	mu_demangle_test("_ZN11ImageLoader24fgTotalLoadLibrariesTimeE", "ImageLoader::fgTotalLoadLibrariesTime"),
	mu_demangle_test("_ZN11ImageLoader17fgTotalRebaseTimeE", "ImageLoader::fgTotalRebaseTime"),
	mu_demangle_test("_ZN11ImageLoader15fgTotalBindTimeE", "ImageLoader::fgTotalBindTime"),
	mu_demangle_test("_ZN11ImageLoader19fgTotalWeakBindTimeE", "ImageLoader::fgTotalWeakBindTime"),
	mu_demangle_test("_ZN11ImageLoader10fgTotalDOFE", "ImageLoader::fgTotalDOF"),
	mu_demangle_test("_ZN11ImageLoader15fgTotalInitTimeE", "ImageLoader::fgTotalInitTime"),
	mu_demangle_test("_ZN11ImageLoader23fgDynamicImageReExportsE", "ImageLoader::fgDynamicImageReExports"),
	mu_demangle_test("_ZN11ImageLoader19fgInterposingTuplesE", "ImageLoader::fgInterposingTuples"),
	mu_demangle_test("_ZNSs4_Rep20_S_empty_rep_storageE", "std::string::_Rep::_S_empty_rep_storage"),
	mu_demangle_test("_ZZN23ImageLoaderMachOClassic26bindIndirectSymbolPointersERKN11ImageLoader11LinkContextEbbE13alreadyWarned", "ImageLoaderMachOClassic::bindIndirectSymbolPointers(ImageLoader::LinkContext const&, bool, bool)::alreadyWarned"),
	mu_demangle_test("_ZN12_GLOBAL__N_115emergency_mutexE", "(anonymous namespace)::emergency_mutex"),
	mu_demangle_test("_Z1fIDnLDn0EEvv", "void f<decltype(nullptr), (decltype(nullptr))0>()"),
	// clang
	mu_demangle_test("_ZN4llvm8DenseMapIjcNS_12DenseMapInfoIjEENS1_IcEEE6insertERKSt4pairIjcE", "llvm::DenseMap<unsigned int, char, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<char> >::insert(std::pair<unsigned int, char> const&)"),
	mu_demangle_test("_ZN4llvm8DenseMapIjcNS_12DenseMapInfoIjEENS1_IcEEE16InsertIntoBucketERKjRKcPSt4pairIjcE", "llvm::DenseMap<unsigned int, char, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<char> >::InsertIntoBucket(unsigned int const&, char const&, std::pair<unsigned int, char>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIjcNS_12DenseMapInfoIjEENS1_IcEEE4growEj", "llvm::DenseMap<unsigned int, char, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<char> >::grow(unsigned int)"),
	mu_demangle_test("_ZN4llvm19MachinePassRegistry3AddEPNS_23MachinePassRegistryNodeE", "llvm::MachinePassRegistry::Add(llvm::MachinePassRegistryNode*)"),
	mu_demangle_test("_ZN4llvm2cl6valuesIiEENS0_11ValuesClassIT_EEPKcS3_S6_z", "llvm::cl::ValuesClass<int> llvm::cl::values<int>(char const*, int, char const*, ...)"),
	mu_demangle_test("_ZN4llvm2cl11ValuesClassIiEC2EPKciS4_P13__va_list_tag", "llvm::cl::ValuesClass<int>::ValuesClass(char const*, int, char const*, __va_list_tag*)"),
	mu_demangle_test("_ZN4llvm24PassRegistrationListenerC2Ev", "llvm::PassRegistrationListener::PassRegistrationListener()"),
	mu_demangle_test("_ZN4llvm24PassRegistrationListener15enumeratePassesEv", "llvm::PassRegistrationListener::enumeratePasses()"),
	mu_demangle_test("_ZN4llvm12PassRegistry15getPassRegistryEv", "llvm::PassRegistry::getPassRegistry()"),
	mu_demangle_test("_ZNK4llvm12PassRegistry7getImplEv", "llvm::PassRegistry::getImpl() const"),
	mu_demangle_test("_ZN4llvm12PassRegistry13enumerateWithEPNS_24PassRegistrationListenerE", "llvm::PassRegistry::enumerateWith(llvm::PassRegistrationListener*)"),
	mu_demangle_test("_ZN4llvm12PassRegistry23addRegistrationListenerEPNS_24PassRegistrationListenerE", "llvm::PassRegistry::addRegistrationListener(llvm::PassRegistrationListener*)"),
	mu_demangle_test("_ZN4llvm3sys11MemoryFenceEv", "llvm::sys::MemoryFence()"),
	mu_demangle_test("_ZN4llvm2cl6Option11addArgumentEv", "llvm::cl::Option::addArgument()"),
	mu_demangle_test("_ZN4llvm2cl18MarkOptionsChangedEv", "llvm::cl::MarkOptionsChanged()"),
	mu_demangle_test("_ZNK4llvm17ManagedStaticBase21RegisterManagedStaticEPFPvvEPFvS1_E", "llvm::ManagedStaticBase::RegisterManagedStatic(void* (*)(), void (*)(void*)) const"),
	mu_demangle_test("_ZN4llvm3sys9MutexImplC2Eb", "llvm::sys::MutexImpl::MutexImpl(bool)"),
	mu_demangle_test("_ZN4llvm3sys9MutexImpl7acquireEv", "llvm::sys::MutexImpl::acquire()"),
	mu_demangle_test("_ZN4llvm3sys9MutexImpl7releaseEv", "llvm::sys::MutexImpl::release()"),
	mu_demangle_test("_ZN4llvm15SmallVectorBase8grow_podEmm", "llvm::SmallVectorBase::grow_pod(unsigned long, unsigned long)"),
	mu_demangle_test("_ZN4llvm3sys15ThreadLocalImplC2Ev", "llvm::sys::ThreadLocalImpl::ThreadLocalImpl()"),
	mu_demangle_test("_ZN4llvm21llvm_is_multithreadedEv", "llvm::llvm_is_multithreaded()"),
	mu_demangle_test("_ZN4llvm24llvm_acquire_global_lockEv", "llvm::llvm_acquire_global_lock()"),
	mu_demangle_test("_ZN4llvm24llvm_release_global_lockEv", "llvm::llvm_release_global_lock()"),
	mu_demangle_test("_ZN4llvm15system_categoryEv", "llvm::system_category()"),
	mu_demangle_test("_Z8cc1_mainPPKcS1_S0_Pv", "cc1_main(char const**, char const**, char const*, void*)"),
	mu_demangle_test("_Z16LLVMErrorHandlerPvRKSs", "LLVMErrorHandler(void*, std::string const&)"),
	mu_demangle_test("_ZNK5clang17DiagnosticBuilder9AddStringEN4llvm9StringRefE", "clang::DiagnosticBuilder::AddString(llvm::StringRef) const"),
	mu_demangle_test("_ZNK4llvm18IntrusiveRefCntPtrIN5clang10DiagnosticEE6getPtrEv", "llvm::IntrusiveRefCntPtr<clang::Diagnostic>::getPtr() const"),
	mu_demangle_test("_ZN5clang16DiagnosticClient15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::DiagnosticClient::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"),
	mu_demangle_test("_ZN5clang16DiagnosticClient13EndSourceFileEv", "clang::DiagnosticClient::EndSourceFile()"),
	mu_demangle_test("_ZN5clang18CompilerInvocationD2Ev", "clang::CompilerInvocation::~CompilerInvocation()"),
	mu_demangle_test("_ZN5clang14CodeGenOptionsD2Ev", "clang::CodeGenOptions::~CodeGenOptions()"),
	mu_demangle_test("_ZN5clang23DependencyOutputOptionsD2Ev", "clang::DependencyOutputOptions::~DependencyOutputOptions()"),
	mu_demangle_test("_ZN5clang15FrontendOptionsD2Ev", "clang::FrontendOptions::~FrontendOptions()"),
	mu_demangle_test("_ZN5clang19HeaderSearchOptionsD2Ev", "clang::HeaderSearchOptions::~HeaderSearchOptions()"),
	mu_demangle_test("_ZN5clang19PreprocessorOptionsD2Ev", "clang::PreprocessorOptions::~PreprocessorOptions()"),
	mu_demangle_test("_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE8_M_eraseEPSt13_Rb_tree_nodeISsE", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_erase(std::_Rb_tree_node<std::string>*)"),
	mu_demangle_test("_ZN5clang13TargetOptionsD2Ev", "clang::TargetOptions::~TargetOptions()"),
	mu_demangle_test("_ZN5clang18CompilerInvocationC2Ev", "clang::CompilerInvocation::CompilerInvocation()"),
	mu_demangle_test("_Z10cc1as_mainPPKcS1_S0_Pv", "cc1as_main(char const**, char const**, char const*, void*)"),
	mu_demangle_test("_Z16LLVMErrorHandlerPvRKSs", "LLVMErrorHandler(void*, std::string const&)"),
	mu_demangle_test("_ZN4llvm23PrettyStackTraceProgramD1Ev", "llvm::PrettyStackTraceProgram::~PrettyStackTraceProgram()"),
	mu_demangle_test("_ZN4llvm23PrettyStackTraceProgramD0Ev", "llvm::PrettyStackTraceProgram::~PrettyStackTraceProgram()"),
	mu_demangle_test("_ZN4llvm21formatted_raw_ostream9setStreamERNS_11raw_ostreamEb", "llvm::formatted_raw_ostream::setStream(llvm::raw_ostream&, bool)"),
	mu_demangle_test("_ZN4llvm21formatted_raw_ostreamD1Ev", "llvm::formatted_raw_ostream::~formatted_raw_ostream()"),
	mu_demangle_test("_ZN4llvm21formatted_raw_ostreamD0Ev", "llvm::formatted_raw_ostream::~formatted_raw_ostream()"),
	mu_demangle_test("_ZN4llvm11raw_ostream11changeColorENS0_6ColorsEbb", "llvm::raw_ostream::changeColor(llvm::raw_ostream::Colors, bool, bool)"),
	mu_demangle_test("_ZN4llvm11raw_ostream10resetColorEv", "llvm::raw_ostream::resetColor()"),
	mu_demangle_test("_ZNK4llvm11raw_ostream12is_displayedEv", "llvm::raw_ostream::is_displayed() const"),
	mu_demangle_test("_ZNK4llvm21formatted_raw_ostream11current_posEv", "llvm::formatted_raw_ostream::current_pos() const"),
	mu_demangle_test("_ZN4llvm21formatted_raw_ostream13releaseStreamEv", "llvm::formatted_raw_ostream::releaseStream()"),
	mu_demangle_test("_ZN4llvm10error_code21unspecified_bool_trueEv", "llvm::error_code::unspecified_bool_true()"),
	mu_demangle_test("_Z17GetExecutablePathPKcb", "GetExecutablePath(char const*, bool)"),
	mu_demangle_test("_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE16_M_insert_uniqueERKSs", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_insert_unique(std::string const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE9_M_insertEPSt18_Rb_tree_node_baseS7_RKSs", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::string const&)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPKcE6insertEPS2_RKS2_", "llvm::SmallVectorImpl<char const*>::insert(char const**, char const* const&)"),
	mu_demangle_test("_ZN5clang25ExecuteCompilerInvocationEPNS_16CompilerInstanceE", "clang::ExecuteCompilerInvocation(clang::CompilerInstance*)"),
	mu_demangle_test("_ZN5clang14FrontendAction21BeginSourceFileActionERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::FrontendAction::BeginSourceFileAction(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang14FrontendAction19EndSourceFileActionEv", "clang::FrontendAction::EndSourceFileAction()"),
	mu_demangle_test("_ZNK5clang26PreprocessorFrontendAction20usesPreprocessorOnlyEv", "clang::PreprocessorFrontendAction::usesPreprocessorOnly() const"),
	mu_demangle_test("_ZN5clang14FrontendAction27usesCompleteTranslationUnitEv", "clang::FrontendAction::usesCompleteTranslationUnit()"),
	mu_demangle_test("_ZNK5clang14FrontendAction13hasPCHSupportEv", "clang::FrontendAction::hasPCHSupport() const"),
	mu_demangle_test("_ZNK5clang14FrontendAction17hasASTFileSupportEv", "clang::FrontendAction::hasASTFileSupport() const"),
	mu_demangle_test("_ZNK5clang14FrontendAction12hasIRSupportEv", "clang::FrontendAction::hasIRSupport() const"),
	mu_demangle_test("_ZNK5clang14FrontendAction24hasCodeCompletionSupportEv", "clang::FrontendAction::hasCodeCompletionSupport() const"),
	mu_demangle_test("_ZN5clang26PreprocessorFrontendActionD1Ev", "clang::PreprocessorFrontendAction::~PreprocessorFrontendAction()"),
	mu_demangle_test("_ZN5clang26PreprocessorFrontendActionD0Ev", "clang::PreprocessorFrontendAction::~PreprocessorFrontendAction()"),
	mu_demangle_test("_ZNK5clang17ASTFrontendAction20usesPreprocessorOnlyEv", "clang::ASTFrontendAction::usesPreprocessorOnly() const"),
	mu_demangle_test("_ZN5clang17ASTFrontendActionD1Ev", "clang::ASTFrontendAction::~ASTFrontendAction()"),
	mu_demangle_test("_ZN5clang17ASTFrontendActionD0Ev", "clang::ASTFrontendAction::~ASTFrontendAction()"),
	mu_demangle_test("_ZNK5clang23PrintPreprocessedAction13hasPCHSupportEv", "clang::PrintPreprocessedAction::hasPCHSupport() const"),
	mu_demangle_test("_ZN5clang19PrintPreambleAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::PrintPreambleAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZNK5clang19PrintPreambleAction20usesPreprocessorOnlyEv", "clang::PrintPreambleAction::usesPreprocessorOnly() const"),
	mu_demangle_test("_ZN5clang16SyntaxOnlyActionD1Ev", "clang::SyntaxOnlyAction::~SyntaxOnlyAction()"),
	mu_demangle_test("_ZN5clang16SyntaxOnlyActionD0Ev", "clang::SyntaxOnlyAction::~SyntaxOnlyAction()"),
	mu_demangle_test("_ZNK5clang16SyntaxOnlyAction24hasCodeCompletionSupportEv", "clang::SyntaxOnlyAction::hasCodeCompletionSupport() const"),
	mu_demangle_test("_ZNK5clang14InitOnlyAction20usesPreprocessorOnlyEv", "clang::InitOnlyAction::usesPreprocessorOnly() const"),
	mu_demangle_test("_ZN5clang17GeneratePCHAction27usesCompleteTranslationUnitEv", "clang::GeneratePCHAction::usesCompleteTranslationUnit()"),
	mu_demangle_test("_ZNK5clang17GeneratePCHAction17hasASTFileSupportEv", "clang::GeneratePCHAction::hasASTFileSupport() const"),
	mu_demangle_test("_ZN5clang16CreateASTPrinterEPN4llvm11raw_ostreamE", "clang::CreateASTPrinter(llvm::raw_ostream*)"),
	mu_demangle_test("_ZN5clang19CreateASTPrinterXMLEPN4llvm11raw_ostreamE", "clang::CreateASTPrinterXML(llvm::raw_ostream*)"),
	mu_demangle_test("_ZN5clang15CreateASTDumperEv", "clang::CreateASTDumper()"),
	mu_demangle_test("_ZN5clang15CreateASTViewerEv", "clang::CreateASTViewer()"),
	mu_demangle_test("_ZN5clang24CreateDeclContextPrinterEv", "clang::CreateDeclContextPrinter()"),
	mu_demangle_test("_ZN5clang23CreateInheritanceViewerERKSs", "clang::CreateInheritanceViewer(std::string const&)"),
	mu_demangle_test("_ZN5clang18CreateASTDumperXMLERN4llvm11raw_ostreamE", "clang::CreateASTDumperXML(llvm::raw_ostream&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ASTDumpXMLD1Ev", "(anonymous namespace)::ASTDumpXML::~ASTDumpXML()"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ASTDumpXMLD0Ev", "(anonymous namespace)::ASTDumpXML::~ASTDumpXML()"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ASTDumpXML21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::ASTDumpXML::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117InheritanceViewerD1Ev", "(anonymous namespace)::InheritanceViewer::~InheritanceViewer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117InheritanceViewerD0Ev", "(anonymous namespace)::InheritanceViewer::~InheritanceViewer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117InheritanceViewer21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::InheritanceViewer::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118DeclContextPrinterD1Ev", "(anonymous namespace)::DeclContextPrinter::~DeclContextPrinter()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118DeclContextPrinterD0Ev", "(anonymous namespace)::DeclContextPrinter::~DeclContextPrinter()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118DeclContextPrinter21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::DeclContextPrinter::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118DeclContextPrinter16PrintDeclContextEPKN5clang11DeclContextEj", "(anonymous namespace)::DeclContextPrinter::PrintDeclContext(clang::DeclContext const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ASTViewerD1Ev", "(anonymous namespace)::ASTViewer::~ASTViewer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ASTViewerD0Ev", "(anonymous namespace)::ASTViewer::~ASTViewer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ASTViewer10InitializeERN5clang10ASTContextE", "(anonymous namespace)::ASTViewer::Initialize(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ASTViewer18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::ASTViewer::HandleTopLevelDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTPrinterXMLD1Ev", "(anonymous namespace)::ASTPrinterXML::~ASTPrinterXML()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTPrinterXMLD0Ev", "(anonymous namespace)::ASTPrinterXML::~ASTPrinterXML()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTPrinterXML10InitializeERN5clang10ASTContextE", "(anonymous namespace)::ASTPrinterXML::Initialize(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTPrinterXML21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::ASTPrinterXML::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ASTPrinterD1Ev", "(anonymous namespace)::ASTPrinter::~ASTPrinter()"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ASTPrinterD0Ev", "(anonymous namespace)::ASTPrinter::~ASTPrinter()"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ASTPrinter21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::ASTPrinter::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_jESt10_Select1stIS4_ENS0_16QualTypeOrderingESaIS4_EE8_M_eraseEPSt13_Rb_tree_nodeIS4_E", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, unsigned int>, std::_Select1st<std::pair<clang::QualType const, unsigned int> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::QualType const, unsigned int> >*)"),
	mu_demangle_test("_ZN5clang14ASTMergeAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTMergeAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang14ASTMergeAction21BeginSourceFileActionERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTMergeAction::BeginSourceFileAction(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang14ASTMergeAction13ExecuteActionEv", "clang::ASTMergeAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang14ASTMergeAction19EndSourceFileActionEv", "clang::ASTMergeAction::EndSourceFileAction()"),
	mu_demangle_test("_ZN5clang14ASTMergeActionC1EPNS_14FrontendActionEPSsj", "clang::ASTMergeAction::ASTMergeAction(clang::FrontendAction*, std::string*, unsigned int)"),
	mu_demangle_test("_ZN5clang14ASTMergeActionC2EPNS_14FrontendActionEPSsj", "clang::ASTMergeAction::ASTMergeAction(clang::FrontendAction*, std::string*, unsigned int)"),
	mu_demangle_test("_ZN5clang14ASTMergeActionD0Ev", "clang::ASTMergeAction::~ASTMergeAction()"),
	mu_demangle_test("_ZN5clang14ASTMergeActionD1Ev", "clang::ASTMergeAction::~ASTMergeAction()"),
	mu_demangle_test("_ZN5clang14ASTMergeActionD2Ev", "clang::ASTMergeAction::~ASTMergeAction()"),
	mu_demangle_test("_ZNK5clang14ASTMergeAction20usesPreprocessorOnlyEv", "clang::ASTMergeAction::usesPreprocessorOnly() const"),
	mu_demangle_test("_ZN5clang14ASTMergeAction27usesCompleteTranslationUnitEv", "clang::ASTMergeAction::usesCompleteTranslationUnit()"),
	mu_demangle_test("_ZNK5clang14ASTMergeAction13hasPCHSupportEv", "clang::ASTMergeAction::hasPCHSupport() const"),
	mu_demangle_test("_ZNK5clang14ASTMergeAction17hasASTFileSupportEv", "clang::ASTMergeAction::hasASTFileSupport() const"),
	mu_demangle_test("_ZNK5clang14ASTMergeAction24hasCodeCompletionSupportEv", "clang::ASTMergeAction::hasCodeCompletionSupport() const"),
	mu_demangle_test("_ZN5clang7ASTUnitC1Eb", "clang::ASTUnit::ASTUnit(bool)"),
	mu_demangle_test("_ZN5clang7ASTUnitC2Eb", "clang::ASTUnit::ASTUnit(bool)"),
	mu_demangle_test("_ZN5clang7ASTUnitC3Eb", "clang::ASTUnit::ASTUnit(bool)"),
	mu_demangle_test("_ZN5clang7ASTUnitC4Eb", "clang::ASTUnit::ASTUnit(bool)"),
	mu_demangle_test("_ZN5clang7ASTUnitC5Eb", "clang::ASTUnit::ASTUnit(bool)"),
	mu_demangle_test("_ZN5clang7ASTUnitD0Ev", "clang::ASTUnit::~ASTUnit()"),
	mu_demangle_test("_ZN5clang7ASTUnitD1Ev", "clang::ASTUnit::~ASTUnit()"),
	mu_demangle_test("_ZN5clang7ASTUnitD2Ev", "clang::ASTUnit::~ASTUnit()"),
	mu_demangle_test("_ZN5clang7ASTUnitD4Ev", "clang::ASTUnit::~ASTUnit()"),
	mu_demangle_test("_ZN5clang7ASTUnitD5Ev", "clang::ASTUnit::~ASTUnit()"),
	mu_demangle_test("_ZN5clang7ASTUnit19CleanTemporaryFilesEv", "clang::ASTUnit::CleanTemporaryFiles()"),
	mu_demangle_test("_ZN5clang7ASTUnit28ClearCachedCompletionResultsEv", "clang::ASTUnit::ClearCachedCompletionResults()"),
	mu_demangle_test("_ZN5clang7ASTUnit26CacheCodeCompletionResultsEv", "clang::ASTUnit::CacheCodeCompletionResults()"),
	mu_demangle_test("_ZNK5clang7ASTUnit15getMainFileNameEv", "clang::ASTUnit::getMainFileName() const"),
	mu_demangle_test("_ZN12_GLOBAL__N_111SimpleTimerD1Ev", "(anonymous namespace)::SimpleTimer::~SimpleTimer()"),
	mu_demangle_test("_ZN5clang7ASTUnit25getOriginalSourceFileNameEv", "clang::ASTUnit::getOriginalSourceFileName()"),
	mu_demangle_test("_ZN5clang7ASTUnit14getASTFileNameEv", "clang::ASTUnit::getASTFileName()"),
	mu_demangle_test("_ZN5clang7ASTUnit16getBufferForFileEN4llvm9StringRefEPSs", "clang::ASTUnit::getBufferForFile(llvm::StringRef, std::string*)"),
	mu_demangle_test("_ZN5clang7ASTUnit14ConfigureDiagsERN4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEEPPKcS8_RS0_b", "clang::ASTUnit::ConfigureDiags(llvm::IntrusiveRefCntPtr<clang::Diagnostic>&, char const**, char const**, clang::ASTUnit&, bool)"),
	mu_demangle_test("_ZN5clang7ASTUnit15LoadFromASTFileERKSsN4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEERKNS_17FileSystemOptionsEbPSt4pairISsPKNS3_12MemoryBufferEEjb", "clang::ASTUnit::LoadFromASTFile(std::string const&, llvm::IntrusiveRefCntPtr<clang::Diagnostic>, clang::FileSystemOptions const&, bool, std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int, bool)"),
	mu_demangle_test("_ZN5clang7ASTUnit5ParseEPN4llvm12MemoryBufferE", "clang::ASTUnit::Parse(llvm::MemoryBuffer*)"),
	mu_demangle_test("_ZN5clang7ASTUnit15ComputePreambleERNS_18CompilerInvocationEjRb", "clang::ASTUnit::ComputePreamble(clang::CompilerInvocation&, unsigned int, bool&)"),
	mu_demangle_test("_ZN5clang7ASTUnit36getMainBufferWithPrecompiledPreambleENS_18CompilerInvocationEbj", "clang::ASTUnit::getMainBufferWithPrecompiledPreamble(clang::CompilerInvocation, bool, unsigned int)"),
	mu_demangle_test("_ZN5clang7ASTUnit32RealizeTopLevelDeclsFromPreambleEv", "clang::ASTUnit::RealizeTopLevelDeclsFromPreamble()"),
	mu_demangle_test("_ZN5clang7ASTUnit39RealizePreprocessedEntitiesFromPreambleEv", "clang::ASTUnit::RealizePreprocessedEntitiesFromPreamble()"),
	mu_demangle_test("_ZN5clang7ASTUnit15pp_entity_beginEv", "clang::ASTUnit::pp_entity_begin()"),
	mu_demangle_test("_ZN5clang7ASTUnit13pp_entity_endEv", "clang::ASTUnit::pp_entity_end()"),
	mu_demangle_test("_ZNK5clang7ASTUnit14getMaxPCHLevelEv", "clang::ASTUnit::getMaxPCHLevel() const"),
	mu_demangle_test("_ZN5clang7ASTUnit26LoadFromCompilerInvocationEb", "clang::ASTUnit::LoadFromCompilerInvocation(bool)"),
	mu_demangle_test("_ZN5clang7ASTUnit26LoadFromCompilerInvocationEPNS_18CompilerInvocationEN4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEEbbbbb", "clang::ASTUnit::LoadFromCompilerInvocation(clang::CompilerInvocation*, llvm::IntrusiveRefCntPtr<clang::Diagnostic>, bool, bool, bool, bool, bool)"),
	mu_demangle_test("_ZN5clang7ASTUnit19LoadFromCommandLineEPPKcS3_N4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEENS4_9StringRefEbbPSt4pairISsPKNS4_12MemoryBufferEEjbbbbb", "clang::ASTUnit::LoadFromCommandLine(char const**, char const**, llvm::IntrusiveRefCntPtr<clang::Diagnostic>, llvm::StringRef, bool, bool, std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int, bool, bool, bool, bool, bool)"),
	mu_demangle_test("_ZN5clang7ASTUnit7ReparseEPSt4pairISsPKN4llvm12MemoryBufferEEj", "clang::ASTUnit::Reparse(std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int)"),
	mu_demangle_test("_ZN5clang7ASTUnit12CodeCompleteEN4llvm9StringRefEjjPSt4pairISsPKNS1_12MemoryBufferEEjbbRNS_20CodeCompleteConsumerERNS_10DiagnosticERNS_11LangOptionsERNS_13SourceManagerERNS_11FileManagerERNS1_15SmallVectorImplINS_16StoredDiagnosticEEERNSJ_IS6_EE", "clang::ASTUnit::CodeComplete(llvm::StringRef, unsigned int, unsigned int, std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int, bool, bool, clang::CodeCompleteConsumer&, clang::Diagnostic&, clang::LangOptions&, clang::SourceManager&, clang::FileManager&, llvm::SmallVectorImpl<clang::StoredDiagnostic>&, llvm::SmallVectorImpl<llvm::MemoryBuffer const*>&)"),
	mu_demangle_test("_ZN5clang7ASTUnit4SaveEN4llvm9StringRefE", "clang::ASTUnit::Save(llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumerD1Ev", "(anonymous namespace)::AugmentedCodeCompleteConsumer::~AugmentedCodeCompleteConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumerD0Ev", "(anonymous namespace)::AugmentedCodeCompleteConsumer::~AugmentedCodeCompleteConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumer26ProcessCodeCompleteResultsERN5clang4SemaENS1_21CodeCompletionContextEPNS1_20CodeCompletionResultEj", "(anonymous namespace)::AugmentedCodeCompleteConsumer::ProcessCodeCompleteResults(clang::Sema&, clang::CodeCompletionContext, clang::CodeCompletionResult*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumer25ProcessOverloadCandidatesERN5clang4SemaEjPNS1_20CodeCompleteConsumer17OverloadCandidateEj", "(anonymous namespace)::AugmentedCodeCompleteConsumer::ProcessOverloadCandidates(clang::Sema&, unsigned int, clang::CodeCompleteConsumer::OverloadCandidate*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumer12getAllocatorEv", "(anonymous namespace)::AugmentedCodeCompleteConsumer::getAllocator()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122StoredDiagnosticClientD1Ev", "(anonymous namespace)::StoredDiagnosticClient::~StoredDiagnosticClient()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122StoredDiagnosticClientD0Ev", "(anonymous namespace)::StoredDiagnosticClient::~StoredDiagnosticClient()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122StoredDiagnosticClient16HandleDiagnosticEN5clang10Diagnostic5LevelERKNS1_14DiagnosticInfoE", "(anonymous namespace)::StoredDiagnosticClient::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrecompilePreambleAction17CreateASTConsumerERN5clang16CompilerInstanceEN4llvm9StringRefE", "(anonymous namespace)::PrecompilePreambleAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrecompilePreambleActionD1Ev", "(anonymous namespace)::PrecompilePreambleAction::~PrecompilePreambleAction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrecompilePreambleActionD0Ev", "(anonymous namespace)::PrecompilePreambleAction::~PrecompilePreambleAction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrecompilePreambleAction27usesCompleteTranslationUnitEv", "(anonymous namespace)::PrecompilePreambleAction::usesCompleteTranslationUnit()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_124PrecompilePreambleAction17hasASTFileSupportEv", "(anonymous namespace)::PrecompilePreambleAction::hasASTFileSupport() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_124PrecompilePreambleAction24hasCodeCompletionSupportEv", "(anonymous namespace)::PrecompilePreambleAction::hasCodeCompletionSupport() const"),
	mu_demangle_test("_ZN12_GLOBAL__N_126PrecompilePreambleConsumerD1Ev", "(anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_126PrecompilePreambleConsumerD0Ev", "(anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_126PrecompilePreambleConsumer18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::PrecompilePreambleConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126PrecompilePreambleConsumer21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::PrecompilePreambleConsumer::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126PrecompilePreambleConsumer27GetASTSerializationListenerEv", "(anonymous namespace)::PrecompilePreambleConsumer::GetASTSerializationListener()"),
	mu_demangle_test("_ZN12_GLOBAL__N_126PrecompilePreambleConsumer28SerializedPreprocessedEntityEPN5clang18PreprocessedEntityEy", "(anonymous namespace)::PrecompilePreambleConsumer::SerializedPreprocessedEntity(clang::PreprocessedEntity*, uint64_t)"),
	mu_demangle_test("_ZThn1912_N12_GLOBAL__N_126PrecompilePreambleConsumerD1Ev", "non-virtual thunk to (anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"),
	mu_demangle_test("_ZThn1912_N12_GLOBAL__N_126PrecompilePreambleConsumerD0Ev", "non-virtual thunk to (anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"),
	mu_demangle_test("_ZThn1912_N12_GLOBAL__N_126PrecompilePreambleConsumer28SerializedPreprocessedEntityEPN5clang18PreprocessedEntityEy", "non-virtual thunk to (anonymous namespace)::PrecompilePreambleConsumer::SerializedPreprocessedEntity(clang::PreprocessedEntity*, uint64_t)"),
	mu_demangle_test("_ZN12_GLOBAL__N_125TopLevelDeclTrackerAction17CreateASTConsumerERN5clang16CompilerInstanceEN4llvm9StringRefE", "(anonymous namespace)::TopLevelDeclTrackerAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_125TopLevelDeclTrackerActionD1Ev", "(anonymous namespace)::TopLevelDeclTrackerAction::~TopLevelDeclTrackerAction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_125TopLevelDeclTrackerActionD0Ev", "(anonymous namespace)::TopLevelDeclTrackerAction::~TopLevelDeclTrackerAction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_125TopLevelDeclTrackerAction27usesCompleteTranslationUnitEv", "(anonymous namespace)::TopLevelDeclTrackerAction::usesCompleteTranslationUnit()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_125TopLevelDeclTrackerAction24hasCodeCompletionSupportEv", "(anonymous namespace)::TopLevelDeclTrackerAction::hasCodeCompletionSupport() const"),
	mu_demangle_test("_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumerD1Ev", "(anonymous namespace)::TopLevelDeclTrackerConsumer::~TopLevelDeclTrackerConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumerD0Ev", "(anonymous namespace)::TopLevelDeclTrackerConsumer::~TopLevelDeclTrackerConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumer18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::TopLevelDeclTrackerConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumer21HandleInterestingDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::TopLevelDeclTrackerConsumer::HandleInterestingDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ASTInfoCollectorD1Ev", "(anonymous namespace)::ASTInfoCollector::~ASTInfoCollector()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ASTInfoCollectorD0Ev", "(anonymous namespace)::ASTInfoCollector::~ASTInfoCollector()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ASTInfoCollector19ReadLanguageOptionsERKN5clang11LangOptionsE", "(anonymous namespace)::ASTInfoCollector::ReadLanguageOptions(clang::LangOptions const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ASTInfoCollector16ReadTargetTripleEN4llvm9StringRefE", "(anonymous namespace)::ASTInfoCollector::ReadTargetTriple(llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ASTInfoCollector20ReadPredefinesBufferERKN4llvm11SmallVectorIN5clang18PCHPredefinesBlockELj2EEENS1_9StringRefERSs", "(anonymous namespace)::ASTInfoCollector::ReadPredefinesBuffer(llvm::SmallVector<clang::PCHPredefinesBlock, 2u> const&, llvm::StringRef, std::string&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ASTInfoCollector18ReadHeaderFileInfoERKN5clang14HeaderFileInfoEj", "(anonymous namespace)::ASTInfoCollector::ReadHeaderFileInfo(clang::HeaderFileInfo const&, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ASTInfoCollector11ReadCounterEj", "(anonymous namespace)::ASTInfoCollector::ReadCounter(unsigned int)"),
	mu_demangle_test("_ZN5clang19PreprocessorOptions15addRemappedFileEN4llvm9StringRefEPKNS1_12MemoryBufferE", "clang::PreprocessorOptions::addRemappedFile(llvm::StringRef, llvm::MemoryBuffer const*)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPKcE6insertIPS2_EES5_S5_T_S6_", "char const** llvm::SmallVectorImpl<char const*>::insert<char const**>(char const**, char const**, char const**)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE4swapERS3_", "llvm::SmallVectorImpl<clang::StoredDiagnostic>::swap(llvm::SmallVectorImpl<clang::StoredDiagnostic>&)"),
	mu_demangle_test("_ZN5clang11LangOptionsaSERKS0_", "clang::LangOptions::operator=(clang::LangOptions const&)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE6insertIPS2_EES5_S5_T_S6_", "clang::StoredDiagnostic* llvm::SmallVectorImpl<clang::StoredDiagnostic>::insert<clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE9push_backERKS2_", "llvm::SmallVectorImpl<clang::StoredDiagnostic>::push_back(clang::StoredDiagnostic const&)"),
	mu_demangle_test("_ZN5clang9ASTWriterD1Ev", "clang::ASTWriter::~ASTWriter()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE6appendIPS2_EEvT_S6_", "void llvm::SmallVectorImpl<clang::StoredDiagnostic>::append<clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang16StoredDiagnosticELb0EE18uninitialized_copyIPS2_S5_EEvT_S6_T0_", "void llvm::SmallVectorTemplateBase<clang::StoredDiagnostic, false>::uninitialized_copy<clang::StoredDiagnostic*, clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"),
	mu_demangle_test("_ZNSt6__copyILb0ESt26random_access_iterator_tagE4copyIPN5clang16StoredDiagnosticES5_EET0_T_S7_S6_", "clang::StoredDiagnostic* std::__copy<false, std::random_access_iterator_tag>::copy<clang::StoredDiagnostic*, clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"),
	mu_demangle_test("_ZNSt15__copy_backwardILb0ESt26random_access_iterator_tagE8__copy_bIPN5clang16StoredDiagnosticES5_EET0_T_S7_S6_", "clang::StoredDiagnostic* std::__copy_backward<false, std::random_access_iterator_tag>::__copy_b<clang::StoredDiagnostic*, clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang16StoredDiagnosticELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::StoredDiagnostic, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm9StringMapISt4pairIxlENS_15MallocAllocatorEE16GetOrCreateValueIS2_EERNS_14StringMapEntryIS2_EENS_9StringRefET_", "llvm::StringMapEntry<std::pair<int64_t, long> >& llvm::StringMap<std::pair<int64_t, long>, llvm::MallocAllocator>::GetOrCreateValue<std::pair<int64_t, long> >(llvm::StringRef, std::pair<int64_t, long>)"),
	mu_demangle_test("_ZN4llvm8DenseMapIN5clang7CanQualINS1_4TypeEEEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::CanQual<clang::Type>, unsigned int, llvm::DenseMapInfo<clang::CanQual<clang::Type> >, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::CanQual<clang::Type> const&, unsigned int const&, std::pair<clang::CanQual<clang::Type>, unsigned int>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIN5clang7CanQualINS1_4TypeEEEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::CanQual<clang::Type>, unsigned int, llvm::DenseMapInfo<clang::CanQual<clang::Type> >, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriterD2Ev", "llvm::BitstreamWriter::~BitstreamWriter()"),
	mu_demangle_test("_ZThn8_N5clang9ASTWriterD1Ev", "non-virtual thunk to clang::ASTWriter::~ASTWriter()"),
	mu_demangle_test("_ZN5clang9ASTWriterD2Ev", "clang::ASTWriter::~ASTWriter()"),
	mu_demangle_test("_ZN5clang9ASTWriterD0Ev", "clang::ASTWriter::~ASTWriter()"),
	mu_demangle_test("_ZThn8_N5clang9ASTWriterD0Ev", "non-virtual thunk to clang::ASTWriter::~ASTWriter()"),
	mu_demangle_test("_ZNSt8_Rb_treeIPN5clang10SwitchCaseESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<clang::SwitchCase*, std::pair<clang::SwitchCase* const, unsigned int>, std::_Select1st<std::pair<clang::SwitchCase* const, unsigned int> >, std::less<clang::SwitchCase*>, std::allocator<std::pair<clang::SwitchCase* const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::SwitchCase* const, unsigned int> >*)"),
	mu_demangle_test("_ZNSt8_Rb_treeIPN5clang9LabelStmtESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<clang::LabelStmt*, std::pair<clang::LabelStmt* const, unsigned int>, std::_Select1st<std::pair<clang::LabelStmt* const, unsigned int> >, std::less<clang::LabelStmt*>, std::allocator<std::pair<clang::LabelStmt* const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::LabelStmt* const, unsigned int> >*)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang20CodeCompletionResultEE6insertIPS2_EES5_S5_T_S6_", "clang::CodeCompletionResult* llvm::SmallVectorImpl<clang::CodeCompletionResult>::insert<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang20CodeCompletionResultELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeCompletionResult, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang20CodeCompletionString5ChunkELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeCompletionString::Chunk, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm9StringSetINS_16BumpPtrAllocatorEE6insertENS_9StringRefE", "llvm::StringSet<llvm::BumpPtrAllocator>::insert(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang18CompilerInvocationC2ERKS0_", "clang::CompilerInvocation::CompilerInvocation(clang::CompilerInvocation const&)"),
	mu_demangle_test("_ZN5clang19PreprocessorOptionsC2ERKS0_", "clang::PreprocessorOptions::PreprocessorOptions(clang::PreprocessorOptions const&)"),
	mu_demangle_test("_ZN5clang15FrontendOptionsC2ERKS0_", "clang::FrontendOptions::FrontendOptions(clang::FrontendOptions const&)"),
	mu_demangle_test("_ZN5clang17DiagnosticOptionsC2ERKS0_", "clang::DiagnosticOptions::DiagnosticOptions(clang::DiagnosticOptions const&)"),
	mu_demangle_test("_ZN5clang14CodeGenOptionsC2ERKS0_", "clang::CodeGenOptions::CodeGenOptions(clang::CodeGenOptions const&)"),
	mu_demangle_test("_ZN5clang15AnalyzerOptionsC2ERKS0_", "clang::AnalyzerOptions::AnalyzerOptions(clang::AnalyzerOptions const&)"),
	mu_demangle_test("_ZN5clang12PCHGenerator14InitializeSemaERNS_4SemaE", "clang::PCHGenerator::InitializeSema(clang::Sema&)"),
	mu_demangle_test("_ZN5clang12PCHGeneratorD1Ev", "clang::PCHGenerator::~PCHGenerator()"),
	mu_demangle_test("_ZN5clang12PCHGeneratorD0Ev", "clang::PCHGenerator::~PCHGenerator()"),
	mu_demangle_test("_ZN5clang14BoostConAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::BoostConAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_119BoostConASTConsumerD1Ev", "(anonymous namespace)::BoostConASTConsumer::~BoostConASTConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_119BoostConASTConsumerD0Ev", "(anonymous namespace)::BoostConASTConsumer::~BoostConASTConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_119BoostConASTConsumer21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::BoostConASTConsumer::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE12TraverseDeclEPNS_4DeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseDecl(clang::Decl*)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE12TraverseStmtEPNS_4StmtE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseStmt(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE15TraverseTypeLocENS_7TypeLocE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseTypeLoc(clang::TypeLoc)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE27TraverseNestedNameSpecifierEPNS_19NestedNameSpecifierE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseNestedNameSpecifier(clang::NestedNameSpecifier*)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE27TraverseTemplateArgumentLocERKNS_19TemplateArgumentLocE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseTemplateArgumentLoc(clang::TemplateArgumentLoc const&)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE24TraverseTemplateArgumentERKNS_16TemplateArgumentE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseTemplateArgument(clang::TemplateArgument const&)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE12TraverseTypeENS_8QualTypeE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseType(clang::QualType)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE24TraverseDeclaratorHelperEPNS_14DeclaratorDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseDeclaratorHelper(clang::DeclaratorDecl*)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE22TraverseFunctionHelperEPNS_12FunctionDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseFunctionHelper(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE23TraverseCXXRecordHelperEPNS_13CXXRecordDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseCXXRecordHelper(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE23WalkUpFromCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::WalkUpFromCXXRecordDecl(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang14BoostConActionD1Ev", "clang::BoostConAction::~BoostConAction()"),
	mu_demangle_test("_ZN5clang14BoostConActionD0Ev", "clang::BoostConAction::~BoostConAction()"),
	mu_demangle_test("_ZNK5clang38DependentTemplateSpecializationTypeLoc9getArgLocEj", "clang::DependentTemplateSpecializationTypeLoc::getArgLoc(unsigned int) const"),
	mu_demangle_test("_ZNK5clang29TemplateSpecializationTypeLoc9getArgLocEj", "clang::TemplateSpecializationTypeLoc::getArgLoc(unsigned int) const"),
	mu_demangle_test("_ZN5clang11CacheTokensERNS_12PreprocessorEPN4llvm14raw_fd_ostreamE", "clang::CacheTokens(clang::Preprocessor&, llvm::raw_fd_ostream*)"),
	mu_demangle_test("_ZN5clang31OnDiskChainedHashTableGeneratorIN12_GLOBAL__N_121FileEntryPTHEntryInfoEE6insertENS1_18PTHEntryKeyVariantERKNS1_8PTHEntryE", "clang::OnDiskChainedHashTableGenerator<(anonymous namespace)::FileEntryPTHEntryInfo>::insert((anonymous namespace)::PTHEntryKeyVariant, (anonymous namespace)::PTHEntry const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19PTHWriter9EmitTokenERKN5clang5TokenE", "(anonymous namespace)::PTHWriter::EmitToken(clang::Token const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_112StatListenerD1Ev", "(anonymous namespace)::StatListener::~StatListener()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112StatListenerD0Ev", "(anonymous namespace)::StatListener::~StatListener()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112StatListener7getStatEPKcR4statPi", "(anonymous namespace)::StatListener::getStat(char const*, stat&, int*)"),
	mu_demangle_test("_ZN5clang2io6Emit32ERN4llvm11raw_ostreamEj", "clang::io::Emit32(llvm::raw_ostream&, unsigned int)"),
	mu_demangle_test("_ZN5clang2io6Emit64ERN4llvm11raw_ostreamEy", "clang::io::Emit64(llvm::raw_ostream&, uint64_t)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang14IdentifierInfoEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::IdentifierInfo const*, unsigned int, llvm::DenseMapInfo<clang::IdentifierInfo const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::IdentifierInfo const* const&, unsigned int const&, std::pair<clang::IdentifierInfo const*, unsigned int>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang14IdentifierInfoEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::IdentifierInfo const*, unsigned int, llvm::DenseMapInfo<clang::IdentifierInfo const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"),
	mu_demangle_test("_ZN5clang16CompilerInstanceC1Ev", "clang::CompilerInstance::CompilerInstance()"),
	mu_demangle_test("_ZN5clang16CompilerInstanceC2Ev", "clang::CompilerInstance::CompilerInstance()"),
	mu_demangle_test("_ZN5clang16CompilerInstanceD1Ev", "clang::CompilerInstance::~CompilerInstance()"),
	mu_demangle_test("_ZN5clang16CompilerInstanceD2Ev", "clang::CompilerInstance::~CompilerInstance()"),
	mu_demangle_test("_ZN5clang16CompilerInstance14setLLVMContextEPN4llvm11LLVMContextE", "clang::CompilerInstance::setLLVMContext(llvm::LLVMContext*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance13setInvocationEPNS_18CompilerInvocationE", "clang::CompilerInstance::setInvocation(clang::CompilerInvocation*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance14setDiagnosticsEPNS_10DiagnosticE", "clang::CompilerInstance::setDiagnostics(clang::Diagnostic*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance9setTargetEPNS_10TargetInfoE", "clang::CompilerInstance::setTarget(clang::TargetInfo*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance14setFileManagerEPNS_11FileManagerE", "clang::CompilerInstance::setFileManager(clang::FileManager*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance16setSourceManagerEPNS_13SourceManagerE", "clang::CompilerInstance::setSourceManager(clang::SourceManager*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance15setPreprocessorEPNS_12PreprocessorE", "clang::CompilerInstance::setPreprocessor(clang::Preprocessor*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance13setASTContextEPNS_10ASTContextE", "clang::CompilerInstance::setASTContext(clang::ASTContext*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance7setSemaEPNS_4SemaE", "clang::CompilerInstance::setSema(clang::Sema*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance14setASTConsumerEPNS_11ASTConsumerE", "clang::CompilerInstance::setASTConsumer(clang::ASTConsumer*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance25setCodeCompletionConsumerEPNS_20CodeCompleteConsumerE", "clang::CompilerInstance::setCodeCompletionConsumer(clang::CodeCompleteConsumer*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance17createDiagnosticsEiPKPKcPNS_16DiagnosticClientE", "clang::CompilerInstance::createDiagnostics(int, char const* const*, clang::DiagnosticClient*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance17createDiagnosticsERKNS_17DiagnosticOptionsEiPKPKcPNS_16DiagnosticClientE", "clang::CompilerInstance::createDiagnostics(clang::DiagnosticOptions const&, int, char const* const*, clang::DiagnosticClient*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance17createFileManagerEv", "clang::CompilerInstance::createFileManager()"),
	mu_demangle_test("_ZN5clang16CompilerInstance19createSourceManagerERNS_11FileManagerE", "clang::CompilerInstance::createSourceManager(clang::FileManager&)"),
	mu_demangle_test("_ZN5clang16CompilerInstance18createPreprocessorEv", "clang::CompilerInstance::createPreprocessor()"),
	mu_demangle_test("_ZN5clang16CompilerInstance18createPreprocessorERNS_10DiagnosticERKNS_11LangOptionsERKNS_19PreprocessorOptionsERKNS_19HeaderSearchOptionsERKNS_23DependencyOutputOptionsERKNS_10TargetInfoERKNS_15FrontendOptionsERNS_13SourceManagerERNS_11FileManagerE", "clang::CompilerInstance::createPreprocessor(clang::Diagnostic&, clang::LangOptions const&, clang::PreprocessorOptions const&, clang::HeaderSearchOptions const&, clang::DependencyOutputOptions const&, clang::TargetInfo const&, clang::FrontendOptions const&, clang::SourceManager&, clang::FileManager&)"),
	mu_demangle_test("_ZN5clang16CompilerInstance16createASTContextEv", "clang::CompilerInstance::createASTContext()"),
	mu_demangle_test("_ZN5clang16CompilerInstance26createPCHExternalASTSourceEN4llvm9StringRefEbbPv", "clang::CompilerInstance::createPCHExternalASTSource(llvm::StringRef, bool, bool, void*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance26createPCHExternalASTSourceEN4llvm9StringRefERKSsbbRNS_12PreprocessorERNS_10ASTContextEPvb", "clang::CompilerInstance::createPCHExternalASTSource(llvm::StringRef, std::string const&, bool, bool, clang::Preprocessor&, clang::ASTContext&, void*, bool)"),
	mu_demangle_test("_ZN5clang16CompilerInstance28createCodeCompletionConsumerEv", "clang::CompilerInstance::createCodeCompletionConsumer()"),
	mu_demangle_test("_ZN5clang16CompilerInstance28createCodeCompletionConsumerERNS_12PreprocessorERKSsjjbbbRN4llvm11raw_ostreamE", "clang::CompilerInstance::createCodeCompletionConsumer(clang::Preprocessor&, std::string const&, unsigned int, unsigned int, bool, bool, bool, llvm::raw_ostream&)"),
	mu_demangle_test("_Z20EnableCodeCompletionRN5clang12PreprocessorERKSsjj", "EnableCodeCompletion(clang::Preprocessor&, std::string const&, unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang16CompilerInstance19createFrontendTimerEv", "clang::CompilerInstance::createFrontendTimer()"),
	mu_demangle_test("_ZN5clang16CompilerInstance10createSemaEbPNS_20CodeCompleteConsumerE", "clang::CompilerInstance::createSema(bool, clang::CodeCompleteConsumer*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance13addOutputFileERKNS0_10OutputFileE", "clang::CompilerInstance::addOutputFile(clang::CompilerInstance::OutputFile const&)"),
	mu_demangle_test("_ZN5clang16CompilerInstance16clearOutputFilesEb", "clang::CompilerInstance::clearOutputFiles(bool)"),
	mu_demangle_test("_ZN5clang16CompilerInstance23createDefaultOutputFileEbN4llvm9StringRefES2_", "clang::CompilerInstance::createDefaultOutputFile(bool, llvm::StringRef, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang16CompilerInstance16createOutputFileEN4llvm9StringRefEbbS2_S2_", "clang::CompilerInstance::createOutputFile(llvm::StringRef, bool, bool, llvm::StringRef, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang16CompilerInstance16createOutputFileEN4llvm9StringRefERSsbbS2_S2_PSsS4_", "clang::CompilerInstance::createOutputFile(llvm::StringRef, std::string&, bool, bool, llvm::StringRef, llvm::StringRef, std::string*, std::string*)"),
	mu_demangle_test("_ZN5clang16CompilerInstance23InitializeSourceManagerEN4llvm9StringRefE", "clang::CompilerInstance::InitializeSourceManager(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang16CompilerInstance23InitializeSourceManagerEN4llvm9StringRefERNS_10DiagnosticERNS_11FileManagerERNS_13SourceManagerERKNS_15FrontendOptionsE", "clang::CompilerInstance::InitializeSourceManager(llvm::StringRef, clang::Diagnostic&, clang::FileManager&, clang::SourceManager&, clang::FrontendOptions const&)"),
	mu_demangle_test("_ZN5clang16CompilerInstance13ExecuteActionERNS_14FrontendActionE", "clang::CompilerInstance::ExecuteAction(clang::FrontendAction&)"),
	mu_demangle_test("_ZN5clang28PrintingCodeCompleteConsumer12getAllocatorEv", "clang::PrintingCodeCompleteConsumer::getAllocator()"),
	mu_demangle_test("_ZN5clang20CodeCompleteConsumer26ProcessCodeCompleteResultsERNS_4SemaENS_21CodeCompletionContextEPNS_20CodeCompletionResultEj", "clang::CodeCompleteConsumer::ProcessCodeCompleteResults(clang::Sema&, clang::CodeCompletionContext, clang::CodeCompletionResult*, unsigned int)"),
	mu_demangle_test("_ZN5clang20CodeCompleteConsumer25ProcessOverloadCandidatesERNS_4SemaEjPNS0_17OverloadCandidateEj", "clang::CodeCompleteConsumer::ProcessOverloadCandidates(clang::Sema&, unsigned int, clang::CodeCompleteConsumer::OverloadCandidate*, unsigned int)"),
	mu_demangle_test("_ZN5clang23ChainedDiagnosticClientD1Ev", "clang::ChainedDiagnosticClient::~ChainedDiagnosticClient()"),
	mu_demangle_test("_ZN5clang23ChainedDiagnosticClientD0Ev", "clang::ChainedDiagnosticClient::~ChainedDiagnosticClient()"),
	mu_demangle_test("_ZN5clang23ChainedDiagnosticClient15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::ChainedDiagnosticClient::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"),
	mu_demangle_test("_ZN5clang23ChainedDiagnosticClient13EndSourceFileEv", "clang::ChainedDiagnosticClient::EndSourceFile()"),
	mu_demangle_test("_ZNK5clang23ChainedDiagnosticClient25IncludeInDiagnosticCountsEv", "clang::ChainedDiagnosticClient::IncludeInDiagnosticCounts() const"),
	mu_demangle_test("_ZN5clang23ChainedDiagnosticClient16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::ChainedDiagnosticClient::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"),
	mu_demangle_test("_ZN5clang18CompilerInvocation16GetResourcesPathEPKcPv", "clang::CompilerInvocation::GetResourcesPath(char const*, void*)"),
	mu_demangle_test("_ZN5clang18CompilerInvocation15setLangDefaultsERNS_11LangOptionsENS_9InputKindENS_12LangStandard4KindE", "clang::CompilerInvocation::setLangDefaults(clang::LangOptions&, clang::InputKind, clang::LangStandard::Kind)"),
	mu_demangle_test("_ZN5clang18CompilerInvocation14CreateFromArgsERS0_PKPKcS5_RNS_10DiagnosticE", "clang::CompilerInvocation::CreateFromArgs(clang::CompilerInvocation&, char const* const*, char const* const*, clang::Diagnostic&)"),
	mu_demangle_test("_ZN5clang19PreprocessorOptions11addMacroDefEN4llvm9StringRefE", "clang::PreprocessorOptions::addMacroDef(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang19PreprocessorOptions13addMacroUndefEN4llvm9StringRefE", "clang::PreprocessorOptions::addMacroUndef(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang19PreprocessorOptions15addRemappedFileEN4llvm9StringRefES2_", "clang::PreprocessorOptions::addRemappedFile(llvm::StringRef, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang19HeaderSearchOptions7AddPathEN4llvm9StringRefENS_8frontend15IncludeDirGroupEbbb", "clang::HeaderSearchOptions::AddPath(llvm::StringRef, clang::frontend::IncludeDirGroup, bool, bool, bool)"),
	mu_demangle_test("_ZN5clang11DocumentXML14writeDeclToXMLEPNS_4DeclE", "clang::DocumentXML::writeDeclToXML(clang::Decl*)"),
	mu_demangle_test("_ZN5clang11DeclVisitorINS_11DocumentXML11DeclPrinterEvE5VisitEPNS_4DeclE", "clang::DeclVisitor<clang::DocumentXML::DeclPrinter, void>::Visit(clang::Decl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter20VisitLinkageSpecDeclEPNS_15LinkageSpecDeclE", "clang::DocumentXML::DeclPrinter::VisitLinkageSpecDecl(clang::LinkageSpecDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter18VisitNamespaceDeclEPNS_13NamespaceDeclE", "clang::DocumentXML::DeclPrinter::VisitNamespaceDecl(clang::NamespaceDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter23VisitNamespaceAliasDeclEPNS_18NamespaceAliasDeclE", "clang::DocumentXML::DeclPrinter::VisitNamespaceAliasDecl(clang::NamespaceAliasDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter13VisitEnumDeclEPNS_8EnumDeclE", "clang::DocumentXML::DeclPrinter::VisitEnumDecl(clang::EnumDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter15VisitRecordDeclEPNS_10RecordDeclE", "clang::DocumentXML::DeclPrinter::VisitRecordDecl(clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter18VisitCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXRecordDecl(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter25VisitTemplateTypeParmDeclEPNS_20TemplateTypeParmDeclE", "clang::DocumentXML::DeclPrinter::VisitTemplateTypeParmDecl(clang::TemplateTypeParmDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter16VisitTypedefDeclEPNS_11TypedefDeclE", "clang::DocumentXML::DeclPrinter::VisitTypedefDecl(clang::TypedefDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter14VisitUsingDeclEPNS_9UsingDeclE", "clang::DocumentXML::DeclPrinter::VisitUsingDecl(clang::UsingDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter23VisitUsingDirectiveDeclEPNS_18UsingDirectiveDeclE", "clang::DocumentXML::DeclPrinter::VisitUsingDirectiveDecl(clang::UsingDirectiveDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter20VisitUsingShadowDeclEPNS_15UsingShadowDeclE", "clang::DocumentXML::DeclPrinter::VisitUsingShadowDecl(clang::UsingShadowDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter14VisitFieldDeclEPNS_9FieldDeclE", "clang::DocumentXML::DeclPrinter::VisitFieldDecl(clang::FieldDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter17VisitFunctionDeclEPNS_12FunctionDeclE", "clang::DocumentXML::DeclPrinter::VisitFunctionDecl(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter18VisitCXXMethodDeclEPNS_13CXXMethodDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXMethodDecl(clang::CXXMethodDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter23VisitCXXConstructorDeclEPNS_18CXXConstructorDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXConstructorDecl(clang::CXXConstructorDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter22VisitCXXConversionDeclEPNS_17CXXConversionDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXConversionDecl(clang::CXXConversionDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter22VisitCXXDestructorDeclEPNS_17CXXDestructorDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXDestructorDecl(clang::CXXDestructorDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter12VisitVarDeclEPNS_7VarDeclE", "clang::DocumentXML::DeclPrinter::VisitVarDecl(clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter16VisitParmVarDeclEPNS_11ParmVarDeclE", "clang::DocumentXML::DeclPrinter::VisitParmVarDecl(clang::ParmVarDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter21VisitEnumConstantDeclEPNS_16EnumConstantDeclE", "clang::DocumentXML::DeclPrinter::VisitEnumConstantDecl(clang::EnumConstantDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter9VisitDeclEPNS_4DeclE", "clang::DocumentXML::DeclPrinter::VisitDecl(clang::Decl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter15addFunctionBodyEPNS_12FunctionDeclE", "clang::DocumentXML::DeclPrinter::addFunctionBody(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter11addSubNodesEPNS_13CXXRecordDeclE", "clang::DocumentXML::DeclPrinter::addSubNodes(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter11addSubNodesEPNS_10RecordDeclE", "clang::DocumentXML::DeclPrinter::addSubNodes(clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter11addSubNodesEPNS_8EnumDeclE", "clang::DocumentXML::DeclPrinter::addSubNodes(clang::EnumDecl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11DeclPrinter17VisitTemplateDeclEPNS_12TemplateDeclE", "clang::DocumentXML::DeclPrinter::VisitTemplateDecl(clang::TemplateDecl*)"),
	mu_demangle_test("_ZN5clang23AttachDependencyFileGenERNS_12PreprocessorERKNS_23DependencyOutputOptionsE", "clang::AttachDependencyFileGen(clang::Preprocessor&, clang::DependencyOutputOptions const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122DependencyFileCallbackD1Ev", "(anonymous namespace)::DependencyFileCallback::~DependencyFileCallback()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122DependencyFileCallbackD0Ev", "(anonymous namespace)::DependencyFileCallback::~DependencyFileCallback()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122DependencyFileCallback11FileChangedEN5clang14SourceLocationENS1_11PPCallbacks16FileChangeReasonENS1_6SrcMgr18CharacteristicKindE", "(anonymous namespace)::DependencyFileCallback::FileChanged(clang::SourceLocation, clang::PPCallbacks::FileChangeReason, clang::SrcMgr::CharacteristicKind)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122DependencyFileCallback13EndOfMainFileEv", "(anonymous namespace)::DependencyFileCallback::EndOfMainFile()"),
	mu_demangle_test("_ZN5clang11DocumentXMLC1ERKSsRN4llvm11raw_ostreamE", "clang::DocumentXML::DocumentXML(std::string const&, llvm::raw_ostream&)"),
	mu_demangle_test("_ZN5clang11DocumentXMLC2ERKSsRN4llvm11raw_ostreamE", "clang::DocumentXML::DocumentXML(std::string const&, llvm::raw_ostream&)"),
	mu_demangle_test("_ZN5clang11DocumentXML10addSubNodeERKSs", "clang::DocumentXML::addSubNode(std::string const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML6IndentEv", "clang::DocumentXML::Indent()"),
	mu_demangle_test("_ZN5clang11DocumentXML8toParentEv", "clang::DocumentXML::toParent()"),
	mu_demangle_test("_ZN5clang11DocumentXML12escapeStringEPKcm", "clang::DocumentXML::escapeString(char const*, unsigned long)"),
	mu_demangle_test("_ZN5clang11DocumentXML8finalizeEv", "clang::DocumentXML::finalize()"),
	mu_demangle_test("_ZN5clang11DocumentXML12addAttributeEPKcRKNS_8QualTypeE", "clang::DocumentXML::addAttribute(char const*, clang::QualType const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML18addTypeRecursivelyERKNS_8QualTypeE", "clang::DocumentXML::addTypeRecursively(clang::QualType const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_4TypeE", "clang::DocumentXML::addPtrAttribute(char const*, clang::Type const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML18addTypeRecursivelyEPKNS_4TypeE", "clang::DocumentXML::addTypeRecursively(clang::Type const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_19NestedNameSpecifierE", "clang::DocumentXML::addPtrAttribute(char const*, clang::NestedNameSpecifier const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_13NamespaceDeclE", "clang::DocumentXML::addPtrAttribute(char const*, clang::NamespaceDecl const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_11DeclContextE", "clang::DocumentXML::addPtrAttribute(char const*, clang::DeclContext const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML22addContextsRecursivelyEPKNS_11DeclContextE", "clang::DocumentXML::addContextsRecursively(clang::DeclContext const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_9NamedDeclE", "clang::DocumentXML::addPtrAttribute(char const*, clang::NamedDecl const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML22addSourceFileAttributeERKSs", "clang::DocumentXML::addSourceFileAttribute(std::string const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_9LabelStmtE", "clang::DocumentXML::addPtrAttribute(char const*, clang::LabelStmt const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML11addLocationERKNS_14SourceLocationE", "clang::DocumentXML::addLocation(clang::SourceLocation const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML16addLocationRangeERKNS_11SourceRangeE", "clang::DocumentXML::addLocationRange(clang::SourceRange const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML9PrintDeclEPNS_4DeclE", "clang::DocumentXML::PrintDecl(clang::Decl*)"),
	mu_demangle_test("_ZN5clang11DocumentXML12addAttributeISsEEvPKcRKT_", "void clang::DocumentXML::addAttribute<std::string>(char const*, std::string const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML15addPtrAttributeEPKcS2_", "clang::DocumentXML::addPtrAttribute(char const*, char const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML12addAttributeIjEEvPKcRKT_", "void clang::DocumentXML::addAttribute<unsigned int>(char const*, unsigned int const&)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang9LabelStmtEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::LabelStmt const*, unsigned int, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::LabelStmt const* const&, unsigned int const&, std::pair<clang::LabelStmt const*, unsigned int>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang9LabelStmtEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::LabelStmt const*, unsigned int, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang9LabelStmtEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::LabelStmt const*, unsigned int, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::LabelStmt const*, unsigned int> const&)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang11DeclContextEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::DeclContext const*, unsigned int, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::DeclContext const*, unsigned int> const&)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang11DeclContextEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::DeclContext const*, unsigned int, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::DeclContext const* const&, unsigned int const&, std::pair<clang::DeclContext const*, unsigned int>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang11DeclContextEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::DeclContext const*, unsigned int, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang9NamedDeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::NamedDecl const*, unsigned int, llvm::DenseMapInfo<clang::NamedDecl const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::NamedDecl const*, unsigned int> const&)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang4TypeEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::Type const*, unsigned int, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::Type const*, unsigned int> const&)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang4TypeEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::Type const*, unsigned int, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::Type const* const&, unsigned int const&, std::pair<clang::Type const*, unsigned int>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIPKN5clang4TypeEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::Type const*, unsigned int, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"),
	mu_demangle_test("_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_jESt10_Select1stIS4_ENS0_16QualTypeOrderingESaIS4_EE16_M_insert_uniqueERKS4_", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, unsigned int>, std::_Select1st<std::pair<clang::QualType const, unsigned int> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, unsigned int> > >::_M_insert_unique(std::pair<clang::QualType const, unsigned int> const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_jESt10_Select1stIS4_ENS0_16QualTypeOrderingESaIS4_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS4_ERKS4_", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, unsigned int>, std::_Select1st<std::pair<clang::QualType const, unsigned int> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, unsigned int> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::QualType const, unsigned int> >, std::pair<clang::QualType const, unsigned int> const&)"),
	mu_demangle_test("_ZN5clang14FrontendActionC1Ev", "clang::FrontendAction::FrontendAction()"),
	mu_demangle_test("_ZN5clang14FrontendActionC2Ev", "clang::FrontendAction::FrontendAction()"),
	mu_demangle_test("_ZN5clang14FrontendActionD0Ev", "clang::FrontendAction::~FrontendAction()"),
	mu_demangle_test("_ZN5clang14FrontendActionD1Ev", "clang::FrontendAction::~FrontendAction()"),
	mu_demangle_test("_ZN5clang14FrontendActionD2Ev", "clang::FrontendAction::~FrontendAction()"),
	mu_demangle_test("_ZN5clang14FrontendAction14setCurrentFileEN4llvm9StringRefENS_9InputKindEPNS_7ASTUnitE", "clang::FrontendAction::setCurrentFile(llvm::StringRef, clang::InputKind, clang::ASTUnit*)"),
	mu_demangle_test("_ZN5clang14FrontendAction24CreateWrappedASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::FrontendAction::CreateWrappedASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang14FrontendAction15BeginSourceFileERNS_16CompilerInstanceEN4llvm9StringRefENS_9InputKindE", "clang::FrontendAction::BeginSourceFile(clang::CompilerInstance&, llvm::StringRef, clang::InputKind)"),
	mu_demangle_test("_ZN5clang14FrontendAction7ExecuteEv", "clang::FrontendAction::Execute()"),
	mu_demangle_test("_ZN5clang14FrontendAction13EndSourceFileEv", "clang::FrontendAction::EndSourceFile()"),
	mu_demangle_test("_ZN5clang17ASTFrontendAction13ExecuteActionEv", "clang::ASTFrontendAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang26PreprocessorFrontendAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::PreprocessorFrontendAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124DeserializedDeclsCheckerD1Ev", "(anonymous namespace)::DeserializedDeclsChecker::~DeserializedDeclsChecker()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124DeserializedDeclsCheckerD0Ev", "(anonymous namespace)::DeserializedDeclsChecker::~DeserializedDeclsChecker()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124DeserializedDeclsChecker8DeclReadEjPKN5clang4DeclE", "(anonymous namespace)::DeserializedDeclsChecker::DeclRead(unsigned int, clang::Decl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_123DeserializedDeclsDumperD1Ev", "(anonymous namespace)::DeserializedDeclsDumper::~DeserializedDeclsDumper()"),
	mu_demangle_test("_ZN12_GLOBAL__N_123DeserializedDeclsDumperD0Ev", "(anonymous namespace)::DeserializedDeclsDumper::~DeserializedDeclsDumper()"),
	mu_demangle_test("_ZN12_GLOBAL__N_123DeserializedDeclsDumper8DeclReadEjPKN5clang4DeclE", "(anonymous namespace)::DeserializedDeclsDumper::DeclRead(unsigned int, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListener17ReaderInitializedEPNS_9ASTReaderE", "clang::ASTDeserializationListener::ReaderInitialized(clang::ASTReader*)"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListener14IdentifierReadEjPNS_14IdentifierInfoE", "clang::ASTDeserializationListener::IdentifierRead(unsigned int, clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListener8TypeReadENS_13serialization7TypeIdxENS_8QualTypeE", "clang::ASTDeserializationListener::TypeRead(clang::serialization::TypeIdx, clang::QualType)"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListener12SelectorReadEjNS_8SelectorE", "clang::ASTDeserializationListener::SelectorRead(unsigned int, clang::Selector)"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListener19MacroDefinitionReadEjPNS_15MacroDefinitionE", "clang::ASTDeserializationListener::MacroDefinitionRead(unsigned int, clang::MacroDefinition*)"),
	mu_demangle_test("_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE4findERKSs", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::find(std::string const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE7_M_copyEPKSt13_Rb_tree_nodeISsEPS7_", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_copy(std::_Rb_tree_node<std::string> const*, std::_Rb_tree_node<std::string>*)"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListener8DeclReadEjPKNS_4DeclE", "clang::ASTDeserializationListener::DeclRead(unsigned int, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang14InitOnlyAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::InitOnlyAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang14InitOnlyAction13ExecuteActionEv", "clang::InitOnlyAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang14ASTPrintAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTPrintAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang17ASTPrintXMLAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTPrintXMLAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang13ASTDumpAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTDumpAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang16ASTDumpXMLAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTDumpXMLAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang13ASTViewAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTViewAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang22DeclContextPrintAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::DeclContextPrintAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang17GeneratePCHAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::GeneratePCHAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang17GeneratePCHAction27ComputeASTConsumerArgumentsERNS_16CompilerInstanceEN4llvm9StringRefERSsRPNS3_11raw_ostreamERb", "clang::GeneratePCHAction::ComputeASTConsumerArguments(clang::CompilerInstance&, llvm::StringRef, std::string&, llvm::raw_ostream*&, bool&)"),
	mu_demangle_test("_ZN5clang21InheritanceViewAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::InheritanceViewAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang16SyntaxOnlyAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::SyntaxOnlyAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang19DumpRawTokensAction13ExecuteActionEv", "clang::DumpRawTokensAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang16DumpTokensAction13ExecuteActionEv", "clang::DumpTokensAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang17GeneratePTHAction13ExecuteActionEv", "clang::GeneratePTHAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang20PreprocessOnlyAction13ExecuteActionEv", "clang::PreprocessOnlyAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang23PrintPreprocessedAction13ExecuteActionEv", "clang::PrintPreprocessedAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang19PrintPreambleAction13ExecuteActionEv", "clang::PrintPreambleAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang5LexerD1Ev", "clang::Lexer::~Lexer()"),
	mu_demangle_test("_ZN5clang12Preprocessor3LexERNS_5TokenE", "clang::Preprocessor::Lex(clang::Token&)"),
	mu_demangle_test("_ZN5clang14InitOnlyActionD1Ev", "clang::InitOnlyAction::~InitOnlyAction()"),
	mu_demangle_test("_ZN5clang14InitOnlyActionD0Ev", "clang::InitOnlyAction::~InitOnlyAction()"),
	mu_demangle_test("_ZN5clang14ASTPrintActionD1Ev", "clang::ASTPrintAction::~ASTPrintAction()"),
	mu_demangle_test("_ZN5clang14ASTPrintActionD0Ev", "clang::ASTPrintAction::~ASTPrintAction()"),
	mu_demangle_test("_ZN5clang17ASTPrintXMLActionD1Ev", "clang::ASTPrintXMLAction::~ASTPrintXMLAction()"),
	mu_demangle_test("_ZN5clang17ASTPrintXMLActionD0Ev", "clang::ASTPrintXMLAction::~ASTPrintXMLAction()"),
	mu_demangle_test("_ZN5clang13ASTDumpActionD1Ev", "clang::ASTDumpAction::~ASTDumpAction()"),
	mu_demangle_test("_ZN5clang13ASTDumpActionD0Ev", "clang::ASTDumpAction::~ASTDumpAction()"),
	mu_demangle_test("_ZN5clang16ASTDumpXMLActionD1Ev", "clang::ASTDumpXMLAction::~ASTDumpXMLAction()"),
	mu_demangle_test("_ZN5clang16ASTDumpXMLActionD0Ev", "clang::ASTDumpXMLAction::~ASTDumpXMLAction()"),
	mu_demangle_test("_ZN5clang13ASTViewActionD1Ev", "clang::ASTViewAction::~ASTViewAction()"),
	mu_demangle_test("_ZN5clang13ASTViewActionD0Ev", "clang::ASTViewAction::~ASTViewAction()"),
	mu_demangle_test("_ZN5clang22DeclContextPrintActionD1Ev", "clang::DeclContextPrintAction::~DeclContextPrintAction()"),
	mu_demangle_test("_ZN5clang22DeclContextPrintActionD0Ev", "clang::DeclContextPrintAction::~DeclContextPrintAction()"),
	mu_demangle_test("_ZN5clang17GeneratePCHActionD1Ev", "clang::GeneratePCHAction::~GeneratePCHAction()"),
	mu_demangle_test("_ZN5clang17GeneratePCHActionD0Ev", "clang::GeneratePCHAction::~GeneratePCHAction()"),
	mu_demangle_test("_ZN5clang21InheritanceViewActionD1Ev", "clang::InheritanceViewAction::~InheritanceViewAction()"),
	mu_demangle_test("_ZN5clang21InheritanceViewActionD0Ev", "clang::InheritanceViewAction::~InheritanceViewAction()"),
	mu_demangle_test("_ZN5clang19PrintPreambleActionD1Ev", "clang::PrintPreambleAction::~PrintPreambleAction()"),
	mu_demangle_test("_ZN5clang19PrintPreambleActionD0Ev", "clang::PrintPreambleAction::~PrintPreambleAction()"),
	mu_demangle_test("_ZN5clang19DumpRawTokensActionD1Ev", "clang::DumpRawTokensAction::~DumpRawTokensAction()"),
	mu_demangle_test("_ZN5clang19DumpRawTokensActionD0Ev", "clang::DumpRawTokensAction::~DumpRawTokensAction()"),
	mu_demangle_test("_ZN5clang16DumpTokensActionD1Ev", "clang::DumpTokensAction::~DumpTokensAction()"),
	mu_demangle_test("_ZN5clang16DumpTokensActionD0Ev", "clang::DumpTokensAction::~DumpTokensAction()"),
	mu_demangle_test("_ZN5clang17GeneratePTHActionD1Ev", "clang::GeneratePTHAction::~GeneratePTHAction()"),
	mu_demangle_test("_ZN5clang17GeneratePTHActionD0Ev", "clang::GeneratePTHAction::~GeneratePTHAction()"),
	mu_demangle_test("_ZN5clang20PreprocessOnlyActionD1Ev", "clang::PreprocessOnlyAction::~PreprocessOnlyAction()"),
	mu_demangle_test("_ZN5clang20PreprocessOnlyActionD0Ev", "clang::PreprocessOnlyAction::~PreprocessOnlyAction()"),
	mu_demangle_test("_ZN5clang23PrintPreprocessedActionD1Ev", "clang::PrintPreprocessedAction::~PrintPreprocessedAction()"),
	mu_demangle_test("_ZN5clang23PrintPreprocessedActionD0Ev", "clang::PrintPreprocessedAction::~PrintPreprocessedAction()"),
	mu_demangle_test("_ZN5clang5LexerD0Ev", "clang::Lexer::~Lexer()"),
	mu_demangle_test("_ZN5clang5Lexer11IndirectLexERNS_5TokenE", "clang::Lexer::IndirectLex(clang::Token&)"),
	mu_demangle_test("_ZN5clang5Lexer17getSourceLocationEv", "clang::Lexer::getSourceLocation()"),
	mu_demangle_test("_ZN5clang17PreprocessorLexerD1Ev", "clang::PreprocessorLexer::~PreprocessorLexer()"),
	mu_demangle_test("_ZN5clang17PreprocessorLexerD0Ev", "clang::PreprocessorLexer::~PreprocessorLexer()"),
	mu_demangle_test("_ZN5clang11ASTConsumerD1Ev", "clang::ASTConsumer::~ASTConsumer()"),
	mu_demangle_test("_ZN5clang11ASTConsumerD0Ev", "clang::ASTConsumer::~ASTConsumer()"),
	mu_demangle_test("_ZN5clang11ASTConsumer10InitializeERNS_10ASTContextE", "clang::ASTConsumer::Initialize(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang11ASTConsumer21HandleTranslationUnitERNS_10ASTContextE", "clang::ASTConsumer::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang11ASTConsumer23HandleTagDeclDefinitionEPNS_7TagDeclE", "clang::ASTConsumer::HandleTagDeclDefinition(clang::TagDecl*)"),
	mu_demangle_test("_ZN5clang11ASTConsumer27CompleteTentativeDefinitionEPNS_7VarDeclE", "clang::ASTConsumer::CompleteTentativeDefinition(clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang11ASTConsumer12HandleVTableEPNS_13CXXRecordDeclEb", "clang::ASTConsumer::HandleVTable(clang::CXXRecordDecl*, bool)"),
	mu_demangle_test("_ZN5clang11ASTConsumer22GetASTMutationListenerEv", "clang::ASTConsumer::GetASTMutationListener()"),
	mu_demangle_test("_ZN5clang11ASTConsumer29GetASTDeserializationListenerEv", "clang::ASTConsumer::GetASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang11ASTConsumer10PrintStatsEv", "clang::ASTConsumer::PrintStats()"),
	mu_demangle_test("_ZN5clang15FrontendOptions24getInputKindForExtensionEN4llvm9StringRefE", "clang::FrontendOptions::getInputKindForExtension(llvm::StringRef)"),
	mu_demangle_test("_ZN4llvm12StringSwitchIN5clang9InputKindES2_E5CasesILj4ELj4ELj4ELj4ELj4EEERS3_RAT__KcRAT0__S6_RAT1__S6_RAT2__S6_RAT3__S6_RKS2_", "llvm::StringSwitch<clang::InputKind, clang::InputKind>& llvm::StringSwitch<clang::InputKind, clang::InputKind>::Cases<4u, 4u, 4u, 4u, 4u>(char const (&) [4u], char const (&) [4u], char const (&) [4u], char const (&) [4u], char const (&) [4u], clang::InputKind const&)"),
	mu_demangle_test("_ZN5clang22AttachHeaderIncludeGenERNS_12PreprocessorEbN4llvm9StringRefE", "clang::AttachHeaderIncludeGen(clang::Preprocessor&, bool, llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122HeaderIncludesCallbackD1Ev", "(anonymous namespace)::HeaderIncludesCallback::~HeaderIncludesCallback()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122HeaderIncludesCallbackD0Ev", "(anonymous namespace)::HeaderIncludesCallback::~HeaderIncludesCallback()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122HeaderIncludesCallback11FileChangedEN5clang14SourceLocationENS1_11PPCallbacks16FileChangeReasonENS1_6SrcMgr18CharacteristicKindE", "(anonymous namespace)::HeaderIncludesCallback::FileChanged(clang::SourceLocation, clang::PPCallbacks::FileChangeReason, clang::SrcMgr::CharacteristicKind)"),
	mu_demangle_test("_ZN5clang24ApplyHeaderSearchOptionsERNS_12HeaderSearchERKNS_19HeaderSearchOptionsERKNS_11LangOptionsERKN4llvm6TripleE", "clang::ApplyHeaderSearchOptions(clang::HeaderSearch&, clang::HeaderSearchOptions const&, clang::LangOptions const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116InitHeaderSearch7AddPathERKN4llvm5TwineEN5clang8frontend15IncludeDirGroupEbbbb", "(anonymous namespace)::InitHeaderSearch::AddPath(llvm::Twine const&, clang::frontend::IncludeDirGroup, bool, bool, bool, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116InitHeaderSearch17AddDelimitedPathsEN4llvm9StringRefE", "(anonymous namespace)::InitHeaderSearch::AddDelimitedPaths(llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116InitHeaderSearch27AddGnuCPlusPlusIncludePathsEN4llvm9StringRefES2_S2_S2_RKNS1_6TripleE", "(anonymous namespace)::InitHeaderSearch::AddGnuCPlusPlusIncludePaths(llvm::StringRef, llvm::StringRef, llvm::StringRef, llvm::StringRef, llvm::Triple const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116InitHeaderSearch29AddMinGWCPlusPlusIncludePathsEN4llvm9StringRefES2_S2_", "(anonymous namespace)::InitHeaderSearch::AddMinGWCPlusPlusIncludePaths(llvm::StringRef, llvm::StringRef, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang24NormalizeDashIncludePathEN4llvm9StringRefE", "clang::NormalizeDashIncludePath(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang22InitializePreprocessorERNS_12PreprocessorERKNS_19PreprocessorOptionsERKNS_19HeaderSearchOptionsERKNS_15FrontendOptionsE", "clang::InitializePreprocessor(clang::Preprocessor&, clang::PreprocessorOptions const&, clang::HeaderSearchOptions const&, clang::FrontendOptions const&)"),
	mu_demangle_test("_Z18AddImplicitIncludeRN5clang12MacroBuilderEN4llvm9StringRefE", "AddImplicitInclude(clang::MacroBuilder&, llvm::StringRef)"),
	mu_demangle_test("_Z17DefineFloatMacrosRN5clang12MacroBuilderEN4llvm9StringRefEPKNS2_12fltSemanticsE", "DefineFloatMacros(clang::MacroBuilder&, llvm::StringRef, llvm::fltSemantics const*)"),
	mu_demangle_test("_Z23DefineExactWidthIntTypeN5clang10TargetInfo7IntTypeERKS0_RNS_12MacroBuilderE", "DefineExactWidthIntType(clang::TargetInfo::IntType, clang::TargetInfo const&, clang::MacroBuilder&)"),
	mu_demangle_test("_ZN5clang12LangStandard22getLangStandardForKindENS0_4KindE", "clang::LangStandard::getLangStandardForKind(clang::LangStandard::Kind)"),
	mu_demangle_test("_ZN5clang12LangStandard22getLangStandardForNameEN4llvm9StringRefE", "clang::LangStandard::getLangStandardForName(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListener17ReaderInitializedEPNS_9ASTReaderE", "clang::MultiplexASTDeserializationListener::ReaderInitialized(clang::ASTReader*)"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListener14IdentifierReadEjPNS_14IdentifierInfoE", "clang::MultiplexASTDeserializationListener::IdentifierRead(unsigned int, clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListener8TypeReadENS_13serialization7TypeIdxENS_8QualTypeE", "clang::MultiplexASTDeserializationListener::TypeRead(clang::serialization::TypeIdx, clang::QualType)"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListener8DeclReadEjPKNS_4DeclE", "clang::MultiplexASTDeserializationListener::DeclRead(unsigned int, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListener12SelectorReadEjNS_8SelectorE", "clang::MultiplexASTDeserializationListener::SelectorRead(unsigned int, clang::Selector)"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListener19MacroDefinitionReadEjPNS_15MacroDefinitionE", "clang::MultiplexASTDeserializationListener::MacroDefinitionRead(unsigned int, clang::MacroDefinition*)"),
	mu_demangle_test("_ZN5clang28MultiplexASTMutationListener22CompletedTagDefinitionEPKNS_7TagDeclE", "clang::MultiplexASTMutationListener::CompletedTagDefinition(clang::TagDecl const*)"),
	mu_demangle_test("_ZN5clang28MultiplexASTMutationListener16AddedVisibleDeclEPKNS_11DeclContextEPKNS_4DeclE", "clang::MultiplexASTMutationListener::AddedVisibleDecl(clang::DeclContext const*, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang28MultiplexASTMutationListener22AddedCXXImplicitMemberEPKNS_13CXXRecordDeclEPKNS_4DeclE", "clang::MultiplexASTMutationListener::AddedCXXImplicitMember(clang::CXXRecordDecl const*, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang28MultiplexASTMutationListener30AddedCXXTemplateSpecializationEPKNS_17ClassTemplateDeclEPKNS_31ClassTemplateSpecializationDeclE", "clang::MultiplexASTMutationListener::AddedCXXTemplateSpecialization(clang::ClassTemplateDecl const*, clang::ClassTemplateSpecializationDecl const*)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumerD0Ev", "clang::MultiplexConsumer::~MultiplexConsumer()"),
	mu_demangle_test("_ZN5clang17MultiplexConsumerD1Ev", "clang::MultiplexConsumer::~MultiplexConsumer()"),
	mu_demangle_test("_ZN5clang17MultiplexConsumerD2Ev", "clang::MultiplexConsumer::~MultiplexConsumer()"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer10InitializeERNS_10ASTContextE", "clang::MultiplexConsumer::Initialize(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer18HandleTopLevelDeclENS_12DeclGroupRefE", "clang::MultiplexConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer21HandleInterestingDeclENS_12DeclGroupRefE", "clang::MultiplexConsumer::HandleInterestingDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer21HandleTranslationUnitERNS_10ASTContextE", "clang::MultiplexConsumer::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer23HandleTagDeclDefinitionEPNS_7TagDeclE", "clang::MultiplexConsumer::HandleTagDeclDefinition(clang::TagDecl*)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer27CompleteTentativeDefinitionEPNS_7VarDeclE", "clang::MultiplexConsumer::CompleteTentativeDefinition(clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer12HandleVTableEPNS_13CXXRecordDeclEb", "clang::MultiplexConsumer::HandleVTable(clang::CXXRecordDecl*, bool)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer22GetASTMutationListenerEv", "clang::MultiplexConsumer::GetASTMutationListener()"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer29GetASTDeserializationListenerEv", "clang::MultiplexConsumer::GetASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer10PrintStatsEv", "clang::MultiplexConsumer::PrintStats()"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer14InitializeSemaERNS_4SemaE", "clang::MultiplexConsumer::InitializeSema(clang::Sema&)"),
	mu_demangle_test("_ZN5clang17MultiplexConsumer10ForgetSemaEv", "clang::MultiplexConsumer::ForgetSema()"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListenerD1Ev", "clang::MultiplexASTDeserializationListener::~MultiplexASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang35MultiplexASTDeserializationListenerD0Ev", "clang::MultiplexASTDeserializationListener::~MultiplexASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang28MultiplexASTMutationListenerD1Ev", "clang::MultiplexASTMutationListener::~MultiplexASTMutationListener()"),
	mu_demangle_test("_ZN5clang28MultiplexASTMutationListenerD0Ev", "clang::MultiplexASTMutationListener::~MultiplexASTMutationListener()"),
	mu_demangle_test("_ZN5clang12SemaConsumerD1Ev", "clang::SemaConsumer::~SemaConsumer()"),
	mu_demangle_test("_ZN5clang12SemaConsumerD0Ev", "clang::SemaConsumer::~SemaConsumer()"),
	mu_demangle_test("_ZN5clang12SemaConsumer14InitializeSemaERNS_4SemaE", "clang::SemaConsumer::InitializeSema(clang::Sema&)"),
	mu_demangle_test("_ZN5clang12SemaConsumer10ForgetSemaEv", "clang::SemaConsumer::ForgetSema()"),
	mu_demangle_test("_ZN5clang24DoPrintPreprocessedInputERNS_12PreprocessorEPN4llvm11raw_ostreamERKNS_25PreprocessorOutputOptionsE", "clang::DoPrintPreprocessedInput(clang::Preprocessor&, llvm::raw_ostream*, clang::PreprocessorOutputOptions const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks10MoveToLineEj", "(anonymous namespace)::PrintPPOutputPPCallbacks::MoveToLine(unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks13WriteLineInfoEjPKcj", "(anonymous namespace)::PrintPPOutputPPCallbacks::WriteLineInfo(unsigned int, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_120UnknownPragmaHandlerD1Ev", "(anonymous namespace)::UnknownPragmaHandler::~UnknownPragmaHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_120UnknownPragmaHandlerD0Ev", "(anonymous namespace)::UnknownPragmaHandler::~UnknownPragmaHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_120UnknownPragmaHandler12HandlePragmaERN5clang12PreprocessorENS1_20PragmaIntroducerKindERNS1_5TokenE", "(anonymous namespace)::UnknownPragmaHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacksD1Ev", "(anonymous namespace)::PrintPPOutputPPCallbacks::~PrintPPOutputPPCallbacks()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacksD0Ev", "(anonymous namespace)::PrintPPOutputPPCallbacks::~PrintPPOutputPPCallbacks()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks11FileChangedEN5clang14SourceLocationENS1_11PPCallbacks16FileChangeReasonENS1_6SrcMgr18CharacteristicKindE", "(anonymous namespace)::PrintPPOutputPPCallbacks::FileChanged(clang::SourceLocation, clang::PPCallbacks::FileChangeReason, clang::SrcMgr::CharacteristicKind)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks5IdentEN5clang14SourceLocationERKSs", "(anonymous namespace)::PrintPPOutputPPCallbacks::Ident(clang::SourceLocation, std::string const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks13PragmaCommentEN5clang14SourceLocationEPKNS1_14IdentifierInfoERKSs", "(anonymous namespace)::PrintPPOutputPPCallbacks::PragmaComment(clang::SourceLocation, clang::IdentifierInfo const*, std::string const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks13PragmaMessageEN5clang14SourceLocationEN4llvm9StringRefE", "(anonymous namespace)::PrintPPOutputPPCallbacks::PragmaMessage(clang::SourceLocation, llvm::StringRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks12MacroDefinedERKN5clang5TokenEPKNS1_9MacroInfoE", "(anonymous namespace)::PrintPPOutputPPCallbacks::MacroDefined(clang::Token const&, clang::MacroInfo const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks14MacroUndefinedERKN5clang5TokenEPKNS1_9MacroInfoE", "(anonymous namespace)::PrintPPOutputPPCallbacks::MacroUndefined(clang::Token const&, clang::MacroInfo const*)"),
	mu_demangle_test("_Z20PrintMacroDefinitionRKN5clang14IdentifierInfoERKNS_9MacroInfoERNS_12PreprocessorERN4llvm11raw_ostreamE", "PrintMacroDefinition(clang::IdentifierInfo const&, clang::MacroInfo const&, clang::Preprocessor&, llvm::raw_ostream&)"),
	mu_demangle_test("_Z14MacroIDComparePKvS0_", "MacroIDCompare(void const*, void const*)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplISt4pairIPN5clang14IdentifierInfoEPNS2_9MacroInfoEEE6appendINS_16DenseMapIteratorIS4_S6_NS_12DenseMapInfoIS4_EENSB_IS6_EELb1EEEEEvT_SF_", "void llvm::SmallVectorImpl<std::pair<clang::IdentifierInfo*, clang::MacroInfo*> >::append<llvm::DenseMapIterator<clang::IdentifierInfo*, clang::MacroInfo*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::MacroInfo*>, true> >(llvm::DenseMapIterator<clang::IdentifierInfo*, clang::MacroInfo*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::MacroInfo*>, true>, llvm::DenseMapIterator<clang::IdentifierInfo*, clang::MacroInfo*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::MacroInfo*>, true>)"),
	mu_demangle_test("_ZN5clang11DocumentXML9PrintStmtEPKNS_4StmtE", "clang::DocumentXML::PrintStmt(clang::Stmt const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_17StmtXML11DumpSubTreeEPN5clang4StmtE", "(anonymous namespace)::StmtXML::DumpSubTree(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang11StmtVisitorIN12_GLOBAL__N_17StmtXMLEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::StmtXML, void>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_17StmtXML19VisitBinaryOperatorEPN5clang14BinaryOperatorE", "(anonymous namespace)::StmtXML::VisitBinaryOperator(clang::BinaryOperator*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_17StmtXML21VisitCXXConstructExprEPN5clang16CXXConstructExprE", "(anonymous namespace)::StmtXML::VisitCXXConstructExpr(clang::CXXConstructExpr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_17StmtXML13VisitCallExprEPN5clang8CallExprE", "(anonymous namespace)::StmtXML::VisitCallExpr(clang::CallExpr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_17StmtXML18VisitUnaryOperatorEPN5clang13UnaryOperatorE", "(anonymous namespace)::StmtXML::VisitUnaryOperator(clang::UnaryOperator*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_17StmtXML9VisitStmtEPN5clang4StmtE", "(anonymous namespace)::StmtXML::VisitStmt(clang::Stmt*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_17StmtXML21VisitCXXNamedCastExprEPN5clang16CXXNamedCastExprE", "(anonymous namespace)::StmtXML::VisitCXXNamedCastExpr(clang::CXXNamedCastExpr*)"),
	mu_demangle_test("_ZN5clang20TextDiagnosticBuffer16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::TextDiagnosticBuffer::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"),
	mu_demangle_test("_ZNK5clang20TextDiagnosticBuffer16FlushDiagnosticsERNS_10DiagnosticE", "clang::TextDiagnosticBuffer::FlushDiagnostics(clang::Diagnostic&) const"),
	mu_demangle_test("_ZN5clang20TextDiagnosticBufferD1Ev", "clang::TextDiagnosticBuffer::~TextDiagnosticBuffer()"),
	mu_demangle_test("_ZN5clang20TextDiagnosticBufferD0Ev", "clang::TextDiagnosticBuffer::~TextDiagnosticBuffer()"),
	mu_demangle_test("_ZN5clang20TextDiagnosticBufferD2Ev", "clang::TextDiagnosticBuffer::~TextDiagnosticBuffer()"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinterC1ERN4llvm11raw_ostreamERKNS_17DiagnosticOptionsEb", "clang::TextDiagnosticPrinter::TextDiagnosticPrinter(llvm::raw_ostream&, clang::DiagnosticOptions const&, bool)"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinterC2ERN4llvm11raw_ostreamERKNS_17DiagnosticOptionsEb", "clang::TextDiagnosticPrinter::TextDiagnosticPrinter(llvm::raw_ostream&, clang::DiagnosticOptions const&, bool)"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinterD0Ev", "clang::TextDiagnosticPrinter::~TextDiagnosticPrinter()"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinterD1Ev", "clang::TextDiagnosticPrinter::~TextDiagnosticPrinter()"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinterD2Ev", "clang::TextDiagnosticPrinter::~TextDiagnosticPrinter()"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinter17PrintIncludeStackENS_14SourceLocationERKNS_13SourceManagerE", "clang::TextDiagnosticPrinter::PrintIncludeStack(clang::SourceLocation, clang::SourceManager const&)"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinter14HighlightRangeERKNS_15CharSourceRangeERKNS_13SourceManagerEjNS_6FileIDERSsRKSs", "clang::TextDiagnosticPrinter::HighlightRange(clang::CharSourceRange const&, clang::SourceManager const&, unsigned int, clang::FileID, std::string&, std::string const&)"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinter19EmitCaretDiagnosticENS_14SourceLocationEPNS_15CharSourceRangeEjRKNS_13SourceManagerEPKNS_9FixItHintEjjjjj", "clang::TextDiagnosticPrinter::EmitCaretDiagnostic(clang::SourceLocation, clang::CharSourceRange*, unsigned int, clang::SourceManager const&, clang::FixItHint const*, unsigned int, unsigned int, unsigned int, unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinter16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::TextDiagnosticPrinter::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"),
	mu_demangle_test("_Z13findEndOfWordjRKN4llvm15SmallVectorImplIcEEjjj", "findEndOfWord(unsigned int, llvm::SmallVectorImpl<char> const&, unsigned int, unsigned int, unsigned int)"),
	mu_demangle_test("_ZNK5clang13SourceManager16getDecomposedLocENS_14SourceLocationE", "clang::SourceManager::getDecomposedLoc(clang::SourceLocation) const"),
	mu_demangle_test("_ZNK5clang13SourceManager29getDecomposedInstantiationLocENS_14SourceLocationE", "clang::SourceManager::getDecomposedInstantiationLoc(clang::SourceLocation) const"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinter15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::TextDiagnosticPrinter::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"),
	mu_demangle_test("_ZN5clang21TextDiagnosticPrinter13EndSourceFileEv", "clang::TextDiagnosticPrinter::EndSourceFile()"),
	mu_demangle_test("_ZNK5clang13SourceManager16isOffsetInFileIDENS_6FileIDEj", "clang::SourceManager::isOffsetInFileID(clang::FileID, unsigned int) const"),
	mu_demangle_test("_ZN5clang11DocumentXML14addParentTypesEPKNS_4TypeE", "clang::DocumentXML::addParentTypes(clang::Type const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML14writeTypeToXMLEPKNS_4TypeE", "clang::DocumentXML::writeTypeToXML(clang::Type const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML14writeTypeToXMLERKNS_8QualTypeE", "clang::DocumentXML::writeTypeToXML(clang::QualType const&)"),
	mu_demangle_test("_ZN5clang3XML12_GLOBAL__N_110TypeWriter9VisitTypeEPKNS_4TypeE", "clang::XML::(anonymous namespace)::TypeWriter::VisitType(clang::Type const*)"),
	mu_demangle_test("_ZN5clang11TypeVisitorINS_11DocumentXML9TypeAdderEvE5VisitEPKNS_4TypeE", "clang::TypeVisitor<clang::DocumentXML::TypeAdder, void>::Visit(clang::Type const*)"),
	mu_demangle_test("_ZN5clang11DocumentXML12addAttributeIN4llvm5APIntEEEvPKcRKT_", "void clang::DocumentXML::addAttribute<llvm::APInt>(char const*, llvm::APInt const&)"),
	mu_demangle_test("_ZN5clang11DocumentXML12addAttributeINS_10Qualifiers2GCEEEvPKcRKT_", "void clang::DocumentXML::addAttribute<clang::Qualifiers::GC>(char const*, clang::Qualifiers::GC const&)"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClientC1ERNS_10DiagnosticEPNS_16DiagnosticClientE", "clang::VerifyDiagnosticsClient::VerifyDiagnosticsClient(clang::Diagnostic&, clang::DiagnosticClient*)"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClientC2ERNS_10DiagnosticEPNS_16DiagnosticClientE", "clang::VerifyDiagnosticsClient::VerifyDiagnosticsClient(clang::Diagnostic&, clang::DiagnosticClient*)"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClientD0Ev", "clang::VerifyDiagnosticsClient::~VerifyDiagnosticsClient()"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClientD1Ev", "clang::VerifyDiagnosticsClient::~VerifyDiagnosticsClient()"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClientD2Ev", "clang::VerifyDiagnosticsClient::~VerifyDiagnosticsClient()"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClient16CheckDiagnosticsEv", "clang::VerifyDiagnosticsClient::CheckDiagnostics()"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClient15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::VerifyDiagnosticsClient::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClient13EndSourceFileEv", "clang::VerifyDiagnosticsClient::EndSourceFile()"),
	mu_demangle_test("_ZN5clang23VerifyDiagnosticsClient16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::VerifyDiagnosticsClient::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117StandardDirectiveD1Ev", "(anonymous namespace)::StandardDirective::~StandardDirective()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117StandardDirectiveD0Ev", "(anonymous namespace)::StandardDirective::~StandardDirective()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117StandardDirective7isValidERSs", "(anonymous namespace)::StandardDirective::isValid(std::string&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117StandardDirective5MatchERKSs", "(anonymous namespace)::StandardDirective::Match(std::string const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19DirectiveD1Ev", "(anonymous namespace)::Directive::~Directive()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19DirectiveD0Ev", "(anonymous namespace)::Directive::~Directive()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114RegexDirectiveD1Ev", "(anonymous namespace)::RegexDirective::~RegexDirective()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114RegexDirectiveD0Ev", "(anonymous namespace)::RegexDirective::~RegexDirective()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114RegexDirective7isValidERSs", "(anonymous namespace)::RegexDirective::isValid(std::string&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114RegexDirective5MatchERKSs", "(anonymous namespace)::RegexDirective::Match(std::string const&)"),
	mu_demangle_test("_ZSt6searchIPKcS1_ET_S2_S2_T0_S3_", "char const* std::search<char const*, char const*>(char const*, char const*, char const*, char const*)"),
	mu_demangle_test("_ZN5clang21ProcessWarningOptionsERNS_10DiagnosticERKNS_17DiagnosticOptionsE", "clang::ProcessWarningOptions(clang::Diagnostic&, clang::DiagnosticOptions const&)"),
	mu_demangle_test("_ZN5clang6driver6ActionD0Ev", "clang::driver::Action::~Action()"),
	mu_demangle_test("_ZN5clang6driver6ActionD1Ev", "clang::driver::Action::~Action()"),
	mu_demangle_test("_ZN5clang6driver6ActionD2Ev", "clang::driver::Action::~Action()"),
	mu_demangle_test("_ZN5clang6driver6Action12getClassNameENS1_11ActionClassE", "clang::driver::Action::getClassName(clang::driver::Action::ActionClass)"),
	mu_demangle_test("_ZN5clang6driver11InputActionC1ERKNS0_3ArgENS0_5types2IDE", "clang::driver::InputAction::InputAction(clang::driver::Arg const&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver11InputActionC2ERKNS0_3ArgENS0_5types2IDE", "clang::driver::InputAction::InputAction(clang::driver::Arg const&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver14BindArchActionC1EPNS0_6ActionEPKc", "clang::driver::BindArchAction::BindArchAction(clang::driver::Action*, char const*)"),
	mu_demangle_test("_ZN5clang6driver14BindArchActionC2EPNS0_6ActionEPKc", "clang::driver::BindArchAction::BindArchAction(clang::driver::Action*, char const*)"),
	mu_demangle_test("_ZN5clang6driver9JobActionC1ENS0_6Action11ActionClassEPS2_NS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver9JobActionC2ENS0_6Action11ActionClassEPS2_NS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver9JobActionC1ENS0_6Action11ActionClassERKN4llvm11SmallVectorIPS2_Lj3EEENS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, llvm::SmallVector<clang::driver::Action*, 3u> const&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver9JobActionC2ENS0_6Action11ActionClassERKN4llvm11SmallVectorIPS2_Lj3EEENS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, llvm::SmallVector<clang::driver::Action*, 3u> const&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver19PreprocessJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::PreprocessJobAction::PreprocessJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver19PreprocessJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::PreprocessJobAction::PreprocessJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver19PrecompileJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::PrecompileJobAction::PrecompileJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver19PrecompileJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::PrecompileJobAction::PrecompileJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver16AnalyzeJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::AnalyzeJobAction::AnalyzeJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver16AnalyzeJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::AnalyzeJobAction::AnalyzeJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver16CompileJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::CompileJobAction::CompileJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver16CompileJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::CompileJobAction::CompileJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver17AssembleJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::AssembleJobAction::AssembleJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver17AssembleJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::AssembleJobAction::AssembleJobAction(clang::driver::Action*, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver13LinkJobActionC1ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LinkJobAction::LinkJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver13LinkJobActionC2ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LinkJobAction::LinkJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver13LipoJobActionC1ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LipoJobAction::LipoJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver13LipoJobActionC2ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LipoJobAction::LipoJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver17DsymutilJobActionC1ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::DsymutilJobAction::DsymutilJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver17DsymutilJobActionC2ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::DsymutilJobAction::DsymutilJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver17DsymutilJobActionD1Ev", "clang::driver::DsymutilJobAction::~DsymutilJobAction()"),
	mu_demangle_test("_ZN5clang6driver17DsymutilJobActionD0Ev", "clang::driver::DsymutilJobAction::~DsymutilJobAction()"),
	mu_demangle_test("_ZN5clang6driver13LipoJobActionD1Ev", "clang::driver::LipoJobAction::~LipoJobAction()"),
	mu_demangle_test("_ZN5clang6driver13LipoJobActionD0Ev", "clang::driver::LipoJobAction::~LipoJobAction()"),
	mu_demangle_test("_ZN5clang6driver13LinkJobActionD1Ev", "clang::driver::LinkJobAction::~LinkJobAction()"),
	mu_demangle_test("_ZN5clang6driver13LinkJobActionD0Ev", "clang::driver::LinkJobAction::~LinkJobAction()"),
	mu_demangle_test("_ZN5clang6driver17AssembleJobActionD1Ev", "clang::driver::AssembleJobAction::~AssembleJobAction()"),
	mu_demangle_test("_ZN5clang6driver17AssembleJobActionD0Ev", "clang::driver::AssembleJobAction::~AssembleJobAction()"),
	mu_demangle_test("_ZN5clang6driver16CompileJobActionD1Ev", "clang::driver::CompileJobAction::~CompileJobAction()"),
	mu_demangle_test("_ZN5clang6driver16CompileJobActionD0Ev", "clang::driver::CompileJobAction::~CompileJobAction()"),
	mu_demangle_test("_ZN5clang6driver16AnalyzeJobActionD1Ev", "clang::driver::AnalyzeJobAction::~AnalyzeJobAction()"),
	mu_demangle_test("_ZN5clang6driver16AnalyzeJobActionD0Ev", "clang::driver::AnalyzeJobAction::~AnalyzeJobAction()"),
	mu_demangle_test("_ZN5clang6driver19PrecompileJobActionD1Ev", "clang::driver::PrecompileJobAction::~PrecompileJobAction()"),
	mu_demangle_test("_ZN5clang6driver19PrecompileJobActionD0Ev", "clang::driver::PrecompileJobAction::~PrecompileJobAction()"),
	mu_demangle_test("_ZN5clang6driver19PreprocessJobActionD1Ev", "clang::driver::PreprocessJobAction::~PreprocessJobAction()"),
	mu_demangle_test("_ZN5clang6driver19PreprocessJobActionD0Ev", "clang::driver::PreprocessJobAction::~PreprocessJobAction()"),
	mu_demangle_test("_ZN5clang6driver9JobActionD1Ev", "clang::driver::JobAction::~JobAction()"),
	mu_demangle_test("_ZN5clang6driver9JobActionD0Ev", "clang::driver::JobAction::~JobAction()"),
	mu_demangle_test("_ZN5clang6driver14BindArchActionD1Ev", "clang::driver::BindArchAction::~BindArchAction()"),
	mu_demangle_test("_ZN5clang6driver14BindArchActionD0Ev", "clang::driver::BindArchAction::~BindArchAction()"),
	mu_demangle_test("_ZN5clang6driver11InputActionD1Ev", "clang::driver::InputAction::~InputAction()"),
	mu_demangle_test("_ZN5clang6driver11InputActionD0Ev", "clang::driver::InputAction::~InputAction()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPN5clang6driver6ActionEEaSERKS5_", "llvm::SmallVectorImpl<clang::driver::Action*>::operator=(llvm::SmallVectorImpl<clang::driver::Action*> const&)"),
	mu_demangle_test("_ZN5clang6driver3ArgC1EPKNS0_6OptionEjPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, clang::driver::Arg const*)"),
	mu_demangle_test("_ZN5clang6driver3ArgC2EPKNS0_6OptionEjPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, clang::driver::Arg const*)"),
	mu_demangle_test("_ZN5clang6driver3ArgC1EPKNS0_6OptionEjPKcPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, clang::driver::Arg const*)"),
	mu_demangle_test("_ZN5clang6driver3ArgC2EPKNS0_6OptionEjPKcPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, clang::driver::Arg const*)"),
	mu_demangle_test("_ZN5clang6driver3ArgC1EPKNS0_6OptionEjPKcS6_PKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, char const*, clang::driver::Arg const*)"),
	mu_demangle_test("_ZN5clang6driver3ArgC2EPKNS0_6OptionEjPKcS6_PKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, char const*, clang::driver::Arg const*)"),
	mu_demangle_test("_ZN5clang6driver3ArgD1Ev", "clang::driver::Arg::~Arg()"),
	mu_demangle_test("_ZN5clang6driver3ArgD2Ev", "clang::driver::Arg::~Arg()"),
	mu_demangle_test("_ZNK5clang6driver3Arg4dumpEv", "clang::driver::Arg::dump() const"),
	mu_demangle_test("_ZNK5clang6driver3Arg11getAsStringERKNS0_7ArgListE", "clang::driver::Arg::getAsString(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZNK5clang6driver3Arg6renderERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::Arg::render(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver3Arg13renderAsInputERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::Arg::renderAsInput(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZN5clang6driver12arg_iterator13SkipToNextArgEv", "clang::driver::arg_iterator::SkipToNextArg()"),
	mu_demangle_test("_ZN5clang6driver7ArgListC1Ev", "clang::driver::ArgList::ArgList()"),
	mu_demangle_test("_ZN5clang6driver7ArgListC2Ev", "clang::driver::ArgList::ArgList()"),
	mu_demangle_test("_ZN5clang6driver7ArgListD0Ev", "clang::driver::ArgList::~ArgList()"),
	mu_demangle_test("_ZN5clang6driver7ArgListD1Ev", "clang::driver::ArgList::~ArgList()"),
	mu_demangle_test("_ZN5clang6driver7ArgListD2Ev", "clang::driver::ArgList::~ArgList()"),
	mu_demangle_test("_ZN5clang6driver7ArgList6appendEPNS0_3ArgE", "clang::driver::ArgList::append(clang::driver::Arg*)"),
	mu_demangle_test("_ZNK5clang6driver7ArgList17getLastArgNoClaimENS0_12OptSpecifierE", "clang::driver::ArgList::getLastArgNoClaim(clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierE", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierES2_", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierES2_S2_", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierES2_S2_S2_", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList7hasFlagENS0_12OptSpecifierES2_b", "clang::driver::ArgList::hasFlag(clang::driver::OptSpecifier, clang::driver::OptSpecifier, bool) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList15getLastArgValueENS0_12OptSpecifierEN4llvm9StringRefE", "clang::driver::ArgList::getLastArgValue(clang::driver::OptSpecifier, llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList18getLastArgIntValueENS0_12OptSpecifierEiRNS_10DiagnosticE", "clang::driver::ArgList::getLastArgIntValue(clang::driver::OptSpecifier, int, clang::Diagnostic&) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList15getAllArgValuesENS0_12OptSpecifierE", "clang::driver::ArgList::getAllArgValues(clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList15AddAllArgValuesERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierES8_S8_", "clang::driver::ArgList::AddAllArgValues(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList10AddLastArgERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierE", "clang::driver::ArgList::AddLastArg(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList10AddAllArgsERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierES8_S8_", "clang::driver::ArgList::AddAllArgs(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList20AddAllArgsTranslatedERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierES5_b", "clang::driver::ArgList::AddAllArgsTranslated(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier, char const*, bool) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList13MakeArgStringERKN4llvm5TwineE", "clang::driver::ArgList::MakeArgString(llvm::Twine const&) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList12ClaimAllArgsENS0_12OptSpecifierE", "clang::driver::ArgList::ClaimAllArgs(clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZNK5clang6driver7ArgList24GetOrMakeJoinedArgStringEjN4llvm9StringRefES3_", "clang::driver::ArgList::GetOrMakeJoinedArgString(unsigned int, llvm::StringRef, llvm::StringRef) const"),
	mu_demangle_test("_ZN5clang6driver12InputArgListC1EPKPKcS5_", "clang::driver::InputArgList::InputArgList(char const* const*, char const* const*)"),
	mu_demangle_test("_ZN5clang6driver12InputArgListC2EPKPKcS5_", "clang::driver::InputArgList::InputArgList(char const* const*, char const* const*)"),
	mu_demangle_test("_ZN5clang6driver12InputArgListD0Ev", "clang::driver::InputArgList::~InputArgList()"),
	mu_demangle_test("_ZN5clang6driver12InputArgListD1Ev", "clang::driver::InputArgList::~InputArgList()"),
	mu_demangle_test("_ZN5clang6driver12InputArgListD2Ev", "clang::driver::InputArgList::~InputArgList()"),
	mu_demangle_test("_ZNK5clang6driver12InputArgList9MakeIndexEN4llvm9StringRefE", "clang::driver::InputArgList::MakeIndex(llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang6driver12InputArgList9MakeIndexEN4llvm9StringRefES3_", "clang::driver::InputArgList::MakeIndex(llvm::StringRef, llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang6driver12InputArgList13MakeArgStringEN4llvm9StringRefE", "clang::driver::InputArgList::MakeArgString(llvm::StringRef) const"),
	mu_demangle_test("_ZN5clang6driver14DerivedArgListC1ERKNS0_12InputArgListE", "clang::driver::DerivedArgList::DerivedArgList(clang::driver::InputArgList const&)"),
	mu_demangle_test("_ZN5clang6driver14DerivedArgListC2ERKNS0_12InputArgListE", "clang::driver::DerivedArgList::DerivedArgList(clang::driver::InputArgList const&)"),
	mu_demangle_test("_ZN5clang6driver14DerivedArgListD0Ev", "clang::driver::DerivedArgList::~DerivedArgList()"),
	mu_demangle_test("_ZN5clang6driver14DerivedArgListD1Ev", "clang::driver::DerivedArgList::~DerivedArgList()"),
	mu_demangle_test("_ZN5clang6driver14DerivedArgListD2Ev", "clang::driver::DerivedArgList::~DerivedArgList()"),
	mu_demangle_test("_ZNK5clang6driver14DerivedArgList13MakeArgStringEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakeArgString(llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang6driver14DerivedArgList11MakeFlagArgEPKNS0_3ArgEPKNS0_6OptionE", "clang::driver::DerivedArgList::MakeFlagArg(clang::driver::Arg const*, clang::driver::Option const*) const"),
	mu_demangle_test("_ZNK5clang6driver14DerivedArgList17MakePositionalArgEPKNS0_3ArgEPKNS0_6OptionEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakePositionalArg(clang::driver::Arg const*, clang::driver::Option const*, llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang6driver14DerivedArgList15MakeSeparateArgEPKNS0_3ArgEPKNS0_6OptionEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakeSeparateArg(clang::driver::Arg const*, clang::driver::Option const*, llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang6driver14DerivedArgList13MakeJoinedArgEPKNS0_3ArgEPKNS0_6OptionEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakeJoinedArg(clang::driver::Arg const*, clang::driver::Option const*, llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang6driver12InputArgList12getArgStringEj", "clang::driver::InputArgList::getArgString(unsigned int) const"),
	mu_demangle_test("_ZNK5clang6driver12InputArgList21getNumInputArgStringsEv", "clang::driver::InputArgList::getNumInputArgStrings() const"),
	mu_demangle_test("_ZNK5clang6driver14DerivedArgList12getArgStringEj", "clang::driver::DerivedArgList::getArgString(unsigned int) const"),
	mu_demangle_test("_ZNK5clang6driver14DerivedArgList21getNumInputArgStringsEv", "clang::driver::DerivedArgList::getNumInputArgStrings() const"),
	mu_demangle_test("_ZN5clang6driver19createCC1AsOptTableEv", "clang::driver::createCC1AsOptTable()"),
	mu_demangle_test("_ZN5clang6driver17createCC1OptTableEv", "clang::driver::createCC1OptTable()"),
	mu_demangle_test("_ZN5clang6driver11CompilationC1ERKNS0_6DriverERKNS0_9ToolChainEPNS0_12InputArgListEPNS0_14DerivedArgListE", "clang::driver::Compilation::Compilation(clang::driver::Driver const&, clang::driver::ToolChain const&, clang::driver::InputArgList*, clang::driver::DerivedArgList*)"),
	mu_demangle_test("_ZN5clang6driver11CompilationC2ERKNS0_6DriverERKNS0_9ToolChainEPNS0_12InputArgListEPNS0_14DerivedArgListE", "clang::driver::Compilation::Compilation(clang::driver::Driver const&, clang::driver::ToolChain const&, clang::driver::InputArgList*, clang::driver::DerivedArgList*)"),
	mu_demangle_test("_ZN5clang6driver11CompilationD1Ev", "clang::driver::Compilation::~Compilation()"),
	mu_demangle_test("_ZN5clang6driver11CompilationD2Ev", "clang::driver::Compilation::~Compilation()"),
	mu_demangle_test("_ZN5clang6driver11Compilation19getArgsForToolChainEPKNS0_9ToolChainEPKc", "clang::driver::Compilation::getArgsForToolChain(clang::driver::ToolChain const*, char const*)"),
	mu_demangle_test("_ZNK5clang6driver11Compilation8PrintJobERN4llvm11raw_ostreamERKNS0_3JobEPKcb", "clang::driver::Compilation::PrintJob(llvm::raw_ostream&, clang::driver::Job const&, char const*, bool) const"),
	mu_demangle_test("_ZNK5clang6driver11Compilation15CleanupFileListERKN4llvm11SmallVectorIPKcLj16EEEb", "clang::driver::Compilation::CleanupFileList(llvm::SmallVector<char const*, 16u> const&, bool) const"),
	mu_demangle_test("_ZNK5clang6driver11Compilation14ExecuteCommandERKNS0_7CommandERPS3_", "clang::driver::Compilation::ExecuteCommand(clang::driver::Command const&, clang::driver::Command const*&) const"),
	mu_demangle_test("_ZNK5clang6driver11Compilation10ExecuteJobERKNS0_3JobERPKNS0_7CommandE", "clang::driver::Compilation::ExecuteJob(clang::driver::Job const&, clang::driver::Command const*&) const"),
	mu_demangle_test("_ZNK4llvm8DenseMapISt4pairIPKN5clang6driver9ToolChainEPKcEPNS3_14DerivedArgListENS_12DenseMapInfoIS9_EENSC_ISB_EEE15LookupBucketForERKS9_RPS1_IS9_SB_E", "llvm::DenseMap<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*, llvm::DenseMapInfo<std::pair<clang::driver::ToolChain const*, char const*> >, llvm::DenseMapInfo<clang::driver::DerivedArgList*> >::LookupBucketFor(std::pair<clang::driver::ToolChain const*, char const*> const&, std::pair<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*>*&) const"),
	mu_demangle_test("_ZN4llvm8DenseMapISt4pairIPKN5clang6driver9ToolChainEPKcEPNS3_14DerivedArgListENS_12DenseMapInfoIS9_EENSC_ISB_EEE16InsertIntoBucketERKS9_RKSB_PS1_IS9_SB_E", "llvm::DenseMap<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*, llvm::DenseMapInfo<std::pair<clang::driver::ToolChain const*, char const*> >, llvm::DenseMapInfo<clang::driver::DerivedArgList*> >::InsertIntoBucket(std::pair<clang::driver::ToolChain const*, char const*> const&, clang::driver::DerivedArgList* const&, std::pair<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapISt4pairIPKN5clang6driver9ToolChainEPKcEPNS3_14DerivedArgListENS_12DenseMapInfoIS9_EENSC_ISB_EEE4growEj", "llvm::DenseMap<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*, llvm::DenseMapInfo<std::pair<clang::driver::ToolChain const*, char const*> >, llvm::DenseMapInfo<clang::driver::DerivedArgList*> >::grow(unsigned int)"),
	mu_demangle_test("_ZN5clang6driver6DriverC1EN4llvm9StringRefES3_S3_bbRNS_10DiagnosticE", "clang::driver::Driver::Driver(llvm::StringRef, llvm::StringRef, llvm::StringRef, bool, bool, clang::Diagnostic&)"),
	mu_demangle_test("_ZN5clang6driver6DriverC2EN4llvm9StringRefES3_S3_bbRNS_10DiagnosticE", "clang::driver::Driver::Driver(llvm::StringRef, llvm::StringRef, llvm::StringRef, bool, bool, clang::Diagnostic&)"),
	mu_demangle_test("_ZN5clang6driver6DriverD1Ev", "clang::driver::Driver::~Driver()"),
	mu_demangle_test("_ZN5clang6driver6DriverD2Ev", "clang::driver::Driver::~Driver()"),
	mu_demangle_test("_ZN5clang6driver6Driver15ParseArgStringsEPPKcS4_", "clang::driver::Driver::ParseArgStrings(char const**, char const**)"),
	mu_demangle_test("_ZNK5clang6driver6Driver18TranslateInputArgsERKNS0_12InputArgListE", "clang::driver::Driver::TranslateInputArgs(clang::driver::InputArgList const&) const"),
	mu_demangle_test("_ZN5clang6driver6Driver16BuildCompilationEiPPKc", "clang::driver::Driver::BuildCompilation(int, char const**)"),
	mu_demangle_test("_ZNK5clang6driver6Driver11GetHostInfoEPKc", "clang::driver::Driver::GetHostInfo(char const*) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver12PrintOptionsERKNS0_7ArgListE", "clang::driver::Driver::PrintOptions(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZN5clang6driver6Driver19HandleImmediateArgsERKNS0_11CompilationE", "clang::driver::Driver::HandleImmediateArgs(clang::driver::Compilation const&)"),
	mu_demangle_test("_ZNK5clang6driver6Driver21BuildUniversalActionsERKNS0_9ToolChainERKNS0_7ArgListERN4llvm11SmallVectorIPNS0_6ActionELj3EEE", "clang::driver::Driver::BuildUniversalActions(clang::driver::ToolChain const&, clang::driver::ArgList const&, llvm::SmallVector<clang::driver::Action*, 3u>&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver12BuildActionsERKNS0_9ToolChainERKNS0_7ArgListERN4llvm11SmallVectorIPNS0_6ActionELj3EEE", "clang::driver::Driver::BuildActions(clang::driver::ToolChain const&, clang::driver::ArgList const&, llvm::SmallVector<clang::driver::Action*, 3u>&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver12PrintActionsERKNS0_11CompilationE", "clang::driver::Driver::PrintActions(clang::driver::Compilation const&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver9BuildJobsERNS0_11CompilationE", "clang::driver::Driver::BuildJobs(clang::driver::Compilation&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver18ExecuteCompilationERKNS0_11CompilationE", "clang::driver::Driver::ExecuteCompilation(clang::driver::Compilation const&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver9PrintHelpEb", "clang::driver::Driver::PrintHelp(bool) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver12PrintVersionERKNS0_11CompilationERN4llvm11raw_ostreamE", "clang::driver::Driver::PrintVersion(clang::driver::Compilation const&, llvm::raw_ostream&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver11GetFilePathEPKcRKNS0_9ToolChainE", "clang::driver::Driver::GetFilePath(char const*, clang::driver::ToolChain const&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver14GetProgramPathEPKcRKNS0_9ToolChainEb", "clang::driver::Driver::GetProgramPath(char const*, clang::driver::ToolChain const&, bool) const"),
	mu_demangle_test("_Z13PrintActions1RKN5clang6driver11CompilationEPNS0_6ActionERSt3mapIS5_jSt4lessIS5_ESaISt4pairIKS5_jEEE", "PrintActions1(clang::driver::Compilation const&, clang::driver::Action*, std::map<clang::driver::Action*, unsigned int, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >&)"),
	mu_demangle_test("_Z21ContainsCompileActionPKN5clang6driver6ActionE", "ContainsCompileAction(clang::driver::Action const*)"),
	mu_demangle_test("_ZNK5clang6driver6Driver20ConstructPhaseActionERKNS0_7ArgListENS0_6phases2IDEPNS0_6ActionE", "clang::driver::Driver::ConstructPhaseAction(clang::driver::ArgList const&, clang::driver::phases::ID, clang::driver::Action*) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver18BuildJobsForActionERNS0_11CompilationEPKNS0_6ActionEPKNS0_9ToolChainEPKcbSB_RNS0_9InputInfoE", "clang::driver::Driver::BuildJobsForAction(clang::driver::Compilation&, clang::driver::Action const*, clang::driver::ToolChain const*, char const*, bool, char const*, clang::driver::InputInfo&) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver18GetNamedOutputPathERNS0_11CompilationERKNS0_9JobActionEPKcb", "clang::driver::Driver::GetNamedOutputPath(clang::driver::Compilation&, clang::driver::JobAction const&, char const*, bool) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver16GetTemporaryPathEPKc", "clang::driver::Driver::GetTemporaryPath(char const*) const"),
	mu_demangle_test("_ZNK5clang6driver6Driver22ShouldUseClangCompilerERKNS0_11CompilationERKNS0_9JobActionERKN4llvm6TripleE", "clang::driver::Driver::ShouldUseClangCompiler(clang::driver::Compilation const&, clang::driver::JobAction const&, llvm::Triple const&) const"),
	mu_demangle_test("_ZN5clang6driver6Driver17GetReleaseVersionEPKcRjS4_S4_Rb", "clang::driver::Driver::GetReleaseVersion(char const*, unsigned int&, unsigned int&, unsigned int&, bool&)"),
	mu_demangle_test("_ZN4llvm22PrettyStackTraceStringD1Ev", "llvm::PrettyStackTraceString::~PrettyStackTraceString()"),
	mu_demangle_test("_ZN4llvm9StringSetINS_15MallocAllocatorEE6insertENS_9StringRefE", "llvm::StringSet<llvm::MallocAllocator>::insert(llvm::StringRef)"),
	mu_demangle_test("_ZNK5clang6driver9InputInfo11getAsStringEv", "clang::driver::InputInfo::getAsString() const"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang6driver9InputInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::driver::InputInfo, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseISsLb0EE4growEm", "llvm::SmallVectorTemplateBase<std::string, false>::grow(unsigned long)"),
	mu_demangle_test("_ZNSt8_Rb_treeIN4llvm6Triple8ArchTypeES2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE8_M_eraseEPSt13_Rb_tree_nodeIS2_E", "std::_Rb_tree<llvm::Triple::ArchType, llvm::Triple::ArchType, std::_Identity<llvm::Triple::ArchType>, std::less<llvm::Triple::ArchType>, std::allocator<llvm::Triple::ArchType> >::_M_erase(std::_Rb_tree_node<llvm::Triple::ArchType>*)"),
	mu_demangle_test("_ZNSt8_Rb_treeIN4llvm6Triple8ArchTypeES2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE16_M_insert_uniqueERKS2_", "std::_Rb_tree<llvm::Triple::ArchType, llvm::Triple::ArchType, std::_Identity<llvm::Triple::ArchType>, std::less<llvm::Triple::ArchType>, std::allocator<llvm::Triple::ArchType> >::_M_insert_unique(llvm::Triple::ArchType const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeIPN5clang6driver6ActionESt4pairIKS3_jESt10_Select1stIS6_ESt4lessIS3_ESaIS6_EE8_M_eraseEPSt13_Rb_tree_nodeIS6_E", "std::_Rb_tree<clang::driver::Action*, std::pair<clang::driver::Action* const, unsigned int>, std::_Select1st<std::pair<clang::driver::Action* const, unsigned int> >, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::driver::Action* const, unsigned int> >*)"),
	mu_demangle_test("_ZNK4llvm18raw_string_ostream11current_posEv", "llvm::raw_string_ostream::current_pos() const"),
	mu_demangle_test("_ZNSt8_Rb_treeIPN5clang6driver6ActionESt4pairIKS3_jESt10_Select1stIS6_ESt4lessIS3_ESaIS6_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS6_ERKS6_", "std::_Rb_tree<clang::driver::Action*, std::pair<clang::driver::Action* const, unsigned int>, std::_Select1st<std::pair<clang::driver::Action* const, unsigned int> >, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::driver::Action* const, unsigned int> >, std::pair<clang::driver::Action* const, unsigned int> const&)"),
	mu_demangle_test("_ZNSt8_Rb_treeIPN5clang6driver6ActionESt4pairIKS3_jESt10_Select1stIS6_ESt4lessIS3_ESaIS6_EE16_M_insert_uniqueERKS6_", "std::_Rb_tree<clang::driver::Action*, std::pair<clang::driver::Action* const, unsigned int>, std::_Select1st<std::pair<clang::driver::Action* const, unsigned int> >, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >::_M_insert_unique(std::pair<clang::driver::Action* const, unsigned int> const&)"),
	mu_demangle_test("_ZN4llvm6TripleC2ENS_9StringRefES1_S1_", "llvm::Triple::Triple(llvm::StringRef, llvm::StringRef, llvm::StringRef)"),
	mu_demangle_test("_ZN4llvm22PrettyStackTraceStringD0Ev", "llvm::PrettyStackTraceString::~PrettyStackTraceString()"),
	mu_demangle_test("_ZN5clang6driver20createDriverOptTableEv", "clang::driver::createDriverOptTable()"),
	mu_demangle_test("_ZN5clang6driver8HostInfoC1ERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::HostInfo::HostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver8HostInfoC2ERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::HostInfo::HostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver8HostInfoD0Ev", "clang::driver::HostInfo::~HostInfo()"),
	mu_demangle_test("_ZN5clang6driver8HostInfoD1Ev", "clang::driver::HostInfo::~HostInfo()"),
	mu_demangle_test("_ZN5clang6driver8HostInfoD2Ev", "clang::driver::HostInfo::~HostInfo()"),
	mu_demangle_test("_ZN5clang6driver22createAuroraUXHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createAuroraUXHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver20createDarwinHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createDarwinHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver21createOpenBSDHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createOpenBSDHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver21createFreeBSDHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createFreeBSDHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver20createNetBSDHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createNetBSDHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver19createMinixHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createMinixHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver23createDragonFlyHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createDragonFlyHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver19createLinuxHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createLinuxHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver17createTCEHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createTCEHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver21createWindowsHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createWindowsHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver19createMinGWHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createMinGWHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver21createUnknownHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createUnknownHostInfo(clang::driver::Driver const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115UnknownHostInfoD1Ev", "(anonymous namespace)::UnknownHostInfo::~UnknownHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115UnknownHostInfoD0Ev", "(anonymous namespace)::UnknownHostInfo::~UnknownHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115UnknownHostInfo15useDriverDriverEv", "(anonymous namespace)::UnknownHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115UnknownHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::UnknownHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_115UnknownHostInfoD2Ev", "(anonymous namespace)::UnknownHostInfo::~UnknownHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113MinGWHostInfoD1Ev", "(anonymous namespace)::MinGWHostInfo::~MinGWHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113MinGWHostInfoD0Ev", "(anonymous namespace)::MinGWHostInfo::~MinGWHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115WindowsHostInfoD1Ev", "(anonymous namespace)::WindowsHostInfo::~WindowsHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115WindowsHostInfoD0Ev", "(anonymous namespace)::WindowsHostInfo::~WindowsHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115WindowsHostInfo15useDriverDriverEv", "(anonymous namespace)::WindowsHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115WindowsHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::WindowsHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115WindowsHostInfo22lookupTypeForExtensionEPKc", "(anonymous namespace)::WindowsHostInfo::lookupTypeForExtension(char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_111TCEHostInfoD1Ev", "(anonymous namespace)::TCEHostInfo::~TCEHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_111TCEHostInfoD0Ev", "(anonymous namespace)::TCEHostInfo::~TCEHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_111TCEHostInfo15useDriverDriverEv", "(anonymous namespace)::TCEHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_111TCEHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::TCEHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_113LinuxHostInfoD1Ev", "(anonymous namespace)::LinuxHostInfo::~LinuxHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113LinuxHostInfoD0Ev", "(anonymous namespace)::LinuxHostInfo::~LinuxHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113LinuxHostInfo15useDriverDriverEv", "(anonymous namespace)::LinuxHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113LinuxHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::LinuxHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_117DragonFlyHostInfoD1Ev", "(anonymous namespace)::DragonFlyHostInfo::~DragonFlyHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117DragonFlyHostInfoD0Ev", "(anonymous namespace)::DragonFlyHostInfo::~DragonFlyHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_117DragonFlyHostInfo15useDriverDriverEv", "(anonymous namespace)::DragonFlyHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_117DragonFlyHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::DragonFlyHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_113MinixHostInfoD1Ev", "(anonymous namespace)::MinixHostInfo::~MinixHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113MinixHostInfoD0Ev", "(anonymous namespace)::MinixHostInfo::~MinixHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113MinixHostInfo15useDriverDriverEv", "(anonymous namespace)::MinixHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113MinixHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::MinixHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_114NetBSDHostInfoD1Ev", "(anonymous namespace)::NetBSDHostInfo::~NetBSDHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114NetBSDHostInfoD0Ev", "(anonymous namespace)::NetBSDHostInfo::~NetBSDHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114NetBSDHostInfo15useDriverDriverEv", "(anonymous namespace)::NetBSDHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114NetBSDHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::NetBSDHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_115FreeBSDHostInfoD1Ev", "(anonymous namespace)::FreeBSDHostInfo::~FreeBSDHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115FreeBSDHostInfoD0Ev", "(anonymous namespace)::FreeBSDHostInfo::~FreeBSDHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115FreeBSDHostInfo15useDriverDriverEv", "(anonymous namespace)::FreeBSDHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115FreeBSDHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::FreeBSDHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_115OpenBSDHostInfoD1Ev", "(anonymous namespace)::OpenBSDHostInfo::~OpenBSDHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115OpenBSDHostInfoD0Ev", "(anonymous namespace)::OpenBSDHostInfo::~OpenBSDHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115OpenBSDHostInfo15useDriverDriverEv", "(anonymous namespace)::OpenBSDHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_115OpenBSDHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::OpenBSDHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_114DarwinHostInfoD1Ev", "(anonymous namespace)::DarwinHostInfo::~DarwinHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114DarwinHostInfoD0Ev", "(anonymous namespace)::DarwinHostInfo::~DarwinHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114DarwinHostInfo15useDriverDriverEv", "(anonymous namespace)::DarwinHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114DarwinHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::DarwinHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_116AuroraUXHostInfoD1Ev", "(anonymous namespace)::AuroraUXHostInfo::~AuroraUXHostInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116AuroraUXHostInfoD0Ev", "(anonymous namespace)::AuroraUXHostInfo::~AuroraUXHostInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_116AuroraUXHostInfo15useDriverDriverEv", "(anonymous namespace)::AuroraUXHostInfo::useDriverDriver() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_116AuroraUXHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::AuroraUXHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN4llvm9StringMapIPN5clang6driver9ToolChainENS_15MallocAllocatorEE16GetOrCreateValueIS4_EERNS_14StringMapEntryIS4_EENS_9StringRefET_", "llvm::StringMapEntry<clang::driver::ToolChain*>& llvm::StringMap<clang::driver::ToolChain*, llvm::MallocAllocator>::GetOrCreateValue<clang::driver::ToolChain*>(llvm::StringRef, clang::driver::ToolChain*)"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain13TranslateArgsERKNS0_14DerivedArgListEPKc", "clang::driver::ToolChain::TranslateArgs(clang::driver::DerivedArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain15IsBlocksDefaultEv", "clang::driver::ToolChain::IsBlocksDefault() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain28IsIntegratedAssemblerDefaultEv", "clang::driver::ToolChain::IsIntegratedAssemblerDefault() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain23IsStrictAliasingDefaultEv", "clang::driver::ToolChain::IsStrictAliasingDefault() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain35IsObjCDefaultSynthPropertiesDefaultEv", "clang::driver::ToolChain::IsObjCDefaultSynthPropertiesDefault() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain26IsObjCNonFragileABIDefaultEv", "clang::driver::ToolChain::IsObjCNonFragileABIDefault() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain27IsObjCLegacyDispatchDefaultEv", "clang::driver::ToolChain::IsObjCLegacyDispatchDefault() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain20UseObjCMixedDispatchEv", "clang::driver::ToolChain::UseObjCMixedDispatch() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain29GetDefaultStackProtectorLevelEv", "clang::driver::ToolChain::GetDefaultStackProtectorLevel() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains18Darwin_Generic_GCC25GetDefaultRelocationModelEv", "clang::driver::toolchains::Darwin_Generic_GCC::GetDefaultRelocationModel() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain14SupportsObjCGCEv", "clang::driver::ToolChain::SupportsObjCGC() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain18UseDwarfDebugFlagsEv", "clang::driver::ToolChain::UseDwarfDebugFlags() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain17UseSjLjExceptionsEv", "clang::driver::ToolChain::UseSjLjExceptions() const"),
	mu_demangle_test("_ZN4llvm8DenseMapIjPN5clang6driver9ToolChainENS_12DenseMapInfoIjEENS5_IS4_EEE16InsertIntoBucketERKjRKS4_PSt4pairIjS4_E", "llvm::DenseMap<unsigned int, clang::driver::ToolChain*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::ToolChain*> >::InsertIntoBucket(unsigned int const&, clang::driver::ToolChain* const&, std::pair<unsigned int, clang::driver::ToolChain*>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIjPN5clang6driver9ToolChainENS_12DenseMapInfoIjEENS5_IS4_EEE4growEj", "llvm::DenseMap<unsigned int, clang::driver::ToolChain*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::ToolChain*> >::grow(unsigned int)"),
	mu_demangle_test("_ZN5clang6driver3JobD0Ev", "clang::driver::Job::~Job()"),
	mu_demangle_test("_ZN5clang6driver3JobD1Ev", "clang::driver::Job::~Job()"),
	mu_demangle_test("_ZN5clang6driver3JobD2Ev", "clang::driver::Job::~Job()"),
	mu_demangle_test("_ZN5clang6driver7CommandC1ERKNS0_6ActionERKNS0_4ToolEPKcRKN4llvm11SmallVectorIS9_Lj16EEE", "clang::driver::Command::Command(clang::driver::Action const&, clang::driver::Tool const&, char const*, llvm::SmallVector<char const*, 16u> const&)"),
	mu_demangle_test("_ZN5clang6driver7CommandC2ERKNS0_6ActionERKNS0_4ToolEPKcRKN4llvm11SmallVectorIS9_Lj16EEE", "clang::driver::Command::Command(clang::driver::Action const&, clang::driver::Tool const&, char const*, llvm::SmallVector<char const*, 16u> const&)"),
	mu_demangle_test("_ZN5clang6driver7JobListC1Ev", "clang::driver::JobList::JobList()"),
	mu_demangle_test("_ZN5clang6driver7JobListC2Ev", "clang::driver::JobList::JobList()"),
	mu_demangle_test("_ZN5clang6driver7JobListD0Ev", "clang::driver::JobList::~JobList()"),
	mu_demangle_test("_ZN5clang6driver7JobListD1Ev", "clang::driver::JobList::~JobList()"),
	mu_demangle_test("_ZN5clang6driver7JobListD2Ev", "clang::driver::JobList::~JobList()"),
	mu_demangle_test("_ZN5clang6driver3Job10addCommandEPNS0_7CommandE", "clang::driver::Job::addCommand(clang::driver::Command*)"),
	mu_demangle_test("_ZN5clang6driver7CommandD1Ev", "clang::driver::Command::~Command()"),
	mu_demangle_test("_ZN5clang6driver7CommandD0Ev", "clang::driver::Command::~Command()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPKcEaSERKS3_", "llvm::SmallVectorImpl<char const*>::operator=(llvm::SmallVectorImpl<char const*> const&)"),
	mu_demangle_test("_ZN5clang6driver12OptSpecifierC1EPKNS0_6OptionE", "clang::driver::OptSpecifier::OptSpecifier(clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver12OptSpecifierC2EPKNS0_6OptionE", "clang::driver::OptSpecifier::OptSpecifier(clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver8OptTableC1EPKNS1_4InfoEj", "clang::driver::OptTable::OptTable(clang::driver::OptTable::Info const*, unsigned int)"),
	mu_demangle_test("_ZN5clang6driver8OptTableC2EPKNS1_4InfoEj", "clang::driver::OptTable::OptTable(clang::driver::OptTable::Info const*, unsigned int)"),
	mu_demangle_test("_ZN5clang6driver8OptTableD1Ev", "clang::driver::OptTable::~OptTable()"),
	mu_demangle_test("_ZN5clang6driver8OptTableD2Ev", "clang::driver::OptTable::~OptTable()"),
	mu_demangle_test("_ZNK5clang6driver8OptTable12CreateOptionEj", "clang::driver::OptTable::CreateOption(unsigned int) const"),
	mu_demangle_test("_ZNK5clang6driver8OptTable11ParseOneArgERKNS0_7ArgListERj", "clang::driver::OptTable::ParseOneArg(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZNK5clang6driver8OptTable9ParseArgsEPKPKcS5_RjS6_", "clang::driver::OptTable::ParseArgs(char const* const*, char const* const*, unsigned int&, unsigned int&) const"),
	mu_demangle_test("_ZNK5clang6driver8OptTable9PrintHelpERN4llvm11raw_ostreamEPKcS6_b", "clang::driver::OptTable::PrintHelp(llvm::raw_ostream&, char const*, char const*, bool) const"),
	mu_demangle_test("_ZN5clang6driver6OptionC1ENS1_11OptionClassENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKS1_", "clang::driver::Option::Option(clang::driver::Option::OptionClass, clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver6OptionC2ENS1_11OptionClassENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKS1_", "clang::driver::Option::Option(clang::driver::Option::OptionClass, clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver6OptionD0Ev", "clang::driver::Option::~Option()"),
	mu_demangle_test("_ZN5clang6driver6OptionD1Ev", "clang::driver::Option::~Option()"),
	mu_demangle_test("_ZN5clang6driver6OptionD2Ev", "clang::driver::Option::~Option()"),
	mu_demangle_test("_ZNK5clang6driver6Option4dumpEv", "clang::driver::Option::dump() const"),
	mu_demangle_test("_ZNK5clang6driver6Option7matchesENS0_12OptSpecifierE", "clang::driver::Option::matches(clang::driver::OptSpecifier) const"),
	mu_demangle_test("_ZN5clang6driver11OptionGroupC1ENS0_12OptSpecifierEPKcPKS1_", "clang::driver::OptionGroup::OptionGroup(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*)"),
	mu_demangle_test("_ZN5clang6driver11OptionGroupC2ENS0_12OptSpecifierEPKcPKS1_", "clang::driver::OptionGroup::OptionGroup(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*)"),
	mu_demangle_test("_ZNK5clang6driver11OptionGroup6acceptERKNS0_7ArgListERj", "clang::driver::OptionGroup::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver11InputOptionC1ENS0_12OptSpecifierE", "clang::driver::InputOption::InputOption(clang::driver::OptSpecifier)"),
	mu_demangle_test("_ZN5clang6driver11InputOptionC2ENS0_12OptSpecifierE", "clang::driver::InputOption::InputOption(clang::driver::OptSpecifier)"),
	mu_demangle_test("_ZNK5clang6driver11InputOption6acceptERKNS0_7ArgListERj", "clang::driver::InputOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver13UnknownOptionC1ENS0_12OptSpecifierE", "clang::driver::UnknownOption::UnknownOption(clang::driver::OptSpecifier)"),
	mu_demangle_test("_ZN5clang6driver13UnknownOptionC2ENS0_12OptSpecifierE", "clang::driver::UnknownOption::UnknownOption(clang::driver::OptSpecifier)"),
	mu_demangle_test("_ZNK5clang6driver13UnknownOption6acceptERKNS0_7ArgListERj", "clang::driver::UnknownOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver10FlagOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::FlagOption::FlagOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver10FlagOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::FlagOption::FlagOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZNK5clang6driver10FlagOption6acceptERKNS0_7ArgListERj", "clang::driver::FlagOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver12JoinedOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOption::JoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver12JoinedOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOption::JoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZNK5clang6driver12JoinedOption6acceptERKNS0_7ArgListERj", "clang::driver::JoinedOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver17CommaJoinedOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::CommaJoinedOption::CommaJoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver17CommaJoinedOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::CommaJoinedOption::CommaJoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZNK5clang6driver17CommaJoinedOption6acceptERKNS0_7ArgListERj", "clang::driver::CommaJoinedOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver14SeparateOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::SeparateOption::SeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver14SeparateOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::SeparateOption::SeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZNK5clang6driver14SeparateOption6acceptERKNS0_7ArgListERj", "clang::driver::SeparateOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver14MultiArgOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionEj", "clang::driver::MultiArgOption::MultiArgOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*, unsigned int)"),
	mu_demangle_test("_ZN5clang6driver14MultiArgOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionEj", "clang::driver::MultiArgOption::MultiArgOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*, unsigned int)"),
	mu_demangle_test("_ZNK5clang6driver14MultiArgOption6acceptERKNS0_7ArgListERj", "clang::driver::MultiArgOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver22JoinedOrSeparateOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOrSeparateOption::JoinedOrSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver22JoinedOrSeparateOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOrSeparateOption::JoinedOrSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZNK5clang6driver22JoinedOrSeparateOption6acceptERKNS0_7ArgListERj", "clang::driver::JoinedOrSeparateOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver23JoinedAndSeparateOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedAndSeparateOption::JoinedAndSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZN5clang6driver23JoinedAndSeparateOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedAndSeparateOption::JoinedAndSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"),
	mu_demangle_test("_ZNK5clang6driver23JoinedAndSeparateOption6acceptERKNS0_7ArgListERj", "clang::driver::JoinedAndSeparateOption::accept(clang::driver::ArgList const&, unsigned int&) const"),
	mu_demangle_test("_ZN5clang6driver11OptionGroupD1Ev", "clang::driver::OptionGroup::~OptionGroup()"),
	mu_demangle_test("_ZN5clang6driver11OptionGroupD0Ev", "clang::driver::OptionGroup::~OptionGroup()"),
	mu_demangle_test("_ZN5clang6driver11InputOptionD1Ev", "clang::driver::InputOption::~InputOption()"),
	mu_demangle_test("_ZN5clang6driver11InputOptionD0Ev", "clang::driver::InputOption::~InputOption()"),
	mu_demangle_test("_ZN5clang6driver13UnknownOptionD1Ev", "clang::driver::UnknownOption::~UnknownOption()"),
	mu_demangle_test("_ZN5clang6driver13UnknownOptionD0Ev", "clang::driver::UnknownOption::~UnknownOption()"),
	mu_demangle_test("_ZN5clang6driver10FlagOptionD1Ev", "clang::driver::FlagOption::~FlagOption()"),
	mu_demangle_test("_ZN5clang6driver10FlagOptionD0Ev", "clang::driver::FlagOption::~FlagOption()"),
	mu_demangle_test("_ZN5clang6driver12JoinedOptionD1Ev", "clang::driver::JoinedOption::~JoinedOption()"),
	mu_demangle_test("_ZN5clang6driver12JoinedOptionD0Ev", "clang::driver::JoinedOption::~JoinedOption()"),
	mu_demangle_test("_ZN5clang6driver17CommaJoinedOptionD1Ev", "clang::driver::CommaJoinedOption::~CommaJoinedOption()"),
	mu_demangle_test("_ZN5clang6driver17CommaJoinedOptionD0Ev", "clang::driver::CommaJoinedOption::~CommaJoinedOption()"),
	mu_demangle_test("_ZN5clang6driver14SeparateOptionD1Ev", "clang::driver::SeparateOption::~SeparateOption()"),
	mu_demangle_test("_ZN5clang6driver14SeparateOptionD0Ev", "clang::driver::SeparateOption::~SeparateOption()"),
	mu_demangle_test("_ZN5clang6driver14MultiArgOptionD1Ev", "clang::driver::MultiArgOption::~MultiArgOption()"),
	mu_demangle_test("_ZN5clang6driver14MultiArgOptionD0Ev", "clang::driver::MultiArgOption::~MultiArgOption()"),
	mu_demangle_test("_ZN5clang6driver22JoinedOrSeparateOptionD1Ev", "clang::driver::JoinedOrSeparateOption::~JoinedOrSeparateOption()"),
	mu_demangle_test("_ZN5clang6driver22JoinedOrSeparateOptionD0Ev", "clang::driver::JoinedOrSeparateOption::~JoinedOrSeparateOption()"),
	mu_demangle_test("_ZN5clang6driver23JoinedAndSeparateOptionD1Ev", "clang::driver::JoinedAndSeparateOption::~JoinedAndSeparateOption()"),
	mu_demangle_test("_ZN5clang6driver23JoinedAndSeparateOptionD0Ev", "clang::driver::JoinedAndSeparateOption::~JoinedAndSeparateOption()"),
	mu_demangle_test("_ZN5clang6driver6phases12getPhaseNameENS1_2IDE", "clang::driver::phases::getPhaseName(clang::driver::phases::ID)"),
	mu_demangle_test("_ZN5clang6driver4ToolC1EPKcS3_RKNS0_9ToolChainE", "clang::driver::Tool::Tool(char const*, char const*, clang::driver::ToolChain const&)"),
	mu_demangle_test("_ZN5clang6driver4ToolC2EPKcS3_RKNS0_9ToolChainE", "clang::driver::Tool::Tool(char const*, char const*, clang::driver::ToolChain const&)"),
	mu_demangle_test("_ZN5clang6driver4ToolD0Ev", "clang::driver::Tool::~Tool()"),
	mu_demangle_test("_ZN5clang6driver4ToolD1Ev", "clang::driver::Tool::~Tool()"),
	mu_demangle_test("_ZN5clang6driver4ToolD2Ev", "clang::driver::Tool::~Tool()"),
	mu_demangle_test("_ZN5clang6driver9ToolChainC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::ToolChain::ToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver9ToolChainC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::ToolChain::ToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver9ToolChainD0Ev", "clang::driver::ToolChain::~ToolChain()"),
	mu_demangle_test("_ZN5clang6driver9ToolChainD1Ev", "clang::driver::ToolChain::~ToolChain()"),
	mu_demangle_test("_ZN5clang6driver9ToolChainD2Ev", "clang::driver::ToolChain::~ToolChain()"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain9getDriverEv", "clang::driver::ToolChain::getDriver() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain11GetFilePathEPKc", "clang::driver::ToolChain::GetFilePath(char const*) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain14GetProgramPathEPKcb", "clang::driver::ToolChain::GetProgramPath(char const*, bool) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain22LookupTypeForExtensionEPKc", "clang::driver::ToolChain::LookupTypeForExtension(char const*) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain20HasNativeLLVMSupportEv", "clang::driver::ToolChain::HasNativeLLVMSupport() const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain17ComputeLLVMTripleERKNS0_7ArgListE", "clang::driver::ToolChain::ComputeLLVMTriple(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain27ComputeEffectiveClangTripleERKNS0_7ArgListE", "clang::driver::ToolChain::ComputeEffectiveClangTriple(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain16GetCXXStdlibTypeERKNS0_7ArgListE", "clang::driver::ToolChain::GetCXXStdlibType(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain28AddClangCXXStdlibIncludeArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::ToolChain::AddClangCXXStdlibIncludeArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain19AddCXXStdlibLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::ToolChain::AddCXXStdlibLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver9ToolChain16AddCCKextLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::ToolChain::AddCCKextLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains6DarwinC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Darwin::Darwin(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains6DarwinC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Darwin::Darwin(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin22LookupTypeForExtensionEPKc", "clang::driver::toolchains::Darwin::LookupTypeForExtension(char const*) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin20HasNativeLLVMSupportEv", "clang::driver::toolchains::Darwin::HasNativeLLVMSupport() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin17getDarwinArchNameERKNS0_7ArgListE", "clang::driver::toolchains::Darwin::getDarwinArchName(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DarwinGCCC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinGCC::DarwinGCC(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DarwinGCCC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinGCC::DarwinGCC(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains6DarwinD0Ev", "clang::driver::toolchains::Darwin::~Darwin()"),
	mu_demangle_test("_ZN5clang6driver10toolchains6DarwinD1Ev", "clang::driver::toolchains::Darwin::~Darwin()"),
	mu_demangle_test("_ZN5clang6driver10toolchains6DarwinD2Ev", "clang::driver::toolchains::Darwin::~Darwin()"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin27ComputeEffectiveClangTripleERKNS0_7ArgListE", "clang::driver::toolchains::Darwin::ComputeEffectiveClangTriple(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Darwin::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains9DarwinGCC21AddLinkSearchPathArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinGCC::AddLinkSearchPathArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains9DarwinGCC21AddLinkRuntimeLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinGCC::AddLinkRuntimeLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains11DarwinClangC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinClang::DarwinClang(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains11DarwinClangC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinClang::DarwinClang(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11DarwinClang21AddLinkSearchPathArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddLinkSearchPathArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11DarwinClang21AddLinkRuntimeLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddLinkRuntimeLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin19AddDeploymentTargetERNS0_14DerivedArgListE", "clang::driver::toolchains::Darwin::AddDeploymentTarget(clang::driver::DerivedArgList&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11DarwinClang19AddCXXStdlibLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddCXXStdlibLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11DarwinClang16AddCCKextLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddCCKextLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin13TranslateArgsERKNS0_14DerivedArgListEPKc", "clang::driver::toolchains::Darwin::TranslateArgs(clang::driver::DerivedArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin21IsUnwindTablesDefaultEv", "clang::driver::toolchains::Darwin::IsUnwindTablesDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin18UseDwarfDebugFlagsEv", "clang::driver::toolchains::Darwin::UseDwarfDebugFlags() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin17UseSjLjExceptionsEv", "clang::driver::toolchains::Darwin::UseSjLjExceptions() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin25GetDefaultRelocationModelEv", "clang::driver::toolchains::Darwin::GetDefaultRelocationModel() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin17GetForcedPicModelEv", "clang::driver::toolchains::Darwin::GetForcedPicModel() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin14SupportsObjCGCEv", "clang::driver::toolchains::Darwin::SupportsObjCGC() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains18Darwin_Generic_GCC27ComputeEffectiveClangTripleERKNS0_7ArgListE", "clang::driver::toolchains::Darwin_Generic_GCC::ComputeEffectiveClangTriple(clang::driver::ArgList const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains11Generic_GCCC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Generic_GCC::Generic_GCC(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains11Generic_GCCC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Generic_GCC::Generic_GCC(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains11Generic_GCCD0Ev", "clang::driver::toolchains::Generic_GCC::~Generic_GCC()"),
	mu_demangle_test("_ZN5clang6driver10toolchains11Generic_GCCD1Ev", "clang::driver::toolchains::Generic_GCC::~Generic_GCC()"),
	mu_demangle_test("_ZN5clang6driver10toolchains11Generic_GCCD2Ev", "clang::driver::toolchains::Generic_GCC::~Generic_GCC()"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11Generic_GCC10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Generic_GCC::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11Generic_GCC21IsUnwindTablesDefaultEv", "clang::driver::toolchains::Generic_GCC::IsUnwindTablesDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11Generic_GCC25GetDefaultRelocationModelEv", "clang::driver::toolchains::Generic_GCC::GetDefaultRelocationModel() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11Generic_GCC17GetForcedPicModelEv", "clang::driver::toolchains::Generic_GCC::GetForcedPicModel() const"),
	mu_demangle_test("_ZN5clang6driver10toolchains12TCEToolChainC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::TCEToolChain::TCEToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains12TCEToolChainC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::TCEToolChain::TCEToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains12TCEToolChainD0Ev", "clang::driver::toolchains::TCEToolChain::~TCEToolChain()"),
	mu_demangle_test("_ZN5clang6driver10toolchains12TCEToolChainD1Ev", "clang::driver::toolchains::TCEToolChain::~TCEToolChain()"),
	mu_demangle_test("_ZN5clang6driver10toolchains12TCEToolChainD2Ev", "clang::driver::toolchains::TCEToolChain::~TCEToolChain()"),
	mu_demangle_test("_ZNK5clang6driver10toolchains12TCEToolChain18IsMathErrnoDefaultEv", "clang::driver::toolchains::TCEToolChain::IsMathErrnoDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains12TCEToolChain21IsUnwindTablesDefaultEv", "clang::driver::toolchains::TCEToolChain::IsUnwindTablesDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains12TCEToolChain25GetDefaultRelocationModelEv", "clang::driver::toolchains::TCEToolChain::GetDefaultRelocationModel() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains12TCEToolChain17GetForcedPicModelEv", "clang::driver::toolchains::TCEToolChain::GetForcedPicModel() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains12TCEToolChain10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::TCEToolChain::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains7OpenBSDC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::OpenBSD::OpenBSD(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains7OpenBSDC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::OpenBSD::OpenBSD(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains7OpenBSD10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::OpenBSD::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains7FreeBSDC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::FreeBSD::FreeBSD(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains7FreeBSDC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::FreeBSD::FreeBSD(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains7FreeBSD10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::FreeBSD::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains6NetBSDC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::NetBSD::NetBSD(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains6NetBSDC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::NetBSD::NetBSD(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6NetBSD10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::NetBSD::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains5MinixC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Minix::Minix(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains5MinixC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Minix::Minix(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains5Minix10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Minix::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains8AuroraUXC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::AuroraUX::AuroraUX(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains8AuroraUXC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::AuroraUX::AuroraUX(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains8AuroraUX10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::AuroraUX::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains5LinuxC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Linux::Linux(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains5LinuxC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Linux::Linux(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains5Linux20HasNativeLLVMSupportEv", "clang::driver::toolchains::Linux::HasNativeLLVMSupport() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains5Linux10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Linux::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DragonFlyC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DragonFly::DragonFly(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DragonFlyC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DragonFly::DragonFly(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains9DragonFly10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::DragonFly::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZN5clang6driver10toolchains7WindowsC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Windows::Windows(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZN5clang6driver10toolchains7WindowsC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Windows::Windows(clang::driver::HostInfo const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver10toolchains7Windows10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Windows::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains7Windows28IsIntegratedAssemblerDefaultEv", "clang::driver::toolchains::Windows::IsIntegratedAssemblerDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains7Windows21IsUnwindTablesDefaultEv", "clang::driver::toolchains::Windows::IsUnwindTablesDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains7Windows25GetDefaultRelocationModelEv", "clang::driver::toolchains::Windows::GetDefaultRelocationModel() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains7Windows17GetForcedPicModelEv", "clang::driver::toolchains::Windows::GetForcedPicModel() const"),
	mu_demangle_test("_ZN5clang6driver10toolchains18Darwin_Generic_GCCD1Ev", "clang::driver::toolchains::Darwin_Generic_GCC::~Darwin_Generic_GCC()"),
	mu_demangle_test("_ZN5clang6driver10toolchains18Darwin_Generic_GCCD0Ev", "clang::driver::toolchains::Darwin_Generic_GCC::~Darwin_Generic_GCC()"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin15IsBlocksDefaultEv", "clang::driver::toolchains::Darwin::IsBlocksDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin28IsIntegratedAssemblerDefaultEv", "clang::driver::toolchains::Darwin::IsIntegratedAssemblerDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin23IsStrictAliasingDefaultEv", "clang::driver::toolchains::Darwin::IsStrictAliasingDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin35IsObjCDefaultSynthPropertiesDefaultEv", "clang::driver::toolchains::Darwin::IsObjCDefaultSynthPropertiesDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin26IsObjCNonFragileABIDefaultEv", "clang::driver::toolchains::Darwin::IsObjCNonFragileABIDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin27IsObjCLegacyDispatchDefaultEv", "clang::driver::toolchains::Darwin::IsObjCLegacyDispatchDefault() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin20UseObjCMixedDispatchEv", "clang::driver::toolchains::Darwin::UseObjCMixedDispatch() const"),
	mu_demangle_test("_ZNK5clang6driver10toolchains6Darwin29GetDefaultStackProtectorLevelEv", "clang::driver::toolchains::Darwin::GetDefaultStackProtectorLevel() const"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DarwinGCCD1Ev", "clang::driver::toolchains::DarwinGCC::~DarwinGCC()"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DarwinGCCD0Ev", "clang::driver::toolchains::DarwinGCC::~DarwinGCC()"),
	mu_demangle_test("_ZN5clang6driver10toolchains11DarwinClangD1Ev", "clang::driver::toolchains::DarwinClang::~DarwinClang()"),
	mu_demangle_test("_ZN5clang6driver10toolchains11DarwinClangD0Ev", "clang::driver::toolchains::DarwinClang::~DarwinClang()"),
	mu_demangle_test("_ZN5clang6driver10toolchains7OpenBSDD1Ev", "clang::driver::toolchains::OpenBSD::~OpenBSD()"),
	mu_demangle_test("_ZN5clang6driver10toolchains7OpenBSDD0Ev", "clang::driver::toolchains::OpenBSD::~OpenBSD()"),
	mu_demangle_test("_ZNK5clang6driver10toolchains11Generic_ELF28IsIntegratedAssemblerDefaultEv", "clang::driver::toolchains::Generic_ELF::IsIntegratedAssemblerDefault() const"),
	mu_demangle_test("_ZN5clang6driver10toolchains7FreeBSDD1Ev", "clang::driver::toolchains::FreeBSD::~FreeBSD()"),
	mu_demangle_test("_ZN5clang6driver10toolchains7FreeBSDD0Ev", "clang::driver::toolchains::FreeBSD::~FreeBSD()"),
	mu_demangle_test("_ZN5clang6driver10toolchains6NetBSDD1Ev", "clang::driver::toolchains::NetBSD::~NetBSD()"),
	mu_demangle_test("_ZN5clang6driver10toolchains6NetBSDD0Ev", "clang::driver::toolchains::NetBSD::~NetBSD()"),
	mu_demangle_test("_ZN5clang6driver10toolchains5MinixD1Ev", "clang::driver::toolchains::Minix::~Minix()"),
	mu_demangle_test("_ZN5clang6driver10toolchains5MinixD0Ev", "clang::driver::toolchains::Minix::~Minix()"),
	mu_demangle_test("_ZN5clang6driver10toolchains8AuroraUXD1Ev", "clang::driver::toolchains::AuroraUX::~AuroraUX()"),
	mu_demangle_test("_ZN5clang6driver10toolchains8AuroraUXD0Ev", "clang::driver::toolchains::AuroraUX::~AuroraUX()"),
	mu_demangle_test("_ZN5clang6driver10toolchains5LinuxD1Ev", "clang::driver::toolchains::Linux::~Linux()"),
	mu_demangle_test("_ZN5clang6driver10toolchains5LinuxD0Ev", "clang::driver::toolchains::Linux::~Linux()"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DragonFlyD1Ev", "clang::driver::toolchains::DragonFly::~DragonFly()"),
	mu_demangle_test("_ZN5clang6driver10toolchains9DragonFlyD0Ev", "clang::driver::toolchains::DragonFly::~DragonFly()"),
	mu_demangle_test("_ZN5clang6driver10toolchains7WindowsD1Ev", "clang::driver::toolchains::Windows::~Windows()"),
	mu_demangle_test("_ZN5clang6driver10toolchains7WindowsD0Ev", "clang::driver::toolchains::Windows::~Windows()"),
	mu_demangle_test("_ZN4llvm8DenseMapIjPN5clang6driver4ToolENS_12DenseMapInfoIjEENS5_IS4_EEE16InsertIntoBucketERKjRKS4_PSt4pairIjS4_E", "llvm::DenseMap<unsigned int, clang::driver::Tool*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::Tool*> >::InsertIntoBucket(unsigned int const&, clang::driver::Tool* const&, std::pair<unsigned int, clang::driver::Tool*>*)"),
	mu_demangle_test("_ZN4llvm8DenseMapIjPN5clang6driver4ToolENS_12DenseMapInfoIjEENS5_IS4_EEE4growEj", "llvm::DenseMap<unsigned int, clang::driver::Tool*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::Tool*> >::grow(unsigned int)"),
	mu_demangle_test("_ZN5clang6driver10toolchains11Generic_ELFD1Ev", "clang::driver::toolchains::Generic_ELF::~Generic_ELF()"),
	mu_demangle_test("_ZN5clang6driver10toolchains11Generic_ELFD0Ev", "clang::driver::toolchains::Generic_ELF::~Generic_ELF()"),
	mu_demangle_test("_ZN5clang6driver10toolchains5LinuxD2Ev", "clang::driver::toolchains::Linux::~Linux()"),
	mu_demangle_test("_ZNK5clang6driver4Tool22hasIntegratedAssemblerEv", "clang::driver::Tool::hasIntegratedAssembler() const"),
	mu_demangle_test("_ZNK5clang6driver5tools12visualstudio4Link16hasIntegratedCPPEv", "clang::driver::tools::visualstudio::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver4Tool18hasGoodDiagnosticsEv", "clang::driver::Tool::hasGoodDiagnostics() const"),
	mu_demangle_test("_ZNK5clang6driver5tools9dragonfly4Link16hasIntegratedCPPEv", "clang::driver::tools::dragonfly::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools9dragonfly8Assemble16hasIntegratedCPPEv", "clang::driver::tools::dragonfly::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools10linuxtools4Link16hasIntegratedCPPEv", "clang::driver::tools::linuxtools::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools10linuxtools8Assemble16hasIntegratedCPPEv", "clang::driver::tools::linuxtools::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools8auroraux4Link16hasIntegratedCPPEv", "clang::driver::tools::auroraux::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools8auroraux8Assemble16hasIntegratedCPPEv", "clang::driver::tools::auroraux::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools5minix4Link16hasIntegratedCPPEv", "clang::driver::tools::minix::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools5minix8Assemble16hasIntegratedCPPEv", "clang::driver::tools::minix::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools6netbsd4Link16hasIntegratedCPPEv", "clang::driver::tools::netbsd::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools6netbsd8Assemble16hasIntegratedCPPEv", "clang::driver::tools::netbsd::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools7freebsd4Link16hasIntegratedCPPEv", "clang::driver::tools::freebsd::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools7freebsd8Assemble16hasIntegratedCPPEv", "clang::driver::tools::freebsd::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools7openbsd4Link16hasIntegratedCPPEv", "clang::driver::tools::openbsd::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools7openbsd8Assemble16hasIntegratedCPPEv", "clang::driver::tools::openbsd::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc4Link16hasIntegratedCPPEv", "clang::driver::tools::gcc::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc6CommonD1Ev", "clang::driver::tools::gcc::Common::~Common()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc6CommonD0Ev", "clang::driver::tools::gcc::Common::~Common()"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc8Assemble16hasIntegratedCPPEv", "clang::driver::tools::gcc::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc7Compile16hasIntegratedCPPEv", "clang::driver::tools::gcc::Compile::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc7Compile18hasGoodDiagnosticsEv", "clang::driver::tools::gcc::Compile::hasGoodDiagnostics() const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc10Precompile16hasIntegratedCPPEv", "clang::driver::tools::gcc::Precompile::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc10Precompile18hasGoodDiagnosticsEv", "clang::driver::tools::gcc::Precompile::hasGoodDiagnostics() const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc10Preprocess16hasIntegratedCPPEv", "clang::driver::tools::gcc::Preprocess::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc10Preprocess18hasGoodDiagnosticsEv", "clang::driver::tools::gcc::Preprocess::hasGoodDiagnostics() const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin8Dsymutil16hasIntegratedCPPEv", "clang::driver::tools::darwin::Dsymutil::hasIntegratedCPP() const"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin10DarwinToolD1Ev", "clang::driver::tools::darwin::DarwinTool::~DarwinTool()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin10DarwinToolD0Ev", "clang::driver::tools::darwin::DarwinTool::~DarwinTool()"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin4Lipo16hasIntegratedCPPEv", "clang::driver::tools::darwin::Lipo::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin4Link16hasIntegratedCPPEv", "clang::driver::tools::darwin::Link::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin8Assemble16hasIntegratedCPPEv", "clang::driver::tools::darwin::Assemble::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools7ClangAs22hasIntegratedAssemblerEv", "clang::driver::tools::ClangAs::hasIntegratedAssembler() const"),
	mu_demangle_test("_ZNK5clang6driver5tools7ClangAs16hasIntegratedCPPEv", "clang::driver::tools::ClangAs::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools7ClangAs18hasGoodDiagnosticsEv", "clang::driver::tools::ClangAs::hasGoodDiagnostics() const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC116hasIntegratedCPPEv", "clang::driver::tools::darwin::CC1::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC118hasGoodDiagnosticsEv", "clang::driver::tools::darwin::CC1::hasGoodDiagnostics() const"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin3CC1D1Ev", "clang::driver::tools::darwin::CC1::~CC1()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin3CC1D0Ev", "clang::driver::tools::darwin::CC1::~CC1()"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang22hasIntegratedAssemblerEv", "clang::driver::tools::Clang::hasIntegratedAssembler() const"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang16hasIntegratedCPPEv", "clang::driver::tools::Clang::hasIntegratedCPP() const"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang18hasGoodDiagnosticsEv", "clang::driver::tools::Clang::hasGoodDiagnostics() const"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang23AddPreprocessingOptionsERKNS0_6DriverERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS0_9InputInfoERKNSA_ISF_Lj4EEE", "clang::driver::tools::Clang::AddPreprocessingOptions(clang::driver::Driver const&, clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&) const"),
	mu_demangle_test("_Z25CheckPreprocessingOptionsRKN5clang6driver6DriverERKNS0_7ArgListE", "CheckPreprocessingOptions(clang::driver::Driver const&, clang::driver::ArgList const&)"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin3CC121getDependencyFileNameERKNS0_7ArgListERKN4llvm11SmallVectorINS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::getDependencyFileName(clang::driver::ArgList const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&)"),
	mu_demangle_test("_Z11QuoteTargetN4llvm9StringRefERNS_15SmallVectorImplIcEE", "QuoteTarget(llvm::StringRef, llvm::SmallVectorImpl<char>&)"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang16AddARMTargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddARMTargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_Z15getARMTargetCPURKN5clang6driver7ArgListERKN4llvm6TripleE", "getARMTargetCPU(clang::driver::ArgList const&, llvm::Triple const&)"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang17AddMIPSTargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddMIPSTargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang18AddSparcTargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddSparcTargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang16AddX86TargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddX86TargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools5Clang12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS8_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::Clang::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin3CC116getBaseInputNameERKNS0_7ArgListERKN4llvm11SmallVectorINS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::getBaseInputName(clang::driver::ArgList const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&)"),
	mu_demangle_test("_Z26CheckCodeGenerationOptionsRKN5clang6driver6DriverERKNS0_7ArgListE", "CheckCodeGenerationOptions(clang::driver::Driver const&, clang::driver::ArgList const&)"),
	mu_demangle_test("_ZNK5clang6driver5tools7ClangAs12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS8_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::ClangAs::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc6Common12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::gcc::Common::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc10Preprocess19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Preprocess::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc10Precompile19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Precompile::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc7Compile19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Compile::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc8Assemble19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Assemble::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools3gcc4Link19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Link::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC110getCC1NameENS0_5types2IDE", "clang::driver::tools::darwin::CC1::getCC1Name(clang::driver::types::ID) const"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin3CC116getBaseInputStemERKNS0_7ArgListERKN4llvm11SmallVectorINS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::getBaseInputStem(clang::driver::ArgList const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&)"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC110AddCC1ArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::CC1::AddCC1Args(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC117AddCC1OptionsArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS8_INS0_9InputInfoELj4EEERKSB_", "clang::driver::tools::darwin::CC1::AddCC1OptionsArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, llvm::SmallVector<char const*, 16u> const&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC117AddCPPOptionsArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS8_INS0_9InputInfoELj4EEERKSB_", "clang::driver::tools::darwin::CC1::AddCPPOptionsArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, llvm::SmallVector<char const*, 16u> const&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC123AddCPPUniqueOptionsArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS8_INS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::AddCPPUniqueOptionsArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin3CC110AddCPPArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::CC1::AddCPPArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin10Preprocess12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Preprocess::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin7Compile12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Compile::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin10DarwinTool13AddDarwinArchERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::DarwinTool::AddDarwinArch(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin4Link11AddLinkArgsERNS0_11CompilationERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::Link::AddLinkArgs(clang::driver::Compilation&, clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_Z15AddLinkerInputsRKN5clang6driver9ToolChainERKN4llvm11SmallVectorINS0_9InputInfoELj4EEERKNS0_7ArgListERNS5_IPKcLj16EEE", "AddLinkerInputs(clang::driver::ToolChain const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&)"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin4Lipo12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Lipo::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6darwin8Dsymutil12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Dsymutil::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools8auroraux8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::auroraux::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools8auroraux4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::auroraux::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools7openbsd8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::openbsd::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools7openbsd4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::openbsd::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools7freebsd8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::freebsd::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools7freebsd4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::freebsd::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6netbsd8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::netbsd::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools6netbsd4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::netbsd::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools10linuxtools8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::linuxtools::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools10linuxtools4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::linuxtools::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools5minix8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::minix::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools5minix4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::minix::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools9dragonfly8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::dragonfly::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools9dragonfly4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::dragonfly::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZNK5clang6driver5tools12visualstudio4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::visualstudio::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"),
	mu_demangle_test("_ZN5clang6driver5tools5ClangD1Ev", "clang::driver::tools::Clang::~Clang()"),
	mu_demangle_test("_ZN5clang6driver5tools5ClangD0Ev", "clang::driver::tools::Clang::~Clang()"),
	mu_demangle_test("_ZN5clang6driver5tools7ClangAsD1Ev", "clang::driver::tools::ClangAs::~ClangAs()"),
	mu_demangle_test("_ZN5clang6driver5tools7ClangAsD0Ev", "clang::driver::tools::ClangAs::~ClangAs()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc10PreprocessD1Ev", "clang::driver::tools::gcc::Preprocess::~Preprocess()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc10PreprocessD0Ev", "clang::driver::tools::gcc::Preprocess::~Preprocess()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc10PrecompileD1Ev", "clang::driver::tools::gcc::Precompile::~Precompile()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc10PrecompileD0Ev", "clang::driver::tools::gcc::Precompile::~Precompile()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc7CompileD1Ev", "clang::driver::tools::gcc::Compile::~Compile()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc7CompileD0Ev", "clang::driver::tools::gcc::Compile::~Compile()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc8AssembleD1Ev", "clang::driver::tools::gcc::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc8AssembleD0Ev", "clang::driver::tools::gcc::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc4LinkD1Ev", "clang::driver::tools::gcc::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools3gcc4LinkD0Ev", "clang::driver::tools::gcc::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin10PreprocessD1Ev", "clang::driver::tools::darwin::Preprocess::~Preprocess()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin10PreprocessD0Ev", "clang::driver::tools::darwin::Preprocess::~Preprocess()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin7CompileD1Ev", "clang::driver::tools::darwin::Compile::~Compile()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin7CompileD0Ev", "clang::driver::tools::darwin::Compile::~Compile()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin8AssembleD1Ev", "clang::driver::tools::darwin::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin8AssembleD0Ev", "clang::driver::tools::darwin::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin4LinkD1Ev", "clang::driver::tools::darwin::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin4LinkD0Ev", "clang::driver::tools::darwin::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin4LipoD1Ev", "clang::driver::tools::darwin::Lipo::~Lipo()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin4LipoD0Ev", "clang::driver::tools::darwin::Lipo::~Lipo()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin8DsymutilD1Ev", "clang::driver::tools::darwin::Dsymutil::~Dsymutil()"),
	mu_demangle_test("_ZN5clang6driver5tools6darwin8DsymutilD0Ev", "clang::driver::tools::darwin::Dsymutil::~Dsymutil()"),
	mu_demangle_test("_ZN5clang6driver5tools7openbsd8AssembleD1Ev", "clang::driver::tools::openbsd::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools7openbsd8AssembleD0Ev", "clang::driver::tools::openbsd::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools7openbsd4LinkD1Ev", "clang::driver::tools::openbsd::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools7openbsd4LinkD0Ev", "clang::driver::tools::openbsd::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools7freebsd8AssembleD1Ev", "clang::driver::tools::freebsd::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools7freebsd8AssembleD0Ev", "clang::driver::tools::freebsd::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools7freebsd4LinkD1Ev", "clang::driver::tools::freebsd::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools7freebsd4LinkD0Ev", "clang::driver::tools::freebsd::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools6netbsd8AssembleD1Ev", "clang::driver::tools::netbsd::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools6netbsd8AssembleD0Ev", "clang::driver::tools::netbsd::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools6netbsd4LinkD1Ev", "clang::driver::tools::netbsd::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools6netbsd4LinkD0Ev", "clang::driver::tools::netbsd::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools10linuxtools8AssembleD1Ev", "clang::driver::tools::linuxtools::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools10linuxtools8AssembleD0Ev", "clang::driver::tools::linuxtools::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools10linuxtools4LinkD1Ev", "clang::driver::tools::linuxtools::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools10linuxtools4LinkD0Ev", "clang::driver::tools::linuxtools::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools5minix8AssembleD1Ev", "clang::driver::tools::minix::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools5minix8AssembleD0Ev", "clang::driver::tools::minix::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools5minix4LinkD1Ev", "clang::driver::tools::minix::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools5minix4LinkD0Ev", "clang::driver::tools::minix::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools8auroraux8AssembleD1Ev", "clang::driver::tools::auroraux::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools8auroraux8AssembleD0Ev", "clang::driver::tools::auroraux::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools8auroraux4LinkD1Ev", "clang::driver::tools::auroraux::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools8auroraux4LinkD0Ev", "clang::driver::tools::auroraux::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools9dragonfly8AssembleD1Ev", "clang::driver::tools::dragonfly::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools9dragonfly8AssembleD0Ev", "clang::driver::tools::dragonfly::Assemble::~Assemble()"),
	mu_demangle_test("_ZN5clang6driver5tools9dragonfly4LinkD1Ev", "clang::driver::tools::dragonfly::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools9dragonfly4LinkD0Ev", "clang::driver::tools::dragonfly::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools12visualstudio4LinkD1Ev", "clang::driver::tools::visualstudio::Link::~Link()"),
	mu_demangle_test("_ZN5clang6driver5tools12visualstudio4LinkD0Ev", "clang::driver::tools::visualstudio::Link::~Link()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplISsEaSERKS1_", "llvm::SmallVectorImpl<std::string>::operator=(llvm::SmallVectorImpl<std::string> const&)"),
	mu_demangle_test("_ZN5clang6driver5types11getTypeNameENS1_2IDE", "clang::driver::types::getTypeName(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types19getPreprocessedTypeENS1_2IDE", "clang::driver::types::getPreprocessedType(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types17getTypeTempSuffixENS1_2IDE", "clang::driver::types::getTypeTempSuffix(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types16onlyAssembleTypeENS1_2IDE", "clang::driver::types::onlyAssembleType(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types18onlyPrecompileTypeENS1_2IDE", "clang::driver::types::onlyPrecompileType(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types22canTypeBeUserSpecifiedENS1_2IDE", "clang::driver::types::canTypeBeUserSpecified(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types19appendSuffixForTypeENS1_2IDE", "clang::driver::types::appendSuffixForType(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types11canLipoTypeENS1_2IDE", "clang::driver::types::canLipoType(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types17isAcceptedByClangENS1_2IDE", "clang::driver::types::isAcceptedByClang(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types21isOnlyAcceptedByClangENS1_2IDE", "clang::driver::types::isOnlyAcceptedByClang(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types6isObjCENS1_2IDE", "clang::driver::types::isObjC(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types5isCXXENS1_2IDE", "clang::driver::types::isCXX(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types22lookupTypeForExtensionEPKc", "clang::driver::types::lookupTypeForExtension(char const*)"),
	mu_demangle_test("_ZN5clang6driver5types26lookupTypeForTypeSpecifierEPKc", "clang::driver::types::lookupTypeForTypeSpecifier(char const*)"),
	mu_demangle_test("_ZN5clang6driver5types23getNumCompilationPhasesENS1_2IDE", "clang::driver::types::getNumCompilationPhases(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang6driver5types19getCompilationPhaseENS1_2IDEj", "clang::driver::types::getCompilationPhase(clang::driver::types::ID, unsigned int)"),
	mu_demangle_test("_ZN5clang6driver5types21lookupCXXTypeForCTypeENS1_2IDE", "clang::driver::types::lookupCXXTypeForCType(clang::driver::types::ID)"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListenerD0Ev", "clang::ASTDeserializationListener::~ASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListenerD1Ev", "clang::ASTDeserializationListener::~ASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang26ASTDeserializationListenerD2Ev", "clang::ASTDeserializationListener::~ASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang13serialization18TypeIdxFromBuiltinEPKNS_11BuiltinTypeE", "clang::serialization::TypeIdxFromBuiltin(clang::BuiltinType const*)"),
	mu_demangle_test("_ZN5clang13serialization11ComputeHashENS_8SelectorE", "clang::serialization::ComputeHash(clang::Selector)"),
	mu_demangle_test("_ZN5clang17ASTReaderListenerD0Ev", "clang::ASTReaderListener::~ASTReaderListener()"),
	mu_demangle_test("_ZN5clang17ASTReaderListenerD1Ev", "clang::ASTReaderListener::~ASTReaderListener()"),
	mu_demangle_test("_ZN5clang17ASTReaderListenerD2Ev", "clang::ASTReaderListener::~ASTReaderListener()"),
	mu_demangle_test("_ZN5clang12PCHValidator19ReadLanguageOptionsERKNS_11LangOptionsE", "clang::PCHValidator::ReadLanguageOptions(clang::LangOptions const&)"),
	mu_demangle_test("_ZN5clang9ASTReader4DiagEj", "clang::ASTReader::Diag(unsigned int)"),
	mu_demangle_test("_ZN5clang12PCHValidator16ReadTargetTripleEN4llvm9StringRefE", "clang::PCHValidator::ReadTargetTriple(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang12PCHValidator20ReadPredefinesBufferERKN4llvm11SmallVectorINS_18PCHPredefinesBlockELj2EEENS1_9StringRefERSs", "clang::PCHValidator::ReadPredefinesBuffer(llvm::SmallVector<clang::PCHPredefinesBlock, 2u> const&, llvm::StringRef, std::string&)"),
	mu_demangle_test("_ZN5clang9ASTReader4DiagENS_14SourceLocationEj", "clang::ASTReader::Diag(clang::SourceLocation, unsigned int)"),
	mu_demangle_test("_ZN5clang12PCHValidator18ReadHeaderFileInfoERKNS_14HeaderFileInfoEj", "clang::PCHValidator::ReadHeaderFileInfo(clang::HeaderFileInfo const&, unsigned int)"),
	mu_demangle_test("_ZN5clang12PCHValidator11ReadCounterEj", "clang::PCHValidator::ReadCounter(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader26setDeserializationListenerEPNS_26ASTDeserializationListenerE", "clang::ASTReader::setDeserializationListener(clang::ASTDeserializationListener*)"),
	mu_demangle_test("_ZN5clang9ASTReader22ReadDeclContextStorageERN4llvm15BitstreamCursorERKSt4pairIyyERNS0_15DeclContextInfoE", "clang::ASTReader::ReadDeclContextStorage(llvm::BitstreamCursor&, std::pair<uint64_t, uint64_t> const&, clang::ASTReader::DeclContextInfo&)"),
	mu_demangle_test("_ZN5clang9ASTReader5ErrorEPKc", "clang::ASTReader::Error(char const*)"),
	mu_demangle_test("_ZN5clang9ASTReader22CheckPredefinesBuffersEv", "clang::ASTReader::CheckPredefinesBuffers()"),
	mu_demangle_test("_ZN5clang9ASTReader14ParseLineTableERNS0_11PerFileDataERN4llvm15SmallVectorImplIyEE", "clang::ASTReader::ParseLineTable(clang::ASTReader::PerFileData&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTReader28MaybeAddSystemRootToFilenameERSs", "clang::ASTReader::MaybeAddSystemRootToFilename(std::string&)"),
	mu_demangle_test("_ZN5clang9ASTReader22ReadSourceManagerBlockERNS0_11PerFileDataE", "clang::ASTReader::ReadSourceManagerBlock(clang::ASTReader::PerFileData&)"),
	mu_demangle_test("_ZN5clang9ASTReader15SLocCursorForIDEj", "clang::ASTReader::SLocCursorForID(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader19ReadSLocEntryRecordEj", "clang::ASTReader::ReadSLocEntryRecord(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader16ReadBlockAbbrevsERN4llvm15BitstreamCursorEj", "clang::ASTReader::ReadBlockAbbrevs(llvm::BitstreamCursor&, unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader15ReadMacroRecordERNS0_11PerFileDataEy", "clang::ASTReader::ReadMacroRecord(clang::ASTReader::PerFileData&, uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader20DecodeIdentifierInfoEj", "clang::ASTReader::DecodeIdentifierInfo(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader18getMacroDefinitionEj", "clang::ASTReader::getMacroDefinition(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader22LoadPreprocessedEntityERNS0_11PerFileDataE", "clang::ASTReader::LoadPreprocessedEntity(clang::ASTReader::PerFileData&)"),
	mu_demangle_test("_ZN5clang9ASTReader20SetIdentifierIsMacroEPNS_14IdentifierInfoERNS0_11PerFileDataEy", "clang::ASTReader::SetIdentifierIsMacro(clang::IdentifierInfo*, clang::ASTReader::PerFileData&, uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader17ReadDefinedMacrosEv", "clang::ASTReader::ReadDefinedMacros()"),
	mu_demangle_test("_ZN5clang9ASTReader19LoadMacroDefinitionEN4llvm16DenseMapIteratorIPNS_14IdentifierInfoEyNS1_12DenseMapInfoIS4_EENS5_IyEELb0EEE", "clang::ASTReader::LoadMacroDefinition(llvm::DenseMapIterator<clang::IdentifierInfo*, uint64_t, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<uint64_t>, false>)"),
	mu_demangle_test("_ZN5clang9ASTReader19LoadMacroDefinitionEPNS_14IdentifierInfoE", "clang::ASTReader::LoadMacroDefinition(clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang9ASTReader12ReadASTBlockERNS0_11PerFileDataE", "clang::ASTReader::ReadASTBlock(clang::ASTReader::PerFileData&)"),
	mu_demangle_test("_ZN5clang9ASTReader11ReadASTCoreEN4llvm9StringRefENS0_11ASTFileTypeE", "clang::ASTReader::ReadASTCore(llvm::StringRef, clang::ASTReader::ASTFileType)"),
	mu_demangle_test("_ZN5clang9ASTReader20ParseLanguageOptionsERKN4llvm15SmallVectorImplIyEE", "clang::ASTReader::ParseLanguageOptions(llvm::SmallVectorImpl<uint64_t> const&)"),
	mu_demangle_test("_ZN5clang9ASTReader7ReadASTERKSsNS0_11ASTFileTypeE", "clang::ASTReader::ReadAST(std::string const&, clang::ASTReader::ASTFileType)"),
	mu_demangle_test("_ZN5clang9ASTReader17InitializeContextERNS_10ASTContextE", "clang::ASTReader::InitializeContext(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang9ASTReader11PerFileDataC1ENS0_11ASTFileTypeE", "clang::ASTReader::PerFileData::PerFileData(clang::ASTReader::ASTFileType)"),
	mu_demangle_test("_ZN5clang9ASTReader15setPreprocessorERNS_12PreprocessorE", "clang::ASTReader::setPreprocessor(clang::Preprocessor&)"),
	mu_demangle_test("_ZN5clang9ASTReader22GetTranslationUnitDeclEv", "clang::ASTReader::GetTranslationUnitDecl()"),
	mu_demangle_test("_ZN5clang9ASTReader7GetTypeEj", "clang::ASTReader::GetType(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader28ReadPragmaDiagnosticMappingsERNS_10DiagnosticE", "clang::ASTReader::ReadPragmaDiagnosticMappings(clang::Diagnostic&)"),
	mu_demangle_test("_ZN5clang9ASTReader7GetDeclEj", "clang::ASTReader::GetDecl(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader21getOriginalSourceFileERKSsRNS_11FileManagerERNS_10DiagnosticE", "clang::ASTReader::getOriginalSourceFile(std::string const&, clang::FileManager&, clang::Diagnostic&)"),
	mu_demangle_test("_ZThn8_N5clang9ASTReader24ReadPreprocessedEntitiesEv", "non-virtual thunk to clang::ASTReader::ReadPreprocessedEntities()"),
	mu_demangle_test("_ZN5clang9ASTReader24ReadPreprocessedEntitiesEv", "clang::ASTReader::ReadPreprocessedEntities()"),
	mu_demangle_test("_ZThn8_N5clang9ASTReader22ReadPreprocessedEntityEy", "non-virtual thunk to clang::ASTReader::ReadPreprocessedEntity(uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader22ReadPreprocessedEntityEy", "clang::ASTReader::ReadPreprocessedEntity(uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader18TypeCursorForIndexEj", "clang::ASTReader::TypeCursorForIndex(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader14ReadTypeRecordEj", "clang::ASTReader::ReadTypeRecord(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader9ReadAPIntERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadAPInt(llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader23ReadNestedNameSpecifierERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadNestedNameSpecifier(llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader20ReadTemplateArgumentERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateArgument(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader15ReadSourceRangeERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadSourceRange(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader16ReadTemplateNameERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateName(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader24ReadTemplateArgumentListERN4llvm11SmallVectorINS_16TemplateArgumentELj8EEERNS0_11PerFileDataERKNS2_IyLj64EEERj", "clang::ASTReader::ReadTemplateArgumentList(llvm::SmallVector<clang::TemplateArgument, 8u>&, clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang13TypeLocReader21VisitQualifiedTypeLocENS_16QualifiedTypeLocE", "clang::TypeLocReader::VisitQualifiedTypeLoc(clang::QualifiedTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader19VisitBuiltinTypeLocENS_14BuiltinTypeLocE", "clang::TypeLocReader::VisitBuiltinTypeLoc(clang::BuiltinTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader19VisitComplexTypeLocENS_14ComplexTypeLocE", "clang::TypeLocReader::VisitComplexTypeLoc(clang::ComplexTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader19VisitPointerTypeLocENS_14PointerTypeLocE", "clang::TypeLocReader::VisitPointerTypeLoc(clang::PointerTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader24VisitBlockPointerTypeLocENS_19BlockPointerTypeLocE", "clang::TypeLocReader::VisitBlockPointerTypeLoc(clang::BlockPointerTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader27VisitLValueReferenceTypeLocENS_22LValueReferenceTypeLocE", "clang::TypeLocReader::VisitLValueReferenceTypeLoc(clang::LValueReferenceTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader27VisitRValueReferenceTypeLocENS_22RValueReferenceTypeLocE", "clang::TypeLocReader::VisitRValueReferenceTypeLoc(clang::RValueReferenceTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader25VisitMemberPointerTypeLocENS_20MemberPointerTypeLocE", "clang::TypeLocReader::VisitMemberPointerTypeLoc(clang::MemberPointerTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader17VisitArrayTypeLocENS_12ArrayTypeLocE", "clang::TypeLocReader::VisitArrayTypeLoc(clang::ArrayTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader25VisitConstantArrayTypeLocENS_20ConstantArrayTypeLocE", "clang::TypeLocReader::VisitConstantArrayTypeLoc(clang::ConstantArrayTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader27VisitIncompleteArrayTypeLocENS_22IncompleteArrayTypeLocE", "clang::TypeLocReader::VisitIncompleteArrayTypeLoc(clang::IncompleteArrayTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader25VisitVariableArrayTypeLocENS_20VariableArrayTypeLocE", "clang::TypeLocReader::VisitVariableArrayTypeLoc(clang::VariableArrayTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader31VisitDependentSizedArrayTypeLocENS_26DependentSizedArrayTypeLocE", "clang::TypeLocReader::VisitDependentSizedArrayTypeLoc(clang::DependentSizedArrayTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader35VisitDependentSizedExtVectorTypeLocENS_30DependentSizedExtVectorTypeLocE", "clang::TypeLocReader::VisitDependentSizedExtVectorTypeLoc(clang::DependentSizedExtVectorTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader18VisitVectorTypeLocENS_13VectorTypeLocE", "clang::TypeLocReader::VisitVectorTypeLoc(clang::VectorTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader21VisitExtVectorTypeLocENS_16ExtVectorTypeLocE", "clang::TypeLocReader::VisitExtVectorTypeLoc(clang::ExtVectorTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader20VisitFunctionTypeLocENS_15FunctionTypeLocE", "clang::TypeLocReader::VisitFunctionTypeLoc(clang::FunctionTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader25VisitFunctionProtoTypeLocENS_20FunctionProtoTypeLocE", "clang::TypeLocReader::VisitFunctionProtoTypeLoc(clang::FunctionProtoTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader27VisitFunctionNoProtoTypeLocENS_22FunctionNoProtoTypeLocE", "clang::TypeLocReader::VisitFunctionNoProtoTypeLoc(clang::FunctionNoProtoTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader27VisitUnresolvedUsingTypeLocENS_22UnresolvedUsingTypeLocE", "clang::TypeLocReader::VisitUnresolvedUsingTypeLoc(clang::UnresolvedUsingTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader19VisitTypedefTypeLocENS_14TypedefTypeLocE", "clang::TypeLocReader::VisitTypedefTypeLoc(clang::TypedefTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader22VisitTypeOfExprTypeLocENS_17TypeOfExprTypeLocE", "clang::TypeLocReader::VisitTypeOfExprTypeLoc(clang::TypeOfExprTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader18VisitTypeOfTypeLocENS_13TypeOfTypeLocE", "clang::TypeLocReader::VisitTypeOfTypeLoc(clang::TypeOfTypeLoc)"),
	mu_demangle_test("_ZN5clang9ASTReader17GetTypeSourceInfoERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::GetTypeSourceInfo(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang13TypeLocReader20VisitDecltypeTypeLocENS_15DecltypeTypeLocE", "clang::TypeLocReader::VisitDecltypeTypeLoc(clang::DecltypeTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader18VisitRecordTypeLocENS_13RecordTypeLocE", "clang::TypeLocReader::VisitRecordTypeLoc(clang::RecordTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader16VisitEnumTypeLocENS_11EnumTypeLocE", "clang::TypeLocReader::VisitEnumTypeLoc(clang::EnumTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader22VisitAttributedTypeLocENS_17AttributedTypeLocE", "clang::TypeLocReader::VisitAttributedTypeLoc(clang::AttributedTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader28VisitTemplateTypeParmTypeLocENS_23TemplateTypeParmTypeLocE", "clang::TypeLocReader::VisitTemplateTypeParmTypeLoc(clang::TemplateTypeParmTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader33VisitSubstTemplateTypeParmTypeLocENS_28SubstTemplateTypeParmTypeLocE", "clang::TypeLocReader::VisitSubstTemplateTypeParmTypeLoc(clang::SubstTemplateTypeParmTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader37VisitSubstTemplateTypeParmPackTypeLocENS_32SubstTemplateTypeParmPackTypeLocE", "clang::TypeLocReader::VisitSubstTemplateTypeParmPackTypeLoc(clang::SubstTemplateTypeParmPackTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader34VisitTemplateSpecializationTypeLocENS_29TemplateSpecializationTypeLocE", "clang::TypeLocReader::VisitTemplateSpecializationTypeLoc(clang::TemplateSpecializationTypeLoc)"),
	mu_demangle_test("_ZN5clang9ASTReader26GetTemplateArgumentLocInfoERNS0_11PerFileDataENS_16TemplateArgument7ArgKindERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::GetTemplateArgumentLocInfo(clang::ASTReader::PerFileData&, clang::TemplateArgument::ArgKind, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang13TypeLocReader17VisitParenTypeLocENS_12ParenTypeLocE", "clang::TypeLocReader::VisitParenTypeLoc(clang::ParenTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader22VisitElaboratedTypeLocENS_17ElaboratedTypeLocE", "clang::TypeLocReader::VisitElaboratedTypeLoc(clang::ElaboratedTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader29VisitInjectedClassNameTypeLocENS_24InjectedClassNameTypeLocE", "clang::TypeLocReader::VisitInjectedClassNameTypeLoc(clang::InjectedClassNameTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader25VisitDependentNameTypeLocENS_20DependentNameTypeLocE", "clang::TypeLocReader::VisitDependentNameTypeLoc(clang::DependentNameTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader43VisitDependentTemplateSpecializationTypeLocENS_38DependentTemplateSpecializationTypeLocE", "clang::TypeLocReader::VisitDependentTemplateSpecializationTypeLoc(clang::DependentTemplateSpecializationTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader25VisitPackExpansionTypeLocENS_20PackExpansionTypeLocE", "clang::TypeLocReader::VisitPackExpansionTypeLoc(clang::PackExpansionTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader25VisitObjCInterfaceTypeLocENS_20ObjCInterfaceTypeLocE", "clang::TypeLocReader::VisitObjCInterfaceTypeLoc(clang::ObjCInterfaceTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader22VisitObjCObjectTypeLocENS_17ObjCObjectTypeLocE", "clang::TypeLocReader::VisitObjCObjectTypeLoc(clang::ObjCObjectTypeLoc)"),
	mu_demangle_test("_ZN5clang13TypeLocReader29VisitObjCObjectPointerTypeLocENS_24ObjCObjectPointerTypeLocE", "clang::TypeLocReader::VisitObjCObjectPointerTypeLoc(clang::ObjCObjectPointerTypeLoc)"),
	mu_demangle_test("_ZNK5clang9ASTReader9GetTypeIDENS_8QualTypeE", "clang::ASTReader::GetTypeID(clang::QualType) const"),
	mu_demangle_test("_ZNK5clang9ASTReader10GetTypeIdxENS_8QualTypeE", "clang::ASTReader::GetTypeIdx(clang::QualType) const"),
	mu_demangle_test("_ZNK5clang9ASTReader28getTotalNumCXXBaseSpecifiersEv", "clang::ASTReader::getTotalNumCXXBaseSpecifiers() const"),
	mu_demangle_test("_ZN5clang9ASTReader23ReadTemplateArgumentLocERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateArgumentLoc(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader15GetExternalDeclEj", "non-virtual thunk to clang::ASTReader::GetExternalDecl(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader15GetExternalDeclEj", "clang::ASTReader::GetExternalDecl(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader26GetCXXBaseSpecifiersOffsetEj", "clang::ASTReader::GetCXXBaseSpecifiersOffset(unsigned int)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader28GetExternalCXXBaseSpecifiersEy", "non-virtual thunk to clang::ASTReader::GetExternalCXXBaseSpecifiers(uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader28GetExternalCXXBaseSpecifiersEy", "clang::ASTReader::GetExternalCXXBaseSpecifiers(uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader20ReadCXXBaseSpecifierERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadCXXBaseSpecifier(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader19GetExternalDeclStmtEy", "non-virtual thunk to clang::ASTReader::GetExternalDeclStmt(uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader19GetExternalDeclStmtEy", "clang::ASTReader::GetExternalDeclStmt(uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTReader18ClearSwitchCaseIDsEv", "clang::ASTReader::ClearSwitchCaseIDs()"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader24FindExternalLexicalDeclsEPKNS_11DeclContextEPFbNS_4Decl4KindEERN4llvm15SmallVectorImplIPS4_EE", "non-virtual thunk to clang::ASTReader::FindExternalLexicalDecls(clang::DeclContext const*, bool (*)(clang::Decl::Kind), llvm::SmallVectorImpl<clang::Decl*>&)"),
	mu_demangle_test("_ZN5clang9ASTReader24FindExternalLexicalDeclsEPKNS_11DeclContextEPFbNS_4Decl4KindEERN4llvm15SmallVectorImplIPS4_EE", "clang::ASTReader::FindExternalLexicalDecls(clang::DeclContext const*, bool (*)(clang::Decl::Kind), llvm::SmallVectorImpl<clang::Decl*>&)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader30FindExternalVisibleDeclsByNameEPKNS_11DeclContextENS_15DeclarationNameE", "non-virtual thunk to clang::ASTReader::FindExternalVisibleDeclsByName(clang::DeclContext const*, clang::DeclarationName)"),
	mu_demangle_test("_ZN5clang9ASTReader30FindExternalVisibleDeclsByNameEPKNS_11DeclContextENS_15DeclarationNameE", "clang::ASTReader::FindExternalVisibleDeclsByName(clang::DeclContext const*, clang::DeclarationName)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader23MaterializeVisibleDeclsEPKNS_11DeclContextE", "non-virtual thunk to clang::ASTReader::MaterializeVisibleDecls(clang::DeclContext const*)"),
	mu_demangle_test("_ZN5clang9ASTReader23MaterializeVisibleDeclsEPKNS_11DeclContextE", "clang::ASTReader::MaterializeVisibleDecls(clang::DeclContext const*)"),
	mu_demangle_test("_ZN5clang9ASTReader30PassInterestingDeclsToConsumerEv", "clang::ASTReader::PassInterestingDeclsToConsumer()"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader20StartTranslationUnitEPNS_11ASTConsumerE", "non-virtual thunk to clang::ASTReader::StartTranslationUnit(clang::ASTConsumer*)"),
	mu_demangle_test("_ZN5clang9ASTReader20StartTranslationUnitEPNS_11ASTConsumerE", "clang::ASTReader::StartTranslationUnit(clang::ASTConsumer*)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader10PrintStatsEv", "non-virtual thunk to clang::ASTReader::PrintStats()"),
	mu_demangle_test("_ZN5clang9ASTReader10PrintStatsEv", "clang::ASTReader::PrintStats()"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader14InitializeSemaERNS_4SemaE", "non-virtual thunk to clang::ASTReader::InitializeSema(clang::Sema&)"),
	mu_demangle_test("_ZN5clang9ASTReader14InitializeSemaERNS_4SemaE", "clang::ASTReader::InitializeSema(clang::Sema&)"),
	mu_demangle_test("_ZN5clang9ASTReader14DecodeSelectorEj", "clang::ASTReader::DecodeSelector(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader3getEPKcS2_", "clang::ASTReader::get(char const*, char const*)"),
	mu_demangle_test("_ZN5clang21ASTIdentifierIteratorC1ERKNS_9ASTReaderE", "clang::ASTIdentifierIterator::ASTIdentifierIterator(clang::ASTReader const&)"),
	mu_demangle_test("_ZN5clang21ASTIdentifierIteratorC2ERKNS_9ASTReaderE", "clang::ASTIdentifierIterator::ASTIdentifierIterator(clang::ASTReader const&)"),
	mu_demangle_test("_ZN5clang21ASTIdentifierIterator4NextEv", "clang::ASTIdentifierIterator::Next()"),
	mu_demangle_test("_ZThn32_NK5clang9ASTReader14getIdentifiersEv", "non-virtual thunk to clang::ASTReader::getIdentifiers() const"),
	mu_demangle_test("_ZNK5clang9ASTReader14getIdentifiersEv", "clang::ASTReader::getIdentifiers() const"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader14ReadMethodPoolENS_8SelectorE", "non-virtual thunk to clang::ASTReader::ReadMethodPool(clang::Selector)"),
	mu_demangle_test("_ZN5clang9ASTReader14ReadMethodPoolENS_8SelectorE", "clang::ASTReader::ReadMethodPool(clang::Selector)"),
	mu_demangle_test("_ZN5clang9ASTReader12LoadSelectorENS_8SelectorE", "clang::ASTReader::LoadSelector(clang::Selector)"),
	mu_demangle_test("_ZN5clang9ASTReader17SetIdentifierInfoEjPNS_14IdentifierInfoE", "clang::ASTReader::SetIdentifierInfo(unsigned int, clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang9ASTReader23SetGloballyVisibleDeclsEPNS_14IdentifierInfoERKN4llvm15SmallVectorImplIjEEb", "clang::ASTReader::SetGloballyVisibleDecls(clang::IdentifierInfo*, llvm::SmallVectorImpl<unsigned int> const&, bool)"),
	mu_demangle_test("_ZThn48_N5clang9ASTReader13ReadSLocEntryEj", "non-virtual thunk to clang::ASTReader::ReadSLocEntry(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader13ReadSLocEntryEj", "clang::ASTReader::ReadSLocEntry(unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122ASTSelectorLookupTrait7ReadKeyEPKhj", "(anonymous namespace)::ASTSelectorLookupTrait::ReadKey(unsigned char const*, unsigned int)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader19GetExternalSelectorEj", "non-virtual thunk to clang::ASTReader::GetExternalSelector(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader19GetExternalSelectorEj", "clang::ASTReader::GetExternalSelector(unsigned int)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader23GetNumExternalSelectorsEv", "non-virtual thunk to clang::ASTReader::GetNumExternalSelectors()"),
	mu_demangle_test("_ZN5clang9ASTReader23GetNumExternalSelectorsEv", "clang::ASTReader::GetNumExternalSelectors()"),
	mu_demangle_test("_ZN5clang9ASTReader19ReadDeclarationNameERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadDeclarationName(llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader22ReadDeclarationNameLocERNS0_11PerFileDataERNS_18DeclarationNameLocENS_15DeclarationNameERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadDeclarationNameLoc(clang::ASTReader::PerFileData&, clang::DeclarationNameLoc&, clang::DeclarationName, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader23ReadDeclarationNameInfoERNS0_11PerFileDataERNS_19DeclarationNameInfoERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadDeclarationNameInfo(clang::ASTReader::PerFileData&, clang::DeclarationNameInfo&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader17ReadQualifierInfoERNS0_11PerFileDataERNS_13QualifierInfoERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadQualifierInfo(clang::ASTReader::PerFileData&, clang::QualifierInfo&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader25ReadTemplateParameterListERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateParameterList(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader10ReadAPSIntERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadAPSInt(llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader17ReadUnresolvedSetERNS_17UnresolvedSetImplERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadUnresolvedSet(clang::UnresolvedSetImpl&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader23ReadCXXCtorInitializersERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadCXXCtorInitializers(clang::ASTReader::PerFileData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader11ReadAPFloatERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadAPFloat(llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader10ReadStringERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadString(llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader16ReadCXXTemporaryERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadCXXTemporary(llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang9ASTReader18getIdentifierTableEv", "clang::ASTReader::getIdentifierTable()"),
	mu_demangle_test("_ZN5clang9ASTReader18RecordSwitchCaseIDEPNS_10SwitchCaseEj", "clang::ASTReader::RecordSwitchCaseID(clang::SwitchCase*, unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader19getSwitchCaseWithIDEj", "clang::ASTReader::getSwitchCaseWithID(unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader15RecordLabelStmtEPNS_9LabelStmtEj", "clang::ASTReader::RecordLabelStmt(clang::LabelStmt*, unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader10SetLabelOfEPNS_8GotoStmtEj", "clang::ASTReader::SetLabelOf(clang::GotoStmt*, unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader10SetLabelOfEPNS_13AddrLabelExprEj", "clang::ASTReader::SetLabelOf(clang::AddrLabelExpr*, unsigned int)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader21FinishedDeserializingEv", "non-virtual thunk to clang::ASTReader::FinishedDeserializing()"),
	mu_demangle_test("_ZN5clang9ASTReader21FinishedDeserializingEv", "clang::ASTReader::FinishedDeserializing()"),
	mu_demangle_test("_ZN5clang9ASTReaderC1ERNS_12PreprocessorEPNS_10ASTContextEPKcbb", "clang::ASTReader::ASTReader(clang::Preprocessor&, clang::ASTContext*, char const*, bool, bool)"),
	mu_demangle_test("_ZN5clang9ASTReaderC2ERNS_12PreprocessorEPNS_10ASTContextEPKcbb", "clang::ASTReader::ASTReader(clang::Preprocessor&, clang::ASTContext*, char const*, bool, bool)"),
	mu_demangle_test("_ZN5clang9ASTReaderC1ERNS_13SourceManagerERNS_11FileManagerERNS_10DiagnosticEPKcbb", "clang::ASTReader::ASTReader(clang::SourceManager&, clang::FileManager&, clang::Diagnostic&, char const*, bool, bool)"),
	mu_demangle_test("_ZN5clang9ASTReaderC2ERNS_13SourceManagerERNS_11FileManagerERNS_10DiagnosticEPKcbb", "clang::ASTReader::ASTReader(clang::SourceManager&, clang::FileManager&, clang::Diagnostic&, char const*, bool, bool)"),
	mu_demangle_test("_ZThn8_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZN5clang9ASTReaderD0Ev", "clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn16_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn32_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn40_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn48_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZN5clang9ASTReaderD1Ev", "clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn8_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn16_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn32_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn40_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZThn48_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZN5clang9ASTReaderD2Ev", "clang::ASTReader::~ASTReader()"),
	mu_demangle_test("_ZN5clang9ASTReader11PerFileDataD1Ev", "clang::ASTReader::PerFileData::~PerFileData()"),
	mu_demangle_test("_ZN5clang9ASTReader11PerFileDataC2ENS0_11ASTFileTypeE", "clang::ASTReader::PerFileData::PerFileData(clang::ASTReader::ASTFileType)"),
	mu_demangle_test("_ZN5clang9ASTReader11PerFileDataD2Ev", "clang::ASTReader::PerFileData::~PerFileData()"),
	mu_demangle_test("_ZN12_GLOBAL__N_129ASTDeclContextNameLookupTrait7ReadKeyEPKhj", "(anonymous namespace)::ASTDeclContextNameLookupTrait::ReadKey(unsigned char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_112ASTStatCacheD1Ev", "(anonymous namespace)::ASTStatCache::~ASTStatCache()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112ASTStatCacheD0Ev", "(anonymous namespace)::ASTStatCache::~ASTStatCache()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112ASTStatCache7getStatEPKcR4statPi", "(anonymous namespace)::ASTStatCache::getStat(char const*, stat&, int*)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor10ReadRecordEjRNS_15SmallVectorImplIyEEPPKcPj", "llvm::BitstreamCursor::ReadRecord(unsigned int, llvm::SmallVectorImpl<uint64_t>&, char const**, unsigned int*)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursoraSERKS0_", "llvm::BitstreamCursor::operator=(llvm::BitstreamCursor const&)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor9SkipBlockEv", "llvm::BitstreamCursor::SkipBlock()"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor13EnterSubBlockEjPj", "llvm::BitstreamCursor::EnterSubBlock(unsigned int, unsigned int*)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor14ReadSubBlockIDEv", "llvm::BitstreamCursor::ReadSubBlockID()"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor16ReadAbbrevRecordEv", "llvm::BitstreamCursor::ReadAbbrevRecord()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIyE4swapERS1_", "llvm::SmallVectorImpl<uint64_t>::swap(llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIyE6insertIPyEES3_S3_T_S4_", "uint64_t* llvm::SmallVectorImpl<uint64_t>::insert<uint64_t*>(uint64_t*, uint64_t*, uint64_t*)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPN5clang15MacroDefinitionEE6resizeEj", "llvm::SmallVectorImpl<clang::MacroDefinition*>::resize(unsigned int)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang8SelectorEE6resizeEj", "llvm::SmallVectorImpl<clang::Selector>::resize(unsigned int)"),
	mu_demangle_test("_ZN5clang22OnDiskChainedHashTableINS_24ASTIdentifierLookupTraitEE4findERKSt4pairIPKcjEPS1_", "clang::OnDiskChainedHashTable<clang::ASTIdentifierLookupTrait>::find(std::pair<char const*, unsigned int> const&, clang::ASTIdentifierLookupTrait*)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor4ReadEj", "llvm::BitstreamCursor::Read(unsigned int)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor18ReadBlockInfoBlockEv", "llvm::BitstreamCursor::ReadBlockInfoBlock()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang9ASTReader15DeclContextInfoEE4swapERS4_", "llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>::swap(llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>&)"),
	mu_demangle_test("_ZN5clang14TypeLocVisitorINS_13TypeLocReaderEvE5VisitENS_7TypeLocE", "clang::TypeLocVisitor<clang::TypeLocReader, void>::Visit(clang::TypeLoc)"),
	mu_demangle_test("_ZN5clang17ASTReaderListener19ReadLanguageOptionsERKNS_11LangOptionsE", "clang::ASTReaderListener::ReadLanguageOptions(clang::LangOptions const&)"),
	mu_demangle_test("_ZN5clang17ASTReaderListener16ReadTargetTripleEN4llvm9StringRefE", "clang::ASTReaderListener::ReadTargetTriple(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang17ASTReaderListener20ReadPredefinesBufferERKN4llvm11SmallVectorINS_18PCHPredefinesBlockELj2EEENS1_9StringRefERSs", "clang::ASTReaderListener::ReadPredefinesBuffer(llvm::SmallVector<clang::PCHPredefinesBlock, 2u> const&, llvm::StringRef, std::string&)"),
	mu_demangle_test("_ZN5clang17ASTReaderListener18ReadHeaderFileInfoERKNS_14HeaderFileInfoEj", "clang::ASTReaderListener::ReadHeaderFileInfo(clang::HeaderFileInfo const&, unsigned int)"),
	mu_demangle_test("_ZN5clang17ASTReaderListener11ReadCounterEj", "clang::ASTReaderListener::ReadCounter(unsigned int)"),
	mu_demangle_test("_ZN5clang12PCHValidatorD1Ev", "clang::PCHValidator::~PCHValidator()"),
	mu_demangle_test("_ZN5clang12PCHValidatorD0Ev", "clang::PCHValidator::~PCHValidator()"),
	mu_demangle_test("_ZN5clang9ASTReader20StartedDeserializingEv", "clang::ASTReader::StartedDeserializing()"),
	mu_demangle_test("_ZN5clang9ASTReader10ForgetSemaEv", "clang::ASTReader::ForgetSema()"),
	mu_demangle_test("_ZN5clang9ASTReader3getEN4llvm9StringRefE", "clang::ASTReader::get(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang9ASTReader13GetIdentifierEj", "clang::ASTReader::GetIdentifier(unsigned int)"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader20StartedDeserializingEv", "non-virtual thunk to clang::ASTReader::StartedDeserializing()"),
	mu_demangle_test("_ZThn16_N5clang9ASTReader10ForgetSemaEv", "non-virtual thunk to clang::ASTReader::ForgetSema()"),
	mu_demangle_test("_ZThn32_N5clang9ASTReader3getEN4llvm9StringRefE", "non-virtual thunk to clang::ASTReader::get(llvm::StringRef)"),
	mu_demangle_test("_ZThn40_N5clang9ASTReader13GetIdentifierEj", "non-virtual thunk to clang::ASTReader::GetIdentifier(unsigned int)"),
	mu_demangle_test("_ZN5clang21ASTIdentifierIteratorD1Ev", "clang::ASTIdentifierIterator::~ASTIdentifierIterator()"),
	mu_demangle_test("_ZN5clang21ASTIdentifierIteratorD0Ev", "clang::ASTIdentifierIterator::~ASTIdentifierIterator()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang9ASTReader15DeclContextInfoEEaSERKS4_", "llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>::operator=(llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo> const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang9ASTReader15DeclContextInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ASTReader::DeclContextInfo, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang24ASTIdentifierLookupTrait8ReadDataERKSt4pairIPKcjEPKhj", "clang::ASTIdentifierLookupTrait::ReadData(std::pair<char const*, unsigned int> const&, unsigned char const*, unsigned int)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPvEaSERKS2_", "llvm::SmallVectorImpl<void*>::operator=(llvm::SmallVectorImpl<void*> const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang18PCHPredefinesBlockELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::PCHPredefinesBlock, false>::grow(unsigned long)"),
	mu_demangle_test("_ZSt16__introsort_loopIPN4llvm9StringRefElEvT_S3_T0_", "void std::__introsort_loop<llvm::StringRef*, long>(llvm::StringRef*, llvm::StringRef*, long)"),
	mu_demangle_test("_ZSt22__final_insertion_sortIPN4llvm9StringRefEEvT_S3_", "void std::__final_insertion_sort<llvm::StringRef*>(llvm::StringRef*, llvm::StringRef*)"),
	mu_demangle_test("_ZSt16__insertion_sortIPN4llvm9StringRefEEvT_S3_", "void std::__insertion_sort<llvm::StringRef*>(llvm::StringRef*, llvm::StringRef*)"),
	mu_demangle_test("_ZSt21__unguarded_partitionIPN4llvm9StringRefES1_ET_S3_S3_T0_", "llvm::StringRef* std::__unguarded_partition<llvm::StringRef*, llvm::StringRef>(llvm::StringRef*, llvm::StringRef*, llvm::StringRef)"),
	mu_demangle_test("_ZSt8__medianIN4llvm9StringRefEERKT_S4_S4_S4_", "llvm::StringRef const& std::__median<llvm::StringRef>(llvm::StringRef const&, llvm::StringRef const&, llvm::StringRef const&)"),
	mu_demangle_test("_ZSt13__heap_selectIPN4llvm9StringRefEEvT_S3_S3_", "void std::__heap_select<llvm::StringRef*>(llvm::StringRef*, llvm::StringRef*, llvm::StringRef*)"),
	mu_demangle_test("_ZSt13__adjust_heapIPN4llvm9StringRefElS1_EvT_T0_S4_T1_", "void std::__adjust_heap<llvm::StringRef*, long, llvm::StringRef>(llvm::StringRef*, long, long, llvm::StringRef)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang18PCHPredefinesBlockEEaSERKS3_", "llvm::SmallVectorImpl<clang::PCHPredefinesBlock>::operator=(llvm::SmallVectorImpl<clang::PCHPredefinesBlock> const&)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplINS_9StringRefEEaSERKS2_", "llvm::SmallVectorImpl<llvm::StringRef>::operator=(llvm::SmallVectorImpl<llvm::StringRef> const&)"),
	mu_demangle_test("_ZN5clang18ExternalSemaSource14InitializeSemaERNS_4SemaE", "clang::ExternalSemaSource::InitializeSema(clang::Sema&)"),
	mu_demangle_test("_ZN5clang18ExternalSemaSource10ForgetSemaEv", "clang::ExternalSemaSource::ForgetSema()"),
	mu_demangle_test("_ZN4llvm15BitstreamReaderD2Ev", "llvm::BitstreamReader::~BitstreamReader()"),
	mu_demangle_test("_ZN4llvm15BitstreamReader9BlockInfoD2Ev", "llvm::BitstreamReader::BlockInfo::~BlockInfo()"),
	mu_demangle_test("_ZN4llvm15BitstreamReader20getOrCreateBlockInfoEj", "llvm::BitstreamReader::getOrCreateBlockInfo(unsigned int)"),
	mu_demangle_test("_ZSt24__uninitialized_copy_auxIPN4llvm15BitstreamReader9BlockInfoES3_ET0_T_S5_S4_St12__false_type", "llvm::BitstreamReader::BlockInfo* std::__uninitialized_copy_aux<llvm::BitstreamReader::BlockInfo*, llvm::BitstreamReader::BlockInfo*>(llvm::BitstreamReader::BlockInfo*, llvm::BitstreamReader::BlockInfo*, llvm::BitstreamReader::BlockInfo*, std::__false_type)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor9freeStateEv", "llvm::BitstreamCursor::freeState()"),
	mu_demangle_test("_ZN5clang19FileSystemStatCacheD1Ev", "clang::FileSystemStatCache::~FileSystemStatCache()"),
	mu_demangle_test("_ZN5clang19FileSystemStatCacheD0Ev", "clang::FileSystemStatCache::~FileSystemStatCache()"),
	mu_demangle_test("_ZN4llvm15BitstreamCursorD2Ev", "llvm::BitstreamCursor::~BitstreamCursor()"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseINS_15BitCodeAbbrevOpELb0EE4growEm", "llvm::SmallVectorTemplateBase<llvm::BitCodeAbbrevOp, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor13PopBlockScopeEv", "llvm::BitstreamCursor::PopBlockScope()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplINS_15BitstreamCursor5BlockEE9push_backERKS2_", "llvm::SmallVectorImpl<llvm::BitstreamCursor::Block>::push_back(llvm::BitstreamCursor::Block const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseINS_15BitstreamCursor5BlockELb0EE4growEm", "llvm::SmallVectorTemplateBase<llvm::BitstreamCursor::Block, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseINS_15BitstreamCursor5BlockELb0EE18uninitialized_copyIPS2_S5_EEvT_S6_T0_", "void llvm::SmallVectorTemplateBase<llvm::BitstreamCursor::Block, false>::uninitialized_copy<llvm::BitstreamCursor::Block*, llvm::BitstreamCursor::Block*>(llvm::BitstreamCursor::Block*, llvm::BitstreamCursor::Block*, llvm::BitstreamCursor::Block*)"),
	mu_demangle_test("_ZN4llvm15BitstreamCursor20ReadAbbreviatedFieldERKNS_15BitCodeAbbrevOpERNS_15SmallVectorImplIyEE", "llvm::BitstreamCursor::ReadAbbreviatedField(llvm::BitCodeAbbrevOp const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22GetCurrentCursorOffsetEv", "clang::ASTDeclReader::GetCurrentCursorOffset()"),
	mu_demangle_test("_ZN5clang13ASTDeclReader5VisitEPNS_4DeclE", "clang::ASTDeclReader::Visit(clang::Decl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader9VisitDeclEPNS_4DeclE", "clang::ASTDeclReader::VisitDecl(clang::Decl*)"),
	mu_demangle_test("_ZN5clang9ASTReader14ReadAttributesERNS0_11PerFileDataERN4llvm11SmallVectorIPNS_4AttrELj2EEERKNS4_IyLj64EEERj", "clang::ASTReader::ReadAttributes(clang::ASTReader::PerFileData&, llvm::SmallVector<clang::Attr*, 2u>&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader24VisitTranslationUnitDeclEPNS_19TranslationUnitDeclE", "clang::ASTDeclReader::VisitTranslationUnitDecl(clang::TranslationUnitDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader14VisitNamedDeclEPNS_9NamedDeclE", "clang::ASTDeclReader::VisitNamedDecl(clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader13VisitTypeDeclEPNS_8TypeDeclE", "clang::ASTDeclReader::VisitTypeDecl(clang::TypeDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader16VisitTypedefDeclEPNS_11TypedefDeclE", "clang::ASTDeclReader::VisitTypedefDecl(clang::TypedefDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader12VisitTagDeclEPNS_7TagDeclE", "clang::ASTDeclReader::VisitTagDecl(clang::TagDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader13VisitEnumDeclEPNS_8EnumDeclE", "clang::ASTDeclReader::VisitEnumDecl(clang::EnumDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader15VisitRecordDeclEPNS_10RecordDeclE", "clang::ASTDeclReader::VisitRecordDecl(clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader14VisitValueDeclEPNS_9ValueDeclE", "clang::ASTDeclReader::VisitValueDecl(clang::ValueDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader21VisitEnumConstantDeclEPNS_16EnumConstantDeclE", "clang::ASTDeclReader::VisitEnumConstantDecl(clang::EnumConstantDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader19VisitDeclaratorDeclEPNS_14DeclaratorDeclE", "clang::ASTDeclReader::VisitDeclaratorDecl(clang::DeclaratorDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader17VisitFunctionDeclEPNS_12FunctionDeclE", "clang::ASTDeclReader::VisitFunctionDecl(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader19VisitObjCMethodDeclEPNS_14ObjCMethodDeclE", "clang::ASTDeclReader::VisitObjCMethodDecl(clang::ObjCMethodDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22VisitObjCContainerDeclEPNS_17ObjCContainerDeclE", "clang::ASTDeclReader::VisitObjCContainerDecl(clang::ObjCContainerDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22VisitObjCInterfaceDeclEPNS_17ObjCInterfaceDeclE", "clang::ASTDeclReader::VisitObjCInterfaceDecl(clang::ObjCInterfaceDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader17VisitObjCIvarDeclEPNS_12ObjCIvarDeclE", "clang::ASTDeclReader::VisitObjCIvarDecl(clang::ObjCIvarDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader14VisitFieldDeclEPNS_9FieldDeclE", "clang::ASTDeclReader::VisitFieldDecl(clang::FieldDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader21VisitObjCProtocolDeclEPNS_16ObjCProtocolDeclE", "clang::ASTDeclReader::VisitObjCProtocolDecl(clang::ObjCProtocolDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader24VisitObjCAtDefsFieldDeclEPNS_19ObjCAtDefsFieldDeclE", "clang::ASTDeclReader::VisitObjCAtDefsFieldDecl(clang::ObjCAtDefsFieldDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader18VisitObjCClassDeclEPNS_13ObjCClassDeclE", "clang::ASTDeclReader::VisitObjCClassDecl(clang::ObjCClassDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader28VisitObjCForwardProtocolDeclEPNS_23ObjCForwardProtocolDeclE", "clang::ASTDeclReader::VisitObjCForwardProtocolDecl(clang::ObjCForwardProtocolDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader21VisitObjCCategoryDeclEPNS_16ObjCCategoryDeclE", "clang::ASTDeclReader::VisitObjCCategoryDecl(clang::ObjCCategoryDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader28VisitObjCCompatibleAliasDeclEPNS_23ObjCCompatibleAliasDeclE", "clang::ASTDeclReader::VisitObjCCompatibleAliasDecl(clang::ObjCCompatibleAliasDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader21VisitObjCPropertyDeclEPNS_16ObjCPropertyDeclE", "clang::ASTDeclReader::VisitObjCPropertyDecl(clang::ObjCPropertyDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader17VisitObjCImplDeclEPNS_12ObjCImplDeclE", "clang::ASTDeclReader::VisitObjCImplDecl(clang::ObjCImplDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader25VisitObjCCategoryImplDeclEPNS_20ObjCCategoryImplDeclE", "clang::ASTDeclReader::VisitObjCCategoryImplDecl(clang::ObjCCategoryImplDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader27VisitObjCImplementationDeclEPNS_22ObjCImplementationDeclE", "clang::ASTDeclReader::VisitObjCImplementationDecl(clang::ObjCImplementationDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader25VisitObjCPropertyImplDeclEPNS_20ObjCPropertyImplDeclE", "clang::ASTDeclReader::VisitObjCPropertyImplDecl(clang::ObjCPropertyImplDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22VisitIndirectFieldDeclEPNS_17IndirectFieldDeclE", "clang::ASTDeclReader::VisitIndirectFieldDecl(clang::IndirectFieldDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader12VisitVarDeclEPNS_7VarDeclE", "clang::ASTDeclReader::VisitVarDecl(clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22VisitImplicitParamDeclEPNS_17ImplicitParamDeclE", "clang::ASTDeclReader::VisitImplicitParamDecl(clang::ImplicitParamDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader16VisitParmVarDeclEPNS_11ParmVarDeclE", "clang::ASTDeclReader::VisitParmVarDecl(clang::ParmVarDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader21VisitFileScopeAsmDeclEPNS_16FileScopeAsmDeclE", "clang::ASTDeclReader::VisitFileScopeAsmDecl(clang::FileScopeAsmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader14VisitBlockDeclEPNS_9BlockDeclE", "clang::ASTDeclReader::VisitBlockDecl(clang::BlockDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader20VisitLinkageSpecDeclEPNS_15LinkageSpecDeclE", "clang::ASTDeclReader::VisitLinkageSpecDecl(clang::LinkageSpecDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader18VisitNamespaceDeclEPNS_13NamespaceDeclE", "clang::ASTDeclReader::VisitNamespaceDecl(clang::NamespaceDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader23VisitNamespaceAliasDeclEPNS_18NamespaceAliasDeclE", "clang::ASTDeclReader::VisitNamespaceAliasDecl(clang::NamespaceAliasDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader14VisitUsingDeclEPNS_9UsingDeclE", "clang::ASTDeclReader::VisitUsingDecl(clang::UsingDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader20VisitUsingShadowDeclEPNS_15UsingShadowDeclE", "clang::ASTDeclReader::VisitUsingShadowDecl(clang::UsingShadowDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader23VisitUsingDirectiveDeclEPNS_18UsingDirectiveDeclE", "clang::ASTDeclReader::VisitUsingDirectiveDecl(clang::UsingDirectiveDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader29VisitUnresolvedUsingValueDeclEPNS_24UnresolvedUsingValueDeclE", "clang::ASTDeclReader::VisitUnresolvedUsingValueDecl(clang::UnresolvedUsingValueDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader32VisitUnresolvedUsingTypenameDeclEPNS_27UnresolvedUsingTypenameDeclE", "clang::ASTDeclReader::VisitUnresolvedUsingTypenameDecl(clang::UnresolvedUsingTypenameDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader21ReadCXXDefinitionDataERNS_13CXXRecordDecl14DefinitionDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTDeclReader::ReadCXXDefinitionData(clang::CXXRecordDecl::DefinitionData&, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader27InitializeCXXDefinitionDataEPNS_13CXXRecordDeclES2_RKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTDeclReader::InitializeCXXDefinitionData(clang::CXXRecordDecl*, clang::CXXRecordDecl*, llvm::SmallVector<uint64_t, 64u> const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader18VisitCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::ASTDeclReader::VisitCXXRecordDecl(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader18VisitCXXMethodDeclEPNS_13CXXMethodDeclE", "clang::ASTDeclReader::VisitCXXMethodDecl(clang::CXXMethodDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader23VisitCXXConstructorDeclEPNS_18CXXConstructorDeclE", "clang::ASTDeclReader::VisitCXXConstructorDecl(clang::CXXConstructorDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22VisitCXXDestructorDeclEPNS_17CXXDestructorDeclE", "clang::ASTDeclReader::VisitCXXDestructorDecl(clang::CXXDestructorDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22VisitCXXConversionDeclEPNS_17CXXConversionDeclE", "clang::ASTDeclReader::VisitCXXConversionDecl(clang::CXXConversionDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader19VisitAccessSpecDeclEPNS_14AccessSpecDeclE", "clang::ASTDeclReader::VisitAccessSpecDecl(clang::AccessSpecDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader15VisitFriendDeclEPNS_10FriendDeclE", "clang::ASTDeclReader::VisitFriendDecl(clang::FriendDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader23VisitFriendTemplateDeclEPNS_18FriendTemplateDeclE", "clang::ASTDeclReader::VisitFriendTemplateDecl(clang::FriendTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader17VisitTemplateDeclEPNS_12TemplateDeclE", "clang::ASTDeclReader::VisitTemplateDecl(clang::TemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader29VisitRedeclarableTemplateDeclEPNS_24RedeclarableTemplateDeclE", "clang::ASTDeclReader::VisitRedeclarableTemplateDecl(clang::RedeclarableTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader22VisitClassTemplateDeclEPNS_17ClassTemplateDeclE", "clang::ASTDeclReader::VisitClassTemplateDecl(clang::ClassTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader36VisitClassTemplateSpecializationDeclEPNS_31ClassTemplateSpecializationDeclE", "clang::ASTDeclReader::VisitClassTemplateSpecializationDecl(clang::ClassTemplateSpecializationDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader43VisitClassTemplatePartialSpecializationDeclEPNS_38ClassTemplatePartialSpecializationDeclE", "clang::ASTDeclReader::VisitClassTemplatePartialSpecializationDecl(clang::ClassTemplatePartialSpecializationDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader25VisitFunctionTemplateDeclEPNS_20FunctionTemplateDeclE", "clang::ASTDeclReader::VisitFunctionTemplateDecl(clang::FunctionTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader25VisitTemplateTypeParmDeclEPNS_20TemplateTypeParmDeclE", "clang::ASTDeclReader::VisitTemplateTypeParmDecl(clang::TemplateTypeParmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader28VisitNonTypeTemplateParmDeclEPNS_23NonTypeTemplateParmDeclE", "clang::ASTDeclReader::VisitNonTypeTemplateParmDecl(clang::NonTypeTemplateParmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader29VisitTemplateTemplateParmDeclEPNS_24TemplateTemplateParmDeclE", "clang::ASTDeclReader::VisitTemplateTemplateParmDecl(clang::TemplateTemplateParmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader21VisitStaticAssertDeclEPNS_16StaticAssertDeclE", "clang::ASTDeclReader::VisitStaticAssertDecl(clang::StaticAssertDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader16VisitDeclContextEPNS_11DeclContextE", "clang::ASTDeclReader::VisitDeclContext(clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang9ASTReader18DeclCursorForIndexEjj", "clang::ASTReader::DeclCursorForIndex(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTReader14ReadDeclRecordEjj", "clang::ASTReader::ReadDeclRecord(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader10UpdateDeclEPNS_4DeclERKN4llvm11SmallVectorIyLj64EEE", "clang::ASTDeclReader::UpdateDecl(clang::Decl*, llvm::SmallVector<uint64_t, 64u> const&)"),
	mu_demangle_test("_ZN5clang11DeclVisitorINS_13ASTDeclReaderEvE5VisitEPNS_4DeclE", "clang::DeclVisitor<clang::ASTDeclReader, void>::Visit(clang::Decl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader17VisitRedeclarableINS_7TagDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclReader::VisitRedeclarable<clang::TagDecl>(clang::Redeclarable<clang::TagDecl>*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader17VisitRedeclarableINS_12FunctionDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclReader::VisitRedeclarable<clang::FunctionDecl>(clang::Redeclarable<clang::FunctionDecl>*)"),
	mu_demangle_test("_ZN5clang13ASTDeclReader17VisitRedeclarableINS_7VarDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclReader::VisitRedeclarable<clang::VarDecl>(clang::Redeclarable<clang::VarDecl>*)"),
	mu_demangle_test("_ZN5clang14AccessSpecDecl6CreateERNS_10ASTContextENS_4Decl10EmptyShellE", "clang::AccessSpecDecl::Create(clang::ASTContext&, clang::Decl::EmptyShell)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang9ASTReader15DeclContextInfoEE6insertEPS3_RKS3_", "llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>::insert(clang::ASTReader::DeclContextInfo*, clang::ASTReader::DeclContextInfo const&)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPN5clang13CXXRecordDeclEEaSERKS4_", "llvm::SmallVectorImpl<clang::CXXRecordDecl*>::operator=(llvm::SmallVectorImpl<clang::CXXRecordDecl*> const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang9BlockDecl7CaptureELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::BlockDecl::Capture, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader32ReadExplicitTemplateArgumentListERNS_28ExplicitTemplateArgumentListEj", "clang::ASTStmtReader::ReadExplicitTemplateArgumentList(clang::ExplicitTemplateArgumentList&, unsigned int)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader9VisitStmtEPNS_4StmtE", "clang::ASTStmtReader::VisitStmt(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader13VisitNullStmtEPNS_8NullStmtE", "clang::ASTStmtReader::VisitNullStmt(clang::NullStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader17VisitCompoundStmtEPNS_12CompoundStmtE", "clang::ASTStmtReader::VisitCompoundStmt(clang::CompoundStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader15VisitSwitchCaseEPNS_10SwitchCaseE", "clang::ASTStmtReader::VisitSwitchCase(clang::SwitchCase*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader13VisitCaseStmtEPNS_8CaseStmtE", "clang::ASTStmtReader::VisitCaseStmt(clang::CaseStmt*)"),
	mu_demangle_test("_ZN5clang9ASTReader11ReadSubExprEv", "clang::ASTReader::ReadSubExpr()"),
	mu_demangle_test("_ZN5clang13ASTStmtReader16VisitDefaultStmtEPNS_11DefaultStmtE", "clang::ASTStmtReader::VisitDefaultStmt(clang::DefaultStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader14VisitLabelStmtEPNS_9LabelStmtE", "clang::ASTStmtReader::VisitLabelStmt(clang::LabelStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader11VisitIfStmtEPNS_6IfStmtE", "clang::ASTStmtReader::VisitIfStmt(clang::IfStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader15VisitSwitchStmtEPNS_10SwitchStmtE", "clang::ASTStmtReader::VisitSwitchStmt(clang::SwitchStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader14VisitWhileStmtEPNS_9WhileStmtE", "clang::ASTStmtReader::VisitWhileStmt(clang::WhileStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader11VisitDoStmtEPNS_6DoStmtE", "clang::ASTStmtReader::VisitDoStmt(clang::DoStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader12VisitForStmtEPNS_7ForStmtE", "clang::ASTStmtReader::VisitForStmt(clang::ForStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader13VisitGotoStmtEPNS_8GotoStmtE", "clang::ASTStmtReader::VisitGotoStmt(clang::GotoStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitIndirectGotoStmtEPNS_16IndirectGotoStmtE", "clang::ASTStmtReader::VisitIndirectGotoStmt(clang::IndirectGotoStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader17VisitContinueStmtEPNS_12ContinueStmtE", "clang::ASTStmtReader::VisitContinueStmt(clang::ContinueStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader14VisitBreakStmtEPNS_9BreakStmtE", "clang::ASTStmtReader::VisitBreakStmt(clang::BreakStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader15VisitReturnStmtEPNS_10ReturnStmtE", "clang::ASTStmtReader::VisitReturnStmt(clang::ReturnStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader13VisitDeclStmtEPNS_8DeclStmtE", "clang::ASTStmtReader::VisitDeclStmt(clang::DeclStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader12VisitAsmStmtEPNS_7AsmStmtE", "clang::ASTStmtReader::VisitAsmStmt(clang::AsmStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader9VisitExprEPNS_4ExprE", "clang::ASTStmtReader::VisitExpr(clang::Expr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader19VisitPredefinedExprEPNS_14PredefinedExprE", "clang::ASTStmtReader::VisitPredefinedExpr(clang::PredefinedExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader16VisitDeclRefExprEPNS_11DeclRefExprE", "clang::ASTStmtReader::VisitDeclRefExpr(clang::DeclRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader19VisitIntegerLiteralEPNS_14IntegerLiteralE", "clang::ASTStmtReader::VisitIntegerLiteral(clang::IntegerLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader20VisitFloatingLiteralEPNS_15FloatingLiteralE", "clang::ASTStmtReader::VisitFloatingLiteral(clang::FloatingLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitImaginaryLiteralEPNS_16ImaginaryLiteralE", "clang::ASTStmtReader::VisitImaginaryLiteral(clang::ImaginaryLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitStringLiteralEPNS_13StringLiteralE", "clang::ASTStmtReader::VisitStringLiteral(clang::StringLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitCharacterLiteralEPNS_16CharacterLiteralE", "clang::ASTStmtReader::VisitCharacterLiteral(clang::CharacterLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader14VisitParenExprEPNS_9ParenExprE", "clang::ASTStmtReader::VisitParenExpr(clang::ParenExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitParenListExprEPNS_13ParenListExprE", "clang::ASTStmtReader::VisitParenListExpr(clang::ParenListExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitUnaryOperatorEPNS_13UnaryOperatorE", "clang::ASTStmtReader::VisitUnaryOperator(clang::UnaryOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader17VisitOffsetOfExprEPNS_12OffsetOfExprE", "clang::ASTStmtReader::VisitOffsetOfExpr(clang::OffsetOfExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader22VisitSizeOfAlignOfExprEPNS_17SizeOfAlignOfExprE", "clang::ASTStmtReader::VisitSizeOfAlignOfExpr(clang::SizeOfAlignOfExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader23VisitArraySubscriptExprEPNS_18ArraySubscriptExprE", "clang::ASTStmtReader::VisitArraySubscriptExpr(clang::ArraySubscriptExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader13VisitCallExprEPNS_8CallExprE", "clang::ASTStmtReader::VisitCallExpr(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader15VisitMemberExprEPNS_10MemberExprE", "clang::ASTStmtReader::VisitMemberExpr(clang::MemberExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader16VisitObjCIsaExprEPNS_11ObjCIsaExprE", "clang::ASTStmtReader::VisitObjCIsaExpr(clang::ObjCIsaExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader13VisitCastExprEPNS_8CastExprE", "clang::ASTStmtReader::VisitCastExpr(clang::CastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader19VisitBinaryOperatorEPNS_14BinaryOperatorE", "clang::ASTStmtReader::VisitBinaryOperator(clang::BinaryOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader27VisitCompoundAssignOperatorEPNS_22CompoundAssignOperatorE", "clang::ASTStmtReader::VisitCompoundAssignOperator(clang::CompoundAssignOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader24VisitConditionalOperatorEPNS_19ConditionalOperatorE", "clang::ASTStmtReader::VisitConditionalOperator(clang::ConditionalOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitImplicitCastExprEPNS_16ImplicitCastExprE", "clang::ASTStmtReader::VisitImplicitCastExpr(clang::ImplicitCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitExplicitCastExprEPNS_16ExplicitCastExprE", "clang::ASTStmtReader::VisitExplicitCastExpr(clang::ExplicitCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader19VisitCStyleCastExprEPNS_14CStyleCastExprE", "clang::ASTStmtReader::VisitCStyleCastExpr(clang::CStyleCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader24VisitCompoundLiteralExprEPNS_19CompoundLiteralExprE", "clang::ASTStmtReader::VisitCompoundLiteralExpr(clang::CompoundLiteralExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader25VisitExtVectorElementExprEPNS_20ExtVectorElementExprE", "clang::ASTStmtReader::VisitExtVectorElementExpr(clang::ExtVectorElementExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader17VisitInitListExprEPNS_12InitListExprE", "clang::ASTStmtReader::VisitInitListExpr(clang::InitListExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader23VisitDesignatedInitExprEPNS_18DesignatedInitExprE", "clang::ASTStmtReader::VisitDesignatedInitExpr(clang::DesignatedInitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader26VisitImplicitValueInitExprEPNS_21ImplicitValueInitExprE", "clang::ASTStmtReader::VisitImplicitValueInitExpr(clang::ImplicitValueInitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader14VisitVAArgExprEPNS_9VAArgExprE", "clang::ASTStmtReader::VisitVAArgExpr(clang::VAArgExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitAddrLabelExprEPNS_13AddrLabelExprE", "clang::ASTStmtReader::VisitAddrLabelExpr(clang::AddrLabelExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader13VisitStmtExprEPNS_8StmtExprE", "clang::ASTStmtReader::VisitStmtExpr(clang::StmtExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader15VisitChooseExprEPNS_10ChooseExprE", "clang::ASTStmtReader::VisitChooseExpr(clang::ChooseExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader16VisitGNUNullExprEPNS_11GNUNullExprE", "clang::ASTStmtReader::VisitGNUNullExpr(clang::GNUNullExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader22VisitShuffleVectorExprEPNS_17ShuffleVectorExprE", "clang::ASTStmtReader::VisitShuffleVectorExpr(clang::ShuffleVectorExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader14VisitBlockExprEPNS_9BlockExprE", "clang::ASTStmtReader::VisitBlockExpr(clang::BlockExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitBlockDeclRefExprEPNS_16BlockDeclRefExprE", "clang::ASTStmtReader::VisitBlockDeclRefExpr(clang::BlockDeclRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader22VisitObjCStringLiteralEPNS_17ObjCStringLiteralE", "clang::ASTStmtReader::VisitObjCStringLiteral(clang::ObjCStringLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader19VisitObjCEncodeExprEPNS_14ObjCEncodeExprE", "clang::ASTStmtReader::VisitObjCEncodeExpr(clang::ObjCEncodeExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitObjCSelectorExprEPNS_16ObjCSelectorExprE", "clang::ASTStmtReader::VisitObjCSelectorExpr(clang::ObjCSelectorExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitObjCProtocolExprEPNS_16ObjCProtocolExprE", "clang::ASTStmtReader::VisitObjCProtocolExpr(clang::ObjCProtocolExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader20VisitObjCIvarRefExprEPNS_15ObjCIvarRefExprE", "clang::ASTStmtReader::VisitObjCIvarRefExpr(clang::ObjCIvarRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader24VisitObjCPropertyRefExprEPNS_19ObjCPropertyRefExprE", "clang::ASTStmtReader::VisitObjCPropertyRefExpr(clang::ObjCPropertyRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader20VisitObjCMessageExprEPNS_15ObjCMessageExprE", "clang::ASTStmtReader::VisitObjCMessageExpr(clang::ObjCMessageExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader26VisitObjCForCollectionStmtEPNS_21ObjCForCollectionStmtE", "clang::ASTStmtReader::VisitObjCForCollectionStmt(clang::ObjCForCollectionStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader20VisitObjCAtCatchStmtEPNS_15ObjCAtCatchStmtE", "clang::ASTStmtReader::VisitObjCAtCatchStmt(clang::ObjCAtCatchStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader22VisitObjCAtFinallyStmtEPNS_17ObjCAtFinallyStmtE", "clang::ASTStmtReader::VisitObjCAtFinallyStmt(clang::ObjCAtFinallyStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitObjCAtTryStmtEPNS_13ObjCAtTryStmtE", "clang::ASTStmtReader::VisitObjCAtTryStmt(clang::ObjCAtTryStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader27VisitObjCAtSynchronizedStmtEPNS_22ObjCAtSynchronizedStmtE", "clang::ASTStmtReader::VisitObjCAtSynchronizedStmt(clang::ObjCAtSynchronizedStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader20VisitObjCAtThrowStmtEPNS_15ObjCAtThrowStmtE", "clang::ASTStmtReader::VisitObjCAtThrowStmt(clang::ObjCAtThrowStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader17VisitCXXCatchStmtEPNS_12CXXCatchStmtE", "clang::ASTStmtReader::VisitCXXCatchStmt(clang::CXXCatchStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader15VisitCXXTryStmtEPNS_10CXXTryStmtE", "clang::ASTStmtReader::VisitCXXTryStmt(clang::CXXTryStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader24VisitCXXOperatorCallExprEPNS_19CXXOperatorCallExprE", "clang::ASTStmtReader::VisitCXXOperatorCallExpr(clang::CXXOperatorCallExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitCXXConstructExprEPNS_16CXXConstructExprE", "clang::ASTStmtReader::VisitCXXConstructExpr(clang::CXXConstructExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader27VisitCXXTemporaryObjectExprEPNS_22CXXTemporaryObjectExprE", "clang::ASTStmtReader::VisitCXXTemporaryObjectExpr(clang::CXXTemporaryObjectExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitCXXNamedCastExprEPNS_16CXXNamedCastExprE", "clang::ASTStmtReader::VisitCXXNamedCastExpr(clang::CXXNamedCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader22VisitCXXStaticCastExprEPNS_17CXXStaticCastExprE", "clang::ASTStmtReader::VisitCXXStaticCastExpr(clang::CXXStaticCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader23VisitCXXDynamicCastExprEPNS_18CXXDynamicCastExprE", "clang::ASTStmtReader::VisitCXXDynamicCastExpr(clang::CXXDynamicCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader27VisitCXXReinterpretCastExprEPNS_22CXXReinterpretCastExprE", "clang::ASTStmtReader::VisitCXXReinterpretCastExpr(clang::CXXReinterpretCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitCXXConstCastExprEPNS_16CXXConstCastExprE", "clang::ASTStmtReader::VisitCXXConstCastExpr(clang::CXXConstCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader26VisitCXXFunctionalCastExprEPNS_21CXXFunctionalCastExprE", "clang::ASTStmtReader::VisitCXXFunctionalCastExpr(clang::CXXFunctionalCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader23VisitCXXBoolLiteralExprEPNS_18CXXBoolLiteralExprE", "clang::ASTStmtReader::VisitCXXBoolLiteralExpr(clang::CXXBoolLiteralExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader26VisitCXXNullPtrLiteralExprEPNS_21CXXNullPtrLiteralExprE", "clang::ASTStmtReader::VisitCXXNullPtrLiteralExpr(clang::CXXNullPtrLiteralExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitCXXTypeidExprEPNS_13CXXTypeidExprE", "clang::ASTStmtReader::VisitCXXTypeidExpr(clang::CXXTypeidExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitCXXUuidofExprEPNS_13CXXUuidofExprE", "clang::ASTStmtReader::VisitCXXUuidofExpr(clang::CXXUuidofExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader16VisitCXXThisExprEPNS_11CXXThisExprE", "clang::ASTStmtReader::VisitCXXThisExpr(clang::CXXThisExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader17VisitCXXThrowExprEPNS_12CXXThrowExprE", "clang::ASTStmtReader::VisitCXXThrowExpr(clang::CXXThrowExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader22VisitCXXDefaultArgExprEPNS_17CXXDefaultArgExprE", "clang::ASTStmtReader::VisitCXXDefaultArgExpr(clang::CXXDefaultArgExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader25VisitCXXBindTemporaryExprEPNS_20CXXBindTemporaryExprE", "clang::ASTStmtReader::VisitCXXBindTemporaryExpr(clang::CXXBindTemporaryExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader27VisitCXXScalarValueInitExprEPNS_22CXXScalarValueInitExprE", "clang::ASTStmtReader::VisitCXXScalarValueInitExpr(clang::CXXScalarValueInitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader15VisitCXXNewExprEPNS_10CXXNewExprE", "clang::ASTStmtReader::VisitCXXNewExpr(clang::CXXNewExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader18VisitCXXDeleteExprEPNS_13CXXDeleteExprE", "clang::ASTStmtReader::VisitCXXDeleteExpr(clang::CXXDeleteExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader28VisitCXXPseudoDestructorExprEPNS_23CXXPseudoDestructorExprE", "clang::ASTStmtReader::VisitCXXPseudoDestructorExpr(clang::CXXPseudoDestructorExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader21VisitExprWithCleanupsEPNS_16ExprWithCleanupsE", "clang::ASTStmtReader::VisitExprWithCleanups(clang::ExprWithCleanups*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader32VisitCXXDependentScopeMemberExprEPNS_27CXXDependentScopeMemberExprE", "clang::ASTStmtReader::VisitCXXDependentScopeMemberExpr(clang::CXXDependentScopeMemberExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader30VisitDependentScopeDeclRefExprEPNS_25DependentScopeDeclRefExprE", "clang::ASTStmtReader::VisitDependentScopeDeclRefExpr(clang::DependentScopeDeclRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader31VisitCXXUnresolvedConstructExprEPNS_26CXXUnresolvedConstructExprE", "clang::ASTStmtReader::VisitCXXUnresolvedConstructExpr(clang::CXXUnresolvedConstructExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader17VisitOverloadExprEPNS_12OverloadExprE", "clang::ASTStmtReader::VisitOverloadExpr(clang::OverloadExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader25VisitUnresolvedMemberExprEPNS_20UnresolvedMemberExprE", "clang::ASTStmtReader::VisitUnresolvedMemberExpr(clang::UnresolvedMemberExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader25VisitUnresolvedLookupExprEPNS_20UnresolvedLookupExprE", "clang::ASTStmtReader::VisitUnresolvedLookupExpr(clang::UnresolvedLookupExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader23VisitUnaryTypeTraitExprEPNS_18UnaryTypeTraitExprE", "clang::ASTStmtReader::VisitUnaryTypeTraitExpr(clang::UnaryTypeTraitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader24VisitBinaryTypeTraitExprEPNS_19BinaryTypeTraitExprE", "clang::ASTStmtReader::VisitBinaryTypeTraitExpr(clang::BinaryTypeTraitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader20VisitCXXNoexceptExprEPNS_15CXXNoexceptExprE", "clang::ASTStmtReader::VisitCXXNoexceptExpr(clang::CXXNoexceptExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader22VisitPackExpansionExprEPNS_17PackExpansionExprE", "clang::ASTStmtReader::VisitPackExpansionExpr(clang::PackExpansionExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader19VisitSizeOfPackExprEPNS_14SizeOfPackExprE", "clang::ASTStmtReader::VisitSizeOfPackExpr(clang::SizeOfPackExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader37VisitSubstNonTypeTemplateParmPackExprEPNS_32SubstNonTypeTemplateParmPackExprE", "clang::ASTStmtReader::VisitSubstNonTypeTemplateParmPackExpr(clang::SubstNonTypeTemplateParmPackExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader20VisitOpaqueValueExprEPNS_15OpaqueValueExprE", "clang::ASTStmtReader::VisitOpaqueValueExpr(clang::OpaqueValueExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtReader23VisitCUDAKernelCallExprEPNS_18CUDAKernelCallExprE", "clang::ASTStmtReader::VisitCUDAKernelCallExpr(clang::CUDAKernelCallExpr*)"),
	mu_demangle_test("_ZN5clang9ASTReader8ReadStmtERNS0_11PerFileDataE", "clang::ASTReader::ReadStmt(clang::ASTReader::PerFileData&)"),
	mu_demangle_test("_ZN5clang9ASTReader18ReadStmtFromStreamERNS0_11PerFileDataE", "clang::ASTReader::ReadStmtFromStream(clang::ASTReader::PerFileData&)"),
	mu_demangle_test("_ZN5clang9ASTReader8ReadExprERNS0_11PerFileDataE", "clang::ASTReader::ReadExpr(clang::ASTReader::PerFileData&)"),
	mu_demangle_test("_ZN5clang11StmtVisitorINS_13ASTStmtReaderEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<clang::ASTStmtReader, void>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang18DesignatedInitExpr10DesignatorELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::DesignatedInitExpr::Designator, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang9ASTWriter19WriteBlockInfoBlockEv", "clang::ASTWriter::WriteBlockInfoBlock()"),
	mu_demangle_test("_Z11EmitBlockIDjPKcRN4llvm15BitstreamWriterERNS1_15SmallVectorImplIyEE", "EmitBlockID(unsigned int, char const*, llvm::BitstreamWriter&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_Z12EmitRecordIDjPKcRN4llvm15BitstreamWriterERNS1_15SmallVectorImplIyEE", "EmitRecordID(unsigned int, char const*, llvm::BitstreamWriter&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter13WriteMetadataERNS_10ASTContextEPKc", "clang::ASTWriter::WriteMetadata(clang::ASTContext&, char const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter20WriteLanguageOptionsERKNS_11LangOptionsE", "clang::ASTWriter::WriteLanguageOptions(clang::LangOptions const&)"),
	mu_demangle_test("_ZN5clang9ASTWriter14WriteStatCacheERNS_17MemorizeStatCallsE", "clang::ASTWriter::WriteStatCache(clang::MemorizeStatCalls&)"),
	mu_demangle_test("_ZN5clang9ASTWriter23WriteSourceManagerBlockERNS_13SourceManagerERKNS_12PreprocessorEPKc", "clang::ASTWriter::WriteSourceManagerBlock(clang::SourceManager&, clang::Preprocessor const&, char const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter16AddIdentifierRefEPKNS_14IdentifierInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddIdentifierRef(clang::IdentifierInfo const*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter17WritePreprocessorERKNS_12PreprocessorE", "clang::ASTWriter::WritePreprocessor(clang::Preprocessor const&)"),
	mu_demangle_test("_ZN5clang9ASTWriter20getMacroDefinitionIDEPNS_15MacroDefinitionE", "clang::ASTWriter::getMacroDefinitionID(clang::MacroDefinition*)"),
	mu_demangle_test("_ZN5clang9ASTWriter23WritePreprocessorDetailERNS_19PreprocessingRecordE", "clang::ASTWriter::WritePreprocessorDetail(clang::PreprocessingRecord&)"),
	mu_demangle_test("_ZN5clang9ASTWriter17AddSourceLocationENS_14SourceLocationERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddSourceLocation(clang::SourceLocation, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter29WritePragmaDiagnosticMappingsERKNS_10DiagnosticE", "clang::ASTWriter::WritePragmaDiagnosticMappings(clang::Diagnostic const&)"),
	mu_demangle_test("_ZN5clang9ASTWriter9WriteTypeENS_8QualTypeE", "clang::ASTWriter::WriteType(clang::QualType)"),
	mu_demangle_test("_ZN5clang9ASTWriter10AddTypeRefENS_8QualTypeERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTypeRef(clang::QualType, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTTypeWriter15VisitVectorTypeEPKN5clang10VectorTypeE", "(anonymous namespace)::ASTTypeWriter::VisitVectorType(clang::VectorType const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter28WriteDeclContextLexicalBlockERNS_10ASTContextEPNS_11DeclContextE", "clang::ASTWriter::WriteDeclContextLexicalBlock(clang::ASTContext&, clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang9ASTWriter10GetDeclRefEPKNS_4DeclE", "clang::ASTWriter::GetDeclRef(clang::Decl const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter20WriteTypeDeclOffsetsEv", "clang::ASTWriter::WriteTypeDeclOffsets()"),
	mu_demangle_test("_ZN5clang9ASTWriter14WriteSelectorsERNS_4SemaE", "clang::ASTWriter::WriteSelectors(clang::Sema&)"),
	mu_demangle_test("_ZN5clang9ASTWriter28WriteReferencedSelectorsPoolERNS_4SemaE", "clang::ASTWriter::WriteReferencedSelectorsPool(clang::Sema&)"),
	mu_demangle_test("_ZN5clang9ASTWriter14AddSelectorRefENS_8SelectorERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddSelectorRef(clang::Selector, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter20WriteIdentifierTableERNS_12PreprocessorE", "clang::ASTWriter::WriteIdentifierTable(clang::Preprocessor&)"),
	mu_demangle_test("_ZN5clang9ASTWriter16getIdentifierRefEPKNS_14IdentifierInfoE", "clang::ASTWriter::getIdentifierRef(clang::IdentifierInfo const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter28WriteDeclContextVisibleBlockERNS_10ASTContextEPNS_11DeclContextE", "clang::ASTWriter::WriteDeclContextVisibleBlock(clang::ASTContext&, clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang31OnDiskChainedHashTableGeneratorIN12_GLOBAL__N_129ASTDeclContextNameLookupTraitEE6insertENS_15DeclarationNameERKNS_23DeclContextLookupResultERS2_", "clang::OnDiskChainedHashTableGenerator<(anonymous namespace)::ASTDeclContextNameLookupTrait>::insert(clang::DeclarationName, clang::DeclContextLookupResult const&, (anonymous namespace)::ASTDeclContextNameLookupTrait&)"),
	mu_demangle_test("_ZN5clang31OnDiskChainedHashTableGeneratorIN12_GLOBAL__N_129ASTDeclContextNameLookupTraitEE4EmitERN4llvm11raw_ostreamERS2_", "clang::OnDiskChainedHashTableGenerator<(anonymous namespace)::ASTDeclContextNameLookupTrait>::Emit(llvm::raw_ostream&, (anonymous namespace)::ASTDeclContextNameLookupTrait&)"),
	mu_demangle_test("_ZN5clang9ASTWriter29WriteDeclContextVisibleUpdateEPKNS_11DeclContextE", "clang::ASTWriter::WriteDeclContextVisibleUpdate(clang::DeclContext const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter9getDeclIDEPKNS_4DeclE", "clang::ASTWriter::getDeclID(clang::Decl const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter15WriteAttributesERKN4llvm11SmallVectorIPNS_4AttrELj2EEERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::WriteAttributes(llvm::SmallVector<clang::Attr*, 2u> const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter9AddStringEN4llvm9StringRefERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddString(llvm::StringRef, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter17AddTypeSourceInfoEPNS_14TypeSourceInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTypeSourceInfo(clang::TypeSourceInfo*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter10AddDeclRefEPKNS_4DeclERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclRef(clang::Decl const*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter19SetIdentifierOffsetEPKNS_14IdentifierInfoEj", "clang::ASTWriter::SetIdentifierOffset(clang::IdentifierInfo const*, unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTWriter17SetSelectorOffsetENS_8SelectorEj", "clang::ASTWriter::SetSelectorOffset(clang::Selector, unsigned int)"),
	mu_demangle_test("_ZN5clang9ASTWriterC1ERN4llvm15BitstreamWriterE", "clang::ASTWriter::ASTWriter(llvm::BitstreamWriter&)"),
	mu_demangle_test("_ZN5clang9ASTWriterC2ERN4llvm15BitstreamWriterE", "clang::ASTWriter::ASTWriter(llvm::BitstreamWriter&)"),
	mu_demangle_test("_ZN5clang9ASTWriter8WriteASTERNS_4SemaEPNS_17MemorizeStatCallsEPKc", "clang::ASTWriter::WriteAST(clang::Sema&, clang::MemorizeStatCalls*, char const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter13WriteASTChainERNS_4SemaEPNS_17MemorizeStatCallsEPKc", "clang::ASTWriter::WriteASTChain(clang::Sema&, clang::MemorizeStatCalls*, char const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter12WriteASTCoreERNS_4SemaEPNS_17MemorizeStatCallsEPKc", "clang::ASTWriter::WriteASTCore(clang::Sema&, clang::MemorizeStatCalls*, char const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter22WriteDeclUpdatesBlocksEv", "clang::ASTWriter::WriteDeclUpdatesBlocks()"),
	mu_demangle_test("_ZN5clang9ASTWriter26WriteDeclReplacementsBlockEv", "clang::ASTWriter::WriteDeclReplacementsBlock()"),
	mu_demangle_test("_ZN5clang9ASTWriter14AddSourceRangeENS_11SourceRangeERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddSourceRange(clang::SourceRange, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter8AddAPIntERKN4llvm5APIntERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddAPInt(llvm::APInt const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter9AddAPSIntERKN4llvm6APSIntERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddAPSInt(llvm::APSInt const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter10AddAPFloatERKN4llvm7APFloatERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddAPFloat(llvm::APFloat const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter14getSelectorRefENS_8SelectorE", "clang::ASTWriter::getSelectorRef(clang::Selector)"),
	mu_demangle_test("_ZN5clang9ASTWriter15AddCXXTemporaryEPKNS_12CXXTemporaryERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXTemporary(clang::CXXTemporary const*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter23AddCXXBaseSpecifiersRefEPKNS_16CXXBaseSpecifierES3_RN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXBaseSpecifiersRef(clang::CXXBaseSpecifier const*, clang::CXXBaseSpecifier const*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter26AddTemplateArgumentLocInfoENS_16TemplateArgument7ArgKindERKNS_23TemplateArgumentLocInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgumentLocInfo(clang::TemplateArgument::ArgKind, clang::TemplateArgumentLocInfo const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter22AddTemplateArgumentLocERKNS_19TemplateArgumentLocERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgumentLoc(clang::TemplateArgumentLoc const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter19AddTemplateArgumentERKNS_16TemplateArgumentERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgument(clang::TemplateArgument const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter17GetOrCreateTypeIDENS_8QualTypeE", "clang::ASTWriter::GetOrCreateTypeID(clang::QualType)"),
	mu_demangle_test("_ZN5clang9ASTWriter18GetOrCreateTypeIdxENS_8QualTypeE", "clang::ASTWriter::GetOrCreateTypeIdx(clang::QualType)"),
	mu_demangle_test("_ZNK5clang9ASTWriter9getTypeIDENS_8QualTypeE", "clang::ASTWriter::getTypeID(clang::QualType) const"),
	mu_demangle_test("_ZNK5clang9ASTWriter10getTypeIdxENS_8QualTypeE", "clang::ASTWriter::getTypeIdx(clang::QualType) const"),
	mu_demangle_test("_ZN5clang9ASTWriter18AddDeclarationNameENS_15DeclarationNameERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclarationName(clang::DeclarationName, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter21AddDeclarationNameLocERKNS_18DeclarationNameLocENS_15DeclarationNameERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclarationNameLoc(clang::DeclarationNameLoc const&, clang::DeclarationName, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter22AddDeclarationNameInfoERKNS_19DeclarationNameInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclarationNameInfo(clang::DeclarationNameInfo const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter16AddQualifierInfoERKNS_13QualifierInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddQualifierInfo(clang::QualifierInfo const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter22AddNestedNameSpecifierEPNS_19NestedNameSpecifierERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddNestedNameSpecifier(clang::NestedNameSpecifier*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter24AddTemplateParameterListEPKNS_21TemplateParameterListERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateParameterList(clang::TemplateParameterList const*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter15AddTemplateNameENS_12TemplateNameERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateName(clang::TemplateName, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter23AddTemplateArgumentListEPKNS_20TemplateArgumentListERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgumentList(clang::TemplateArgumentList const*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter16AddUnresolvedSetERKNS_17UnresolvedSetImplERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddUnresolvedSet(clang::UnresolvedSetImpl const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter19AddCXXBaseSpecifierERKNS_16CXXBaseSpecifierERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXBaseSpecifier(clang::CXXBaseSpecifier const&, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter22FlushCXXBaseSpecifiersEv", "clang::ASTWriter::FlushCXXBaseSpecifiers()"),
	mu_demangle_test("_ZN5clang9ASTWriter22AddCXXCtorInitializersEPKPKNS_18CXXCtorInitializerEjRN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXCtorInitializers(clang::CXXCtorInitializer const* const*, unsigned int, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter20AddCXXDefinitionDataEPKNS_13CXXRecordDeclERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXDefinitionData(clang::CXXRecordDecl const*, llvm::SmallVectorImpl<uint64_t>&)"),
	mu_demangle_test("_ZN5clang9ASTWriter17ReaderInitializedEPNS_9ASTReaderE", "clang::ASTWriter::ReaderInitialized(clang::ASTReader*)"),
	mu_demangle_test("_ZN5clang9ASTWriter14IdentifierReadEjPNS_14IdentifierInfoE", "clang::ASTWriter::IdentifierRead(unsigned int, clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang9ASTWriter8TypeReadENS_13serialization7TypeIdxENS_8QualTypeE", "clang::ASTWriter::TypeRead(clang::serialization::TypeIdx, clang::QualType)"),
	mu_demangle_test("_ZN5clang9ASTWriter8DeclReadEjPKNS_4DeclE", "clang::ASTWriter::DeclRead(unsigned int, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter12SelectorReadEjNS_8SelectorE", "clang::ASTWriter::SelectorRead(unsigned int, clang::Selector)"),
	mu_demangle_test("_ZN5clang9ASTWriter19MacroDefinitionReadEjPNS_15MacroDefinitionE", "clang::ASTWriter::MacroDefinitionRead(unsigned int, clang::MacroDefinition*)"),
	mu_demangle_test("_ZThn8_N5clang9ASTWriter22CompletedTagDefinitionEPKNS_7TagDeclE", "non-virtual thunk to clang::ASTWriter::CompletedTagDefinition(clang::TagDecl const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter22CompletedTagDefinitionEPKNS_7TagDeclE", "clang::ASTWriter::CompletedTagDefinition(clang::TagDecl const*)"),
	mu_demangle_test("_ZThn8_N5clang9ASTWriter16AddedVisibleDeclEPKNS_11DeclContextEPKNS_4DeclE", "non-virtual thunk to clang::ASTWriter::AddedVisibleDecl(clang::DeclContext const*, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter16AddedVisibleDeclEPKNS_11DeclContextEPKNS_4DeclE", "clang::ASTWriter::AddedVisibleDecl(clang::DeclContext const*, clang::Decl const*)"),
	mu_demangle_test("_ZThn8_N5clang9ASTWriter22AddedCXXImplicitMemberEPKNS_13CXXRecordDeclEPKNS_4DeclE", "non-virtual thunk to clang::ASTWriter::AddedCXXImplicitMember(clang::CXXRecordDecl const*, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter22AddedCXXImplicitMemberEPKNS_13CXXRecordDeclEPKNS_4DeclE", "clang::ASTWriter::AddedCXXImplicitMember(clang::CXXRecordDecl const*, clang::Decl const*)"),
	mu_demangle_test("_ZThn8_N5clang9ASTWriter30AddedCXXTemplateSpecializationEPKNS_17ClassTemplateDeclEPKNS_31ClassTemplateSpecializationDeclE", "non-virtual thunk to clang::ASTWriter::AddedCXXTemplateSpecialization(clang::ClassTemplateDecl const*, clang::ClassTemplateSpecializationDecl const*)"),
	mu_demangle_test("_ZN5clang9ASTWriter30AddedCXXTemplateSpecializationEPKNS_17ClassTemplateDeclEPKNS_31ClassTemplateSpecializationDeclE", "clang::ASTWriter::AddedCXXTemplateSpecialization(clang::ClassTemplateDecl const*, clang::ClassTemplateSpecializationDecl const*)"),
	mu_demangle_test("_ZN5clang24ASTSerializationListenerD0Ev", "clang::ASTSerializationListener::~ASTSerializationListener()"),
	mu_demangle_test("_ZN5clang24ASTSerializationListenerD1Ev", "clang::ASTSerializationListener::~ASTSerializationListener()"),
	mu_demangle_test("_ZN5clang24ASTSerializationListenerD2Ev", "clang::ASTSerializationListener::~ASTSerializationListener()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113TypeLocWriter20VisitFunctionTypeLocEN5clang15FunctionTypeLocE", "(anonymous namespace)::TypeLocWriter::VisitFunctionTypeLoc(clang::FunctionTypeLoc)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113TypeLocWriter17VisitArrayTypeLocEN5clang12ArrayTypeLocE", "(anonymous namespace)::TypeLocWriter::VisitArrayTypeLoc(clang::ArrayTypeLoc)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTTypeWriter12VisitTagTypeEPKN5clang7TagTypeE", "(anonymous namespace)::ASTTypeWriter::VisitTagType(clang::TagType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTTypeWriter17VisitFunctionTypeEPKN5clang12FunctionTypeE", "(anonymous namespace)::ASTTypeWriter::VisitFunctionType(clang::FunctionType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ASTTypeWriter14VisitArrayTypeEPKN5clang9ArrayTypeE", "(anonymous namespace)::ASTTypeWriter::VisitArrayType(clang::ArrayType const*)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter13EnterSubblockEjj", "llvm::BitstreamWriter::EnterSubblock(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter9ExitBlockEv", "llvm::BitstreamWriter::ExitBlock()"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter10EmitRecordIyEEvjRNS_15SmallVectorImplIT_EEj", "void llvm::BitstreamWriter::EmitRecord<uint64_t>(unsigned int, llvm::SmallVectorImpl<uint64_t>&, unsigned int)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIyE6insertIPKcEEPyS5_T_S6_", "uint64_t* llvm::SmallVectorImpl<uint64_t>::insert<char const*>(uint64_t*, char const*, char const*)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter4EmitEjj", "llvm::BitstreamWriter::Emit(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIyEaSERKS1_", "llvm::SmallVectorImpl<uint64_t>::operator=(llvm::SmallVectorImpl<uint64_t> const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang9ASTWriter23QueuedCXXBaseSpecifiersELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ASTWriter::QueuedCXXBaseSpecifiers, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPN5clang4DeclEE6appendINS1_18IdentifierResolver8iteratorEEEvT_S8_", "void llvm::SmallVectorImpl<clang::Decl*>::append<clang::IdentifierResolver::iterator>(clang::IdentifierResolver::iterator, clang::IdentifierResolver::iterator)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter24EmitRecordWithAbbrevImplIyEEvjRNS_15SmallVectorImplIT_EENS_9StringRefE", "void llvm::BitstreamWriter::EmitRecordWithAbbrevImpl<uint64_t>(unsigned int, llvm::SmallVectorImpl<uint64_t>&, llvm::StringRef)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter20EmitAbbreviatedFieldIhEEvRKNS_15BitCodeAbbrevOpET_", "void llvm::BitstreamWriter::EmitAbbreviatedField<unsigned char>(llvm::BitCodeAbbrevOp const&, unsigned char)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter20EmitAbbreviatedFieldIyEEvRKNS_15BitCodeAbbrevOpET_", "void llvm::BitstreamWriter::EmitAbbreviatedField<uint64_t>(llvm::BitCodeAbbrevOp const&, uint64_t)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter11FlushToWordEv", "llvm::BitstreamWriter::FlushToWord()"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter9EmitVBR64Eyj", "llvm::BitstreamWriter::EmitVBR64(uint64_t, unsigned int)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIyE6insertEPyRKy", "llvm::SmallVectorImpl<uint64_t>::insert(uint64_t*, uint64_t const&)"),
	mu_demangle_test("_ZN4llvm15BitstreamWriter12EncodeAbbrevEPNS_13BitCodeAbbrevE", "llvm::BitstreamWriter::EncodeAbbrev(llvm::BitCodeAbbrev*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter5VisitEPNS_4DeclE", "clang::ASTDeclWriter::Visit(clang::Decl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter9VisitDeclEPNS_4DeclE", "clang::ASTDeclWriter::VisitDecl(clang::Decl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter24VisitTranslationUnitDeclEPNS_19TranslationUnitDeclE", "clang::ASTDeclWriter::VisitTranslationUnitDecl(clang::TranslationUnitDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter14VisitNamedDeclEPNS_9NamedDeclE", "clang::ASTDeclWriter::VisitNamedDecl(clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter13VisitTypeDeclEPNS_8TypeDeclE", "clang::ASTDeclWriter::VisitTypeDecl(clang::TypeDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter16VisitTypedefDeclEPNS_11TypedefDeclE", "clang::ASTDeclWriter::VisitTypedefDecl(clang::TypedefDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter12VisitTagDeclEPNS_7TagDeclE", "clang::ASTDeclWriter::VisitTagDecl(clang::TagDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter13VisitEnumDeclEPNS_8EnumDeclE", "clang::ASTDeclWriter::VisitEnumDecl(clang::EnumDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter15VisitRecordDeclEPNS_10RecordDeclE", "clang::ASTDeclWriter::VisitRecordDecl(clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter14VisitValueDeclEPNS_9ValueDeclE", "clang::ASTDeclWriter::VisitValueDecl(clang::ValueDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter21VisitEnumConstantDeclEPNS_16EnumConstantDeclE", "clang::ASTDeclWriter::VisitEnumConstantDecl(clang::EnumConstantDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter19VisitDeclaratorDeclEPNS_14DeclaratorDeclE", "clang::ASTDeclWriter::VisitDeclaratorDecl(clang::DeclaratorDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter17VisitFunctionDeclEPNS_12FunctionDeclE", "clang::ASTDeclWriter::VisitFunctionDecl(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter19VisitObjCMethodDeclEPNS_14ObjCMethodDeclE", "clang::ASTDeclWriter::VisitObjCMethodDecl(clang::ObjCMethodDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter22VisitObjCContainerDeclEPNS_17ObjCContainerDeclE", "clang::ASTDeclWriter::VisitObjCContainerDecl(clang::ObjCContainerDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter22VisitObjCInterfaceDeclEPNS_17ObjCInterfaceDeclE", "clang::ASTDeclWriter::VisitObjCInterfaceDecl(clang::ObjCInterfaceDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter17VisitObjCIvarDeclEPNS_12ObjCIvarDeclE", "clang::ASTDeclWriter::VisitObjCIvarDecl(clang::ObjCIvarDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter14VisitFieldDeclEPNS_9FieldDeclE", "clang::ASTDeclWriter::VisitFieldDecl(clang::FieldDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter21VisitObjCProtocolDeclEPNS_16ObjCProtocolDeclE", "clang::ASTDeclWriter::VisitObjCProtocolDecl(clang::ObjCProtocolDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter24VisitObjCAtDefsFieldDeclEPNS_19ObjCAtDefsFieldDeclE", "clang::ASTDeclWriter::VisitObjCAtDefsFieldDecl(clang::ObjCAtDefsFieldDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter18VisitObjCClassDeclEPNS_13ObjCClassDeclE", "clang::ASTDeclWriter::VisitObjCClassDecl(clang::ObjCClassDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter28VisitObjCForwardProtocolDeclEPNS_23ObjCForwardProtocolDeclE", "clang::ASTDeclWriter::VisitObjCForwardProtocolDecl(clang::ObjCForwardProtocolDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter21VisitObjCCategoryDeclEPNS_16ObjCCategoryDeclE", "clang::ASTDeclWriter::VisitObjCCategoryDecl(clang::ObjCCategoryDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter28VisitObjCCompatibleAliasDeclEPNS_23ObjCCompatibleAliasDeclE", "clang::ASTDeclWriter::VisitObjCCompatibleAliasDecl(clang::ObjCCompatibleAliasDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter21VisitObjCPropertyDeclEPNS_16ObjCPropertyDeclE", "clang::ASTDeclWriter::VisitObjCPropertyDecl(clang::ObjCPropertyDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter17VisitObjCImplDeclEPNS_12ObjCImplDeclE", "clang::ASTDeclWriter::VisitObjCImplDecl(clang::ObjCImplDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter25VisitObjCCategoryImplDeclEPNS_20ObjCCategoryImplDeclE", "clang::ASTDeclWriter::VisitObjCCategoryImplDecl(clang::ObjCCategoryImplDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter27VisitObjCImplementationDeclEPNS_22ObjCImplementationDeclE", "clang::ASTDeclWriter::VisitObjCImplementationDecl(clang::ObjCImplementationDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter25VisitObjCPropertyImplDeclEPNS_20ObjCPropertyImplDeclE", "clang::ASTDeclWriter::VisitObjCPropertyImplDecl(clang::ObjCPropertyImplDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter22VisitIndirectFieldDeclEPNS_17IndirectFieldDeclE", "clang::ASTDeclWriter::VisitIndirectFieldDecl(clang::IndirectFieldDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter12VisitVarDeclEPNS_7VarDeclE", "clang::ASTDeclWriter::VisitVarDecl(clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter22VisitImplicitParamDeclEPNS_17ImplicitParamDeclE", "clang::ASTDeclWriter::VisitImplicitParamDecl(clang::ImplicitParamDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter16VisitParmVarDeclEPNS_11ParmVarDeclE", "clang::ASTDeclWriter::VisitParmVarDecl(clang::ParmVarDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter21VisitFileScopeAsmDeclEPNS_16FileScopeAsmDeclE", "clang::ASTDeclWriter::VisitFileScopeAsmDecl(clang::FileScopeAsmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter14VisitBlockDeclEPNS_9BlockDeclE", "clang::ASTDeclWriter::VisitBlockDecl(clang::BlockDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter20VisitLinkageSpecDeclEPNS_15LinkageSpecDeclE", "clang::ASTDeclWriter::VisitLinkageSpecDecl(clang::LinkageSpecDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter18VisitNamespaceDeclEPNS_13NamespaceDeclE", "clang::ASTDeclWriter::VisitNamespaceDecl(clang::NamespaceDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter23VisitNamespaceAliasDeclEPNS_18NamespaceAliasDeclE", "clang::ASTDeclWriter::VisitNamespaceAliasDecl(clang::NamespaceAliasDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter14VisitUsingDeclEPNS_9UsingDeclE", "clang::ASTDeclWriter::VisitUsingDecl(clang::UsingDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter20VisitUsingShadowDeclEPNS_15UsingShadowDeclE", "clang::ASTDeclWriter::VisitUsingShadowDecl(clang::UsingShadowDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter23VisitUsingDirectiveDeclEPNS_18UsingDirectiveDeclE", "clang::ASTDeclWriter::VisitUsingDirectiveDecl(clang::UsingDirectiveDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter29VisitUnresolvedUsingValueDeclEPNS_24UnresolvedUsingValueDeclE", "clang::ASTDeclWriter::VisitUnresolvedUsingValueDecl(clang::UnresolvedUsingValueDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter32VisitUnresolvedUsingTypenameDeclEPNS_27UnresolvedUsingTypenameDeclE", "clang::ASTDeclWriter::VisitUnresolvedUsingTypenameDecl(clang::UnresolvedUsingTypenameDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter18VisitCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::ASTDeclWriter::VisitCXXRecordDecl(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter18VisitCXXMethodDeclEPNS_13CXXMethodDeclE", "clang::ASTDeclWriter::VisitCXXMethodDecl(clang::CXXMethodDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter23VisitCXXConstructorDeclEPNS_18CXXConstructorDeclE", "clang::ASTDeclWriter::VisitCXXConstructorDecl(clang::CXXConstructorDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter22VisitCXXDestructorDeclEPNS_17CXXDestructorDeclE", "clang::ASTDeclWriter::VisitCXXDestructorDecl(clang::CXXDestructorDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter22VisitCXXConversionDeclEPNS_17CXXConversionDeclE", "clang::ASTDeclWriter::VisitCXXConversionDecl(clang::CXXConversionDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter19VisitAccessSpecDeclEPNS_14AccessSpecDeclE", "clang::ASTDeclWriter::VisitAccessSpecDecl(clang::AccessSpecDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter15VisitFriendDeclEPNS_10FriendDeclE", "clang::ASTDeclWriter::VisitFriendDecl(clang::FriendDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter23VisitFriendTemplateDeclEPNS_18FriendTemplateDeclE", "clang::ASTDeclWriter::VisitFriendTemplateDecl(clang::FriendTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter17VisitTemplateDeclEPNS_12TemplateDeclE", "clang::ASTDeclWriter::VisitTemplateDecl(clang::TemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter29VisitRedeclarableTemplateDeclEPNS_24RedeclarableTemplateDeclE", "clang::ASTDeclWriter::VisitRedeclarableTemplateDecl(clang::RedeclarableTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter22VisitClassTemplateDeclEPNS_17ClassTemplateDeclE", "clang::ASTDeclWriter::VisitClassTemplateDecl(clang::ClassTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter36VisitClassTemplateSpecializationDeclEPNS_31ClassTemplateSpecializationDeclE", "clang::ASTDeclWriter::VisitClassTemplateSpecializationDecl(clang::ClassTemplateSpecializationDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter43VisitClassTemplatePartialSpecializationDeclEPNS_38ClassTemplatePartialSpecializationDeclE", "clang::ASTDeclWriter::VisitClassTemplatePartialSpecializationDecl(clang::ClassTemplatePartialSpecializationDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter25VisitFunctionTemplateDeclEPNS_20FunctionTemplateDeclE", "clang::ASTDeclWriter::VisitFunctionTemplateDecl(clang::FunctionTemplateDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter25VisitTemplateTypeParmDeclEPNS_20TemplateTypeParmDeclE", "clang::ASTDeclWriter::VisitTemplateTypeParmDecl(clang::TemplateTypeParmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter28VisitNonTypeTemplateParmDeclEPNS_23NonTypeTemplateParmDeclE", "clang::ASTDeclWriter::VisitNonTypeTemplateParmDecl(clang::NonTypeTemplateParmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter29VisitTemplateTemplateParmDeclEPNS_24TemplateTemplateParmDeclE", "clang::ASTDeclWriter::VisitTemplateTemplateParmDecl(clang::TemplateTemplateParmDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter21VisitStaticAssertDeclEPNS_16StaticAssertDeclE", "clang::ASTDeclWriter::VisitStaticAssertDecl(clang::StaticAssertDecl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter16VisitDeclContextEPNS_11DeclContextEyy", "clang::ASTDeclWriter::VisitDeclContext(clang::DeclContext*, uint64_t, uint64_t)"),
	mu_demangle_test("_ZN5clang9ASTWriter22WriteDeclsBlockAbbrevsEv", "clang::ASTWriter::WriteDeclsBlockAbbrevs()"),
	mu_demangle_test("_ZN5clang9ASTWriter9WriteDeclERNS_10ASTContextEPNS_4DeclE", "clang::ASTWriter::WriteDecl(clang::ASTContext&, clang::Decl*)"),
	mu_demangle_test("_ZN5clang11DeclVisitorINS_13ASTDeclWriterEvE5VisitEPNS_4DeclE", "clang::DeclVisitor<clang::ASTDeclWriter, void>::Visit(clang::Decl*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter17VisitRedeclarableINS_7TagDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclWriter::VisitRedeclarable<clang::TagDecl>(clang::Redeclarable<clang::TagDecl>*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter17VisitRedeclarableINS_12FunctionDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclWriter::VisitRedeclarable<clang::FunctionDecl>(clang::Redeclarable<clang::FunctionDecl>*)"),
	mu_demangle_test("_ZN5clang13ASTDeclWriter17VisitRedeclarableINS_7VarDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclWriter::VisitRedeclarable<clang::VarDecl>(clang::Redeclarable<clang::VarDecl>*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter31AddExplicitTemplateArgumentListERKNS_28ExplicitTemplateArgumentListE", "clang::ASTStmtWriter::AddExplicitTemplateArgumentList(clang::ExplicitTemplateArgumentList const&)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter9VisitStmtEPNS_4StmtE", "clang::ASTStmtWriter::VisitStmt(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter13VisitNullStmtEPNS_8NullStmtE", "clang::ASTStmtWriter::VisitNullStmt(clang::NullStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter17VisitCompoundStmtEPNS_12CompoundStmtE", "clang::ASTStmtWriter::VisitCompoundStmt(clang::CompoundStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter15VisitSwitchCaseEPNS_10SwitchCaseE", "clang::ASTStmtWriter::VisitSwitchCase(clang::SwitchCase*)"),
	mu_demangle_test("_ZN5clang9ASTWriter15getSwitchCaseIDEPNS_10SwitchCaseE", "clang::ASTWriter::getSwitchCaseID(clang::SwitchCase*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter13VisitCaseStmtEPNS_8CaseStmtE", "clang::ASTStmtWriter::VisitCaseStmt(clang::CaseStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter16VisitDefaultStmtEPNS_11DefaultStmtE", "clang::ASTStmtWriter::VisitDefaultStmt(clang::DefaultStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter14VisitLabelStmtEPNS_9LabelStmtE", "clang::ASTStmtWriter::VisitLabelStmt(clang::LabelStmt*)"),
	mu_demangle_test("_ZN5clang9ASTWriter10GetLabelIDEPNS_9LabelStmtE", "clang::ASTWriter::GetLabelID(clang::LabelStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter11VisitIfStmtEPNS_6IfStmtE", "clang::ASTStmtWriter::VisitIfStmt(clang::IfStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter15VisitSwitchStmtEPNS_10SwitchStmtE", "clang::ASTStmtWriter::VisitSwitchStmt(clang::SwitchStmt*)"),
	mu_demangle_test("_ZN5clang9ASTWriter18RecordSwitchCaseIDEPNS_10SwitchCaseE", "clang::ASTWriter::RecordSwitchCaseID(clang::SwitchCase*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter14VisitWhileStmtEPNS_9WhileStmtE", "clang::ASTStmtWriter::VisitWhileStmt(clang::WhileStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter11VisitDoStmtEPNS_6DoStmtE", "clang::ASTStmtWriter::VisitDoStmt(clang::DoStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter12VisitForStmtEPNS_7ForStmtE", "clang::ASTStmtWriter::VisitForStmt(clang::ForStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter13VisitGotoStmtEPNS_8GotoStmtE", "clang::ASTStmtWriter::VisitGotoStmt(clang::GotoStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitIndirectGotoStmtEPNS_16IndirectGotoStmtE", "clang::ASTStmtWriter::VisitIndirectGotoStmt(clang::IndirectGotoStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter17VisitContinueStmtEPNS_12ContinueStmtE", "clang::ASTStmtWriter::VisitContinueStmt(clang::ContinueStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter14VisitBreakStmtEPNS_9BreakStmtE", "clang::ASTStmtWriter::VisitBreakStmt(clang::BreakStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter15VisitReturnStmtEPNS_10ReturnStmtE", "clang::ASTStmtWriter::VisitReturnStmt(clang::ReturnStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter13VisitDeclStmtEPNS_8DeclStmtE", "clang::ASTStmtWriter::VisitDeclStmt(clang::DeclStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter12VisitAsmStmtEPNS_7AsmStmtE", "clang::ASTStmtWriter::VisitAsmStmt(clang::AsmStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter9VisitExprEPNS_4ExprE", "clang::ASTStmtWriter::VisitExpr(clang::Expr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter19VisitPredefinedExprEPNS_14PredefinedExprE", "clang::ASTStmtWriter::VisitPredefinedExpr(clang::PredefinedExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter16VisitDeclRefExprEPNS_11DeclRefExprE", "clang::ASTStmtWriter::VisitDeclRefExpr(clang::DeclRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter19VisitIntegerLiteralEPNS_14IntegerLiteralE", "clang::ASTStmtWriter::VisitIntegerLiteral(clang::IntegerLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter20VisitFloatingLiteralEPNS_15FloatingLiteralE", "clang::ASTStmtWriter::VisitFloatingLiteral(clang::FloatingLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitImaginaryLiteralEPNS_16ImaginaryLiteralE", "clang::ASTStmtWriter::VisitImaginaryLiteral(clang::ImaginaryLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitStringLiteralEPNS_13StringLiteralE", "clang::ASTStmtWriter::VisitStringLiteral(clang::StringLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitCharacterLiteralEPNS_16CharacterLiteralE", "clang::ASTStmtWriter::VisitCharacterLiteral(clang::CharacterLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter14VisitParenExprEPNS_9ParenExprE", "clang::ASTStmtWriter::VisitParenExpr(clang::ParenExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitParenListExprEPNS_13ParenListExprE", "clang::ASTStmtWriter::VisitParenListExpr(clang::ParenListExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitUnaryOperatorEPNS_13UnaryOperatorE", "clang::ASTStmtWriter::VisitUnaryOperator(clang::UnaryOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter17VisitOffsetOfExprEPNS_12OffsetOfExprE", "clang::ASTStmtWriter::VisitOffsetOfExpr(clang::OffsetOfExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitSizeOfAlignOfExprEPNS_17SizeOfAlignOfExprE", "clang::ASTStmtWriter::VisitSizeOfAlignOfExpr(clang::SizeOfAlignOfExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter23VisitArraySubscriptExprEPNS_18ArraySubscriptExprE", "clang::ASTStmtWriter::VisitArraySubscriptExpr(clang::ArraySubscriptExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter13VisitCallExprEPNS_8CallExprE", "clang::ASTStmtWriter::VisitCallExpr(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter15VisitMemberExprEPNS_10MemberExprE", "clang::ASTStmtWriter::VisitMemberExpr(clang::MemberExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter16VisitObjCIsaExprEPNS_11ObjCIsaExprE", "clang::ASTStmtWriter::VisitObjCIsaExpr(clang::ObjCIsaExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter13VisitCastExprEPNS_8CastExprE", "clang::ASTStmtWriter::VisitCastExpr(clang::CastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter19VisitBinaryOperatorEPNS_14BinaryOperatorE", "clang::ASTStmtWriter::VisitBinaryOperator(clang::BinaryOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter27VisitCompoundAssignOperatorEPNS_22CompoundAssignOperatorE", "clang::ASTStmtWriter::VisitCompoundAssignOperator(clang::CompoundAssignOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter24VisitConditionalOperatorEPNS_19ConditionalOperatorE", "clang::ASTStmtWriter::VisitConditionalOperator(clang::ConditionalOperator*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitImplicitCastExprEPNS_16ImplicitCastExprE", "clang::ASTStmtWriter::VisitImplicitCastExpr(clang::ImplicitCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitExplicitCastExprEPNS_16ExplicitCastExprE", "clang::ASTStmtWriter::VisitExplicitCastExpr(clang::ExplicitCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter19VisitCStyleCastExprEPNS_14CStyleCastExprE", "clang::ASTStmtWriter::VisitCStyleCastExpr(clang::CStyleCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter24VisitCompoundLiteralExprEPNS_19CompoundLiteralExprE", "clang::ASTStmtWriter::VisitCompoundLiteralExpr(clang::CompoundLiteralExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter25VisitExtVectorElementExprEPNS_20ExtVectorElementExprE", "clang::ASTStmtWriter::VisitExtVectorElementExpr(clang::ExtVectorElementExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter17VisitInitListExprEPNS_12InitListExprE", "clang::ASTStmtWriter::VisitInitListExpr(clang::InitListExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter23VisitDesignatedInitExprEPNS_18DesignatedInitExprE", "clang::ASTStmtWriter::VisitDesignatedInitExpr(clang::DesignatedInitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter26VisitImplicitValueInitExprEPNS_21ImplicitValueInitExprE", "clang::ASTStmtWriter::VisitImplicitValueInitExpr(clang::ImplicitValueInitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter14VisitVAArgExprEPNS_9VAArgExprE", "clang::ASTStmtWriter::VisitVAArgExpr(clang::VAArgExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitAddrLabelExprEPNS_13AddrLabelExprE", "clang::ASTStmtWriter::VisitAddrLabelExpr(clang::AddrLabelExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter13VisitStmtExprEPNS_8StmtExprE", "clang::ASTStmtWriter::VisitStmtExpr(clang::StmtExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter15VisitChooseExprEPNS_10ChooseExprE", "clang::ASTStmtWriter::VisitChooseExpr(clang::ChooseExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter16VisitGNUNullExprEPNS_11GNUNullExprE", "clang::ASTStmtWriter::VisitGNUNullExpr(clang::GNUNullExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitShuffleVectorExprEPNS_17ShuffleVectorExprE", "clang::ASTStmtWriter::VisitShuffleVectorExpr(clang::ShuffleVectorExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter14VisitBlockExprEPNS_9BlockExprE", "clang::ASTStmtWriter::VisitBlockExpr(clang::BlockExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitBlockDeclRefExprEPNS_16BlockDeclRefExprE", "clang::ASTStmtWriter::VisitBlockDeclRefExpr(clang::BlockDeclRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitObjCStringLiteralEPNS_17ObjCStringLiteralE", "clang::ASTStmtWriter::VisitObjCStringLiteral(clang::ObjCStringLiteral*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter19VisitObjCEncodeExprEPNS_14ObjCEncodeExprE", "clang::ASTStmtWriter::VisitObjCEncodeExpr(clang::ObjCEncodeExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitObjCSelectorExprEPNS_16ObjCSelectorExprE", "clang::ASTStmtWriter::VisitObjCSelectorExpr(clang::ObjCSelectorExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitObjCProtocolExprEPNS_16ObjCProtocolExprE", "clang::ASTStmtWriter::VisitObjCProtocolExpr(clang::ObjCProtocolExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter20VisitObjCIvarRefExprEPNS_15ObjCIvarRefExprE", "clang::ASTStmtWriter::VisitObjCIvarRefExpr(clang::ObjCIvarRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter24VisitObjCPropertyRefExprEPNS_19ObjCPropertyRefExprE", "clang::ASTStmtWriter::VisitObjCPropertyRefExpr(clang::ObjCPropertyRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter20VisitObjCMessageExprEPNS_15ObjCMessageExprE", "clang::ASTStmtWriter::VisitObjCMessageExpr(clang::ObjCMessageExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter26VisitObjCForCollectionStmtEPNS_21ObjCForCollectionStmtE", "clang::ASTStmtWriter::VisitObjCForCollectionStmt(clang::ObjCForCollectionStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter20VisitObjCAtCatchStmtEPNS_15ObjCAtCatchStmtE", "clang::ASTStmtWriter::VisitObjCAtCatchStmt(clang::ObjCAtCatchStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitObjCAtFinallyStmtEPNS_17ObjCAtFinallyStmtE", "clang::ASTStmtWriter::VisitObjCAtFinallyStmt(clang::ObjCAtFinallyStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitObjCAtTryStmtEPNS_13ObjCAtTryStmtE", "clang::ASTStmtWriter::VisitObjCAtTryStmt(clang::ObjCAtTryStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter27VisitObjCAtSynchronizedStmtEPNS_22ObjCAtSynchronizedStmtE", "clang::ASTStmtWriter::VisitObjCAtSynchronizedStmt(clang::ObjCAtSynchronizedStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter20VisitObjCAtThrowStmtEPNS_15ObjCAtThrowStmtE", "clang::ASTStmtWriter::VisitObjCAtThrowStmt(clang::ObjCAtThrowStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter17VisitCXXCatchStmtEPNS_12CXXCatchStmtE", "clang::ASTStmtWriter::VisitCXXCatchStmt(clang::CXXCatchStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter15VisitCXXTryStmtEPNS_10CXXTryStmtE", "clang::ASTStmtWriter::VisitCXXTryStmt(clang::CXXTryStmt*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter24VisitCXXOperatorCallExprEPNS_19CXXOperatorCallExprE", "clang::ASTStmtWriter::VisitCXXOperatorCallExpr(clang::CXXOperatorCallExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitCXXMemberCallExprEPNS_17CXXMemberCallExprE", "clang::ASTStmtWriter::VisitCXXMemberCallExpr(clang::CXXMemberCallExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitCXXConstructExprEPNS_16CXXConstructExprE", "clang::ASTStmtWriter::VisitCXXConstructExpr(clang::CXXConstructExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter27VisitCXXTemporaryObjectExprEPNS_22CXXTemporaryObjectExprE", "clang::ASTStmtWriter::VisitCXXTemporaryObjectExpr(clang::CXXTemporaryObjectExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitCXXNamedCastExprEPNS_16CXXNamedCastExprE", "clang::ASTStmtWriter::VisitCXXNamedCastExpr(clang::CXXNamedCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitCXXStaticCastExprEPNS_17CXXStaticCastExprE", "clang::ASTStmtWriter::VisitCXXStaticCastExpr(clang::CXXStaticCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter23VisitCXXDynamicCastExprEPNS_18CXXDynamicCastExprE", "clang::ASTStmtWriter::VisitCXXDynamicCastExpr(clang::CXXDynamicCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter27VisitCXXReinterpretCastExprEPNS_22CXXReinterpretCastExprE", "clang::ASTStmtWriter::VisitCXXReinterpretCastExpr(clang::CXXReinterpretCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitCXXConstCastExprEPNS_16CXXConstCastExprE", "clang::ASTStmtWriter::VisitCXXConstCastExpr(clang::CXXConstCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter26VisitCXXFunctionalCastExprEPNS_21CXXFunctionalCastExprE", "clang::ASTStmtWriter::VisitCXXFunctionalCastExpr(clang::CXXFunctionalCastExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter23VisitCXXBoolLiteralExprEPNS_18CXXBoolLiteralExprE", "clang::ASTStmtWriter::VisitCXXBoolLiteralExpr(clang::CXXBoolLiteralExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter26VisitCXXNullPtrLiteralExprEPNS_21CXXNullPtrLiteralExprE", "clang::ASTStmtWriter::VisitCXXNullPtrLiteralExpr(clang::CXXNullPtrLiteralExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitCXXTypeidExprEPNS_13CXXTypeidExprE", "clang::ASTStmtWriter::VisitCXXTypeidExpr(clang::CXXTypeidExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitCXXUuidofExprEPNS_13CXXUuidofExprE", "clang::ASTStmtWriter::VisitCXXUuidofExpr(clang::CXXUuidofExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter16VisitCXXThisExprEPNS_11CXXThisExprE", "clang::ASTStmtWriter::VisitCXXThisExpr(clang::CXXThisExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter17VisitCXXThrowExprEPNS_12CXXThrowExprE", "clang::ASTStmtWriter::VisitCXXThrowExpr(clang::CXXThrowExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitCXXDefaultArgExprEPNS_17CXXDefaultArgExprE", "clang::ASTStmtWriter::VisitCXXDefaultArgExpr(clang::CXXDefaultArgExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter25VisitCXXBindTemporaryExprEPNS_20CXXBindTemporaryExprE", "clang::ASTStmtWriter::VisitCXXBindTemporaryExpr(clang::CXXBindTemporaryExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter27VisitCXXScalarValueInitExprEPNS_22CXXScalarValueInitExprE", "clang::ASTStmtWriter::VisitCXXScalarValueInitExpr(clang::CXXScalarValueInitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter15VisitCXXNewExprEPNS_10CXXNewExprE", "clang::ASTStmtWriter::VisitCXXNewExpr(clang::CXXNewExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter18VisitCXXDeleteExprEPNS_13CXXDeleteExprE", "clang::ASTStmtWriter::VisitCXXDeleteExpr(clang::CXXDeleteExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter28VisitCXXPseudoDestructorExprEPNS_23CXXPseudoDestructorExprE", "clang::ASTStmtWriter::VisitCXXPseudoDestructorExpr(clang::CXXPseudoDestructorExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter21VisitExprWithCleanupsEPNS_16ExprWithCleanupsE", "clang::ASTStmtWriter::VisitExprWithCleanups(clang::ExprWithCleanups*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter32VisitCXXDependentScopeMemberExprEPNS_27CXXDependentScopeMemberExprE", "clang::ASTStmtWriter::VisitCXXDependentScopeMemberExpr(clang::CXXDependentScopeMemberExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter30VisitDependentScopeDeclRefExprEPNS_25DependentScopeDeclRefExprE", "clang::ASTStmtWriter::VisitDependentScopeDeclRefExpr(clang::DependentScopeDeclRefExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter31VisitCXXUnresolvedConstructExprEPNS_26CXXUnresolvedConstructExprE", "clang::ASTStmtWriter::VisitCXXUnresolvedConstructExpr(clang::CXXUnresolvedConstructExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter17VisitOverloadExprEPNS_12OverloadExprE", "clang::ASTStmtWriter::VisitOverloadExpr(clang::OverloadExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter25VisitUnresolvedMemberExprEPNS_20UnresolvedMemberExprE", "clang::ASTStmtWriter::VisitUnresolvedMemberExpr(clang::UnresolvedMemberExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter25VisitUnresolvedLookupExprEPNS_20UnresolvedLookupExprE", "clang::ASTStmtWriter::VisitUnresolvedLookupExpr(clang::UnresolvedLookupExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter23VisitUnaryTypeTraitExprEPNS_18UnaryTypeTraitExprE", "clang::ASTStmtWriter::VisitUnaryTypeTraitExpr(clang::UnaryTypeTraitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter24VisitBinaryTypeTraitExprEPNS_19BinaryTypeTraitExprE", "clang::ASTStmtWriter::VisitBinaryTypeTraitExpr(clang::BinaryTypeTraitExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter20VisitCXXNoexceptExprEPNS_15CXXNoexceptExprE", "clang::ASTStmtWriter::VisitCXXNoexceptExpr(clang::CXXNoexceptExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter22VisitPackExpansionExprEPNS_17PackExpansionExprE", "clang::ASTStmtWriter::VisitPackExpansionExpr(clang::PackExpansionExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter19VisitSizeOfPackExprEPNS_14SizeOfPackExprE", "clang::ASTStmtWriter::VisitSizeOfPackExpr(clang::SizeOfPackExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter37VisitSubstNonTypeTemplateParmPackExprEPNS_32SubstNonTypeTemplateParmPackExprE", "clang::ASTStmtWriter::VisitSubstNonTypeTemplateParmPackExpr(clang::SubstNonTypeTemplateParmPackExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter20VisitOpaqueValueExprEPNS_15OpaqueValueExprE", "clang::ASTStmtWriter::VisitOpaqueValueExpr(clang::OpaqueValueExpr*)"),
	mu_demangle_test("_ZN5clang13ASTStmtWriter23VisitCUDAKernelCallExprEPNS_18CUDAKernelCallExprE", "clang::ASTStmtWriter::VisitCUDAKernelCallExpr(clang::CUDAKernelCallExpr*)"),
	mu_demangle_test("_ZN5clang9ASTWriter18ClearSwitchCaseIDsEv", "clang::ASTWriter::ClearSwitchCaseIDs()"),
	mu_demangle_test("_ZN5clang9ASTWriter12WriteSubStmtEPNS_4StmtE", "clang::ASTWriter::WriteSubStmt(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang9ASTWriter10FlushStmtsEv", "clang::ASTWriter::FlushStmts()"),
	mu_demangle_test("_ZN5clang11StmtVisitorINS_13ASTStmtWriterEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<clang::ASTStmtWriter, void>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang12PCHGeneratorC1ERKNS_12PreprocessorEbPKcPN4llvm11raw_ostreamE", "clang::PCHGenerator::PCHGenerator(clang::Preprocessor const&, bool, char const*, llvm::raw_ostream*)"),
	mu_demangle_test("_ZN5clang12PCHGeneratorC2ERKNS_12PreprocessorEbPKcPN4llvm11raw_ostreamE", "clang::PCHGenerator::PCHGenerator(clang::Preprocessor const&, bool, char const*, llvm::raw_ostream*)"),
	mu_demangle_test("_ZN5clang12PCHGenerator21HandleTranslationUnitERNS_10ASTContextE", "clang::PCHGenerator::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang12PCHGenerator22GetASTMutationListenerEv", "clang::PCHGenerator::GetASTMutationListener()"),
	mu_demangle_test("_ZN5clang12PCHGenerator27GetASTSerializationListenerEv", "clang::PCHGenerator::GetASTSerializationListener()"),
	mu_demangle_test("_ZN5clang12PCHGenerator29GetASTDeserializationListenerEv", "clang::PCHGenerator::GetASTDeserializationListener()"),
	mu_demangle_test("_ZN5clang17EmitBackendOutputERNS_10DiagnosticERKNS_14CodeGenOptionsERKNS_13TargetOptionsEPN4llvm6ModuleENS_13BackendActionEPNS8_11raw_ostreamE", "clang::EmitBackendOutput(clang::Diagnostic&, clang::CodeGenOptions const&, clang::TargetOptions const&, llvm::Module*, clang::BackendAction, llvm::raw_ostream*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGBlockInfoC1EPKNS_9BlockExprEPKc", "clang::CodeGen::CGBlockInfo::CGBlockInfo(clang::BlockExpr const*, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGBlockInfoC2EPKNS_9BlockExprEPKc", "clang::CodeGen::CGBlockInfo::CGBlockInfo(clang::BlockExpr const*, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitBlockLiteralEPKNS_9BlockExprE", "clang::CodeGen::CodeGenFunction::EmitBlockLiteral(clang::BlockExpr const*)"),
	mu_demangle_test("_Z16computeBlockInfoRN5clang7CodeGen13CodeGenModuleERNS0_11CGBlockInfoE", "computeBlockInfo(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo&)"),
	mu_demangle_test("_Z16buildGlobalBlockRN5clang7CodeGen13CodeGenModuleERKNS0_11CGBlockInfoEPN4llvm8ConstantE", "buildGlobalBlock(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&, llvm::Constant*)"),
	mu_demangle_test("_Z20buildBlockDescriptorRN5clang7CodeGen13CodeGenModuleERKNS0_11CGBlockInfoE", "buildBlockDescriptor(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule22getBlockDescriptorTypeEv", "clang::CodeGen::CodeGenModule::getBlockDescriptorType()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule26getGenericBlockLiteralTypeEv", "clang::CodeGen::CodeGenModule::getGenericBlockLiteralType()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitBlockCallExprEPKNS_8CallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitBlockCallExpr(clang::CallExpr const*, clang::CodeGen::ReturnValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18GetAddrOfBlockDeclEPKNS_7VarDeclEb", "clang::CodeGen::CodeGenFunction::GetAddrOfBlockDecl(clang::VarDecl const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule20GetAddrOfGlobalBlockEPKNS_9BlockExprEPKc", "clang::CodeGen::CodeGenModule::GetAddrOfGlobalBlock(clang::BlockExpr const*, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26GenerateCopyHelperFunctionERKNS0_11CGBlockInfoE", "clang::CodeGen::CodeGenFunction::GenerateCopyHelperFunction(clang::CodeGen::CGBlockInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction29GenerateDestroyHelperFunctionERKNS0_11CGBlockInfoE", "clang::CodeGen::CodeGenFunction::GenerateDestroyHelperFunction(clang::CodeGen::CGBlockInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17BuildBlockReleaseEPN4llvm5ValueENS0_15BlockFieldFlagsE", "clang::CodeGen::CodeGenFunction::BuildBlockRelease(llvm::Value*, clang::CodeGen::BlockFieldFlags)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction31GeneratebyrefCopyHelperFunctionEPKN4llvm4TypeENS0_15BlockFieldFlagsEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::GeneratebyrefCopyHelperFunction(llvm::Type const*, clang::CodeGen::BlockFieldFlags, clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction34GeneratebyrefDestroyHelperFunctionEPKN4llvm4TypeENS0_15BlockFieldFlagsEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::GeneratebyrefDestroyHelperFunction(llvm::Type const*, clang::CodeGen::BlockFieldFlags, clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule20BuildbyrefCopyHelperEPKN4llvm4TypeENS0_15BlockFieldFlagsEjPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::BuildbyrefCopyHelper(llvm::Type const*, clang::CodeGen::BlockFieldFlags, unsigned int, clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23BuildbyrefDestroyHelperEPKN4llvm4TypeENS0_15BlockFieldFlagsEjPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::BuildbyrefDestroyHelper(llvm::Type const*, clang::CodeGen::BlockFieldFlags, unsigned int, clang::VarDecl const*)"),
	mu_demangle_test("_ZSt21__inplace_stable_sortIPN12_GLOBAL__N_116BlockLayoutChunkEEvT_S3_", "void std::__inplace_stable_sort<(anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"),
	mu_demangle_test("_ZSt22__stable_sort_adaptiveIPN12_GLOBAL__N_116BlockLayoutChunkES2_lEvT_S3_T0_T1_", "void std::__stable_sort_adaptive<(anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long)"),
	mu_demangle_test("_ZSt24__merge_sort_with_bufferIPN12_GLOBAL__N_116BlockLayoutChunkES2_EvT_S3_T0_", "void std::__merge_sort_with_buffer<(anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"),
	mu_demangle_test("_ZSt16__merge_adaptiveIPN12_GLOBAL__N_116BlockLayoutChunkElS2_EvT_S3_S3_T0_S4_T1_S4_", "void std::__merge_adaptive<(anonymous namespace)::BlockLayoutChunk*, long, (anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long, long, (anonymous namespace)::BlockLayoutChunk*, long)"),
	mu_demangle_test("_ZSt13copy_backwardIPN12_GLOBAL__N_116BlockLayoutChunkES2_ET0_T_S4_S3_", "(anonymous namespace)::BlockLayoutChunk* std::copy_backward<(anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"),
	mu_demangle_test("_ZSt6rotateIPN12_GLOBAL__N_116BlockLayoutChunkEEvT_S3_S3_", "void std::rotate<(anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"),
	mu_demangle_test("_ZSt16__insertion_sortIPN12_GLOBAL__N_116BlockLayoutChunkEEvT_S3_", "void std::__insertion_sort<(anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"),
	mu_demangle_test("_ZSt22__merge_without_bufferIPN12_GLOBAL__N_116BlockLayoutChunkElEvT_S3_S3_T0_S4_", "void std::__merge_without_buffer<(anonymous namespace)::BlockLayoutChunk*, long>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long, long)"),
	mu_demangle_test("_Z15hasMutableFieldPKN5clang13CXXRecordDeclE", "hasMutableField(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN12_GLOBAL__N_116BlockLayoutChunkELb0EE4growEm", "llvm::SmallVectorTemplateBase<(anonymous namespace)::BlockLayoutChunk, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitBuiltinExprEPKNS_12FunctionDeclEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitBuiltinExpr(clang::FunctionDecl const*, unsigned int, clang::CallExpr const*)"),
	mu_demangle_test("_Z8EmitFAbsRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueENS_8QualTypeE", "EmitFAbs(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::QualType)"),
	mu_demangle_test("_Z16EmitBinaryAtomicRN5clang7CodeGen15CodeGenFunctionEN4llvm9Intrinsic2IDEPKNS_8CallExprE", "EmitBinaryAtomic(clang::CodeGen::CodeGenFunction&, llvm::Intrinsic::ID, clang::CallExpr const*)"),
	mu_demangle_test("_Z20EmitBinaryAtomicPostRN5clang7CodeGen15CodeGenFunctionEN4llvm9Intrinsic2IDEPKNS_8CallExprENS3_11Instruction9BinaryOpsE", "EmitBinaryAtomicPost(clang::CodeGen::CodeGenFunction&, llvm::Intrinsic::ID, clang::CallExpr const*, llvm::Instruction::BinaryOps)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitTargetBuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitTargetBuiltinExpr(unsigned int, clang::CallExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitARMBuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitARMBuiltinExpr(unsigned int, clang::CallExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitX86BuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitX86BuiltinExpr(unsigned int, clang::CallExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitPPCBuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitPPCBuiltinExpr(unsigned int, clang::CallExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13EmitNeonSplatEPN4llvm5ValueEPNS2_8ConstantE", "clang::CodeGen::CodeGenFunction::EmitNeonSplat(llvm::Value*, llvm::Constant*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitNeonCallEPN4llvm8FunctionERNS2_15SmallVectorImplIPNS2_5ValueEEEPKcjb", "clang::CodeGen::CodeGenFunction::EmitNeonCall(llvm::Function*, llvm::SmallVectorImpl<llvm::Value*>&, char const*, unsigned int, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitNeonShiftVectorEPN4llvm5ValueEPKNS2_4TypeEb", "clang::CodeGen::CodeGenFunction::EmitNeonShiftVector(llvm::Value*, llvm::Type const*, bool)"),
	mu_demangle_test("_Z19GetPointeeAlignmentRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprE", "GetPointeeAlignment(clang::CodeGen::CodeGenFunction&, clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11BuildVectorERKN4llvm15SmallVectorImplIPNS2_5ValueEEE", "clang::CodeGen::CodeGenFunction::BuildVector(llvm::SmallVectorImpl<llvm::Value*> const&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule28TryEmitBaseDestructorAsAliasEPKNS_17CXXDestructorDeclE", "clang::CodeGen::CodeGenModule::TryEmitBaseDestructorAsAlias(clang::CXXDestructorDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule24TryEmitDefinitionAsAliasENS0_10GlobalDeclES2_", "clang::CodeGen::CodeGenModule::TryEmitDefinitionAsAlias(clang::CodeGen::GlobalDecl, clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19EmitCXXConstructorsEPKNS_18CXXConstructorDeclE", "clang::CodeGen::CodeGenModule::EmitCXXConstructors(clang::CXXConstructorDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule18EmitCXXConstructorEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeE", "clang::CodeGen::CodeGenModule::EmitCXXConstructor(clang::CXXConstructorDecl const*, clang::CXXCtorType)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23GetAddrOfCXXConstructorEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeE", "clang::CodeGen::CodeGenModule::GetAddrOfCXXConstructor(clang::CXXConstructorDecl const*, clang::CXXCtorType)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule18EmitCXXDestructorsEPKNS_17CXXDestructorDeclE", "clang::CodeGen::CodeGenModule::EmitCXXDestructors(clang::CXXDestructorDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule17EmitCXXDestructorEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenModule::EmitCXXDestructor(clang::CXXDestructorDecl const*, clang::CXXDtorType)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule22GetAddrOfCXXDestructorEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenModule::GetAddrOfCXXDestructor(clang::CXXDestructorDecl const*, clang::CXXDtorType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16BuildVirtualCallEPKNS_13CXXMethodDeclEPN4llvm5ValueEPKNS5_4TypeE", "clang::CodeGen::CodeGenFunction::BuildVirtualCall(clang::CXXMethodDecl const*, llvm::Value*, llvm::Type const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25BuildAppleKextVirtualCallEPKNS_13CXXMethodDeclEPNS_19NestedNameSpecifierEPKN4llvm4TypeE", "clang::CodeGen::CodeGenFunction::BuildAppleKextVirtualCall(clang::CXXMethodDecl const*, clang::NestedNameSpecifier*, llvm::Type const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction35BuildAppleKextVirtualDestructorCallEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenFunction::BuildAppleKextVirtualDestructorCall(clang::CXXDestructorDecl const*, clang::CXXDtorType, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16BuildVirtualCallEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeEPN4llvm5ValueEPKNS6_4TypeE", "clang::CodeGen::CodeGenFunction::BuildVirtualCall(clang::CXXDestructorDecl const*, clang::CXXDtorType, llvm::Value*, llvm::Type const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule15GetAddrOfGlobalENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::GetAddrOfGlobal(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABID0Ev", "clang::CodeGen::CGCXXABI::~CGCXXABI()"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABID1Ev", "clang::CodeGen::CGCXXABI::~CGCXXABI()"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABID2Ev", "clang::CodeGen::CGCXXABI::~CGCXXABI()"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI24ConvertMemberPointerTypeEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::ConvertMemberPointerType(clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI31EmitLoadOfMemberFunctionPointerERNS0_15CodeGenFunctionERPN4llvm5ValueES6_PKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitLoadOfMemberFunctionPointer(clang::CodeGen::CodeGenFunction&, llvm::Value*&, llvm::Value*, clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI28EmitMemberDataPointerAddressERNS0_15CodeGenFunctionEPN4llvm5ValueES6_PKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitMemberDataPointerAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI27EmitMemberPointerConversionERNS0_15CodeGenFunctionEPKNS_8CastExprEPN4llvm5ValueE", "clang::CodeGen::CGCXXABI::EmitMemberPointerConversion(clang::CodeGen::CodeGenFunction&, clang::CastExpr const*, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI27EmitMemberPointerComparisonERNS0_15CodeGenFunctionEPN4llvm5ValueES6_PKNS_17MemberPointerTypeEb", "clang::CodeGen::CGCXXABI::EmitMemberPointerComparison(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI26EmitMemberPointerIsNotNullERNS0_15CodeGenFunctionEPN4llvm5ValueEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitMemberPointerIsNotNull(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI27EmitMemberPointerConversionEPN4llvm8ConstantEPKNS_8CastExprE", "clang::CodeGen::CGCXXABI::EmitMemberPointerConversion(llvm::Constant*, clang::CastExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI21EmitNullMemberPointerEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitNullMemberPointer(clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI17EmitMemberPointerEPKNS_13CXXMethodDeclE", "clang::CodeGen::CGCXXABI::EmitMemberPointer(clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI21EmitMemberDataPointerEPKNS_17MemberPointerTypeENS_9CharUnitsE", "clang::CodeGen::CGCXXABI::EmitMemberDataPointer(clang::MemberPointerType const*, clang::CharUnits)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI19isZeroInitializableEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::isZeroInitializable(clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI14BuildThisParamERNS0_15CodeGenFunctionERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CGCXXABI::BuildThisParam(clang::CodeGen::CodeGenFunction&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI13EmitThisParamERNS0_15CodeGenFunctionE", "clang::CodeGen::CGCXXABI::EmitThisParam(clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI19EmitReturnFromThunkERNS0_15CodeGenFunctionENS0_6RValueENS_8QualTypeE", "clang::CodeGen::CGCXXABI::EmitReturnFromThunk(clang::CodeGen::CodeGenFunction&, clang::CodeGen::RValue, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI18GetArrayCookieSizeEPKNS_10CXXNewExprE", "clang::CodeGen::CGCXXABI::GetArrayCookieSize(clang::CXXNewExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI21InitializeArrayCookieERNS0_15CodeGenFunctionEPN4llvm5ValueES6_PKNS_10CXXNewExprENS_8QualTypeE", "clang::CodeGen::CGCXXABI::InitializeArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::CXXNewExpr const*, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI15ReadArrayCookieERNS0_15CodeGenFunctionEPN4llvm5ValueEPKNS_13CXXDeleteExprENS_8QualTypeERS6_SB_RNS_9CharUnitsE", "clang::CodeGen::CGCXXABI::ReadArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::CXXDeleteExpr const*, clang::QualType, llvm::Value*&, llvm::Value*&, clang::CharUnits&)"),
	mu_demangle_test("_ZN5clang7CodeGen8CGCXXABI15EmitGuardedInitERNS0_15CodeGenFunctionERKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CGCXXABI::EmitGuardedInit(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::GlobalVariable*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_7CanQualINS_19FunctionNoProtoTypeEEEb", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CanQual<clang::FunctionNoProtoType>, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_7CanQualINS_17FunctionProtoTypeEEEb", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CanQual<clang::FunctionProtoType>, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_13CXXRecordDeclEPKNS_17FunctionProtoTypeE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXRecordDecl const*, clang::FunctionProtoType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_13CXXMethodDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXConstructorDecl const*, clang::CXXCtorType)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXDestructorDecl const*, clang::CXXDtorType)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_12FunctionDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::FunctionDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_14ObjCMethodDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS0_10GlobalDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_8QualTypeERKN4llvm11SmallVectorISt4pairINS0_6RValueES2_ELj16EEERKNS_12FunctionType7ExtInfoE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::QualType, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::FunctionType::ExtInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_8QualTypeERKN4llvm11SmallVectorISt4pairIPKNS_7VarDeclES2_ELj16EEERKNS_12FunctionType7ExtInfoE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::QualType, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&, clang::FunctionType::ExtInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CGFunctionInfoC1EjbjNS_7CanQualINS_4TypeEEEPKS4_j", "clang::CodeGen::CGFunctionInfo::CGFunctionInfo(unsigned int, bool, unsigned int, clang::CanQual<clang::Type>, clang::CanQual<clang::Type> const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen14CGFunctionInfoC2EjbjNS_7CanQualINS_4TypeEEEPKS4_j", "clang::CodeGen::CGFunctionInfo::CGFunctionInfo(unsigned int, bool, unsigned int, clang::CanQual<clang::Type>, clang::CanQual<clang::Type> const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18ExpandTypeFromArgsENS_8QualTypeENS0_6LValueEN4llvm14ilist_iteratorINS4_8ArgumentEEE", "clang::CodeGen::CodeGenFunction::ExpandTypeFromArgs(clang::QualType, clang::CodeGen::LValue, llvm::ilist_iterator<llvm::Argument>)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16ExpandTypeToArgsENS_8QualTypeENS0_6RValueERN4llvm11SmallVectorIPNS4_5ValueELj16EEE", "clang::CodeGen::CodeGenFunction::ExpandTypeToArgs(clang::QualType, clang::CodeGen::RValue, llvm::SmallVector<llvm::Value*, 16u>&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule18ReturnTypeUsesSRetERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenModule::ReturnTypeUsesSRet(clang::CodeGen::CGFunctionInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19ReturnTypeUsesFPRetENS_8QualTypeE", "clang::CodeGen::CodeGenModule::ReturnTypeUsesFPRet(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15GetFunctionTypeENS0_10GlobalDeclE", "clang::CodeGen::CodeGenTypes::GetFunctionType(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes15GetFunctionTypeERKNS0_14CGFunctionInfoEbb", "clang::CodeGen::CodeGenTypes::GetFunctionType(clang::CodeGen::CGFunctionInfo const&, bool, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes24GetFunctionTypeForVTableENS0_10GlobalDeclE", "clang::CodeGen::CodeGenTypes::GetFunctionTypeForVTable(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule22ConstructAttributeListERKNS0_14CGFunctionInfoEPKNS_4DeclERN4llvm11SmallVectorINS8_18AttributeWithIndexELj8EEERj", "clang::CodeGen::CodeGenModule::ConstructAttributeList(clang::CodeGen::CGFunctionInfo const&, clang::Decl const*, llvm::SmallVector<llvm::AttributeWithIndex, 8u>&, unsigned int&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitFunctionPrologERKNS0_14CGFunctionInfoEPN4llvm8FunctionERKNS5_11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitFunctionProlog(clang::CodeGen::CGFunctionInfo const&, llvm::Function*, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&)"),
	mu_demangle_test("_Z18CreateCoercedStorePN4llvm5ValueES1_bRN5clang7CodeGen15CodeGenFunctionE", "CreateCoercedStore(llvm::Value*, llvm::Value*, bool, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitFunctionEpilogERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenFunction::EmitFunctionEpilog(clang::CodeGen::CGFunctionInfo const&)"),
	mu_demangle_test("_Z17CreateCoercedLoadPN4llvm5ValueEPKNS_4TypeERN5clang7CodeGen15CodeGenFunctionE", "CreateCoercedLoad(llvm::Value*, llvm::Type const*, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitDelegateCallArgEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::EmitDelegateCallArg(clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11EmitCallArgEPKNS_4ExprENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitCallArg(clang::Expr const*, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitCallOrInvokeEPN4llvm5ValueEPKS4_S6_RKNS2_5TwineE", "clang::CodeGen::CodeGenFunction::EmitCallOrInvoke(llvm::Value*, llvm::Value* const*, llvm::Value* const*, llvm::Twine const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction8EmitCallERKNS0_14CGFunctionInfoEPN4llvm5ValueENS0_15ReturnValueSlotERKNS5_11SmallVectorISt4pairINS0_6RValueENS_8QualTypeEELj16EEEPKNS_4DeclEPPNS5_11InstructionE", "clang::CodeGen::CodeGenFunction::EmitCall(clang::CodeGen::CGFunctionInfo const&, llvm::Value*, clang::CodeGen::ReturnValueSlot, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::Decl const*, llvm::Instruction**)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction9EmitVAArgEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitVAArg(llvm::Value*, clang::QualType)"),
	mu_demangle_test("_Z34EnterStructPointerForCoercedAccessPN4llvm5ValueEPKNS_10StructTypeEyRN5clang7CodeGen15CodeGenFunctionE", "EnterStructPointerForCoercedAccess(llvm::Value*, llvm::StructType const*, uint64_t, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_Z24CoerceIntOrPtrToIntOrPtrPN4llvm5ValueEPKNS_4TypeERN5clang7CodeGen15CodeGenFunctionE", "CoerceIntOrPtrToIntOrPtr(llvm::Value*, llvm::Type const*, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CGFunctionInfo7ProfileIPKNS_7CanQualINS_4TypeEEEEEvRN4llvm16FoldingSetNodeIDERKNS_12FunctionType7ExtInfoES5_T_SF_", "void clang::CodeGen::CGFunctionInfo::Profile<clang::CanQual<clang::Type> const*>(llvm::FoldingSetNodeID&, clang::FunctionType::ExtInfo const&, clang::CanQual<clang::Type>, clang::CanQual<clang::Type> const*, clang::CanQual<clang::Type> const*)"),
	mu_demangle_test("_ZN4llvm10InvokeInstC2IPKPNS_5ValueEEES3_PNS_10BasicBlockES7_T_S8_jRKNS_5TwineEPNS_11InstructionE", "llvm::InvokeInst::InvokeInst<llvm::Value* const*>(llvm::Value*, llvm::BasicBlock*, llvm::BasicBlock*, llvm::Value* const*, llvm::Value* const*, unsigned int, llvm::Twine const&, llvm::Instruction*)"),
	mu_demangle_test("_ZN4llvm8CallInstC2IPKPNS_5ValueEEES3_T_S6_RKNS_5TwineEPNS_11InstructionE", "llvm::CallInst::CallInst<llvm::Value* const*>(llvm::Value*, llvm::Value* const*, llvm::Value* const*, llvm::Twine const&, llvm::Instruction*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule28GetNonVirtualBaseClassOffsetEPKNS_13CXXRecordDeclEPKPKNS_16CXXBaseSpecifierES9_", "clang::CodeGen::CodeGenModule::GetNonVirtualBaseClassOffset(clang::CXXRecordDecl const*, clang::CXXBaseSpecifier const* const*, clang::CXXBaseSpecifier const* const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction37GetAddressOfDirectBaseInCompleteClassEPN4llvm5ValueEPKNS_13CXXRecordDeclES7_b", "clang::CodeGen::CodeGenFunction::GetAddressOfDirectBaseInCompleteClass(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXRecordDecl const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21GetAddressOfBaseClassEPN4llvm5ValueEPKNS_13CXXRecordDeclEPKPKNS_16CXXBaseSpecifierESC_b", "clang::CodeGen::CodeGenFunction::GetAddressOfBaseClass(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXBaseSpecifier const* const*, clang::CXXBaseSpecifier const* const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25GetVirtualBaseClassOffsetEPN4llvm5ValueEPKNS_13CXXRecordDeclES7_", "clang::CodeGen::CodeGenFunction::GetVirtualBaseClassOffset(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_Z31ApplyNonVirtualAndVirtualOffsetRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEyS5_", "ApplyNonVirtualAndVirtualOffset(clang::CodeGen::CodeGenFunction&, llvm::Value*, uint64_t, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24GetAddressOfDerivedClassEPN4llvm5ValueEPKNS_13CXXRecordDeclEPKPKNS_16CXXBaseSpecifierESC_b", "clang::CodeGen::CodeGenFunction::GetAddressOfDerivedClass(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXBaseSpecifier const* const*, clang::CXXBaseSpecifier const* const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitConstructorBodyERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitConstructorBody(llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction30EmitDelegateCXXConstructorCallEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeERKN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitDelegateCXXConstructorCall(clang::CXXConstructorDecl const*, clang::CXXCtorType, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitCtorPrologueEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitCtorPrologue(clang::CXXConstructorDecl const*, clang::CXXCtorType, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24InitializeVTablePointersEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenFunction::InitializeVTablePointers(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitDestructorBodyERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitDestructorBody(llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EnterDtorCleanupsEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenFunction::EnterDtorCleanups(clang::CXXDestructorDecl const*, clang::CXXDtorType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitCXXDestructorCallEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeEbPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCXXDestructorCall(clang::CXXDestructorDecl const*, clang::CXXDtorType, bool, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitCXXAggrConstructorCallEPKNS_18CXXConstructorDeclEPKNS_17ConstantArrayTypeEPN4llvm5ValueENS_17ConstExprIteratorESB_b", "clang::CodeGen::CodeGenFunction::EmitCXXAggrConstructorCall(clang::CXXConstructorDecl const*, clang::ConstantArrayType const*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitCXXAggrConstructorCallEPKNS_18CXXConstructorDeclEPN4llvm5ValueES7_NS_17ConstExprIteratorES8_b", "clang::CodeGen::CodeGenFunction::EmitCXXAggrConstructorCall(clang::CXXConstructorDecl const*, llvm::Value*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22EmitCXXConstructorCallEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeEbPN4llvm5ValueENS_17ConstExprIteratorES9_", "clang::CodeGen::CodeGenFunction::EmitCXXConstructorCall(clang::CXXConstructorDecl const*, clang::CXXCtorType, bool, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25EmitCXXAggrDestructorCallEPKNS_17CXXDestructorDeclEPKNS_9ArrayTypeEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCXXAggrDestructorCall(clang::CXXDestructorDecl const*, clang::ArrayType const*, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25EmitCXXAggrDestructorCallEPKNS_17CXXDestructorDeclEPN4llvm5ValueES7_", "clang::CodeGen::CodeGenFunction::EmitCXXAggrDestructorCall(clang::CXXDestructorDecl const*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_Z15GetVTTParameterRN5clang7CodeGen15CodeGenFunctionENS0_10GlobalDeclEb", "GetVTTParameter(clang::CodeGen::CodeGenFunction&, clang::CodeGen::GlobalDecl, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction30EmitSynthesizedCXXCopyCtorCallEPKNS_18CXXConstructorDeclEPN4llvm5ValueES7_NS_17ConstExprIteratorES8_", "clang::CodeGen::CodeGenFunction::EmitSynthesizedCXXCopyCtorCall(clang::CXXConstructorDecl const*, llvm::Value*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21PushDestructorCleanupEPKNS_17CXXDestructorDeclEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::PushDestructorCleanup(clang::CXXDestructorDecl const*, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21PushDestructorCleanupENS_8QualTypeEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::PushDestructorCleanup(clang::QualType, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12GetVTablePtrEPN4llvm5ValueEPKNS2_4TypeE", "clang::CodeGen::CodeGenFunction::GetVTablePtr(llvm::Value*, llvm::Type const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction23InitializeVTablePointerENS0_13BaseSubobjectEPKNS_13CXXRecordDeclEyPN4llvm8ConstantES5_", "clang::CodeGen::CodeGenFunction::InitializeVTablePointer(clang::CodeGen::BaseSubobject, clang::CXXRecordDecl const*, uint64_t, llvm::Constant*, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24InitializeVTablePointersENS0_13BaseSubobjectEPKNS_13CXXRecordDeclEybPN4llvm8ConstantES5_RNS6_11SmallPtrSetIS5_Lj4EEE", "clang::CodeGen::CodeGenFunction::InitializeVTablePointers(clang::CodeGen::BaseSubobject, clang::CXXRecordDecl const*, uint64_t, bool, llvm::Constant*, clang::CXXRecordDecl const*, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallLocalDtorD1Ev", "(anonymous namespace)::CallLocalDtor::~CallLocalDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallLocalDtorD0Ev", "(anonymous namespace)::CallLocalDtor::~CallLocalDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallLocalDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallLocalDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallFieldDtorD1Ev", "(anonymous namespace)::CallFieldDtor::~CallFieldDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallFieldDtorD0Ev", "(anonymous namespace)::CallFieldDtor::~CallFieldDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallFieldDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallFieldDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CallArrayFieldDtorD1Ev", "(anonymous namespace)::CallArrayFieldDtor::~CallArrayFieldDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CallArrayFieldDtorD0Ev", "(anonymous namespace)::CallArrayFieldDtor::~CallArrayFieldDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CallArrayFieldDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallArrayFieldDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallDtorDeleteD1Ev", "(anonymous namespace)::CallDtorDelete::~CallDtorDelete()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallDtorDeleteD0Ev", "(anonymous namespace)::CallDtorDelete::~CallDtorDelete()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallDtorDelete4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallDtorDelete::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallBaseDtorD1Ev", "(anonymous namespace)::CallBaseDtor::~CallBaseDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallBaseDtorD0Ev", "(anonymous namespace)::CallBaseDtor::~CallBaseDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallBaseDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallBaseDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_Z24EmitAggMemberInitializerRN5clang7CodeGen15CodeGenFunctionENS0_6LValueEPN4llvm5ValueEPNS_18CXXCtorInitializerENS_8QualTypeEj", "EmitAggMemberInitializer(clang::CodeGen::CodeGenFunction&, clang::CodeGen::LValue, llvm::Value*, clang::CXXCtorInitializer*, clang::QualType, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallMemberDtorD1Ev", "(anonymous namespace)::CallMemberDtor::~CallMemberDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallMemberDtorD0Ev", "(anonymous namespace)::CallMemberDtor::~CallMemberDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallMemberDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallMemberDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN5clang11StmtVisitorIN12_GLOBAL__N_121DynamicThisUseCheckerEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::DynamicThisUseChecker, void>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang20EvaluatedExprVisitorIN12_GLOBAL__N_121DynamicThisUseCheckerEE9VisitStmtEPNS_4StmtE", "clang::EvaluatedExprVisitor<(anonymous namespace)::DynamicThisUseChecker>::VisitStmt(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang7CodeGen15DominatingValueINS0_6RValueEE10saved_type11needsSavingES2_", "clang::CodeGen::DominatingValue<clang::CodeGen::RValue>::saved_type::needsSaving(clang::CodeGen::RValue)"),
	mu_demangle_test("_ZN5clang7CodeGen15DominatingValueINS0_6RValueEE10saved_type4saveERNS0_15CodeGenFunctionES2_", "clang::CodeGen::DominatingValue<clang::CodeGen::RValue>::saved_type::save(clang::CodeGen::CodeGenFunction&, clang::CodeGen::RValue)"),
	mu_demangle_test("_ZN5clang7CodeGen15DominatingValueINS0_6RValueEE10saved_type7restoreERNS0_15CodeGenFunctionE", "clang::CodeGen::DominatingValue<clang::CodeGen::RValue>::saved_type::restore(clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack8allocateEm", "clang::CodeGen::EHScopeStack::allocate(unsigned long)"),
	mu_demangle_test("_ZNK5clang7CodeGen12EHScopeStack21getEnclosingEHCleanupENS1_8iteratorE", "clang::CodeGen::EHScopeStack::getEnclosingEHCleanup(clang::CodeGen::EHScopeStack::iterator) const"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack11pushCleanupENS0_11CleanupKindEm", "clang::CodeGen::EHScopeStack::pushCleanup(clang::CodeGen::CleanupKind, unsigned long)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack10popCleanupEv", "clang::CodeGen::EHScopeStack::popCleanup()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack13popNullFixupsEv", "clang::CodeGen::EHScopeStack::popNullFixups()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack10pushFilterEj", "clang::CodeGen::EHScopeStack::pushFilter(unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack9popFilterEv", "clang::CodeGen::EHScopeStack::popFilter()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack9pushCatchEj", "clang::CodeGen::EHScopeStack::pushCatch(unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack13pushTerminateEv", "clang::CodeGen::EHScopeStack::pushTerminate()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19initFullExprCleanupEv", "clang::CodeGen::CodeGenFunction::initFullExprCleanup()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack7CleanupD0Ev", "clang::CodeGen::EHScopeStack::Cleanup::~Cleanup()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack7CleanupD1Ev", "clang::CodeGen::EHScopeStack::Cleanup::~Cleanup()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack7CleanupD2Ev", "clang::CodeGen::EHScopeStack::Cleanup::~Cleanup()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19ResolveBranchFixupsEPN4llvm10BasicBlockE", "clang::CodeGen::CodeGenFunction::ResolveBranchFixups(llvm::BasicBlock*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16PopCleanupBlocksENS0_12EHScopeStack15stable_iteratorE", "clang::CodeGen::CodeGenFunction::PopCleanupBlocks(clang::CodeGen::EHScopeStack::stable_iterator)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15PopCleanupBlockEb", "clang::CodeGen::CodeGenFunction::PopCleanupBlock(bool)"),
	mu_demangle_test("_Z29ForwardPrebranchedFallthroughPN4llvm10BasicBlockES1_S1_", "ForwardPrebranchedFallthrough(llvm::BasicBlock*, llvm::BasicBlock*, llvm::BasicBlock*)"),
	mu_demangle_test("_Z20SimplifyCleanupEntryRN5clang7CodeGen15CodeGenFunctionEPN4llvm10BasicBlockE", "SimplifyCleanupEntry(clang::CodeGen::CodeGenFunction&, llvm::BasicBlock*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20getEHCleanupDestSlotEv", "clang::CodeGen::CodeGenFunction::getEHCleanupDestSlot()"),
	mu_demangle_test("_Z11EmitCleanupRN5clang7CodeGen15CodeGenFunctionEPNS0_12EHScopeStack7CleanupEbPN4llvm5ValueE", "EmitCleanup(clang::CodeGen::CodeGenFunction&, clang::CodeGen::EHScopeStack::Cleanup*, bool, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24getNormalCleanupDestSlotEv", "clang::CodeGen::CodeGenFunction::getNormalCleanupDestSlot()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24EmitBranchThroughCleanupENS1_8JumpDestE", "clang::CodeGen::CodeGenFunction::EmitBranchThroughCleanup(clang::CodeGen::CodeGenFunction::JumpDest)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitBranchThroughEHCleanupENS1_10UnwindDestE", "clang::CodeGen::CodeGenFunction::EmitBranchThroughEHCleanup(clang::CodeGen::CodeGenFunction::UnwindDest)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20ActivateCleanupBlockENS0_12EHScopeStack15stable_iteratorE", "clang::CodeGen::CodeGenFunction::ActivateCleanupBlock(clang::CodeGen::EHScopeStack::stable_iterator)"),
	mu_demangle_test("_Z27SetupCleanupBlockActivationRN5clang7CodeGen15CodeGenFunctionENS0_12EHScopeStack15stable_iteratorE15ForActivation_t", "SetupCleanupBlockActivation(clang::CodeGen::CodeGenFunction&, clang::CodeGen::EHScopeStack::stable_iterator, ForActivation_t)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22DeactivateCleanupBlockENS0_12EHScopeStack15stable_iteratorE", "clang::CodeGen::CodeGenFunction::DeactivateCleanupBlock(clang::CodeGen::EHScopeStack::stable_iterator)"),
	mu_demangle_test("_ZN5clang7CodeGen14EHCleanupScope14addBranchAfterEPN4llvm11ConstantIntEPNS2_10BasicBlockE", "clang::CodeGen::EHCleanupScope::addBranchAfter(llvm::ConstantInt*, llvm::BasicBlock*)"),
	mu_demangle_test("_ZN5clang7CodeGen14EHCleanupScope16addEHBranchAfterEPN4llvm11ConstantIntEPNS2_10BasicBlockE", "clang::CodeGen::EHCleanupScope::addEHBranchAfter(llvm::ConstantInt*, llvm::BasicBlock*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang7CodeGen11BranchFixupELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeGen::BranchFixup, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang7CodeGen14EHCleanupScopeD2Ev", "clang::CodeGen::EHCleanupScope::~EHCleanupScope()"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfoC1ERNS0_13CodeGenModuleE", "clang::CodeGen::CGDebugInfo::CGDebugInfo(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfoC2ERNS0_13CodeGenModuleE", "clang::CodeGen::CGDebugInfo::CGDebugInfo(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo17CreateCompileUnitEv", "clang::CodeGen::CGDebugInfo::CreateCompileUnit()"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfoD1Ev", "clang::CodeGen::CGDebugInfo::~CGDebugInfo()"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfoD2Ev", "clang::CodeGen::CGDebugInfo::~CGDebugInfo()"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo11setLocationENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::setLocation(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo20getContextDescriptorEPKNS_4DeclE", "clang::CodeGen::CGDebugInfo::getContextDescriptor(clang::Decl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo20getOrCreateNameSpaceEPKNS_13NamespaceDeclE", "clang::CodeGen::CGDebugInfo::getOrCreateNameSpace(clang::NamespaceDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo15getOrCreateTypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::getOrCreateType(clang::QualType, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo19getOrCreateMainFileEv", "clang::CodeGen::CGDebugInfo::getOrCreateMainFile()"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo15getFunctionNameEPKNS_12FunctionDeclE", "clang::CodeGen::CGDebugInfo::getFunctionName(clang::FunctionDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo17getObjCMethodNameEPKNS_14ObjCMethodDeclE", "clang::CodeGen::CGDebugInfo::getObjCMethodName(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo12getClassNameEPNS_10RecordDeclE", "clang::CodeGen::CGDebugInfo::getClassName(clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo15getOrCreateFileENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getOrCreateFile(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo17getCurrentDirnameEv", "clang::CodeGen::CGDebugInfo::getCurrentDirname()"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo13getLineNumberENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getLineNumber(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo15getColumnNumberENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getColumnNumber(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11BuiltinTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::BuiltinType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11ComplexTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ComplexType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo19CreateQualifiedTypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateQualifiedType(clang::QualType, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_21ObjCObjectPointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ObjCObjectPointerType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo21CreatePointerLikeTypeEjPKNS_4TypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreatePointerLikeType(unsigned int, clang::Type const*, clang::QualType, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11PointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::PointerType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo17CreatePointeeTypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreatePointeeType(clang::QualType, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_16BlockPointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::BlockPointerType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo16CreateMemberTypeEN4llvm6DIFileENS_8QualTypeENS2_9StringRefEPy", "clang::CodeGen::CGDebugInfo::CreateMemberType(llvm::DIFile, clang::QualType, llvm::StringRef, uint64_t*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11TypedefTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::TypedefType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_12FunctionTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::FunctionType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo19CollectRecordFieldsEPKNS_10RecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEE", "clang::CodeGen::CGDebugInfo::CollectRecordFields(clang::RecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo21getOrCreateMethodTypeEPKNS_13CXXMethodDeclEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::getOrCreateMethodType(clang::CXXMethodDecl const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo23CreateCXXMemberFunctionEPKNS_13CXXMethodDeclEN4llvm6DIFileENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CreateCXXMemberFunction(clang::CXXMethodDecl const*, llvm::DIFile, llvm::DIType)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo25CollectCXXMemberFunctionsEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CollectCXXMemberFunctions(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&, llvm::DIType)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo17CollectCXXFriendsEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CollectCXXFriends(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&, llvm::DIType)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo15CollectCXXBasesEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CollectCXXBases(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&, llvm::DIType)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo24getOrCreateVTablePtrTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::getOrCreateVTablePtrType(llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo13getVTableNameEPKNS_13CXXRecordDeclE", "clang::CodeGen::CGDebugInfo::getVTableName(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo17CollectVTableInfoEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEE", "clang::CodeGen::CGDebugInfo::CollectVTableInfo(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo21getOrCreateRecordTypeENS_8QualTypeENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getOrCreateRecordType(clang::QualType, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_10RecordTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::RecordType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_14ObjCObjectTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ObjCObjectType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_17ObjCInterfaceTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ObjCInterfaceType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_7TagTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::TagType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo14CreateEnumTypeEPKNS_8EnumDeclE", "clang::CodeGen::CGDebugInfo::CreateEnumType(clang::EnumDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_10VectorTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::VectorType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_9ArrayTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ArrayType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_19LValueReferenceTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::LValueReferenceType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_19RValueReferenceTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::RValueReferenceType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_17MemberPointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::MemberPointerType const*, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo14CreateTypeNodeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateTypeNode(clang::QualType, llvm::DIFile)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo28EmitTypeForVarWithBlocksAttrEPKNS_9ValueDeclEPy", "clang::CodeGen::CGDebugInfo::EmitTypeForVarWithBlocksAttr(clang::ValueDecl const*, uint64_t*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo18EmitGlobalVariableEPN4llvm14GlobalVariableEPKNS_7VarDeclE", "clang::CodeGen::CGDebugInfo::EmitGlobalVariable(llvm::GlobalVariable*, clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo18EmitGlobalVariableEPN4llvm14GlobalVariableEPNS_17ObjCInterfaceDeclE", "clang::CodeGen::CGDebugInfo::EmitGlobalVariable(llvm::GlobalVariable*, clang::ObjCInterfaceDecl*)"),
	mu_demangle_test("_ZN5clang7CodeGen11CGDebugInfo18EmitGlobalVariableEPKNS_9ValueDeclEPN4llvm8ConstantE", "clang::CodeGen::CGDebugInfo::EmitGlobalVariable(clang::ValueDecl const*, llvm::Constant*)"),
	mu_demangle_test("_ZNK5clang15ASTRecordLayout24getBaseClassOffsetInBitsEPKNS_13CXXRecordDeclE", "clang::ASTRecordLayout::getBaseClassOffsetInBits(clang::CXXRecordDecl const*) const"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction8EmitDeclERKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitDecl(clang::Decl const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11EmitVarDeclERKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::EmitVarDecl(clang::VarDecl const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitAutoVarDeclERKNS_7VarDeclEPFvRS1_S4_PN4llvm5ValueEE", "clang::CodeGen::CodeGenFunction::EmitAutoVarDecl(clang::VarDecl const&, void (*)(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::Value*))"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitStaticVarDeclERKNS_7VarDeclEN4llvm11GlobalValue12LinkageTypesE", "clang::CodeGen::CodeGenFunction::EmitStaticVarDecl(clang::VarDecl const&, llvm::GlobalValue::LinkageTypes)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19CreateStaticVarDeclERKNS_7VarDeclEPKcN4llvm11GlobalValue12LinkageTypesE", "clang::CodeGen::CodeGenFunction::CreateStaticVarDecl(clang::VarDecl const&, char const*, llvm::GlobalValue::LinkageTypes)"),
	mu_demangle_test("_Z17GetStaticDeclNameRN5clang7CodeGen15CodeGenFunctionERKNS_7VarDeclEPKc", "GetStaticDeclName(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction29AddInitializerToStaticVarDeclERKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenFunction::AddInitializerToStaticVarDecl(clang::VarDecl const&, llvm::GlobalVariable*)"),
	mu_demangle_test("_ZNK5clang7CodeGen15CodeGenFunction22getByRefValueLLVMFieldEPKNS_9ValueDeclE", "clang::CodeGen::CodeGenFunction::getByRefValueLLVMField(clang::ValueDecl const*) const"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22BuildBlockByrefAddressEPN4llvm5ValueEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::BuildBlockByrefAddress(llvm::Value*, clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14BuildByRefTypeEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::BuildByRefType(clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitParmDeclERKNS_7VarDeclEPN4llvm5ValueEb", "clang::CodeGen::CodeGenFunction::EmitParmDecl(clang::VarDecl const&, llvm::Value*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallBlockReleaseD1Ev", "(anonymous namespace)::CallBlockRelease::~CallBlockRelease()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallBlockReleaseD0Ev", "(anonymous namespace)::CallBlockRelease::~CallBlockRelease()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallBlockRelease4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallBlockRelease::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_119CallCleanupFunctionD1Ev", "(anonymous namespace)::CallCleanupFunction::~CallCleanupFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_119CallCleanupFunctionD0Ev", "(anonymous namespace)::CallCleanupFunction::~CallCleanupFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_119CallCleanupFunction4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallCleanupFunction::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_111CallVarDtorD1Ev", "(anonymous namespace)::CallVarDtor::~CallVarDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_111CallVarDtorD0Ev", "(anonymous namespace)::CallVarDtor::~CallVarDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_111CallVarDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallVarDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallArrayDtorD1Ev", "(anonymous namespace)::CallArrayDtor::~CallArrayDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallArrayDtorD0Ev", "(anonymous namespace)::CallArrayDtor::~CallArrayDtor()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113CallArrayDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallArrayDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallStackRestoreD1Ev", "(anonymous namespace)::CallStackRestore::~CallStackRestore()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallStackRestoreD0Ev", "(anonymous namespace)::CallStackRestore::~CallStackRestore()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallStackRestore4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallStackRestore::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_Z35canEmitInitWithFewStoresAfterMemsetPN4llvm8ConstantERj", "canEmitInitWithFewStoresAfterMemset(llvm::Constant*, unsigned int&)"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_11CleanupAttrEEEPT_v", "clang::CleanupAttr* clang::Decl::getAttr<clang::CleanupAttr>() const"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24EmitCXXGlobalVarDeclInitERKNS_7VarDeclEPN4llvm8ConstantE", "clang::CodeGen::CodeGenFunction::EmitCXXGlobalVarDeclInit(clang::VarDecl const&, llvm::Constant*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction29EmitCXXGlobalDtorRegistrationEPN4llvm8ConstantES4_", "clang::CodeGen::CodeGenFunction::EmitCXXGlobalDtorRegistration(llvm::Constant*, llvm::Constant*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitCXXGuardedInitERKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenFunction::EmitCXXGuardedInit(clang::VarDecl const&, llvm::GlobalVariable*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule28EmitCXXGlobalVarDeclInitFuncEPKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenModule::EmitCXXGlobalVarDeclInitFunc(clang::VarDecl const*, llvm::GlobalVariable*)"),
	mu_demangle_test("_Z34CreateGlobalInitOrDestructFunctionRN5clang7CodeGen13CodeGenModuleEPKN4llvm12FunctionTypeENS3_9StringRefE", "CreateGlobalInitOrDestructFunction(clang::CodeGen::CodeGenModule&, llvm::FunctionType const*, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction32GenerateCXXGlobalVarDeclInitFuncEPN4llvm8FunctionEPKNS_7VarDeclEPNS2_14GlobalVariableE", "clang::CodeGen::CodeGenFunction::GenerateCXXGlobalVarDeclInitFunc(llvm::Function*, clang::VarDecl const*, llvm::GlobalVariable*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21EmitCXXGlobalInitFuncEv", "clang::CodeGen::CodeGenModule::EmitCXXGlobalInitFunc()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25GenerateCXXGlobalInitFuncEPN4llvm8FunctionEPPNS2_8ConstantEj", "clang::CodeGen::CodeGenFunction::GenerateCXXGlobalInitFunc(llvm::Function*, llvm::Constant**, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21EmitCXXGlobalDtorFuncEv", "clang::CodeGen::CodeGenModule::EmitCXXGlobalDtorFunc()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction31GenerateCXXAggrDestructorHelperEPKNS_17CXXDestructorDeclEPKNS_9ArrayTypeEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::GenerateCXXAggrDestructorHelper(clang::CXXDestructorDecl const*, clang::ArrayType const*, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule15AddCXXDtorEntryEPN4llvm8ConstantES4_", "clang::CodeGen::CodeGenModule::AddCXXDtorEntry(llvm::Constant*, llvm::Constant*)"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_16InitPriorityAttrEEEPT_v", "clang::InitPriorityAttr* clang::Decl::getAttr<clang::InitPriorityAttr>() const"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseISt4pairIN5clang7CodeGen16OrderGlobalInitsEPNS_8FunctionEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::CodeGen::OrderGlobalInits, llvm::Function*>, false>::grow(unsigned long)"),
	mu_demangle_test("_ZNSt15__copy_backwardILb0ESt26random_access_iterator_tagE8__copy_bIPSt4pairIN4llvm6WeakVHEPNS4_8ConstantEES9_EET0_T_SB_SA_", "std::pair<llvm::WeakVH, llvm::Constant*>* std::__copy_backward<false, std::random_access_iterator_tag>::__copy_b<std::pair<llvm::WeakVH, llvm::Constant*>*, std::pair<llvm::WeakVH, llvm::Constant*>*>(std::pair<llvm::WeakVH, llvm::Constant*>*, std::pair<llvm::WeakVH, llvm::Constant*>*, std::pair<llvm::WeakVH, llvm::Constant*>*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26getUnwindResumeOrRethrowFnEv", "clang::CodeGen::CodeGenFunction::getUnwindResumeOrRethrowFn()"),
	mu_demangle_test("_ZN5clang7CodeGen13EHPersonality3getERKNS_11LangOptionsE", "clang::CodeGen::EHPersonality::get(clang::LangOptions const&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19SimplifyPersonalityEv", "clang::CodeGen::CodeGenModule::SimplifyPersonality()"),
	mu_demangle_test("_Z25PersonalityHasOnlyCXXUsesPN4llvm8ConstantE", "PersonalityHasOnlyCXXUses(llvm::Constant*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16getExceptionSlotEv", "clang::CodeGen::CodeGenFunction::getExceptionSlot()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitCXXThrowExprEPKNS_12CXXThrowExprE", "clang::CodeGen::CodeGenFunction::EmitCXXThrowExpr(clang::CXXThrowExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitStartEHSpecEPKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitStartEHSpec(clang::Decl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13EmitEndEHSpecEPKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitEndEHSpec(clang::Decl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitCXXTryStmtERKNS_10CXXTryStmtE", "clang::CodeGen::CodeGenFunction::EmitCXXTryStmt(clang::CXXTryStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EnterCXXTryStmtERKNS_10CXXTryStmtEb", "clang::CodeGen::CodeGenFunction::EnterCXXTryStmt(clang::CXXTryStmt const&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14ExitCXXTryStmtERKNS_10CXXTryStmtEb", "clang::CodeGen::CodeGenFunction::ExitCXXTryStmt(clang::CXXTryStmt const&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17getInvokeDestImplEv", "clang::CodeGen::CodeGenFunction::getInvokeDestImpl()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitLandingPadEv", "clang::CodeGen::CodeGenFunction::EmitLandingPad()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22getTerminateLandingPadEv", "clang::CodeGen::CodeGenFunction::getTerminateLandingPad()"),
	mu_demangle_test("_Z22getOpaquePersonalityFnRN5clang7CodeGen13CodeGenModuleERKNS0_13EHPersonalityE", "getOpaquePersonalityFn(clang::CodeGen::CodeGenModule&, clang::CodeGen::EHPersonality const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19getTerminateHandlerEv", "clang::CodeGen::CodeGenFunction::getTerminateHandler()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14getRethrowDestEv", "clang::CodeGen::CodeGenFunction::getRethrowDest()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EnterFinallyBlockEPKNS_4StmtEPN4llvm8ConstantES7_S7_", "clang::CodeGen::CodeGenFunction::EnterFinallyBlock(clang::Stmt const*, llvm::Constant*, llvm::Constant*, llvm::Constant*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16ExitFinallyBlockERNS1_11FinallyInfoE", "clang::CodeGen::CodeGenFunction::ExitFinallyBlock(clang::CodeGen::CodeGenFunction::FinallyInfo&)"),
	mu_demangle_test("_Z14getTerminateFnRN5clang7CodeGen15CodeGenFunctionE", "getTerminateFn(clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114PerformFinallyD1Ev", "(anonymous namespace)::PerformFinally::~PerformFinally()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114PerformFinallyD0Ev", "(anonymous namespace)::PerformFinally::~PerformFinally()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114PerformFinally4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::PerformFinally::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CallEndCatchForFinallyD1Ev", "(anonymous namespace)::CallEndCatchForFinally::~CallEndCatchForFinally()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CallEndCatchForFinallyD0Ev", "(anonymous namespace)::CallEndCatchForFinally::~CallEndCatchForFinally()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CallEndCatchForFinally4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallEndCatchForFinally::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_111CallRethrowD1Ev", "(anonymous namespace)::CallRethrow::~CallRethrow()"),
	mu_demangle_test("_ZN12_GLOBAL__N_111CallRethrowD0Ev", "(anonymous namespace)::CallRethrow::~CallRethrow()"),
	mu_demangle_test("_ZN12_GLOBAL__N_111CallRethrow4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallRethrow::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_Z14CallBeginCatchRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEb", "CallBeginCatch(clang::CodeGen::CodeGenFunction&, llvm::Value*, bool)"),
	mu_demangle_test("_Z14InitCatchParamRN5clang7CodeGen15CodeGenFunctionERKNS_7VarDeclEPN4llvm5ValueE", "InitCatchParam(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallEndCatchD1Ev", "(anonymous namespace)::CallEndCatch::~CallEndCatch()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallEndCatchD0Ev", "(anonymous namespace)::CallEndCatch::~CallEndCatch()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallEndCatch4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallEndCatch::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~ConditionalCleanup1()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~ConditionalCleanup1()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::ConditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113FreeException4EmitERN5clang7CodeGen15CodeGenFunctionEbPN4llvm5ValueE", "(anonymous namespace)::FreeException::Emit(clang::CodeGen::CodeGenFunction&, bool, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~UnconditionalCleanup1()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~UnconditionalCleanup1()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::UnconditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19getUnreachableBlockEv", "clang::CodeGen::CodeGenFunction::getUnreachableBlock()"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang7CodeGen12EHCatchScope7HandlerELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeGen::EHCatchScope::Handler, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang7CodeGen19DominatingLLVMValue4saveERNS0_15CodeGenFunctionEPN4llvm5ValueE", "clang::CodeGen::DominatingLLVMValue::save(clang::CodeGen::CodeGenFunction&, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitCastToVoidPtrEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCastToVoidPtr(llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16CreateTempAllocaEPKN4llvm4TypeERKNS2_5TwineE", "clang::CodeGen::CodeGenFunction::CreateTempAlloca(llvm::Type const*, llvm::Twine const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14InitTempAllocaEPN4llvm10AllocaInstEPNS2_5ValueE", "clang::CodeGen::CodeGenFunction::InitTempAlloca(llvm::AllocaInst*, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12CreateIRTempENS_8QualTypeERKN4llvm5TwineE", "clang::CodeGen::CodeGenFunction::CreateIRTemp(clang::QualType, llvm::Twine const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13CreateMemTempENS_8QualTypeERKN4llvm5TwineE", "clang::CodeGen::CodeGenFunction::CreateMemTemp(clang::QualType, llvm::Twine const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EvaluateExprAsBoolEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EvaluateExprAsBool(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitIgnoredExprEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitIgnoredExpr(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11EmitAnyExprEPKNS_4ExprENS0_12AggValueSlotEb", "clang::CodeGen::CodeGenFunction::EmitAnyExpr(clang::Expr const*, clang::CodeGen::AggValueSlot, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction10EmitLValueEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitLValue(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitAnyExprToTempEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitAnyExprToTemp(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitAnyExprToMemEPKNS_4ExprEPN4llvm5ValueEbb", "clang::CodeGen::CodeGenFunction::EmitAnyExprToMem(clang::Expr const*, llvm::Value*, bool, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22EmitStoreThroughLValueENS0_6RValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughLValue(clang::CodeGen::RValue, clang::CodeGen::LValue, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitReferenceBindingToExprEPKNS_4ExprEPKNS_9NamedDeclE", "clang::CodeGen::CodeGenFunction::EmitReferenceBindingToExpr(clang::Expr const*, clang::NamedDecl const*)"),
	mu_demangle_test("_Z27EmitExprForReferenceBindingRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprERPN4llvm5ValueERPKNS_17CXXDestructorDeclEPKNS_9NamedDeclE", "EmitExprForReferenceBinding(clang::CodeGen::CodeGenFunction&, clang::Expr const*, llvm::Value*&, clang::CXXDestructorDecl const*&, clang::NamedDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18getAccessedFieldNoEjPKN4llvm8ConstantE", "clang::CodeGen::CodeGenFunction::getAccessedFieldNo(unsigned int, llvm::Constant const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction9EmitCheckEPN4llvm5ValueEj", "clang::CodeGen::CodeGenFunction::EmitCheck(llvm::Value*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction9getTrapBBEv", "clang::CodeGen::CodeGenFunction::getTrapBB()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24EmitComplexPrePostIncDecEPKNS_13UnaryOperatorENS0_6LValueEbb", "clang::CodeGen::CodeGenFunction::EmitComplexPrePostIncDec(clang::UnaryOperator const*, clang::CodeGen::LValue, bool, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14GetUndefRValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::GetUndefRValue(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitUnsupportedRValueEPKNS_4ExprEPKc", "clang::CodeGen::CodeGenFunction::EmitUnsupportedRValue(clang::Expr const*, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitUnsupportedLValueEPKNS_4ExprEPKc", "clang::CodeGen::CodeGenFunction::EmitUnsupportedLValue(clang::Expr const*, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitCheckedLValueEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitCheckedLValue(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22EmitObjCSelectorLValueEPKNS_16ObjCSelectorExprE", "clang::CodeGen::CodeGenFunction::EmitObjCSelectorLValue(clang::ObjCSelectorExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24EmitBinaryOperatorLValueEPKNS_14BinaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitBinaryOperatorLValue(clang::BinaryOperator const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitCallExprLValueEPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitCallExprLValue(clang::CallExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitVAArgExprLValueEPKNS_9VAArgExprE", "clang::CodeGen::CodeGenFunction::EmitVAArgExprLValue(clang::VAArgExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitDeclRefLValueEPKNS_11DeclRefExprE", "clang::CodeGen::CodeGenFunction::EmitDeclRefLValue(clang::DeclRefExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitPredefinedLValueEPKNS_14PredefinedExprE", "clang::CodeGen::CodeGenFunction::EmitPredefinedLValue(clang::PredefinedExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction23EmitStringLiteralLValueEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenFunction::EmitStringLiteralLValue(clang::StringLiteral const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24EmitObjCEncodeExprLValueEPKNS_14ObjCEncodeExprE", "clang::CodeGen::CodeGenFunction::EmitObjCEncodeExprLValue(clang::ObjCEncodeExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22EmitBlockDeclRefLValueEPKNS_16BlockDeclRefExprE", "clang::CodeGen::CodeGenFunction::EmitBlockDeclRefLValue(clang::BlockDeclRefExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22EmitCXXConstructLValueEPKNS_16CXXConstructExprE", "clang::CodeGen::CodeGenFunction::EmitCXXConstructLValue(clang::CXXConstructExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitCXXBindTemporaryLValueEPKNS_20CXXBindTemporaryExprE", "clang::CodeGen::CodeGenFunction::EmitCXXBindTemporaryLValue(clang::CXXBindTemporaryExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction28EmitNullInitializationLValueEPKNS_22CXXScalarValueInitExprE", "clang::CodeGen::CodeGenFunction::EmitNullInitializationLValue(clang::CXXScalarValueInitExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitCXXTypeidLValueEPKNS_13CXXTypeidExprE", "clang::CodeGen::CodeGenFunction::EmitCXXTypeidLValue(clang::CXXTypeidExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25EmitObjCMessageExprLValueEPKNS_15ObjCMessageExprE", "clang::CodeGen::CodeGenFunction::EmitObjCMessageExprLValue(clang::ObjCMessageExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitObjCIvarRefLValueEPKNS_15ObjCIvarRefExprE", "clang::CodeGen::CodeGenFunction::EmitObjCIvarRefLValue(clang::ObjCIvarRefExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitStmtExprLValueEPKNS_8StmtExprE", "clang::CodeGen::CodeGenFunction::EmitStmtExprLValue(clang::StmtExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitUnaryOpLValueEPKNS_13UnaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitUnaryOpLValue(clang::UnaryOperator const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22EmitArraySubscriptExprEPKNS_18ArraySubscriptExprE", "clang::CodeGen::CodeGenFunction::EmitArraySubscriptExpr(clang::ArraySubscriptExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24EmitExtVectorElementExprEPKNS_20ExtVectorElementExprE", "clang::CodeGen::CodeGenFunction::EmitExtVectorElementExpr(clang::ExtVectorElementExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitMemberExprEPKNS_10MemberExprE", "clang::CodeGen::CodeGenFunction::EmitMemberExpr(clang::MemberExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25EmitCompoundLiteralLValueEPKNS_19CompoundLiteralExprE", "clang::CodeGen::CodeGenFunction::EmitCompoundLiteralLValue(clang::CompoundLiteralExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction29EmitConditionalOperatorLValueEPKNS_19ConditionalOperatorE", "clang::CodeGen::CodeGenFunction::EmitConditionalOperatorLValue(clang::ConditionalOperator const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitCastLValueEPKNS_8CastExprE", "clang::CodeGen::CodeGenFunction::EmitCastLValue(clang::CastExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitLoadOfScalarEPN4llvm5ValueEbjNS_8QualTypeEPNS2_6MDNodeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfScalar(llvm::Value*, bool, unsigned int, clang::QualType, llvm::MDNode*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitFromMemoryEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitFromMemory(llvm::Value*, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitToMemoryEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitToMemory(llvm::Value*, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitStoreOfScalarEPN4llvm5ValueES4_bjNS_8QualTypeEPNS2_6MDNodeE", "clang::CodeGen::CodeGenFunction::EmitStoreOfScalar(llvm::Value*, llvm::Value*, bool, unsigned int, clang::QualType, llvm::MDNode*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitLoadOfLValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfLValue(clang::CodeGen::LValue, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction32EmitLoadOfExtVectorElementLValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfExtVectorElementLValue(clang::CodeGen::LValue, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24EmitLoadOfBitfieldLValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfBitfieldLValue(clang::CodeGen::LValue, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction40EmitStoreThroughExtVectorComponentLValueENS0_6RValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughExtVectorComponentLValue(clang::CodeGen::RValue, clang::CodeGen::LValue, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction30EmitStoreThroughBitfieldLValueENS0_6RValueENS0_6LValueENS_8QualTypeEPPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughBitfieldLValue(clang::CodeGen::RValue, clang::CodeGen::LValue, clang::QualType, llvm::Value**)"),
	mu_demangle_test("_Z23EmitGlobalVarDeclLValueRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprEPKNS_7VarDeclE", "EmitGlobalVarDeclLValue(clang::CodeGen::CodeGenFunction&, clang::Expr const*, clang::VarDecl const*)"),
	mu_demangle_test("_Z20setObjCGCLValueClassRKN5clang10ASTContextEPKNS_4ExprERNS_7CodeGen6LValueE", "setObjCGCLValueClass(clang::ASTContext const&, clang::Expr const*, clang::CodeGen::LValue&)"),
	mu_demangle_test("_Z22EmitFunctionDeclLValueRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprEPKNS_12FunctionDeclE", "EmitFunctionDeclLValue(clang::CodeGen::CodeGenFunction&, clang::Expr const*, clang::FunctionDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitLValueForFieldEPN4llvm5ValueEPKNS_9FieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForField(llvm::Value*, clang::FieldDecl const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitLValueForBitfieldEPN4llvm5ValueEPKNS_9FieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForBitfield(llvm::Value*, clang::FieldDecl const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction28EmitLValueForAnonRecordFieldEPN4llvm5ValueEPKNS_17IndirectFieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForAnonRecordField(llvm::Value*, clang::IndirectFieldDecl const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction32EmitLValueForFieldInitializationEPN4llvm5ValueEPKNS_9FieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForFieldInitialization(llvm::Value*, clang::FieldDecl const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitCallExprEPKNS_8CallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCallExpr(clang::CallExpr const*, clang::CodeGen::ReturnValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction8EmitCallENS_8QualTypeEPN4llvm5ValueENS0_15ReturnValueSlotENS_17ConstExprIteratorES7_PKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitCall(clang::QualType, llvm::Value*, clang::CodeGen::ReturnValueSlot, clang::ConstExprIterator, clang::ConstExprIterator, clang::Decl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction33EmitPointerToDataMemberBinaryExprEPKNS_14BinaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitPointerToDataMemberBinaryExpr(clang::BinaryOperator const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitIvarOffsetEPKNS_17ObjCInterfaceDeclEPKNS_12ObjCIvarDeclE", "clang::CodeGen::CodeGenFunction::EmitIvarOffset(clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitLValueForIvarENS_8QualTypeEPN4llvm5ValueEPKNS_12ObjCIvarDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForIvar(clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_119SubobjectAdjustmentEE9push_backERKS2_", "llvm::SmallVectorImpl<(anonymous namespace)::SubobjectAdjustment>::push_back((anonymous namespace)::SubobjectAdjustment const&)"),
	mu_demangle_test("_Z24CreateReferenceTemporaryRN5clang7CodeGen15CodeGenFunctionENS_8QualTypeEPKNS_9NamedDeclE", "CreateReferenceTemporary(clang::CodeGen::CodeGenFunction&, clang::QualType, clang::NamedDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitCallArgsINS_17FunctionProtoTypeEEEvRN4llvm11SmallVectorISt4pairINS0_6RValueENS_8QualTypeEELj16EEEPKT_NS_17ConstExprIteratorESF_", "void clang::CodeGen::CodeGenFunction::EmitCallArgs<clang::FunctionProtoType>(llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u>&, clang::FunctionProtoType const*, clang::ConstExprIterator, clang::ConstExprIterator)"),
	mu_demangle_test("_ZN4llvm11SmallVectorIPNS_8ConstantELj4EEC2EjRKS2_", "llvm::SmallVector<llvm::Constant*, 4u>::SmallVector(unsigned int, llvm::Constant* const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11EmitAggExprEPKNS_4ExprENS0_12AggValueSlotEb", "clang::CodeGen::CodeGenFunction::EmitAggExpr(clang::Expr const*, clang::CodeGen::AggValueSlot, bool)"),
	mu_demangle_test("_ZN5clang11StmtVisitorIN12_GLOBAL__N_114AggExprEmitterEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::AggExprEmitter, void>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitAggExprToLValueEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitAggExprToLValue(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitAggregateCopyEPN4llvm5ValueES4_NS_8QualTypeEb", "clang::CodeGen::CodeGenFunction::EmitAggregateCopy(llvm::Value*, llvm::Value*, clang::QualType, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114AggExprEmitter13VisitCallExprEPKN5clang8CallExprE", "(anonymous namespace)::AggExprEmitter::VisitCallExpr(clang::CallExpr const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114AggExprEmitter17EmitFinalDestCopyEPKN5clang4ExprENS1_7CodeGen6LValueEb", "(anonymous namespace)::AggExprEmitter::EmitFinalDestCopy(clang::Expr const*, clang::CodeGen::LValue, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114AggExprEmitter10EmitGCMoveEPKN5clang4ExprENS1_7CodeGen6RValueE", "(anonymous namespace)::AggExprEmitter::EmitGCMove(clang::Expr const*, clang::CodeGen::RValue)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114AggExprEmitter26EmitInitializationToLValueEPN5clang4ExprENS1_7CodeGen6LValueENS1_8QualTypeE", "(anonymous namespace)::AggExprEmitter::EmitInitializationToLValue(clang::Expr*, clang::CodeGen::LValue, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114AggExprEmitter30EmitNullInitializationToLValueEN5clang7CodeGen6LValueENS1_8QualTypeE", "(anonymous namespace)::AggExprEmitter::EmitNullInitializationToLValue(clang::CodeGen::LValue, clang::QualType)"),
	mu_demangle_test("_Z12isSimpleZeroPKN5clang4ExprERNS_7CodeGen15CodeGenFunctionE", "isSimpleZero(clang::Expr const*, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114AggExprEmitter13VisitCastExprEPN5clang8CastExprE", "(anonymous namespace)::AggExprEmitter::VisitCastExpr(clang::CastExpr*)"),
	mu_demangle_test("_Z24GetNumNonZeroBytesInInitPKN5clang4ExprERNS_7CodeGen15CodeGenFunctionE", "GetNumNonZeroBytesInInit(clang::Expr const*, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitCXXMemberCallEPKNS_13CXXMethodDeclEPN4llvm5ValueENS0_15ReturnValueSlotES7_S7_NS_17ConstExprIteratorES9_", "clang::CodeGen::CodeGenFunction::EmitCXXMemberCall(clang::CXXMethodDecl const*, llvm::Value*, clang::CodeGen::ReturnValueSlot, llvm::Value*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitCXXMemberCallExprEPKNS_17CXXMemberCallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXMemberCallExpr(clang::CXXMemberCallExpr const*, clang::CodeGen::ReturnValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction28EmitCXXMemberPointerCallExprEPKNS_17CXXMemberCallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXMemberPointerCallExpr(clang::CXXMemberCallExpr const*, clang::CodeGen::ReturnValueSlot)"),
	mu_demangle_test("_Z34canDevirtualizeMemberFunctionCallsRN5clang10ASTContextEPKNS_4ExprEPKNS_13CXXMethodDeclE", "canDevirtualizeMemberFunctionCalls(clang::ASTContext&, clang::Expr const*, clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction29EmitCXXOperatorMemberCallExprEPKNS_19CXXOperatorCallExprEPKNS_13CXXMethodDeclENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXOperatorMemberCallExpr(clang::CXXOperatorCallExpr const*, clang::CXXMethodDecl const*, clang::CodeGen::ReturnValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitCXXConstructExprEPKNS_16CXXConstructExprENS0_12AggValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXConstructExpr(clang::CXXConstructExpr const*, clang::CodeGen::AggValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitSynthesizedCXXCopyCtorEPN4llvm5ValueES4_PKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitSynthesizedCXXCopyCtor(llvm::Value*, llvm::Value*, clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction23EmitNewArrayInitializerEPKNS_10CXXNewExprEPN4llvm5ValueES7_", "clang::CodeGen::CodeGenFunction::EmitNewArrayInitializer(clang::CXXNewExpr const*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_Z23StoreAnyExprIntoOneUnitRN5clang7CodeGen15CodeGenFunctionEPKNS_10CXXNewExprEPN4llvm5ValueE", "StoreAnyExprIntoOneUnit(clang::CodeGen::CodeGenFunction&, clang::CXXNewExpr const*, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitCXXNewExprEPKNS_10CXXNewExprE", "clang::CodeGen::CodeGenFunction::EmitCXXNewExpr(clang::CXXNewExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitDeleteCallEPKNS_12FunctionDeclEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitDeleteCall(clang::FunctionDecl const*, llvm::Value*, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitCXXDeleteExprEPKNS_13CXXDeleteExprE", "clang::CodeGen::CodeGenFunction::EmitCXXDeleteExpr(clang::CXXDeleteExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitCXXTypeidExprEPKNS_13CXXTypeidExprE", "clang::CodeGen::CodeGenFunction::EmitCXXTypeidExpr(clang::CXXTypeidExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitDynamicCastEPN4llvm5ValueEPKNS_18CXXDynamicCastExprE", "clang::CodeGen::CodeGenFunction::EmitDynamicCast(llvm::Value*, clang::CXXDynamicCastExpr const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallObjectDeleteD1Ev", "(anonymous namespace)::CallObjectDelete::~CallObjectDelete()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallObjectDeleteD0Ev", "(anonymous namespace)::CallObjectDelete::~CallObjectDelete()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallObjectDelete4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallObjectDelete::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CallArrayDeleteD1Ev", "(anonymous namespace)::CallArrayDelete::~CallArrayDelete()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CallArrayDeleteD0Ev", "(anonymous namespace)::CallArrayDelete::~CallArrayDelete()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CallArrayDelete4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallArrayDelete::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_130CallDeleteDuringConditionalNewD1Ev", "(anonymous namespace)::CallDeleteDuringConditionalNew::~CallDeleteDuringConditionalNew()"),
	mu_demangle_test("_ZN12_GLOBAL__N_130CallDeleteDuringConditionalNewD0Ev", "(anonymous namespace)::CallDeleteDuringConditionalNew::~CallDeleteDuringConditionalNew()"),
	mu_demangle_test("_ZN12_GLOBAL__N_130CallDeleteDuringConditionalNew4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallDeleteDuringConditionalNew::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_119CallDeleteDuringNewD1Ev", "(anonymous namespace)::CallDeleteDuringNew::~CallDeleteDuringNew()"),
	mu_demangle_test("_ZN12_GLOBAL__N_119CallDeleteDuringNewD0Ev", "(anonymous namespace)::CallDeleteDuringNew::~CallDeleteDuringNew()"),
	mu_demangle_test("_ZN12_GLOBAL__N_119CallDeleteDuringNew4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallDeleteDuringNew::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitComplexExprEPKNS_4ExprEbb", "clang::CodeGen::CodeGenFunction::EmitComplexExpr(clang::Expr const*, bool, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter5VisitEPN5clang4ExprE", "(anonymous namespace)::ComplexExprEmitter::Visit(clang::Expr*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction23EmitComplexExprIntoAddrEPKNS_4ExprEPN4llvm5ValueEb", "clang::CodeGen::CodeGenFunction::EmitComplexExprIntoAddr(clang::Expr const*, llvm::Value*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18StoreComplexToAddrESt4pairIPN4llvm5ValueES5_ES5_b", "clang::CodeGen::CodeGenFunction::StoreComplexToAddr(std::pair<llvm::Value*, llvm::Value*>, llvm::Value*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19LoadComplexFromAddrEPN4llvm5ValueEb", "clang::CodeGen::CodeGenFunction::LoadComplexFromAddr(llvm::Value*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter17EmitLoadOfComplexEPN4llvm5ValueEb", "(anonymous namespace)::ComplexExprEmitter::EmitLoadOfComplex(llvm::Value*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction27EmitComplexAssignmentLValueEPKNS_14BinaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitComplexAssignmentLValue(clang::BinaryOperator const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction35EmitComplexCompoundAssignmentLValueEPKNS_22CompoundAssignOperatorE", "clang::CodeGen::CodeGenFunction::EmitComplexCompoundAssignmentLValue(clang::CompoundAssignOperator const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinMulERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinMul((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinDivERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinDiv((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinSubERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinSub((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinAddERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinAdd((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter24EmitCompoundAssignLValueEPKN5clang22CompoundAssignOperatorEMS0_FSt4pairIPN4llvm5ValueES8_ERKNS0_9BinOpInfoEERS9_", "(anonymous namespace)::ComplexExprEmitter::EmitCompoundAssignLValue(clang::CompoundAssignOperator const*, std::pair<llvm::Value*, llvm::Value*> ((anonymous namespace)::ComplexExprEmitter::*)((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&), std::pair<llvm::Value*, llvm::Value*>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter24EmitComplexToComplexCastESt4pairIPN4llvm5ValueES4_EN5clang8QualTypeES7_", "(anonymous namespace)::ComplexExprEmitter::EmitComplexToComplexCast(std::pair<llvm::Value*, llvm::Value*>, clang::QualType, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter22EmitStoreThroughLValueESt4pairIPN4llvm5ValueES4_EN5clang7CodeGen6LValueE", "(anonymous namespace)::ComplexExprEmitter::EmitStoreThroughLValue(std::pair<llvm::Value*, llvm::Value*>, clang::CodeGen::LValue)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter9VisitExprEPN5clang4ExprE", "(anonymous namespace)::ComplexExprEmitter::VisitExpr(clang::Expr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter16EmitLoadOfLValueEPKN5clang4ExprE", "(anonymous namespace)::ComplexExprEmitter::EmitLoadOfLValue(clang::Expr const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter8EmitCastEN5clang8CastKindEPNS1_4ExprENS1_8QualTypeE", "(anonymous namespace)::ComplexExprEmitter::EmitCast(clang::CastKind, clang::Expr*, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ComplexExprEmitter18EmitCompoundAssignEPKN5clang22CompoundAssignOperatorEMS0_FSt4pairIPN4llvm5ValueES8_ERKNS0_9BinOpInfoEE", "(anonymous namespace)::ComplexExprEmitter::EmitCompoundAssign(clang::CompoundAssignOperator const*, std::pair<llvm::Value*, llvm::Value*> ((anonymous namespace)::ComplexExprEmitter::*)((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&))"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16EmitConstantExprEPKNS_4ExprENS_8QualTypeEPNS0_15CodeGenFunctionE", "clang::CodeGen::CodeGenModule::EmitConstantExpr(clang::Expr const*, clang::QualType, clang::CodeGen::CodeGenFunction*)"),
	mu_demangle_test("_ZN5clang11StmtVisitorIN12_GLOBAL__N_116ConstExprEmitterEPN4llvm8ConstantEE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::ConstExprEmitter, llvm::Constant*>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule24getMemberPointerConstantEPKNS_13UnaryOperatorE", "clang::CodeGen::CodeGenModule::getMemberPointerConstant(clang::UnaryOperator const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16EmitNullConstantENS_8QualTypeE", "clang::CodeGen::CodeGenModule::EmitNullConstant(clang::QualType)"),
	mu_demangle_test("_Z16EmitNullConstantRN5clang7CodeGen13CodeGenModuleEPKNS_13CXXRecordDeclE", "EmitNullConstant(clang::CodeGen::CodeGenModule&, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ConstExprEmitter21VisitCXXConstructExprEPN5clang16CXXConstructExprE", "(anonymous namespace)::ConstExprEmitter::VisitCXXConstructExpr(clang::CXXConstructExpr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ConstExprEmitter23EmitArrayInitializationEPN5clang12InitListExprE", "(anonymous namespace)::ConstExprEmitter::EmitArrayInitialization(clang::InitListExpr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ConstStructBuilder5BuildEPN5clang12InitListExprE", "(anonymous namespace)::ConstStructBuilder::Build(clang::InitListExpr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ConstStructBuilder21ConvertStructToPackedEv", "(anonymous namespace)::ConstStructBuilder::ConvertStructToPacked()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118ConstStructBuilder13AppendPaddingEy", "(anonymous namespace)::ConstStructBuilder::AppendPadding(uint64_t)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_118ConstStructBuilder14getSizeInBytesEPKN4llvm8ConstantE", "(anonymous namespace)::ConstStructBuilder::getSizeInBytes(llvm::Constant const*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_116ConstExprEmitter13VisitCastExprEPN5clang8CastExprE", "(anonymous namespace)::ConstExprEmitter::VisitCastExpr(clang::CastExpr*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitScalarExprEPKNS_4ExprEb", "clang::CodeGen::CodeGenFunction::EmitScalarExpr(clang::Expr const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitScalarConversionEPN4llvm5ValueENS_8QualTypeES5_", "clang::CodeGen::CodeGenFunction::EmitScalarConversion(llvm::Value*, clang::QualType, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter20EmitScalarConversionEPN4llvm5ValueEN5clang8QualTypeES5_", "(anonymous namespace)::ScalarExprEmitter::EmitScalarConversion(llvm::Value*, clang::QualType, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction29EmitComplexToScalarConversionESt4pairIPN4llvm5ValueES5_ENS_8QualTypeES7_", "clang::CodeGen::CodeGenFunction::EmitComplexToScalarConversion(std::pair<llvm::Value*, llvm::Value*>, clang::QualType, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter29EmitComplexToScalarConversionESt4pairIPN4llvm5ValueES4_EN5clang8QualTypeES7_", "(anonymous namespace)::ScalarExprEmitter::EmitComplexToScalarConversion(std::pair<llvm::Value*, llvm::Value*>, clang::QualType, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction23EmitScalarPrePostIncDecEPKNS_13UnaryOperatorENS0_6LValueEbb", "clang::CodeGen::CodeGenFunction::EmitScalarPrePostIncDec(clang::UnaryOperator const*, clang::CodeGen::LValue, bool, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter23EmitScalarPrePostIncDecEPKN5clang13UnaryOperatorENS1_7CodeGen6LValueEbb", "(anonymous namespace)::ScalarExprEmitter::EmitScalarPrePostIncDec(clang::UnaryOperator const*, clang::CodeGen::LValue, bool, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitObjCIsaExprEPKNS_11ObjCIsaExprE", "clang::CodeGen::CodeGenFunction::EmitObjCIsaExpr(clang::ObjCIsaExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction28EmitCompoundAssignmentLValueEPKNS_22CompoundAssignOperatorE", "clang::CodeGen::CodeGenFunction::EmitCompoundAssignmentLValue(clang::CompoundAssignOperator const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter24EmitCompoundAssignLValueEPKN5clang22CompoundAssignOperatorEMS0_FPN4llvm5ValueERKNS_9BinOpInfoEERS7_", "(anonymous namespace)::ScalarExprEmitter::EmitCompoundAssignLValue(clang::CompoundAssignOperator const*, llvm::Value* ((anonymous namespace)::ScalarExprEmitter::*)((anonymous namespace)::BinOpInfo const&), llvm::Value*&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitMulERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitMul((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitDivERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitDiv((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitRemERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitRem((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitAddERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitAdd((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitSubERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitSub((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitShlERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitShl((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitShrERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitShr((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitAndERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitAnd((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitXorERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitXor((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter6EmitOrERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitOr((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter24EmitOverflowCheckedBinOpERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitOverflowCheckedBinOp((anonymous namespace)::BinOpInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter42EmitUndefinedBehaviorIntegerDivAndRemCheckERKNS_9BinOpInfoEPN4llvm5ValueEb", "(anonymous namespace)::ScalarExprEmitter::EmitUndefinedBehaviorIntegerDivAndRemCheck((anonymous namespace)::BinOpInfo const&, llvm::Value*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter31EmitAddConsiderOverflowBehaviorEPKN5clang13UnaryOperatorEPN4llvm5ValueES7_b", "(anonymous namespace)::ScalarExprEmitter::EmitAddConsiderOverflowBehavior(clang::UnaryOperator const*, llvm::Value*, llvm::Value*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter25EmitFloatToBoolConversionEPN4llvm5ValueE", "(anonymous namespace)::ScalarExprEmitter::EmitFloatToBoolConversion(llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter23EmitIntToBoolConversionEPN4llvm5ValueE", "(anonymous namespace)::ScalarExprEmitter::EmitIntToBoolConversion(llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter27EmitPointerToBoolConversionEPN4llvm5ValueE", "(anonymous namespace)::ScalarExprEmitter::EmitPointerToBoolConversion(llvm::Value*)"),
	mu_demangle_test("_ZN5clang11StmtVisitorIN12_GLOBAL__N_117ScalarExprEmitterEPN4llvm5ValueEE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::ScalarExprEmitter, llvm::Value*>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter13VisitCallExprEPKN5clang8CallExprE", "(anonymous namespace)::ScalarExprEmitter::VisitCallExpr(clang::CallExpr const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter13EmitNullValueEN5clang8QualTypeE", "(anonymous namespace)::ScalarExprEmitter::EmitNullValue(clang::QualType)"),
	mu_demangle_test("_Z38isCheapEnoughToEvaluateUnconditionallyPKN5clang4ExprERNS_7CodeGen15CodeGenFunctionE", "isCheapEnoughToEvaluateUnconditionally(clang::Expr const*, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter12EmitCastExprEPN5clang8CastExprE", "(anonymous namespace)::ScalarExprEmitter::EmitCastExpr(clang::CastExpr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter18EmitCompoundAssignEPKN5clang22CompoundAssignOperatorEMS0_FPN4llvm5ValueERKNS_9BinOpInfoEE", "(anonymous namespace)::ScalarExprEmitter::EmitCompoundAssign(clang::CompoundAssignOperator const*, llvm::Value* ((anonymous namespace)::ScalarExprEmitter::*)((anonymous namespace)::BinOpInfo const&))"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter10EmitBinOpsEPKN5clang14BinaryOperatorE", "(anonymous namespace)::ScalarExprEmitter::EmitBinOps(clang::BinaryOperator const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ScalarExprEmitter11EmitCompareEPKN5clang14BinaryOperatorEjjj", "(anonymous namespace)::ScalarExprEmitter::EmitCompare(clang::BinaryOperator const*, unsigned int, unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21EmitObjCStringLiteralEPKNS_17ObjCStringLiteralE", "clang::CodeGen::CodeGenFunction::EmitObjCStringLiteral(clang::ObjCStringLiteral const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitObjCSelectorExprEPKNS_16ObjCSelectorExprE", "clang::CodeGen::CodeGenFunction::EmitObjCSelectorExpr(clang::ObjCSelectorExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitObjCProtocolExprEPKNS_16ObjCProtocolExprE", "clang::CodeGen::CodeGenFunction::EmitObjCProtocolExpr(clang::ObjCProtocolExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitObjCMessageExprEPKNS_15ObjCMessageExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitObjCMessageExpr(clang::ObjCMessageExpr const*, clang::CodeGen::ReturnValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12LoadObjCSelfEv", "clang::CodeGen::CodeGenFunction::LoadObjCSelf()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15StartObjCMethodEPKNS_14ObjCMethodDeclEPKNS_17ObjCContainerDeclE", "clang::CodeGen::CodeGenFunction::StartObjCMethod(clang::ObjCMethodDecl const*, clang::ObjCContainerDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18GenerateObjCMethodEPKNS_14ObjCMethodDeclE", "clang::CodeGen::CodeGenFunction::GenerateObjCMethod(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18GenerateObjCGetterEPNS_22ObjCImplementationDeclEPKNS_20ObjCPropertyImplDeclE", "clang::CodeGen::CodeGenFunction::GenerateObjCGetter(clang::ObjCImplementationDecl*, clang::ObjCPropertyImplDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16TypeOfSelfObjectEv", "clang::CodeGen::CodeGenFunction::TypeOfSelfObject()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25IvarTypeWithAggrGCObjectsENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::IvarTypeWithAggrGCObjects(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18GenerateObjCSetterEPNS_22ObjCImplementationDeclEPKNS_20ObjCPropertyImplDeclE", "clang::CodeGen::CodeGenFunction::GenerateObjCSetter(clang::ObjCImplementationDecl*, clang::ObjCPropertyImplDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction21IndirectObjCSetterArgERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenFunction::IndirectObjCSetterArg(clang::CodeGen::CGFunctionInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26GenerateObjCCtorDtorMethodEPNS_22ObjCImplementationDeclEPNS_14ObjCMethodDeclEb", "clang::CodeGen::CodeGenFunction::GenerateObjCCtorDtorMethod(clang::ObjCImplementationDecl*, clang::ObjCMethodDecl*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25EmitObjCPropertyRefLValueEPKNS_19ObjCPropertyRefExprE", "clang::CodeGen::CodeGenFunction::EmitObjCPropertyRefLValue(clang::ObjCPropertyRefExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction27EmitLoadOfPropertyRefLValueENS0_6LValueENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitLoadOfPropertyRefLValue(clang::CodeGen::LValue, clang::CodeGen::ReturnValueSlot)"),
	mu_demangle_test("_Z24GenerateMessageSendSuperRN5clang7CodeGen15CodeGenFunctionENS0_15ReturnValueSlotENS_8QualTypeENS_8SelectorEPN4llvm5ValueERKNS6_11SmallVectorISt4pairINS0_6RValueES4_ELj16EEE", "GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction33EmitStoreThroughPropertyRefLValueENS0_6RValueENS0_6LValueE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughPropertyRefLValue(clang::CodeGen::RValue, clang::CodeGen::LValue)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction25EmitObjCForCollectionStmtERKNS_21ObjCForCollectionStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCForCollectionStmt(clang::ObjCForCollectionStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitObjCAtTryStmtERKNS_13ObjCAtTryStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCAtTryStmt(clang::ObjCAtTryStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19EmitObjCAtThrowStmtERKNS_15ObjCAtThrowStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCAtThrowStmt(clang::ObjCAtThrowStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitObjCAtSynchronizedStmtERKNS_22ObjCAtSynchronizedStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCAtSynchronizedStmt(clang::ObjCAtSynchronizedStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CGObjCRuntimeD0Ev", "clang::CodeGen::CGObjCRuntime::~CGObjCRuntime()"),
	mu_demangle_test("_ZN5clang7CodeGen13CGObjCRuntimeD1Ev", "clang::CodeGen::CGObjCRuntime::~CGObjCRuntime()"),
	mu_demangle_test("_ZN5clang7CodeGen13CGObjCRuntimeD2Ev", "clang::CodeGen::CGObjCRuntime::~CGObjCRuntime()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitCallArgsINS_14ObjCMethodDeclEEEvRN4llvm11SmallVectorISt4pairINS0_6RValueENS_8QualTypeEELj16EEEPKT_NS_17ConstExprIteratorESF_", "void clang::CodeGen::CodeGenFunction::EmitCallArgs<clang::ObjCMethodDecl>(llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u>&, clang::ObjCMethodDecl const*, clang::ConstExprIterator, clang::ConstExprIterator)"),
	mu_demangle_test("_ZNK5clang9ValueDecl7getTypeEv", "clang::ValueDecl::getType() const"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang7CodeGen15CodeGenFunction13BreakContinueELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeGen::CodeGenFunction::BreakContinue, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang7CodeGen20CreateGNUObjCRuntimeERNS0_13CodeGenModuleE", "clang::CodeGen::CreateGNUObjCRuntime(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNUD1Ev", "(anonymous namespace)::CGObjCGNU::~CGObjCGNU()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNUD0Ev", "(anonymous namespace)::CGObjCGNU::~CGObjCGNU()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU18ModuleInitFunctionEv", "(anonymous namespace)::CGObjCGNU::ModuleInitFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU9GetEHTypeEN5clang8QualTypeE", "(anonymous namespace)::CGObjCGNU::GetEHType(clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU22GenerateConstantStringEPKN5clang13StringLiteralE", "(anonymous namespace)::CGObjCGNU::GenerateConstantString(clang::StringLiteral const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU16GenerateCategoryEPKN5clang20ObjCCategoryImplDeclE", "(anonymous namespace)::CGObjCGNU::GenerateCategory(clang::ObjCCategoryImplDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU13GenerateClassEPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCGNU::GenerateClass(clang::ObjCImplementationDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU19GenerateMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueERKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_17ObjCInterfaceDeclEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCGNU::GenerateMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCInterfaceDecl const*, clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU24GenerateMessageSendSuperERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPKNS1_17ObjCInterfaceDeclEbPN4llvm5ValueEbRKNSB_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCGNU::GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, clang::ObjCInterfaceDecl const*, bool, llvm::Value*, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU16GenerateProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCGNU::GenerateProtocol(clang::ObjCProtocolDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU14GenerateMethodEPKN5clang14ObjCMethodDeclEPKNS1_17ObjCContainerDeclE", "(anonymous namespace)::CGObjCGNU::GenerateMethod(clang::ObjCMethodDecl const*, clang::ObjCContainerDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU22GetPropertyGetFunctionEv", "(anonymous namespace)::CGObjCGNU::GetPropertyGetFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU22GetPropertySetFunctionEv", "(anonymous namespace)::CGObjCGNU::GetPropertySetFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU20GetGetStructFunctionEv", "(anonymous namespace)::CGObjCGNU::GetGetStructFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU20GetSetStructFunctionEv", "(anonymous namespace)::CGObjCGNU::GetSetStructFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU27EnumerationMutationFunctionEv", "(anonymous namespace)::CGObjCGNU::EnumerationMutationFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU20EmitSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_22ObjCAtSynchronizedStmtE", "(anonymous namespace)::CGObjCGNU::EmitSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtSynchronizedStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU11EmitTryStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_13ObjCAtTryStmtE", "(anonymous namespace)::CGObjCGNU::EmitTryStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtTryStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU13EmitThrowStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_15ObjCAtThrowStmtE", "(anonymous namespace)::CGObjCGNU::EmitThrowStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtThrowStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU16EmitObjCWeakReadERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::CGObjCGNU::EmitObjCWeakRead(clang::CodeGen::CodeGenFunction&, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU18EmitObjCWeakAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCGNU::EmitObjCWeakAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU20EmitObjCGlobalAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_b", "(anonymous namespace)::CGObjCGNU::EmitObjCGlobalAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU18EmitObjCIvarAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCGNU::EmitObjCIvarAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU24EmitObjCStrongCastAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCGNU::EmitObjCStrongCastAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU20EmitObjCValueForIvarERN5clang7CodeGen15CodeGenFunctionENS1_8QualTypeEPN4llvm5ValueEPKNS1_12ObjCIvarDeclEj", "(anonymous namespace)::CGObjCGNU::EmitObjCValueForIvar(clang::CodeGen::CodeGenFunction&, clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU14EmitIvarOffsetERN5clang7CodeGen15CodeGenFunctionEPKNS1_17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCGNU::EmitIvarOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU24EmitGCMemmoveCollectableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCGNU::EmitGCMemmoveCollectable(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU18BuildGCBlockLayoutERN5clang7CodeGen13CodeGenModuleERKNS2_11CGBlockInfoE", "(anonymous namespace)::CGObjCGNU::BuildGCBlockLayout(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&)"),
	mu_demangle_test("_Z17FindIvarInterfaceRN5clang10ASTContextEPKNS_17ObjCInterfaceDeclEPKNS_12ObjCIvarDeclE", "FindIvarInterface(clang::ASTContext&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallSyncExitD1Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallSyncExitD0Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallSyncExit4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallSyncExit::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU12EmitClassRefERKSs", "(anonymous namespace)::CGObjCGNU::EmitClassRef(std::string const&)"),
	mu_demangle_test("_Z19SymbolNameForMethodRKSsS0_S0_b", "SymbolNameForMethod(std::string const&, std::string const&, std::string const&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU20GenerateProtocolListERKN4llvm15SmallVectorImplISsEE", "(anonymous namespace)::CGObjCGNU::GenerateProtocolList(llvm::SmallVectorImpl<std::string> const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU26GenerateProtocolMethodListERKN4llvm15SmallVectorImplIPNS1_8ConstantEEES7_", "(anonymous namespace)::CGObjCGNU::GenerateProtocolMethodList(llvm::SmallVectorImpl<llvm::Constant*> const&, llvm::SmallVectorImpl<llvm::Constant*> const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU18GenerateMethodListERKSsS2_RKN4llvm15SmallVectorImplIN5clang8SelectorEEERKNS4_IPNS3_8ConstantEEEb", "(anonymous namespace)::CGObjCGNU::GenerateMethodList(std::string const&, std::string const&, llvm::SmallVectorImpl<clang::Selector> const&, llvm::SmallVectorImpl<llvm::Constant*> const&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU16GenerateIvarListERKN4llvm15SmallVectorImplIPNS1_8ConstantEEES7_S7_", "(anonymous namespace)::CGObjCGNU::GenerateIvarList(llvm::SmallVectorImpl<llvm::Constant*> const&, llvm::SmallVectorImpl<llvm::Constant*> const&, llvm::SmallVectorImpl<llvm::Constant*> const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU22GenerateClassStructureEPN4llvm8ConstantES3_jPKcS3_S3_S3_S3_S3_S3_S3_b", "(anonymous namespace)::CGObjCGNU::GenerateClassStructure(llvm::Constant*, llvm::Constant*, unsigned int, char const*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCGNU18ExportUniqueStringERKSsSs", "(anonymous namespace)::CGObjCGNU::ExportUniqueString(std::string const&, std::string)"),
	mu_demangle_test("_Z19MangleSelectorTypesRKSs", "MangleSelectorTypes(std::string const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang7CanQualINS1_4TypeEEELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CanQual<clang::Type>, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseISt4pairIN5clang7CodeGen6RValueENS2_8QualTypeEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::CodeGen::RValue, clang::QualType>, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang7CodeGen13CGObjCRuntime21ComputeIvarBaseOffsetERNS0_13CodeGenModuleEPKNS_17ObjCInterfaceDeclEPKNS_12ObjCIvarDeclE", "clang::CodeGen::CGObjCRuntime::ComputeIvarBaseOffset(clang::CodeGen::CodeGenModule&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_Z20LookupFieldBitOffsetRN5clang7CodeGen13CodeGenModuleEPKNS_17ObjCInterfaceDeclEPKNS_22ObjCImplementationDeclEPKNS_12ObjCIvarDeclE", "LookupFieldBitOffset(clang::CodeGen::CodeGenModule&, clang::ObjCInterfaceDecl const*, clang::ObjCImplementationDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CGObjCRuntime21ComputeIvarBaseOffsetERNS0_13CodeGenModuleEPKNS_22ObjCImplementationDeclEPKNS_12ObjCIvarDeclE", "clang::CodeGen::CGObjCRuntime::ComputeIvarBaseOffset(clang::CodeGen::CodeGenModule&, clang::ObjCImplementationDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CGObjCRuntime24EmitValueForIvarAtOffsetERNS0_15CodeGenFunctionEPKNS_17ObjCInterfaceDeclEPN4llvm5ValueEPKNS_12ObjCIvarDeclEjS9_", "clang::CodeGen::CGObjCRuntime::EmitValueForIvarAtOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen20CreateMacObjCRuntimeERNS0_13CodeGenModuleE", "clang::CodeGen::CreateMacObjCRuntime(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN5clang7CodeGen33CreateMacNonFragileABIObjCRuntimeERNS0_13CodeGenModuleE", "clang::CodeGen::CreateMacNonFragileABIObjCRuntime(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMacC2ERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::CGObjCCommonMac::CGObjCCommonMac(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMacD1Ev", "(anonymous namespace)::CGObjCNonFragileABIMac::~CGObjCNonFragileABIMac()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMacD0Ev", "(anonymous namespace)::CGObjCNonFragileABIMac::~CGObjCNonFragileABIMac()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18ModuleInitFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::ModuleInitFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac9GetEHTypeEN5clang8QualTypeE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetEHType(clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac22GenerateConstantStringEPKN5clang13StringLiteralE", "(anonymous namespace)::CGObjCCommonMac::GenerateConstantString(clang::StringLiteral const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac16GenerateCategoryEPKN5clang20ObjCCategoryImplDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateCategory(clang::ObjCCategoryImplDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac13GenerateClassEPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateClass(clang::ObjCImplementationDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac19GenerateMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueERKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_17ObjCInterfaceDeclEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCInterfaceDecl const*, clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24GenerateMessageSendSuperERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPKNS1_17ObjCInterfaceDeclEbPN4llvm5ValueEbRKNSB_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, clang::ObjCInterfaceDecl const*, bool, llvm::Value*, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac16GenerateProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCCommonMac::GenerateProtocol(clang::ObjCProtocolDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac14GenerateMethodEPKN5clang14ObjCMethodDeclEPKNS1_17ObjCContainerDeclE", "(anonymous namespace)::CGObjCCommonMac::GenerateMethod(clang::ObjCMethodDecl const*, clang::ObjCContainerDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac22GetPropertyGetFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetPropertyGetFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac22GetPropertySetFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetPropertySetFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20GetGetStructFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetGetStructFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20GetSetStructFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetSetStructFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac27EnumerationMutationFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::EnumerationMutationFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20EmitSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_22ObjCAtSynchronizedStmtE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtSynchronizedStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac11EmitTryStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_13ObjCAtTryStmtE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitTryStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtTryStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac13EmitThrowStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_15ObjCAtThrowStmtE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitThrowStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtThrowStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac16EmitObjCWeakReadERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCWeakRead(clang::CodeGen::CodeGenFunction&, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18EmitObjCWeakAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCWeakAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20EmitObjCGlobalAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_b", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCGlobalAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18EmitObjCIvarAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCIvarAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24EmitObjCStrongCastAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCStrongCastAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20EmitObjCValueForIvarERN5clang7CodeGen15CodeGenFunctionENS1_8QualTypeEPN4llvm5ValueEPKNS1_12ObjCIvarDeclEj", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCValueForIvar(clang::CodeGen::CodeGenFunction&, clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac14EmitIvarOffsetERN5clang7CodeGen15CodeGenFunctionEPKNS1_17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitIvarOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24EmitGCMemmoveCollectableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitGCMemmoveCollectable(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac18BuildGCBlockLayoutERN5clang7CodeGen13CodeGenModuleERKNS2_11CGBlockInfoE", "(anonymous namespace)::CGObjCCommonMac::BuildGCBlockLayout(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac17GetOrEmitProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetOrEmitProtocol(clang::ObjCProtocolDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20GetOrEmitProtocolRefEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetOrEmitProtocolRef(clang::ObjCProtocolDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac28GetMethodDescriptionConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetMethodDescriptionConstant(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac12GetClassNameEPN5clang14IdentifierInfoE", "(anonymous namespace)::CGObjCCommonMac::GetClassName(clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac16EmitProtocolListEN4llvm5TwineEPKPN5clang16ObjCProtocolDeclES7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitProtocolList(llvm::Twine, clang::ObjCProtocolDecl* const*, clang::ObjCProtocolDecl* const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac16EmitPropertyListEN4llvm5TwineEPKN5clang4DeclEPKNS3_17ObjCContainerDeclERKNS_21ObjCCommonTypesHelperE", "(anonymous namespace)::CGObjCCommonMac::EmitPropertyList(llvm::Twine, clang::Decl const*, clang::ObjCContainerDecl const*, (anonymous namespace)::ObjCCommonTypesHelper const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac15GetPropertyNameEPN5clang14IdentifierInfoE", "(anonymous namespace)::CGObjCCommonMac::GetPropertyName(clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac21GetPropertyTypeStringEPKN5clang16ObjCPropertyDeclEPKNS1_4DeclE", "(anonymous namespace)::CGObjCCommonMac::GetPropertyTypeString(clang::ObjCPropertyDecl const*, clang::Decl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac17CreateMetadataVarEN4llvm5TwineEPNS1_8ConstantEPKcjb", "(anonymous namespace)::CGObjCCommonMac::CreateMetadataVar(llvm::Twine, llvm::Constant*, char const*, unsigned int, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac16GetMethodVarNameEN5clang8SelectorE", "(anonymous namespace)::CGObjCCommonMac::GetMethodVarName(clang::Selector)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac16GetMethodVarTypeEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCCommonMac::GetMethodVarType(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREE9push_backERKS3_", "llvm::SmallVectorImpl<(anonymous namespace)::CGObjCCommonMac::GC_IVAR>::push_back((anonymous namespace)::CGObjCCommonMac::GC_IVAR const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac25BuildAggrIvarRecordLayoutEPKN5clang10RecordTypeEjbRb", "(anonymous namespace)::CGObjCCommonMac::BuildAggrIvarRecordLayout(clang::RecordType const*, unsigned int, bool, bool&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac21BuildIvarLayoutBitmapERSs", "(anonymous namespace)::CGObjCCommonMac::BuildIvarLayoutBitmap(std::string&)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_115CGObjCCommonMac9SKIP_SCANEE9push_backERKS3_", "llvm::SmallVectorImpl<(anonymous namespace)::CGObjCCommonMac::SKIP_SCAN>::push_back((anonymous namespace)::CGObjCCommonMac::SKIP_SCAN const&)"),
	mu_demangle_test("_ZN4llvm25array_pod_sort_comparatorIN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREEEiPKvS5_", "int llvm::array_pod_sort_comparator<(anonymous namespace)::CGObjCCommonMac::GC_IVAR>(void const*, void const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac19BuildAggrIvarLayoutEPKN5clang22ObjCImplementationDeclEPKN4llvm12StructLayoutEPKNS1_10RecordDeclERKNS5_15SmallVectorImplIPNS1_9FieldDeclEEEjbRb", "(anonymous namespace)::CGObjCCommonMac::BuildAggrIvarLayout(clang::ObjCImplementationDecl const*, llvm::StructLayout const*, clang::RecordDecl const*, llvm::SmallVectorImpl<clang::FieldDecl*> const&, unsigned int, bool, bool&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper22GcMemmoveCollectableFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::GcMemmoveCollectableFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac22ObjCIvarOffsetVariableEPKN5clang17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::ObjCIvarOffsetVariable(clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper23getGcAssignStrongCastFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignStrongCastFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper17getGcAssignIvarFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignIvarFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper19getGcAssignGlobalFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignGlobalFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper24getGcAssignThreadLocalFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignThreadLocalFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper17getGcAssignWeakFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignWeakFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper15getGcReadWeakFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcReadWeakFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper19getExceptionThrowFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getExceptionThrowFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallObjCEndCatchD1Ev", "(anonymous namespace)::CallObjCEndCatch::~CallObjCEndCatch()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallObjCEndCatchD0Ev", "(anonymous namespace)::CallObjCEndCatch::~CallObjCEndCatch()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116CallObjCEndCatch4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallObjCEndCatch::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper14getSyncEnterFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getSyncEnterFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper13getSyncExitFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getSyncExitFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallSyncExitD1Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallSyncExitD0Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"),
	mu_demangle_test("_ZN12_GLOBAL__N_112CallSyncExit4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallSyncExit::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper24getEnumerationMutationFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getEnumerationMutationFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac14GetClassGlobalERKSs", "(anonymous namespace)::CGObjCNonFragileABIMac::GetClassGlobal(std::string const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper15getCopyStructFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getCopyStructFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper16getSetPropertyFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getSetPropertyFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelper16getGetPropertyFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGetPropertyFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24LegacyDispatchedSelectorEN5clang8SelectorE", "(anonymous namespace)::CGObjCNonFragileABIMac::LegacyDispatchedSelector(clang::Selector)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac21EmitLegacyMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeEPN4llvm5ValueES9_S6_bRKNS7_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclERKNS_21ObjCCommonTypesHelperE", "(anonymous namespace)::CGObjCCommonMac::EmitLegacyMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, llvm::Value*, llvm::Value*, clang::QualType, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*, (anonymous namespace)::ObjCCommonTypesHelper const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac15EmitMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueES6_bRKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, clang::QualType, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper21getMessageSendSuperFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendSuperFn() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper16getMessageSendFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendFn() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper22getMessageSendSuperFn2Ev", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendSuperFn2() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper21getMessageSendFpretFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendFpretFn() const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper21getMessageSendStretFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendStretFn() const"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24BuildClassRoTInitializerEjjjPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::BuildClassRoTInitializer(unsigned int, unsigned int, unsigned int, clang::ObjCImplementationDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18BuildClassMetaDataERSsPN4llvm8ConstantES4_S4_b", "(anonymous namespace)::CGObjCNonFragileABIMac::BuildClassMetaData(std::string&, llvm::Constant*, llvm::Constant*, llvm::Constant*, bool)"),
	mu_demangle_test("_Z25hasObjCExceptionAttributeRN5clang10ASTContextEPKNS_17ObjCInterfaceDeclE", "hasObjCExceptionAttribute(clang::ASTContext&, clang::ObjCInterfaceDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18GetInterfaceEHTypeEPKN5clang17ObjCInterfaceDeclEb", "(anonymous namespace)::CGObjCNonFragileABIMac::GetInterfaceEHType(clang::ObjCInterfaceDecl const*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac15BuildIvarLayoutEPKN5clang22ObjCImplementationDeclEb", "(anonymous namespace)::CGObjCCommonMac::BuildIvarLayout(clang::ObjCImplementationDecl const*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac17GetMethodConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetMethodConstant(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac16GetMethodVarTypeEPKN5clang9FieldDeclE", "(anonymous namespace)::CGObjCCommonMac::GetMethodVarType(clang::FieldDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac19GetMethodDefinitionEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCCommonMac::GetMethodDefinition(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZSt4sortIPN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREEvT_S4_", "void std::sort<(anonymous namespace)::CGObjCCommonMac::GC_IVAR*>((anonymous namespace)::CGObjCCommonMac::GC_IVAR*, (anonymous namespace)::CGObjCCommonMac::GC_IVAR*)"),
	mu_demangle_test("_ZSt16__introsort_loopIPN12_GLOBAL__N_115CGObjCCommonMac7GC_IVARElEvT_S4_T0_", "void std::__introsort_loop<(anonymous namespace)::CGObjCCommonMac::GC_IVAR*, long>((anonymous namespace)::CGObjCCommonMac::GC_IVAR*, (anonymous namespace)::CGObjCCommonMac::GC_IVAR*, long)"),
	mu_demangle_test("_ZSt16__insertion_sortIPN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREEvT_S4_", "void std::__insertion_sort<(anonymous namespace)::CGObjCCommonMac::GC_IVAR*>((anonymous namespace)::CGObjCCommonMac::GC_IVAR*, (anonymous namespace)::CGObjCCommonMac::GC_IVAR*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMac13EmitImageInfoEv", "(anonymous namespace)::CGObjCCommonMac::EmitImageInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMacD2Ev", "(anonymous namespace)::CGObjCCommonMac::~CGObjCCommonMac()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMacD1Ev", "(anonymous namespace)::CGObjCCommonMac::~CGObjCCommonMac()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115CGObjCCommonMacD0Ev", "(anonymous namespace)::CGObjCCommonMac::~CGObjCCommonMac()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121ObjCCommonTypesHelperC2ERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::ObjCCommonTypesHelper::ObjCCommonTypesHelper(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMacD1Ev", "(anonymous namespace)::CGObjCMac::~CGObjCMac()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMacD0Ev", "(anonymous namespace)::CGObjCMac::~CGObjCMac()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac18ModuleInitFunctionEv", "(anonymous namespace)::CGObjCMac::ModuleInitFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac9GetEHTypeEN5clang8QualTypeE", "(anonymous namespace)::CGObjCMac::GetEHType(clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac16GenerateCategoryEPKN5clang20ObjCCategoryImplDeclE", "(anonymous namespace)::CGObjCMac::GenerateCategory(clang::ObjCCategoryImplDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac13GenerateClassEPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCMac::GenerateClass(clang::ObjCImplementationDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac19GenerateMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueERKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_17ObjCInterfaceDeclEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GenerateMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCInterfaceDecl const*, clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac24GenerateMessageSendSuperERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPKNS1_17ObjCInterfaceDeclEbPN4llvm5ValueEbRKNSB_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, clang::ObjCInterfaceDecl const*, bool, llvm::Value*, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac22GetPropertyGetFunctionEv", "(anonymous namespace)::CGObjCMac::GetPropertyGetFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac22GetPropertySetFunctionEv", "(anonymous namespace)::CGObjCMac::GetPropertySetFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac20GetGetStructFunctionEv", "(anonymous namespace)::CGObjCMac::GetGetStructFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac20GetSetStructFunctionEv", "(anonymous namespace)::CGObjCMac::GetSetStructFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac27EnumerationMutationFunctionEv", "(anonymous namespace)::CGObjCMac::EnumerationMutationFunction()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac20EmitSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_22ObjCAtSynchronizedStmtE", "(anonymous namespace)::CGObjCMac::EmitSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtSynchronizedStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac11EmitTryStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_13ObjCAtTryStmtE", "(anonymous namespace)::CGObjCMac::EmitTryStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtTryStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac13EmitThrowStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_15ObjCAtThrowStmtE", "(anonymous namespace)::CGObjCMac::EmitThrowStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtThrowStmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac16EmitObjCWeakReadERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::CGObjCMac::EmitObjCWeakRead(clang::CodeGen::CodeGenFunction&, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac18EmitObjCWeakAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCMac::EmitObjCWeakAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac20EmitObjCGlobalAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_b", "(anonymous namespace)::CGObjCMac::EmitObjCGlobalAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac18EmitObjCIvarAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCMac::EmitObjCIvarAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac24EmitObjCStrongCastAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCMac::EmitObjCStrongCastAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac20EmitObjCValueForIvarERN5clang7CodeGen15CodeGenFunctionENS1_8QualTypeEPN4llvm5ValueEPKNS1_12ObjCIvarDeclEj", "(anonymous namespace)::CGObjCMac::EmitObjCValueForIvar(clang::CodeGen::CodeGenFunction&, clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac14EmitIvarOffsetERN5clang7CodeGen15CodeGenFunctionEPKNS1_17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCMac::EmitIvarOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac24EmitGCMemmoveCollectableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCMac::EmitGCMemmoveCollectable(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac17GetOrEmitProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCMac::GetOrEmitProtocol(clang::ObjCProtocolDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac20GetOrEmitProtocolRefEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCMac::GetOrEmitProtocolRef(clang::ObjCProtocolDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac28GetMethodDescriptionConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GetMethodDescriptionConstant(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac16EmitProtocolListEN4llvm5TwineEPKPN5clang16ObjCProtocolDeclES7_", "(anonymous namespace)::CGObjCMac::EmitProtocolList(llvm::Twine, clang::ObjCProtocolDecl* const*, clang::ObjCProtocolDecl* const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac25EmitTryOrSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_4StmtE", "(anonymous namespace)::CGObjCMac::EmitTryOrSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::Stmt const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115ObjCTypesHelper22getExceptionTryEnterFnEv", "(anonymous namespace)::ObjCTypesHelper::getExceptionTryEnterFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115ObjCTypesHelper11getSetJmpFnEv", "(anonymous namespace)::ObjCTypesHelper::getSetJmpFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115ObjCTypesHelper21getExceptionExtractFnEv", "(anonymous namespace)::ObjCTypesHelper::getExceptionExtractFn()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121PerformFragileFinallyD1Ev", "(anonymous namespace)::PerformFragileFinally::~PerformFragileFinally()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121PerformFragileFinallyD0Ev", "(anonymous namespace)::PerformFragileFinally::~PerformFragileFinally()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121PerformFragileFinally4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::PerformFragileFinally::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac17GetMethodConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GetMethodConstant(clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19CGObjCMac12EmitIvarListEPKN5clang22ObjCImplementationDeclEb", "(anonymous namespace)::CGObjCMac::EmitIvarList(clang::ObjCImplementationDecl const*, bool)"),
	mu_demangle_test("_ZN4llvm9StringMapIPNS_14GlobalVariableENS_15MallocAllocatorEE16GetOrCreateValueIS2_EERNS_14StringMapEntryIS2_EENS_9StringRefET_", "llvm::StringMapEntry<llvm::GlobalVariable*>& llvm::StringMap<llvm::GlobalVariable*, llvm::MallocAllocator>::GetOrCreateValue<llvm::GlobalVariable*>(llvm::StringRef, llvm::GlobalVariable*)"),
	mu_demangle_test("_ZN4llvm8SmallSetISsLj16EE6insertERKSs", "llvm::SmallSet<std::string, 16u>::insert(std::string const&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23GetAddrOfRTTIDescriptorENS_8QualTypeEb", "clang::CodeGen::CodeGenModule::GetAddrOfRTTIDescriptor(clang::QualType, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_111RTTIBuilder13BuildTypeInfoEN5clang8QualTypeEb", "(anonymous namespace)::RTTIBuilder::BuildTypeInfo(clang::QualType, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule29EmitFundamentalRTTIDescriptorENS_8QualTypeE", "clang::CodeGen::CodeGenModule::EmitFundamentalRTTIDescriptor(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule30EmitFundamentalRTTIDescriptorsEv", "clang::CodeGen::CodeGenModule::EmitFundamentalRTTIDescriptors()"),
	mu_demangle_test("_Z18getTypeInfoLinkageRN5clang7CodeGen13CodeGenModuleENS_8QualTypeE", "getTypeInfoLinkage(clang::CodeGen::CodeGenModule&, clang::QualType)"),
	mu_demangle_test("_Z23CanUseSingleInheritancePKN5clang13CXXRecordDeclE", "CanUseSingleInheritance(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_111RTTIBuilder20BuildPointerTypeInfoEN5clang8QualTypeE", "(anonymous namespace)::RTTIBuilder::BuildPointerTypeInfo(clang::QualType)"),
	mu_demangle_test("_Z27ContainsIncompleteClassTypeN5clang8QualTypeE", "ContainsIncompleteClassType(clang::QualType)"),
	mu_demangle_test("_Z28ComputeVMIClassTypeInfoFlagsPKN5clang16CXXBaseSpecifierERN12_GLOBAL__N_19SeenBasesE", "ComputeVMIClassTypeInfoFlags(clang::CXXBaseSpecifier const*, (anonymous namespace)::SeenBases&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CGBitFieldInfo8MakeInfoERNS0_12CodeGenTypesEPKNS_9FieldDeclEyyyj", "clang::CodeGen::CGBitFieldInfo::MakeInfo(clang::CodeGen::CodeGenTypes&, clang::FieldDecl const*, uint64_t, uint64_t, uint64_t, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen14CGBitFieldInfo8MakeInfoERNS0_12CodeGenTypesEPKNS_9FieldDeclEyy", "clang::CodeGen::CGBitFieldInfo::MakeInfo(clang::CodeGen::CodeGenTypes&, clang::FieldDecl const*, uint64_t, uint64_t)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes19ComputeRecordLayoutEPKNS_10RecordDeclE", "clang::CodeGen::CodeGenTypes::ComputeRecordLayout(clang::RecordDecl const*)"),
	mu_demangle_test("_ZNK5clang7CodeGen14CGRecordLayout4dumpEv", "clang::CodeGen::CGRecordLayout::dump() const"),
	mu_demangle_test("_ZNK5clang7CodeGen14CGRecordLayout5printERN4llvm11raw_ostreamE", "clang::CodeGen::CGRecordLayout::print(llvm::raw_ostream&) const"),
	mu_demangle_test("_ZNK5clang7CodeGen14CGBitFieldInfo5printERN4llvm11raw_ostreamE", "clang::CodeGen::CGBitFieldInfo::print(llvm::raw_ostream&) const"),
	mu_demangle_test("_ZNK5clang7CodeGen14CGBitFieldInfo4dumpEv", "clang::CodeGen::CGBitFieldInfo::dump() const"),
	mu_demangle_test("_ZN12_GLOBAL__N_121CGRecordLayoutBuilder12LayoutFieldsEPKN5clang10RecordDeclE", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutFields(clang::RecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121CGRecordLayoutBuilder18LayoutVirtualBasesEPKN5clang13CXXRecordDeclERKNS1_15ASTRecordLayoutE", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutVirtualBases(clang::CXXRecordDecl const*, clang::ASTRecordLayout const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121CGRecordLayoutBuilder17LayoutVirtualBaseEPKN5clang13CXXRecordDeclEy", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutVirtualBase(clang::CXXRecordDecl const*, uint64_t)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121CGRecordLayoutBuilder20LayoutNonVirtualBaseEPKN5clang13CXXRecordDeclEy", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutNonVirtualBase(clang::CXXRecordDecl const*, uint64_t)"),
	mu_demangle_test("_ZN5clang7CodeGen14CGRecordLayoutC2EPKN4llvm10StructTypeES5_b", "clang::CodeGen::CGRecordLayout::CGRecordLayout(llvm::StructType const*, llvm::StructType const*, bool)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseISt4pairIPKN5clang9FieldDeclENS2_7CodeGen14CGBitFieldInfoEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::FieldDecl const*, clang::CodeGen::CGBitFieldInfo>, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13EmitStopPointEPKNS_4StmtE", "clang::CodeGen::CodeGenFunction::EmitStopPoint(clang::Stmt const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction8EmitStmtEPKNS_4StmtE", "clang::CodeGen::CodeGenFunction::EmitStmt(clang::Stmt const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitSimpleStmtEPKNS_4StmtE", "clang::CodeGen::CodeGenFunction::EmitSimpleStmt(clang::Stmt const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitIndirectGotoStmtERKNS_16IndirectGotoStmtE", "clang::CodeGen::CodeGenFunction::EmitIndirectGotoStmt(clang::IndirectGotoStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction10EmitIfStmtERKNS_6IfStmtE", "clang::CodeGen::CodeGenFunction::EmitIfStmt(clang::IfStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13EmitWhileStmtERKNS_9WhileStmtE", "clang::CodeGen::CodeGenFunction::EmitWhileStmt(clang::WhileStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction10EmitDoStmtERKNS_6DoStmtE", "clang::CodeGen::CodeGenFunction::EmitDoStmt(clang::DoStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11EmitForStmtERKNS_7ForStmtE", "clang::CodeGen::CodeGenFunction::EmitForStmt(clang::ForStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitReturnStmtERKNS_10ReturnStmtE", "clang::CodeGen::CodeGenFunction::EmitReturnStmt(clang::ReturnStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14EmitSwitchStmtERKNS_10SwitchStmtE", "clang::CodeGen::CodeGenFunction::EmitSwitchStmt(clang::SwitchStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11EmitAsmStmtERKNS_7AsmStmtE", "clang::CodeGen::CodeGenFunction::EmitAsmStmt(clang::AsmStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitCompoundStmtERKNS_12CompoundStmtEbNS0_12AggValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCompoundStmt(clang::CompoundStmt const&, bool, clang::CodeGen::AggValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitDeclStmtERKNS_8DeclStmtE", "clang::CodeGen::CodeGenFunction::EmitDeclStmt(clang::DeclStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13EmitLabelStmtERKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::EmitLabelStmt(clang::LabelStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitGotoStmtERKNS_8GotoStmtE", "clang::CodeGen::CodeGenFunction::EmitGotoStmt(clang::GotoStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13EmitBreakStmtERKNS_9BreakStmtE", "clang::CodeGen::CodeGenFunction::EmitBreakStmt(clang::BreakStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitContinueStmtERKNS_12ContinueStmtE", "clang::CodeGen::CodeGenFunction::EmitContinueStmt(clang::ContinueStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitDefaultStmtERKNS_11DefaultStmtE", "clang::CodeGen::CodeGenFunction::EmitDefaultStmt(clang::DefaultStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitCaseStmtERKNS_8CaseStmtE", "clang::CodeGen::CodeGenFunction::EmitCaseStmt(clang::CaseStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction9EmitLabelERKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::EmitLabel(clang::LabelStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24SimplifyForwardingBlocksEPN4llvm10BasicBlockE", "clang::CodeGen::CodeGenFunction::SimplifyForwardingBlocks(llvm::BasicBlock*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction9EmitBlockEPN4llvm10BasicBlockEb", "clang::CodeGen::CodeGenFunction::EmitBlock(llvm::BasicBlock*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction10EmitBranchEPN4llvm10BasicBlockE", "clang::CodeGen::CodeGenFunction::EmitBranch(llvm::BasicBlock*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction19getJumpDestForLabelEPKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::getJumpDestForLabel(clang::LabelStmt const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitReturnOfRValueENS0_6RValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitReturnOfRValue(clang::CodeGen::RValue, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17EmitCaseStmtRangeERKNS_8CaseStmtE", "clang::CodeGen::CodeGenFunction::EmitCaseStmtRange(clang::CaseStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction18EmitAsmInputLValueERKNS_7AsmStmtERKNS_10TargetInfo14ConstraintInfoENS0_6LValueENS_8QualTypeERSs", "clang::CodeGen::CodeGenFunction::EmitAsmInputLValue(clang::AsmStmt const&, clang::TargetInfo::ConstraintInfo const&, clang::CodeGen::LValue, clang::QualType, std::string&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12EmitAsmInputERKNS_7AsmStmtERKNS_10TargetInfo14ConstraintInfoEPKNS_4ExprERSs", "clang::CodeGen::CodeGenFunction::EmitAsmInput(clang::AsmStmt const&, clang::TargetInfo::ConstraintInfo const&, clang::Expr const*, std::string&)"),
	mu_demangle_test("_Z18SimplifyConstraintPKcRKN5clang10TargetInfoEPN4llvm15SmallVectorImplINS2_14ConstraintInfoEEE", "SimplifyConstraint(char const*, clang::TargetInfo const&, llvm::SmallVectorImpl<clang::TargetInfo::ConstraintInfo>*)"),
	mu_demangle_test("_Z22AddVariableConstraintsRKSsRKN5clang4ExprERKNS1_10TargetInfoERNS1_7CodeGen13CodeGenModuleERKNS1_7AsmStmtE", "AddVariableConstraints(std::string const&, clang::Expr const&, clang::TargetInfo const&, clang::CodeGen::CodeGenModule&, clang::AsmStmt const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitCXXTemporaryEPKNS_12CXXTemporaryEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCXXTemporary(clang::CXXTemporary const*, llvm::Value*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitExprWithCleanupsEPKNS_16ExprWithCleanupsENS0_12AggValueSlotE", "clang::CodeGen::CodeGenFunction::EmitExprWithCleanups(clang::ExprWithCleanups const*, clang::CodeGen::AggValueSlot)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction26EmitExprWithCleanupsLValueEPKNS_16ExprWithCleanupsE", "clang::CodeGen::CodeGenFunction::EmitExprWithCleanupsLValue(clang::ExprWithCleanups const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~ConditionalCleanup2()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~ConditionalCleanup2()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::ConditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~UnconditionalCleanup2()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~UnconditionalCleanup2()"),
	mu_demangle_test("_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::UnconditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables17EmitVTTDefinitionEPN4llvm14GlobalVariableENS2_11GlobalValue12LinkageTypesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::EmitVTTDefinition(llvm::GlobalVariable*, llvm::GlobalValue::LinkageTypes, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_110VTTBuilderC1ERN5clang7CodeGen13CodeGenModuleEPKNS1_13CXXRecordDeclEb", "(anonymous namespace)::VTTBuilder::VTTBuilder(clang::CodeGen::CodeGenModule&, clang::CXXRecordDecl const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables12GetAddrOfVTTEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::GetAddrOfVTT(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables17needsVTTParameterENS0_10GlobalDeclE", "clang::CodeGen::CodeGenVTables::needsVTTParameter(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables14getSubVTTIndexEPKNS_13CXXRecordDeclENS0_13BaseSubobjectE", "clang::CodeGen::CodeGenVTables::getSubVTTIndex(clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables31getSecondaryVirtualPointerIndexEPKNS_13CXXRecordDeclENS0_13BaseSubobjectE", "clang::CodeGen::CodeGenVTables::getSecondaryVirtualPointerIndex(clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject)"),
	mu_demangle_test("_ZN12_GLOBAL__N_110VTTBuilder9LayoutVTTEN5clang7CodeGen13BaseSubobjectEb", "(anonymous namespace)::VTTBuilder::LayoutVTT(clang::CodeGen::BaseSubobject, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_110VTTBuilder17LayoutVirtualVTTsEPKN5clang13CXXRecordDeclERN4llvm11SmallPtrSetIS4_Lj4EEE", "(anonymous namespace)::VTTBuilder::LayoutVirtualVTTs(clang::CXXRecordDecl const*, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables26ComputeMethodVTableIndicesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::ComputeMethodVTableIndices(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables29getNumVirtualFunctionPointersEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::getNumVirtualFunctionPointers(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_127FindNearestOverriddenMethodEPKN5clang13CXXMethodDeclERN4llvm14SmallSetVectorIPKNS0_13CXXRecordDeclELj8EEE", "(anonymous namespace)::FindNearestOverriddenMethod(clang::CXXMethodDecl const*, llvm::SmallSetVector<clang::CXXRecordDecl const*, 8u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_133ComputeReturnAdjustmentBaseOffsetERN5clang10ASTContextEPKNS0_13CXXMethodDeclES5_", "(anonymous namespace)::ComputeReturnAdjustmentBaseOffset(clang::ASTContext&, clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables20getMethodVTableIndexENS0_10GlobalDeclE", "clang::CodeGen::CodeGenVTables::getMethodVTableIndex(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables24ShouldEmitVTableInThisTUEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::ShouldEmitVTableInThisTU(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables26getVirtualBaseOffsetOffsetEPKNS_13CXXRecordDeclES4_", "clang::CodeGen::CodeGenVTables::getVirtualBaseOffsetOffset(clang::CXXRecordDecl const*, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilderC1EPKN5clang13CXXRecordDeclES4_PKNS_15FinalOverridersENS1_7CodeGen13BaseSubobjectEby", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::VCallAndVBaseOffsetBuilder(clang::CXXRecordDecl const*, clang::CXXRecordDecl const*, (anonymous namespace)::FinalOverriders const*, clang::CodeGen::BaseSubobject, bool, uint64_t)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables15getAddressPointENS0_13BaseSubobjectEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::getAddressPoint(clang::CodeGen::BaseSubobject, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule14GetAddrOfThunkENS0_10GlobalDeclERKNS_9ThunkInfoE", "clang::CodeGen::CodeGenModule::GetAddrOfThunk(clang::CodeGen::GlobalDecl, clang::ThunkInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13GenerateThunkEPN4llvm8FunctionENS0_10GlobalDeclERKNS_9ThunkInfoE", "clang::CodeGen::CodeGenFunction::GenerateThunk(llvm::Function*, clang::CodeGen::GlobalDecl, clang::ThunkInfo const&)"),
	mu_demangle_test("_Z21PerformTypeAdjustmentRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueExx", "PerformTypeAdjustment(clang::CodeGen::CodeGenFunction&, llvm::Value*, int64_t, int64_t)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables9EmitThunkENS0_10GlobalDeclERKNS_9ThunkInfoEb", "clang::CodeGen::CodeGenVTables::EmitThunk(clang::CodeGen::GlobalDecl, clang::ThunkInfo const&, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables33MaybeEmitThunkAvailableExternallyENS0_10GlobalDeclERKNS_9ThunkInfoE", "clang::CodeGen::CodeGenVTables::MaybeEmitThunkAvailableExternally(clang::CodeGen::GlobalDecl, clang::ThunkInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables10EmitThunksENS0_10GlobalDeclE", "clang::CodeGen::CodeGenVTables::EmitThunks(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables31ComputeVTableRelatedInformationEPKNS_13CXXRecordDeclEb", "clang::CodeGen::CodeGenVTables::ComputeVTableRelatedInformation(clang::CXXRecordDecl const*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilderC1ERN5clang7CodeGen14CodeGenVTablesEPKNS1_13CXXRecordDeclEybS7_", "(anonymous namespace)::VTableBuilder::VTableBuilder(clang::CodeGen::CodeGenVTables&, clang::CXXRecordDecl const*, uint64_t, bool, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilderD1Ev", "(anonymous namespace)::VTableBuilder::~VTableBuilder()"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables23CreateVTableInitializerEPKNS_13CXXRecordDeclEPKyjRKN4llvm11SmallVectorISt4pairIyNS_9ThunkInfoEELj1EEE", "clang::CodeGen::CodeGenVTables::CreateVTableInitializer(clang::CXXRecordDecl const*, uint64_t const*, unsigned int, llvm::SmallVector<std::pair<uint64_t, clang::ThunkInfo>, 1u> const&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables15GetAddrOfVTableEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::GetAddrOfVTable(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables20EmitVTableDefinitionEPN4llvm14GlobalVariableENS2_11GlobalValue12LinkageTypesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::EmitVTableDefinition(llvm::GlobalVariable*, llvm::GlobalValue::LinkageTypes, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilder10dumpLayoutERN4llvm11raw_ostreamE", "(anonymous namespace)::VTableBuilder::dumpLayout(llvm::raw_ostream&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTables17GenerateClassDataEN4llvm11GlobalValue12LinkageTypesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::GenerateClassData(llvm::GlobalValue::LinkageTypes, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilder32LayoutPrimaryAndSecondaryVTablesEN5clang7CodeGen13BaseSubobjectEbby", "(anonymous namespace)::VTableBuilder::LayoutPrimaryAndSecondaryVTables(clang::CodeGen::BaseSubobject, bool, bool, uint64_t)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilder28DeterminePrimaryVirtualBasesEPKN5clang13CXXRecordDeclEyRN4llvm11SmallPtrSetIS4_Lj4EEE", "(anonymous namespace)::VTableBuilder::DeterminePrimaryVirtualBases(clang::CXXRecordDecl const*, uint64_t, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilder28LayoutVTablesForVirtualBasesEPKN5clang13CXXRecordDeclERN4llvm11SmallPtrSetIS4_Lj4EEE", "(anonymous namespace)::VTableBuilder::LayoutVTablesForVirtualBases(clang::CXXRecordDecl const*, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilder10AddMethodsEN5clang7CodeGen13BaseSubobjectEyPKNS1_13CXXRecordDeclEyRN4llvm14SmallSetVectorIS6_Lj8EEE", "(anonymous namespace)::VTableBuilder::AddMethods(clang::CodeGen::BaseSubobject, uint64_t, clang::CXXRecordDecl const*, uint64_t, llvm::SmallSetVector<clang::CXXRecordDecl const*, 8u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilder22LayoutSecondaryVTablesEN5clang7CodeGen13BaseSubobjectEby", "(anonymous namespace)::VTableBuilder::LayoutSecondaryVTables(clang::CodeGen::BaseSubobject, bool, uint64_t)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113VTableBuilder21ComputeThisAdjustmentEPKN5clang13CXXMethodDeclEyNS_15FinalOverriders13OverriderInfoE", "(anonymous namespace)::VTableBuilder::ComputeThisAdjustment(clang::CXXMethodDecl const*, uint64_t, (anonymous namespace)::FinalOverriders::OverriderInfo)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114VCallOffsetMap26MethodsCanShareVCallOffsetEPKN5clang13CXXMethodDeclES4_", "(anonymous namespace)::VCallOffsetMap::MethodsCanShareVCallOffset(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117ComputeBaseOffsetERN5clang10ASTContextEPKNS0_13CXXRecordDeclERKNS0_11CXXBasePathE", "(anonymous namespace)::ComputeBaseOffset(clang::ASTContext&, clang::CXXRecordDecl const*, clang::CXXBasePath const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_130OverridesIndirectMethodInBasesEPKN5clang13CXXMethodDeclERN4llvm14SmallSetVectorIPKNS0_13CXXRecordDeclELj8EEE", "(anonymous namespace)::OverridesIndirectMethodInBases(clang::CXXMethodDecl const*, llvm::SmallSetVector<clang::CXXRecordDecl const*, 8u>&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN12_GLOBAL__N_115VTableComponentELb0EE4growEm", "llvm::SmallVectorTemplateBase<(anonymous namespace)::VTableComponent, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilder23AddVCallAndVBaseOffsetsEN5clang7CodeGen13BaseSubobjectEby", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::AddVCallAndVBaseOffsets(clang::CodeGen::BaseSubobject, bool, uint64_t)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilder15AddVBaseOffsetsEPKN5clang13CXXRecordDeclEy", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::AddVBaseOffsets(clang::CXXRecordDecl const*, uint64_t)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilder15AddVCallOffsetsEN5clang7CodeGen13BaseSubobjectEy", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::AddVCallOffsets(clang::CodeGen::BaseSubobject, uint64_t)"),
	mu_demangle_test("_ZN12_GLOBAL__N_127ComputeAllOverriddenMethodsEPKN5clang13CXXMethodDeclERN4llvm11SmallPtrSetIS3_Lj8EEE", "(anonymous namespace)::ComputeAllOverriddenMethods(clang::CXXMethodDecl const*, llvm::SmallPtrSet<clang::CXXMethodDecl const*, 8u>&)"),
	mu_demangle_test("_ZSt16__introsort_loopIPSt4pairIyN5clang9ThunkInfoEElEvT_S5_T0_", "void std::__introsort_loop<std::pair<uint64_t, clang::ThunkInfo>*, long>(std::pair<uint64_t, clang::ThunkInfo>*, std::pair<uint64_t, clang::ThunkInfo>*, long)"),
	mu_demangle_test("_ZSt22__final_insertion_sortIPSt4pairIyN5clang9ThunkInfoEEEvT_S5_", "void std::__final_insertion_sort<std::pair<uint64_t, clang::ThunkInfo>*>(std::pair<uint64_t, clang::ThunkInfo>*, std::pair<uint64_t, clang::ThunkInfo>*)"),
	mu_demangle_test("_ZSt16__insertion_sortIPSt4pairIyN5clang9ThunkInfoEEEvT_S5_", "void std::__insertion_sort<std::pair<uint64_t, clang::ThunkInfo>*>(std::pair<uint64_t, clang::ThunkInfo>*, std::pair<uint64_t, clang::ThunkInfo>*)"),
	mu_demangle_test("_ZSt13__heap_selectIPSt4pairIyN5clang9ThunkInfoEEEvT_S5_S5_", "void std::__heap_select<std::pair<uint64_t, clang::ThunkInfo>*>(std::pair<uint64_t, clang::ThunkInfo>*, std::pair<uint64_t, clang::ThunkInfo>*, std::pair<uint64_t, clang::ThunkInfo>*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseISt4pairIyN5clang9ThunkInfoEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<uint64_t, clang::ThunkInfo>, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang9ThunkInfoEEaSERKS3_", "llvm::SmallVectorImpl<clang::ThunkInfo>::operator=(llvm::SmallVectorImpl<clang::ThunkInfo> const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang9ThunkInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ThunkInfo, false>::grow(unsigned long)"),
	mu_demangle_test("_ZSt16__introsort_loopIPN5clang9ThunkInfoElEvT_S3_T0_", "void std::__introsort_loop<clang::ThunkInfo*, long>(clang::ThunkInfo*, clang::ThunkInfo*, long)"),
	mu_demangle_test("_ZSt22__final_insertion_sortIPN5clang9ThunkInfoEEvT_S3_", "void std::__final_insertion_sort<clang::ThunkInfo*>(clang::ThunkInfo*, clang::ThunkInfo*)"),
	mu_demangle_test("_ZSt16__insertion_sortIPN5clang9ThunkInfoEEvT_S3_", "void std::__insertion_sort<clang::ThunkInfo*>(clang::ThunkInfo*, clang::ThunkInfo*)"),
	mu_demangle_test("_ZSt21__unguarded_partitionIPN5clang9ThunkInfoES1_ET_S3_S3_T0_", "clang::ThunkInfo* std::__unguarded_partition<clang::ThunkInfo*, clang::ThunkInfo>(clang::ThunkInfo*, clang::ThunkInfo*, clang::ThunkInfo)"),
	mu_demangle_test("_ZSt8__medianIN5clang9ThunkInfoEERKT_S4_S4_S4_", "clang::ThunkInfo const& std::__median<clang::ThunkInfo>(clang::ThunkInfo const&, clang::ThunkInfo const&, clang::ThunkInfo const&)"),
	mu_demangle_test("_ZSt13__heap_selectIPN5clang9ThunkInfoEEvT_S3_S3_", "void std::__heap_select<clang::ThunkInfo*>(clang::ThunkInfo*, clang::ThunkInfo*, clang::ThunkInfo*)"),
	mu_demangle_test("_ZSt13__adjust_heapIPN5clang9ThunkInfoElS1_EvT_T0_S4_T1_", "void std::__adjust_heap<clang::ThunkInfo*, long, clang::ThunkInfo>(clang::ThunkInfo*, long, long, clang::ThunkInfo)"),
	mu_demangle_test("_ZNK5clang15ASTRecordLayout25getVBaseClassOffsetInBitsEPKNS_13CXXRecordDeclE", "clang::ASTRecordLayout::getVBaseClassOffsetInBits(clang::CXXRecordDecl const*) const"),
	mu_demangle_test("_ZSt6__findIPN5clang9ThunkInfoES1_ET_S3_S3_RKT0_St26random_access_iterator_tag", "clang::ThunkInfo* std::__find<clang::ThunkInfo*, clang::ThunkInfo>(clang::ThunkInfo*, clang::ThunkInfo*, clang::ThunkInfo const&, std::random_access_iterator_tag)"),
	mu_demangle_test("_ZN5clang15BackendConsumer21InlineAsmDiagHandler2ERKN4llvm12SMDiagnosticENS_14SourceLocationE", "clang::BackendConsumer::InlineAsmDiagHandler2(llvm::SMDiagnostic const&, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang13CodeGenActionC1Ej", "clang::CodeGenAction::CodeGenAction(unsigned int)"),
	mu_demangle_test("_ZN5clang13CodeGenActionC2Ej", "clang::CodeGenAction::CodeGenAction(unsigned int)"),
	mu_demangle_test("_ZN5clang13CodeGenActionD0Ev", "clang::CodeGenAction::~CodeGenAction()"),
	mu_demangle_test("_ZN5clang13CodeGenActionD1Ev", "clang::CodeGenAction::~CodeGenAction()"),
	mu_demangle_test("_ZN5clang13CodeGenActionD2Ev", "clang::CodeGenAction::~CodeGenAction()"),
	mu_demangle_test("_ZNK5clang13CodeGenAction12hasIRSupportEv", "clang::CodeGenAction::hasIRSupport() const"),
	mu_demangle_test("_ZN5clang13CodeGenAction19EndSourceFileActionEv", "clang::CodeGenAction::EndSourceFileAction()"),
	mu_demangle_test("_ZN5clang13CodeGenAction10takeModuleEv", "clang::CodeGenAction::takeModule()"),
	mu_demangle_test("_ZN5clang13CodeGenAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::CodeGenAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"),
	mu_demangle_test("_Z15GetOutputStreamRN5clang16CompilerInstanceEN4llvm9StringRefENS_13BackendActionE", "GetOutputStream(clang::CompilerInstance&, llvm::StringRef, clang::BackendAction)"),
	mu_demangle_test("_ZN5clang13CodeGenAction13ExecuteActionEv", "clang::CodeGenAction::ExecuteAction()"),
	mu_demangle_test("_ZN5clang18EmitAssemblyActionC1Ev", "clang::EmitAssemblyAction::EmitAssemblyAction()"),
	mu_demangle_test("_ZN5clang18EmitAssemblyActionC2Ev", "clang::EmitAssemblyAction::EmitAssemblyAction()"),
	mu_demangle_test("_ZN5clang12EmitBCActionC1Ev", "clang::EmitBCAction::EmitBCAction()"),
	mu_demangle_test("_ZN5clang12EmitBCActionC2Ev", "clang::EmitBCAction::EmitBCAction()"),
	mu_demangle_test("_ZN5clang14EmitLLVMActionC1Ev", "clang::EmitLLVMAction::EmitLLVMAction()"),
	mu_demangle_test("_ZN5clang14EmitLLVMActionC2Ev", "clang::EmitLLVMAction::EmitLLVMAction()"),
	mu_demangle_test("_ZN5clang18EmitLLVMOnlyActionC1Ev", "clang::EmitLLVMOnlyAction::EmitLLVMOnlyAction()"),
	mu_demangle_test("_ZN5clang18EmitLLVMOnlyActionC2Ev", "clang::EmitLLVMOnlyAction::EmitLLVMOnlyAction()"),
	mu_demangle_test("_ZN5clang21EmitCodeGenOnlyActionC1Ev", "clang::EmitCodeGenOnlyAction::EmitCodeGenOnlyAction()"),
	mu_demangle_test("_ZN5clang21EmitCodeGenOnlyActionC2Ev", "clang::EmitCodeGenOnlyAction::EmitCodeGenOnlyAction()"),
	mu_demangle_test("_ZN5clang13EmitObjActionC1Ev", "clang::EmitObjAction::EmitObjAction()"),
	mu_demangle_test("_ZN5clang13EmitObjActionC2Ev", "clang::EmitObjAction::EmitObjAction()"),
	mu_demangle_test("_ZN4llvm7ParseIREPNS_12MemoryBufferERNS_12SMDiagnosticERNS_11LLVMContextE", "llvm::ParseIR(llvm::MemoryBuffer*, llvm::SMDiagnostic&, llvm::LLVMContext&)"),
	mu_demangle_test("_ZN5clang13EmitObjActionD1Ev", "clang::EmitObjAction::~EmitObjAction()"),
	mu_demangle_test("_ZN5clang13EmitObjActionD0Ev", "clang::EmitObjAction::~EmitObjAction()"),
	mu_demangle_test("_ZN5clang21EmitCodeGenOnlyActionD1Ev", "clang::EmitCodeGenOnlyAction::~EmitCodeGenOnlyAction()"),
	mu_demangle_test("_ZN5clang21EmitCodeGenOnlyActionD0Ev", "clang::EmitCodeGenOnlyAction::~EmitCodeGenOnlyAction()"),
	mu_demangle_test("_ZN5clang18EmitLLVMOnlyActionD1Ev", "clang::EmitLLVMOnlyAction::~EmitLLVMOnlyAction()"),
	mu_demangle_test("_ZN5clang18EmitLLVMOnlyActionD0Ev", "clang::EmitLLVMOnlyAction::~EmitLLVMOnlyAction()"),
	mu_demangle_test("_ZN5clang14EmitLLVMActionD1Ev", "clang::EmitLLVMAction::~EmitLLVMAction()"),
	mu_demangle_test("_ZN5clang14EmitLLVMActionD0Ev", "clang::EmitLLVMAction::~EmitLLVMAction()"),
	mu_demangle_test("_ZN5clang12EmitBCActionD1Ev", "clang::EmitBCAction::~EmitBCAction()"),
	mu_demangle_test("_ZN5clang12EmitBCActionD0Ev", "clang::EmitBCAction::~EmitBCAction()"),
	mu_demangle_test("_ZN5clang18EmitAssemblyActionD1Ev", "clang::EmitAssemblyAction::~EmitAssemblyAction()"),
	mu_demangle_test("_ZN5clang18EmitAssemblyActionD0Ev", "clang::EmitAssemblyAction::~EmitAssemblyAction()"),
	mu_demangle_test("_ZN5clang15BackendConsumerD1Ev", "clang::BackendConsumer::~BackendConsumer()"),
	mu_demangle_test("_ZN5clang15BackendConsumerD0Ev", "clang::BackendConsumer::~BackendConsumer()"),
	mu_demangle_test("_ZN5clang15BackendConsumer10InitializeERNS_10ASTContextE", "clang::BackendConsumer::Initialize(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang15BackendConsumer18HandleTopLevelDeclENS_12DeclGroupRefE", "clang::BackendConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN5clang15BackendConsumer21HandleTranslationUnitERNS_10ASTContextE", "clang::BackendConsumer::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang15BackendConsumer23HandleTagDeclDefinitionEPNS_7TagDeclE", "clang::BackendConsumer::HandleTagDeclDefinition(clang::TagDecl*)"),
	mu_demangle_test("_ZN5clang15BackendConsumer27CompleteTentativeDefinitionEPNS_7VarDeclE", "clang::BackendConsumer::CompleteTentativeDefinition(clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang15BackendConsumer12HandleVTableEPNS_13CXXRecordDeclEb", "clang::BackendConsumer::HandleVTable(clang::CXXRecordDecl*, bool)"),
	mu_demangle_test("_ZN5clang20PrettyStackTraceDeclD1Ev", "clang::PrettyStackTraceDecl::~PrettyStackTraceDecl()"),
	mu_demangle_test("_ZN5clang20PrettyStackTraceDeclD0Ev", "clang::PrettyStackTraceDecl::~PrettyStackTraceDecl()"),
	mu_demangle_test("_ZN5clang15BackendConsumer20InlineAsmDiagHandlerERKN4llvm12SMDiagnosticEPvj", "clang::BackendConsumer::InlineAsmDiagHandler(llvm::SMDiagnostic const&, void*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunctionC1ERNS0_13CodeGenModuleE", "clang::CodeGen::CodeGenFunction::CodeGenFunction(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunctionC2ERNS0_13CodeGenModuleE", "clang::CodeGen::CodeGenFunction::CodeGenFunction(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZNK5clang7CodeGen15CodeGenFunction10getContextEv", "clang::CodeGen::CodeGenFunction::getContext() const"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17ConvertTypeForMemENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::ConvertTypeForMem(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11ConvertTypeENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::ConvertType(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20hasAggregateLLVMTypeENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::hasAggregateLLVMType(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction15EmitReturnBlockEv", "clang::CodeGen::CodeGenFunction::EmitReturnBlock()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14FinishFunctionENS_14SourceLocationE", "clang::CodeGen::CodeGenFunction::FinishFunction(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction27EmitFunctionInstrumentationEPKc", "clang::CodeGen::CodeGenFunction::EmitFunctionInstrumentation(char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction24ShouldInstrumentFunctionEv", "clang::CodeGen::CodeGenFunction::ShouldInstrumentFunction()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13StartFunctionENS0_10GlobalDeclENS_8QualTypeEPN4llvm8FunctionERKNS4_11SmallVectorISt4pairIPKNS_7VarDeclES3_ELj16EEENS_14SourceLocationE", "clang::CodeGen::CodeGenFunction::StartFunction(clang::CodeGen::GlobalDecl, clang::QualType, llvm::Function*, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction11EmitVLASizeENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitVLASize(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitFunctionBodyERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitFunctionBody(llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction12GenerateCodeENS0_10GlobalDeclEPN4llvm8FunctionE", "clang::CodeGen::CodeGenFunction::GenerateCode(clang::CodeGen::GlobalDecl, llvm::Function*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13ContainsLabelEPKNS_4StmtEb", "clang::CodeGen::CodeGenFunction::ContainsLabel(clang::Stmt const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction28ConstantFoldsToSimpleIntegerEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::ConstantFoldsToSimpleInteger(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20EmitBranchOnBoolExprEPKNS_4ExprEPN4llvm10BasicBlockES7_", "clang::CodeGen::CodeGenFunction::EmitBranchOnBoolExpr(clang::Expr const*, llvm::BasicBlock*, llvm::BasicBlock*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16ErrorUnsupportedEPKNS_4StmtEPKcb", "clang::CodeGen::CodeGenFunction::ErrorUnsupported(clang::Stmt const*, char const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction22EmitNullInitializationEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitNullInitialization(llvm::Value*, clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction10GetVLASizeEPKNS_17VariableArrayTypeE", "clang::CodeGen::CodeGenFunction::GetVLASize(clang::VariableArrayType const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction14GetAddrOfLabelEPKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::GetAddrOfLabel(clang::LabelStmt const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction20GetIndirectGotoBlockEv", "clang::CodeGen::CodeGenFunction::GetIndirectGotoBlock()"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction13EmitVAListRefEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitVAListRef(clang::Expr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction23EmitDeclRefExprDbgValueEPKNS_11DeclRefExprEPN4llvm8ConstantE", "clang::CodeGen::CodeGenFunction::EmitDeclRefExprDbgValue(clang::DeclRefExpr const*, llvm::Constant*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModuleC1ERNS_10ASTContextERKNS_14CodeGenOptionsERN4llvm6ModuleERKNS7_10DataLayoutERNS_10DiagnosticE", "clang::CodeGen::CodeGenModule::CodeGenModule(clang::ASTContext&, clang::CodeGenOptions const&, llvm::Module&, llvm::DataLayout const&, clang::Diagnostic&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModuleC2ERNS_10ASTContextERKNS_14CodeGenOptionsERN4llvm6ModuleERKNS7_10DataLayoutERNS_10DiagnosticE", "clang::CodeGen::CodeGenModule::CodeGenModule(clang::ASTContext&, clang::CodeGenOptions const&, llvm::Module&, llvm::DataLayout const&, clang::Diagnostic&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModuleD1Ev", "clang::CodeGen::CodeGenModule::~CodeGenModule()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModuleD2Ev", "clang::CodeGen::CodeGenModule::~CodeGenModule()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule17createObjCRuntimeEv", "clang::CodeGen::CodeGenModule::createObjCRuntime()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule7ReleaseEv", "clang::CodeGen::CodeGenModule::Release()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule12EmitDeferredEv", "clang::CodeGen::CodeGenModule::EmitDeferred()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule13AddGlobalCtorEPN4llvm8FunctionEi", "clang::CodeGen::CodeGenModule::AddGlobalCtor(llvm::Function*, int)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule15EmitAnnotationsEv", "clang::CodeGen::CodeGenModule::EmitAnnotations()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule12EmitLLVMUsedEv", "clang::CodeGen::CodeGenModule::EmitLLVMUsed()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16EmitDeclMetadataEv", "clang::CodeGen::CodeGenModule::EmitDeclMetadata()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule11getTBAAInfoENS_8QualTypeE", "clang::CodeGen::CodeGenModule::getTBAAInfo(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19DecorateInstructionEPN4llvm11InstructionEPNS2_6MDNodeE", "clang::CodeGen::CodeGenModule::DecorateInstruction(llvm::Instruction*, llvm::MDNode*)"),
	mu_demangle_test("_ZNK5clang7CodeGen13CodeGenModule14isTargetDarwinEv", "clang::CodeGen::CodeGenModule::isTargetDarwin() const"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16ErrorUnsupportedEPKNS_4StmtEPKcb", "clang::CodeGen::CodeGenModule::ErrorUnsupported(clang::Stmt const*, char const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16ErrorUnsupportedEPKNS_4DeclEPKcb", "clang::CodeGen::CodeGenModule::ErrorUnsupported(clang::Decl const*, char const*, bool)"),
	mu_demangle_test("_ZNK5clang7CodeGen13CodeGenModule19setGlobalVisibilityEPN4llvm11GlobalValueEPKNS_9NamedDeclE", "clang::CodeGen::CodeGenModule::setGlobalVisibility(llvm::GlobalValue*, clang::NamedDecl const*) const"),
	mu_demangle_test("_ZNK5clang7CodeGen13CodeGenModule17setTypeVisibilityEPN4llvm11GlobalValueEPKNS_13CXXRecordDeclENS1_18TypeVisibilityKindE", "clang::CodeGen::CodeGenModule::setTypeVisibility(llvm::GlobalValue*, clang::CXXRecordDecl const*, clang::CodeGen::CodeGenModule::TypeVisibilityKind) const"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule14getMangledNameENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::getMangledName(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19getBlockMangledNameENS0_10GlobalDeclERNS_12MangleBufferEPKNS_9BlockDeclE", "clang::CodeGen::CodeGenModule::getBlockMangledName(clang::CodeGen::GlobalDecl, clang::MangleBuffer&, clang::BlockDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule14GetGlobalValueEN4llvm9StringRefE", "clang::CodeGen::CodeGenModule::GetGlobalValue(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule13AddGlobalDtorEPN4llvm8FunctionEi", "clang::CodeGen::CodeGenModule::AddGlobalDtor(llvm::Function*, int)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule18getFunctionLinkageEPKNS_12FunctionDeclE", "clang::CodeGen::CodeGenModule::getFunctionLinkage(clang::FunctionDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule31SetFunctionDefinitionAttributesEPKNS_12FunctionDeclEPN4llvm11GlobalValueE", "clang::CodeGen::CodeGenModule::SetFunctionDefinitionAttributes(clang::FunctionDecl const*, llvm::GlobalValue*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19SetCommonAttributesEPKNS_4DeclEPN4llvm11GlobalValueE", "clang::CodeGen::CodeGenModule::SetCommonAttributes(clang::Decl const*, llvm::GlobalValue*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule25SetLLVMFunctionAttributesEPKNS_4DeclERKNS0_14CGFunctionInfoEPN4llvm8FunctionE", "clang::CodeGen::CodeGenModule::SetLLVMFunctionAttributes(clang::Decl const*, clang::CodeGen::CGFunctionInfo const&, llvm::Function*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule38SetLLVMFunctionAttributesForDefinitionEPKNS_4DeclEPN4llvm8FunctionE", "clang::CodeGen::CodeGenModule::SetLLVMFunctionAttributesForDefinition(clang::Decl const*, llvm::Function*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule13AddUsedGlobalEPN4llvm11GlobalValueE", "clang::CodeGen::CodeGenModule::AddUsedGlobal(llvm::GlobalValue*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule29SetInternalFunctionAttributesEPKNS_4DeclEPN4llvm8FunctionERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenModule::SetInternalFunctionAttributes(clang::Decl const*, llvm::Function*, clang::CodeGen::CGFunctionInfo const&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21SetFunctionAttributesENS0_10GlobalDeclEPN4llvm8FunctionEb", "clang::CodeGen::CodeGenModule::SetFunctionAttributes(clang::CodeGen::GlobalDecl, llvm::Function*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16getVTableLinkageEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenModule::getVTableLinkage(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule20EmitGlobalDefinitionENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitGlobalDefinition(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16EmitAnnotateAttrEPN4llvm11GlobalValueEPKNS_12AnnotateAttrEj", "clang::CodeGen::CodeGenModule::EmitAnnotateAttr(llvm::GlobalValue*, clang::AnnotateAttr const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule18MayDeferGenerationEPKNS_9ValueDeclE", "clang::CodeGen::CodeGenModule::MayDeferGeneration(clang::ValueDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19GetWeakRefReferenceEPKNS_9ValueDeclE", "clang::CodeGen::CodeGenModule::GetWeakRefReference(clang::ValueDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23GetOrCreateLLVMFunctionEN4llvm9StringRefEPKNS2_4TypeENS0_10GlobalDeclEb", "clang::CodeGen::CodeGenModule::GetOrCreateLLVMFunction(llvm::StringRef, llvm::Type const*, clang::CodeGen::GlobalDecl, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21GetOrCreateLLVMGlobalEN4llvm9StringRefEPKNS2_11PointerTypeEPKNS_7VarDeclEb", "clang::CodeGen::CodeGenModule::GetOrCreateLLVMGlobal(llvm::StringRef, llvm::PointerType const*, clang::VarDecl const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule10EmitGlobalENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitGlobal(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule19EmitAliasDefinitionENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitAliasDefinition(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule28EmitGlobalFunctionDefinitionENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitGlobalFunctionDefinition(clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23EmitGlobalVarDefinitionEPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::EmitGlobalVarDefinition(clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule17GetAddrOfFunctionENS0_10GlobalDeclEPKN4llvm4TypeEb", "clang::CodeGen::CodeGenModule::GetAddrOfFunction(clang::CodeGen::GlobalDecl, llvm::Type const*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21CreateRuntimeFunctionEPKN4llvm12FunctionTypeENS2_9StringRefE", "clang::CodeGen::CodeGenModule::CreateRuntimeFunction(llvm::FunctionType const*, llvm::StringRef)"),
	mu_demangle_test("_Z20DeclIsConstantGlobalRN5clang10ASTContextEPKNS_7VarDeclE", "DeclIsConstantGlobal(clang::ASTContext&, clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule33CreateOrReplaceCXXRuntimeVariableEN4llvm9StringRefEPKNS2_4TypeENS2_11GlobalValue12LinkageTypesE", "clang::CodeGen::CodeGenModule::CreateOrReplaceCXXRuntimeVariable(llvm::StringRef, llvm::Type const*, llvm::GlobalValue::LinkageTypes)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule18GetAddrOfGlobalVarEPKNS_7VarDeclEPKN4llvm4TypeE", "clang::CodeGen::CodeGenModule::GetAddrOfGlobalVar(clang::VarDecl const*, llvm::Type const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21CreateRuntimeVariableEPKN4llvm4TypeENS2_9StringRefE", "clang::CodeGen::CodeGenModule::CreateRuntimeVariable(llvm::Type const*, llvm::StringRef)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23EmitTentativeDefinitionEPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::EmitTentativeDefinition(clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule10EmitVTableEPNS_13CXXRecordDeclEb", "clang::CodeGen::CodeGenModule::EmitVTable(clang::CXXRecordDecl*, bool)"),
	mu_demangle_test("_ZNK5clang7CodeGen13CodeGenModule22GetTargetTypeStoreSizeEPKN4llvm4TypeE", "clang::CodeGen::CodeGenModule::GetTargetTypeStoreSize(llvm::Type const*) const"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule27GetLLVMLinkageVarDefinitionEPKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenModule::GetLLVMLinkageVarDefinition(clang::VarDecl const*, llvm::GlobalVariable*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21getBuiltinLibFunctionEPKNS_12FunctionDeclEj", "clang::CodeGen::CodeGenModule::getBuiltinLibFunction(clang::FunctionDecl const*, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule12getIntrinsicEjPPKN4llvm4TypeEj", "clang::CodeGen::CodeGenModule::getIntrinsic(unsigned int, llvm::Type const**, unsigned int)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule25GetAddrOfConstantCFStringEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantCFString(clang::StringLiteral const*)"),
	mu_demangle_test("_Z24GetConstantCFStringEntryRN4llvm9StringMapIPNS_8ConstantENS_15MallocAllocatorEEEPKN5clang13StringLiteralEbRbRj", "GetConstantCFStringEntry(llvm::StringMap<llvm::Constant*, llvm::MallocAllocator>&, clang::StringLiteral const*, bool, bool&, unsigned int&)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23GetAddrOfConstantStringEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantString(clang::StringLiteral const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule25GetStringForStringLiteralEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetStringForStringLiteral(clang::StringLiteral const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule34GetAddrOfConstantStringFromLiteralEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantStringFromLiteral(clang::StringLiteral const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23GetAddrOfConstantStringERKSsPKc", "clang::CodeGen::CodeGenModule::GetAddrOfConstantString(std::string const&, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule37GetAddrOfConstantStringFromObjCEncodeEPKNS_14ObjCEncodeExprE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantStringFromObjCEncode(clang::ObjCEncodeExpr const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule24GetAddrOfConstantCStringERKSsPKc", "clang::CodeGen::CodeGenModule::GetAddrOfConstantCString(std::string const&, char const*)"),
	mu_demangle_test("_Z21GenerateStringLiteralRKSsbRN5clang7CodeGen13CodeGenModuleEPKc", "GenerateStringLiteral(std::string const&, bool, clang::CodeGen::CodeGenModule&, char const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule31EmitObjCPropertyImplementationsEPKNS_22ObjCImplementationDeclE", "clang::CodeGen::CodeGenModule::EmitObjCPropertyImplementations(clang::ObjCImplementationDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule27EmitObjCIvarInitializationsEPNS_22ObjCImplementationDeclE", "clang::CodeGen::CodeGenModule::EmitObjCIvarInitializations(clang::ObjCImplementationDecl*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule13EmitNamespaceEPKNS_13NamespaceDeclE", "clang::CodeGen::CodeGenModule::EmitNamespace(clang::NamespaceDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule16EmitTopLevelDeclEPNS_4DeclE", "clang::CodeGen::CodeGenModule::EmitTopLevelDecl(clang::Decl*)"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule15EmitLinkageSpecEPKNS_15LinkageSpecDeclE", "clang::CodeGen::CodeGenModule::EmitLinkageSpec(clang::LinkageSpecDecl const*)"),
	mu_demangle_test("_Z22EmitGlobalDeclMetadataRN5clang7CodeGen13CodeGenModuleERPN4llvm11NamedMDNodeENS0_10GlobalDeclEPNS3_11GlobalValueE", "EmitGlobalDeclMetadata(clang::CodeGen::CodeGenModule&, llvm::NamedMDNode*&, clang::CodeGen::GlobalDecl, llvm::GlobalValue*)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction16EmitDeclMetadataEv", "clang::CodeGen::CodeGenFunction::EmitDeclMetadata()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule21getBlockObjectDisposeEv", "clang::CodeGen::CodeGenModule::getBlockObjectDispose()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule20getBlockObjectAssignEv", "clang::CodeGen::CodeGenModule::getBlockObjectAssign()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule24getNSConcreteGlobalBlockEv", "clang::CodeGen::CodeGenModule::getNSConcreteGlobalBlock()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule23getNSConcreteStackBlockEv", "clang::CodeGen::CodeGenModule::getNSConcreteStackBlock()"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_11SectionAttrEEEPT_v", "clang::SectionAttr* clang::Decl::getAttr<clang::SectionAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_9AliasAttrEEEPT_v", "clang::AliasAttr* clang::Decl::getAttr<clang::AliasAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_12AnnotateAttrEEEPT_v", "clang::AnnotateAttr* clang::Decl::getAttr<clang::AnnotateAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_12NoCommonAttrEEEPT_v", "clang::NoCommonAttr* clang::Decl::getAttr<clang::NoCommonAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_10CommonAttrEEEPT_v", "clang::CommonAttr* clang::Decl::getAttr<clang::CommonAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_15ConstructorAttrEEEPT_v", "clang::ConstructorAttr* clang::Decl::getAttr<clang::ConstructorAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_14DestructorAttrEEEPT_v", "clang::DestructorAttr* clang::Decl::getAttr<clang::DestructorAttr>() const"),
	mu_demangle_test("_ZN4llvm9StringMapIPNS_8ConstantENS_15MallocAllocatorEE16GetOrCreateValueIS2_EERNS_14StringMapEntryIS2_EENS_9StringRefET_", "llvm::StringMapEntry<llvm::Constant*>& llvm::StringMap<llvm::Constant*, llvm::MallocAllocator>::GetOrCreateValue<llvm::Constant*>(llvm::StringRef, llvm::Constant*)"),
	mu_demangle_test("_ZN4llvm9StringMapIN5clang7CodeGen10GlobalDeclENS_15MallocAllocatorEE16GetOrCreateValueIS3_EERNS_14StringMapEntryIS3_EENS_9StringRefET_", "llvm::StringMapEntry<clang::CodeGen::GlobalDecl>& llvm::StringMap<clang::CodeGen::GlobalDecl, llvm::MallocAllocator>::GetOrCreateValue<clang::CodeGen::GlobalDecl>(llvm::StringRef, clang::CodeGen::GlobalDecl)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunctionD2Ev", "clang::CodeGen::CodeGenFunction::~CodeGenFunction()"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTablesD2Ev", "clang::CodeGen::CodeGenVTables::~CodeGenVTables()"),
	mu_demangle_test("_ZN5clang7CodeGen14CodeGenVTablesC2ERNS0_13CodeGenModuleE", "clang::CodeGen::CodeGenVTables::CodeGenVTables(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAAC1ERNS_10ASTContextERN4llvm11LLVMContextERKNS_11LangOptionsERNS_13MangleContextE", "clang::CodeGen::CodeGenTBAA::CodeGenTBAA(clang::ASTContext&, llvm::LLVMContext&, clang::LangOptions const&, clang::MangleContext&)"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAAC2ERNS_10ASTContextERN4llvm11LLVMContextERKNS_11LangOptionsERNS_13MangleContextE", "clang::CodeGen::CodeGenTBAA::CodeGenTBAA(clang::ASTContext&, llvm::LLVMContext&, clang::LangOptions const&, clang::MangleContext&)"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAAD1Ev", "clang::CodeGen::CodeGenTBAA::~CodeGenTBAA()"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAAD2Ev", "clang::CodeGen::CodeGenTBAA::~CodeGenTBAA()"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAA7getRootEv", "clang::CodeGen::CodeGenTBAA::getRoot()"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAA23getTBAAInfoForNamedTypeEN4llvm9StringRefEPNS2_6MDNodeEb", "clang::CodeGen::CodeGenTBAA::getTBAAInfoForNamedType(llvm::StringRef, llvm::MDNode*, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAA7getCharEv", "clang::CodeGen::CodeGenTBAA::getChar()"),
	mu_demangle_test("_ZN5clang7CodeGen11CodeGenTBAA11getTBAAInfoENS_8QualTypeE", "clang::CodeGen::CodeGenTBAA::getTBAAInfo(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypesC1ERNS_10ASTContextERN4llvm6ModuleERKNS4_10DataLayoutERKNS_7ABIInfoERNS0_8CGCXXABIE", "clang::CodeGen::CodeGenTypes::CodeGenTypes(clang::ASTContext&, llvm::Module&, llvm::DataLayout const&, clang::ABIInfo const&, clang::CodeGen::CGCXXABI&)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypesC2ERNS_10ASTContextERN4llvm6ModuleERKNS4_10DataLayoutERKNS_7ABIInfoERNS0_8CGCXXABIE", "clang::CodeGen::CodeGenTypes::CodeGenTypes(clang::ASTContext&, llvm::Module&, llvm::DataLayout const&, clang::ABIInfo const&, clang::CodeGen::CGCXXABI&)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypesD1Ev", "clang::CodeGen::CodeGenTypes::~CodeGenTypes()"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypesD2Ev", "clang::CodeGen::CodeGenTypes::~CodeGenTypes()"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes26HandleLateResolvedPointersEv", "clang::CodeGen::CodeGenTypes::HandleLateResolvedPointers()"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes11ConvertTypeENS_8QualTypeEb", "clang::CodeGen::CodeGenTypes::ConvertType(clang::QualType, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes20ConvertTypeRecursiveENS_8QualTypeE", "clang::CodeGen::CodeGenTypes::ConvertTypeRecursive(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes14ConvertNewTypeENS_8QualTypeE", "clang::CodeGen::CodeGenTypes::ConvertNewType(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes17ConvertTypeForMemENS_8QualTypeEb", "clang::CodeGen::CodeGenTypes::ConvertTypeForMem(clang::QualType, bool)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes22VerifyFuncTypeCompleteEPKNS_4TypeE", "clang::CodeGen::CodeGenTypes::VerifyFuncTypeComplete(clang::Type const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes19UpdateCompletedTypeEPKNS_7TagDeclE", "clang::CodeGen::CodeGenTypes::UpdateCompletedType(clang::TagDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes18ConvertTagDeclTypeEPKNS_7TagDeclE", "clang::CodeGen::CodeGenTypes::ConvertTagDeclType(clang::TagDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes17getCGRecordLayoutEPKNS_10RecordDeclE", "clang::CodeGen::CodeGenTypes::getCGRecordLayout(clang::RecordDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes19isZeroInitializableENS_8QualTypeE", "clang::CodeGen::CodeGenTypes::isZeroInitializable(clang::QualType)"),
	mu_demangle_test("_ZN5clang7CodeGen12CodeGenTypes19isZeroInitializableEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenTypes::isZeroInitializable(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEED1Ev", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::~FoldingSet()"),
	mu_demangle_test("_ZN4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEED0Ev", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::~FoldingSet()"),
	mu_demangle_test("_ZNK4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEE14GetNodeProfileEPNS_14FoldingSetImpl4NodeERNS_16FoldingSetNodeIDE", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::GetNodeProfile(llvm::FoldingSetImpl::Node*, llvm::FoldingSetNodeID&) const"),
	mu_demangle_test("_ZNK4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEE10NodeEqualsEPNS_14FoldingSetImpl4NodeERKNS_16FoldingSetNodeIDERS8_", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::NodeEquals(llvm::FoldingSetImpl::Node*, llvm::FoldingSetNodeID const&, llvm::FoldingSetNodeID&) const"),
	mu_demangle_test("_ZNK4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEE15ComputeNodeHashEPNS_14FoldingSetImpl4NodeERNS_16FoldingSetNodeIDE", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::ComputeNodeHash(llvm::FoldingSetImpl::Node*, llvm::FoldingSetNodeID&) const"),
	mu_demangle_test("_ZN5clang7CodeGen14CGFunctionInfo7ProfileERN4llvm16FoldingSetNodeIDE", "clang::CodeGen::CGFunctionInfo::Profile(llvm::FoldingSetNodeID&)"),
	mu_demangle_test("_ZN5clang7CodeGen14CGRecordLayoutD2Ev", "clang::CodeGen::CGRecordLayout::~CGRecordLayout()"),
	mu_demangle_test("_ZN5clang7CodeGen19CreateItaniumCXXABIERNS0_13CodeGenModuleE", "clang::CodeGen::CreateItaniumCXXABI(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CreateARMCXXABIERNS0_13CodeGenModuleE", "clang::CodeGen::CreateARMCXXABI(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABID1Ev", "(anonymous namespace)::ARMCXXABI::~ARMCXXABI()"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABID0Ev", "(anonymous namespace)::ARMCXXABI::~ARMCXXABI()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI24ConvertMemberPointerTypeEPKN5clang17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::ConvertMemberPointerType(clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI31EmitLoadOfMemberFunctionPointerERN5clang7CodeGen15CodeGenFunctionERPN4llvm5ValueES7_PKNS1_17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitLoadOfMemberFunctionPointer(clang::CodeGen::CodeGenFunction&, llvm::Value*&, llvm::Value*, clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI28EmitMemberDataPointerAddressERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberDataPointerAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI27EmitMemberPointerConversionERN5clang7CodeGen15CodeGenFunctionEPKNS1_8CastExprEPN4llvm5ValueE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerConversion(clang::CodeGen::CodeGenFunction&, clang::CastExpr const*, llvm::Value*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI27EmitMemberPointerConversionEPN4llvm8ConstantEPKN5clang8CastExprE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerConversion(llvm::Constant*, clang::CastExpr const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI19isZeroInitializableEPKN5clang17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::isZeroInitializable(clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI21EmitNullMemberPointerEPKN5clang17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitNullMemberPointer(clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI17EmitMemberPointerEPKN5clang13CXXMethodDeclE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointer(clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI21EmitMemberDataPointerEPKN5clang17MemberPointerTypeENS1_9CharUnitsE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberDataPointer(clang::MemberPointerType const*, clang::CharUnits)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI27EmitMemberPointerComparisonERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_17MemberPointerTypeEb", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerComparison(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI26EmitMemberPointerIsNotNullERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEPKNS1_17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerIsNotNull(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::MemberPointerType const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABI27BuildInstanceFunctionParamsERN5clang7CodeGen15CodeGenFunctionERNS1_8QualTypeERN4llvm11SmallVectorISt4pairIPKNS1_7VarDeclES5_ELj16EEE", "(anonymous namespace)::ARMCXXABI::BuildInstanceFunctionParams(clang::CodeGen::CodeGenFunction&, clang::QualType&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABI26EmitInstanceFunctionPrologERN5clang7CodeGen15CodeGenFunctionE", "(anonymous namespace)::ARMCXXABI::EmitInstanceFunctionProlog(clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABI19EmitReturnFromThunkERN5clang7CodeGen15CodeGenFunctionENS2_6RValueENS1_8QualTypeE", "(anonymous namespace)::ARMCXXABI::EmitReturnFromThunk(clang::CodeGen::CodeGenFunction&, clang::CodeGen::RValue, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABI18GetArrayCookieSizeEPKN5clang10CXXNewExprE", "(anonymous namespace)::ARMCXXABI::GetArrayCookieSize(clang::CXXNewExpr const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABI21InitializeArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_10CXXNewExprENS1_8QualTypeE", "(anonymous namespace)::ARMCXXABI::InitializeArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::CXXNewExpr const*, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_19ARMCXXABI15ReadArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEPKNS1_13CXXDeleteExprENS1_8QualTypeERS7_SC_RNS1_9CharUnitsE", "(anonymous namespace)::ARMCXXABI::ReadArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::CXXDeleteExpr const*, clang::QualType, llvm::Value*&, llvm::Value*&, clang::CharUnits&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI15EmitGuardedInitERN5clang7CodeGen15CodeGenFunctionERKNS1_7VarDeclEPN4llvm14GlobalVariableE", "(anonymous namespace)::ItaniumCXXABI::EmitGuardedInit(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::GlobalVariable*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallGuardAbortD1Ev", "(anonymous namespace)::CallGuardAbort::~CallGuardAbort()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallGuardAbortD0Ev", "(anonymous namespace)::CallGuardAbort::~CallGuardAbort()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114CallGuardAbort4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallGuardAbort::Emit(clang::CodeGen::CodeGenFunction&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI26EmitInstanceFunctionPrologERN5clang7CodeGen15CodeGenFunctionE", "(anonymous namespace)::ItaniumCXXABI::EmitInstanceFunctionProlog(clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI27BuildInstanceFunctionParamsERN5clang7CodeGen15CodeGenFunctionERNS1_8QualTypeERN4llvm11SmallVectorISt4pairIPKNS1_7VarDeclES5_ELj16EEE", "(anonymous namespace)::ItaniumCXXABI::BuildInstanceFunctionParams(clang::CodeGen::CodeGenFunction&, clang::QualType&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABID1Ev", "(anonymous namespace)::ItaniumCXXABI::~ItaniumCXXABI()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABID0Ev", "(anonymous namespace)::ItaniumCXXABI::~ItaniumCXXABI()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI18GetArrayCookieSizeEPKN5clang10CXXNewExprE", "(anonymous namespace)::ItaniumCXXABI::GetArrayCookieSize(clang::CXXNewExpr const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI21InitializeArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_10CXXNewExprENS1_8QualTypeE", "(anonymous namespace)::ItaniumCXXABI::InitializeArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::CXXNewExpr const*, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ItaniumCXXABI15ReadArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEPKNS1_13CXXDeleteExprENS1_8QualTypeERS7_SC_RNS1_9CharUnitsE", "(anonymous namespace)::ItaniumCXXABI::ReadArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::CXXDeleteExpr const*, clang::QualType, llvm::Value*&, llvm::Value*&, clang::CharUnits&)"),
	mu_demangle_test("_ZN5clang7CodeGen15CodeGenFunction17GetAddrOfLocalVarEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::GetAddrOfLocalVar(clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang7CodeGen21CreateMicrosoftCXXABIERNS0_13CodeGenModuleE", "clang::CodeGen::CreateMicrosoftCXXABI(clang::CodeGen::CodeGenModule&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115MicrosoftCXXABID1Ev", "(anonymous namespace)::MicrosoftCXXABI::~MicrosoftCXXABI()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115MicrosoftCXXABID0Ev", "(anonymous namespace)::MicrosoftCXXABI::~MicrosoftCXXABI()"),
	mu_demangle_test("_ZN12_GLOBAL__N_115MicrosoftCXXABI27BuildInstanceFunctionParamsERN5clang7CodeGen15CodeGenFunctionERNS1_8QualTypeERN4llvm11SmallVectorISt4pairIPKNS1_7VarDeclES5_ELj16EEE", "(anonymous namespace)::MicrosoftCXXABI::BuildInstanceFunctionParams(clang::CodeGen::CodeGenFunction&, clang::QualType&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115MicrosoftCXXABI26EmitInstanceFunctionPrologERN5clang7CodeGen15CodeGenFunctionE", "(anonymous namespace)::MicrosoftCXXABI::EmitInstanceFunctionProlog(clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZN5clang17CreateLLVMCodeGenERNS_10DiagnosticERKSsRKNS_14CodeGenOptionsERN4llvm11LLVMContextE", "clang::CreateLLVMCodeGen(clang::Diagnostic&, std::string const&, clang::CodeGenOptions const&, llvm::LLVMContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImplD1Ev", "(anonymous namespace)::CodeGeneratorImpl::~CodeGeneratorImpl()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImplD0Ev", "(anonymous namespace)::CodeGeneratorImpl::~CodeGeneratorImpl()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl10InitializeERN5clang10ASTContextE", "(anonymous namespace)::CodeGeneratorImpl::Initialize(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::CodeGeneratorImpl::HandleTopLevelDecl(clang::DeclGroupRef)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::CodeGeneratorImpl::HandleTranslationUnit(clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl23HandleTagDeclDefinitionEPN5clang7TagDeclE", "(anonymous namespace)::CodeGeneratorImpl::HandleTagDeclDefinition(clang::TagDecl*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl27CompleteTentativeDefinitionEPN5clang7VarDeclE", "(anonymous namespace)::CodeGeneratorImpl::CompleteTentativeDefinition(clang::VarDecl*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl12HandleVTableEPN5clang13CXXRecordDeclEb", "(anonymous namespace)::CodeGeneratorImpl::HandleVTable(clang::CXXRecordDecl*, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl9GetModuleEv", "(anonymous namespace)::CodeGeneratorImpl::GetModule()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CodeGeneratorImpl13ReleaseModuleEv", "(anonymous namespace)::CodeGeneratorImpl::ReleaseModule()"),
	mu_demangle_test("_ZN5clang13CodeGeneratorD1Ev", "clang::CodeGenerator::~CodeGenerator()"),
	mu_demangle_test("_ZN5clang13CodeGeneratorD0Ev", "clang::CodeGenerator::~CodeGenerator()"),
	mu_demangle_test("_ZN5clang7ABIInfoD0Ev", "clang::ABIInfo::~ABIInfo()"),
	mu_demangle_test("_ZN5clang7ABIInfoD1Ev", "clang::ABIInfo::~ABIInfo()"),
	mu_demangle_test("_ZN5clang7ABIInfoD2Ev", "clang::ABIInfo::~ABIInfo()"),
	mu_demangle_test("_ZNK5clang7ABIInfo10getContextEv", "clang::ABIInfo::getContext() const"),
	mu_demangle_test("_ZNK5clang7ABIInfo12getVMContextEv", "clang::ABIInfo::getVMContext() const"),
	mu_demangle_test("_ZNK5clang7ABIInfo13getDataLayoutEv", "clang::ABIInfo::getDataLayout() const"),
	mu_demangle_test("_ZNK5clang10ABIArgInfo4dumpEv", "clang::ABIArgInfo::dump() const"),
	mu_demangle_test("_ZN5clang17TargetCodeGenInfoD0Ev", "clang::TargetCodeGenInfo::~TargetCodeGenInfo()"),
	mu_demangle_test("_ZN5clang17TargetCodeGenInfoD1Ev", "clang::TargetCodeGenInfo::~TargetCodeGenInfo()"),
	mu_demangle_test("_ZN5clang17TargetCodeGenInfoD2Ev", "clang::TargetCodeGenInfo::~TargetCodeGenInfo()"),
	mu_demangle_test("_ZN5clang7CodeGen13CodeGenModule20getTargetCodeGenInfoEv", "clang::CodeGen::CodeGenModule::getTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_123X86_64TargetCodeGenInfoD1Ev", "(anonymous namespace)::X86_64TargetCodeGenInfo::~X86_64TargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_123X86_64TargetCodeGenInfoD0Ev", "(anonymous namespace)::X86_64TargetCodeGenInfo::~X86_64TargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_123X86_64TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::X86_64TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_123X86_64TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::X86_64TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_113X86_64ABIInfoD1Ev", "(anonymous namespace)::X86_64ABIInfo::~X86_64ABIInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113X86_64ABIInfoD0Ev", "(anonymous namespace)::X86_64ABIInfo::~X86_64ABIInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::X86_64ABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::X86_64ABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo20classifyArgumentTypeEN5clang8QualTypeERjS3_", "(anonymous namespace)::X86_64ABIInfo::classifyArgumentType(clang::QualType, unsigned int&, unsigned int&) const"),
	mu_demangle_test("_Z19EmitVAArgFromMemoryPN4llvm5ValueEN5clang8QualTypeERNS2_7CodeGen15CodeGenFunctionE", "EmitVAArgFromMemory(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo8classifyEN5clang8QualTypeEyRNS0_5ClassES4_", "(anonymous namespace)::X86_64ABIInfo::classify(clang::QualType, uint64_t, (anonymous namespace)::X86_64ABIInfo::Class&, (anonymous namespace)::X86_64ABIInfo::Class&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo17getIndirectResultEN5clang8QualTypeE", "(anonymous namespace)::X86_64ABIInfo::getIndirectResult(clang::QualType) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo22GetINTEGERTypeAtOffsetEPKN4llvm4TypeEjN5clang8QualTypeEj", "(anonymous namespace)::X86_64ABIInfo::GetINTEGERTypeAtOffset(llvm::Type const*, unsigned int, clang::QualType, unsigned int) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo18GetSSETypeAtOffsetEPKN4llvm4TypeEjN5clang8QualTypeEj", "(anonymous namespace)::X86_64ABIInfo::GetSSETypeAtOffset(llvm::Type const*, unsigned int, clang::QualType, unsigned int) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_64ABIInfo19Get16ByteVectorTypeEN5clang8QualTypeE", "(anonymous namespace)::X86_64ABIInfo::Get16ByteVectorType(clang::QualType) const"),
	mu_demangle_test("_Z26GetX86_64ByValArgumentPairPKN4llvm4TypeES2_RKNS_10DataLayoutE", "GetX86_64ByValArgumentPair(llvm::Type const*, llvm::Type const*, llvm::DataLayout const&)"),
	mu_demangle_test("_Z21BitsContainNoUserDataN5clang8QualTypeEjjRNS_10ASTContextE", "BitsContainNoUserData(clang::QualType, unsigned int, unsigned int, clang::ASTContext&)"),
	mu_demangle_test("_Z21ContainsFloatAtOffsetPKN4llvm4TypeEjRKNS_10DataLayoutE", "ContainsFloatAtOffset(llvm::Type const*, unsigned int, llvm::DataLayout const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126WinX86_64TargetCodeGenInfoD1Ev", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::~WinX86_64TargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_126WinX86_64TargetCodeGenInfoD0Ev", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::~WinX86_64TargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_126WinX86_64TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_126WinX86_64TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_116WinX86_64ABIInfoD1Ev", "(anonymous namespace)::WinX86_64ABIInfo::~WinX86_64ABIInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_116WinX86_64ABIInfoD0Ev", "(anonymous namespace)::WinX86_64ABIInfo::~WinX86_64ABIInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_116WinX86_64ABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::WinX86_64ABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_116WinX86_64ABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::WinX86_64ABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_116WinX86_64ABIInfo8classifyEN5clang8QualTypeE", "(anonymous namespace)::WinX86_64ABIInfo::classify(clang::QualType) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_123X86_32TargetCodeGenInfoD1Ev", "(anonymous namespace)::X86_32TargetCodeGenInfo::~X86_32TargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_123X86_32TargetCodeGenInfoD0Ev", "(anonymous namespace)::X86_32TargetCodeGenInfo::~X86_32TargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_123X86_32TargetCodeGenInfo19SetTargetAttributesEPKN5clang4DeclEPN4llvm11GlobalValueERNS1_7CodeGen13CodeGenModuleE", "(anonymous namespace)::X86_32TargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_123X86_32TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::X86_32TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_123X86_32TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::X86_32TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_113X86_32ABIInfoD1Ev", "(anonymous namespace)::X86_32ABIInfo::~X86_32ABIInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113X86_32ABIInfoD0Ev", "(anonymous namespace)::X86_32ABIInfo::~X86_32ABIInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_32ABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::X86_32ABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113X86_32ABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::X86_32ABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"),
	mu_demangle_test("_Z25isRecordWithSSEVectorTypeRN5clang10ASTContextENS_8QualTypeE", "isRecordWithSSEVectorType(clang::ASTContext&, clang::QualType)"),
	mu_demangle_test("_Z21isSingleElementStructN5clang8QualTypeERNS_10ASTContextE", "isSingleElementStruct(clang::QualType, clang::ASTContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113X86_32ABIInfo26shouldReturnTypeInRegisterEN5clang8QualTypeERNS1_10ASTContextE", "(anonymous namespace)::X86_32ABIInfo::shouldReturnTypeInRegister(clang::QualType, clang::ASTContext&)"),
	mu_demangle_test("_Z12isEmptyFieldRN5clang10ASTContextEPKNS_9FieldDeclEb", "isEmptyField(clang::ASTContext&, clang::FieldDecl const*, bool)"),
	mu_demangle_test("_Z13isEmptyRecordRN5clang10ASTContextENS_8QualTypeEb", "isEmptyRecord(clang::ASTContext&, clang::QualType, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_123MSP430TargetCodeGenInfoD1Ev", "(anonymous namespace)::MSP430TargetCodeGenInfo::~MSP430TargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_123MSP430TargetCodeGenInfoD0Ev", "(anonymous namespace)::MSP430TargetCodeGenInfo::~MSP430TargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_123MSP430TargetCodeGenInfo19SetTargetAttributesEPKN5clang4DeclEPN4llvm11GlobalValueERNS1_7CodeGen13CodeGenModuleE", "(anonymous namespace)::MSP430TargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_114DefaultABIInfoD1Ev", "(anonymous namespace)::DefaultABIInfo::~DefaultABIInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114DefaultABIInfoD0Ev", "(anonymous namespace)::DefaultABIInfo::~DefaultABIInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114DefaultABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::DefaultABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114DefaultABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::DefaultABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_123MBlazeTargetCodeGenInfoD1Ev", "(anonymous namespace)::MBlazeTargetCodeGenInfo::~MBlazeTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_123MBlazeTargetCodeGenInfoD0Ev", "(anonymous namespace)::MBlazeTargetCodeGenInfo::~MBlazeTargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_123MBlazeTargetCodeGenInfo19SetTargetAttributesEPKN5clang4DeclEPN4llvm11GlobalValueERNS1_7CodeGen13CodeGenModuleE", "(anonymous namespace)::MBlazeTargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_113MBlazeABIInfoD1Ev", "(anonymous namespace)::MBlazeABIInfo::~MBlazeABIInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_113MBlazeABIInfoD0Ev", "(anonymous namespace)::MBlazeABIInfo::~MBlazeABIInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113MBlazeABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::MBlazeABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113MBlazeABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::MBlazeABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_124SystemZTargetCodeGenInfoD1Ev", "(anonymous namespace)::SystemZTargetCodeGenInfo::~SystemZTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124SystemZTargetCodeGenInfoD0Ev", "(anonymous namespace)::SystemZTargetCodeGenInfo::~SystemZTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114SystemZABIInfoD1Ev", "(anonymous namespace)::SystemZABIInfo::~SystemZABIInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_114SystemZABIInfoD0Ev", "(anonymous namespace)::SystemZABIInfo::~SystemZABIInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114SystemZABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::SystemZABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_114SystemZABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::SystemZABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_122PPC32TargetCodeGenInfoD1Ev", "(anonymous namespace)::PPC32TargetCodeGenInfo::~PPC32TargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122PPC32TargetCodeGenInfoD0Ev", "(anonymous namespace)::PPC32TargetCodeGenInfo::~PPC32TargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_122PPC32TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::PPC32TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_122PPC32TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::PPC32TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_124DefaultTargetCodeGenInfoD1Ev", "(anonymous namespace)::DefaultTargetCodeGenInfo::~DefaultTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_124DefaultTargetCodeGenInfoD0Ev", "(anonymous namespace)::DefaultTargetCodeGenInfo::~DefaultTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_120ARMTargetCodeGenInfoD1Ev", "(anonymous namespace)::ARMTargetCodeGenInfo::~ARMTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_120ARMTargetCodeGenInfoD0Ev", "(anonymous namespace)::ARMTargetCodeGenInfo::~ARMTargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_120ARMTargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::ARMTargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ARMABIInfoD1Ev", "(anonymous namespace)::ARMABIInfo::~ARMABIInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_110ARMABIInfoD0Ev", "(anonymous namespace)::ARMABIInfo::~ARMABIInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_110ARMABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::ARMABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_110ARMABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::ARMABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"),
	mu_demangle_test("_Z17isIntegerLikeTypeN5clang8QualTypeERNS_10ASTContextERN4llvm11LLVMContextE", "isIntegerLikeType(clang::QualType, clang::ASTContext&, llvm::LLVMContext&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_121MIPSTargetCodeGenInfoD1Ev", "(anonymous namespace)::MIPSTargetCodeGenInfo::~MIPSTargetCodeGenInfo()"),
	mu_demangle_test("_ZN12_GLOBAL__N_121MIPSTargetCodeGenInfoD0Ev", "(anonymous namespace)::MIPSTargetCodeGenInfo::~MIPSTargetCodeGenInfo()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_121MIPSTargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::MIPSTargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_121MIPSTargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::MIPSTargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZNK5clang17TargetCodeGenInfo19SetTargetAttributesEPKNS_4DeclEPN4llvm11GlobalValueERNS_7CodeGen13CodeGenModuleE", "clang::TargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK5clang17TargetCodeGenInfo21extendPointerWithSExtEv", "clang::TargetCodeGenInfo::extendPointerWithSExt() const"),
	mu_demangle_test("_ZNK5clang17TargetCodeGenInfo22getDwarfEHStackPointerERNS_7CodeGen13CodeGenModuleE", "clang::TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"),
	mu_demangle_test("_ZNK5clang17TargetCodeGenInfo23initDwarfEHRegSizeTableERNS_7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "clang::TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZNK5clang17TargetCodeGenInfo19decodeReturnAddressERNS_7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "clang::TargetCodeGenInfo::decodeReturnAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZNK5clang17TargetCodeGenInfo19encodeReturnAddressERNS_7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "clang::TargetCodeGenInfo::encodeReturnAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_19MSP430InterruptAttrEEEPT_v", "clang::MSP430InterruptAttr* clang::Decl::getAttr<clang::MSP430InterruptAttr>() const"),
	mu_demangle_test("_ZN5clang8ParseASTERNS_12PreprocessorEPNS_11ASTConsumerERNS_10ASTContextEbbPNS_20CodeCompleteConsumerE", "clang::ParseAST(clang::Preprocessor&, clang::ASTConsumer*, clang::ASTContext&, bool, bool, clang::CodeCompleteConsumer*)"),
	mu_demangle_test("_ZN5clang8ParseASTERNS_4SemaEb", "clang::ParseAST(clang::Sema&, bool)"),
	mu_demangle_test("_ZN5clang6Parser23ParseCXXInlineMethodDefENS_15AccessSpecifierERNS_10DeclaratorERKNS0_18ParsedTemplateInfoERKNS_14VirtSpecifiersE", "clang::Parser::ParseCXXInlineMethodDef(clang::AccessSpecifier, clang::Declarator&, clang::Parser::ParsedTemplateInfo const&, clang::VirtSpecifiers const&)"),
	mu_demangle_test("_ZN5clang6Parser21LateParsedDeclarationD0Ev", "clang::Parser::LateParsedDeclaration::~LateParsedDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser21LateParsedDeclarationD1Ev", "clang::Parser::LateParsedDeclaration::~LateParsedDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser21LateParsedDeclarationD2Ev", "clang::Parser::LateParsedDeclaration::~LateParsedDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser21LateParsedDeclaration28ParseLexedMethodDeclarationsEv", "clang::Parser::LateParsedDeclaration::ParseLexedMethodDeclarations()"),
	mu_demangle_test("_ZN5clang6Parser21LateParsedDeclaration20ParseLexedMethodDefsEv", "clang::Parser::LateParsedDeclaration::ParseLexedMethodDefs()"),
	mu_demangle_test("_ZN5clang6Parser15LateParsedClassC1EPS0_PNS0_12ParsingClassE", "clang::Parser::LateParsedClass::LateParsedClass(clang::Parser*, clang::Parser::ParsingClass*)"),
	mu_demangle_test("_ZN5clang6Parser15LateParsedClassC2EPS0_PNS0_12ParsingClassE", "clang::Parser::LateParsedClass::LateParsedClass(clang::Parser*, clang::Parser::ParsingClass*)"),
	mu_demangle_test("_ZN5clang6Parser15LateParsedClassD0Ev", "clang::Parser::LateParsedClass::~LateParsedClass()"),
	mu_demangle_test("_ZN5clang6Parser15LateParsedClassD1Ev", "clang::Parser::LateParsedClass::~LateParsedClass()"),
	mu_demangle_test("_ZN5clang6Parser15LateParsedClassD2Ev", "clang::Parser::LateParsedClass::~LateParsedClass()"),
	mu_demangle_test("_ZN5clang6Parser15LateParsedClass28ParseLexedMethodDeclarationsEv", "clang::Parser::LateParsedClass::ParseLexedMethodDeclarations()"),
	mu_demangle_test("_ZN5clang6Parser28ParseLexedMethodDeclarationsERNS0_12ParsingClassE", "clang::Parser::ParseLexedMethodDeclarations(clang::Parser::ParsingClass&)"),
	mu_demangle_test("_ZN5clang6Parser15LateParsedClass20ParseLexedMethodDefsEv", "clang::Parser::LateParsedClass::ParseLexedMethodDefs()"),
	mu_demangle_test("_ZN5clang6Parser20ParseLexedMethodDefsERNS0_12ParsingClassE", "clang::Parser::ParseLexedMethodDefs(clang::Parser::ParsingClass&)"),
	mu_demangle_test("_ZN5clang6Parser27LateParsedMethodDeclaration28ParseLexedMethodDeclarationsEv", "clang::Parser::LateParsedMethodDeclaration::ParseLexedMethodDeclarations()"),
	mu_demangle_test("_ZN5clang6Parser27ParseLexedMethodDeclarationERNS0_27LateParsedMethodDeclarationE", "clang::Parser::ParseLexedMethodDeclaration(clang::Parser::LateParsedMethodDeclaration&)"),
	mu_demangle_test("_ZN5clang6Parser11LexedMethod20ParseLexedMethodDefsEv", "clang::Parser::LexedMethod::ParseLexedMethodDefs()"),
	mu_demangle_test("_ZN5clang6Parser19ParseLexedMethodDefERNS0_11LexedMethodE", "clang::Parser::ParseLexedMethodDef(clang::Parser::LexedMethod&)"),
	mu_demangle_test("_ZN5clang6Parser20ConsumeAndStoreUntilENS_3tok9TokenKindES2_RN4llvm11SmallVectorINS_5TokenELj4EEEbb", "clang::Parser::ConsumeAndStoreUntil(clang::tok::TokenKind, clang::tok::TokenKind, llvm::SmallVector<clang::Token, 4u>&, bool, bool)"),
	mu_demangle_test("_ZN5clang6Parser11LexedMethodD1Ev", "clang::Parser::LexedMethod::~LexedMethod()"),
	mu_demangle_test("_ZN5clang6Parser11LexedMethodD0Ev", "clang::Parser::LexedMethod::~LexedMethod()"),
	mu_demangle_test("_ZN5clang6Parser27LateParsedMethodDeclarationD1Ev", "clang::Parser::LateParsedMethodDeclaration::~LateParsedMethodDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser27LateParsedMethodDeclarationD0Ev", "clang::Parser::LateParsedMethodDeclaration::~LateParsedMethodDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser13ParseTypeNameEPNS_11SourceRangeENS_10Declarator10TheContextE", "clang::Parser::ParseTypeName(clang::SourceRange*, clang::Declarator::TheContext)"),
	mu_demangle_test("_ZN5clang6Parser27ParseSpecifierQualifierListERNS_8DeclSpecE", "clang::Parser::ParseSpecifierQualifierList(clang::DeclSpec&)"),
	mu_demangle_test("_ZN5clang6Parser15ParseDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseDeclarator(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser18ParseGNUAttributesERNS_16ParsedAttributesEPNS_14SourceLocationE", "clang::Parser::ParseGNUAttributes(clang::ParsedAttributes&, clang::SourceLocation*)"),
	mu_demangle_test("_ZN5clang6Parser22isDeclarationSpecifierEb", "clang::Parser::isDeclarationSpecifier(bool)"),
	mu_demangle_test("_ZN5clang6Parser22ParseMicrosoftDeclSpecERNS_16ParsedAttributesE", "clang::Parser::ParseMicrosoftDeclSpec(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser28ParseMicrosoftTypeAttributesERNS_16ParsedAttributesE", "clang::Parser::ParseMicrosoftTypeAttributes(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser26ParseBorlandTypeAttributesERNS_16ParsedAttributesE", "clang::Parser::ParseBorlandTypeAttributes(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser28DiagnoseProhibitedAttributesERNS0_25ParsedAttributesWithRangeE", "clang::Parser::DiagnoseProhibitedAttributes(clang::Parser::ParsedAttributesWithRange&)"),
	mu_demangle_test("_ZN5clang6Parser16ParseDeclarationERNS_15ASTOwningVectorIPNS_4StmtELj32EEEjRNS_14SourceLocationERNS0_25ParsedAttributesWithRangeE", "clang::Parser::ParseDeclaration(clang::ASTOwningVector<clang::Stmt*, 32u>&, unsigned int, clang::SourceLocation&, clang::Parser::ParsedAttributesWithRange&)"),
	mu_demangle_test("_ZN5clang6Parser22ParseSimpleDeclarationERNS_15ASTOwningVectorIPNS_4StmtELj32EEEjRNS_14SourceLocationERNS_16ParsedAttributesEb", "clang::Parser::ParseSimpleDeclaration(clang::ASTOwningVector<clang::Stmt*, 32u>&, unsigned int, clang::SourceLocation&, clang::ParsedAttributes&, bool)"),
	mu_demangle_test("_ZN5clang6Parser26ParseDeclarationSpecifiersERNS_8DeclSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierENS0_15DeclSpecContextE", "clang::Parser::ParseDeclarationSpecifiers(clang::DeclSpec&, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier, clang::Parser::DeclSpecContext)"),
	mu_demangle_test("_ZN5clang6Parser39getDeclSpecContextFromDeclaratorContextEj", "clang::Parser::getDeclSpecContextFromDeclaratorContext(unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser14ParseDeclGroupERNS0_15ParsingDeclSpecEjbPNS_14SourceLocationE", "clang::Parser::ParseDeclGroup(clang::Parser::ParsingDeclSpec&, unsigned int, bool, clang::SourceLocation*)"),
	mu_demangle_test("_ZN5clang6Parser31ParseDeclarationAfterDeclaratorERNS_10DeclaratorERKNS0_18ParsedTemplateInfoE", "clang::Parser::ParseDeclarationAfterDeclarator(clang::Declarator&, clang::Parser::ParsedTemplateInfo const&)"),
	mu_demangle_test("_ZN5clang6Parser16ParseImplicitIntERNS_8DeclSpecEPNS_12CXXScopeSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierE", "clang::Parser::ParseImplicitInt(clang::DeclSpec&, clang::CXXScopeSpec*, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang6Parser18ParseEnumSpecifierENS_14SourceLocationERNS_8DeclSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierE", "clang::Parser::ParseEnumSpecifier(clang::SourceLocation, clang::DeclSpec&, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang6Parser23isConstructorDeclaratorEv", "clang::Parser::isConstructorDeclarator()"),
	mu_demangle_test("_ZN5clang6Parser20ParseTypeofSpecifierERNS_8DeclSpecE", "clang::Parser::ParseTypeofSpecifier(clang::DeclSpec&)"),
	mu_demangle_test("_ZN5clang6Parser26ParseOptionalTypeSpecifierERNS_8DeclSpecERbRPKcRjRKNS0_18ParsedTemplateInfoEb", "clang::Parser::ParseOptionalTypeSpecifier(clang::DeclSpec&, bool&, char const*&, unsigned int&, clang::Parser::ParsedTemplateInfo const&, bool)"),
	mu_demangle_test("_ZN5clang6Parser22ParseStructDeclarationERNS_8DeclSpecERNS0_13FieldCallbackE", "clang::Parser::ParseStructDeclaration(clang::DeclSpec&, clang::Parser::FieldCallback&)"),
	mu_demangle_test("_ZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclE", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)"),
	mu_demangle_test("_ZZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclEEN14CFieldCallbackD1Ev", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)::CFieldCallback::~CFieldCallback()"),
	mu_demangle_test("_ZN5clang6Parser13ParseEnumBodyENS_14SourceLocationEPNS_4DeclE", "clang::Parser::ParseEnumBody(clang::SourceLocation, clang::Decl*)"),
	mu_demangle_test("_ZNK5clang6Parser15isTypeQualifierEv", "clang::Parser::isTypeQualifier() const"),
	mu_demangle_test("_ZNK5clang6Parser24isKnownToBeTypeSpecifierERKNS_5TokenE", "clang::Parser::isKnownToBeTypeSpecifier(clang::Token const&) const"),
	mu_demangle_test("_ZN5clang6Parser24isTypeSpecifierQualifierEv", "clang::Parser::isTypeSpecifierQualifier()"),
	mu_demangle_test("_ZN5clang6Parser25ParseTypeQualifierListOptERNS_8DeclSpecEbb", "clang::Parser::ParseTypeQualifierListOpt(clang::DeclSpec&, bool, bool)"),
	mu_demangle_test("_ZN5clang6Parser23ParseDeclaratorInternalERNS_10DeclaratorEMS0_FvS2_E", "clang::Parser::ParseDeclaratorInternal(clang::Declarator&, void (clang::Parser::*)(clang::Declarator&))"),
	mu_demangle_test("_ZN5clang6Parser21ParseDirectDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseDirectDeclarator(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser20ParseParenDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseParenDeclarator(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser23ParseFunctionDeclaratorENS_14SourceLocationERNS_10DeclaratorERNS_16ParsedAttributesEb", "clang::Parser::ParseFunctionDeclarator(clang::SourceLocation, clang::Declarator&, clang::ParsedAttributes&, bool)"),
	mu_demangle_test("_ZN5clang6Parser22ParseBracketDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseBracketDeclarator(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser37ParseFunctionDeclaratorIdentifierListENS_14SourceLocationEPNS_14IdentifierInfoES1_RNS_10DeclaratorE", "clang::Parser::ParseFunctionDeclaratorIdentifierList(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser30TryAltiVecVectorTokenOutOfLineEv", "clang::Parser::TryAltiVecVectorTokenOutOfLine()"),
	mu_demangle_test("_ZN5clang6Parser24TryAltiVecTokenOutOfLineERNS_8DeclSpecENS_14SourceLocationERPKcRjRb", "clang::Parser::TryAltiVecTokenOutOfLine(clang::DeclSpec&, clang::SourceLocation, char const*&, unsigned int&, bool&)"),
	mu_demangle_test("_ZZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclEEN14CFieldCallback6invokeERNS_15FieldDeclaratorE", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)::CFieldCallback::invoke(clang::FieldDeclarator&)"),
	mu_demangle_test("_ZZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclEEN14CFieldCallbackD0Ev", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)::CFieldCallback::~CFieldCallback()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPN5clang4DeclEE6insertIPS3_EES6_S6_T_S7_", "clang::Decl** llvm::SmallVectorImpl<clang::Decl*>::insert<clang::Decl**>(clang::Decl**, clang::Decl**, clang::Decl**)"),
	mu_demangle_test("_ZN5clang6Parser14ParseNamespaceEjRNS_14SourceLocationES1_", "clang::Parser::ParseNamespace(unsigned int, clang::SourceLocation&, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser19ParseNamespaceAliasENS_14SourceLocationES1_PNS_14IdentifierInfoERS1_", "clang::Parser::ParseNamespaceAlias(clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser12ParseLinkageERNS0_15ParsingDeclSpecEj", "clang::Parser::ParseLinkage(clang::Parser::ParsingDeclSpec&, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser32ParseUsingDirectiveOrDeclarationEjRKNS0_18ParsedTemplateInfoERNS_14SourceLocationERNS0_25ParsedAttributesWithRangeE", "clang::Parser::ParseUsingDirectiveOrDeclaration(unsigned int, clang::Parser::ParsedTemplateInfo const&, clang::SourceLocation&, clang::Parser::ParsedAttributesWithRange&)"),
	mu_demangle_test("_ZN5clang6Parser19ParseUsingDirectiveEjNS_14SourceLocationERS1_RNS_16ParsedAttributesE", "clang::Parser::ParseUsingDirective(unsigned int, clang::SourceLocation, clang::SourceLocation&, clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser21ParseUsingDeclarationEjRKNS0_18ParsedTemplateInfoENS_14SourceLocationERS4_NS_15AccessSpecifierE", "clang::Parser::ParseUsingDeclaration(unsigned int, clang::Parser::ParsedTemplateInfo const&, clang::SourceLocation, clang::SourceLocation&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang6Parser28ParseStaticAssertDeclarationERNS_14SourceLocationE", "clang::Parser::ParseStaticAssertDeclaration(clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser22ParseDecltypeSpecifierERNS_8DeclSpecE", "clang::Parser::ParseDecltypeSpecifier(clang::DeclSpec&)"),
	mu_demangle_test("_ZN5clang6Parser14ParseClassNameERNS_14SourceLocationEPNS_12CXXScopeSpecE", "clang::Parser::ParseClassName(clang::SourceLocation&, clang::CXXScopeSpec*)"),
	mu_demangle_test("_ZN5clang6Parser19ParseClassSpecifierENS_3tok9TokenKindENS_14SourceLocationERNS_8DeclSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierEb", "clang::Parser::ParseClassSpecifier(clang::tok::TokenKind, clang::SourceLocation, clang::DeclSpec&, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier, bool)"),
	mu_demangle_test("_ZNK5clang6Parser25isCXX0XClassVirtSpecifierEv", "clang::Parser::isCXX0XClassVirtSpecifier() const"),
	mu_demangle_test("_ZN5clang6Parser27ParseCXXMemberSpecificationENS_14SourceLocationEjPNS_4DeclE", "clang::Parser::ParseCXXMemberSpecification(clang::SourceLocation, unsigned int, clang::Decl*)"),
	mu_demangle_test("_ZN5clang6Parser15ParseBaseClauseEPNS_4DeclE", "clang::Parser::ParseBaseClause(clang::Decl*)"),
	mu_demangle_test("_ZN5clang6Parser18ParseBaseSpecifierEPNS_4DeclE", "clang::Parser::ParseBaseSpecifier(clang::Decl*)"),
	mu_demangle_test("_ZNK5clang6Parser27getAccessSpecifierIfPresentEv", "clang::Parser::getAccessSpecifierIfPresent() const"),
	mu_demangle_test("_ZN5clang6Parser31HandleMemberFunctionDefaultArgsERNS_10DeclaratorEPNS_4DeclE", "clang::Parser::HandleMemberFunctionDefaultArgs(clang::Declarator&, clang::Decl*)"),
	mu_demangle_test("_ZNK5clang6Parser20isCXX0XVirtSpecifierEv", "clang::Parser::isCXX0XVirtSpecifier() const"),
	mu_demangle_test("_ZN5clang6Parser34ParseOptionalCXX0XVirtSpecifierSeqERNS_14VirtSpecifiersE", "clang::Parser::ParseOptionalCXX0XVirtSpecifierSeq(clang::VirtSpecifiers&)"),
	mu_demangle_test("_ZN5clang6Parser39ParseOptionalCXX0XClassVirtSpecifierSeqERNS_19ClassVirtSpecifiersE", "clang::Parser::ParseOptionalCXX0XClassVirtSpecifierSeq(clang::ClassVirtSpecifiers&)"),
	mu_demangle_test("_ZN5clang6Parser30ParseCXXClassMemberDeclarationENS_15AccessSpecifierERKNS0_18ParsedTemplateInfoEPNS0_21ParsingDeclRAIIObjectE", "clang::Parser::ParseCXXClassMemberDeclaration(clang::AccessSpecifier, clang::Parser::ParsedTemplateInfo const&, clang::Parser::ParsingDeclRAIIObject*)"),
	mu_demangle_test("_ZN5clang6Parser27ParseConstructorInitializerEPNS_4DeclE", "clang::Parser::ParseConstructorInitializer(clang::Decl*)"),
	mu_demangle_test("_ZN5clang6Parser19ParseMemInitializerEPNS_4DeclE", "clang::Parser::ParseMemInitializer(clang::Decl*)"),
	mu_demangle_test("_ZN5clang6Parser23ParseTrailingReturnTypeEv", "clang::Parser::ParseTrailingReturnType()"),
	mu_demangle_test("_ZN5clang6Parser16PushParsingClassEPNS_4DeclEb", "clang::Parser::PushParsingClass(clang::Decl*, bool)"),
	mu_demangle_test("_ZN5clang6Parser23DeallocateParsedClassesEPNS0_12ParsingClassE", "clang::Parser::DeallocateParsedClasses(clang::Parser::ParsingClass*)"),
	mu_demangle_test("_ZN5clang6Parser15PopParsingClassEv", "clang::Parser::PopParsingClass()"),
	mu_demangle_test("_ZN5clang6Parser20ParseCXX0XAttributesERNS0_25ParsedAttributesWithRangeEPNS_14SourceLocationE", "clang::Parser::ParseCXX0XAttributes(clang::Parser::ParsedAttributesWithRange&, clang::SourceLocation*)"),
	mu_demangle_test("_ZN5clang6Parser23ParseCXX0XAlignArgumentENS_14SourceLocationE", "clang::Parser::ParseCXX0XAlignArgument(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser24ParseMicrosoftAttributesERNS_16ParsedAttributesEPNS_14SourceLocationE", "clang::Parser::ParseMicrosoftAttributes(clang::ParsedAttributes&, clang::SourceLocation*)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang6Parser25LateParsedDefaultArgumentELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Parser::LateParsedDefaultArgument, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang6Parser15ParseExpressionEv", "clang::Parser::ParseExpression()"),
	mu_demangle_test("_ZN5clang6Parser25ParseAssignmentExpressionEv", "clang::Parser::ParseAssignmentExpression()"),
	mu_demangle_test("_ZN5clang6Parser26ParseRHSOfBinaryExpressionENS_12ActionResultIPNS_4ExprELb1EEENS_4prec5LevelE", "clang::Parser::ParseRHSOfBinaryExpression(clang::ActionResult<clang::Expr*, true>, clang::prec::Level)"),
	mu_demangle_test("_ZN5clang6Parser28ParseExpressionWithLeadingAtENS_14SourceLocationE", "clang::Parser::ParseExpressionWithLeadingAt(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser35ParseExpressionWithLeadingExtensionENS_14SourceLocationE", "clang::Parser::ParseExpressionWithLeadingExtension(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser19ParseCastExpressionEbbNS_9OpaquePtrINS_8QualTypeEEE", "clang::Parser::ParseCastExpression(bool, bool, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZN5clang6Parser43ParseAssignmentExprWithObjCMessageExprStartENS_14SourceLocationES1_NS_9OpaquePtrINS_8QualTypeEEEPNS_4ExprE", "clang::Parser::ParseAssignmentExprWithObjCMessageExprStart(clang::SourceLocation, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::Expr*)"),
	mu_demangle_test("_ZN5clang6Parser28ParsePostfixExpressionSuffixENS_12ActionResultIPNS_4ExprELb1EEE", "clang::Parser::ParsePostfixExpressionSuffix(clang::ActionResult<clang::Expr*, true>)"),
	mu_demangle_test("_ZN5clang6Parser23ParseConstantExpressionEv", "clang::Parser::ParseConstantExpression()"),
	mu_demangle_test("_ZN5clang6Parser19ParseCastExpressionEbbRbNS_9OpaquePtrINS_8QualTypeEEE", "clang::Parser::ParseCastExpression(bool, bool, bool&, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZN5clang6Parser20ParseParenExpressionERNS0_16ParenParseOptionEbNS_9OpaquePtrINS_8QualTypeEEERS5_RNS_14SourceLocationE", "clang::Parser::ParseParenExpression(clang::Parser::ParenParseOption&, bool, clang::OpaquePtr<clang::QualType>, clang::OpaquePtr<clang::QualType>&, clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser28ParseStringLiteralExpressionEv", "clang::Parser::ParseStringLiteralExpression()"),
	mu_demangle_test("_ZN5clang6Parser29ParseBuiltinPrimaryExpressionEv", "clang::Parser::ParseBuiltinPrimaryExpression()"),
	mu_demangle_test("_ZN5clang6Parser28ParseSizeofAlignofExpressionEv", "clang::Parser::ParseSizeofAlignofExpression()"),
	mu_demangle_test("_ZN5clang6Parser27ParseBlockLiteralExpressionEv", "clang::Parser::ParseBlockLiteralExpression()"),
	mu_demangle_test("_ZN5clang6Parser19ParseExpressionListERN4llvm15SmallVectorImplIPNS_4ExprEEERNS2_INS_14SourceLocationEEEMNS_4SemaEFvPNS_5ScopeES4_PS4_jES4_", "clang::Parser::ParseExpressionList(llvm::SmallVectorImpl<clang::Expr*>&, llvm::SmallVectorImpl<clang::SourceLocation>&, void (clang::Sema::*)(clang::Scope*, clang::Expr*, clang::Expr**, unsigned int), clang::Expr*)"),
	mu_demangle_test("_ZN5clang6Parser33ParseExprAfterTypeofSizeofAlignofERKNS_5TokenERbRNS_9OpaquePtrINS_8QualTypeEEERNS_11SourceRangeE", "clang::Parser::ParseExprAfterTypeofSizeofAlignof(clang::Token const&, bool&, clang::OpaquePtr<clang::QualType>&, clang::SourceRange&)"),
	mu_demangle_test("_ZN5clang6Parser30ParseCompoundLiteralExpressionENS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationES4_", "clang::Parser::ParseCompoundLiteralExpression(clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser12ParseBlockIdEv", "clang::Parser::ParseBlockId()"),
	mu_demangle_test("_ZN5clang6Parser30ParseOptionalCXXScopeSpecifierERNS_12CXXScopeSpecENS_9OpaquePtrINS_8QualTypeEEEbPb", "clang::Parser::ParseOptionalCXXScopeSpecifier(clang::CXXScopeSpec&, clang::OpaquePtr<clang::QualType>, bool, bool*)"),
	mu_demangle_test("_ZN5clang6Parser26ParseUnqualifiedIdOperatorERNS_12CXXScopeSpecEbNS_9OpaquePtrINS_8QualTypeEEERNS_13UnqualifiedIdE", "clang::Parser::ParseUnqualifiedIdOperator(clang::CXXScopeSpec&, bool, clang::OpaquePtr<clang::QualType>, clang::UnqualifiedId&)"),
	mu_demangle_test("_ZN5clang6Parser20ParseCXXIdExpressionEb", "clang::Parser::ParseCXXIdExpression(bool)"),
	mu_demangle_test("_ZN5clang6Parser18ParseUnqualifiedIdERNS_12CXXScopeSpecEbbbNS_9OpaquePtrINS_8QualTypeEEERNS_13UnqualifiedIdE", "clang::Parser::ParseUnqualifiedId(clang::CXXScopeSpec&, bool, bool, bool, clang::OpaquePtr<clang::QualType>, clang::UnqualifiedId&)"),
	mu_demangle_test("_ZN5clang6Parser13ParseCXXCastsEv", "clang::Parser::ParseCXXCasts()"),
	mu_demangle_test("_ZN5clang6Parser14ParseCXXTypeidEv", "clang::Parser::ParseCXXTypeid()"),
	mu_demangle_test("_ZN5clang6Parser14ParseCXXUuidofEv", "clang::Parser::ParseCXXUuidof()"),
	mu_demangle_test("_ZN5clang6Parser24ParseCXXPseudoDestructorEPNS_4ExprENS_14SourceLocationENS_3tok9TokenKindERNS_12CXXScopeSpecENS_9OpaquePtrINS_8QualTypeEEE", "clang::Parser::ParseCXXPseudoDestructor(clang::Expr*, clang::SourceLocation, clang::tok::TokenKind, clang::CXXScopeSpec&, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZN5clang6Parser28ParseUnqualifiedIdTemplateIdERNS_12CXXScopeSpecEPNS_14IdentifierInfoENS_14SourceLocationEbNS_9OpaquePtrINS_8QualTypeEEERNS_13UnqualifiedIdEbS5_", "clang::Parser::ParseUnqualifiedIdTemplateId(clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::SourceLocation, bool, clang::OpaquePtr<clang::QualType>, clang::UnqualifiedId&, bool, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser19ParseCXXBoolLiteralEv", "clang::Parser::ParseCXXBoolLiteral()"),
	mu_demangle_test("_ZN5clang6Parser20ParseThrowExpressionEv", "clang::Parser::ParseThrowExpression()"),
	mu_demangle_test("_ZN5clang6Parser12ParseCXXThisEv", "clang::Parser::ParseCXXThis()"),
	mu_demangle_test("_ZN5clang6Parser31ParseCXXTypeConstructExpressionERKNS_8DeclSpecE", "clang::Parser::ParseCXXTypeConstructExpression(clang::DeclSpec const&)"),
	mu_demangle_test("_ZN5clang6Parser17ParseCXXConditionERNS_12ActionResultIPNS_4ExprELb1EEERPNS_4DeclENS_14SourceLocationEb", "clang::Parser::ParseCXXCondition(clang::ActionResult<clang::Expr*, true>&, clang::Decl*&, clang::SourceLocation, bool)"),
	mu_demangle_test("_ZNK5clang6Parser24isCXXSimpleTypeSpecifierEv", "clang::Parser::isCXXSimpleTypeSpecifier() const"),
	mu_demangle_test("_ZN5clang6Parser27ParseCXXSimpleTypeSpecifierERNS_8DeclSpecE", "clang::Parser::ParseCXXSimpleTypeSpecifier(clang::DeclSpec&)"),
	mu_demangle_test("_ZN5clang6Parser24ParseCXXTypeSpecifierSeqERNS_8DeclSpecE", "clang::Parser::ParseCXXTypeSpecifierSeq(clang::DeclSpec&)"),
	mu_demangle_test("_ZN5clang6Parser21ParseCXXNewExpressionEbNS_14SourceLocationE", "clang::Parser::ParseCXXNewExpression(bool, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser27ParseExpressionListOrTypeIdERN4llvm15SmallVectorImplIPNS_4ExprEEERNS_10DeclaratorE", "clang::Parser::ParseExpressionListOrTypeId(llvm::SmallVectorImpl<clang::Expr*>&, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser24ParseDirectNewDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseDirectNewDeclarator(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser24ParseCXXDeleteExpressionEbNS_14SourceLocationE", "clang::Parser::ParseCXXDeleteExpression(bool, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser19ParseUnaryTypeTraitEv", "clang::Parser::ParseUnaryTypeTrait()"),
	mu_demangle_test("_ZN5clang6Parser20ParseBinaryTypeTraitEv", "clang::Parser::ParseBinaryTypeTrait()"),
	mu_demangle_test("_ZN5clang6Parser32ParseCXXAmbiguousParenExpressionERNS0_16ParenParseOptionERNS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationERS7_", "clang::Parser::ParseCXXAmbiguousParenExpression(clang::Parser::ParenParseOption&, clang::OpaquePtr<clang::QualType>&, clang::SourceLocation, clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser39ParseInitializerWithPotentialDesignatorEv", "clang::Parser::ParseInitializerWithPotentialDesignator()"),
	mu_demangle_test("_ZN5clang6Parser21ParseBraceInitializerEv", "clang::Parser::ParseBraceInitializer()"),
	mu_demangle_test("_ZN5clang6Parser21ParseObjCAtDirectivesEv", "clang::Parser::ParseObjCAtDirectives()"),
	mu_demangle_test("_ZN5clang6Parser27ParseObjCAtClassDeclarationENS_14SourceLocationE", "clang::Parser::ParseObjCAtClassDeclaration(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser31ParseObjCAtInterfaceDeclarationENS_14SourceLocationERNS_16ParsedAttributesE", "clang::Parser::ParseObjCAtInterfaceDeclaration(clang::SourceLocation, clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser30ParseObjCAtProtocolDeclarationENS_14SourceLocationERNS_16ParsedAttributesE", "clang::Parser::ParseObjCAtProtocolDeclaration(clang::SourceLocation, clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser36ParseObjCAtImplementationDeclarationENS_14SourceLocationE", "clang::Parser::ParseObjCAtImplementationDeclaration(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser25ParseObjCAtEndDeclarationENS_11SourceRangeE", "clang::Parser::ParseObjCAtEndDeclaration(clang::SourceRange)"),
	mu_demangle_test("_ZN5clang6Parser27ParseObjCAtAliasDeclarationENS_14SourceLocationE", "clang::Parser::ParseObjCAtAliasDeclaration(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser27ParseObjCPropertySynthesizeENS_14SourceLocationE", "clang::Parser::ParseObjCPropertySynthesize(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser24ParseObjCPropertyDynamicENS_14SourceLocationE", "clang::Parser::ParseObjCPropertyDynamic(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser27ParseObjCProtocolReferencesERN4llvm15SmallVectorImplIPNS_4DeclEEERNS2_INS_14SourceLocationEEEbRS7_SA_", "clang::Parser::ParseObjCProtocolReferences(llvm::SmallVectorImpl<clang::Decl*>&, llvm::SmallVectorImpl<clang::SourceLocation>&, bool, clang::SourceLocation&, clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationE", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser26ParseObjCInterfaceDeclListEPNS_4DeclENS_3tok15ObjCKeywordKindE", "clang::Parser::ParseObjCInterfaceDeclList(clang::Decl*, clang::tok::ObjCKeywordKind)"),
	mu_demangle_test("_ZN5clang6Parser24ParseObjCMethodPrototypeEPNS_4DeclENS_3tok15ObjCKeywordKindE", "clang::Parser::ParseObjCMethodPrototype(clang::Decl*, clang::tok::ObjCKeywordKind)"),
	mu_demangle_test("_ZN5clang6Parser19ParseObjCMethodDeclENS_14SourceLocationENS_3tok9TokenKindEPNS_4DeclENS2_15ObjCKeywordKindE", "clang::Parser::ParseObjCMethodDecl(clang::SourceLocation, clang::tok::TokenKind, clang::Decl*, clang::tok::ObjCKeywordKind)"),
	mu_demangle_test("_ZN5clang6Parser26ParseObjCPropertyAttributeERNS_12ObjCDeclSpecEPNS_4DeclE", "clang::Parser::ParseObjCPropertyAttribute(clang::ObjCDeclSpec&, clang::Decl*)"),
	mu_demangle_test("_ZN5clang6Parser22ParseObjCSelectorPieceERNS_14SourceLocationE", "clang::Parser::ParseObjCSelectorPiece(clang::SourceLocation&)"),
	mu_demangle_test("_ZNK5clang6Parser18isTokIdentifier_inEv", "clang::Parser::isTokIdentifier_in() const"),
	mu_demangle_test("_ZN5clang6Parser26ParseObjCTypeQualifierListERNS_12ObjCDeclSpecEb", "clang::Parser::ParseObjCTypeQualifierList(clang::ObjCDeclSpec&, bool)"),
	mu_demangle_test("_ZN5clang6Parser17ParseObjCTypeNameERNS_12ObjCDeclSpecEb", "clang::Parser::ParseObjCTypeName(clang::ObjCDeclSpec&, bool)"),
	mu_demangle_test("_ZN5clang6Parser27ParseObjCProtocolQualifiersERNS_8DeclSpecE", "clang::Parser::ParseObjCProtocolQualifiers(clang::DeclSpec&)"),
	mu_demangle_test("_ZZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationEEN16ObjCIvarCallbackD1Ev", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)::ObjCIvarCallback::~ObjCIvarCallback()"),
	mu_demangle_test("_ZN5clang6Parser24FinishPendingObjCActionsEv", "clang::Parser::FinishPendingObjCActions()"),
	mu_demangle_test("_ZN5clang6Parser18ParseObjCThrowStmtENS_14SourceLocationE", "clang::Parser::ParseObjCThrowStmt(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser25ParseObjCSynchronizedStmtENS_14SourceLocationE", "clang::Parser::ParseObjCSynchronizedStmt(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser16ParseObjCTryStmtENS_14SourceLocationE", "clang::Parser::ParseObjCTryStmt(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser25ParseObjCMethodDefinitionEv", "clang::Parser::ParseObjCMethodDefinition()"),
	mu_demangle_test("_ZN5clang6Parser20ParseObjCAtStatementENS_14SourceLocationE", "clang::Parser::ParseObjCAtStatement(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser21ParseObjCAtExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCAtExpression(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser22ParseObjCStringLiteralENS_14SourceLocationE", "clang::Parser::ParseObjCStringLiteral(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser25ParseObjCEncodeExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCEncodeExpression(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser27ParseObjCProtocolExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCProtocolExpression(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser27ParseObjCSelectorExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCSelectorExpression(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser26ParseObjCXXMessageReceiverERbRPv", "clang::Parser::ParseObjCXXMessageReceiver(bool&, void*&)"),
	mu_demangle_test("_ZN5clang6Parser29isSimpleObjCMessageExpressionEv", "clang::Parser::isSimpleObjCMessageExpression()"),
	mu_demangle_test("_ZN5clang6Parser43isStartOfObjCClassMessageMissingOpenBracketEv", "clang::Parser::isStartOfObjCClassMessageMissingOpenBracket()"),
	mu_demangle_test("_ZN5clang6Parser26ParseObjCMessageExpressionEv", "clang::Parser::ParseObjCMessageExpression()"),
	mu_demangle_test("_ZN5clang6Parser30ParseObjCMessageExpressionBodyENS_14SourceLocationES1_NS_9OpaquePtrINS_8QualTypeEEEPNS_4ExprE", "clang::Parser::ParseObjCMessageExpressionBody(clang::SourceLocation, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::Expr*)"),
	mu_demangle_test("_ZZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationEEN16ObjCIvarCallback6invokeERNS_15FieldDeclaratorE", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)::ObjCIvarCallback::invoke(clang::FieldDeclarator&)"),
	mu_demangle_test("_ZZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationEEN16ObjCIvarCallbackD0Ev", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)::ObjCIvarCallback::~ObjCIvarCallback()"),
	mu_demangle_test("_ZN5clang6Parser20ObjCPropertyCallbackD1Ev", "clang::Parser::ObjCPropertyCallback::~ObjCPropertyCallback()"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang15DeclaratorChunk9ParamInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::DeclaratorChunk::ParamInfo, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang4Sema11ObjCArgInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Sema::ObjCArgInfo, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang6Parser20ObjCPropertyCallback6invokeERNS_15FieldDeclaratorE", "clang::Parser::ObjCPropertyCallback::invoke(clang::FieldDeclarator&)"),
	mu_demangle_test("_ZN5clang6Parser20ObjCPropertyCallbackD0Ev", "clang::Parser::ObjCPropertyCallback::~ObjCPropertyCallback()"),
	mu_demangle_test("_ZN5clang6Parser18HandlePragmaUnusedEv", "clang::Parser::HandlePragmaUnused()"),
	mu_demangle_test("_ZN5clang26PragmaGCCVisibilityHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaGCCVisibilityHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"),
	mu_demangle_test("_ZN5clang17PragmaPackHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaPackHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"),
	mu_demangle_test("_ZN5clang18PragmaAlignHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaAlignHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"),
	mu_demangle_test("_Z16ParseAlignPragmaRN5clang4SemaERNS_12PreprocessorERNS_5TokenEb", "ParseAlignPragma(clang::Sema&, clang::Preprocessor&, clang::Token&, bool)"),
	mu_demangle_test("_ZN5clang20PragmaOptionsHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaOptionsHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"),
	mu_demangle_test("_ZN5clang19PragmaUnusedHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaUnusedHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"),
	mu_demangle_test("_ZN5clang17PragmaWeakHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaWeakHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"),
	mu_demangle_test("_ZN5clang18PragmaAlignHandlerD1Ev", "clang::PragmaAlignHandler::~PragmaAlignHandler()"),
	mu_demangle_test("_ZN5clang18PragmaAlignHandlerD0Ev", "clang::PragmaAlignHandler::~PragmaAlignHandler()"),
	mu_demangle_test("_ZN5clang26PragmaGCCVisibilityHandlerD1Ev", "clang::PragmaGCCVisibilityHandler::~PragmaGCCVisibilityHandler()"),
	mu_demangle_test("_ZN5clang26PragmaGCCVisibilityHandlerD0Ev", "clang::PragmaGCCVisibilityHandler::~PragmaGCCVisibilityHandler()"),
	mu_demangle_test("_ZN5clang20PragmaOptionsHandlerD1Ev", "clang::PragmaOptionsHandler::~PragmaOptionsHandler()"),
	mu_demangle_test("_ZN5clang20PragmaOptionsHandlerD0Ev", "clang::PragmaOptionsHandler::~PragmaOptionsHandler()"),
	mu_demangle_test("_ZN5clang17PragmaPackHandlerD1Ev", "clang::PragmaPackHandler::~PragmaPackHandler()"),
	mu_demangle_test("_ZN5clang17PragmaPackHandlerD0Ev", "clang::PragmaPackHandler::~PragmaPackHandler()"),
	mu_demangle_test("_ZN5clang19PragmaUnusedHandlerD1Ev", "clang::PragmaUnusedHandler::~PragmaUnusedHandler()"),
	mu_demangle_test("_ZN5clang19PragmaUnusedHandlerD0Ev", "clang::PragmaUnusedHandler::~PragmaUnusedHandler()"),
	mu_demangle_test("_ZN5clang17PragmaWeakHandlerD1Ev", "clang::PragmaWeakHandler::~PragmaWeakHandler()"),
	mu_demangle_test("_ZN5clang17PragmaWeakHandlerD0Ev", "clang::PragmaWeakHandler::~PragmaWeakHandler()"),
	mu_demangle_test("_ZN5clang6Parser27ParseStatementOrDeclarationERNS_15ASTOwningVectorIPNS_4StmtELj32EEEb", "clang::Parser::ParseStatementOrDeclaration(clang::ASTOwningVector<clang::Stmt*, 32u>&, bool)"),
	mu_demangle_test("_ZN5clang6Parser21ParseLabeledStatementERNS_16ParsedAttributesE", "clang::Parser::ParseLabeledStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser18ParseCaseStatementERNS_16ParsedAttributesE", "clang::Parser::ParseCaseStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser21ParseDefaultStatementERNS_16ParsedAttributesE", "clang::Parser::ParseDefaultStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser22ParseCompoundStatementERNS_16ParsedAttributesEb", "clang::Parser::ParseCompoundStatement(clang::ParsedAttributes&, bool)"),
	mu_demangle_test("_ZN5clang6Parser16ParseIfStatementERNS_16ParsedAttributesE", "clang::Parser::ParseIfStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser20ParseSwitchStatementERNS_16ParsedAttributesE", "clang::Parser::ParseSwitchStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser19ParseWhileStatementERNS_16ParsedAttributesE", "clang::Parser::ParseWhileStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser16ParseDoStatementERNS_16ParsedAttributesE", "clang::Parser::ParseDoStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser17ParseForStatementERNS_16ParsedAttributesE", "clang::Parser::ParseForStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser18ParseGotoStatementERNS_16ParsedAttributesE", "clang::Parser::ParseGotoStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser22ParseContinueStatementERNS_16ParsedAttributesE", "clang::Parser::ParseContinueStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser19ParseBreakStatementERNS_16ParsedAttributesE", "clang::Parser::ParseBreakStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser20ParseReturnStatementERNS_16ParsedAttributesE", "clang::Parser::ParseReturnStatement(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser17ParseAsmStatementERb", "clang::Parser::ParseAsmStatement(bool&)"),
	mu_demangle_test("_ZN5clang6Parser16ParseCXXTryBlockERNS_16ParsedAttributesE", "clang::Parser::ParseCXXTryBlock(clang::ParsedAttributes&)"),
	mu_demangle_test("_ZN5clang6Parser26ParseCompoundStatementBodyEb", "clang::Parser::ParseCompoundStatementBody(bool)"),
	mu_demangle_test("_ZN5clang6Parser25ParseParenExprOrConditionERNS_12ActionResultIPNS_4ExprELb1EEERPNS_4DeclENS_14SourceLocationEb", "clang::Parser::ParseParenExprOrCondition(clang::ActionResult<clang::Expr*, true>&, clang::Decl*&, clang::SourceLocation, bool)"),
	mu_demangle_test("_ZN5clang6Parser31FuzzyParseMicrosoftAsmStatementENS_14SourceLocationE", "clang::Parser::FuzzyParseMicrosoftAsmStatement(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser19ParseAsmOperandsOptERN4llvm15SmallVectorImplIPNS_14IdentifierInfoEEERNS2_IPNS_4ExprEEESA_", "clang::Parser::ParseAsmOperandsOpt(llvm::SmallVectorImpl<clang::IdentifierInfo*>&, llvm::SmallVectorImpl<clang::Expr*>&, llvm::SmallVectorImpl<clang::Expr*>&)"),
	mu_demangle_test("_ZN5clang6Parser26ParseFunctionStatementBodyEPNS_4DeclE", "clang::Parser::ParseFunctionStatementBody(clang::Decl*)"),
	mu_demangle_test("_ZN5clang6Parser40trySkippingFunctionBodyForCodeCompletionEv", "clang::Parser::trySkippingFunctionBodyForCodeCompletion()"),
	mu_demangle_test("_ZN5clang6Parser21ParseFunctionTryBlockEPNS_4DeclE", "clang::Parser::ParseFunctionTryBlock(clang::Decl*)"),
	mu_demangle_test("_ZN5clang6Parser22ParseCXXTryBlockCommonENS_14SourceLocationE", "clang::Parser::ParseCXXTryBlockCommon(clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser18ParseCXXCatchBlockEv", "clang::Parser::ParseCXXCatchBlock()"),
	mu_demangle_test("_ZN5clang6Parser36ParseDeclarationStartingWithTemplateEjRNS_14SourceLocationENS_15AccessSpecifierE", "clang::Parser::ParseDeclarationStartingWithTemplate(unsigned int, clang::SourceLocation&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang6Parser26ParseExplicitInstantiationENS_14SourceLocationES1_RS1_", "clang::Parser::ParseExplicitInstantiation(clang::SourceLocation, clang::SourceLocation, clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser40ParseTemplateDeclarationOrSpecializationEjRNS_14SourceLocationENS_15AccessSpecifierE", "clang::Parser::ParseTemplateDeclarationOrSpecialization(unsigned int, clang::SourceLocation&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang6Parser23ParseTemplateParametersEjRN4llvm15SmallVectorImplIPNS_4DeclEEERNS_14SourceLocationES8_", "clang::Parser::ParseTemplateParameters(unsigned int, llvm::SmallVectorImpl<clang::Decl*>&, clang::SourceLocation&, clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser35ParseSingleDeclarationAfterTemplateEjRKNS0_18ParsedTemplateInfoERNS0_21ParsingDeclRAIIObjectERNS_14SourceLocationENS_15AccessSpecifierE", "clang::Parser::ParseSingleDeclarationAfterTemplate(unsigned int, clang::Parser::ParsedTemplateInfo const&, clang::Parser::ParsingDeclRAIIObject&, clang::SourceLocation&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang6Parser26ParseTemplateParameterListEjRN4llvm15SmallVectorImplIPNS_4DeclEEE", "clang::Parser::ParseTemplateParameterList(unsigned int, llvm::SmallVectorImpl<clang::Decl*>&)"),
	mu_demangle_test("_ZN5clang6Parser22ParseTemplateParameterEjj", "clang::Parser::ParseTemplateParameter(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser30isStartOfTemplateTypeParameterEv", "clang::Parser::isStartOfTemplateTypeParameter()"),
	mu_demangle_test("_ZN5clang6Parser18ParseTypeParameterEjj", "clang::Parser::ParseTypeParameter(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser30ParseTemplateTemplateParameterEjj", "clang::Parser::ParseTemplateTemplateParameter(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser29ParseNonTypeTemplateParameterEjj", "clang::Parser::ParseNonTypeTemplateParameter(unsigned int, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser29ParseTemplateTemplateArgumentEv", "clang::Parser::ParseTemplateTemplateArgument()"),
	mu_demangle_test("_ZN5clang6Parser32ParseTemplateIdAfterTemplateNameENS_9OpaquePtrINS_12TemplateNameEEENS_14SourceLocationEPKNS_12CXXScopeSpecEbRS4_RN4llvm11SmallVectorINS_22ParsedTemplateArgumentELj16EEES8_", "clang::Parser::ParseTemplateIdAfterTemplateName(clang::OpaquePtr<clang::TemplateName>, clang::SourceLocation, clang::CXXScopeSpec const*, bool, clang::SourceLocation&, llvm::SmallVector<clang::ParsedTemplateArgument, 16u>&, clang::SourceLocation&)"),
	mu_demangle_test("_ZN5clang6Parser25ParseTemplateArgumentListERN4llvm11SmallVectorINS_22ParsedTemplateArgumentELj16EEE", "clang::Parser::ParseTemplateArgumentList(llvm::SmallVector<clang::ParsedTemplateArgument, 16u>&)"),
	mu_demangle_test("_ZN5clang6Parser23AnnotateTemplateIdTokenENS_9OpaquePtrINS_12TemplateNameEEENS_16TemplateNameKindEPKNS_12CXXScopeSpecERNS_13UnqualifiedIdENS_14SourceLocationEb", "clang::Parser::AnnotateTemplateIdToken(clang::OpaquePtr<clang::TemplateName>, clang::TemplateNameKind, clang::CXXScopeSpec const*, clang::UnqualifiedId&, clang::SourceLocation, bool)"),
	mu_demangle_test("_ZN5clang6Parser29AnnotateTemplateIdTokenAsTypeEPKNS_12CXXScopeSpecE", "clang::Parser::AnnotateTemplateIdTokenAsType(clang::CXXScopeSpec const*)"),
	mu_demangle_test("_ZN5clang6Parser21ParseTemplateArgumentEv", "clang::Parser::ParseTemplateArgument()"),
	mu_demangle_test("_ZN5clang6Parser22IsTemplateArgumentListEj", "clang::Parser::IsTemplateArgumentList(unsigned int)"),
	mu_demangle_test("_ZNK5clang6Parser18ParsedTemplateInfo14getSourceRangeEv", "clang::Parser::ParsedTemplateInfo::getSourceRange() const"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang22ParsedTemplateArgumentELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ParsedTemplateArgument, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang6Parser25isCXXDeclarationStatementEv", "clang::Parser::isCXXDeclarationStatement()"),
	mu_demangle_test("_ZN5clang6Parser22isCXXSimpleDeclarationEv", "clang::Parser::isCXXSimpleDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser25isCXXDeclarationSpecifierEv", "clang::Parser::isCXXDeclarationSpecifier()"),
	mu_demangle_test("_ZN5clang6Parser25TryParseSimpleDeclarationEv", "clang::Parser::TryParseSimpleDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser23TryParseTypeofSpecifierEv", "clang::Parser::TryParseTypeofSpecifier()"),
	mu_demangle_test("_ZN5clang6Parser26TryParseProtocolQualifiersEv", "clang::Parser::TryParseProtocolQualifiers()"),
	mu_demangle_test("_ZN5clang6Parser26TryParseInitDeclaratorListEv", "clang::Parser::TryParseInitDeclaratorList()"),
	mu_demangle_test("_ZN5clang6Parser18TryParseDeclaratorEbb", "clang::Parser::TryParseDeclarator(bool, bool)"),
	mu_demangle_test("_ZN5clang6Parser25isCXXConditionDeclarationEv", "clang::Parser::isCXXConditionDeclaration()"),
	mu_demangle_test("_ZN5clang6Parser11isCXXTypeIdENS0_25TentativeCXXTypeIdContextERb", "clang::Parser::isCXXTypeId(clang::Parser::TentativeCXXTypeIdContext, bool&)"),
	mu_demangle_test("_ZN5clang6Parser25isCXX0XAttributeSpecifierEbPNS_3tok9TokenKindE", "clang::Parser::isCXX0XAttributeSpecifier(bool, clang::tok::TokenKind*)"),
	mu_demangle_test("_ZN5clang6Parser26TryParseFunctionDeclaratorEv", "clang::Parser::TryParseFunctionDeclarator()"),
	mu_demangle_test("_ZN5clang6Parser23isCXXFunctionDeclaratorEb", "clang::Parser::isCXXFunctionDeclarator(bool)"),
	mu_demangle_test("_ZN5clang6Parser25TryParseBracketDeclaratorEv", "clang::Parser::TryParseBracketDeclarator()"),
	mu_demangle_test("_ZN5clang6Parser33isExpressionOrTypeSpecifierSimpleENS_3tok9TokenKindE", "clang::Parser::isExpressionOrTypeSpecifierSimple(clang::tok::TokenKind)"),
	mu_demangle_test("_ZN5clang6Parser28TryParseDeclarationSpecifierEv", "clang::Parser::TryParseDeclarationSpecifier()"),
	mu_demangle_test("_ZN5clang6Parser34TryParseParameterDeclarationClauseEv", "clang::Parser::TryParseParameterDeclarationClause()"),
	mu_demangle_test("_ZN5clang6ParserC1ERNS_12PreprocessorERNS_4SemaE", "clang::Parser::Parser(clang::Preprocessor&, clang::Sema&)"),
	mu_demangle_test("_ZN5clang6ParserC2ERNS_12PreprocessorERNS_4SemaE", "clang::Parser::Parser(clang::Preprocessor&, clang::Sema&)"),
	mu_demangle_test("_ZNK5clang27PrettyStackTraceParserEntry5printERN4llvm11raw_ostreamE", "clang::PrettyStackTraceParserEntry::print(llvm::raw_ostream&) const"),
	mu_demangle_test("_ZN5clang6Parser4DiagENS_14SourceLocationEj", "clang::Parser::Diag(clang::SourceLocation, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser4DiagERKNS_5TokenEj", "clang::Parser::Diag(clang::Token const&, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser18SuggestParenthesesENS_14SourceLocationEjNS_11SourceRangeE", "clang::Parser::SuggestParentheses(clang::SourceLocation, unsigned int, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang6Parser19MatchRHSPunctuationENS_3tok9TokenKindENS_14SourceLocationE", "clang::Parser::MatchRHSPunctuation(clang::tok::TokenKind, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang6Parser16ExpectAndConsumeENS_3tok9TokenKindEjPKcS2_", "clang::Parser::ExpectAndConsume(clang::tok::TokenKind, unsigned int, char const*, clang::tok::TokenKind)"),
	mu_demangle_test("_ZN5clang6Parser20ExpectAndConsumeSemiEj", "clang::Parser::ExpectAndConsumeSemi(unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser9SkipUntilEPKNS_3tok9TokenKindEjbbb", "clang::Parser::SkipUntil(clang::tok::TokenKind const*, unsigned int, bool, bool, bool)"),
	mu_demangle_test("_ZN5clang6Parser10EnterScopeEj", "clang::Parser::EnterScope(unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser9ExitScopeEv", "clang::Parser::ExitScope()"),
	mu_demangle_test("_ZN5clang6ParserD0Ev", "clang::Parser::~Parser()"),
	mu_demangle_test("_ZN5clang6ParserD1Ev", "clang::Parser::~Parser()"),
	mu_demangle_test("_ZN5clang6ParserD2Ev", "clang::Parser::~Parser()"),
	mu_demangle_test("_ZN5clang6Parser10InitializeEv", "clang::Parser::Initialize()"),
	mu_demangle_test("_ZN5clang6Parser17ParseTopLevelDeclERNS_9OpaquePtrINS_12DeclGroupRefEEE", "clang::Parser::ParseTopLevelDecl(clang::OpaquePtr<clang::DeclGroupRef>&)"),
	mu_demangle_test("_ZN5clang6Parser24ParseExternalDeclarationERNS0_25ParsedAttributesWithRangeEPNS0_15ParsingDeclSpecE", "clang::Parser::ParseExternalDeclaration(clang::Parser::ParsedAttributesWithRange&, clang::Parser::ParsingDeclSpec*)"),
	mu_demangle_test("_ZN5clang6Parser20ParseTranslationUnitEv", "clang::Parser::ParseTranslationUnit()"),
	mu_demangle_test("_ZN5clang6Parser14ParseSimpleAsmEPNS_14SourceLocationE", "clang::Parser::ParseSimpleAsm(clang::SourceLocation*)"),
	mu_demangle_test("_ZN5clang6Parser36ParseDeclarationOrFunctionDefinitionERNS0_15ParsingDeclSpecENS_15AccessSpecifierE", "clang::Parser::ParseDeclarationOrFunctionDefinition(clang::Parser::ParsingDeclSpec&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang6Parser36ParseDeclarationOrFunctionDefinitionERNS_16ParsedAttributesENS_15AccessSpecifierE", "clang::Parser::ParseDeclarationOrFunctionDefinition(clang::ParsedAttributes&, clang::AccessSpecifier)"),
	mu_demangle_test("_ZNK5clang6Parser28isDeclarationAfterDeclaratorEv", "clang::Parser::isDeclarationAfterDeclarator() const"),
	mu_demangle_test("_ZN5clang6Parser27isStartOfFunctionDefinitionERKNS0_17ParsingDeclaratorE", "clang::Parser::isStartOfFunctionDefinition(clang::Parser::ParsingDeclarator const&)"),
	mu_demangle_test("_ZN5clang6Parser23ParseFunctionDefinitionERNS0_17ParsingDeclaratorERKNS0_18ParsedTemplateInfoE", "clang::Parser::ParseFunctionDefinition(clang::Parser::ParsingDeclarator&, clang::Parser::ParsedTemplateInfo const&)"),
	mu_demangle_test("_ZN5clang6Parser25ParseKNRParamDeclarationsERNS_10DeclaratorE", "clang::Parser::ParseKNRParamDeclarations(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang6Parser21ParseAsmStringLiteralEv", "clang::Parser::ParseAsmStringLiteral()"),
	mu_demangle_test("_ZN5clang6Parser27TryAnnotateTypeOrScopeTokenEb", "clang::Parser::TryAnnotateTypeOrScopeToken(bool)"),
	mu_demangle_test("_ZN5clang6Parser24TryAnnotateCXXScopeTokenEb", "clang::Parser::TryAnnotateCXXScopeToken(bool)"),
	mu_demangle_test("_ZN5clang6Parser32isTokenEqualOrMistypedEqualEqualEj", "clang::Parser::isTokenEqualOrMistypedEqualEqual(unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser22CodeCompletionRecoveryEv", "clang::Parser::CodeCompletionRecovery()"),
	mu_demangle_test("_ZN5clang6Parser13FieldCallback7_anchorEv", "clang::Parser::FieldCallback::_anchor()"),
	mu_demangle_test("_ZN5clang6Parser21CodeCompleteDirectiveEb", "clang::Parser::CodeCompleteDirective(bool)"),
	mu_demangle_test("_ZN5clang6Parser34CodeCompleteInConditionalExclusionEv", "clang::Parser::CodeCompleteInConditionalExclusion()"),
	mu_demangle_test("_ZN5clang6Parser21CodeCompleteMacroNameEb", "clang::Parser::CodeCompleteMacroName(bool)"),
	mu_demangle_test("_ZN5clang6Parser34CodeCompletePreprocessorExpressionEv", "clang::Parser::CodeCompletePreprocessorExpression()"),
	mu_demangle_test("_ZN5clang6Parser25CodeCompleteMacroArgumentEPNS_14IdentifierInfoEPNS_9MacroInfoEj", "clang::Parser::CodeCompleteMacroArgument(clang::IdentifierInfo*, clang::MacroInfo*, unsigned int)"),
	mu_demangle_test("_ZN5clang6Parser27CodeCompleteNaturalLanguageEv", "clang::Parser::CodeCompleteNaturalLanguage()"),
	mu_demangle_test("_ZN5clang6Parser15ConsumeAnyTokenEv", "clang::Parser::ConsumeAnyToken()"),
	mu_demangle_test("_ZN5clang5Scope4InitEPS0_j", "clang::Scope::Init(clang::Scope*, unsigned int)"),
	mu_demangle_test("_ZN5clang27PrettyStackTraceParserEntryD1Ev", "clang::PrettyStackTraceParserEntry::~PrettyStackTraceParserEntry()"),
	mu_demangle_test("_ZN5clang27PrettyStackTraceParserEntryD0Ev", "clang::PrettyStackTraceParserEntry::~PrettyStackTraceParserEntry()"),
	mu_demangle_test("_ZN5clang6Parser13FieldCallbackD1Ev", "clang::Parser::FieldCallback::~FieldCallback()"),
	mu_demangle_test("_ZN5clang6Parser13FieldCallbackD0Ev", "clang::Parser::FieldCallback::~FieldCallback()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang5TokenEE6insertEPS2_RKS2_", "llvm::SmallVectorImpl<clang::Token>::insert(clang::Token*, clang::Token const&)"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarnings6PolicyC1Ev", "clang::sema::AnalysisBasedWarnings::Policy::Policy()"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarnings6PolicyC2Ev", "clang::sema::AnalysisBasedWarnings::Policy::Policy()"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarningsC1ERNS_4SemaE", "clang::sema::AnalysisBasedWarnings::AnalysisBasedWarnings(clang::Sema&)"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarningsC2ERNS_4SemaE", "clang::sema::AnalysisBasedWarnings::AnalysisBasedWarnings(clang::Sema&)"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_4DeclENS_8QualTypeE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::Decl const*, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122UninitValsDiagReporterD1Ev", "(anonymous namespace)::UninitValsDiagReporter::~UninitValsDiagReporter()"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_9BlockExprE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::BlockExpr const*)"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_14ObjCMethodDeclE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::ObjCMethodDecl const*)"),
	mu_demangle_test("_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_12FunctionDeclE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::FunctionDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122UninitValsDiagReporterD0Ev", "(anonymous namespace)::UninitValsDiagReporter::~UninitValsDiagReporter()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122UninitValsDiagReporter25handleUseOfUninitVariableEPKN5clang4ExprEPKNS1_7VarDeclE", "(anonymous namespace)::UninitValsDiagReporter::handleUseOfUninitVariable(clang::Expr const*, clang::VarDecl const*)"),
	mu_demangle_test("_ZSt16__introsort_loopIPPKN5clang4ExprElN12_GLOBAL__N_18SLocSortEEvT_S7_T0_T1_", "void std::__introsort_loop<clang::Expr const**, long, (anonymous namespace)::SLocSort>(clang::Expr const**, clang::Expr const**, long, (anonymous namespace)::SLocSort)"),
	mu_demangle_test("_ZSt16__insertion_sortIPPKN5clang4ExprEN12_GLOBAL__N_18SLocSortEEvT_S7_T0_", "void std::__insertion_sort<clang::Expr const**, (anonymous namespace)::SLocSort>(clang::Expr const**, clang::Expr const**, (anonymous namespace)::SLocSort)"),
	mu_demangle_test("_ZSt25__unguarded_linear_insertIPPKN5clang4ExprES3_N12_GLOBAL__N_18SLocSortEEvT_T0_T1_", "void std::__unguarded_linear_insert<clang::Expr const**, clang::Expr const*, (anonymous namespace)::SLocSort>(clang::Expr const**, clang::Expr const*, (anonymous namespace)::SLocSort)"),
	mu_demangle_test("_ZSt13__adjust_heapIPPKN5clang4ExprElS3_N12_GLOBAL__N_18SLocSortEEvT_T0_S8_T1_T2_", "void std::__adjust_heap<clang::Expr const**, long, clang::Expr const*, (anonymous namespace)::SLocSort>(clang::Expr const**, long, long, clang::Expr const*, (anonymous namespace)::SLocSort)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122UnreachableCodeHandlerD1Ev", "(anonymous namespace)::UnreachableCodeHandler::~UnreachableCodeHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122UnreachableCodeHandlerD0Ev", "(anonymous namespace)::UnreachableCodeHandler::~UnreachableCodeHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_122UnreachableCodeHandler17HandleUnreachableEN5clang14SourceLocationENS1_11SourceRangeES3_", "(anonymous namespace)::UnreachableCodeHandler::HandleUnreachable(clang::SourceLocation, clang::SourceRange, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang22UninitVariablesHandler25handleUseOfUninitVariableEPKNS_4ExprEPKNS_7VarDeclE", "clang::UninitVariablesHandler::handleUseOfUninitVariable(clang::Expr const*, clang::VarDecl const*)"),
	mu_demangle_test("_ZN5clang14reachable_code8CallbackD1Ev", "clang::reachable_code::Callback::~Callback()"),
	mu_demangle_test("_ZN5clang14reachable_code8CallbackD0Ev", "clang::reachable_code::Callback::~Callback()"),
	mu_demangle_test("_ZSt6__findIPKPN5clang8CFGBlockES2_ET_S5_S5_RKT0_St26random_access_iterator_tag", "clang::CFGBlock* const* std::__find<clang::CFGBlock* const*, clang::CFGBlock*>(clang::CFGBlock* const*, clang::CFGBlock* const*, clang::CFGBlock* const&, std::random_access_iterator_tag)"),
	mu_demangle_test("_ZN5clang13AttributeListC1ERN4llvm16BumpPtrAllocatorEPNS_14IdentifierInfoENS_14SourceLocationES5_S6_S5_S6_PPNS_4ExprEjbb", "clang::AttributeList::AttributeList(llvm::BumpPtrAllocator&, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Expr**, unsigned int, bool, bool)"),
	mu_demangle_test("_ZN5clang13AttributeListC2ERN4llvm16BumpPtrAllocatorEPNS_14IdentifierInfoENS_14SourceLocationES5_S6_S5_S6_PPNS_4ExprEjbb", "clang::AttributeList::AttributeList(llvm::BumpPtrAllocator&, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Expr**, unsigned int, bool, bool)"),
	mu_demangle_test("_ZN5clang13AttributeList7getKindEPKNS_14IdentifierInfoE", "clang::AttributeList::getKind(clang::IdentifierInfo const*)"),
	mu_demangle_test("_ZNK5clang21CodeCompletionContext22wantConstructorResultsEv", "clang::CodeCompletionContext::wantConstructorResults() const"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5ChunkC1ENS0_9ChunkKindEPKc", "clang::CodeCompletionString::Chunk::Chunk(clang::CodeCompletionString::ChunkKind, char const*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5ChunkC2ENS0_9ChunkKindEPKc", "clang::CodeCompletionString::Chunk::Chunk(clang::CodeCompletionString::ChunkKind, char const*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5Chunk10CreateTextEPKc", "clang::CodeCompletionString::Chunk::CreateText(char const*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5Chunk14CreateOptionalEPS0_", "clang::CodeCompletionString::Chunk::CreateOptional(clang::CodeCompletionString*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5Chunk17CreatePlaceholderEPKc", "clang::CodeCompletionString::Chunk::CreatePlaceholder(char const*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5Chunk17CreateInformativeEPKc", "clang::CodeCompletionString::Chunk::CreateInformative(char const*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5Chunk16CreateResultTypeEPKc", "clang::CodeCompletionString::Chunk::CreateResultType(char const*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionString5Chunk22CreateCurrentParameterEPKc", "clang::CodeCompletionString::Chunk::CreateCurrentParameter(char const*)"),
	mu_demangle_test("_ZN5clang20CodeCompletionStringC1EPKNS0_5ChunkEjj18CXAvailabilityKind", "clang::CodeCompletionString::CodeCompletionString(clang::CodeCompletionString::Chunk const*, unsigned int, unsigned int, CXAvailabilityKind)"),
	mu_demangle_test("_ZN5clang20CodeCompletionStringC2EPKNS0_5ChunkEjj18CXAvailabilityKind", "clang::CodeCompletionString::CodeCompletionString(clang::CodeCompletionString::Chunk const*, unsigned int, unsigned int, CXAvailabilityKind)"),
	mu_demangle_test("_ZNK5clang20CodeCompletionString11getAsStringEv", "clang::CodeCompletionString::getAsString() const"),
	mu_demangle_test("_ZNK5clang20CodeCompletionString12getTypedTextEv", "clang::CodeCompletionString::getTypedText() const"),
	mu_demangle_test("_ZN5clang23CodeCompletionAllocator10CopyStringEN4llvm9StringRefE", "clang::CodeCompletionAllocator::CopyString(llvm::StringRef)"),
	mu_demangle_test("_ZN5clang21CodeCompletionBuilder10TakeStringEv", "clang::CodeCompletionBuilder::TakeString()"),
	mu_demangle_test("_ZN5clang20CodeCompletionResult19getPriorityFromDeclEPNS_9NamedDeclE", "clang::CodeCompletionResult::getPriorityFromDecl(clang::NamedDecl*)"),
	mu_demangle_test("_ZNK5clang20CodeCompleteConsumer17OverloadCandidate11getFunctionEv", "clang::CodeCompleteConsumer::OverloadCandidate::getFunction() const"),
	mu_demangle_test("_ZNK5clang20CodeCompleteConsumer17OverloadCandidate15getFunctionTypeEv", "clang::CodeCompleteConsumer::OverloadCandidate::getFunctionType() const"),
	mu_demangle_test("_ZN5clang20CodeCompleteConsumerD0Ev", "clang::CodeCompleteConsumer::~CodeCompleteConsumer()"),
	mu_demangle_test("_ZN5clang20CodeCompleteConsumerD1Ev", "clang::CodeCompleteConsumer::~CodeCompleteConsumer()"),
	mu_demangle_test("_ZN5clang20CodeCompleteConsumerD2Ev", "clang::CodeCompleteConsumer::~CodeCompleteConsumer()"),
	mu_demangle_test("_ZN5clang28PrintingCodeCompleteConsumer26ProcessCodeCompleteResultsERNS_4SemaENS_21CodeCompletionContextEPNS_20CodeCompletionResultEj", "clang::PrintingCodeCompleteConsumer::ProcessCodeCompleteResults(clang::Sema&, clang::CodeCompletionContext, clang::CodeCompletionResult*, unsigned int)"),
	mu_demangle_test("_ZN5clang28PrintingCodeCompleteConsumer25ProcessOverloadCandidatesERNS_4SemaEjPNS_20CodeCompleteConsumer17OverloadCandidateEj", "clang::PrintingCodeCompleteConsumer::ProcessOverloadCandidates(clang::Sema&, unsigned int, clang::CodeCompleteConsumer::OverloadCandidate*, unsigned int)"),
	mu_demangle_test("_ZN5clang20CodeCompletionResult32computeCursorKindAndAvailabilityEv", "clang::CodeCompletionResult::computeCursorKindAndAvailability()"),
	mu_demangle_test("_ZN5clangltERKNS_20CodeCompletionResultES2_", "clang::operator<(clang::CodeCompletionResult const&, clang::CodeCompletionResult const&)"),
	mu_demangle_test("_Z14getOrderedNameRKN5clang20CodeCompletionResultERSs", "getOrderedName(clang::CodeCompletionResult const&, std::string&)"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_15UnavailableAttrEEEPT_v", "clang::UnavailableAttr* clang::Decl::getAttr<clang::UnavailableAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_14DeprecatedAttrEEEPT_v", "clang::DeprecatedAttr* clang::Decl::getAttr<clang::DeprecatedAttr>() const"),
	mu_demangle_test("_ZN5clang28PrintingCodeCompleteConsumerD1Ev", "clang::PrintingCodeCompleteConsumer::~PrintingCodeCompleteConsumer()"),
	mu_demangle_test("_ZN5clang28PrintingCodeCompleteConsumerD0Ev", "clang::PrintingCodeCompleteConsumer::~PrintingCodeCompleteConsumer()"),
	mu_demangle_test("_ZSt21__inplace_stable_sortIPN5clang20CodeCompletionResultEEvT_S3_", "void std::__inplace_stable_sort<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*)"),
	mu_demangle_test("_ZSt22__stable_sort_adaptiveIPN5clang20CodeCompletionResultES2_lEvT_S3_T0_T1_", "void std::__stable_sort_adaptive<clang::CodeCompletionResult*, clang::CodeCompletionResult*, long>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long)"),
	mu_demangle_test("_ZSt24__merge_sort_with_bufferIPN5clang20CodeCompletionResultES2_EvT_S3_T0_", "void std::__merge_sort_with_buffer<clang::CodeCompletionResult*, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"),
	mu_demangle_test("_ZSt16__merge_adaptiveIPN5clang20CodeCompletionResultElS2_EvT_S3_S3_T0_S4_T1_S4_", "void std::__merge_adaptive<clang::CodeCompletionResult*, long, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long, long, clang::CodeCompletionResult*, long)"),
	mu_demangle_test("_ZSt5mergeIPN5clang20CodeCompletionResultES2_S2_ET1_T_S4_T0_S5_S3_", "clang::CodeCompletionResult* std::merge<clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"),
	mu_demangle_test("_ZSt16__merge_backwardIPN5clang20CodeCompletionResultES2_S2_ET1_T_S4_T0_S5_S3_", "clang::CodeCompletionResult* std::__merge_backward<clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"),
	mu_demangle_test("_ZSt17__rotate_adaptiveIPN5clang20CodeCompletionResultES2_lET_S3_S3_S3_T1_S4_T0_S4_", "clang::CodeCompletionResult* std::__rotate_adaptive<clang::CodeCompletionResult*, clang::CodeCompletionResult*, long>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long, long, clang::CodeCompletionResult*, long)"),
	mu_demangle_test("_ZSt8__rotateIPN5clang20CodeCompletionResultEEvT_S3_S3_St26random_access_iterator_tag", "void std::__rotate<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, std::random_access_iterator_tag)"),
	mu_demangle_test("_ZSt16__insertion_sortIPN5clang20CodeCompletionResultEEvT_S3_", "void std::__insertion_sort<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*)"),
	mu_demangle_test("_ZSt22__merge_without_bufferIPN5clang20CodeCompletionResultElEvT_S3_S3_T0_S4_", "void std::__merge_without_buffer<clang::CodeCompletionResult*, long>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long, long)"),
	mu_demangle_test("_ZN5clang13UnqualifiedId13setTemplateIdEPNS_20TemplateIdAnnotationE", "clang::UnqualifiedId::setTemplateId(clang::TemplateIdAnnotation*)"),
	mu_demangle_test("_ZN5clang13UnqualifiedId24setConstructorTemplateIdEPNS_20TemplateIdAnnotationE", "clang::UnqualifiedId::setConstructorTemplateId(clang::TemplateIdAnnotation*)"),
	mu_demangle_test("_ZN5clang15DeclaratorChunk11getFunctionERKNS_16ParsedAttributesEbbNS_14SourceLocationEPNS0_9ParamInfoEjjbS4_bS4_bPNS_9OpaquePtrINS_8QualTypeEEEPNS_11SourceRangeEjS4_S4_RNS_10DeclaratorES9_", "clang::DeclaratorChunk::getFunction(clang::ParsedAttributes const&, bool, bool, clang::SourceLocation, clang::DeclaratorChunk::ParamInfo*, unsigned int, unsigned int, bool, clang::SourceLocation, bool, clang::SourceLocation, bool, clang::OpaquePtr<clang::QualType>*, clang::SourceRange*, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::Declarator&, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZNK5clang8DeclSpec19getParsedSpecifiersEv", "clang::DeclSpec::getParsedSpecifiers() const"),
	mu_demangle_test("_ZN5clang8DeclSpec16getSpecifierNameENS0_3SCSE", "clang::DeclSpec::getSpecifierName(clang::DeclSpec::SCS)"),
	mu_demangle_test("_ZN5clang8DeclSpec16getSpecifierNameENS_18TypeSpecifierWidthE", "clang::DeclSpec::getSpecifierName(clang::TypeSpecifierWidth)"),
	mu_demangle_test("_ZN5clang8DeclSpec16getSpecifierNameENS0_3TSCE", "clang::DeclSpec::getSpecifierName(clang::DeclSpec::TSC)"),
	mu_demangle_test("_ZN5clang8DeclSpec16getSpecifierNameENS_17TypeSpecifierSignE", "clang::DeclSpec::getSpecifierName(clang::TypeSpecifierSign)"),
	mu_demangle_test("_ZN5clang8DeclSpec16getSpecifierNameENS_17TypeSpecifierTypeE", "clang::DeclSpec::getSpecifierName(clang::TypeSpecifierType)"),
	mu_demangle_test("_ZN5clang8DeclSpec16getSpecifierNameENS0_2TQE", "clang::DeclSpec::getSpecifierName(clang::DeclSpec::TQ)"),
	mu_demangle_test("_ZN5clang8DeclSpec19SetStorageClassSpecENS0_3SCSENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetStorageClassSpec(clang::DeclSpec::SCS, clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec25SetStorageClassSpecThreadENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetStorageClassSpecThread(clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec16SetTypeSpecWidthENS_18TypeSpecifierWidthENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecWidth(clang::TypeSpecifierWidth, clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec18SetTypeSpecComplexENS0_3TSCENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecComplex(clang::DeclSpec::TSC, clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec15SetTypeSpecSignENS_17TypeSpecifierSignENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecSign(clang::TypeSpecifierSign, clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRjNS_9OpaquePtrINS_8QualTypeEEE", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRjPNS_4ExprE", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&, clang::Expr*)"),
	mu_demangle_test("_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRjPNS_4DeclEb", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&, clang::Decl*, bool)"),
	mu_demangle_test("_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec20SetTypeAltiVecVectorEbNS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeAltiVecVector(bool, clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec19SetTypeAltiVecPixelEbNS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeAltiVecPixel(bool, clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec16SetTypeSpecErrorEv", "clang::DeclSpec::SetTypeSpecError()"),
	mu_demangle_test("_ZN5clang8DeclSpec11SetTypeQualENS0_2TQENS_14SourceLocationERPKcRjRKNS_11LangOptionsE", "clang::DeclSpec::SetTypeQual(clang::DeclSpec::TQ, clang::SourceLocation, char const*&, unsigned int&, clang::LangOptions const&)"),
	mu_demangle_test("_ZN5clang8DeclSpec21SetFunctionSpecInlineENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFunctionSpecInline(clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec22SetFunctionSpecVirtualENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFunctionSpecVirtual(clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec23SetFunctionSpecExplicitENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFunctionSpecExplicit(clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec13SetFriendSpecENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFriendSpec(clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec16SetConstexprSpecENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetConstexprSpec(clang::SourceLocation, char const*&, unsigned int&)"),
	mu_demangle_test("_ZN5clang8DeclSpec21setProtocolQualifiersEPKPNS_4DeclEjPNS_14SourceLocationES5_", "clang::DeclSpec::setProtocolQualifiers(clang::Decl* const*, unsigned int, clang::SourceLocation*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang8DeclSpec23SaveWrittenBuiltinSpecsEv", "clang::DeclSpec::SaveWrittenBuiltinSpecs()"),
	mu_demangle_test("_ZN5clang8DeclSpec29SaveStorageSpecifierAsWrittenEv", "clang::DeclSpec::SaveStorageSpecifierAsWritten()"),
	mu_demangle_test("_ZN5clang8DeclSpec6FinishERNS_10DiagnosticERNS_12PreprocessorE", "clang::DeclSpec::Finish(clang::Diagnostic&, clang::Preprocessor&)"),
	mu_demangle_test("_ZN5clang8DeclSpec21isMissingDeclaratorOkEv", "clang::DeclSpec::isMissingDeclaratorOk()"),
	mu_demangle_test("_ZN5clang13UnqualifiedId5clearEv", "clang::UnqualifiedId::clear()"),
	mu_demangle_test("_ZN5clang13UnqualifiedId21setOperatorFunctionIdENS_14SourceLocationENS_22OverloadedOperatorKindEPS1_", "clang::UnqualifiedId::setOperatorFunctionId(clang::SourceLocation, clang::OverloadedOperatorKind, clang::SourceLocation*)"),
	mu_demangle_test("_ZN5clang14VirtSpecifiers12SetSpecifierENS0_9SpecifierENS_14SourceLocationERPKc", "clang::VirtSpecifiers::SetSpecifier(clang::VirtSpecifiers::Specifier, clang::SourceLocation, char const*&)"),
	mu_demangle_test("_ZN5clang14VirtSpecifiers16getSpecifierNameENS0_9SpecifierE", "clang::VirtSpecifiers::getSpecifierName(clang::VirtSpecifiers::Specifier)"),
	mu_demangle_test("_ZN5clang19ClassVirtSpecifiers12SetSpecifierENS0_9SpecifierENS_14SourceLocationERPKc", "clang::ClassVirtSpecifiers::SetSpecifier(clang::ClassVirtSpecifiers::Specifier, clang::SourceLocation, char const*&)"),
	mu_demangle_test("_ZN5clang19ClassVirtSpecifiers16getSpecifierNameENS0_9SpecifierE", "clang::ClassVirtSpecifiers::getSpecifierName(clang::ClassVirtSpecifiers::Specifier)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver10IdDeclInfo10RemoveDeclEPNS_9NamedDeclE", "clang::IdentifierResolver::IdDeclInfo::RemoveDecl(clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver10IdDeclInfo11ReplaceDeclEPNS_9NamedDeclES3_", "clang::IdentifierResolver::IdDeclInfo::ReplaceDecl(clang::NamedDecl*, clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang18IdentifierResolverC1ERKNS_11LangOptionsE", "clang::IdentifierResolver::IdentifierResolver(clang::LangOptions const&)"),
	mu_demangle_test("_ZN5clang18IdentifierResolverC2ERKNS_11LangOptionsE", "clang::IdentifierResolver::IdentifierResolver(clang::LangOptions const&)"),
	mu_demangle_test("_ZN5clang18IdentifierResolverD1Ev", "clang::IdentifierResolver::~IdentifierResolver()"),
	mu_demangle_test("_ZN5clang18IdentifierResolverD2Ev", "clang::IdentifierResolver::~IdentifierResolver()"),
	mu_demangle_test("_ZNK5clang18IdentifierResolver13isDeclInScopeEPNS_4DeclEPNS_11DeclContextERNS_10ASTContextEPNS_5ScopeE", "clang::IdentifierResolver::isDeclInScope(clang::Decl*, clang::DeclContext*, clang::ASTContext&, clang::Scope*) const"),
	mu_demangle_test("_ZN5clang18IdentifierResolver7AddDeclEPNS_9NamedDeclE", "clang::IdentifierResolver::AddDecl(clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver13IdDeclInfoMapixENS_15DeclarationNameE", "clang::IdentifierResolver::IdDeclInfoMap::operator[](clang::DeclarationName)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver10RemoveDeclEPNS_9NamedDeclE", "clang::IdentifierResolver::RemoveDecl(clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver11ReplaceDeclEPNS_9NamedDeclES2_", "clang::IdentifierResolver::ReplaceDecl(clang::NamedDecl*, clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver5beginENS_15DeclarationNameE", "clang::IdentifierResolver::begin(clang::DeclarationName)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver24AddDeclToIdentifierChainEPNS_14IdentifierInfoEPNS_9NamedDeclE", "clang::IdentifierResolver::AddDeclToIdentifierChain(clang::IdentifierInfo*, clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang18IdentifierResolver8iterator17incrementSlowCaseEv", "clang::IdentifierResolver::iterator::incrementSlowCase()"),
	mu_demangle_test("_ZN5clang4Sema20DiagnoseInvalidJumpsEPNS_4StmtE", "clang::Sema::DiagnoseInvalidJumps(clang::Stmt*)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_116JumpScopeChecker9GotoScopeEE9push_backERKS3_", "llvm::SmallVectorImpl<(anonymous namespace)::JumpScopeChecker::GotoScope>::push_back((anonymous namespace)::JumpScopeChecker::GotoScope const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116JumpScopeChecker21BuildScopeInformationEPN5clang4StmtEj", "(anonymous namespace)::JumpScopeChecker::BuildScopeInformation(clang::Stmt*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116JumpScopeChecker9CheckJumpEPN5clang4StmtES3_NS1_14SourceLocationEj", "(anonymous namespace)::JumpScopeChecker::CheckJump(clang::Stmt*, clang::Stmt*, clang::SourceLocation, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116JumpScopeChecker21BuildScopeInformationEPN5clang4DeclERj", "(anonymous namespace)::JumpScopeChecker::BuildScopeInformation(clang::Decl*, unsigned int&)"),
	mu_demangle_test("_ZN5clang4sema17FunctionScopeInfoD0Ev", "clang::sema::FunctionScopeInfo::~FunctionScopeInfo()"),
	mu_demangle_test("_ZN5clang4sema17FunctionScopeInfoD1Ev", "clang::sema::FunctionScopeInfo::~FunctionScopeInfo()"),
	mu_demangle_test("_ZN5clang4sema17FunctionScopeInfoD2Ev", "clang::sema::FunctionScopeInfo::~FunctionScopeInfo()"),
	mu_demangle_test("_ZN5clang4sema17FunctionScopeInfo5ClearEv", "clang::sema::FunctionScopeInfo::Clear()"),
	mu_demangle_test("_ZN5clang4sema14BlockScopeInfoD0Ev", "clang::sema::BlockScopeInfo::~BlockScopeInfo()"),
	mu_demangle_test("_ZN5clang4sema14BlockScopeInfoD1Ev", "clang::sema::BlockScopeInfo::~BlockScopeInfo()"),
	mu_demangle_test("_ZN5clang4sema14BlockScopeInfoD2Ev", "clang::sema::BlockScopeInfo::~BlockScopeInfo()"),
	mu_demangle_test("_ZN5clang4Sema25ActOnTranslationUnitScopeEPNS_5ScopeE", "clang::Sema::ActOnTranslationUnitScope(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4SemaC1ERNS_12PreprocessorERNS_10ASTContextERNS_11ASTConsumerEbPNS_20CodeCompleteConsumerE", "clang::Sema::Sema(clang::Preprocessor&, clang::ASTContext&, clang::ASTConsumer&, bool, clang::CodeCompleteConsumer*)"),
	mu_demangle_test("_ZN5clang4SemaC2ERNS_12PreprocessorERNS_10ASTContextERNS_11ASTConsumerEbPNS_20CodeCompleteConsumerE", "clang::Sema::Sema(clang::Preprocessor&, clang::ASTContext&, clang::ASTConsumer&, bool, clang::CodeCompleteConsumer*)"),
	mu_demangle_test("_ZN5clang4Sema10InitializeEv", "clang::Sema::Initialize()"),
	mu_demangle_test("_ZN5clang4SemaD1Ev", "clang::Sema::~Sema()"),
	mu_demangle_test("_ZN5clang4SemaD2Ev", "clang::Sema::~Sema()"),
	mu_demangle_test("_ZN5clang4Sema17ImpCastExprToTypeERPNS_4ExprENS_8QualTypeENS_8CastKindENS_13ExprValueKindEPKN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::ImpCastExprToType(clang::Expr*&, clang::QualType, clang::CastKind, clang::ExprValueKind, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u> const*)"),
	mu_demangle_test("_ZN5clang4Sema12CastCategoryEPNS_4ExprE", "clang::Sema::CastCategory(clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema25ActOnEndOfTranslationUnitEv", "clang::Sema::ActOnEndOfTranslationUnit()"),
	mu_demangle_test("_Z22ShouldRemoveFromUnusedPN5clang4SemaEPKNS_14DeclaratorDeclE", "ShouldRemoveFromUnused(clang::Sema*, clang::DeclaratorDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema4DiagENS_14SourceLocationEj", "clang::Sema::Diag(clang::SourceLocation, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema21SemaDiagnosticBuilderD1Ev", "clang::Sema::SemaDiagnosticBuilder::~SemaDiagnosticBuilder()"),
	mu_demangle_test("_ZN5clang4Sema27getFunctionLevelDeclContextEv", "clang::Sema::getFunctionLevelDeclContext()"),
	mu_demangle_test("_ZN5clang4Sema18getCurFunctionDeclEv", "clang::Sema::getCurFunctionDecl()"),
	mu_demangle_test("_ZN5clang4Sema16getCurMethodDeclEv", "clang::Sema::getCurMethodDecl()"),
	mu_demangle_test("_ZN5clang4Sema26getCurFunctionOrMethodDeclEv", "clang::Sema::getCurFunctionOrMethodDecl()"),
	mu_demangle_test("_ZN5clang4Sema21SemaDiagnosticBuilderD2Ev", "clang::Sema::SemaDiagnosticBuilder::~SemaDiagnosticBuilder()"),
	mu_demangle_test("_ZN5clang4Sema4DiagENS_14SourceLocationERKNS_17PartialDiagnosticE", "clang::Sema::Diag(clang::SourceLocation, clang::PartialDiagnostic const&)"),
	mu_demangle_test("_ZN5clang4Sema18getScopeForContextEPNS_11DeclContextE", "clang::Sema::getScopeForContext(clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang4Sema17PushFunctionScopeEv", "clang::Sema::PushFunctionScope()"),
	mu_demangle_test("_ZN5clang4Sema14PushBlockScopeEPNS_5ScopeEPNS_9BlockDeclE", "clang::Sema::PushBlockScope(clang::Scope*, clang::BlockDecl*)"),
	mu_demangle_test("_ZN5clang4Sema23PopFunctionOrBlockScopeEv", "clang::Sema::PopFunctionOrBlockScope()"),
	mu_demangle_test("_ZNK5clang4Sema26hasAnyErrorsInThisFunctionEv", "clang::Sema::hasAnyErrorsInThisFunction() const"),
	mu_demangle_test("_ZN5clang4Sema11getCurBlockEv", "clang::Sema::getCurBlock()"),
	mu_demangle_test("_ZN5clang18ExternalSemaSourceD0Ev", "clang::ExternalSemaSource::~ExternalSemaSource()"),
	mu_demangle_test("_ZN5clang18ExternalSemaSourceD1Ev", "clang::ExternalSemaSource::~ExternalSemaSource()"),
	mu_demangle_test("_ZN5clang18ExternalSemaSourceD2Ev", "clang::ExternalSemaSource::~ExternalSemaSource()"),
	mu_demangle_test("_ZN5clang18ExternalSemaSource14ReadMethodPoolENS_8SelectorE", "clang::ExternalSemaSource::ReadMethodPool(clang::Selector)"),
	mu_demangle_test("_ZNK5clang25PrettyDeclStackTraceEntry5printERN4llvm11raw_ostreamE", "clang::PrettyDeclStackTraceEntry::print(llvm::raw_ostream&) const"),
	mu_demangle_test("_ZN5clang4sema21TemplateDeductionInfo23addSuppressedDiagnosticENS_14SourceLocationERKNS_17PartialDiagnosticE", "clang::sema::TemplateDeductionInfo::addSuppressedDiagnostic(clang::SourceLocation, clang::PartialDiagnostic const&)"),
	mu_demangle_test("_ZNK5clang17PartialDiagnostic4EmitERKNS_17DiagnosticBuilderE", "clang::PartialDiagnostic::Emit(clang::DiagnosticBuilder const&) const"),
	mu_demangle_test("_ZN5clang25PrettyDeclStackTraceEntryD1Ev", "clang::PrettyDeclStackTraceEntry::~PrettyDeclStackTraceEntry()"),
	mu_demangle_test("_ZN5clang25PrettyDeclStackTraceEntryD0Ev", "clang::PrettyDeclStackTraceEntry::~PrettyDeclStackTraceEntry()"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang4Sema33ExpressionEvaluationContextRecordELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Sema::ExpressionEvaluationContextRecord, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang4sema14BlockScopeInfoC2ERNS_10DiagnosticEPNS_5ScopeEPNS_9BlockDeclE", "clang::sema::BlockScopeInfo::BlockScopeInfo(clang::Diagnostic&, clang::Scope*, clang::BlockDecl*)"),
	mu_demangle_test("_ZN5clang17PartialDiagnostic11freeStorageEv", "clang::PartialDiagnostic::freeStorage()"),
	mu_demangle_test("_ZN5clang17PartialDiagnosticC2ERKNS_14DiagnosticInfoERNS0_16StorageAllocatorE", "clang::PartialDiagnostic::PartialDiagnostic(clang::DiagnosticInfo const&, clang::PartialDiagnostic::StorageAllocator&)"),
	mu_demangle_test("_ZNK5clang17PartialDiagnostic9AddStringEN4llvm9StringRefE", "clang::PartialDiagnostic::AddString(llvm::StringRef) const"),
	mu_demangle_test("_ZNK5clang17PartialDiagnostic10getStorageEv", "clang::PartialDiagnostic::getStorage() const"),
	mu_demangle_test("_ZN5clang17PartialDiagnostic16StorageAllocator8AllocateEv", "clang::PartialDiagnostic::StorageAllocator::Allocate()"),
	mu_demangle_test("_ZN5clang17PartialDiagnostic7StorageaSERKS1_", "clang::PartialDiagnostic::Storage::operator=(clang::PartialDiagnostic::Storage const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseISt4pairIN5clang14SourceLocationENS2_17PartialDiagnosticEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::SourceLocation, clang::PartialDiagnostic>, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang4Sema24SetMemberAccessSpecifierEPNS_9NamedDeclES2_NS_15AccessSpecifierE", "clang::Sema::SetMemberAccessSpecifier(clang::NamedDecl*, clang::NamedDecl*, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang4Sema24HandleDelayedAccessCheckERNS_4sema17DelayedDiagnosticEPNS_4DeclE", "clang::Sema::HandleDelayedAccessCheck(clang::sema::DelayedDiagnostic&, clang::Decl*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_116EffectiveContextC1EPN5clang11DeclContextE", "(anonymous namespace)::EffectiveContext::EffectiveContext(clang::DeclContext*)"),
	mu_demangle_test("_Z20CheckEffectiveAccessRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextENS_14SourceLocationERNS2_12AccessTargetE", "CheckEffectiveAccess(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::SourceLocation, (anonymous namespace)::AccessTarget&)"),
	mu_demangle_test("_ZN5clang4Sema26HandleDependentAccessCheckERKNS_19DependentDiagnosticERKNS_30MultiLevelTemplateArgumentListE", "clang::Sema::HandleDependentAccessCheck(clang::DependentDiagnostic const&, clang::MultiLevelTemplateArgumentList const&)"),
	mu_demangle_test("_Z11CheckAccessRN5clang4SemaENS_14SourceLocationERN12_GLOBAL__N_112AccessTargetE", "CheckAccess(clang::Sema&, clang::SourceLocation, (anonymous namespace)::AccessTarget&)"),
	mu_demangle_test("_ZN5clang4Sema27CheckUnresolvedLookupAccessEPNS_20UnresolvedLookupExprENS_14DeclAccessPairE", "clang::Sema::CheckUnresolvedLookupAccess(clang::UnresolvedLookupExpr*, clang::DeclAccessPair)"),
	mu_demangle_test("_ZN5clang4Sema27CheckUnresolvedMemberAccessEPNS_20UnresolvedMemberExprENS_14DeclAccessPairE", "clang::Sema::CheckUnresolvedMemberAccess(clang::UnresolvedMemberExpr*, clang::DeclAccessPair)"),
	mu_demangle_test("_ZN5clang4Sema21CheckDestructorAccessENS_14SourceLocationEPNS_17CXXDestructorDeclERKNS_17PartialDiagnosticE", "clang::Sema::CheckDestructorAccess(clang::SourceLocation, clang::CXXDestructorDecl*, clang::PartialDiagnostic const&)"),
	mu_demangle_test("_ZN5clang4Sema22CheckConstructorAccessENS_14SourceLocationEPNS_18CXXConstructorDeclERKNS_17InitializedEntityENS_15AccessSpecifierEb", "clang::Sema::CheckConstructorAccess(clang::SourceLocation, clang::CXXConstructorDecl*, clang::InitializedEntity const&, clang::AccessSpecifier, bool)"),
	mu_demangle_test("_ZN5clang4Sema23CheckDirectMemberAccessENS_14SourceLocationEPNS_9NamedDeclERKNS_17PartialDiagnosticE", "clang::Sema::CheckDirectMemberAccess(clang::SourceLocation, clang::NamedDecl*, clang::PartialDiagnostic const&)"),
	mu_demangle_test("_ZN5clang4Sema21CheckAllocationAccessENS_14SourceLocationENS_11SourceRangeEPNS_13CXXRecordDeclENS_14DeclAccessPairE", "clang::Sema::CheckAllocationAccess(clang::SourceLocation, clang::SourceRange, clang::CXXRecordDecl*, clang::DeclAccessPair)"),
	mu_demangle_test("_ZN5clang4Sema25CheckMemberOperatorAccessENS_14SourceLocationEPNS_4ExprES3_NS_14DeclAccessPairE", "clang::Sema::CheckMemberOperatorAccess(clang::SourceLocation, clang::Expr*, clang::Expr*, clang::DeclAccessPair)"),
	mu_demangle_test("_ZN5clang4Sema26CheckAddressOfMemberAccessEPNS_4ExprENS_14DeclAccessPairE", "clang::Sema::CheckAddressOfMemberAccess(clang::Expr*, clang::DeclAccessPair)"),
	mu_demangle_test("_ZN5clang4Sema20CheckBaseClassAccessENS_14SourceLocationENS_8QualTypeES2_RKNS_11CXXBasePathEjbb", "clang::Sema::CheckBaseClassAccess(clang::SourceLocation, clang::QualType, clang::QualType, clang::CXXBasePath const&, unsigned int, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema17CheckLookupAccessERKNS_12LookupResultE", "clang::Sema::CheckLookupAccess(clang::LookupResult const&)"),
	mu_demangle_test("_ZN5clang4Sema33ActOnStartSuppressingAccessChecksEv", "clang::Sema::ActOnStartSuppressingAccessChecks()"),
	mu_demangle_test("_ZN5clang4Sema32ActOnStopSuppressingAccessChecksEv", "clang::Sema::ActOnStopSuppressingAccessChecks()"),
	mu_demangle_test("_Z18FindDeclaringClassPN5clang9NamedDeclE", "FindDeclaringClass(clang::NamedDecl*)"),
	mu_demangle_test("_Z9HasAccessRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextEPKNS_13CXXRecordDeclENS_15AccessSpecifierERKNS2_12AccessTargetE", "HasAccess(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::CXXRecordDecl const*, clang::AccessSpecifier, (anonymous namespace)::AccessTarget const&)"),
	mu_demangle_test("_Z12FindBestPathRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextERNS2_12AccessTargetENS_15AccessSpecifierERNS_12CXXBasePathsE", "FindBestPath(clang::Sema&, (anonymous namespace)::EffectiveContext const&, (anonymous namespace)::AccessTarget&, clang::AccessSpecifier, clang::CXXBasePaths&)"),
	mu_demangle_test("_Z13GetFriendKindRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextEPKNS_13CXXRecordDeclE", "GetFriendKind(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_Z13MatchesFriendRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextEPKNS_13CXXRecordDeclE", "MatchesFriend(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_Z18MightInstantiateToRN5clang4SemaEPNS_12FunctionDeclES3_", "MightInstantiateTo(clang::Sema&, clang::FunctionDecl*, clang::FunctionDecl*)"),
	mu_demangle_test("_Z22IsDerivedFromInclusivePKN5clang13CXXRecordDeclES2_", "IsDerivedFromInclusive(clang::CXXRecordDecl const*, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_122ProtectedFriendContext14findFriendshipEPKN5clang13CXXRecordDeclEj", "(anonymous namespace)::ProtectedFriendContext::findFriendship(clang::CXXRecordDecl const*, unsigned int)"),
	mu_demangle_test("_ZSt6__findIPKPN5clang13CXXRecordDeclEPKS1_ET_S7_S7_RKT0_St26random_access_iterator_tag", "clang::CXXRecordDecl* const* std::__find<clang::CXXRecordDecl* const*, clang::CXXRecordDecl const*>(clang::CXXRecordDecl* const*, clang::CXXRecordDecl* const*, clang::CXXRecordDecl const* const&, std::random_access_iterator_tag)"),
	mu_demangle_test("_ZN5clang4Sema17FreePackedContextEv", "clang::Sema::FreePackedContext()"),
	mu_demangle_test("_ZN5clang4Sema31AddAlignmentAttributesForRecordEPNS_10RecordDeclE", "clang::Sema::AddAlignmentAttributesForRecord(clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnPragmaOptionsAlignENS0_22PragmaOptionsAlignKindENS_14SourceLocationES2_", "clang::Sema::ActOnPragmaOptionsAlign(clang::Sema::PragmaOptionsAlignKind, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115PragmaPackStack4pushEPN5clang14IdentifierInfoE", "(anonymous namespace)::PragmaPackStack::push(clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang4Sema15ActOnPragmaPackENS0_14PragmaPackKindEPNS_14IdentifierInfoEPNS_4ExprENS_14SourceLocationES6_S6_", "clang::Sema::ActOnPragmaPack(clang::Sema::PragmaPackKind, clang::IdentifierInfo*, clang::Expr*, clang::SourceLocation, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema17ActOnPragmaUnusedERKNS_5TokenEPNS_5ScopeENS_14SourceLocationE", "clang::Sema::ActOnPragmaUnused(clang::Token const&, clang::Scope*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema28AddPushedVisibilityAttributeEPNS_4DeclE", "clang::Sema::AddPushedVisibilityAttribute(clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema14FreeVisContextEv", "clang::Sema::FreeVisContext()"),
	mu_demangle_test("_ZN5clang4Sema21ActOnPragmaVisibilityEbPKNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::ActOnPragmaVisibility(bool, clang::IdentifierInfo const*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema19PopPragmaVisibilityEv", "clang::Sema::PopPragmaVisibility()"),
	mu_demangle_test("_ZN5clang4Sema27PushNamespaceVisibilityAttrEPKNS_14VisibilityAttrE", "clang::Sema::PushNamespaceVisibilityAttr(clang::VisibilityAttr const*)"),
	mu_demangle_test("_ZN5clang4Decl7addAttrEPNS_4AttrE", "clang::Decl::addAttr(clang::Attr*)"),
	mu_demangle_test("_ZN5clang15InheritableAttrD1Ev", "clang::InheritableAttr::~InheritableAttr()"),
	mu_demangle_test("_ZN5clang15InheritableAttrD0Ev", "clang::InheritableAttr::~InheritableAttr()"),
	mu_demangle_test("_ZN4llvm11SmallVectorIPN5clang4AttrELj2EEC2EjRKS3_", "llvm::SmallVector<clang::Attr*, 2u>::SmallVector(unsigned int, clang::Attr* const&)"),
	mu_demangle_test("_ZN5clang4Sema17ActOnCXXNamedCastENS_14SourceLocationENS_3tok9TokenKindES1_NS_9OpaquePtrINS_8QualTypeEEES1_S1_PNS_4ExprES1_", "clang::Sema::ActOnCXXNamedCast(clang::SourceLocation, clang::tok::TokenKind, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation, clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema17BuildCXXNamedCastENS_14SourceLocationENS_3tok9TokenKindEPNS_14TypeSourceInfoEPNS_4ExprENS_11SourceRangeES8_", "clang::Sema::BuildCXXNamedCast(clang::SourceLocation, clang::tok::TokenKind, clang::TypeSourceInfo*, clang::Expr*, clang::SourceRange, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang4Sema18CXXCheckCStyleCastENS_11SourceRangeENS_8QualTypeERNS_13ExprValueKindERPNS_4ExprERNS_8CastKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEEb", "clang::Sema::CXXCheckCStyleCast(clang::SourceRange, clang::QualType, clang::ExprValueKind&, clang::Expr*&, clang::CastKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&, bool)"),
	mu_demangle_test("_Z12TryConstCastRN5clang4SemaEPNS_4ExprENS_8QualTypeEbRj", "TryConstCast(clang::Sema&, clang::Expr*, clang::QualType, bool, unsigned int&)"),
	mu_demangle_test("_Z13TryStaticCastRN5clang4SemaERPNS_4ExprENS_8QualTypeEbRKNS_11SourceRangeERjRNS_8CastKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "TryStaticCast(clang::Sema&, clang::Expr*&, clang::QualType, bool, clang::SourceRange const&, unsigned int&, clang::CastKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&)"),
	mu_demangle_test("_Z18TryReinterpretCastRN5clang4SemaEPNS_4ExprENS_8QualTypeEbRKNS_11SourceRangeERjRNS_8CastKindE", "TryReinterpretCast(clang::Sema&, clang::Expr*, clang::QualType, bool, clang::SourceRange const&, unsigned int&, clang::CastKind&)"),
	mu_demangle_test("_Z18CastsAwayConstnessRN5clang4SemaENS_8QualTypeES2_", "CastsAwayConstness(clang::Sema&, clang::QualType, clang::QualType)"),
	mu_demangle_test("_Z17TryStaticDowncastRN5clang4SemaENS_7CanQualINS_4TypeEEES4_bRKNS_11SourceRangeENS_8QualTypeES8_RjRNS_8CastKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "TryStaticDowncast(clang::Sema&, clang::CanQual<clang::Type>, clang::CanQual<clang::Type>, bool, clang::SourceRange const&, clang::QualType, clang::QualType, unsigned int&, clang::CastKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&)"),
	mu_demangle_test("_Z25NoteAllOverloadCandidatesPN5clang4ExprERNS_4SemaE", "NoteAllOverloadCandidates(clang::Expr*, clang::Sema&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang10QualifiersELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Qualifiers, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang4Sema18computeDeclContextENS_8QualTypeE", "clang::Sema::computeDeclContext(clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema18computeDeclContextERKNS_12CXXScopeSpecEb", "clang::Sema::computeDeclContext(clang::CXXScopeSpec const&, bool)"),
	mu_demangle_test("_ZN5clang4Sema25getCurrentInstantiationOfEPNS_19NestedNameSpecifierE", "clang::Sema::getCurrentInstantiationOf(clang::NestedNameSpecifier*)"),
	mu_demangle_test("_ZN5clang4Sema25isDependentScopeSpecifierERKNS_12CXXScopeSpecE", "clang::Sema::isDependentScopeSpecifier(clang::CXXScopeSpec const&)"),
	mu_demangle_test("_ZN5clang4Sema23isUnknownSpecializationERKNS_12CXXScopeSpecE", "clang::Sema::isUnknownSpecialization(clang::CXXScopeSpec const&)"),
	mu_demangle_test("_ZN5clang4Sema26RequireCompleteDeclContextERNS_12CXXScopeSpecEPNS_11DeclContextE", "clang::Sema::RequireCompleteDeclContext(clang::CXXScopeSpec&, clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang4Sema28ActOnCXXGlobalScopeSpecifierEPNS_5ScopeENS_14SourceLocationE", "clang::Sema::ActOnCXXGlobalScopeSpecifier(clang::Scope*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema31isAcceptableNestedNameSpecifierEPNS_9NamedDeclE", "clang::Sema::isAcceptableNestedNameSpecifier(clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang4Sema25FindFirstQualifierInScopeEPNS_5ScopeEPNS_19NestedNameSpecifierE", "clang::Sema::FindFirstQualifierInScope(clang::Scope*, clang::NestedNameSpecifier*)"),
	mu_demangle_test("_ZN5clang4Sema28isNonTypeNestedNameSpecifierEPNS_5ScopeERNS_12CXXScopeSpecENS_14SourceLocationERNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::isNonTypeNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec&, clang::SourceLocation, clang::IdentifierInfo&, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZN5clang4Sema27BuildCXXNestedNameSpecifierEPNS_5ScopeERNS_12CXXScopeSpecENS_14SourceLocationES5_RNS_14IdentifierInfoENS_8QualTypeEPNS_9NamedDeclEbb", "clang::Sema::BuildCXXNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec&, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo&, clang::QualType, clang::NamedDecl*, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema27ActOnCXXNestedNameSpecifierEPNS_5ScopeERNS_12CXXScopeSpecENS_14SourceLocationES5_RNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEEb", "clang::Sema::ActOnCXXNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec&, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo&, clang::OpaquePtr<clang::QualType>, bool)"),
	mu_demangle_test("_ZN5clang4Sema25IsInvalidUnlessNestedNameEPNS_5ScopeERNS_12CXXScopeSpecERNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEEb", "clang::Sema::IsInvalidUnlessNestedName(clang::Scope*, clang::CXXScopeSpec&, clang::IdentifierInfo&, clang::OpaquePtr<clang::QualType>, bool)"),
	mu_demangle_test("_ZN5clang4Sema27ActOnCXXNestedNameSpecifierEPNS_5ScopeERKNS_12CXXScopeSpecENS_9OpaquePtrINS_8QualTypeEEENS_11SourceRangeENS_14SourceLocationE", "clang::Sema::ActOnCXXNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec const&, clang::OpaquePtr<clang::QualType>, clang::SourceRange, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema26ShouldEnterDeclaratorScopeEPNS_5ScopeERKNS_12CXXScopeSpecE", "clang::Sema::ShouldEnterDeclaratorScope(clang::Scope*, clang::CXXScopeSpec const&)"),
	mu_demangle_test("_ZN5clang4Sema28ActOnCXXEnterDeclaratorScopeEPNS_5ScopeERNS_12CXXScopeSpecE", "clang::Sema::ActOnCXXEnterDeclaratorScope(clang::Scope*, clang::CXXScopeSpec&)"),
	mu_demangle_test("_ZN5clang4Sema27ActOnCXXExitDeclaratorScopeEPNS_5ScopeERKNS_12CXXScopeSpecE", "clang::Sema::ActOnCXXExitDeclaratorScope(clang::Scope*, clang::CXXScopeSpec const&)"),
	mu_demangle_test("_ZNK5clang4Sema30getLocationOfStringLiteralByteEPKNS_13StringLiteralEj", "clang::Sema::getLocationOfStringLiteralByte(clang::StringLiteral const*, unsigned int) const"),
	mu_demangle_test("_ZN5clang4Sema19CheckablePrintfAttrEPKNS_10FormatAttrEPNS_8CallExprE", "clang::Sema::CheckablePrintfAttr(clang::FormatAttr const*, clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema24CheckBuiltinFunctionCallEjPNS_8CallExprE", "clang::Sema::CheckBuiltinFunctionCall(unsigned int, clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema22SemaBuiltinConstantArgEPNS_8CallExprEiRN4llvm6APSIntE", "clang::Sema::SemaBuiltinConstantArg(clang::CallExpr*, int, llvm::APSInt&)"),
	mu_demangle_test("_ZN5clang4Sema15CheckObjCStringEPNS_4ExprE", "clang::Sema::CheckObjCString(clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema18SemaBuiltinVAStartEPNS_8CallExprE", "clang::Sema::SemaBuiltinVAStart(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema27SemaBuiltinUnorderedCompareEPNS_8CallExprE", "clang::Sema::SemaBuiltinUnorderedCompare(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema27SemaBuiltinFPClassificationEPNS_8CallExprEj", "clang::Sema::SemaBuiltinFPClassification(clang::CallExpr*, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema24SemaBuiltinShuffleVectorEPNS_8CallExprE", "clang::Sema::SemaBuiltinShuffleVector(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema19SemaBuiltinPrefetchEPNS_8CallExprE", "clang::Sema::SemaBuiltinPrefetch(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema21SemaBuiltinObjectSizeEPNS_8CallExprE", "clang::Sema::SemaBuiltinObjectSize(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema18SemaBuiltinLongjmpEPNS_8CallExprE", "clang::Sema::SemaBuiltinLongjmp(clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema27SemaBuiltinAtomicOverloadedENS_12ActionResultIPNS_4ExprELb1EEE", "clang::Sema::SemaBuiltinAtomicOverloaded(clang::ActionResult<clang::Expr*, true>)"),
	mu_demangle_test("_ZN5clang4Sema27CheckARMBuiltinFunctionCallEjPNS_8CallExprE", "clang::Sema::CheckARMBuiltinFunctionCall(unsigned int, clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema17CheckFunctionCallEPNS_12FunctionDeclEPNS_8CallExprE", "clang::Sema::CheckFunctionCall(clang::FunctionDecl*, clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema25CheckPrintfScanfArgumentsEPKNS_8CallExprEbjjb", "clang::Sema::CheckPrintfScanfArguments(clang::CallExpr const*, bool, unsigned int, unsigned int, bool)"),
	mu_demangle_test("_ZN5clang4Sema21CheckNonNullArgumentsEPKNS_11NonNullAttrEPKNS_8CallExprE", "clang::Sema::CheckNonNullArguments(clang::NonNullAttr const*, clang::CallExpr const*)"),
	mu_demangle_test("_ZN5clang4Sema14CheckBlockCallEPNS_9NamedDeclEPNS_8CallExprE", "clang::Sema::CheckBlockCall(clang::NamedDecl*, clang::CallExpr*)"),
	mu_demangle_test("_ZN5clang4Sema22SemaCheckStringLiteralEPKNS_4ExprEPKNS_8CallExprEbjjb", "clang::Sema::SemaCheckStringLiteral(clang::Expr const*, clang::CallExpr const*, bool, unsigned int, unsigned int, bool)"),
	mu_demangle_test("_ZN5clang4Sema17CheckFormatStringEPKNS_13StringLiteralEPKNS_4ExprEPKNS_8CallExprEbjjb", "clang::Sema::CheckFormatString(clang::StringLiteral const*, clang::Expr const*, clang::CallExpr const*, bool, unsigned int, unsigned int, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandler14DoneProcessingEv", "(anonymous namespace)::CheckFormatHandler::DoneProcessing()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandlerD1Ev", "(anonymous namespace)::CheckPrintfHandler::~CheckPrintfHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CheckScanfHandlerD1Ev", "(anonymous namespace)::CheckScanfHandler::~CheckScanfHandler()"),
	mu_demangle_test("_ZN5clang4Sema20CheckReturnStackAddrEPNS_4ExprENS_8QualTypeENS_14SourceLocationE", "clang::Sema::CheckReturnStackAddr(clang::Expr*, clang::QualType, clang::SourceLocation)"),
	mu_demangle_test("_Z8EvalAddrPN5clang4ExprERN4llvm15SmallVectorImplIPNS_11DeclRefExprEEE", "EvalAddr(clang::Expr*, llvm::SmallVectorImpl<clang::DeclRefExpr*>&)"),
	mu_demangle_test("_Z7EvalValPN5clang4ExprERN4llvm15SmallVectorImplIPNS_11DeclRefExprEEE", "EvalVal(clang::Expr*, llvm::SmallVectorImpl<clang::DeclRefExpr*>&)"),
	mu_demangle_test("_ZN5clang4Sema20CheckFloatComparisonENS_14SourceLocationEPNS_4ExprES3_", "clang::Sema::CheckFloatComparison(clang::SourceLocation, clang::Expr*, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema24CheckImplicitConversionsEPNS_4ExprENS_14SourceLocationE", "clang::Sema::CheckImplicitConversions(clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126AnalyzeImplicitConversionsERN5clang4SemaEPNS0_4ExprENS0_14SourceLocationE", "(anonymous namespace)::AnalyzeImplicitConversions(clang::Sema&, clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema27CheckBitFieldInitializationENS_14SourceLocationEPNS_9FieldDeclEPNS_4ExprE", "clang::Sema::CheckBitFieldInitialization(clang::SourceLocation, clang::FieldDecl*, clang::Expr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_125AnalyzeBitFieldAssignmentERN5clang4SemaEPNS0_9FieldDeclEPNS0_4ExprENS0_14SourceLocationE", "(anonymous namespace)::AnalyzeBitFieldAssignment(clang::Sema&, clang::FieldDecl*, clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema24CheckParmsForFunctionDefEPPNS_11ParmVarDeclES3_b", "clang::Sema::CheckParmsForFunctionDef(clang::ParmVarDecl**, clang::ParmVarDecl**, bool)"),
	mu_demangle_test("_ZN5clang4Sema14CheckCastAlignEPNS_4ExprENS_8QualTypeENS_11SourceRangeE", "clang::Sema::CheckCastAlign(clang::Expr*, clang::QualType, clang::SourceRange)"),
	mu_demangle_test("_ZN12_GLOBAL__N_124CheckConditionalOperatorERN5clang4SemaEPNS0_19ConditionalOperatorENS0_8QualTypeE", "(anonymous namespace)::CheckConditionalOperator(clang::Sema&, clang::ConditionalOperator*, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_123CheckImplicitConversionERN5clang4SemaEPNS0_4ExprENS0_8QualTypeENS0_14SourceLocationEPb", "(anonymous namespace)::CheckImplicitConversion(clang::Sema&, clang::Expr*, clang::QualType, clang::SourceLocation, bool*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_130CheckTrivialUnsignedComparisonERN5clang4SemaEPNS0_14BinaryOperatorE", "(anonymous namespace)::CheckTrivialUnsignedComparison(clang::Sema&, clang::BinaryOperator*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_112GetExprRangeERN5clang10ASTContextEPNS0_4ExprEj", "(anonymous namespace)::GetExprRange(clang::ASTContext&, clang::Expr*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113GetValueRangeERN5clang10ASTContextERNS0_7APValueENS0_8QualTypeEj", "(anonymous namespace)::GetValueRange(clang::ASTContext&, clang::APValue&, clang::QualType, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_18IntRange14forValueOfTypeERN5clang10ASTContextENS1_8QualTypeE", "(anonymous namespace)::IntRange::forValueOfType(clang::ASTContext&, clang::QualType)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113GetValueRangeERN5clang10ASTContextERN4llvm6APSIntEj", "(anonymous namespace)::GetValueRange(clang::ASTContext&, llvm::APSInt&, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_16IsZeroERN5clang4SemaEPNS0_4ExprE", "(anonymous namespace)::IsZero(clang::Sema&, clang::Expr*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_115DiagnoseImpCastERN5clang4SemaEPNS0_4ExprENS0_8QualTypeENS0_14SourceLocationEj", "(anonymous namespace)::DiagnoseImpCast(clang::Sema&, clang::Expr*, clang::QualType, clang::SourceLocation, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_120IsSameFloatAfterCastERKN5clang7APValueERKN4llvm12fltSemanticsES7_", "(anonymous namespace)::IsSameFloatAfterCast(clang::APValue const&, llvm::fltSemantics const&, llvm::fltSemantics const&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_123CheckConditionalOperandERN5clang4SemaEPNS0_4ExprENS0_8QualTypeENS0_14SourceLocationERb", "(anonymous namespace)::CheckConditionalOperand(clang::Sema&, clang::Expr*, clang::QualType, clang::SourceLocation, bool&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CheckScanfHandlerD0Ev", "(anonymous namespace)::CheckScanfHandler::~CheckScanfHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandler14HandleNullCharEPKc", "(anonymous namespace)::CheckFormatHandler::HandleNullChar(char const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandler21HandleInvalidPositionEPKcjN5clang21analyze_format_string15PositionContextE", "(anonymous namespace)::CheckFormatHandler::HandleInvalidPosition(char const*, unsigned int, clang::analyze_format_string::PositionContext)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandler18HandleZeroPositionEPKcj", "(anonymous namespace)::CheckFormatHandler::HandleZeroPosition(char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandler25HandleIncompleteSpecifierEPKcj", "(anonymous namespace)::CheckFormatHandler::HandleIncompleteSpecifier(char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CheckScanfHandler37HandleInvalidScanfConversionSpecifierERKN5clang13analyze_scanf14ScanfSpecifierEPKcj", "(anonymous namespace)::CheckScanfHandler::HandleInvalidScanfConversionSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CheckScanfHandler20HandleScanfSpecifierERKN5clang13analyze_scanf14ScanfSpecifierEPKcj", "(anonymous namespace)::CheckScanfHandler::HandleScanfSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_117CheckScanfHandler24HandleIncompleteScanListEPKcS2_", "(anonymous namespace)::CheckScanfHandler::HandleIncompleteScanList(char const*, char const*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandler12CheckNumArgsERKN5clang21analyze_format_string15FormatSpecifierERKNS2_19ConversionSpecifierEPKcjj", "(anonymous namespace)::CheckFormatHandler::CheckNumArgs(clang::analyze_format_string::FormatSpecifier const&, clang::analyze_format_string::ConversionSpecifier const&, char const*, unsigned int, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandler32HandleInvalidConversionSpecifierEjN5clang14SourceLocationEPKcjS4_j", "(anonymous namespace)::CheckFormatHandler::HandleInvalidConversionSpecifier(unsigned int, clang::SourceLocation, char const*, unsigned int, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandlerD1Ev", "(anonymous namespace)::CheckFormatHandler::~CheckFormatHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckFormatHandlerD0Ev", "(anonymous namespace)::CheckFormatHandler::~CheckFormatHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandlerD0Ev", "(anonymous namespace)::CheckPrintfHandler::~CheckPrintfHandler()"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandler38HandleInvalidPrintfConversionSpecifierERKN5clang14analyze_printf15PrintfSpecifierEPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleInvalidPrintfConversionSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandler21HandlePrintfSpecifierERKN5clang14analyze_printf15PrintfSpecifierEPKcj", "(anonymous namespace)::CheckPrintfHandler::HandlePrintfSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandler12HandleAmountERKN5clang21analyze_format_string14OptionalAmountEjPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleAmount(clang::analyze_format_string::OptionalAmount const&, unsigned int, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandler19HandleInvalidAmountERKN5clang14analyze_printf15PrintfSpecifierERKNS1_21analyze_format_string14OptionalAmountEjPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleInvalidAmount(clang::analyze_printf::PrintfSpecifier const&, clang::analyze_format_string::OptionalAmount const&, unsigned int, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandler10HandleFlagERKN5clang14analyze_printf15PrintfSpecifierERKNS1_21analyze_format_string12OptionalFlagEPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleFlag(clang::analyze_printf::PrintfSpecifier const&, clang::analyze_format_string::OptionalFlag const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckPrintfHandler17HandleIgnoredFlagERKN5clang14analyze_printf15PrintfSpecifierERKNS1_21analyze_format_string12OptionalFlagES9_PKcj", "(anonymous namespace)::CheckPrintfHandler::HandleIgnoredFlag(clang::analyze_printf::PrintfSpecifier const&, clang::analyze_format_string::OptionalFlag const&, clang::analyze_format_string::OptionalFlag const&, char const*, unsigned int)"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_13FormatArgAttrEEEPT_v", "clang::FormatArgAttr* clang::Decl::getAttr<clang::FormatArgAttr>() const"),
	mu_demangle_test("_ZN4llvm11SmallVectorItLj128EEC2EjRKt", "llvm::SmallVector<unsigned short, 128u>::SmallVector(unsigned int, unsigned short const&)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler38HandleInvalidPrintfConversionSpecifierERKNS_14analyze_printf15PrintfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleInvalidPrintfConversionSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler21HandlePrintfSpecifierERKNS_14analyze_printf15PrintfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandlePrintfSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler37HandleInvalidScanfConversionSpecifierERKNS_13analyze_scanf14ScanfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleInvalidScanfConversionSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler20HandleScanfSpecifierERKNS_13analyze_scanf14ScanfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleScanfSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler24HandleIncompleteScanListEPKcS3_", "clang::analyze_format_string::FormatStringHandler::HandleIncompleteScanList(char const*, char const*)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler14HandleNullCharEPKc", "clang::analyze_format_string::FormatStringHandler::HandleNullChar(char const*)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler21HandleInvalidPositionEPKcjNS0_15PositionContextE", "clang::analyze_format_string::FormatStringHandler::HandleInvalidPosition(char const*, unsigned int, clang::analyze_format_string::PositionContext)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler18HandleZeroPositionEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleZeroPosition(char const*, unsigned int)"),
	mu_demangle_test("_ZN5clang21analyze_format_string19FormatStringHandler25HandleIncompleteSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleIncompleteSpecifier(char const*, unsigned int)"),
	mu_demangle_test("_ZN5clang22getSimplifiedTypeClassENS_7CanQualINS_4TypeEEE", "clang::getSimplifiedTypeClass(clang::CanQual<clang::Type>)"),
	mu_demangle_test("_ZN5clang16getDeclUsageTypeERNS_10ASTContextEPNS_9NamedDeclE", "clang::getDeclUsageType(clang::ASTContext&, clang::NamedDecl*)"),
	mu_demangle_test("_Z23GetCompletionTypeStringN5clang8QualTypeERNS_10ASTContextERNS_23CodeCompletionAllocatorE", "GetCompletionTypeString(clang::QualType, clang::ASTContext&, clang::CodeCompletionAllocator&)"),
	mu_demangle_test("_ZN5clang20CodeCompletionResult26CreateCodeCompletionStringERNS_4SemaERNS_23CodeCompletionAllocatorE", "clang::CodeCompletionResult::CreateCodeCompletionString(clang::Sema&, clang::CodeCompletionAllocator&)"),
	mu_demangle_test("_Z18AddResultTypeChunkRN5clang10ASTContextEPNS_9NamedDeclERNS_21CodeCompletionBuilderE", "AddResultTypeChunk(clang::ASTContext&, clang::NamedDecl*, clang::CodeCompletionBuilder&)"),
	mu_demangle_test("_Z30AddQualifierToCompletionStringRN5clang21CodeCompletionBuilderEPNS_19NestedNameSpecifierEbRNS_10ASTContextE", "AddQualifierToCompletionString(clang::CodeCompletionBuilder&, clang::NestedNameSpecifier*, bool, clang::ASTContext&)"),
	mu_demangle_test("_Z17AddTypedNameChunkRN5clang10ASTContextEPNS_9NamedDeclERNS_21CodeCompletionBuilderE", "AddTypedNameChunk(clang::ASTContext&, clang::NamedDecl*, clang::CodeCompletionBuilder&)"),
	mu_demangle_test("_Z26AddFunctionParameterChunksRN5clang10ASTContextEPNS_12FunctionDeclERNS_21CodeCompletionBuilderEjb", "AddFunctionParameterChunks(clang::ASTContext&, clang::FunctionDecl*, clang::CodeCompletionBuilder&, unsigned int, bool)"),
	mu_demangle_test("_Z38AddFunctionTypeQualsToCompletionStringRN5clang21CodeCompletionBuilderEPNS_12FunctionDeclE", "AddFunctionTypeQualsToCompletionString(clang::CodeCompletionBuilder&, clang::FunctionDecl*)"),
	mu_demangle_test("_Z26AddTemplateParameterChunksRN5clang10ASTContextEPNS_12TemplateDeclERNS_21CodeCompletionBuilderEjjb", "AddTemplateParameterChunks(clang::ASTContext&, clang::TemplateDecl*, clang::CodeCompletionBuilder&, unsigned int, unsigned int, bool)"),
	mu_demangle_test("_Z23FormatFunctionParameterRN5clang10ASTContextEPNS_11ParmVarDeclEb", "FormatFunctionParameter(clang::ASTContext&, clang::ParmVarDecl*, bool)"),
	mu_demangle_test("_Z16MaybeAddSentinelRN5clang10ASTContextEPNS_9NamedDeclERNS_21CodeCompletionBuilderE", "MaybeAddSentinel(clang::ASTContext&, clang::NamedDecl*, clang::CodeCompletionBuilder&)"),
	mu_demangle_test("_ZNK5clang20CodeCompleteConsumer17OverloadCandidate21CreateSignatureStringEjRNS_4SemaERNS_23CodeCompletionAllocatorE", "clang::CodeCompleteConsumer::OverloadCandidate::CreateSignatureString(unsigned int, clang::Sema&, clang::CodeCompletionAllocator&) const"),
	mu_demangle_test("_ZN5clang21getMacroUsagePriorityEN4llvm9StringRefERKNS_11LangOptionsEb", "clang::getMacroUsagePriority(llvm::StringRef, clang::LangOptions const&, bool)"),
	mu_demangle_test("_ZN5clang20getCursorKindForDeclEPNS_4DeclE", "clang::getCursorKindForDecl(clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema24CodeCompleteOrdinaryNameEPNS_5ScopeENS0_23ParserCompletionContextE", "clang::Sema::CodeCompleteOrdinaryName(clang::Scope*, clang::Sema::ParserCompletionContext)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ResultBuilder13EnterNewScopeEv", "(anonymous namespace)::ResultBuilder::EnterNewScope()"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder22IsOrdinaryNonValueNameEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsOrdinaryNonValueName(clang::NamedDecl*) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder14IsOrdinaryNameEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsOrdinaryName(clang::NamedDecl*) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder21IsOrdinaryNonTypeNameEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsOrdinaryNonTypeName(clang::NamedDecl*) const"),
	mu_demangle_test("_Z21MaybeAddOverrideCallsRN5clang4SemaEPNS_11DeclContextERN12_GLOBAL__N_113ResultBuilderE", "MaybeAddOverrideCalls(clang::Sema&, clang::DeclContext*, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_Z22AddOrdinaryNameResultsN5clang4Sema23ParserCompletionContextEPNS_5ScopeERS0_RN12_GLOBAL__N_113ResultBuilderE", "AddOrdinaryNameResults(clang::Sema::ParserCompletionContext, clang::Scope*, clang::Sema&, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ResultBuilder9ExitScopeEv", "(anonymous namespace)::ResultBuilder::ExitScope()"),
	mu_demangle_test("_Z24AddPrettyFunctionResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddPrettyFunctionResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_Z15AddMacroResultsRN5clang12PreprocessorERN12_GLOBAL__N_113ResultBuilderEb", "AddMacroResults(clang::Preprocessor&, (anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126CodeCompletionDeclConsumerD1Ev", "(anonymous namespace)::CodeCompletionDeclConsumer::~CodeCompletionDeclConsumer()"),
	mu_demangle_test("_ZN5clang4Sema20CodeCompleteDeclSpecEPNS_5ScopeERNS_8DeclSpecEbb", "clang::Sema::CodeCompleteDeclSpec(clang::Scope*, clang::DeclSpec&, bool, bool)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder21IsImpossibleToSatisfyEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsImpossibleToSatisfy(clang::NamedDecl*) const"),
	mu_demangle_test("_Z26AddClassMessageCompletionsRN5clang4SemaEPNS_5ScopeENS_9OpaquePtrINS_8QualTypeEEEPPNS_14IdentifierInfoEjbbRN12_GLOBAL__N_113ResultBuilderE", "AddClassMessageCompletions(clang::Sema&, clang::Scope*, clang::OpaquePtr<clang::QualType>, clang::IdentifierInfo**, unsigned int, bool, bool, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZN5clang4Sema22CodeCompleteExpressionEPNS_5ScopeERKNS0_26CodeCompleteExpressionDataE", "clang::Sema::CodeCompleteExpression(clang::Scope*, clang::Sema::CodeCompleteExpressionData const&)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder16IsObjCCollectionEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsObjCCollection(clang::NamedDecl*) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder23IsIntegralConstantValueEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsIntegralConstantValue(clang::NamedDecl*) const"),
	mu_demangle_test("_ZN5clang4Sema29CodeCompletePostfixExpressionEPNS_5ScopeENS_12ActionResultIPNS_4ExprELb1EEE", "clang::Sema::CodeCompletePostfixExpression(clang::Scope*, clang::ActionResult<clang::Expr*, true>)"),
	mu_demangle_test("_ZN5clang4Sema31CodeCompleteObjCInstanceMessageEPNS_5ScopeEPNS_4ExprEPPNS_14IdentifierInfoEjbPNS_17ObjCInterfaceDeclE", "clang::Sema::CodeCompleteObjCInstanceMessage(clang::Scope*, clang::Expr*, clang::IdentifierInfo**, unsigned int, bool, clang::ObjCInterfaceDecl*)"),
	mu_demangle_test("_ZN5clang4Sema31CodeCompleteMemberReferenceExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationEb", "clang::Sema::CodeCompleteMemberReferenceExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, bool)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder8IsMemberEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsMember(clang::NamedDecl*) const"),
	mu_demangle_test("_Z17AddObjCPropertiesPN5clang17ObjCContainerDeclEbPNS_11DeclContextERN4llvm11SmallPtrSetIPNS_14IdentifierInfoELj16EEERN12_GLOBAL__N_113ResultBuilderE", "AddObjCProperties(clang::ObjCContainerDecl*, bool, clang::DeclContext*, llvm::SmallPtrSet<clang::IdentifierInfo*, 16u>&, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder10IsObjCIvarEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsObjCIvar(clang::NamedDecl*) const"),
	mu_demangle_test("_ZN5clang4Sema15CodeCompleteTagEPNS_5ScopeEj", "clang::Sema::CodeCompleteTag(clang::Scope*, unsigned int)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder6IsEnumEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsEnum(clang::NamedDecl*) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder7IsUnionEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsUnion(clang::NamedDecl*) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder15IsClassOrStructEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsClassOrStruct(clang::NamedDecl*) const"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder21IsNestedNameSpecifierEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsNestedNameSpecifier(clang::NamedDecl*) const"),
	mu_demangle_test("_ZN5clang4Sema26CodeCompleteTypeQualifiersERNS_8DeclSpecE", "clang::Sema::CodeCompleteTypeQualifiers(clang::DeclSpec&)"),
	mu_demangle_test("_ZN5clang4Sema16CodeCompleteCaseEPNS_5ScopeE", "clang::Sema::CodeCompleteCase(clang::Scope*)"),
	mu_demangle_test("_Z24getRequiredQualificationRN5clang10ASTContextEPNS_11DeclContextES3_", "getRequiredQualification(clang::ASTContext&, clang::DeclContext*, clang::DeclContext*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ResultBuilder9AddResultEN5clang20CodeCompletionResultEPNS1_11DeclContextEPNS1_9NamedDeclEb", "(anonymous namespace)::ResultBuilder::AddResult(clang::CodeCompletionResult, clang::DeclContext*, clang::NamedDecl*, bool)"),
	mu_demangle_test("_ZN5clang4Sema16CodeCompleteCallEPNS_5ScopeEPNS_4ExprEPS4_j", "clang::Sema::CodeCompleteCall(clang::Scope*, clang::Expr*, clang::Expr**, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema23CodeCompleteInitializerEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteInitializer(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema18CodeCompleteReturnEPNS_5ScopeE", "clang::Sema::CodeCompleteReturn(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema25CodeCompleteAssignmentRHSEPNS_5ScopeEPNS_4ExprE", "clang::Sema::CodeCompleteAssignmentRHS(clang::Scope*, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema23CodeCompleteQualifiedIdEPNS_5ScopeERNS_12CXXScopeSpecEb", "clang::Sema::CodeCompleteQualifiedId(clang::Scope*, clang::CXXScopeSpec&, bool)"),
	mu_demangle_test("_ZN5clang4Sema17CodeCompleteUsingEPNS_5ScopeE", "clang::Sema::CodeCompleteUsing(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema26CodeCompleteUsingDirectiveEPNS_5ScopeE", "clang::Sema::CodeCompleteUsingDirective(clang::Scope*)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder18IsNamespaceOrAliasEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsNamespaceOrAlias(clang::NamedDecl*) const"),
	mu_demangle_test("_ZN5clang4Sema25CodeCompleteNamespaceDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteNamespaceDecl(clang::Scope*)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder11IsNamespaceEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsNamespace(clang::NamedDecl*) const"),
	mu_demangle_test("_ZN5clang4Sema30CodeCompleteNamespaceAliasDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteNamespaceAliasDecl(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema24CodeCompleteOperatorNameEPNS_5ScopeE", "clang::Sema::CodeCompleteOperatorName(clang::Scope*)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder6IsTypeEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsType(clang::NamedDecl*) const"),
	mu_demangle_test("_Z23AddTypeSpecifierResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddTypeSpecifierResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZN5clang4Sema34CodeCompleteConstructorInitializerEPNS_4DeclEPPNS_18CXXCtorInitializerEj", "clang::Sema::CodeCompleteConstructorInitializer(clang::Decl*, clang::CXXCtorInitializer**, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema27CodeCompleteObjCAtDirectiveEPNS_5ScopeEPNS_4DeclEb", "clang::Sema::CodeCompleteObjCAtDirective(clang::Scope*, clang::Decl*, bool)"),
	mu_demangle_test("_Z28AddObjCImplementationResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderEb", "AddObjCImplementationResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_Z23AddObjCInterfaceResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderEb", "AddObjCInterfaceResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_Z22AddObjCTopLevelResultsRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCTopLevelResults((anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_ZN5clang4Sema28CodeCompleteObjCAtVisibilityEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCAtVisibility(clang::Scope*)"),
	mu_demangle_test("_Z24AddObjCVisibilityResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderEb", "AddObjCVisibilityResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_ZN5clang4Sema27CodeCompleteObjCAtStatementEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCAtStatement(clang::Scope*)"),
	mu_demangle_test("_Z23AddObjCStatementResultsRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCStatementResults((anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_Z24AddObjCExpressionResultsRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCExpressionResults((anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_ZN5clang4Sema28CodeCompleteObjCAtExpressionEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCAtExpression(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema29CodeCompleteObjCPropertyFlagsEPNS_5ScopeERNS_12ObjCDeclSpecE", "clang::Sema::CodeCompleteObjCPropertyFlags(clang::Scope*, clang::ObjCDeclSpec&)"),
	mu_demangle_test("_ZN5clang4Sema30CodeCompleteObjCPropertyGetterEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertyGetter(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_Z14AddObjCMethodsPN5clang17ObjCContainerDeclEb14ObjCMethodKindPPNS_14IdentifierInfoEjPNS_11DeclContextERN4llvm11SmallPtrSetINS_8SelectorELj16EEEbRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCMethods(clang::ObjCContainerDecl*, bool, ObjCMethodKind, clang::IdentifierInfo**, unsigned int, clang::DeclContext*, llvm::SmallPtrSet<clang::Selector, 16u>&, bool, (anonymous namespace)::ResultBuilder&, bool)"),
	mu_demangle_test("_ZN5clang4Sema30CodeCompleteObjCPropertySetterEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertySetter(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema27CodeCompleteObjCPassingTypeEPNS_5ScopeERNS_12ObjCDeclSpecE", "clang::Sema::CodeCompleteObjCPassingType(clang::Scope*, clang::ObjCDeclSpec&)"),
	mu_demangle_test("_ZN5clang4Sema31CodeCompleteObjCMessageReceiverEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCMessageReceiver(clang::Scope*)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder21IsObjCMessageReceiverEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsObjCMessageReceiver(clang::NamedDecl*) const"),
	mu_demangle_test("_Z22AddSuperSendCompletionRN5clang4SemaEbPPNS_14IdentifierInfoEjRN12_GLOBAL__N_113ResultBuilderE", "AddSuperSendCompletion(clang::Sema&, bool, clang::IdentifierInfo**, unsigned int, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZN5clang4Sema28CodeCompleteObjCSuperMessageEPNS_5ScopeENS_14SourceLocationEPPNS_14IdentifierInfoEjb", "clang::Sema::CodeCompleteObjCSuperMessage(clang::Scope*, clang::SourceLocation, clang::IdentifierInfo**, unsigned int, bool)"),
	mu_demangle_test("_ZN5clang4Sema28CodeCompleteObjCClassMessageEPNS_5ScopeENS_9OpaquePtrINS_8QualTypeEEEPPNS_14IdentifierInfoEjbb", "clang::Sema::CodeCompleteObjCClassMessage(clang::Scope*, clang::OpaquePtr<clang::QualType>, clang::IdentifierInfo**, unsigned int, bool, bool)"),
	mu_demangle_test("_Z38getPreferredArgumentTypeForMessageSendRN12_GLOBAL__N_113ResultBuilderEj", "getPreferredArgumentTypeForMessageSend((anonymous namespace)::ResultBuilder&, unsigned int)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ResultBuilder14MaybeAddResultEN5clang20CodeCompletionResultEPNS1_11DeclContextE", "(anonymous namespace)::ResultBuilder::MaybeAddResult(clang::CodeCompletionResult, clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang4Sema29CodeCompleteObjCForCollectionEPNS_5ScopeENS_9OpaquePtrINS_12DeclGroupRefEEE", "clang::Sema::CodeCompleteObjCForCollection(clang::Scope*, clang::OpaquePtr<clang::DeclGroupRef>)"),
	mu_demangle_test("_ZN5clang4Sema24CodeCompleteObjCSelectorEPNS_5ScopeEPPNS_14IdentifierInfoEj", "clang::Sema::CodeCompleteObjCSelector(clang::Scope*, clang::IdentifierInfo**, unsigned int)"),
	mu_demangle_test("_Z24isAcceptableObjCSelectorN5clang8SelectorE14ObjCMethodKindPPNS_14IdentifierInfoEjb", "isAcceptableObjCSelector(clang::Selector, ObjCMethodKind, clang::IdentifierInfo**, unsigned int, bool)"),
	mu_demangle_test("_ZN5clang4Sema34CodeCompleteObjCProtocolReferencesEPSt4pairIPNS_14IdentifierInfoENS_14SourceLocationEEj", "clang::Sema::CodeCompleteObjCProtocolReferences(std::pair<clang::IdentifierInfo*, clang::SourceLocation>*, unsigned int)"),
	mu_demangle_test("_Z18AddProtocolResultsPN5clang11DeclContextES1_bRN12_GLOBAL__N_113ResultBuilderE", "AddProtocolResults(clang::DeclContext*, clang::DeclContext*, bool, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZN5clang4Sema28CodeCompleteObjCProtocolDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCProtocolDecl(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema29CodeCompleteObjCInterfaceDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCInterfaceDecl(clang::Scope*)"),
	mu_demangle_test("_Z19AddInterfaceResultsPN5clang11DeclContextES1_bbRN12_GLOBAL__N_113ResultBuilderE", "AddInterfaceResults(clang::DeclContext*, clang::DeclContext*, bool, bool, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZN5clang4Sema26CodeCompleteObjCSuperclassEPNS_5ScopeEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::CodeCompleteObjCSuperclass(clang::Scope*, clang::IdentifierInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema34CodeCompleteObjCImplementationDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCImplementationDecl(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema33CodeCompleteObjCInterfaceCategoryEPNS_5ScopeEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::CodeCompleteObjCInterfaceCategory(clang::Scope*, clang::IdentifierInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema38CodeCompleteObjCImplementationCategoryEPNS_5ScopeEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::CodeCompleteObjCImplementationCategory(clang::Scope*, clang::IdentifierInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema34CodeCompleteObjCPropertyDefinitionEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertyDefinition(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema38CodeCompleteObjCPropertySynthesizeIvarEPNS_5ScopeEPNS_14IdentifierInfoEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertySynthesizeIvar(clang::Scope*, clang::IdentifierInfo*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema26CodeCompleteObjCMethodDeclEPNS_5ScopeEbNS_9OpaquePtrINS_8QualTypeEEEPNS_4DeclE", "clang::Sema::CodeCompleteObjCMethodDecl(clang::Scope*, bool, clang::OpaquePtr<clang::QualType>, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema34CodeCompleteObjCMethodDeclSelectorEPNS_5ScopeEbbNS_9OpaquePtrINS_8QualTypeEEEPPNS_14IdentifierInfoEj", "clang::Sema::CodeCompleteObjCMethodDeclSelector(clang::Scope*, bool, bool, clang::OpaquePtr<clang::QualType>, clang::IdentifierInfo**, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema33CodeCompletePreprocessorDirectiveEb", "clang::Sema::CodeCompletePreprocessorDirective(bool)"),
	mu_demangle_test("_ZN5clang4Sema46CodeCompleteInPreprocessorConditionalExclusionEPNS_5ScopeE", "clang::Sema::CodeCompleteInPreprocessorConditionalExclusion(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema33CodeCompletePreprocessorMacroNameEb", "clang::Sema::CodeCompletePreprocessorMacroName(bool)"),
	mu_demangle_test("_ZN5clang4Sema34CodeCompletePreprocessorExpressionEv", "clang::Sema::CodeCompletePreprocessorExpression()"),
	mu_demangle_test("_ZN5clang4Sema37CodeCompletePreprocessorMacroArgumentEPNS_5ScopeEPNS_14IdentifierInfoEPNS_9MacroInfoEj", "clang::Sema::CodeCompletePreprocessorMacroArgument(clang::Scope*, clang::IdentifierInfo*, clang::MacroInfo*, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema27CodeCompleteNaturalLanguageEv", "clang::Sema::CodeCompleteNaturalLanguage()"),
	mu_demangle_test("_ZN5clang4Sema27GatherGlobalCodeCompletionsERNS_23CodeCompletionAllocatorERN4llvm15SmallVectorImplINS_20CodeCompletionResultEEE", "clang::Sema::GatherGlobalCodeCompletions(clang::CodeCompletionAllocator&, llvm::SmallVectorImpl<clang::CodeCompletionResult>&)"),
	mu_demangle_test("_ZSt21__inplace_stable_sortIPN5clang17OverloadCandidateEN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_", "void std::__inplace_stable_sort<clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"),
	mu_demangle_test("_ZSt22__stable_sort_adaptiveIPN5clang17OverloadCandidateES2_lN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_T1_T2_", "void std::__stable_sort_adaptive<clang::OverloadCandidate*, clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate)"),
	mu_demangle_test("_ZSt24__merge_sort_with_bufferIPN5clang17OverloadCandidateES2_N12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_T1_", "void std::__merge_sort_with_buffer<clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"),
	mu_demangle_test("_ZSt16__merge_adaptiveIPN5clang17OverloadCandidateElS2_N12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_S5_T0_S6_T1_S6_T2_", "void std::__merge_adaptive<clang::OverloadCandidate*, long, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, long, clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate)"),
	mu_demangle_test("_ZSt5mergeIPN5clang17OverloadCandidateES2_S2_N12_GLOBAL__N_125IsBetterOverloadCandidateEET1_T_S6_T0_S7_S5_T2_", "clang::OverloadCandidate* std::merge<clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"),
	mu_demangle_test("_ZSt16__insertion_sortIPN5clang17OverloadCandidateEN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_", "void std::__insertion_sort<clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"),
	mu_demangle_test("_ZSt22__merge_without_bufferIPN5clang17OverloadCandidateElN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_S5_T0_S6_T1_", "void std::__merge_without_buffer<clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, long, (anonymous namespace)::IsBetterOverloadCandidate)"),
	mu_demangle_test("_ZNK12_GLOBAL__N_113ResultBuilder17isInterestingDeclEPN5clang9NamedDeclERb", "(anonymous namespace)::ResultBuilder::isInterestingDecl(clang::NamedDecl*, bool&) const"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ResultBuilder17CheckHiddenResultERN5clang20CodeCompletionResultEPNS1_11DeclContextEPNS1_9NamedDeclE", "(anonymous namespace)::ResultBuilder::CheckHiddenResult(clang::CodeCompletionResult&, clang::DeclContext*, clang::NamedDecl*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ResultBuilder27AdjustResultPriorityForDeclERN5clang20CodeCompletionResultE", "(anonymous namespace)::ResultBuilder::AdjustResultPriorityForDecl(clang::CodeCompletionResult&)"),
	mu_demangle_test("_ZN12_GLOBAL__N_113ResultBuilder26MaybeAddConstructorResultsEN5clang20CodeCompletionResultE", "(anonymous namespace)::ResultBuilder::MaybeAddConstructorResults(clang::CodeCompletionResult)"),
	mu_demangle_test("_ZN12_GLOBAL__N_126CodeCompletionDeclConsumerD0Ev", "(anonymous namespace)::CodeCompletionDeclConsumer::~CodeCompletionDeclConsumer()"),
	mu_demangle_test("_ZN12_GLOBAL__N_126CodeCompletionDeclConsumer9FoundDeclEPN5clang9NamedDeclES3_b", "(anonymous namespace)::CodeCompletionDeclConsumer::FoundDecl(clang::NamedDecl*, clang::NamedDecl*, bool)"),
	mu_demangle_test("_Z16AddTypedefResultRN12_GLOBAL__N_113ResultBuilderE", "AddTypedefResult((anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_Z20AddStorageSpecifiersN5clang4Sema23ParserCompletionContextERKNS_11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddStorageSpecifiers(clang::Sema::ParserCompletionContext, clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_Z21AddFunctionSpecifiersN5clang4Sema23ParserCompletionContextERKNS_11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddFunctionSpecifiers(clang::Sema::ParserCompletionContext, clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"),
	mu_demangle_test("_ZNSt17_Temporary_bufferIPN5clang17OverloadCandidateES1_ED2Ev", "std::_Temporary_buffer<clang::OverloadCandidate*, clang::OverloadCandidate>::~_Temporary_buffer()"),
	mu_demangle_test("_ZSt17__rotate_adaptiveIPN5clang17OverloadCandidateES2_lET_S3_S3_S3_T1_S4_T0_S4_", "clang::OverloadCandidate* std::__rotate_adaptive<clang::OverloadCandidate*, clang::OverloadCandidate*, long>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, long, clang::OverloadCandidate*, long)"),
	mu_demangle_test("_ZSt8__rotateIPN5clang17OverloadCandidateEEvT_S3_S3_St26random_access_iterator_tag", "void std::__rotate<clang::OverloadCandidate*>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, std::random_access_iterator_tag)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang26ImplicitConversionSequenceEEaSERKS3_", "llvm::SmallVectorImpl<clang::ImplicitConversionSequence>::operator=(llvm::SmallVectorImpl<clang::ImplicitConversionSequence> const&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang26ImplicitConversionSequenceELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ImplicitConversionSequence, false>::grow(unsigned long)"),
	mu_demangle_test("_ZSt4swapIN5clang17OverloadCandidateEEvRT_S3_", "void std::swap<clang::OverloadCandidate>(clang::OverloadCandidate&, clang::OverloadCandidate&)"),
	mu_demangle_test("_ZNSt15__copy_backwardILb0ESt26random_access_iterator_tagE8__copy_bIPN5clang17OverloadCandidateES5_EET0_T_S7_S6_", "clang::OverloadCandidate* std::__copy_backward<false, std::random_access_iterator_tag>::__copy_b<clang::OverloadCandidate*, clang::OverloadCandidate*>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*)"),
	mu_demangle_test("_ZNSt6__copyILb0ESt26random_access_iterator_tagE4copyIPN5clang17OverloadCandidateES5_EET0_T_S7_S6_", "clang::OverloadCandidate* std::__copy<false, std::random_access_iterator_tag>::copy<clang::OverloadCandidate*, clang::OverloadCandidate*>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*)"),
	mu_demangle_test("_ZSt26__uninitialized_fill_n_auxIPN5clang17OverloadCandidateElS1_EvT_T0_RKT1_St12__false_type", "void std::__uninitialized_fill_n_aux<clang::OverloadCandidate*, long, clang::OverloadCandidate>(clang::OverloadCandidate*, long, clang::OverloadCandidate const&, std::__false_type)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang20CodeCompleteConsumer17OverloadCandidateELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeCompleteConsumer::OverloadCandidate, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIN5clang17OverloadCandidateEED2Ev", "llvm::SmallVectorImpl<clang::OverloadCandidate>::~SmallVectorImpl()"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_12SentinelAttrEEEPT_v", "clang::SentinelAttr* clang::Decl::getAttr<clang::SentinelAttr>() const"),
	mu_demangle_test("_ZN5clang4Sema22ConvertDeclToDeclGroupEPNS_4DeclE", "clang::Sema::ConvertDeclToDeclGroup(clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema11getTypeNameERNS_14IdentifierInfoENS_14SourceLocationEPNS_5ScopeEPNS_12CXXScopeSpecEbbNS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::getTypeName(clang::IdentifierInfo&, clang::SourceLocation, clang::Scope*, clang::CXXScopeSpec*, bool, bool, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZN5clang4Sema9isTagNameERNS_14IdentifierInfoEPNS_5ScopeE", "clang::Sema::isTagName(clang::IdentifierInfo&, clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema23DiagnoseUnknownTypeNameERKNS_14IdentifierInfoENS_14SourceLocationEPNS_5ScopeEPNS_12CXXScopeSpecERNS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::DiagnoseUnknownTypeName(clang::IdentifierInfo const&, clang::SourceLocation, clang::Scope*, clang::CXXScopeSpec*, clang::OpaquePtr<clang::QualType>&)"),
	mu_demangle_test("_ZN5clang4Sema15getContainingDCEPNS_11DeclContextE", "clang::Sema::getContainingDC(clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang4Sema15PushDeclContextEPNS_5ScopeEPNS_11DeclContextE", "clang::Sema::PushDeclContext(clang::Scope*, clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang4Sema14PopDeclContextEv", "clang::Sema::PopDeclContext()"),
	mu_demangle_test("_ZN5clang4Sema22EnterDeclaratorContextEPNS_5ScopeEPNS_11DeclContextE", "clang::Sema::EnterDeclaratorContext(clang::Scope*, clang::DeclContext*)"),
	mu_demangle_test("_ZN5clang4Sema21ExitDeclaratorContextEPNS_5ScopeE", "clang::Sema::ExitDeclaratorContext(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema17PushOnScopeChainsEPNS_9NamedDeclEPNS_5ScopeEb", "clang::Sema::PushOnScopeChains(clang::NamedDecl*, clang::Scope*, bool)"),
	mu_demangle_test("_ZN5clang4Sema13isDeclInScopeERPNS_9NamedDeclEPNS_11DeclContextEPNS_5ScopeE", "clang::Sema::isDeclInScope(clang::NamedDecl*&, clang::DeclContext*, clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema22getScopeForDeclContextEPNS_5ScopeEPNS_11DeclContextE", "clang::Sema::getScopeForDeclContext(clang::Scope*, clang::DeclContext*)"),
	mu_demangle_test("_ZNK5clang4Sema32ShouldWarnIfUnusedFileScopedDeclEPKNS_14DeclaratorDeclE", "clang::Sema::ShouldWarnIfUnusedFileScopedDecl(clang::DeclaratorDecl const*) const"),
	mu_demangle_test("_ZN5clang4Sema24MarkUnusedFileScopedDeclEPKNS_14DeclaratorDeclE", "clang::Sema::MarkUnusedFileScopedDecl(clang::DeclaratorDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema18DiagnoseUnusedDeclEPKNS_9NamedDeclE", "clang::Sema::DiagnoseUnusedDecl(clang::NamedDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema13ActOnPopScopeENS_14SourceLocationEPNS_5ScopeE", "clang::Sema::ActOnPopScope(clang::SourceLocation, clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema20getObjCInterfaceDeclERPNS_14IdentifierInfoENS_14SourceLocationEb", "clang::Sema::getObjCInterfaceDecl(clang::IdentifierInfo*&, clang::SourceLocation, bool)"),
	mu_demangle_test("_ZN5clang4Sema20getNonFieldDeclScopeEPNS_5ScopeE", "clang::Sema::getNonFieldDeclScope(clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema19LazilyCreateBuiltinEPNS_14IdentifierInfoEjPNS_5ScopeEbNS_14SourceLocationE", "clang::Sema::LazilyCreateBuiltin(clang::IdentifierInfo*, unsigned int, clang::Scope*, bool, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema26AddKnownFunctionAttributesEPNS_12FunctionDeclE", "clang::Sema::AddKnownFunctionAttributes(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema16MergeTypeDefDeclEPNS_11TypedefDeclERNS_12LookupResultE", "clang::Sema::MergeTypeDefDecl(clang::TypedefDecl*, clang::LookupResult&)"),
	mu_demangle_test("_ZN5clang4Sema16getSpecialMemberEPKNS_13CXXMethodDeclE", "clang::Sema::getSpecialMember(clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema17MergeFunctionDeclEPNS_12FunctionDeclEPNS_4DeclE", "clang::Sema::MergeFunctionDecl(clang::FunctionDecl*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema28MergeCompatibleFunctionDeclsEPNS_12FunctionDeclES2_", "clang::Sema::MergeCompatibleFunctionDecls(clang::FunctionDecl*, clang::FunctionDecl*)"),
	mu_demangle_test("_Z19MergeDeclAttributesPN5clang4DeclES1_RNS_10ASTContextE", "MergeDeclAttributes(clang::Decl*, clang::Decl*, clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang4Sema12MergeVarDeclEPNS_7VarDeclERNS_12LookupResultE", "clang::Sema::MergeVarDecl(clang::VarDecl*, clang::LookupResult&)"),
	mu_demangle_test("_ZN5clang4Sema26ParsedFreeStandingDeclSpecEPNS_5ScopeENS_15AccessSpecifierERNS_8DeclSpecE", "clang::Sema::ParsedFreeStandingDeclSpec(clang::Scope*, clang::AccessSpecifier, clang::DeclSpec&)"),
	mu_demangle_test("_ZN5clang4Sema27BuildAnonymousStructOrUnionEPNS_5ScopeERNS_8DeclSpecENS_15AccessSpecifierEPNS_10RecordDeclE", "clang::Sema::BuildAnonymousStructOrUnion(clang::Scope*, clang::DeclSpec&, clang::AccessSpecifier, clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema30BuildMicrosoftCAnonymousStructEPNS_5ScopeERNS_8DeclSpecEPNS_10RecordDeclE", "clang::Sema::BuildMicrosoftCAnonymousStruct(clang::Scope*, clang::DeclSpec&, clang::RecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema12ActOnVlaStmtERKNS_8DeclSpecE", "clang::Sema::ActOnVlaStmt(clang::DeclSpec const&)"),
	mu_demangle_test("_ZN5clang4Sema20CheckNontrivialFieldEPNS_9FieldDeclE", "clang::Sema::CheckNontrivialField(clang::FieldDecl*)"),
	mu_demangle_test("_Z35InjectAnonymousStructOrUnionMembersRN5clang4SemaEPNS_5ScopeEPNS_11DeclContextEPNS_10RecordDeclENS_15AccessSpecifierERN4llvm11SmallVectorIPNS_9NamedDeclELj2EEEb", "InjectAnonymousStructOrUnionMembers(clang::Sema&, clang::Scope*, clang::DeclContext*, clang::RecordDecl*, clang::AccessSpecifier, llvm::SmallVector<clang::NamedDecl*, 2u>&, bool)"),
	mu_demangle_test("_ZN5clang4Sema20GetNameForDeclaratorERNS_10DeclaratorE", "clang::Sema::GetNameForDeclarator(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema24GetNameFromUnqualifiedIdERKNS_13UnqualifiedIdE", "clang::Sema::GetNameFromUnqualifiedId(clang::UnqualifiedId const&)"),
	mu_demangle_test("_ZN5clang4Sema15ActOnDeclaratorEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnDeclarator(clang::Scope*, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema16HandleDeclaratorEPNS_5ScopeERNS_10DeclaratorENS_11ASTMultiPtrIPNS_21TemplateParameterListEEEb", "clang::Sema::HandleDeclarator(clang::Scope*, clang::Declarator&, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnTypedefDeclaratorEPNS_5ScopeERNS_10DeclaratorEPNS_11DeclContextENS_8QualTypeEPNS_14TypeSourceInfoERNS_12LookupResultERb", "clang::Sema::ActOnTypedefDeclarator(clang::Scope*, clang::Declarator&, clang::DeclContext*, clang::QualType, clang::TypeSourceInfo*, clang::LookupResult&, bool&)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnFunctionDeclaratorEPNS_5ScopeERNS_10DeclaratorEPNS_11DeclContextENS_8QualTypeEPNS_14TypeSourceInfoERNS_12LookupResultENS_11ASTMultiPtrIPNS_21TemplateParameterListEEEbRb", "clang::Sema::ActOnFunctionDeclarator(clang::Scope*, clang::Declarator&, clang::DeclContext*, clang::QualType, clang::TypeSourceInfo*, clang::LookupResult&, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool, bool&)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnVariableDeclaratorEPNS_5ScopeERNS_10DeclaratorEPNS_11DeclContextENS_8QualTypeEPNS_14TypeSourceInfoERNS_12LookupResultENS_11ASTMultiPtrIPNS_21TemplateParameterListEEERb", "clang::Sema::ActOnVariableDeclarator(clang::Scope*, clang::Declarator&, clang::DeclContext*, clang::QualType, clang::TypeSourceInfo*, clang::LookupResult&, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool&)"),
	mu_demangle_test("_ZN5clang4Sema32RegisterLocallyScopedExternCDeclEPNS_9NamedDeclERKNS_12LookupResultEPNS_5ScopeE", "clang::Sema::RegisterLocallyScopedExternCDecl(clang::NamedDecl*, clang::LookupResult const&, clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema26DiagnoseFunctionSpecifiersERNS_10DeclaratorE", "clang::Sema::DiagnoseFunctionSpecifiers(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema16ParseTypedefDeclEPNS_5ScopeERNS_10DeclaratorENS_8QualTypeEPNS_14TypeSourceInfoE", "clang::Sema::ParseTypedefDecl(clang::Scope*, clang::Declarator&, clang::QualType, clang::TypeSourceInfo*)"),
	mu_demangle_test("_Z35TryToFixInvalidVariablyModifiedTypeN5clang8QualTypeERNS_10ASTContextERbRN4llvm6APSIntE", "TryToFixInvalidVariablyModifiedType(clang::QualType, clang::ASTContext&, bool&, llvm::APSInt&)"),
	mu_demangle_test("_Z20FilterLookupForScopeRN5clang4SemaERNS_12LookupResultEPNS_11DeclContextEPNS_5ScopeEb", "FilterLookupForScope(clang::Sema&, clang::LookupResult&, clang::DeclContext*, clang::Scope*, bool)"),
	mu_demangle_test("_ZN5clang4Sema11CheckShadowEPNS_5ScopeEPNS_7VarDeclERKNS_12LookupResultE", "clang::Sema::CheckShadow(clang::Scope*, clang::VarDecl*, clang::LookupResult const&)"),
	mu_demangle_test("_ZN5clang4Sema24CheckVariableDeclarationEPNS_7VarDeclERNS_12LookupResultERb", "clang::Sema::CheckVariableDeclaration(clang::VarDecl*, clang::LookupResult&, bool&)"),
	mu_demangle_test("_ZN5clang4Sema11CheckShadowEPNS_5ScopeEPNS_7VarDeclE", "clang::Sema::CheckShadow(clang::Scope*, clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang4Sema20AddOverriddenMethodsEPNS_13CXXRecordDeclEPNS_13CXXMethodDeclE", "clang::Sema::AddOverriddenMethods(clang::CXXRecordDecl*, clang::CXXMethodDecl*)"),
	mu_demangle_test("_Z20FindOverriddenMethodPKN5clang16CXXBaseSpecifierERNS_11CXXBasePathEPv", "FindOverriddenMethod(clang::CXXBaseSpecifier const*, clang::CXXBasePath&, void*)"),
	mu_demangle_test("_ZN5clang4Sema26BuildParmVarDeclForTypedefEPNS_11DeclContextENS_14SourceLocationENS_8QualTypeE", "clang::Sema::BuildParmVarDeclForTypedef(clang::DeclContext*, clang::SourceLocation, clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema24CheckFunctionDeclarationEPNS_5ScopeEPNS_12FunctionDeclERNS_12LookupResultEbRb", "clang::Sema::CheckFunctionDeclaration(clang::Scope*, clang::FunctionDecl*, clang::LookupResult&, bool, bool&)"),
	mu_demangle_test("_Z28DiagnoseInvalidRedeclarationRN5clang4SemaEPNS_12FunctionDeclE", "DiagnoseInvalidRedeclaration(clang::Sema&, clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema9CheckMainEPNS_12FunctionDeclE", "clang::Sema::CheckMain(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema27CheckForConstantInitializerEPNS_4ExprENS_8QualTypeE", "clang::Sema::CheckForConstantInitializer(clang::Expr*, clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema20AddInitializerToDeclEPNS_4DeclEPNS_4ExprE", "clang::Sema::AddInitializerToDecl(clang::Decl*, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema20AddInitializerToDeclEPNS_4DeclEPNS_4ExprEb", "clang::Sema::AddInitializerToDecl(clang::Decl*, clang::Expr*, bool)"),
	mu_demangle_test("_ZN5clang4Sema32CheckCompleteVariableDeclarationEPNS_7VarDeclE", "clang::Sema::CheckCompleteVariableDeclaration(clang::VarDecl*)"),
	mu_demangle_test("_ZN5clang4Sema21ActOnInitializerErrorEPNS_4DeclE", "clang::Sema::ActOnInitializerError(clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnUninitializedDeclEPNS_4DeclEb", "clang::Sema::ActOnUninitializedDecl(clang::Decl*, bool)"),
	mu_demangle_test("_ZN5clang4Sema23FinalizeDeclaratorGroupEPNS_5ScopeERKNS_8DeclSpecEPPNS_4DeclEj", "clang::Sema::FinalizeDeclaratorGroup(clang::Scope*, clang::DeclSpec const&, clang::Decl**, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema20ActOnParamDeclaratorEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnParamDeclarator(clang::Scope*, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema14CheckParameterEPNS_11DeclContextEPNS_14TypeSourceInfoENS_8QualTypeEPNS_14IdentifierInfoENS_14SourceLocationENS_12StorageClassES9_", "clang::Sema::CheckParameter(clang::DeclContext*, clang::TypeSourceInfo*, clang::QualType, clang::IdentifierInfo*, clang::SourceLocation, clang::StorageClass, clang::StorageClass)"),
	mu_demangle_test("_ZN5clang4Sema24DiagnoseUnusedParametersEPKPNS_11ParmVarDeclES4_", "clang::Sema::DiagnoseUnusedParameters(clang::ParmVarDecl* const*, clang::ParmVarDecl* const*)"),
	mu_demangle_test("_ZN5clang4Sema38DiagnoseSizeOfParametersAndReturnValueEPKPNS_11ParmVarDeclES4_NS_8QualTypeEPNS_9NamedDeclE", "clang::Sema::DiagnoseSizeOfParametersAndReturnValue(clang::ParmVarDecl* const*, clang::ParmVarDecl* const*, clang::QualType, clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang4Sema31ActOnFinishKNRParamDeclarationsEPNS_5ScopeERNS_10DeclaratorENS_14SourceLocationE", "clang::Sema::ActOnFinishKNRParamDeclarations(clang::Scope*, clang::Declarator&, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnStartOfFunctionDefEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnStartOfFunctionDef(clang::Scope*, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnStartOfFunctionDefEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartOfFunctionDef(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnFinishFunctionBodyEPNS_4DeclEPNS_4StmtE", "clang::Sema::ActOnFinishFunctionBody(clang::Decl*, clang::Stmt*)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnFinishFunctionBodyEPNS_4DeclEPNS_4StmtEb", "clang::Sema::ActOnFinishFunctionBody(clang::Decl*, clang::Stmt*, bool)"),
	mu_demangle_test("_ZN5clang4Sema24ImplicitlyDefineFunctionENS_14SourceLocationERNS_14IdentifierInfoEPNS_5ScopeE", "clang::Sema::ImplicitlyDefineFunction(clang::SourceLocation, clang::IdentifierInfo&, clang::Scope*)"),
	mu_demangle_test("_ZN5clang4Sema28isAcceptableTagRedeclarationEPKNS_7TagDeclENS_11TagTypeKindENS_14SourceLocationERKNS_14IdentifierInfoE", "clang::Sema::isAcceptableTagRedeclaration(clang::TagDecl const*, clang::TagTypeKind, clang::SourceLocation, clang::IdentifierInfo const&)"),
	mu_demangle_test("_ZN5clang4Sema8ActOnTagEPNS_5ScopeEjNS0_10TagUseKindENS_14SourceLocationERNS_12CXXScopeSpecEPNS_14IdentifierInfoES4_PNS_13AttributeListENS_15AccessSpecifierENS_11ASTMultiPtrIPNS_21TemplateParameterListEEERbSG_bbNS_12ActionResultINS_9OpaquePtrINS_8QualTypeEEELb0EEE", "clang::Sema::ActOnTag(clang::Scope*, unsigned int, clang::Sema::TagUseKind, clang::SourceLocation, clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::SourceLocation, clang::AttributeList*, clang::AccessSpecifier, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool&, bool&, bool, bool, clang::ActionResult<clang::OpaquePtr<clang::QualType>, false>)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnTagStartDefinitionEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnTagStartDefinition(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema31ActOnStartCXXMemberDeclarationsEPNS_5ScopeEPNS_4DeclERNS_19ClassVirtSpecifiersENS_14SourceLocationE", "clang::Sema::ActOnStartCXXMemberDeclarations(clang::Scope*, clang::Decl*, clang::ClassVirtSpecifiers&, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema24ActOnTagFinishDefinitionEPNS_5ScopeEPNS_4DeclENS_14SourceLocationE", "clang::Sema::ActOnTagFinishDefinition(clang::Scope*, clang::Decl*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnTagDefinitionErrorEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnTagDefinitionError(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema14VerifyBitFieldENS_14SourceLocationEPNS_14IdentifierInfoENS_8QualTypeEPKNS_4ExprEPb", "clang::Sema::VerifyBitField(clang::SourceLocation, clang::IdentifierInfo*, clang::QualType, clang::Expr const*, bool*)"),
	mu_demangle_test("_ZN5clang4Sema10ActOnFieldEPNS_5ScopeEPNS_4DeclENS_14SourceLocationERNS_10DeclaratorEPNS_4ExprE", "clang::Sema::ActOnField(clang::Scope*, clang::Decl*, clang::SourceLocation, clang::Declarator&, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema11HandleFieldEPNS_5ScopeEPNS_10RecordDeclENS_14SourceLocationERNS_10DeclaratorEPNS_4ExprENS_15AccessSpecifierE", "clang::Sema::HandleField(clang::Scope*, clang::RecordDecl*, clang::SourceLocation, clang::Declarator&, clang::Expr*, clang::AccessSpecifier)"),
	mu_demangle_test("_ZN5clang4Sema14CheckFieldDeclENS_15DeclarationNameENS_8QualTypeEPNS_14TypeSourceInfoEPNS_10RecordDeclENS_14SourceLocationEbPNS_4ExprES7_NS_15AccessSpecifierEPNS_9NamedDeclEPNS_10DeclaratorE", "clang::Sema::CheckFieldDecl(clang::DeclarationName, clang::QualType, clang::TypeSourceInfo*, clang::RecordDecl*, clang::SourceLocation, bool, clang::Expr*, clang::SourceLocation, clang::AccessSpecifier, clang::NamedDecl*, clang::Declarator*)"),
	mu_demangle_test("_ZN5clang4Sema18DiagnoseNontrivialEPKNS_10RecordTypeENS0_16CXXSpecialMemberE", "clang::Sema::DiagnoseNontrivial(clang::RecordType const*, clang::Sema::CXXSpecialMember)"),
	mu_demangle_test("_ZN5clang4Sema9ActOnIvarEPNS_5ScopeENS_14SourceLocationEPNS_4DeclERNS_10DeclaratorEPNS_4ExprENS_3tok15ObjCKeywordKindE", "clang::Sema::ActOnIvar(clang::Scope*, clang::SourceLocation, clang::Decl*, clang::Declarator&, clang::Expr*, clang::tok::ObjCKeywordKind)"),
	mu_demangle_test("_ZN5clang4Sema17ActOnLastBitfieldENS_14SourceLocationEPNS_4DeclERN4llvm15SmallVectorImplIS3_EE", "clang::Sema::ActOnLastBitfield(clang::SourceLocation, clang::Decl*, llvm::SmallVectorImpl<clang::Decl*>&)"),
	mu_demangle_test("_ZN5clang4Sema11ActOnFieldsEPNS_5ScopeENS_14SourceLocationEPNS_4DeclEPS5_jS3_S3_PNS_13AttributeListE", "clang::Sema::ActOnFields(clang::Scope*, clang::SourceLocation, clang::Decl*, clang::Decl**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::AttributeList*)"),
	mu_demangle_test("_ZN5clang4Sema17CheckEnumConstantEPNS_8EnumDeclEPNS_16EnumConstantDeclENS_14SourceLocationEPNS_14IdentifierInfoEPNS_4ExprE", "clang::Sema::CheckEnumConstant(clang::EnumDecl*, clang::EnumConstantDecl*, clang::SourceLocation, clang::IdentifierInfo*, clang::Expr*)"),
	mu_demangle_test("_Z27isRepresentableIntegerValueRN5clang10ASTContextERN4llvm6APSIntENS_8QualTypeE", "isRepresentableIntegerValue(clang::ASTContext&, llvm::APSInt&, clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema17ActOnEnumConstantEPNS_5ScopeEPNS_4DeclES4_NS_14SourceLocationEPNS_14IdentifierInfoEPNS_13AttributeListES5_PNS_4ExprE", "clang::Sema::ActOnEnumConstant(clang::Scope*, clang::Decl*, clang::Decl*, clang::SourceLocation, clang::IdentifierInfo*, clang::AttributeList*, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema13ActOnEnumBodyENS_14SourceLocationES1_S1_PNS_4DeclEPS3_jPNS_5ScopeEPNS_13AttributeListE", "clang::Sema::ActOnEnumBody(clang::SourceLocation, clang::SourceLocation, clang::SourceLocation, clang::Decl*, clang::Decl**, unsigned int, clang::Scope*, clang::AttributeList*)"),
	mu_demangle_test("_ZN5clang4Sema21ActOnFileScopeAsmDeclENS_14SourceLocationEPNS_4ExprE", "clang::Sema::ActOnFileScopeAsmDecl(clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema17ActOnPragmaWeakIDEPNS_14IdentifierInfoENS_14SourceLocationES3_", "clang::Sema::ActOnPragmaWeakID(clang::IdentifierInfo*, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema20ActOnPragmaWeakAliasEPNS_14IdentifierInfoES2_NS_14SourceLocationES3_S3_", "clang::Sema::ActOnPragmaWeakAlias(clang::IdentifierInfo*, clang::IdentifierInfo*, clang::SourceLocation, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang12RedeclarableINS_11TypedefDeclEE22setPreviousDeclarationEPS1_", "clang::Redeclarable<clang::TypedefDecl>::setPreviousDeclaration(clang::TypedefDecl*)"),
	mu_demangle_test("_ZN5clang12RedeclarableINS_7VarDeclEE22setPreviousDeclarationEPS1_", "clang::Redeclarable<clang::VarDecl>::setPreviousDeclaration(clang::VarDecl*)"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_13DLLImportAttrEEEPT_v", "clang::DLLImportAttr* clang::Decl::getAttr<clang::DLLImportAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_13DLLExportAttrEEEPT_v", "clang::DLLExportAttr* clang::Decl::getAttr<clang::DLLExportAttr>() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_10FormatAttrEEEPT_v", "clang::FormatAttr* clang::Decl::getAttr<clang::FormatAttr>() const"),
	mu_demangle_test("_ZNK5clang13CXXRecordDecl25hasTrivialCopyConstructorEv", "clang::CXXRecordDecl::hasTrivialCopyConstructor() const"),
	mu_demangle_test("_ZNK5clang13CXXRecordDecl21hasTrivialConstructorEv", "clang::CXXRecordDecl::hasTrivialConstructor() const"),
	mu_demangle_test("_ZNK5clang13CXXRecordDecl24hasTrivialCopyAssignmentEv", "clang::CXXRecordDecl::hasTrivialCopyAssignment() const"),
	mu_demangle_test("_ZNK5clang13CXXRecordDecl20hasTrivialDestructorEv", "clang::CXXRecordDecl::hasTrivialDestructor() const"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_10PackedAttrEEEPT_v", "clang::PackedAttr* clang::Decl::getAttr<clang::PackedAttr>() const"),
	mu_demangle_test("_ZNK4llvm6APSInt10extOrTruncEj", "llvm::APSInt::extOrTrunc(unsigned int) const"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPN5clang9FieldDeclEE6resizeEj", "llvm::SmallVectorImpl<clang::FieldDecl*>::resize(unsigned int)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang15DeclaratorChunkELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::DeclaratorChunk, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang12CXXBasePathsD2Ev", "clang::CXXBasePaths::~CXXBasePaths()"),
	mu_demangle_test("_ZN5clang12LookupResult22resolveKindAfterFilterEv", "clang::LookupResult::resolveKindAfterFilter()"),
	mu_demangle_test("_ZN5clang10Declarator5clearEv", "clang::Declarator::clear()"),
	mu_demangle_test("_ZN4llvm15SmallVectorImplIPN5clang9NamedDeclEE6resizeEj", "llvm::SmallVectorImpl<clang::NamedDecl*>::resize(unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema17CheckNoReturnAttrERKNS_13AttributeListE", "clang::Sema::CheckNoReturnAttr(clang::AttributeList const&)"),
	mu_demangle_test("_ZN5clang4Sema14AddAlignedAttrENS_14SourceLocationEPNS_4DeclEPNS_4ExprE", "clang::Sema::AddAlignedAttr(clang::SourceLocation, clang::Decl*, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema14AddAlignedAttrENS_14SourceLocationEPNS_4DeclEPNS_14TypeSourceInfoE", "clang::Sema::AddAlignedAttr(clang::SourceLocation, clang::Decl*, clang::TypeSourceInfo*)"),
	mu_demangle_test("_ZN5clang4Sema20CheckCallingConvAttrERKNS_13AttributeListERNS_11CallingConvE", "clang::Sema::CheckCallingConvAttr(clang::AttributeList const&, clang::CallingConv&)"),
	mu_demangle_test("_ZN5clang4Sema16CheckRegparmAttrERKNS_13AttributeListERj", "clang::Sema::CheckRegparmAttr(clang::AttributeList const&, unsigned int&)"),
	mu_demangle_test("_ZN5clang4Sema24ProcessDeclAttributeListEPNS_5ScopeEPNS_4DeclEPKNS_13AttributeListEbb", "clang::Sema::ProcessDeclAttributeList(clang::Scope*, clang::Decl*, clang::AttributeList const*, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema19DeclClonePragmaWeakEPNS_9NamedDeclEPNS_14IdentifierInfoE", "clang::Sema::DeclClonePragmaWeak(clang::NamedDecl*, clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang4Sema19DeclApplyPragmaWeakEPNS_5ScopeEPNS_9NamedDeclERNS0_8WeakInfoE", "clang::Sema::DeclApplyPragmaWeak(clang::Scope*, clang::NamedDecl*, clang::Sema::WeakInfo&)"),
	mu_demangle_test("_ZN5clang4Sema21ProcessDeclAttributesEPNS_5ScopeEPNS_4DeclERKNS_10DeclaratorEbb", "clang::Sema::ProcessDeclAttributes(clang::Scope*, clang::Decl*, clang::Declarator const&, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema22PushParsingDeclarationEv", "clang::Sema::PushParsingDeclaration()"),
	mu_demangle_test("_ZN5clang4Sema21PopParsingDeclarationEmPNS_4DeclE", "clang::Sema::PopParsingDeclaration(unsigned long, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema29HandleDelayedDeprecationCheckERNS_4sema17DelayedDiagnosticEPNS_4DeclE", "clang::Sema::HandleDelayedDeprecationCheck(clang::sema::DelayedDiagnostic&, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema22EmitDeprecationWarningEPNS_9NamedDeclEN4llvm9StringRefENS_14SourceLocationEb", "clang::Sema::EmitDeprecationWarning(clang::NamedDecl*, llvm::StringRef, clang::SourceLocation, bool)"),
	mu_demangle_test("_Z26ProcessInheritableDeclAttrPN5clang5ScopeEPNS_4DeclERKNS_13AttributeListERNS_4SemaE", "ProcessInheritableDeclAttr(clang::Scope*, clang::Decl*, clang::AttributeList const&, clang::Sema&)"),
	mu_demangle_test("_Z15getFunctionTypePKN5clang4DeclEb", "getFunctionType(clang::Decl const*, bool)"),
	mu_demangle_test("_ZN4llvm25array_pod_sort_comparatorIjEEiPKvS2_", "int llvm::array_pod_sort_comparator<unsigned int>(void const*, void const*)"),
	mu_demangle_test("_Z14isNSStringTypeN5clang8QualTypeERNS_10ASTContextE", "isNSStringType(clang::QualType, clang::ASTContext&)"),
	mu_demangle_test("_Z14isCFStringTypeN5clang8QualTypeERNS_10ASTContextE", "isCFStringType(clang::QualType, clang::ASTContext&)"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang4sema17DelayedDiagnosticELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::sema::DelayedDiagnostic, false>::grow(unsigned long)"),
	mu_demangle_test("_ZNK5clang4Decl7getAttrINS_13VecReturnAttrEEEPT_v", "clang::VecReturnAttr* clang::Decl::getAttr<clang::VecReturnAttr>() const"),
	mu_demangle_test("_ZN5clang4Sema23SetParamDefaultArgumentEPNS_11ParmVarDeclEPNS_4ExprENS_14SourceLocationE", "clang::Sema::SetParamDefaultArgument(clang::ParmVarDecl*, clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema25ActOnParamDefaultArgumentEPNS_4DeclENS_14SourceLocationEPNS_4ExprE", "clang::Sema::ActOnParamDefaultArgument(clang::Decl*, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang11StmtVisitorIN12_GLOBAL__N_127CheckDefaultArgumentVisitorEbE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::CheckDefaultArgumentVisitor, bool>::Visit(clang::Stmt*)"),
	mu_demangle_test("_ZN5clang4Sema33ActOnParamUnparsedDefaultArgumentEPNS_4DeclENS_14SourceLocationES3_", "clang::Sema::ActOnParamUnparsedDefaultArgument(clang::Decl*, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema30ActOnParamDefaultArgumentErrorEPNS_4DeclE", "clang::Sema::ActOnParamDefaultArgumentError(clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema29CheckExtraCXXDefaultArgumentsERNS_10DeclaratorE", "clang::Sema::CheckExtraCXXDefaultArguments(clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema20MergeCXXFunctionDeclEPNS_12FunctionDeclES2_", "clang::Sema::MergeCXXFunctionDecl(clang::FunctionDecl*, clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema24CheckCXXDefaultArgumentsEPNS_12FunctionDeclE", "clang::Sema::CheckCXXDefaultArguments(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema18isCurrentClassNameERKNS_14IdentifierInfoEPNS_5ScopeEPKNS_12CXXScopeSpecE", "clang::Sema::isCurrentClassName(clang::IdentifierInfo const&, clang::Scope*, clang::CXXScopeSpec const*)"),
	mu_demangle_test("_ZN5clang4Sema18CheckBaseSpecifierEPNS_13CXXRecordDeclENS_11SourceRangeEbNS_15AccessSpecifierEPNS_14TypeSourceInfoENS_14SourceLocationE", "clang::Sema::CheckBaseSpecifier(clang::CXXRecordDecl*, clang::SourceRange, bool, clang::AccessSpecifier, clang::TypeSourceInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema18ActOnBaseSpecifierEPNS_4DeclENS_11SourceRangeEbNS_15AccessSpecifierENS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationES8_", "clang::Sema::ActOnBaseSpecifier(clang::Decl*, clang::SourceRange, bool, clang::AccessSpecifier, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema20AttachBaseSpecifiersEPNS_13CXXRecordDeclEPPNS_16CXXBaseSpecifierEj", "clang::Sema::AttachBaseSpecifiers(clang::CXXRecordDecl*, clang::CXXBaseSpecifier**, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema19ActOnBaseSpecifiersEPNS_4DeclEPPNS_16CXXBaseSpecifierEj", "clang::Sema::ActOnBaseSpecifiers(clang::Decl*, clang::CXXBaseSpecifier**, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema13IsDerivedFromENS_8QualTypeES1_", "clang::Sema::IsDerivedFrom(clang::QualType, clang::QualType)"),
	mu_demangle_test("_Z15GetClassForTypeN5clang8QualTypeE", "GetClassForType(clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema13IsDerivedFromENS_8QualTypeES1_RNS_12CXXBasePathsE", "clang::Sema::IsDerivedFrom(clang::QualType, clang::QualType, clang::CXXBasePaths&)"),
	mu_demangle_test("_ZN5clang4Sema18BuildBasePathArrayERKNS_12CXXBasePathsERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::BuildBasePathArray(clang::CXXBasePaths const&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&)"),
	mu_demangle_test("_ZN5clang4Sema27BasePathInvolvesVirtualBaseERKN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::BasePathInvolvesVirtualBase(llvm::SmallVector<clang::CXXBaseSpecifier*, 4u> const&)"),
	mu_demangle_test("_ZN5clang4Sema28CheckDerivedToBaseConversionENS_8QualTypeES1_jjNS_14SourceLocationENS_11SourceRangeENS_15DeclarationNameEPN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::CheckDerivedToBaseConversion(clang::QualType, clang::QualType, unsigned int, unsigned int, clang::SourceLocation, clang::SourceRange, clang::DeclarationName, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>*)"),
	mu_demangle_test("_ZN5clang4Sema30getAmbiguousPathsDisplayStringERNS_12CXXBasePathsE", "clang::Sema::getAmbiguousPathsDisplayString(clang::CXXBasePaths&)"),
	mu_demangle_test("_ZN5clang4Sema28CheckDerivedToBaseConversionENS_8QualTypeES1_NS_14SourceLocationENS_11SourceRangeEPN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEEb", "clang::Sema::CheckDerivedToBaseConversion(clang::QualType, clang::QualType, clang::SourceLocation, clang::SourceRange, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>*, bool)"),
	mu_demangle_test("_ZN5clang4Sema20ActOnAccessSpecifierENS_15AccessSpecifierENS_14SourceLocationES2_", "clang::Sema::ActOnAccessSpecifier(clang::AccessSpecifier, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema20CheckOverrideControlEPKNS_4DeclE", "clang::Sema::CheckOverrideControl(clang::Decl const*)"),
	mu_demangle_test("_ZN5clang4Sema38CheckIfOverriddenFunctionIsMarkedFinalEPKNS_13CXXMethodDeclES3_", "clang::Sema::CheckIfOverriddenFunctionIsMarkedFinal(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema24ActOnCXXMemberDeclaratorEPNS_5ScopeENS_15AccessSpecifierERNS_10DeclaratorENS_11ASTMultiPtrIPNS_21TemplateParameterListEEEPNS_4ExprERKNS_14VirtSpecifiersESB_bb", "clang::Sema::ActOnCXXMemberDeclarator(clang::Scope*, clang::AccessSpecifier, clang::Declarator&, clang::ASTMultiPtr<clang::TemplateParameterList*>, clang::Expr*, clang::VirtSpecifiers const&, clang::Expr*, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema14SetDeclDeletedEPNS_4DeclENS_14SourceLocationE", "clang::Sema::SetDeclDeleted(clang::Decl*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema19ActOnMemInitializerEPNS_4DeclEPNS_5ScopeERNS_12CXXScopeSpecEPNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationESC_PPNS_4ExprEjSC_SC_", "clang::Sema::ActOnMemInitializer(clang::Decl*, clang::Scope*, clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema22BuildMemberInitializerEPNS_9ValueDeclEPPNS_4ExprEjNS_14SourceLocationES6_S6_", "clang::Sema::BuildMemberInitializer(clang::ValueDecl*, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_Z19FindBaseInitializerRN5clang4SemaEPNS_13CXXRecordDeclENS_8QualTypeERPKNS_16CXXBaseSpecifierES8_", "FindBaseInitializer(clang::Sema&, clang::CXXRecordDecl*, clang::QualType, clang::CXXBaseSpecifier const*&, clang::CXXBaseSpecifier const*&)"),
	mu_demangle_test("_ZN5clang4Sema20BuildBaseInitializerENS_8QualTypeEPNS_14TypeSourceInfoEPPNS_4ExprEjNS_14SourceLocationES7_PNS_13CXXRecordDeclES7_", "clang::Sema::BuildBaseInitializer(clang::QualType, clang::TypeSourceInfo*, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::CXXRecordDecl*, clang::SourceLocation)"),
	mu_demangle_test("_Z35InitExprContainsUninitializedFieldsPKN5clang4StmtEPKNS_9ValueDeclEPNS_14SourceLocationE", "InitExprContainsUninitializedFields(clang::Stmt const*, clang::ValueDecl const*, clang::SourceLocation*)"),
	mu_demangle_test("_ZN5clang4Sema26BuildDelegatingInitializerEPNS_14TypeSourceInfoEPPNS_4ExprEjNS_14SourceLocationES6_PNS_13CXXRecordDeclES6_", "clang::Sema::BuildDelegatingInitializer(clang::TypeSourceInfo*, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::CXXRecordDecl*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema19SetCtorInitializersEPNS_18CXXConstructorDeclEPPNS_18CXXCtorInitializerEjb", "clang::Sema::SetCtorInitializers(clang::CXXConstructorDecl*, clang::CXXCtorInitializer**, unsigned int, bool)"),
	mu_demangle_test("_Z28BuildImplicitBaseInitializerRN5clang4SemaEPNS_18CXXConstructorDeclE23ImplicitInitializerKindPNS_16CXXBaseSpecifierEbRPNS_18CXXCtorInitializerE", "BuildImplicitBaseInitializer(clang::Sema&, clang::CXXConstructorDecl*, ImplicitInitializerKind, clang::CXXBaseSpecifier*, bool, clang::CXXCtorInitializer*&)"),
	mu_demangle_test("_Z23CollectFieldInitializerRN12_GLOBAL__N_116BaseAndFieldInfoEPN5clang9FieldDeclES4_", "CollectFieldInitializer((anonymous namespace)::BaseAndFieldInfo&, clang::FieldDecl*, clang::FieldDecl*)"),
	mu_demangle_test("_ZN5clang4Sema38MarkBaseAndMemberDestructorsReferencedENS_14SourceLocationEPNS_13CXXRecordDeclE", "clang::Sema::MarkBaseAndMemberDestructorsReferenced(clang::SourceLocation, clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema20ActOnMemInitializersEPNS_4DeclENS_14SourceLocationEPPNS_18CXXCtorInitializerEjb", "clang::Sema::ActOnMemInitializers(clang::Decl*, clang::SourceLocation, clang::CXXCtorInitializer**, unsigned int, bool)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckRedundantInitERN5clang4SemaEPNS0_18CXXCtorInitializerERS4_", "(anonymous namespace)::CheckRedundantInit(clang::Sema&, clang::CXXCtorInitializer*, clang::CXXCtorInitializer*&)"),
	mu_demangle_test("_ZN5clang4Sema28ActOnDefaultCtorInitializersEPNS_4DeclE", "clang::Sema::ActOnDefaultCtorInitializers(clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema22RequireNonAbstractTypeENS_14SourceLocationENS_8QualTypeEjNS0_17AbstractDiagSelIDE", "clang::Sema::RequireNonAbstractType(clang::SourceLocation, clang::QualType, unsigned int, clang::Sema::AbstractDiagSelID)"),
	mu_demangle_test("_ZN5clang4Sema22RequireNonAbstractTypeENS_14SourceLocationENS_8QualTypeERKNS_17PartialDiagnosticE", "clang::Sema::RequireNonAbstractType(clang::SourceLocation, clang::QualType, clang::PartialDiagnostic const&)"),
	mu_demangle_test("_ZN5clang4Sema20DiagnoseAbstractTypeEPKNS_13CXXRecordDeclE", "clang::Sema::DiagnoseAbstractType(clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema22CheckCompletedCXXClassEPNS_13CXXRecordDeclE", "clang::Sema::CheckCompletedCXXClass(clang::CXXRecordDecl*)"),
	mu_demangle_test("_Z23CheckAbstractClassUsageRN12_GLOBAL__N_117AbstractUsageInfoEPN5clang13CXXRecordDeclE", "CheckAbstractClassUsage((anonymous namespace)::AbstractUsageInfo&, clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema28DiagnoseHiddenVirtualMethodsEPNS_13CXXRecordDeclEPNS_13CXXMethodDeclE", "clang::Sema::DiagnoseHiddenVirtualMethods(clang::CXXRecordDecl*, clang::CXXMethodDecl*)"),
	mu_demangle_test("_ZN5clang4Sema28DeclareInheritedConstructorsEPNS_13CXXRecordDeclE", "clang::Sema::DeclareInheritedConstructors(clang::CXXRecordDecl*)"),
	mu_demangle_test("_Z23FindHiddenVirtualMethodPKN5clang16CXXBaseSpecifierERNS_11CXXBasePathEPv", "FindHiddenVirtualMethod(clang::CXXBaseSpecifier const*, clang::CXXBasePath&, void*)"),
	mu_demangle_test("_ZN5clang4Sema33ActOnFinishCXXMemberSpecificationEPNS_5ScopeENS_14SourceLocationEPNS_4DeclES3_S3_PNS_13AttributeListE", "clang::Sema::ActOnFinishCXXMemberSpecification(clang::Scope*, clang::SourceLocation, clang::Decl*, clang::SourceLocation, clang::SourceLocation, clang::AttributeList*)"),
	mu_demangle_test("_ZN5clang4Sema35AddImplicitlyDeclaredMembersToClassEPNS_13CXXRecordDeclE", "clang::Sema::AddImplicitlyDeclaredMembersToClass(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema29DeclareImplicitCopyAssignmentEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitCopyAssignment(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema25DeclareImplicitDestructorEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitDestructor(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema25ActOnReenterTemplateScopeEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnReenterTemplateScope(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema35ActOnStartDelayedMemberDeclarationsEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartDelayedMemberDeclarations(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema36ActOnFinishDelayedMemberDeclarationsEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnFinishDelayedMemberDeclarations(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema37ActOnStartDelayedCXXMethodDeclarationEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartDelayedCXXMethodDeclaration(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema30ActOnDelayedCXXMethodParameterEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnDelayedCXXMethodParameter(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema38ActOnFinishDelayedCXXMethodDeclarationEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnFinishDelayedCXXMethodDeclaration(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema16CheckConstructorEPNS_18CXXConstructorDeclE", "clang::Sema::CheckConstructor(clang::CXXConstructorDecl*)"),
	mu_demangle_test("_ZN5clang4Sema26CheckConstructorDeclaratorERNS_10DeclaratorENS_8QualTypeERNS_12StorageClassE", "clang::Sema::CheckConstructorDeclarator(clang::Declarator&, clang::QualType, clang::StorageClass&)"),
	mu_demangle_test("_ZN5clang4Sema15CheckDestructorEPNS_17CXXDestructorDeclE", "clang::Sema::CheckDestructor(clang::CXXDestructorDecl*)"),
	mu_demangle_test("_ZN5clang4Sema25CheckDestructorDeclaratorERNS_10DeclaratorENS_8QualTypeERNS_12StorageClassE", "clang::Sema::CheckDestructorDeclarator(clang::Declarator&, clang::QualType, clang::StorageClass&)"),
	mu_demangle_test("_ZN5clang4Sema25CheckConversionDeclaratorERNS_10DeclaratorERNS_8QualTypeERNS_12StorageClassE", "clang::Sema::CheckConversionDeclarator(clang::Declarator&, clang::QualType&, clang::StorageClass&)"),
	mu_demangle_test("_ZN5clang4Sema25ActOnConversionDeclaratorEPNS_17CXXConversionDeclE", "clang::Sema::ActOnConversionDeclarator(clang::CXXConversionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnStartNamespaceDefEPNS_5ScopeENS_14SourceLocationES3_PNS_14IdentifierInfoES3_PNS_13AttributeListE", "clang::Sema::ActOnStartNamespaceDef(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::AttributeList*)"),
	mu_demangle_test("_ZNK5clang4Sema15getStdNamespaceEv", "clang::Sema::getStdNamespace() const"),
	mu_demangle_test("_ZN5clang4Sema23ActOnFinishNamespaceDefEPNS_4DeclENS_14SourceLocationE", "clang::Sema::ActOnFinishNamespaceDef(clang::Decl*, clang::SourceLocation)"),
	mu_demangle_test("_ZNK5clang4Sema14getStdBadAllocEv", "clang::Sema::getStdBadAlloc() const"),
	mu_demangle_test("_ZN5clang4Sema23getOrCreateStdNamespaceEv", "clang::Sema::getOrCreateStdNamespace()"),
	mu_demangle_test("_ZN5clang4Sema19ActOnUsingDirectiveEPNS_5ScopeENS_14SourceLocationES3_RNS_12CXXScopeSpecES3_PNS_14IdentifierInfoEPNS_13AttributeListE", "clang::Sema::ActOnUsingDirective(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::CXXScopeSpec&, clang::SourceLocation, clang::IdentifierInfo*, clang::AttributeList*)"),
	mu_demangle_test("_ZN5clang4Sema18PushUsingDirectiveEPNS_5ScopeEPNS_18UsingDirectiveDeclE", "clang::Sema::PushUsingDirective(clang::Scope*, clang::UsingDirectiveDecl*)"),
	mu_demangle_test("_ZN5clang4Sema21ActOnUsingDeclarationEPNS_5ScopeENS_15AccessSpecifierEbNS_14SourceLocationERNS_12CXXScopeSpecERNS_13UnqualifiedIdEPNS_13AttributeListEbS4_", "clang::Sema::ActOnUsingDeclaration(clang::Scope*, clang::AccessSpecifier, bool, clang::SourceLocation, clang::CXXScopeSpec&, clang::UnqualifiedId&, clang::AttributeList*, bool, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema21BuildUsingDeclarationEPNS_5ScopeENS_15AccessSpecifierENS_14SourceLocationERNS_12CXXScopeSpecERKNS_19DeclarationNameInfoEPNS_13AttributeListEbbS4_", "clang::Sema::BuildUsingDeclaration(clang::Scope*, clang::AccessSpecifier, clang::SourceLocation, clang::CXXScopeSpec&, clang::DeclarationNameInfo const&, clang::AttributeList*, bool, bool, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema20CheckUsingShadowDeclEPNS_9UsingDeclEPNS_9NamedDeclERKNS_12LookupResultE", "clang::Sema::CheckUsingShadowDecl(clang::UsingDecl*, clang::NamedDecl*, clang::LookupResult const&)"),
	mu_demangle_test("_ZN5clang4Sema20BuildUsingShadowDeclEPNS_5ScopeEPNS_9UsingDeclEPNS_9NamedDeclE", "clang::Sema::BuildUsingShadowDecl(clang::Scope*, clang::UsingDecl*, clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang4Sema19HideUsingShadowDeclEPNS_5ScopeEPNS_15UsingShadowDeclE", "clang::Sema::HideUsingShadowDecl(clang::Scope*, clang::UsingShadowDecl*)"),
	mu_demangle_test("_ZN5clang4Sema27CheckUsingDeclRedeclarationENS_14SourceLocationEbRKNS_12CXXScopeSpecES1_RKNS_12LookupResultE", "clang::Sema::CheckUsingDeclRedeclaration(clang::SourceLocation, bool, clang::CXXScopeSpec const&, clang::SourceLocation, clang::LookupResult const&)"),
	mu_demangle_test("_ZN5clang4Sema23CheckUsingDeclQualifierENS_14SourceLocationERKNS_12CXXScopeSpecES1_", "clang::Sema::CheckUsingDeclQualifier(clang::SourceLocation, clang::CXXScopeSpec const&, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema34CheckInheritedConstructorUsingDeclEPNS_9UsingDeclE", "clang::Sema::CheckInheritedConstructorUsingDecl(clang::UsingDecl*)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnNamespaceAliasDefEPNS_5ScopeENS_14SourceLocationES3_PNS_14IdentifierInfoERNS_12CXXScopeSpecES3_S5_", "clang::Sema::ActOnNamespaceAliasDef(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo*, clang::CXXScopeSpec&, clang::SourceLocation, clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang4Sema33DeclareImplicitDefaultConstructorEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitDefaultConstructor(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_130ImplicitExceptionSpecification10CalledDeclEPN5clang13CXXMethodDeclE", "(anonymous namespace)::ImplicitExceptionSpecification::CalledDecl(clang::CXXMethodDecl*)"),
	mu_demangle_test("_Z27getDefaultConstructorUnsafeRN5clang4SemaEPNS_13CXXRecordDeclE", "getDefaultConstructorUnsafe(clang::Sema&, clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema32DefineImplicitDefaultConstructorENS_14SourceLocationEPNS_18CXXConstructorDeclE", "clang::Sema::DefineImplicitDefaultConstructor(clang::SourceLocation, clang::CXXConstructorDecl*)"),
	mu_demangle_test("_ZN5clang4Sema14MarkVTableUsedENS_14SourceLocationEPNS_13CXXRecordDeclEb", "clang::Sema::MarkVTableUsed(clang::SourceLocation, clang::CXXRecordDecl*, bool)"),
	mu_demangle_test("_ZN5clang4Sema24DefineImplicitDestructorENS_14SourceLocationEPNS_17CXXDestructorDeclE", "clang::Sema::DefineImplicitDestructor(clang::SourceLocation, clang::CXXDestructorDecl*)"),
	mu_demangle_test("_Z22hasConstCopyAssignmentRN5clang4SemaEPKNS_13CXXRecordDeclE", "hasConstCopyAssignment(clang::Sema&, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema28DefineImplicitCopyAssignmentENS_14SourceLocationEPNS_13CXXMethodDeclE", "clang::Sema::DefineImplicitCopyAssignment(clang::SourceLocation, clang::CXXMethodDecl*)"),
	mu_demangle_test("_Z21BuildSingleCopyAssignRN5clang4SemaENS_14SourceLocationENS_8QualTypeEPNS_4ExprES5_bj", "BuildSingleCopyAssign(clang::Sema&, clang::SourceLocation, clang::QualType, clang::Expr*, clang::Expr*, bool, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema30DeclareImplicitCopyConstructorEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitCopyConstructor(clang::CXXRecordDecl*)"),
	mu_demangle_test("_ZN5clang4Sema29DefineImplicitCopyConstructorENS_14SourceLocationEPNS_18CXXConstructorDeclEj", "clang::Sema::DefineImplicitCopyConstructor(clang::SourceLocation, clang::CXXConstructorDecl*, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema21BuildCXXConstructExprENS_14SourceLocationENS_8QualTypeEPNS_18CXXConstructorDeclENS_11ASTMultiPtrIPNS_4ExprEEEbjNS_11SourceRangeE", "clang::Sema::BuildCXXConstructExpr(clang::SourceLocation, clang::QualType, clang::CXXConstructorDecl*, clang::ASTMultiPtr<clang::Expr*>, bool, unsigned int, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang4Sema21BuildCXXConstructExprENS_14SourceLocationENS_8QualTypeEPNS_18CXXConstructorDeclEbNS_11ASTMultiPtrIPNS_4ExprEEEbjNS_11SourceRangeE", "clang::Sema::BuildCXXConstructExpr(clang::SourceLocation, clang::QualType, clang::CXXConstructorDecl*, bool, clang::ASTMultiPtr<clang::Expr*>, bool, unsigned int, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang4Sema28InitializeVarWithConstructorEPNS_7VarDeclEPNS_18CXXConstructorDeclENS_11ASTMultiPtrIPNS_4ExprEEE", "clang::Sema::InitializeVarWithConstructor(clang::VarDecl*, clang::CXXConstructorDecl*, clang::ASTMultiPtr<clang::Expr*>)"),
	mu_demangle_test("_ZN5clang4Sema25FinalizeVarWithDestructorEPNS_7VarDeclEPKNS_10RecordTypeE", "clang::Sema::FinalizeVarWithDestructor(clang::VarDecl*, clang::RecordType const*)"),
	mu_demangle_test("_ZN5clang4Sema29AddCXXDirectInitializerToDeclEPNS_4DeclENS_14SourceLocationENS_11ASTMultiPtrIPNS_4ExprEEES3_", "clang::Sema::AddCXXDirectInitializerToDecl(clang::Decl*, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema23CompleteConstructorCallEPNS_18CXXConstructorDeclENS_11ASTMultiPtrIPNS_4ExprEEENS_14SourceLocationERNS_15ASTOwningVectorIS5_Lj8EEE", "clang::Sema::CompleteConstructorCall(clang::CXXConstructorDecl*, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation, clang::ASTOwningVector<clang::Expr*, 8u>&)"),
	mu_demangle_test("_ZN5clang4Sema34CheckOverloadedOperatorDeclarationEPNS_12FunctionDeclE", "clang::Sema::CheckOverloadedOperatorDeclaration(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema31CheckLiteralOperatorDeclarationEPNS_12FunctionDeclE", "clang::Sema::CheckLiteralOperatorDeclaration(clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema30ActOnStartLinkageSpecificationEPNS_5ScopeENS_14SourceLocationES3_N4llvm9StringRefES3_", "clang::Sema::ActOnStartLinkageSpecification(clang::Scope*, clang::SourceLocation, clang::SourceLocation, llvm::StringRef, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema31ActOnFinishLinkageSpecificationEPNS_5ScopeEPNS_4DeclENS_14SourceLocationE", "clang::Sema::ActOnFinishLinkageSpecification(clang::Scope*, clang::Decl*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema25BuildExceptionDeclarationEPNS_5ScopeEPNS_14TypeSourceInfoEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::BuildExceptionDeclaration(clang::Scope*, clang::TypeSourceInfo*, clang::IdentifierInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema24ActOnExceptionDeclaratorEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnExceptionDeclarator(clang::Scope*, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema28ActOnStaticAssertDeclarationENS_14SourceLocationEPNS_4ExprES3_", "clang::Sema::ActOnStaticAssertDeclaration(clang::SourceLocation, clang::Expr*, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema19CheckFriendTypeDeclENS_14SourceLocationEPNS_14TypeSourceInfoE", "clang::Sema::CheckFriendTypeDecl(clang::SourceLocation, clang::TypeSourceInfo*)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnTemplatedFriendTagEPNS_5ScopeENS_14SourceLocationEjS3_RNS_12CXXScopeSpecEPNS_14IdentifierInfoES3_PNS_13AttributeListENS_11ASTMultiPtrIPNS_21TemplateParameterListEEE", "clang::Sema::ActOnTemplatedFriendTag(clang::Scope*, clang::SourceLocation, unsigned int, clang::SourceLocation, clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::SourceLocation, clang::AttributeList*, clang::ASTMultiPtr<clang::TemplateParameterList*>)"),
	mu_demangle_test("_ZN5clang4Sema19ActOnFriendTypeDeclEPNS_5ScopeERKNS_8DeclSpecENS_11ASTMultiPtrIPNS_21TemplateParameterListEEE", "clang::Sema::ActOnFriendTypeDecl(clang::Scope*, clang::DeclSpec const&, clang::ASTMultiPtr<clang::TemplateParameterList*>)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnFriendFunctionDeclEPNS_5ScopeERNS_10DeclaratorEbNS_11ASTMultiPtrIPNS_21TemplateParameterListEEE", "clang::Sema::ActOnFriendFunctionDecl(clang::Scope*, clang::Declarator&, bool, clang::ASTMultiPtr<clang::TemplateParameterList*>)"),
	mu_demangle_test("_ZN5clang4Sema43DiagnoseReturnInConstructorExceptionHandlerEPNS_10CXXTryStmtE", "clang::Sema::DiagnoseReturnInConstructorExceptionHandler(clang::CXXTryStmt*)"),
	mu_demangle_test("_Z21SearchForReturnInStmtRN5clang4SemaEPNS_4StmtE", "SearchForReturnInStmt(clang::Sema&, clang::Stmt*)"),
	mu_demangle_test("_ZN5clang4Sema33CheckOverridingFunctionReturnTypeEPKNS_13CXXMethodDeclES3_", "clang::Sema::CheckOverridingFunctionReturnType(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema15CheckPureMethodEPNS_13CXXMethodDeclENS_11SourceRangeE", "clang::Sema::CheckPureMethod(clang::CXXMethodDecl*, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang4Sema28ActOnCXXEnterDeclInitializerEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnCXXEnterDeclInitializer(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema27ActOnCXXExitDeclInitializerEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnCXXExitDeclInitializer(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema28ActOnCXXConditionDeclarationEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnCXXConditionDeclaration(clang::Scope*, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema28MarkVirtualMembersReferencedENS_14SourceLocationEPKNS_13CXXRecordDeclE", "clang::Sema::MarkVirtualMembersReferenced(clang::SourceLocation, clang::CXXRecordDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema17DefineUsedVTablesEv", "clang::Sema::DefineUsedVTables()"),
	mu_demangle_test("_ZN5clang4Sema19SetIvarInitializersEPNS_22ObjCImplementationDeclE", "clang::Sema::SetIvarInitializers(clang::ObjCImplementationDecl*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_127CheckDefaultArgumentVisitor9VisitExprEPN5clang4ExprE", "(anonymous namespace)::CheckDefaultArgumentVisitor::VisitExpr(clang::Expr*)"),
	mu_demangle_test("_Z38CheckOperatorNewDeleteDeclarationScopeRN5clang4SemaEPKNS_12FunctionDeclE", "CheckOperatorNewDeleteDeclarationScope(clang::Sema&, clang::FunctionDecl const*)"),
	mu_demangle_test("_Z27CheckOperatorNewDeleteTypesRN5clang4SemaEPKNS_12FunctionDeclENS_7CanQualINS_4TypeEEES7_jj", "CheckOperatorNewDeleteTypes(clang::Sema&, clang::FunctionDecl const*, clang::CanQual<clang::Type>, clang::CanQual<clang::Type>, unsigned int, unsigned int)"),
	mu_demangle_test("_ZZN5clang4Sema23CheckUsingDeclQualifierENS_14SourceLocationERKNS_12CXXScopeSpecES1_EN8UserData14doesNotContainEPKNS_13CXXRecordDeclEPv", "clang::Sema::CheckUsingDeclQualifier(clang::SourceLocation, clang::CXXScopeSpec const&, clang::SourceLocation)::UserData::doesNotContain(clang::CXXRecordDecl const*, void*)"),
	mu_demangle_test("_ZZN5clang4Sema23CheckUsingDeclQualifierENS_14SourceLocationERKNS_12CXXScopeSpecES1_EN8UserData7collectEPKNS_13CXXRecordDeclEPv", "clang::Sema::CheckUsingDeclQualifier(clang::SourceLocation, clang::CXXScopeSpec const&, clang::SourceLocation)::UserData::collect(clang::CXXRecordDecl const*, void*)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckAbstractUsage5VisitEN5clang7TypeLocENS1_4Sema17AbstractDiagSelIDE", "(anonymous namespace)::CheckAbstractUsage::Visit(clang::TypeLoc, clang::Sema::AbstractDiagSelID)"),
	mu_demangle_test("_ZN12_GLOBAL__N_118CheckAbstractUsage5CheckEN5clang7TypeLocENS1_4Sema17AbstractDiagSelIDE", "(anonymous namespace)::CheckAbstractUsage::Check(clang::TypeLoc, clang::Sema::AbstractDiagSelID)"),
	mu_demangle_test("_ZN5clang14AccessSpecDecl6CreateERNS_10ASTContextENS_15AccessSpecifierEPNS_11DeclContextENS_14SourceLocationES6_", "clang::AccessSpecDecl::Create(clang::ASTContext&, clang::AccessSpecifier, clang::DeclContext*, clang::SourceLocation, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang15UsingShadowDeclC2EPNS_11DeclContextENS_14SourceLocationEPNS_9UsingDeclEPNS_9NamedDeclE", "clang::UsingShadowDecl::UsingShadowDecl(clang::DeclContext*, clang::SourceLocation, clang::UsingDecl*, clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang15UsingShadowDeclD1Ev", "clang::UsingShadowDecl::~UsingShadowDecl()"),
	mu_demangle_test("_ZN5clang15UsingShadowDeclD0Ev", "clang::UsingShadowDecl::~UsingShadowDecl()"),
	mu_demangle_test("_ZN4llvm23SmallVectorTemplateBaseIN5clang17InitializedEntityELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::InitializedEntity, false>::grow(unsigned long)"),
	mu_demangle_test("_ZN5clang14AccessSpecDeclD1Ev", "clang::AccessSpecDecl::~AccessSpecDecl()"),
	mu_demangle_test("_ZN5clang14AccessSpecDeclD0Ev", "clang::AccessSpecDecl::~AccessSpecDecl()"),
	mu_demangle_test("_ZNK5clang14AccessSpecDecl14getSourceRangeEv", "clang::AccessSpecDecl::getSourceRange() const"),
	mu_demangle_test("_ZN5clang4Sema25ActOnStartOfObjCMethodDefEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartOfObjCMethodDef(clang::Scope*, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema24ActOnStartClassInterfaceENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_PKPNS_4DeclEjPKS1_S1_PNS_13AttributeListE", "clang::Sema::ActOnStartClassInterface(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Decl* const*, unsigned int, clang::SourceLocation const*, clang::SourceLocation, clang::AttributeList*)"),
	mu_demangle_test("_ZN5clang4Sema18CheckObjCDeclScopeEPNS_4DeclE", "clang::Sema::CheckObjCDeclScope(clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnCompatiblityAliasENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_", "clang::Sema::ActOnCompatiblityAlias(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema52CheckForwardProtocolDeclarationForCircularDependencyEPNS_14IdentifierInfoERNS_14SourceLocationES3_RKNS_8ObjCListINS_16ObjCProtocolDeclEEE", "clang::Sema::CheckForwardProtocolDeclarationForCircularDependency(clang::IdentifierInfo*, clang::SourceLocation&, clang::SourceLocation, clang::ObjCList<clang::ObjCProtocolDecl> const&)"),
	mu_demangle_test("_ZN5clang4Sema27ActOnStartProtocolInterfaceENS_14SourceLocationEPNS_14IdentifierInfoES1_PKPNS_4DeclEjPKS1_S1_PNS_13AttributeListE", "clang::Sema::ActOnStartProtocolInterface(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Decl* const*, unsigned int, clang::SourceLocation const*, clang::SourceLocation, clang::AttributeList*)"),
	mu_demangle_test("_ZN5clang4Sema23FindProtocolDeclarationEbPKSt4pairIPNS_14IdentifierInfoENS_14SourceLocationEEjRN4llvm15SmallVectorImplIPNS_4DeclEEE", "clang::Sema::FindProtocolDeclaration(bool, std::pair<clang::IdentifierInfo*, clang::SourceLocation> const*, unsigned int, llvm::SmallVectorImpl<clang::Decl*>&)"),
	mu_demangle_test("_ZN5clang4Sema32DiagnoseClassExtensionDupMethodsEPNS_16ObjCCategoryDeclEPNS_17ObjCInterfaceDeclE", "clang::Sema::DiagnoseClassExtensionDupMethods(clang::ObjCCategoryDecl*, clang::ObjCInterfaceDecl*)"),
	mu_demangle_test("_ZN5clang4Sema26MatchTwoMethodDeclarationsEPKNS_14ObjCMethodDeclES3_bb", "clang::Sema::MatchTwoMethodDeclarations(clang::ObjCMethodDecl const*, clang::ObjCMethodDecl const*, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema31ActOnForwardProtocolDeclarationENS_14SourceLocationEPKSt4pairIPNS_14IdentifierInfoES1_EjPNS_13AttributeListE", "clang::Sema::ActOnForwardProtocolDeclaration(clang::SourceLocation, std::pair<clang::IdentifierInfo*, clang::SourceLocation> const*, unsigned int, clang::AttributeList*)"),
	mu_demangle_test("_ZN5clang4Sema27ActOnStartCategoryInterfaceENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_PKPNS_4DeclEjPKS1_S1_", "clang::Sema::ActOnStartCategoryInterface(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Decl* const*, unsigned int, clang::SourceLocation const*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema32ActOnStartCategoryImplementationENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_", "clang::Sema::ActOnStartCategoryImplementation(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema29ActOnStartClassImplementationENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_", "clang::Sema::ActOnStartClassImplementation(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema24CheckImplementationIvarsEPNS_22ObjCImplementationDeclEPPNS_12ObjCIvarDeclEjNS_14SourceLocationE", "clang::Sema::CheckImplementationIvars(clang::ObjCImplementationDecl*, clang::ObjCIvarDecl**, unsigned int, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema19WarnUndefinedMethodENS_14SourceLocationEPNS_14ObjCMethodDeclERbj", "clang::Sema::WarnUndefinedMethod(clang::SourceLocation, clang::ObjCMethodDecl*, bool&, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema27WarnConflictingTypedMethodsEPNS_14ObjCMethodDeclES2_", "clang::Sema::WarnConflictingTypedMethods(clang::ObjCMethodDecl*, clang::ObjCMethodDecl*)"),
	mu_demangle_test("_ZN5clang4Sema25ImplMethodsVsClassMethodsEPNS_5ScopeEPNS_12ObjCImplDeclEPNS_17ObjCContainerDeclEb", "clang::Sema::ImplMethodsVsClassMethods(clang::Scope*, clang::ObjCImplDecl*, clang::ObjCContainerDecl*, bool)"),
	mu_demangle_test("_ZN5clang4Sema28ActOnForwardClassDeclarationENS_14SourceLocationEPPNS_14IdentifierInfoEPS1_j", "clang::Sema::ActOnForwardClassDeclaration(clang::SourceLocation, clang::IdentifierInfo**, clang::SourceLocation*, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema14ReadMethodPoolENS_8SelectorE", "clang::Sema::ReadMethodPool(clang::Selector)"),
	mu_demangle_test("_ZN5clang4Sema21AddMethodToGlobalPoolEPNS_14ObjCMethodDeclEbb", "clang::Sema::AddMethodToGlobalPool(clang::ObjCMethodDecl*, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema24LookupMethodInGlobalPoolENS_8SelectorENS_11SourceRangeEbbb", "clang::Sema::LookupMethodInGlobalPool(clang::Selector, clang::SourceRange, bool, bool, bool)"),
	mu_demangle_test("_ZN5clang4Sema35LookupImplementedMethodInGlobalPoolENS_8SelectorE", "clang::Sema::LookupImplementedMethodInGlobalPool(clang::Selector)"),
	mu_demangle_test("_ZN5clang4Sema33CompareMethodParamsInBaseAndSuperEPNS_4DeclEPNS_14ObjCMethodDeclEb", "clang::Sema::CompareMethodParamsInBaseAndSuper(clang::Decl*, clang::ObjCMethodDecl*, bool)"),
	mu_demangle_test("_ZN5clang4Sema22DiagnoseDuplicateIvarsEPNS_17ObjCInterfaceDeclES2_", "clang::Sema::DiagnoseDuplicateIvars(clang::ObjCInterfaceDecl*, clang::ObjCInterfaceDecl*)"),
	mu_demangle_test("_ZN5clang4Sema10ActOnAtEndEPNS_5ScopeENS_11SourceRangeEPNS_4DeclEPS5_jS6_jPNS_9OpaquePtrINS_12DeclGroupRefEEEj", "clang::Sema::ActOnAtEnd(clang::Scope*, clang::SourceRange, clang::Decl*, clang::Decl**, unsigned int, clang::Decl**, unsigned int, clang::OpaquePtr<clang::DeclGroupRef>*, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnMethodDeclarationEPNS_5ScopeENS_14SourceLocationES3_NS_3tok9TokenKindEPNS_4DeclERNS_12ObjCDeclSpecENS_9OpaquePtrINS_8QualTypeEEENS_8SelectorEPNS0_11ObjCArgInfoEPNS_15DeclaratorChunk9ParamInfoEjPNS_13AttributeListENS4_15ObjCKeywordKindEb", "clang::Sema::ActOnMethodDeclaration(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::tok::TokenKind, clang::Decl*, clang::ObjCDeclSpec&, clang::OpaquePtr<clang::QualType>, clang::Selector, clang::Sema::ObjCArgInfo*, clang::DeclaratorChunk::ParamInfo*, unsigned int, clang::AttributeList*, clang::tok::ObjCKeywordKind, bool)"),
	mu_demangle_test("_ZN5clang4Sema9ActOnDefsEPNS_5ScopeEPNS_4DeclENS_14SourceLocationEPNS_14IdentifierInfoERN4llvm15SmallVectorImplIS4_EE", "clang::Sema::ActOnDefs(clang::Scope*, clang::Decl*, clang::SourceLocation, clang::IdentifierInfo*, llvm::SmallVectorImpl<clang::Decl*>&)"),
	mu_demangle_test("_ZN5clang4Sema22BuildObjCExceptionDeclEPNS_14TypeSourceInfoENS_8QualTypeEPNS_14IdentifierInfoENS_14SourceLocationEb", "clang::Sema::BuildObjCExceptionDecl(clang::TypeSourceInfo*, clang::QualType, clang::IdentifierInfo*, clang::SourceLocation, bool)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnObjCExceptionDeclEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnObjCExceptionDecl(clang::Scope*, clang::Declarator&)"),
	mu_demangle_test("_ZN5clang4Sema33CollectIvarsToConstructOrDestructEPNS_17ObjCInterfaceDeclERN4llvm15SmallVectorImplIPNS_12ObjCIvarDeclEEE", "clang::Sema::CollectIvarsToConstructOrDestruct(clang::ObjCInterfaceDecl*, llvm::SmallVectorImpl<clang::ObjCIvarDecl*>&)"),
	mu_demangle_test("_ZN5clang22ObjCImplementationDecl19setIvarInitializersERNS_10ASTContextEPPNS_18CXXCtorInitializerEj", "clang::ObjCImplementationDecl::setIvarInitializers(clang::ASTContext&, clang::CXXCtorInitializer**, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema35DiagnoseUseOfUnimplementedSelectorsEv", "clang::Sema::DiagnoseUseOfUnimplementedSelectors()"),
	mu_demangle_test("_Z23isObjCTypeSubstitutableRN5clang10ASTContextEPKNS_21ObjCObjectPointerTypeES4_b", "isObjCTypeSubstitutable(clang::ASTContext&, clang::ObjCObjectPointerType const*, clang::ObjCObjectPointerType const*, bool)"),
	mu_demangle_test("_ZN5clang4Sema27CheckSpecifiedExceptionTypeENS_8QualTypeERKNS_11SourceRangeE", "clang::Sema::CheckSpecifiedExceptionType(clang::QualType, clang::SourceRange const&)"),
	mu_demangle_test("_ZN5clang4Sema25CheckDistantExceptionSpecENS_8QualTypeE", "clang::Sema::CheckDistantExceptionSpec(clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema28CheckEquivalentExceptionSpecEPNS_12FunctionDeclES2_", "clang::Sema::CheckEquivalentExceptionSpec(clang::FunctionDecl*, clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema28CheckEquivalentExceptionSpecERKNS_17PartialDiagnosticES3_PKNS_17FunctionProtoTypeENS_14SourceLocationES6_S7_PbS8_", "clang::Sema::CheckEquivalentExceptionSpec(clang::PartialDiagnostic const&, clang::PartialDiagnostic const&, clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation, bool*, bool*)"),
	mu_demangle_test("_ZN5clang4Sema28CheckEquivalentExceptionSpecEPKNS_17FunctionProtoTypeENS_14SourceLocationES3_S4_", "clang::Sema::CheckEquivalentExceptionSpec(clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema24CheckExceptionSpecSubsetERKNS_17PartialDiagnosticES3_PKNS_17FunctionProtoTypeENS_14SourceLocationES6_S7_", "clang::Sema::CheckExceptionSpecSubset(clang::PartialDiagnostic const&, clang::PartialDiagnostic const&, clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema23CheckParamExceptionSpecERKNS_17PartialDiagnosticEPKNS_17FunctionProtoTypeENS_14SourceLocationES6_S7_", "clang::Sema::CheckParamExceptionSpec(clang::PartialDiagnostic const&, clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema31CheckExceptionSpecCompatibilityEPNS_4ExprENS_8QualTypeE", "clang::Sema::CheckExceptionSpecCompatibility(clang::Expr*, clang::QualType)"),
	mu_demangle_test("_ZN5clang21GetUnderlyingFunctionENS_8QualTypeE", "clang::GetUnderlyingFunction(clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema36CheckOverridingFunctionExceptionSpecEPKNS_13CXXMethodDeclES3_", "clang::Sema::CheckOverridingFunctionExceptionSpec(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"),
	mu_demangle_test("_ZN5clang4Sema17DiagnoseUseOfDeclEPNS_9NamedDeclENS_14SourceLocationEb", "clang::Sema::DiagnoseUseOfDecl(clang::NamedDecl*, clang::SourceLocation, bool)"),
	mu_demangle_test("_ZN5clang4Sema21DiagnoseSentinelCallsEPNS_9NamedDeclENS_14SourceLocationEPPNS_4ExprEj", "clang::Sema::DiagnoseSentinelCalls(clang::NamedDecl*, clang::SourceLocation, clang::Expr**, unsigned int)"),
	mu_demangle_test("_ZNK5clang4Sema12getExprRangeEPNS_4ExprE", "clang::Sema::getExprRange(clang::Expr*) const"),
	mu_demangle_test("_ZN5clang4Sema30DefaultFunctionArrayConversionERPNS_4ExprE", "clang::Sema::DefaultFunctionArrayConversion(clang::Expr*&)"),
	mu_demangle_test("_ZN5clang4Sema23DefaultLvalueConversionERPNS_4ExprE", "clang::Sema::DefaultLvalueConversion(clang::Expr*&)"),
	mu_demangle_test("_ZN5clang4Sema24ConvertPropertyForRValueERPNS_4ExprE", "clang::Sema::ConvertPropertyForRValue(clang::Expr*&)"),
	mu_demangle_test("_ZN5clang4Sema36DefaultFunctionArrayLvalueConversionERPNS_4ExprE", "clang::Sema::DefaultFunctionArrayLvalueConversion(clang::Expr*&)"),
	mu_demangle_test("_ZN5clang4Sema21UsualUnaryConversionsERPNS_4ExprE", "clang::Sema::UsualUnaryConversions(clang::Expr*&)"),
	mu_demangle_test("_ZN5clang4Sema24DefaultArgumentPromotionERPNS_4ExprE", "clang::Sema::DefaultArgumentPromotion(clang::Expr*&)"),
	mu_demangle_test("_ZN5clang4Sema32DefaultVariadicArgumentPromotionERPNS_4ExprENS0_16VariadicCallTypeEPNS_12FunctionDeclE", "clang::Sema::DefaultVariadicArgumentPromotion(clang::Expr*&, clang::Sema::VariadicCallType, clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema19DiagRuntimeBehaviorENS_14SourceLocationERKNS_17PartialDiagnosticE", "clang::Sema::DiagRuntimeBehavior(clang::SourceLocation, clang::PartialDiagnostic const&)"),
	mu_demangle_test("_ZN5clang4Sema26UsualArithmeticConversionsERPNS_4ExprES3_b", "clang::Sema::UsualArithmeticConversions(clang::Expr*&, clang::Expr*&, bool)"),
	mu_demangle_test("_ZN5clang4Sema18ActOnStringLiteralEPKNS_5TokenEj", "clang::Sema::ActOnStringLiteral(clang::Token const*, unsigned int)"),
	mu_demangle_test("_ZN5clang4Sema16BuildDeclRefExprEPNS_9ValueDeclENS_8QualTypeENS_13ExprValueKindENS_14SourceLocationEPKNS_12CXXScopeSpecE", "clang::Sema::BuildDeclRefExpr(clang::ValueDecl*, clang::QualType, clang::ExprValueKind, clang::SourceLocation, clang::CXXScopeSpec const*)"),
	mu_demangle_test("_ZN5clang4Sema16BuildDeclRefExprEPNS_9ValueDeclENS_8QualTypeENS_13ExprValueKindERKNS_19DeclarationNameInfoEPKNS_12CXXScopeSpecE", "clang::Sema::BuildDeclRefExpr(clang::ValueDecl*, clang::QualType, clang::ExprValueKind, clang::DeclarationNameInfo const&, clang::CXXScopeSpec const*)"),
	mu_demangle_test("_ZN5clang4Sema25MarkDeclarationReferencedENS_14SourceLocationEPNS_4DeclE", "clang::Sema::MarkDeclarationReferenced(clang::SourceLocation, clang::Decl*)"),
	mu_demangle_test("_ZN5clang4Sema40BuildAnonymousStructUnionMemberReferenceERKNS_12CXXScopeSpecENS_14SourceLocationEPNS_17IndirectFieldDeclEPNS_4ExprES4_", "clang::Sema::BuildAnonymousStructUnionMemberReference(clang::CXXScopeSpec const&, clang::SourceLocation, clang::IndirectFieldDecl*, clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema24BuildDeclarationNameExprERKNS_12CXXScopeSpecERKNS_19DeclarationNameInfoEPNS_9NamedDeclE", "clang::Sema::BuildDeclarationNameExpr(clang::CXXScopeSpec const&, clang::DeclarationNameInfo const&, clang::NamedDecl*)"),
	mu_demangle_test("_Z23BuildFieldReferenceExprRN5clang4SemaEPNS_4ExprEbRKNS_12CXXScopeSpecEPNS_9FieldDeclENS_14DeclAccessPairERKNS_19DeclarationNameInfoE", "BuildFieldReferenceExpr(clang::Sema&, clang::Expr*, bool, clang::CXXScopeSpec const&, clang::FieldDecl*, clang::DeclAccessPair, clang::DeclarationNameInfo const&)"),
	mu_demangle_test("_ZN5clang4Sema19DiagnoseEmptyLookupEPNS_5ScopeERNS_12CXXScopeSpecERNS_12LookupResultENS0_18CorrectTypoContextE", "clang::Sema::DiagnoseEmptyLookup(clang::Scope*, clang::CXXScopeSpec&, clang::LookupResult&, clang::Sema::CorrectTypoContext)"),
	mu_demangle_test("_ZN5clang4Sema28canSynthesizeProvisionalIvarEPNS_14IdentifierInfoE", "clang::Sema::canSynthesizeProvisionalIvar(clang::IdentifierInfo*)"),
	mu_demangle_test("_ZN5clang4Sema28canSynthesizeProvisionalIvarEPNS_16ObjCPropertyDeclE", "clang::Sema::canSynthesizeProvisionalIvar(clang::ObjCPropertyDecl*)"),
	mu_demangle_test("_ZN5clang4Sema17ActOnIdExpressionEPNS_5ScopeERNS_12CXXScopeSpecERNS_13UnqualifiedIdEbb", "clang::Sema::ActOnIdExpression(clang::Scope*, clang::CXXScopeSpec&, clang::UnqualifiedId&, bool, bool)"),
	mu_demangle_test("_Z22DecomposeUnqualifiedIdRN5clang4SemaERKNS_13UnqualifiedIdERNS_24TemplateArgumentListInfoERNS_19DeclarationNameInfoERPKS5_", "DecomposeUnqualifiedId(clang::Sema&, clang::UnqualifiedId const&, clang::TemplateArgumentListInfo&, clang::DeclarationNameInfo&, clang::TemplateArgumentListInfo const*&)"),
	mu_demangle_test("_ZN5clang4Sema18LookupInObjCMethodERNS_12LookupResultEPNS_5ScopeEPNS_14IdentifierInfoEb", "clang::Sema::LookupInObjCMethod(clang::LookupResult&, clang::Scope*, clang::IdentifierInfo*, bool)"),
	mu_demangle_test("_ZN5clang4Sema26UseArgumentDependentLookupERKNS_12CXXScopeSpecERKNS_12LookupResultEb", "clang::Sema::UseArgumentDependentLookup(clang::CXXScopeSpec const&, clang::LookupResult const&, bool)"),
	mu_demangle_test("_ZN5clang4Sema31BuildPossibleImplicitMemberExprERKNS_12CXXScopeSpecERNS_12LookupResultEPKNS_24TemplateArgumentListInfoE", "clang::Sema::BuildPossibleImplicitMemberExpr(clang::CXXScopeSpec const&, clang::LookupResult&, clang::TemplateArgumentListInfo const*)"),
	mu_demangle_test("_ZN5clang4Sema24BuildDeclarationNameExprERKNS_12CXXScopeSpecERNS_12LookupResultEb", "clang::Sema::BuildDeclarationNameExpr(clang::CXXScopeSpec const&, clang::LookupResult&, bool)"),
	mu_demangle_test("_ZN5clang4Sema23BuildImplicitMemberExprERKNS_12CXXScopeSpecERNS_12LookupResultEPKNS_24TemplateArgumentListInfoEb", "clang::Sema::BuildImplicitMemberExpr(clang::CXXScopeSpec const&, clang::LookupResult&, clang::TemplateArgumentListInfo const*, bool)"),
	mu_demangle_test("_Z25DiagnoseInstanceReferenceRN5clang4SemaERKNS_12CXXScopeSpecEPNS_9NamedDeclERKNS_19DeclarationNameInfoE", "DiagnoseInstanceReference(clang::Sema&, clang::CXXScopeSpec const&, clang::NamedDecl*, clang::DeclarationNameInfo const&)"),
	mu_demangle_test("_ZN5clang4Sema33BuildQualifiedDeclarationNameExprERNS_12CXXScopeSpecERKNS_19DeclarationNameInfoE", "clang::Sema::BuildQualifiedDeclarationNameExpr(clang::CXXScopeSpec&, clang::DeclarationNameInfo const&)"),
	mu_demangle_test("_ZN5clang4Sema29PerformObjectMemberConversionERPNS_4ExprEPNS_19NestedNameSpecifierEPNS_9NamedDeclES7_", "clang::Sema::PerformObjectMemberConversion(clang::Expr*&, clang::NestedNameSpecifier*, clang::NamedDecl*, clang::NamedDecl*)"),
	mu_demangle_test("_ZN5clang4Sema24BuildMemberReferenceExprEPNS_4ExprENS_8QualTypeENS_14SourceLocationEbRKNS_12CXXScopeSpecEPNS_9NamedDeclERNS_12LookupResultEPKNS_24TemplateArgumentListInfoEb", "clang::Sema::BuildMemberReferenceExpr(clang::Expr*, clang::QualType, clang::SourceLocation, bool, clang::CXXScopeSpec const&, clang::NamedDecl*, clang::LookupResult&, clang::TemplateArgumentListInfo const*, bool)"),
	mu_demangle_test("_Z15CheckDeclInExprRN5clang4SemaENS_14SourceLocationEPNS_9NamedDeclE", "CheckDeclInExpr(clang::Sema&, clang::SourceLocation, clang::NamedDecl*)"),
	mu_demangle_test("_Z21BuildBlockDeclRefExprRN5clang4SemaEPNS_9ValueDeclERKNS_19DeclarationNameInfoEb", "BuildBlockDeclRefExpr(clang::Sema&, clang::ValueDecl*, clang::DeclarationNameInfo const&, bool)"),
	mu_demangle_test("_ZN5clang4Sema19ActOnPredefinedExprENS_14SourceLocationENS_3tok9TokenKindE", "clang::Sema::ActOnPredefinedExpr(clang::SourceLocation, clang::tok::TokenKind)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnCharacterConstantERKNS_5TokenE", "clang::Sema::ActOnCharacterConstant(clang::Token const&)"),
	mu_demangle_test("_ZN5clang4Sema20ActOnNumericConstantERKNS_5TokenE", "clang::Sema::ActOnNumericConstant(clang::Token const&)"),
	mu_demangle_test("_ZN5clang4Sema14ActOnParenExprENS_14SourceLocationES1_PNS_4ExprE", "clang::Sema::ActOnParenExpr(clang::SourceLocation, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema25CheckSizeOfAlignOfOperandENS_8QualTypeENS_14SourceLocationENS_11SourceRangeEb", "clang::Sema::CheckSizeOfAlignOfOperand(clang::QualType, clang::SourceLocation, clang::SourceRange, bool)"),
	mu_demangle_test("_ZN5clang4Sema23CreateSizeOfAlignOfExprEPNS_14TypeSourceInfoENS_14SourceLocationEbNS_11SourceRangeE", "clang::Sema::CreateSizeOfAlignOfExpr(clang::TypeSourceInfo*, clang::SourceLocation, bool, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang4Sema23CreateSizeOfAlignOfExprEPNS_4ExprENS_14SourceLocationEbNS_11SourceRangeE", "clang::Sema::CreateSizeOfAlignOfExpr(clang::Expr*, clang::SourceLocation, bool, clang::SourceRange)"),
	mu_demangle_test("_ZN5clang4Sema20CheckPlaceholderExprEPNS_4ExprENS_14SourceLocationE", "clang::Sema::CheckPlaceholderExpr(clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema22ActOnSizeOfAlignOfExprENS_14SourceLocationEbbPvRKNS_11SourceRangeE", "clang::Sema::ActOnSizeOfAlignOfExpr(clang::SourceLocation, bool, bool, void*, clang::SourceRange const&)"),
	mu_demangle_test("_ZN5clang4Sema19ActOnPostfixUnaryOpEPNS_5ScopeENS_14SourceLocationENS_3tok9TokenKindEPNS_4ExprE", "clang::Sema::ActOnPostfixUnaryOp(clang::Scope*, clang::SourceLocation, clang::tok::TokenKind, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema12BuildUnaryOpEPNS_5ScopeENS_14SourceLocationENS_17UnaryOperatorKindEPNS_4ExprE", "clang::Sema::BuildUnaryOp(clang::Scope*, clang::SourceLocation, clang::UnaryOperatorKind, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnArraySubscriptExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationES4_S5_", "clang::Sema::ActOnArraySubscriptExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema36MaybeConvertParenListExprToParenExprEPNS_5ScopeEPNS_4ExprE", "clang::Sema::MaybeConvertParenListExprToParenExpr(clang::Scope*, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema31CreateBuiltinArraySubscriptExprEPNS_4ExprENS_14SourceLocationES2_S3_", "clang::Sema::CreateBuiltinArraySubscriptExpr(clang::Expr*, clang::SourceLocation, clang::Expr*, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema24ActOnDependentMemberExprEPNS_4ExprENS_8QualTypeEbNS_14SourceLocationERKNS_12CXXScopeSpecEPNS_9NamedDeclERKNS_19DeclarationNameInfoEPKNS_24TemplateArgumentListInfoE", "clang::Sema::ActOnDependentMemberExpr(clang::Expr*, clang::QualType, bool, clang::SourceLocation, clang::CXXScopeSpec const&, clang::NamedDecl*, clang::DeclarationNameInfo const&, clang::TemplateArgumentListInfo const*)"),
	mu_demangle_test("_ZN5clang4Sema29CheckQualifiedMemberReferenceEPNS_4ExprENS_8QualTypeERKNS_12CXXScopeSpecERKNS_12LookupResultE", "clang::Sema::CheckQualifiedMemberReference(clang::Expr*, clang::QualType, clang::CXXScopeSpec const&, clang::LookupResult const&)"),
	mu_demangle_test("_Z24IsProvablyNotDerivedFromRN5clang4SemaEPNS_13CXXRecordDeclERKN4llvm11SmallPtrSetIS3_Lj4EEE", "IsProvablyNotDerivedFrom(clang::Sema&, clang::CXXRecordDecl*, llvm::SmallPtrSet<clang::CXXRecordDecl*, 4u> const&)"),
	mu_demangle_test("_ZN5clang4Sema24BuildMemberReferenceExprEPNS_4ExprENS_8QualTypeENS_14SourceLocationEbRNS_12CXXScopeSpecEPNS_9NamedDeclERKNS_19DeclarationNameInfoEPKNS_24TemplateArgumentListInfoE", "clang::Sema::BuildMemberReferenceExpr(clang::Expr*, clang::QualType, clang::SourceLocation, bool, clang::CXXScopeSpec&, clang::NamedDecl*, clang::DeclarationNameInfo const&, clang::TemplateArgumentListInfo const*)"),
	mu_demangle_test("_Z24LookupMemberExprInRecordRN5clang4SemaERNS_12LookupResultENS_11SourceRangeEPKNS_10RecordTypeENS_14SourceLocationERNS_12CXXScopeSpecEb", "LookupMemberExprInRecord(clang::Sema&, clang::LookupResult&, clang::SourceRange, clang::RecordType const*, clang::SourceLocation, clang::CXXScopeSpec&, bool)"),
	mu_demangle_test("_ZN5clang4Sema16LookupMemberExprERNS_12LookupResultERPNS_4ExprERbNS_14SourceLocationERNS_12CXXScopeSpecEPNS_4DeclEb", "clang::Sema::LookupMemberExpr(clang::LookupResult&, clang::Expr*&, bool&, clang::SourceLocation, clang::CXXScopeSpec&, clang::Decl*, bool)"),
	mu_demangle_test("_Z34ShouldTryAgainWithRedefinitionTypeRN5clang4SemaERPNS_4ExprE", "ShouldTryAgainWithRedefinitionType(clang::Sema&, clang::Expr*&)"),
	mu_demangle_test("_Z24FindGetterSetterNameDeclPKN5clang21ObjCObjectPointerTypeEPNS_14IdentifierInfoERKNS_8SelectorERNS_10ASTContextE", "FindGetterSetterNameDecl(clang::ObjCObjectPointerType const*, clang::IdentifierInfo*, clang::Selector const&, clang::ASTContext&)"),
	mu_demangle_test("_ZN5clang4Sema13ActOnCallExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationENS_11ASTMultiPtrIS4_EES5_S4_", "clang::Sema::ActOnCallExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema21ActOnMemberAccessExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationENS_3tok9TokenKindERNS_12CXXScopeSpecERNS_13UnqualifiedIdEPNS_4DeclEb", "clang::Sema::ActOnMemberAccessExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, clang::tok::TokenKind, clang::CXXScopeSpec&, clang::UnqualifiedId&, clang::Decl*, bool)"),
	mu_demangle_test("_ZN5clang4Sema22BuildCXXDefaultArgExprENS_14SourceLocationEPNS_12FunctionDeclEPNS_11ParmVarDeclE", "clang::Sema::BuildCXXDefaultArgExpr(clang::SourceLocation, clang::FunctionDecl*, clang::ParmVarDecl*)"),
	mu_demangle_test("_ZN5clang4Sema32MarkDeclarationsReferencedInExprEPNS_4ExprE", "clang::Sema::MarkDeclarationsReferencedInExpr(clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema23ConvertArgumentsForCallEPNS_8CallExprEPNS_4ExprEPNS_12FunctionDeclEPKNS_17FunctionProtoTypeEPS4_jNS_14SourceLocationE", "clang::Sema::ConvertArgumentsForCall(clang::CallExpr*, clang::Expr*, clang::FunctionDecl*, clang::FunctionProtoType const*, clang::Expr**, unsigned int, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema22GatherArgumentsForCallENS_14SourceLocationEPNS_12FunctionDeclEPKNS_17FunctionProtoTypeEjPPNS_4ExprEjRN4llvm11SmallVectorIS8_Lj8EEENS0_16VariadicCallTypeE", "clang::Sema::GatherArgumentsForCall(clang::SourceLocation, clang::FunctionDecl*, clang::FunctionProtoType const*, unsigned int, clang::Expr**, unsigned int, llvm::SmallVector<clang::Expr*, 8u>&, clang::Sema::VariadicCallType)"),
	mu_demangle_test("_ZN5clang4Sema19CheckCallReturnTypeENS_8QualTypeENS_14SourceLocationEPNS_8CallExprEPNS_12FunctionDeclE", "clang::Sema::CheckCallReturnType(clang::QualType, clang::SourceLocation, clang::CallExpr*, clang::FunctionDecl*)"),
	mu_demangle_test("_ZN5clang4Sema21BuildResolvedCallExprEPNS_4ExprEPNS_9NamedDeclENS_14SourceLocationEPS2_jS5_S2_", "clang::Sema::BuildResolvedCallExpr(clang::Expr*, clang::NamedDecl*, clang::SourceLocation, clang::Expr**, unsigned int, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema23ActOnCUDAExecConfigExprEPNS_5ScopeENS_14SourceLocationENS_11ASTMultiPtrIPNS_4ExprEEES3_", "clang::Sema::ActOnCUDAExecConfigExpr(clang::Scope*, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema20ActOnCompoundLiteralENS_14SourceLocationENS_9OpaquePtrINS_8QualTypeEEES1_PNS_4ExprE", "clang::Sema::ActOnCompoundLiteral(clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema24BuildCompoundLiteralExprENS_14SourceLocationEPNS_14TypeSourceInfoES1_PNS_4ExprE", "clang::Sema::BuildCompoundLiteralExpr(clang::SourceLocation, clang::TypeSourceInfo*, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema13ActOnInitListENS_14SourceLocationENS_11ASTMultiPtrIPNS_4ExprEEES1_", "clang::Sema::ActOnInitList(clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema14CheckCastTypesENS_11SourceRangeENS_8QualTypeERPNS_4ExprERNS_8CastKindERNS_13ExprValueKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEEb", "clang::Sema::CheckCastTypes(clang::SourceRange, clang::QualType, clang::Expr*&, clang::CastKind&, clang::ExprValueKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&, bool)"),
	mu_demangle_test("_ZN5clang4Sema18CheckExtVectorCastENS_11SourceRangeENS_8QualTypeERPNS_4ExprERNS_8CastKindE", "clang::Sema::CheckExtVectorCast(clang::SourceRange, clang::QualType, clang::Expr*&, clang::CastKind&)"),
	mu_demangle_test("_ZN5clang4Sema15CheckVectorCastENS_11SourceRangeENS_8QualTypeES2_RNS_8CastKindE", "clang::Sema::CheckVectorCast(clang::SourceRange, clang::QualType, clang::QualType, clang::CastKind&)"),
	mu_demangle_test("_Z17PrepareScalarCastRN5clang4SemaERPNS_4ExprENS_8QualTypeE", "PrepareScalarCast(clang::Sema&, clang::Expr*&, clang::QualType)"),
	mu_demangle_test("_ZN5clang4Sema13ActOnCastExprEPNS_5ScopeENS_14SourceLocationENS_9OpaquePtrINS_8QualTypeEEES3_PNS_4ExprE", "clang::Sema::ActOnCastExpr(clang::Scope*, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema24ActOnCastOfParenListExprEPNS_5ScopeENS_14SourceLocationES3_PNS_4ExprEPNS_14TypeSourceInfoE", "clang::Sema::ActOnCastOfParenListExpr(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::Expr*, clang::TypeSourceInfo*)"),
	mu_demangle_test("_ZN5clang4Sema19BuildCStyleCastExprENS_14SourceLocationEPNS_14TypeSourceInfoES1_PNS_4ExprE", "clang::Sema::BuildCStyleCastExpr(clang::SourceLocation, clang::TypeSourceInfo*, clang::SourceLocation, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema10ActOnBinOpEPNS_5ScopeENS_14SourceLocationENS_3tok9TokenKindEPNS_4ExprES7_", "clang::Sema::ActOnBinOp(clang::Scope*, clang::SourceLocation, clang::tok::TokenKind, clang::Expr*, clang::Expr*)"),
	mu_demangle_test("_ZN5clang4Sema25ActOnParenOrParenListExprENS_14SourceLocationES1_NS_11ASTMultiPtrIPNS_4ExprEEENS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::ActOnParenOrParenListExpr(clang::SourceLocation, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::OpaquePtr<clang::QualType>)"),
	mu_demangle_test("_ZN5clang4Sema24CheckConditionalOperandsERPNS_4ExprES3_S3_S3_RNS_13ExprValueKindERNS_14ExprObjectKindENS_14SourceLocationE", "clang::Sema::CheckConditionalOperands(clang::Expr*&, clang::Expr*&, clang::Expr*&, clang::Expr*&, clang::ExprValueKind&, clang::ExprObjectKind&, clang::SourceLocation)"),
	mu_demangle_test("_ZN5clang4Sema19CheckVectorOperandsENS_14SourceLocat