## common variables
seg1_tstart=1257741529
seg1_tend=1257743329
seg2_tstart=1257743330
seg2_tend=1257745130
Tsft=1800
fmin=10
Band=1990

## a segment file
segs="./segs"
echo "${seg1_tstart} ${seg1_tend}" > $segs
echo "${seg2_tstart} ${seg2_tend}" >> $segs

for SFT_name_opts in "-O 4 -K DEV -R 1" "-O 0 -X private"; do

for chans in "H1:GDS-CALIB_STRAIN_CLEAN" "H1:GDS-CALIB_STRAIN,H1:GDS-CALIB_STRAIN_CLEAN"; do

## run lalpulsar_MakeSFTDAG to create a fake output
cmdline="./lalpulsar_MakeSFTDAG ${SFT_name_opts} -f test.dag -G TEST -d H1_HOFT_C00 -k 7 -T ${Tsft} -p . -N ${chans} -F ${fmin} -B ${Band} -w 3 -P 0.5 -m 1 -A ligo.sim.o4.cw.explore.test -U albert.einstein -g segs -J /tmp/path/to"
if ! eval "$cmdline"; then
    echo "ERROR: something failed when running '$cmdline'"
    exit 1
fi
dagfile="test.dag"
datafindsub="datafind.sub"
sftsub="MakeSFTs.sub"
for file in $dagfile $datafindsub $sftsub; do
    if ! test -f $file; then
        echo "ERROR: could not find file '$file'"
        exit 1
    fi
done

testdagcontent=$(<$dagfile)
dagfilecontent="JOB datafind_1 datafind.sub
RETRY datafind_1 1
VARS datafind_1 gpsstarttime=\"1257741529\" gpsendtime=\"1257743329\" observatory=\"H\" inputdatatype=\"H1_HOFT_C00\" tagstring=\"TEST_1\"
JOB MakeSFTs_1 MakeSFTs.sub
RETRY MakeSFTs_1 1
VARS MakeSFTs_1 argList=\"${SFT_name_opts} -f 7 -t 1800 -p . -C cache/H-1257741529-1257743329.cache -s 1257741529 -e 1257743329 -N ${chans} -F 10 -B 1990 -w 3 -P 0.5\" tagstring=\"TEST_1\"
PARENT datafind_1 CHILD MakeSFTs_1
JOB datafind_2 datafind.sub
RETRY datafind_2 1
VARS datafind_2 gpsstarttime=\"1257743330\" gpsendtime=\"1257745130\" observatory=\"H\" inputdatatype=\"H1_HOFT_C00\" tagstring=\"TEST_2\"
JOB MakeSFTs_2 MakeSFTs.sub
RETRY MakeSFTs_2 1
VARS MakeSFTs_2 argList=\"${SFT_name_opts} -f 7 -t 1800 -p . -C cache/H-1257743330-1257745130.cache -s 1257743330 -e 1257745130 -N ${chans} -F 10 -B 1990 -w 3 -P 0.5\" tagstring=\"TEST_2\"
PARENT datafind_2 CHILD MakeSFTs_2"
if ! [[ $testdagcontent == $dagfilecontent ]]; then
   echo "ERROR: dagfile content did not match expected content"
   echo "test content:"
   echo $testdagcontent
   echo "Expected content:"
   echo $dagfilecontent
   exit 1
fi

testdatafindcontent=$(<$datafindsub)
datafindfilecontent="universe = vanilla
executable = /usr/bin/gw_data_find
arguments = --observatory \$(observatory) --url-type file --gps-start-time \$(gpsstarttime) --gps-end-time \$(gpsendtime) --lal-cache --gaps --type \$(inputdatatype)
getenv = *DATAFIND*, KRB5*, X509*, BEARER_TOKEN*, SCITOKEN*
request_disk = 5MB
request_memory = 2000MB
accounting_group = ligo.sim.o4.cw.explore.test
accounting_group_user = albert.einstein
log = logs/datafind_test.dag.log
error = logs/datafind_\$(tagstring).err
output = cache/\$(observatory)-\$(gpsstarttime)-\$(gpsendtime).cache
notification = never
queue 1"
if ! [[ $testdatafindcontent == $datafindfilecontent ]]; then
   echo "ERROR: datafind.sub content did not match expected content"
   echo "test content:"
   echo $testdatafindcontent
   echo "Expected content:"
   echo $datafindfilecontent
   exit 1
fi

testsftsubcontent=$(<$sftsub)
sftsubfilecontent="universe = vanilla
executable = /tmp/path/to/lalpulsar_MakeSFTs
arguments = \$(argList)
accounting_group = ligo.sim.o4.cw.explore.test
accounting_group_user = albert.einstein
log = logs/MakeSFTs_test.dag.log
error = logs/MakeSFTs_\$(tagstring).err
output = logs/MakeSFTs_\$(tagstring).out
notification = never
request_memory = 2048MB
request_disk = 1024MB
RequestCpus = 1
queue 1"
if ! [[ $testsftsubcontent == $sftsubfilecontent ]]; then
   echo "ERROR: MakeSFT.sub content did not match expected content"
   echo "test content:"
   echo $testsftsubcontent
   echo "Expected content:"
   echo $sftsubfilecontent
   exit 1
fi

## run lalpulsar_MakeSFTDAG to create a fake output using a frame cache file
cmdline="./lalpulsar_MakeSFTDAG ${SFT_name_opts} -f test.dag -G TEST -d H1_HOFT_C00 -k 7 -T ${Tsft} -p . -N ${chans} -F ${fmin} -B ${Band} -w 3 -P 0.5 -m 1 -A ligo.sim.o4.cw.explore.test -U albert.einstein -g segs -J /tmp/path/to -e /tmp/path/to.cache"
if ! eval "$cmdline"; then
    echo "ERROR: something failed when running '$cmdline'"
    exit 1
fi
dagfile="test.dag"
sftsub="MakeSFTs.sub"
for file in $dagfile $sftsub; do
    if ! test -f $file; then
        echo "ERROR: could not find file '$file'"
        exit 1
    fi
done

testdagcontent=$(<$dagfile)
dagfilecontent="JOB MakeSFTs_1 MakeSFTs.sub
RETRY MakeSFTs_1 1
VARS MakeSFTs_1 argList=\"${SFT_name_opts} -f 7 -t 1800 -p . -C /tmp/path/to.cache -s 1257741529 -e 1257743329 -N ${chans} -F 10 -B 1990 -w 3 -P 0.5\" tagstring=\"TEST_1\"
JOB MakeSFTs_2 MakeSFTs.sub
RETRY MakeSFTs_2 1
VARS MakeSFTs_2 argList=\"${SFT_name_opts} -f 7 -t 1800 -p . -C /tmp/path/to.cache -s 1257743330 -e 1257745130 -N ${chans} -F 10 -B 1990 -w 3 -P 0.5\" tagstring=\"TEST_2\""
if ! [[ $testdagcontent == $dagfilecontent ]]; then
   echo "ERROR: dagfile content did not match expected content"
   echo "test content:"
   echo $testdagcontent
   echo "Expected content:"
   echo $dagfilecontent
   exit 1
fi

rm MakeSFTs.sub datafind.sub test.dag
rmdir logs cache

done

done

rm segs
