/*
*  Copyright (C) 2007 Duncan Brown
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with with program; see the file COPYING. If not, write to the
*  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
*  MA  02110-1301  USA
*/

/*-----------------------------------------------------------------------
 *
 * File Name: LIGOLwXML.h
 *
 * Author: Brown, D. A.
 *
 *-----------------------------------------------------------------------
 */

/**
 * \author Brown, D. A.
 * \file
 * \ingroup lalmetaio_general
 * \brief Provides prototypes for obsolete code.
 *
 * ### Synopsis ###
 *
 * \code
 * #include <lal/LIGOLwXMLlegacy.h>
 * \endcode
 *
 */

#ifndef _LIGOLWXMLLEGACY_H
#define _LIGOLWXMLLEGACY_H

#include <lal/LIGOLwXML.h>
#include <lal/LALAtomicDatatypes.h>
#include <lal/LALDatatypes.h>
#include <lal/LIGOMetadataTables.h>

#if defined(__cplusplus)
extern "C" {
#elif 0
} /* so that editors will match preceding brace */
#endif


typedef enum
tagMetadataTableType
{
  no_table,
  process_table,
  process_params_table,
  search_summary_table,
  sngl_inspiral_table,
  sngl_ringdown_table,
  multi_inspiral_table,
  sim_inspiral_table,
  sim_ringdown_table
}
MetadataTableType;


typedef union
tagMetadataTable
{
  ProcessTable          *processTable;
  ProcessParamsTable    *processParamsTable;
  SearchSummaryTable    *searchSummaryTable;
  SnglBurst             *snglBurst;
  SnglInspiralTable     *snglInspiralTable;
  SnglRingdownTable     *snglRingdownTable;
  MultiInspiralTable    *multiInspiralTable;
  SimInspiralTable      *simInspiralTable;
  SimRingdownTable      *simRingdownTable;
  ExtTriggerTable       *extTriggerTable;
}
MetadataTable;


void
LALOpenLIGOLwXMLFile (
    LALStatus           *status,
    LIGOLwXMLStream     *xml,
    const CHAR          *path
    );

void
LALCloseLIGOLwXMLFile (
    LALStatus           *status,
    LIGOLwXMLStream     *xml
    );

void
LALBeginLIGOLwXMLTable (
    LALStatus           *status,
    LIGOLwXMLStream     *xml,
    MetadataTableType    table
    );

void
LALEndLIGOLwXMLTable (
    LALStatus           *status,
    LIGOLwXMLStream     *xml
    );

void
LALWriteLIGOLwXMLTable (
    LALStatus           *status,
    LIGOLwXMLStream     *xml,
    MetadataTable        tablePtr,
    MetadataTableType    table
    );

#if 0
{ /* so that editors will match succeeding brace */
#elif defined(__cplusplus)
}
#endif

#endif /* _LIGOLIGOLWXMLLEGACY_H */
