/*
 * Copyright (C) 2016 Karl Wette
 * Copyright (C) 2007 Jolien Creighton
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301  USA
 */

#include <stdio.h>
#include <config.h>

#include <lal/LALStdlib.h>

#include "LALAppsVCSInfo.h"

/*
 * Utility for printing version information for LALApps
 */

int main(int argc, char **argv) {

  /* Parse command line */
  int verbose = 0;
  if ( argc == 2 && ( strcmp( argv[1], "-v" ) == 0 || strcmp( argv[1], "-verbose" ) == 0 || strcmp( argv[1], "--verbose" ) == 0 ) ) {
    verbose = 1;
  } else if ( argc > 1 ) {
    fprintf(stderr,
            "Usage: %s [-h|--help] [-v|--verbose]\n\n"
            "Print version information for LALApps and upstream LALSuite components\n\n"
            "Options:\n"
            "  --help       display this messgage and exit\n"
            "  --verbose    display verbose version information\n",
            argv[0]
      );
    if ( strcmp( argv[1], "-h" ) == 0 || strcmp( argv[1], "-help" ) == 0 || strcmp( argv[1], "--help" ) == 0 ) {
      return EXIT_SUCCESS;
    } else {
      return EXIT_FAILURE;
    }
  }

  /* Print version information */
  char *str = XLALVCSInfoString( lalAppsVCSInfoList, verbose, NULL );
  XLAL_CHECK_MAIN( str != NULL, XLAL_EFUNC );
  fprintf( stdout, "%s", str );

  /* Cleanup */
  XLALFree( str );
  LALCheckMemoryLeaks();

  return EXIT_SUCCESS;

}
